/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.landawn.abacus.annotation.JsonXmlCreator;
import com.landawn.abacus.annotation.JsonXmlValue;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.ObjectType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.TypeAttrParser;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

abstract class SingleValueType<T>
extends AbstractType<T> {
    final Class<T> typeClass;
    final boolean isGenericType;
    final Type<?>[] parameterTypes;
    final Field jsonValueField;
    final Method jsonValueMethod;
    final Method jsonCreatorMethod;
    final Type<Object> jsonValueType;
    final boolean isSerializable;

    protected SingleValueType(Class<T> cls) {
        this(ClassUtil.getCanonicalClassName(cls), cls);
    }

    protected SingleValueType(String typeName, Class<T> cls) {
        super(typeName);
        this.typeClass = cls;
        this.isGenericType = typeName.indexOf(60) > 0 && typeName.indexOf(62) > 0;
        TypeAttrParser attrs = TypeAttrParser.parse(typeName);
        this.parameterTypes = new Type[attrs.getTypeParameters().length];
        int len = this.parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            this.parameterTypes[i] = TypeFactory.getType(attrs.getTypeParameters()[i]);
        }
        AccessibleObject localJsonValueField = null;
        Method localJsonValueMethod = null;
        Method localJsonCreatorMethod = null;
        Class<?> localJsonValueType = null;
        Method[] methods = cls.getDeclaredMethods();
        for (Method method : methods) {
            if (method.isAnnotationPresent(JsonXmlCreator.class)) {
                localJsonCreatorMethod = method;
            } else if (method.isAnnotationPresent(JsonXmlValue.class)) {
                localJsonValueMethod = method;
            } else {
                try {
                    if (method.isAnnotationPresent(JsonCreator.class)) {
                        localJsonCreatorMethod = method;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    if (method.isAnnotationPresent(JsonValue.class)) {
                        localJsonValueMethod = method;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (localJsonCreatorMethod != null && localJsonValueMethod != null) break;
        }
        if (localJsonValueMethod == null) {
            for (AccessibleObject accessibleObject : cls.getDeclaredFields()) {
                if (accessibleObject.isAnnotationPresent(JsonXmlValue.class)) {
                    localJsonValueField = accessibleObject;
                } else {
                    try {
                        if (accessibleObject.isAnnotationPresent(JsonValue.class)) {
                            localJsonValueField = accessibleObject;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (localJsonValueField != null) break;
            }
        }
        if ((localJsonValueField != null || localJsonValueMethod != null) && localJsonCreatorMethod == null || localJsonValueField == null && localJsonValueMethod == null && localJsonCreatorMethod != null) {
            throw new RuntimeException("Json annotation 'JsonValue' and 'JsonCreator' are not added in pair in class: " + cls);
        }
        if (localJsonCreatorMethod != null) {
            Class<?> clazz = localJsonValueType = localJsonValueMethod == null ? localJsonValueField.getType() : localJsonValueMethod.getReturnType();
            if (!cls.isAssignableFrom(localJsonCreatorMethod.getReturnType())) {
                throw new RuntimeException("The result type of 'JsonCreator' method: " + localJsonCreatorMethod + " is not assigned to target class: " + cls);
            }
            if (!Modifier.isStatic(localJsonCreatorMethod.getModifiers())) {
                throw new RuntimeException("The 'JsonCreator' method: " + localJsonCreatorMethod + " is not static in class: " + cls);
            }
            if (N.len(localJsonCreatorMethod.getParameterTypes()) != 1 && localJsonCreatorMethod.getParameterTypes()[0].isAssignableFrom(localJsonValueType)) {
                throw new RuntimeException("The parameter type of 'JsonCreator' method: " + localJsonCreatorMethod + " is not assigned from the return type of 'JsonValue' in class " + cls);
            }
        }
        this.jsonValueField = localJsonValueField;
        this.jsonValueMethod = localJsonValueMethod;
        this.jsonCreatorMethod = localJsonCreatorMethod;
        if (this.jsonValueField != null) {
            this.jsonValueField.setAccessible(true);
        }
        if (this.jsonValueMethod != null) {
            this.jsonValueMethod.setAccessible(true);
        }
        if (this.jsonCreatorMethod != null) {
            this.jsonCreatorMethod.setAccessible(true);
        }
        this.jsonValueType = localJsonValueType != null ? TypeFactory.getType(localJsonValueType) : null;
        this.isSerializable = this.jsonValueType == null ? false : this.jsonValueType.isSerializable();
    }

    @Override
    public Class<T> clazz() {
        return this.typeClass;
    }

    @Override
    public boolean isGenericType() {
        return this.isGenericType;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isSerializable() {
        return this.isSerializable;
    }

    @Override
    public String stringOf(T x) {
        if (x == null) {
            return null;
        }
        if (this.jsonValueType == null) {
            Type<T> realType = TypeFactory.getType(x.getClass());
            return realType instanceof ObjectType ? x.toString() : realType.stringOf(x);
        }
        try {
            if (this.jsonValueField != null) {
                return this.jsonValueType.stringOf(this.jsonValueField.get(x));
            }
            return this.jsonValueType.stringOf(this.jsonValueMethod.invoke(x, new Object[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T valueOf(String str) {
        if (this.jsonValueType == null) {
            return (T)str;
        }
        try {
            return (T)this.jsonCreatorMethod.invoke(null, this.jsonValueType.valueOf(str));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, T x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else if (this.jsonValueType == null) {
            char ch;
            char c = ch = config == null ? (char)'\u0000' : config.getStringQuotation();
            if (ch == '\u0000') {
                writer.writeCharacter(this.stringOf(x));
            } else {
                writer.write(ch);
                writer.writeCharacter(this.stringOf(x));
                writer.write(ch);
            }
        } else {
            try {
                if (this.jsonValueField != null) {
                    this.jsonValueType.writeCharacter(writer, this.jsonValueField.get(x), config);
                } else {
                    this.jsonValueType.writeCharacter(writer, this.jsonValueMethod.invoke(x, new Object[0]), config);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

