/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Triple;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class TripleType<L, M, R>
extends AbstractType<Triple<L, M, R>> {
    private final String declaringName;
    private final Class<Triple<L, M, R>> typeClass = Triple.class;
    private final Type<L> leftType;
    private final Type<M> middleType;
    private final Type<R> rightType;
    private final Type<?>[] parameterTypes;

    TripleType(String leftTypeName, String middleTypeName, String rightTypeName) {
        super(TripleType.getTypeName(leftTypeName, middleTypeName, rightTypeName, false));
        this.declaringName = TripleType.getTypeName(leftTypeName, middleTypeName, rightTypeName, true);
        this.leftType = TypeFactory.getType(leftTypeName);
        this.middleType = TypeFactory.getType(middleTypeName);
        this.rightType = TypeFactory.getType(rightTypeName);
        this.parameterTypes = new Type[]{this.leftType, this.middleType, this.rightType};
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<Triple<L, M, R>> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public String stringOf(Triple<L, M, R> x) {
        return x == null ? null : Utils.jsonParser.serialize(N.asArray(x.left, x.middle, x.right), Utils.jsc);
    }

    @Override
    public Triple<L, M, R> valueOf(String str) {
        Object middle;
        Object left;
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        Object[] a = Utils.jsonParser.deserialize(Object[].class, str, Utils.jdc);
        Object object = a[0] == null ? null : (left = this.leftType.clazz().isAssignableFrom(a[0].getClass()) ? a[0] : N.convert(a[0], this.leftType));
        Object object2 = a[1] == null ? null : (middle = this.middleType.clazz().isAssignableFrom(a[1].getClass()) ? a[1] : N.convert(a[1], this.middleType));
        Object right = a[2] == null ? null : (this.rightType.clazz().isAssignableFrom(a[2].getClass()) ? a[2] : N.convert(a[2], this.rightType));
        return Triple.of(left, middle, right);
    }

    @Override
    public void write(Writer writer, Triple<L, M, R> x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(91);
                this.leftType.write(bw, x.left);
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.middleType.write(bw, x.middle);
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.rightType.write(bw, x.right);
                bw.write(93);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Triple<L, M, R> x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            try {
                writer.write('[');
                this.leftType.writeCharacter(writer, x.left, config);
                writer.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.middleType.writeCharacter(writer, x.middle, config);
                writer.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.rightType.writeCharacter(writer, x.right, config);
                writer.write(']');
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected static String getTypeName(String leftTypeName, String middleTypeName, String rightTypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(Triple.class) + "<" + TypeFactory.getType(leftTypeName).declaringName() + ", " + TypeFactory.getType(middleTypeName).declaringName() + ", " + TypeFactory.getType(rightTypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(Triple.class) + "<" + TypeFactory.getType(leftTypeName).name() + ", " + TypeFactory.getType(middleTypeName).name() + ", " + TypeFactory.getType(rightTypeName).name() + ">";
    }
}

