/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.type.TypeFactory;
import com.landawn.abacus.type.Utils;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Tuple;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class Tuple2Type<T1, T2>
extends AbstractType<Tuple.Tuple2<T1, T2>> {
    private final String declaringName;
    private final Class<Tuple.Tuple2<T1, T2>> typeClass = Tuple.Tuple2.class;
    private final Type<T1> type1;
    private final Type<T2> type2;
    private final Type<?>[] parameterTypes;

    Tuple2Type(String t1TypeName, String t2TypeName) {
        super(Tuple2Type.getTypeName(t1TypeName, t2TypeName, false));
        this.declaringName = Tuple2Type.getTypeName(t1TypeName, t2TypeName, true);
        this.type1 = TypeFactory.getType(t1TypeName);
        this.type2 = TypeFactory.getType(t2TypeName);
        this.parameterTypes = new Type[]{this.type1, this.type2};
    }

    @Override
    public String declaringName() {
        return this.declaringName;
    }

    @Override
    public Class<Tuple.Tuple2<T1, T2>> clazz() {
        return this.typeClass;
    }

    @Override
    public Type<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public boolean isGenericType() {
        return true;
    }

    @Override
    public String stringOf(Tuple.Tuple2<T1, T2> x) {
        return x == null ? null : Utils.jsonParser.serialize(N.asArray(x._1, x._2), Utils.jsc);
    }

    @Override
    public Tuple.Tuple2<T1, T2> valueOf(String str) {
        Object t1;
        if (N.isNullOrEmpty(str)) {
            return null;
        }
        Object[] a = Utils.jsonParser.deserialize(Object[].class, str, Utils.jdc);
        Object object = a[0] == null ? null : (t1 = this.type1.clazz().isAssignableFrom(a[0].getClass()) ? a[0] : N.convert(a[0], this.type1));
        Object t2 = a[1] == null ? null : (this.type2.clazz().isAssignableFrom(a[1].getClass()) ? a[1] : N.convert(a[1], this.type2));
        return Tuple.of(t1, t2);
    }

    @Override
    public void write(Writer writer, Tuple.Tuple2<T1, T2> x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isBufferedWriter = writer instanceof com.landawn.abacus.util.BufferedWriter || writer instanceof BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            try {
                bw.write(91);
                this.type1.write(bw, x._1);
                bw.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.type2.write(bw, x._2);
                bw.write(93);
                if (!isBufferedWriter) {
                    bw.flush();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((com.landawn.abacus.util.BufferedWriter)bw);
                }
            }
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, Tuple.Tuple2<T1, T2> x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            try {
                writer.write('[');
                this.type1.writeCharacter(writer, x._1, config);
                writer.write(ELEMENT_SEPARATOR_CHAR_ARRAY);
                this.type2.writeCharacter(writer, x._2, config);
                writer.write(']');
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    protected static String getTypeName(String t1TypeName, String t2TypeName, boolean isDeclaringName) {
        if (isDeclaringName) {
            return ClassUtil.getSimpleClassName(Tuple.Tuple2.class) + "<" + TypeFactory.getType(t1TypeName).declaringName() + ", " + TypeFactory.getType(t2TypeName).declaringName() + ">";
        }
        return ClassUtil.getCanonicalClassName(Tuple.Tuple2.class) + "<" + TypeFactory.getType(t1TypeName).name() + ", " + TypeFactory.getType(t2TypeName).name() + ">";
    }
}

