/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.type;

import com.landawn.abacus.parser.SerializationConfig;
import com.landawn.abacus.type.AbstractType;
import com.landawn.abacus.util.CharacterWriter;
import com.landawn.abacus.util.DateTimeFormat;
import com.landawn.abacus.util.DateUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.Writer;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarType
extends AbstractType<XMLGregorianCalendar> {
    public static final String XML_GREGORIAN_CALENDAR = XMLGregorianCalendar.class.getSimpleName();

    XMLGregorianCalendarType() {
        super(XML_GREGORIAN_CALENDAR);
    }

    @Override
    public Class<XMLGregorianCalendar> clazz() {
        return XMLGregorianCalendar.class;
    }

    @Override
    public XMLGregorianCalendar valueOf(String str) {
        return N.isNullOrEmpty(str) ? null : (N.equals(str, "sysTime") ? DateUtil.currentXMLGregorianCalendar() : DateUtil.parseXMLGregorianCalendar(str));
    }

    @Override
    public XMLGregorianCalendar valueOf(char[] cbuf, int offset, int len) {
        if (cbuf == null || len == 0) {
            return null;
        }
        if (cbuf[offset + 4] != '-') {
            try {
                return DateUtil.createXMLGregorianCalendar(XMLGregorianCalendarType.parseLong(cbuf, offset, len));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.valueOf(String.valueOf(cbuf, offset, len));
    }

    @Override
    public String stringOf(XMLGregorianCalendar x) {
        return x == null ? null : DateUtil.format(x);
    }

    @Override
    public void write(Writer writer, XMLGregorianCalendar x) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            DateUtil.format(writer, x, null, null);
        }
    }

    @Override
    public void writeCharacter(CharacterWriter writer, XMLGregorianCalendar x, SerializationConfig<?> config) throws IOException {
        if (x == null) {
            writer.write(NULL_CHAR_ARRAY);
        } else {
            boolean isQuote;
            boolean bl = isQuote = config != null && config.getStringQuotation() != '\u0000' && config.getDateTimeFormat() != DateTimeFormat.LONG;
            if (isQuote) {
                writer.write(config.getStringQuotation());
            }
            if (config == null || config.getDateTimeFormat() == null) {
                DateUtil.format((Writer)writer, x, null, null);
            } else {
                switch (config.getDateTimeFormat()) {
                    case LONG: {
                        writer.write(String.valueOf(x.toGregorianCalendar().getTimeInMillis()));
                        break;
                    }
                    case ISO_8601_DATETIME: {
                        DateUtil.format((Writer)writer, x, "yyyy-MM-dd'T'HH:mm:ss'Z'", null);
                        break;
                    }
                    case ISO_8601_TIMESTAMP: {
                        DateUtil.format((Writer)writer, x, "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", null);
                        break;
                    }
                    default: {
                        throw new RuntimeException("unsupported operation");
                    }
                }
            }
            if (isQuote) {
                writer.write(config.getStringQuotation());
            }
        }
    }
}

