/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.NullSafe;
import com.landawn.abacus.util.N;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public final class Array {
    static final int MIN_ARRAY_SORT_GRAN = 8192;
    static final int BINARYSEARCH_THRESHOLD = 64;

    private Array() {
    }

    public static <T> T newInstance(Class<?> componentType, int length) throws NegativeArraySizeException {
        if (length == 0) {
            Object result = N.CLASS_EMPTY_ARRAY.get(componentType);
            if (result == null) {
                result = java.lang.reflect.Array.newInstance(componentType, length);
                N.CLASS_EMPTY_ARRAY.put(componentType, result);
            }
            return (T)result;
        }
        return (T)java.lang.reflect.Array.newInstance(componentType, length);
    }

    @SafeVarargs
    public static <T> T newInstance(Class<?> componentType, int ... dimensions) throws IllegalArgumentException, NegativeArraySizeException {
        return (T)java.lang.reflect.Array.newInstance(componentType, dimensions);
    }

    public static int getLength(Object array) throws IllegalArgumentException {
        return java.lang.reflect.Array.getLength(array);
    }

    public static <T> T get(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return (T)java.lang.reflect.Array.get(array, index);
    }

    public static boolean getBoolean(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getBoolean(array, index);
    }

    public static byte getByte(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getByte(array, index);
    }

    public static char getChar(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getChar(array, index);
    }

    public static short getShort(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getShort(array, index);
    }

    public static int getInt(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getInt(array, index);
    }

    public static long getLong(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getLong(array, index);
    }

    public static float getFloat(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getFloat(array, index);
    }

    public static double getDouble(Object array, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        return java.lang.reflect.Array.getDouble(array, index);
    }

    public static void set(Object array, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.set(array, index, value);
    }

    public static void setBoolean(Object array, int index, boolean z) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setBoolean(array, index, z);
    }

    public static void setByte(Object array, int index, byte b) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setByte(array, index, b);
    }

    public static void setChar(Object array, int index, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setChar(array, index, c);
    }

    public static void setShort(Object array, int index, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setShort(array, index, s);
    }

    public static void setInt(Object array, int index, int i) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setInt(array, index, i);
    }

    public static void setLong(Object array, int index, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setLong(array, index, l);
    }

    public static void setFloat(Object array, int index, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setFloat(array, index, f);
    }

    public static void setDouble(Object array, int index, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        java.lang.reflect.Array.setDouble(array, index, d);
    }

    @SafeVarargs
    @NullSafe
    public static <T> List<T> asList(T ... a) {
        return N.isNullOrEmpty(a) ? N.emptyList() : Arrays.asList(a);
    }

    @SafeVarargs
    public static boolean[] of(boolean ... a) {
        return a;
    }

    @SafeVarargs
    public static char[] of(char ... a) {
        return a;
    }

    @SafeVarargs
    public static byte[] of(byte ... a) {
        return a;
    }

    @SafeVarargs
    public static short[] of(short ... a) {
        return a;
    }

    @SafeVarargs
    public static int[] of(int ... a) {
        return a;
    }

    @SafeVarargs
    public static long[] of(long ... a) {
        return a;
    }

    @SafeVarargs
    public static float[] of(float ... a) {
        return a;
    }

    @SafeVarargs
    public static double[] of(double ... a) {
        return a;
    }

    @SafeVarargs
    public static String[] of(String ... a) {
        return a;
    }

    @SafeVarargs
    public static <T extends Date> T[] of(T ... a) {
        return a;
    }

    @SafeVarargs
    public static <T extends Calendar> T[] of(T ... a) {
        return a;
    }

    @Deprecated
    @SafeVarargs
    public static <T> T[] oF(T ... a) {
        return a;
    }

    public static char[] range(char startInclusive, char endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_CHAR_ARRAY;
        }
        char[] a = new char[endExclusive * '\u0001' - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            char c = startInclusive;
            startInclusive = (char)(startInclusive + '\u0001');
            a[i] = c;
        }
        return a;
    }

    public static byte[] range(byte startInclusive, byte endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_BYTE_ARRAY;
        }
        byte[] a = new byte[endExclusive * 1 - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            byte by = startInclusive;
            startInclusive = (byte)(startInclusive + 1);
            a[i] = by;
        }
        return a;
    }

    public static short[] range(short startInclusive, short endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_SHORT_ARRAY;
        }
        short[] a = new short[endExclusive * 1 - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            short s = startInclusive;
            startInclusive = (short)(startInclusive + 1);
            a[i] = s;
        }
        return a;
    }

    public static int[] range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_INT_ARRAY;
        }
        if ((long)endExclusive * 1L - (long)startInclusive > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[endExclusive - startInclusive];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive++;
        }
        return a;
    }

    public static long[] range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return N.EMPTY_LONG_ARRAY;
        }
        if (endExclusive - startInclusive < 0L || endExclusive - startInclusive > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)(endExclusive - startInclusive)];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            ++startInclusive;
        }
        return a;
    }

    public static char[] range(char startInclusive, char endExclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        int len = (endExclusive * '\u0001' - startInclusive) / by + ((endExclusive * '\u0001' - startInclusive) % by == 0 ? 0 : 1);
        char[] a = new char[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (char)(startInclusive + by);
        }
        return a;
    }

    public static byte[] range(byte startInclusive, byte endExclusive, byte by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        int len = (endExclusive * 1 - startInclusive) / by + ((endExclusive * 1 - startInclusive) % by == 0 ? 0 : 1);
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (byte)(startInclusive + by);
        }
        return a;
    }

    public static short[] range(short startInclusive, short endExclusive, short by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_SHORT_ARRAY;
        }
        int len = (endExclusive * 1 - startInclusive) / by + ((endExclusive * 1 - startInclusive) % by == 0 ? 0 : 1);
        short[] a = new short[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (short)(startInclusive + by);
        }
        return a;
    }

    public static int[] range(int startInclusive, int endExclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0) {
            return N.EMPTY_INT_ARRAY;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)by + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)by == 0L ? 0 : 1);
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static long[] range(long startInclusive, long endExclusive, long by) {
        if (by == 0L) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endExclusive == startInclusive || endExclusive > startInclusive != by > 0L) {
            return N.EMPTY_LONG_ARRAY;
        }
        long len = 0L;
        if (by > 0L && endExclusive - startInclusive < 0L || by < 0L && startInclusive - endExclusive < 0L) {
            BigInteger m = BigInteger.valueOf(endExclusive).subtract(BigInteger.valueOf(startInclusive)).divide(BigInteger.valueOf(by));
            if (m.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new IllegalArgumentException("overflow");
            }
            len = m.multiply(BigInteger.valueOf(by)).add(BigInteger.valueOf(startInclusive)).equals(BigInteger.valueOf(endExclusive)) ? m.longValue() : m.longValue() + 1L;
        } else {
            len = (endExclusive - startInclusive) / by + (long)((endExclusive - startInclusive) % by == 0L ? 0 : 1);
        }
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static char[] rangeClosed(char startInclusive, char endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_CHAR_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        char[] a = new char[endInclusive * '\u0001' - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            char c = startInclusive;
            startInclusive = (char)(startInclusive + '\u0001');
            a[i] = c;
        }
        return a;
    }

    public static byte[] rangeClosed(byte startInclusive, byte endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_BYTE_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        byte[] a = new byte[endInclusive * 1 - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            byte by = startInclusive;
            startInclusive = (byte)(startInclusive + 1);
            a[i] = by;
        }
        return a;
    }

    public static short[] rangeClosed(short startInclusive, short endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_SHORT_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        short[] a = new short[endInclusive * 1 - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            short s = startInclusive;
            startInclusive = (short)(startInclusive + 1);
            a[i] = s;
        }
        return a;
    }

    public static int[] rangeClosed(int startInclusive, int endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_INT_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        if ((long)endInclusive * 1L - (long)startInclusive + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[endInclusive - startInclusive + 1];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive++;
        }
        return a;
    }

    public static long[] rangeClosed(long startInclusive, long endInclusive) {
        if (startInclusive > endInclusive) {
            return N.EMPTY_LONG_ARRAY;
        }
        if (startInclusive == endInclusive) {
            return Array.of(startInclusive);
        }
        if (endInclusive - startInclusive + 1L <= 0L || endInclusive - startInclusive + 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)(endInclusive - startInclusive + 1L)];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            ++startInclusive;
        }
        return a;
    }

    public static char[] rangeClosed(char startInclusive, char endInclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new char[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        int len = (endInclusive * '\u0001' - startInclusive) / by + 1;
        char[] a = new char[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (char)(startInclusive + by);
        }
        return a;
    }

    public static byte[] rangeClosed(byte startInclusive, byte endInclusive, byte by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new byte[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        int len = (endInclusive * 1 - startInclusive) / by + 1;
        byte[] a = new byte[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (byte)(startInclusive + by);
        }
        return a;
    }

    public static short[] rangeClosed(short startInclusive, short endInclusive, short by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new short[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_SHORT_ARRAY;
        }
        int len = (endInclusive * 1 - startInclusive) / by + 1;
        short[] a = new short[len];
        for (int i = 0; i < len; ++i) {
            a[i] = startInclusive;
            startInclusive = (short)(startInclusive + by);
        }
        return a;
    }

    public static int[] rangeClosed(int startInclusive, int endInclusive, int by) {
        if (by == 0) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new int[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0) {
            return N.EMPTY_INT_ARRAY;
        }
        long len = ((long)endInclusive * 1L - (long)startInclusive) / (long)by + 1L;
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        int[] a = new int[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static long[] rangeClosed(long startInclusive, long endInclusive, long by) {
        if (by == 0L) {
            throw new IllegalArgumentException("The input parameter 'by' can't be zero");
        }
        if (endInclusive == startInclusive) {
            return new long[]{startInclusive};
        }
        if (endInclusive > startInclusive != by > 0L) {
            return N.EMPTY_LONG_ARRAY;
        }
        long len = 0L;
        if (by > 0L && endInclusive - startInclusive < 0L || by < 0L && startInclusive - endInclusive < 0L || (endInclusive - startInclusive) / by + 1L <= 0L) {
            BigInteger m = BigInteger.valueOf(endInclusive).subtract(BigInteger.valueOf(startInclusive)).divide(BigInteger.valueOf(by));
            if (m.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                throw new IllegalArgumentException("overflow");
            }
            len = m.longValue() + 1L;
        } else {
            len = (endInclusive - startInclusive) / by + 1L;
        }
        if (len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("overflow");
        }
        long[] a = new long[(int)len];
        int i = 0;
        while ((long)i < len) {
            a[i] = startInclusive;
            ++i;
            startInclusive += by;
        }
        return a;
    }

    public static boolean[] repeat(boolean element, int n) {
        boolean[] a = new boolean[n];
        N.fill(a, element);
        return a;
    }

    public static char[] repeat(char element, int n) {
        char[] a = new char[n];
        N.fill(a, element);
        return a;
    }

    public static byte[] repeat(byte element, int n) {
        byte[] a = new byte[n];
        N.fill(a, element);
        return a;
    }

    public static short[] repeat(short element, int n) {
        short[] a = new short[n];
        N.fill(a, element);
        return a;
    }

    public static int[] repeat(int element, int n) {
        int[] a = new int[n];
        N.fill(a, element);
        return a;
    }

    public static long[] repeat(long element, int n) {
        long[] a = new long[n];
        N.fill(a, element);
        return a;
    }

    public static float[] repeat(float element, int n) {
        float[] a = new float[n];
        N.fill(a, element);
        return a;
    }

    public static double[] repeat(double element, int n) {
        double[] a = new double[n];
        N.fill(a, element);
        return a;
    }

    public static String[] repeat(String element, int n) {
        Object[] a = new String[n];
        N.fill(a, element);
        return a;
    }

    @Deprecated
    public static <T> T[] repeat(T element, int n) throws NullPointerException {
        Object[] a = (Object[])N.newArray(element.getClass(), n);
        N.fill(a, element);
        return a;
    }

    @Deprecated
    public static <T> T[] repeat(Class<T> elementClass, T element, int n) throws NullPointerException {
        Object[] a = (Object[])N.newArray(elementClass, n);
        N.fill(a, element);
        return a;
    }

    public static <T> T[] repeat(T element, int n, Class<T> elementClass) throws NullPointerException {
        Object[] a = (Object[])N.newArray(elementClass, n);
        N.fill(a, element);
        return a;
    }

    public static <T> T[] repeatNonNull(T element, int n) throws IllegalArgumentException {
        N.checkArgNotNull(element, "element");
        Object[] a = (Object[])N.newArray(element.getClass(), n);
        N.fill(a, element);
        return a;
    }

    public static boolean[][] concat(boolean[][] a, boolean[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new boolean[][]{} : (boolean[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        boolean[][] result = new boolean[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static boolean[][][] concat(boolean[][][] a, boolean[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new boolean[][][]{} : (boolean[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        boolean[][][] result = new boolean[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (boolean[][])null, i < bLen ? b[i] : (boolean[][])null);
        }
        return result;
    }

    public static char[][] concat(char[][] a, char[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new char[][]{} : (char[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        char[][] result = new char[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static char[][][] concat(char[][][] a, char[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new char[][][]{} : (char[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        char[][][] result = new char[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (char[][])null, i < bLen ? b[i] : (char[][])null);
        }
        return result;
    }

    public static byte[][] concat(byte[][] a, byte[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new byte[][]{} : (byte[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        byte[][] result = new byte[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static byte[][][] concat(byte[][][] a, byte[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new byte[][][]{} : (byte[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        byte[][][] result = new byte[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (byte[][])null, i < bLen ? b[i] : (byte[][])null);
        }
        return result;
    }

    public static short[][] concat(short[][] a, short[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new short[][]{} : (short[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        short[][] result = new short[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static short[][][] concat(short[][][] a, short[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new short[][][]{} : (short[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        short[][][] result = new short[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (short[][])null, i < bLen ? b[i] : (short[][])null);
        }
        return result;
    }

    public static int[][] concat(int[][] a, int[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new int[][]{} : (int[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        int[][] result = new int[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static int[][][] concat(int[][][] a, int[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new int[][][]{} : (int[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        int[][][] result = new int[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (int[][])null, i < bLen ? b[i] : (int[][])null);
        }
        return result;
    }

    public static long[][] concat(long[][] a, long[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new long[][]{} : (long[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        long[][] result = new long[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static long[][][] concat(long[][][] a, long[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new long[][][]{} : (long[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        long[][][] result = new long[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (long[][])null, i < bLen ? b[i] : (long[][])null);
        }
        return result;
    }

    public static float[][] concat(float[][] a, float[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new float[][]{} : (float[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        float[][] result = new float[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static float[][][] concat(float[][][] a, float[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new float[][][]{} : (float[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        float[][][] result = new float[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (float[][])null, i < bLen ? b[i] : (float[][])null);
        }
        return result;
    }

    public static double[][] concat(double[][] a, double[][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new double[][]{} : (double[][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        double[][] result = new double[maxLen][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static double[][][] concat(double[][][] a, double[][][] b) {
        if (N.isNullOrEmpty((Object[])a)) {
            return N.isNullOrEmpty((Object[])b) ? new double[][][]{} : (double[][][])N.clone(b);
        }
        if (N.isNullOrEmpty((Object[])b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len((Object[])a), N.len((Object[])b));
        double[][][] result = new double[maxLen][][];
        int aLen = N.len((Object[])a);
        int bLen = N.len((Object[])b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concat(i < aLen ? a[i] : (double[][])null, i < bLen ? b[i] : (double[][])null);
        }
        return result;
    }

    public static <T> T[][] concatt(T[][] a, T[][] b) {
        if (N.isNullOrEmpty(a)) {
            return N.clone(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len(a), N.len(b));
        Object[][] result = (Object[][])Array.newInstance(a.getClass().getComponentType(), maxLen);
        int aLen = N.len(a);
        int bLen = N.len(b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = N.concat(i < aLen ? a[i] : null, i < bLen ? b[i] : null);
        }
        return result;
    }

    public static <T> T[][][] concatt(T[][][] a, T[][][] b) {
        if (N.isNullOrEmpty(a)) {
            return N.clone(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.clone(a);
        }
        int maxLen = N.max(N.len(a), N.len(b));
        Object[][][] result = (Object[][][])Array.newInstance(a.getClass().getComponentType(), maxLen);
        int aLen = N.len(a);
        int bLen = N.len(b);
        for (int i = 0; i < maxLen; ++i) {
            result[i] = Array.concatt(i < aLen ? a[i] : (Object[][])null, i < bLen ? b[i] : (Object[][])null);
        }
        return result;
    }

    @SafeVarargs
    public static Boolean[] box(boolean ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Boolean[] box(boolean[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Character[] box(char ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Character[] box(char[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = Character.valueOf(a[j]);
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Byte[] box(byte ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Byte[] box(byte[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Short[] box(short ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Short[] box(short[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Integer[] box(int ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Integer[] box(int[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Long[] box(long ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Long[] box(long[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Float[] box(float ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Float[] box(float[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = Float.valueOf(a[j]);
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static Double[] box(double ... a) {
        if (a == null) {
            return null;
        }
        return Array.box(a, 0, a.length);
    }

    public static Double[] box(double[] a, int fromIndex, int toIndex) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j];
            ++i;
        }
        return result;
    }

    public static Boolean[][] box(boolean[][] a) {
        if (a == null) {
            return null;
        }
        Boolean[][] result = new Boolean[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Character[][] box(char[][] a) {
        if (a == null) {
            return null;
        }
        Character[][] result = new Character[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Byte[][] box(byte[][] a) {
        if (a == null) {
            return null;
        }
        Byte[][] result = new Byte[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Short[][] box(short[][] a) {
        if (a == null) {
            return null;
        }
        Short[][] result = new Short[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Integer[][] box(int[][] a) {
        if (a == null) {
            return null;
        }
        Integer[][] result = new Integer[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Long[][] box(long[][] a) {
        if (a == null) {
            return null;
        }
        Long[][] result = new Long[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Float[][] box(float[][] a) {
        if (a == null) {
            return null;
        }
        Float[][] result = new Float[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Double[][] box(double[][] a) {
        if (a == null) {
            return null;
        }
        Double[][] result = new Double[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Boolean[][][] box(boolean[][][] a) {
        if (a == null) {
            return null;
        }
        Boolean[][][] result = new Boolean[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Character[][][] box(char[][][] a) {
        if (a == null) {
            return null;
        }
        Character[][][] result = new Character[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Byte[][][] box(byte[][][] a) {
        if (a == null) {
            return null;
        }
        Byte[][][] result = new Byte[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Short[][][] box(short[][][] a) {
        if (a == null) {
            return null;
        }
        Short[][][] result = new Short[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Integer[][][] box(int[][][] a) {
        if (a == null) {
            return null;
        }
        Integer[][][] result = new Integer[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Long[][][] box(long[][][] a) {
        if (a == null) {
            return null;
        }
        Long[][][] result = new Long[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Float[][][] box(float[][][] a) {
        if (a == null) {
            return null;
        }
        Float[][][] result = new Float[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    public static Double[][][] box(double[][][] a) {
        if (a == null) {
            return null;
        }
        Double[][][] result = new Double[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.box(a[i]);
        }
        return result;
    }

    @SafeVarargs
    public static boolean[] unbox(Boolean ... a) {
        return Array.unbox(a, false);
    }

    public static boolean[] unbox(Boolean[] a, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static boolean[] unbox(Boolean[] a, int fromIndex, int toIndex, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static char[] unbox(Character ... a) {
        return Array.unbox(a, '\u0000');
    }

    public static char[] unbox(Character[] a, char valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static char[] unbox(Character[] a, int fromIndex, int toIndex, char valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j].charValue();
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static byte[] unbox(Byte ... a) {
        return Array.unbox(a, (byte)0);
    }

    public static byte[] unbox(Byte[] a, byte valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static byte[] unbox(Byte[] a, int fromIndex, int toIndex, byte valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static short[] unbox(Short ... a) {
        return Array.unbox(a, (short)0);
    }

    public static short[] unbox(Short[] a, short valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static short[] unbox(Short[] a, int fromIndex, int toIndex, short valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static int[] unbox(Integer ... a) {
        return Array.unbox(a, 0);
    }

    public static int[] unbox(Integer[] a, int valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static int[] unbox(Integer[] a, int fromIndex, int toIndex, int valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_INT_ARRAY;
        }
        int[] result = new int[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static long[] unbox(Long ... a) {
        return Array.unbox(a, 0L);
    }

    public static long[] unbox(Long[] a, long valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static long[] unbox(Long[] a, int fromIndex, int toIndex, long valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_LONG_ARRAY;
        }
        long[] result = new long[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static float[] unbox(Float ... a) {
        return Array.unbox(a, 0.0f);
    }

    public static float[] unbox(Float[] a, float valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static float[] unbox(Float[] a, int fromIndex, int toIndex, float valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j].floatValue();
            ++i;
        }
        return result;
    }

    @SafeVarargs
    public static double[] unbox(Double ... a) {
        return Array.unbox(a, 0.0);
    }

    public static double[] unbox(Double[] a, double valueForNull) {
        if (a == null) {
            return null;
        }
        return Array.unbox(a, 0, a.length, valueForNull);
    }

    public static double[] unbox(Double[] a, int fromIndex, int toIndex, double valueForNull) {
        if (a == null) {
            return null;
        }
        if (toIndex - fromIndex == 0) {
            return N.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[toIndex - fromIndex];
        int i = 0;
        for (int j = fromIndex; j < toIndex; ++j) {
            result[i] = a[j] == null ? valueForNull : a[j];
            ++i;
        }
        return result;
    }

    public static boolean[][] unbox(Boolean[][] a) {
        return Array.unbox(a, false);
    }

    public static boolean[][] unbox(Boolean[][] a, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        boolean[][] result = new boolean[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static char[][] unbox(Character[][] a) {
        return Array.unbox(a, '\u0000');
    }

    public static char[][] unbox(Character[][] a, char valueForNull) {
        if (a == null) {
            return null;
        }
        char[][] result = new char[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static byte[][] unbox(Byte[][] a) {
        return Array.unbox(a, (byte)0);
    }

    public static byte[][] unbox(Byte[][] a, byte valueForNull) {
        if (a == null) {
            return null;
        }
        byte[][] result = new byte[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static short[][] unbox(Short[][] a) {
        return Array.unbox(a, (short)0);
    }

    public static short[][] unbox(Short[][] a, short valueForNull) {
        if (a == null) {
            return null;
        }
        short[][] result = new short[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static int[][] unbox(Integer[][] a) {
        return Array.unbox(a, 0);
    }

    public static int[][] unbox(Integer[][] a, int valueForNull) {
        if (a == null) {
            return null;
        }
        int[][] result = new int[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static long[][] unbox(Long[][] a) {
        return Array.unbox(a, 0L);
    }

    public static long[][] unbox(Long[][] a, long valueForNull) {
        if (a == null) {
            return null;
        }
        long[][] result = new long[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static float[][] unbox(Float[][] a) {
        return Array.unbox(a, 0.0f);
    }

    public static float[][] unbox(Float[][] a, float valueForNull) {
        if (a == null) {
            return null;
        }
        float[][] result = new float[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static double[][] unbox(Double[][] a) {
        return Array.unbox(a, 0.0);
    }

    public static double[][] unbox(Double[][] a, double valueForNull) {
        if (a == null) {
            return null;
        }
        double[][] result = new double[a.length][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static boolean[][][] unbox(Boolean[][][] a) {
        return Array.unbox(a, false);
    }

    public static boolean[][][] unbox(Boolean[][][] a, boolean valueForNull) {
        if (a == null) {
            return null;
        }
        boolean[][][] result = new boolean[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static char[][][] unbox(Character[][][] a) {
        return Array.unbox(a, '\u0000');
    }

    public static char[][][] unbox(Character[][][] a, char valueForNull) {
        if (a == null) {
            return null;
        }
        char[][][] result = new char[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static byte[][][] unbox(Byte[][][] a) {
        return Array.unbox(a, (byte)0);
    }

    public static byte[][][] unbox(Byte[][][] a, byte valueForNull) {
        if (a == null) {
            return null;
        }
        byte[][][] result = new byte[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static short[][][] unbox(Short[][][] a) {
        return Array.unbox(a, (short)0);
    }

    public static short[][][] unbox(Short[][][] a, short valueForNull) {
        if (a == null) {
            return null;
        }
        short[][][] result = new short[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static int[][][] unbox(Integer[][][] a) {
        return Array.unbox(a, 0);
    }

    public static int[][][] unbox(Integer[][][] a, int valueForNull) {
        if (a == null) {
            return null;
        }
        int[][][] result = new int[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static long[][][] unbox(Long[][][] a) {
        return Array.unbox(a, 0L);
    }

    public static long[][][] unbox(Long[][][] a, long valueForNull) {
        if (a == null) {
            return null;
        }
        long[][][] result = new long[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static float[][][] unbox(Float[][][] a) {
        return Array.unbox(a, 0.0f);
    }

    public static float[][][] unbox(Float[][][] a, float valueForNull) {
        if (a == null) {
            return null;
        }
        float[][][] result = new float[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }

    public static double[][][] unbox(Double[][][] a) {
        return Array.unbox(a, 0.0);
    }

    public static double[][][] unbox(Double[][][] a, double valueForNull) {
        if (a == null) {
            return null;
        }
        double[][][] result = new double[a.length][][];
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            result[i] = Array.unbox(a[i], valueForNull);
        }
        return result;
    }
}

