/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ArrayHashSet;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Wrapper;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArrayHashMap<K, V>
implements Map<K, V> {
    private final Map<Wrapper<K>, V> map;

    public ArrayHashMap() {
        this.map = new HashMap<Wrapper<K>, V>();
    }

    public ArrayHashMap(int initialCapacity) {
        this.map = new HashMap<Wrapper<K>, V>(initialCapacity);
    }

    public ArrayHashMap(Class<? extends Map> mapType) {
        try {
            this.map = Modifier.isAbstract(mapType.getModifiers()) ? N.newInstance(mapType) : mapType.newInstance();
        }
        catch (InstantiationException e) {
            throw N.toRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw N.toRuntimeException(e);
        }
    }

    public ArrayHashMap(Map<? extends K, ? extends V> m) {
        this.map = N.isNullOrEmpty(m) ? new HashMap<Wrapper<K>, V>() : N.newHashMap(m.size());
        this.putAll(m);
    }

    @Override
    public V get(Object key) {
        return this.map.get(Wrapper.of(key));
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(Wrapper.of(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        if (N.isNullOrEmpty(m)) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(Wrapper.of(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(Wrapper.of(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return new ArrayHashSet(this.map.keySet());
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new ArrayEntrySet<K, V>(this.map.entrySet());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof ArrayHashMap && ((ArrayHashMap)obj).map.equals(this.map);
    }

    public String toString() {
        return this.map.toString();
    }

    static class ArrayEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<Wrapper<K>, V> entry;

        ArrayEntry(Map.Entry<Wrapper<K>, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey().value();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return this.entry.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof ArrayEntry && ((ArrayEntry)obj).entry.equals(this.entry);
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    static class ArrayEntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Wrapper<K>, V>> it;

        ArrayEntryIterator(Iterator<Map.Entry<Wrapper<K>, V>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new ArrayEntry<K, V>(this.it.next());
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    static class ArrayEntrySet<K, V>
    implements Set<Map.Entry<K, V>> {
        private final Set<Map.Entry<Wrapper<K>, V>> set;

        ArrayEntrySet(Set<Map.Entry<Wrapper<K>, V>> set) {
            this.set = set;
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return this.set.contains(N.newEntry(Wrapper.of(entry.getKey()), entry.getValue()));
            }
            return false;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new ArrayEntryIterator<K, V>(this.set.iterator());
        }

        @Override
        public Object[] toArray() {
            int size = this.size();
            if (size == 0) {
                return N.EMPTY_OBJECT_ARRAY;
            }
            Object[] result = new Object[size];
            int i = 0;
            for (Map.Entry<Wrapper<K>, V> e : this.set) {
                result[i++] = new ArrayEntry<K, V>(e);
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])N.newArray(a.getClass().getComponentType(), size);
            }
            T[] result = a;
            int i = 0;
            for (Map.Entry<Wrapper<K>, V> e : this.set) {
                result[i++] = new ArrayEntry<K, V>(e);
            }
            return a;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof ArrayEntrySet && ((ArrayEntrySet)obj).set.equals(this.set);
        }

        public String toString() {
            return this.set.toString();
        }
    }
}

