/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.function.Supplier;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class BiMap<K, V>
implements Map<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    final Supplier<? extends Map<K, V>> keyMapSupplier;
    final Supplier<? extends Map<V, K>> valueMapSupplier;
    final Map<K, V> keyMap;
    final Map<V, K> valueMap;
    private transient BiMap<V, K> inverse;

    public BiMap() {
        this(16);
    }

    public BiMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public BiMap(int initialCapacity, float loadFactor) {
        this(new HashMap(N.initHashCapacity(initialCapacity), loadFactor), new HashMap(N.initHashCapacity(initialCapacity), loadFactor));
    }

    public BiMap(Class<? extends Map> keyMapType, Class<? extends Map> valueMapType) {
        this(Maps.mapType2Supplier(keyMapType), Maps.mapType2Supplier(valueMapType));
    }

    public BiMap(Supplier<? extends Map<K, V>> keyMapSupplier, Supplier<? extends Map<V, K>> valueMapSupplier) {
        this.keyMapSupplier = keyMapSupplier;
        this.valueMapSupplier = valueMapSupplier;
        this.keyMap = keyMapSupplier.get();
        this.valueMap = valueMapSupplier.get();
    }

    @Internal
    BiMap(Map<K, V> keyMap, Map<V, K> valueMap) {
        this.keyMapSupplier = Maps.mapType2Supplier(keyMap.getClass());
        this.valueMapSupplier = Maps.mapType2Supplier(valueMap.getClass());
        this.keyMap = keyMap;
        this.valueMap = valueMap;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1) {
        BiMap<K, V> map = new BiMap<K, V>(1);
        map.put(k1, v1);
        return map;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1, K k2, V v2) {
        BiMap<K, V> map = new BiMap<K, V>(2);
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        BiMap<K, V> map = new BiMap<K, V>(3);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        BiMap<K, V> map = new BiMap<K, V>(4);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return map;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        BiMap<K, V> map = new BiMap<K, V>(5);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return map;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        BiMap<K, V> map = new BiMap<K, V>(6);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return map;
    }

    public static <K, V> BiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        BiMap<K, V> map = new BiMap<K, V>(7);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    public static <K, V> BiMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        BiMap<? extends K, ? extends V> biMap = new BiMap<K, V>(Maps.newTargetMap(map), Maps.newOrderingMap(map));
        biMap.putAll(map);
        return biMap;
    }

    @Deprecated
    public static <K, V> BiMap<K, V> from(Map<? extends K, ? extends V> map) {
        return BiMap.copyOf(map);
    }

    @Override
    public V get(Object key) {
        return this.keyMap.get(key);
    }

    public K getByValue(Object value) {
        return this.valueMap.get(value);
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, false);
    }

    public V forcePut(K key, V value) {
        return this.put(key, value, true);
    }

    private V put(K key, V value, boolean isForce) {
        K k;
        if (key == null || value == null) {
            throw new NullPointerException("key or value can't be null");
        }
        if (!isForce && this.valueMap.containsKey(value)) {
            throw new IllegalArgumentException("Value already exists: " + value);
        }
        V v = this.keyMap.remove(key);
        if (v != null) {
            this.valueMap.remove(v);
        }
        if ((k = this.valueMap.remove(value)) != null) {
            this.keyMap.remove(k);
        }
        this.keyMap.put(key, value);
        this.valueMap.put(value, key);
        return v;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V value = this.keyMap.remove(key);
        if (value != null) {
            this.valueMap.remove(value);
        }
        return value;
    }

    public K removeByValue(Object value) {
        K key = this.valueMap.remove(value);
        if (key != null) {
            this.keyMap.remove(key);
        }
        return key;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueMap.containsKey(value);
    }

    @Override
    public ImmutableSet<K> keySet() {
        return ImmutableSet.of(this.keyMap.keySet());
    }

    @Override
    public ImmutableSet<V> values() {
        return ImmutableSet.of(this.valueMap.keySet());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new ObjIterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> keyValueEntryIter;
                    {
                        this.keyValueEntryIter = BiMap.this.keyMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyValueEntryIter.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry entry = this.keyValueEntryIter.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return entry.getKey();
                            }

                            @Override
                            public V getValue() {
                                return entry.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return BiMap.this.keyMap.size();
            }
        };
    }

    public BiMap<V, K> inversed() {
        return this.inverse == null ? (this.inverse = new BiMap<K, V>(this.valueMap, this.keyMap)) : this.inverse;
    }

    public BiMap<K, V> copy() {
        BiMap<K, V> copy = new BiMap<K, V>(this.keyMapSupplier, this.valueMapSupplier);
        copy.putAll(this.keyMap);
        return copy;
    }

    @Override
    public void clear() {
        this.keyMap.clear();
        this.valueMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.keyMap.isEmpty();
    }

    @Override
    public int size() {
        return this.keyMap.size();
    }

    @Override
    public int hashCode() {
        return this.keyMap.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof BiMap && this.keyMap.equals(((BiMap)obj).keyMap);
    }

    public String toString() {
        return this.keyMap.toString();
    }
}

