/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.InternalUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public final class BufferedReader
extends Reader {
    protected char[] _cbuf;
    protected int nChars = 0;
    protected int nextChar = 0;
    protected boolean skipLF = false;
    protected String str;
    protected char[] strValue;
    protected int strLength;
    protected Reader in;
    protected boolean isClosed;

    BufferedReader(String st) {
        this.reinit(st);
    }

    BufferedReader(InputStream is) {
        this(new InputStreamReader(is, Charsets.UTF_8));
    }

    BufferedReader(Reader reader) {
        this.reinit(reader);
    }

    @Override
    public int read() throws IOException {
        if (this.str == null) {
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (this._cbuf[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            return this._cbuf[this.nextChar++];
        }
        return this.nextChar < this.strLength ? this.strValue[this.nextChar++] : -1;
    }

    private int read1(char[] cbuf, int off, int len) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (len >= Objectory.BUFFER_SIZE && !this.skipLF) {
                return IOUtil.read(this.in, cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this._cbuf[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        N.copy(this._cbuf, this.nextChar, cbuf, off, n);
        this.nextChar += n;
        return n;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off > cbuf.length || len > cbuf.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.str == null) {
            int n1;
            int n = this.read1(cbuf, off, len);
            if (n <= 0) {
                return n;
            }
            while (n < len && this.in.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
                n += n1;
            }
            return n;
        }
        if (this.nextChar >= this.strLength) {
            return -1;
        }
        int n = Math.min(this.strLength - this.nextChar, len);
        this.str.getChars(this.nextChar, this.nextChar + n, cbuf, off);
        this.nextChar += n;
        return n;
    }

    String readLine(boolean ignoreLF) throws IOException {
        boolean omitLF;
        StringBuilder sb = null;
        boolean bl = omitLF = ignoreLF || this.skipLF;
        while (true) {
            int i;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                String str = null;
                if (sb != null && sb.length() > 0) {
                    str = sb.toString();
                }
                Objectory.recycle(sb);
                return str;
            }
            boolean eol = false;
            char c = '\u0000';
            if (!omitLF || this._cbuf[this.nextChar] == '\n') {
                // empty if block
            }
            this.skipLF = false;
            omitLF = false;
            for (i = ++this.nextChar; i < this.nChars; ++i) {
                c = this._cbuf[i];
                if (c != '\n' && c != '\r') continue;
                eol = true;
                break;
            }
            int startChar = this.nextChar;
            this.nextChar = i;
            if (eol) {
                String str = null;
                if (sb == null) {
                    str = new String(this._cbuf, startChar, i - startChar);
                } else {
                    sb.append(this._cbuf, startChar, i - startChar);
                    str = sb.toString();
                }
                ++this.nextChar;
                if (c == '\r') {
                    this.skipLF = true;
                }
                Objectory.recycle(sb);
                return str;
            }
            if (sb == null) {
                sb = Objectory.createStringBuilder();
            }
            sb.append(this._cbuf, startChar, i - startChar);
        }
    }

    public String readLine() throws IOException {
        if (this.str == null) {
            return this.readLine(false);
        }
        if (this.nextChar >= this.strLength) {
            return null;
        }
        String line = this.str.substring(this.nextChar);
        this.nextChar = this.strLength;
        return line;
    }

    @Override
    public long skip(long n) throws IOException {
        N.checkArgNotNegative(n, "n");
        if (this.str == null) {
            long r;
            long d;
            for (r = n; r > 0L; r -= d) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (this._cbuf[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (r <= (d = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + r);
                    r = 0L;
                    break;
                }
                this.nextChar = this.nChars;
            }
            return n - r;
        }
        if (this.nextChar >= this.strLength) {
            return 0L;
        }
        long ns = Math.min((long)(this.strLength - this.nextChar), n);
        this.nextChar = (int)((long)this.nextChar + ns);
        return ns;
    }

    @Override
    public boolean ready() throws IOException {
        if (this.str == null) {
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this._cbuf[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.ready();
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            IOUtil.close(this.in);
        }
        finally {
            this._reset();
            this.isClosed = true;
        }
    }

    void reinit(String st) {
        this.isClosed = false;
        this.str = st;
        this.strValue = InternalUtil.getCharsForReadOnly(this.str);
        this.strLength = st.length();
        this.lock = this.str;
    }

    void reinit(InputStream is) {
        this.reinit(new InputStreamReader(is));
    }

    void reinit(Reader reader) {
        this.isClosed = false;
        this.in = reader;
        this.lock = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _reset() {
        Object object = this.lock;
        synchronized (object) {
            Objectory.recycle(this._cbuf);
            this._cbuf = null;
            this.nextChar = 0;
            this.nChars = 0;
            this.skipLF = false;
            this.str = null;
            this.strValue = null;
            this.strLength = 0;
            this.in = null;
        }
    }

    protected void fill() throws IOException {
        int len;
        if (this._cbuf == null) {
            this._cbuf = Objectory.createCharArrayBuffer();
        }
        if ((len = this.nChars - this.nextChar) > 0) {
            N.copy(this._cbuf, this.nextChar, this._cbuf, 0, len);
        }
        this.nextChar = 0;
        this.nChars = len;
        int n = IOUtil.read(this.in, this._cbuf, len, this._cbuf.length - len);
        if (n > 0) {
            this.nChars += n;
        }
    }
}

