/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.DateUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;

public class BufferedWriter
extends Writer {
    protected Writer out;
    protected char[] value;
    protected int count = 0;
    protected char[] _cbuf;
    protected int nextChar = 0;
    protected boolean isClosed = false;

    BufferedWriter() {
        this.value = Objectory.createCharArrayBuffer();
        this.lock = this.value;
    }

    BufferedWriter(OutputStream os) {
        this(new OutputStreamWriter(os, Charsets.UTF_8));
    }

    BufferedWriter(Writer writer) {
        this.out = writer;
        this.lock = writer;
    }

    public void write(boolean b) throws IOException {
        this.write(b ? N.TRUE_CHAR_ARRAY : N.FALSE_CHAR_ARRAY);
    }

    public void write(byte b) throws IOException {
        this.write(N.stringOf(b));
    }

    public void write(short s) throws IOException {
        this.write(N.stringOf(s));
    }

    @Override
    @Deprecated
    public void write(int ch) throws IOException {
        this.write((char)ch);
    }

    public void writeInt(int i) throws IOException {
        this.write(N.stringOf(i));
    }

    public void write(long lng) throws IOException {
        this.write(N.stringOf(lng));
    }

    public void write(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void write(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void write(Date date) throws IOException {
        DateUtil.format((Writer)this, date, null, null);
    }

    public void write(Calendar c) throws IOException {
        DateUtil.format((Writer)this, c, null, null);
    }

    public void write(XMLGregorianCalendar c) throws IOException {
        DateUtil.format((Writer)this, c, null, null);
    }

    public void write(char c) throws IOException {
        if (this.value == null) {
            if (this.nextChar >= Objectory.BUFFER_SIZE) {
                this.flushBuffer();
            }
            if (this._cbuf == null) {
                this._cbuf = Objectory.createCharArrayBuffer();
            }
            this._cbuf[this.nextChar++] = c;
        } else {
            if (this.count == this.value.length) {
                this.expandCapacity(this.count + 64);
            }
            this.value[this.count++] = c;
        }
    }

    @Override
    public void write(String str) throws IOException {
        if (str == null) {
            this.write(N.NULL_CHAR_ARRAY);
        } else {
            this.write(str, 0, str.length());
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (str == null) {
            this.write(N.NULL_CHAR_ARRAY, off, len);
        } else {
            len = Math.min(str.length() - off, len);
            if (this.value == null) {
                if (len > Objectory.BUFFER_SIZE - this.nextChar) {
                    if (this.nextChar > 0) {
                        this.flushBuffer();
                    }
                    this.out.write(str, off, len);
                } else {
                    if (this._cbuf == null) {
                        this._cbuf = Objectory.createCharArrayBuffer();
                    }
                    str.getChars(off, off + len, this._cbuf, this.nextChar);
                    this.nextChar += len;
                }
            } else {
                if (len > this.value.length - this.count) {
                    this.expandCapacity(this.count + len);
                }
                str.getChars(off, off + len, this.value, this.count);
                this.count += len;
            }
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        int len = cbuf.length;
        if (this.value == null) {
            if (len > Objectory.BUFFER_SIZE - this.nextChar) {
                if (this.nextChar > 0) {
                    this.flushBuffer();
                }
                this.out.write(cbuf, 0, len);
            } else {
                if (this._cbuf == null) {
                    this._cbuf = Objectory.createCharArrayBuffer();
                }
                N.copy(cbuf, 0, this._cbuf, this.nextChar, len);
                this.nextChar += len;
            }
        } else {
            if (len > this.value.length - this.count) {
                this.expandCapacity(this.count + len);
            }
            N.copy(cbuf, 0, this.value, this.count, len);
            this.count += len;
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        len = Math.min(cbuf.length - off, len);
        if (this.value == null) {
            if (len > Objectory.BUFFER_SIZE - this.nextChar) {
                if (this.nextChar > 0) {
                    this.flushBuffer();
                }
                this.out.write(cbuf, off, len);
            } else {
                if (this._cbuf == null) {
                    this._cbuf = Objectory.createCharArrayBuffer();
                }
                N.copy(cbuf, off, this._cbuf, this.nextChar, len);
                this.nextChar += len;
            }
        } else {
            if (len > this.value.length - this.count) {
                this.expandCapacity(this.count + len);
            }
            N.copy(cbuf, off, this.value, this.count, len);
            this.count += len;
        }
    }

    public void newLine() throws IOException {
        this.write(IOUtil.LINE_SEPARATOR);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return super.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return super.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return super.append(c);
    }

    protected void flushBuffer() throws IOException {
        if (this.value == null) {
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this._cbuf, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        if (this.value == null) {
            this.out.flush();
        }
        Objectory.recycle(this._cbuf);
        this._cbuf = null;
        this.nextChar = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        try {
            this.flush();
            IOUtil.close(this.out);
        }
        finally {
            this._reset();
            this.isClosed = true;
        }
    }

    public String toString() throws UncheckedIOException {
        if (this.value == null) {
            try {
                this.flush();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return this.out.toString();
        }
        return String.valueOf(this.value, 0, this.count);
    }

    void reinit() {
        this.isClosed = false;
        this.value = Objectory.createCharArrayBuffer();
        this.lock = this.value;
    }

    void reinit(OutputStream os) {
        this.reinit(new OutputStreamWriter(os));
    }

    void reinit(Writer writer) {
        this.isClosed = false;
        this.out = writer;
        this.lock = writer;
    }

    void _reset() {
        Objectory.recycle(this._cbuf);
        this._cbuf = null;
        this.nextChar = 0;
        Objectory.recycle(this.value);
        this.value = null;
        this.count = 0;
        this.out = null;
        this.lock = null;
    }

    void expandCapacity(int minimumCapacity) {
        int newCapacity = this.value.length * 2 + 2;
        if (newCapacity - minimumCapacity < 0) {
            newCapacity = minimumCapacity;
        }
        if (newCapacity < 0) {
            if (minimumCapacity < 0) {
                throw new OutOfMemoryError();
            }
            newCapacity = Integer.MAX_VALUE;
        }
        char[] tmp = Arrays.copyOf(this.value, newCapacity);
        Objectory.recycle(this.value);
        this.value = tmp;
    }
}

