/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.CharacterWriter;
import java.io.OutputStream;
import java.io.Writer;

public final class BufferedXMLWriter
extends CharacterWriter {
    private static final char[][] REPLACEMENT_CHARS;

    BufferedXMLWriter() {
        super(REPLACEMENT_CHARS);
    }

    BufferedXMLWriter(OutputStream os) {
        super(os, REPLACEMENT_CHARS);
    }

    BufferedXMLWriter(Writer writer) {
        super(writer, REPLACEMENT_CHARS);
    }

    char getCharQuotation() {
        return '\u0000';
    }

    protected static String getHexString(int ch) {
        return "&#x" + Integer.toHexString(ch) + ";";
    }

    static {
        int length = 128;
        REPLACEMENT_CHARS = new char[length][];
        for (int i = 0; i < length; ++i) {
            if (i >= 32 && i != 127) continue;
            BufferedXMLWriter.REPLACEMENT_CHARS[i] = BufferedXMLWriter.getHexString(i).toCharArray();
        }
        BufferedXMLWriter.REPLACEMENT_CHARS[34] = "&quot;".toCharArray();
        BufferedXMLWriter.REPLACEMENT_CHARS[39] = "&apos;".toCharArray();
        BufferedXMLWriter.REPLACEMENT_CHARS[60] = "&lt;".toCharArray();
        BufferedXMLWriter.REPLACEMENT_CHARS[62] = "&gt;".toCharArray();
        BufferedXMLWriter.REPLACEMENT_CHARS[38] = "&amp;".toCharArray();
    }
}

