/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = (byte)b;
        ++this.count;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        N.copy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void write(byte b) {
        this.ensureCapacity(this.count + 1);
        this.buf[this.count] = b;
        ++this.count;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public int capacity() {
        return this.buf == null ? 0 : this.buf.length;
    }

    public byte[] array() {
        return this.buf;
    }

    public int size() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(Charset charset) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charset);
    }

    @Override
    public void close() throws IOException {
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > 0x7FFFFFF7 || minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        if (minCapacity - this.buf.length > 0) {
            int newCapacity = (int)((double)this.buf.length * 1.75);
            if (newCapacity < 0 || newCapacity > 0x7FFFFFF7) {
                newCapacity = 0x7FFFFFF7;
            }
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }
    }
}

