/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.ParseException;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CSVParser {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final int INITIAL_READ_SIZE = 1024;
    public static final int READ_BUFFER_SIZE = 128;
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char DEFAULT_ESCAPE_CHARACTER = '\\';
    public static final boolean DEFAULT_STRICT_QUOTES = false;
    public static final boolean DEFAULT_IGNORE_LEADING_WHITESPACE = true;
    public static final boolean DEFAULT_IGNORE_QUOTATIONS = false;
    public static final char NULL_CHARACTER = '\u0000';
    private final char separator;
    private final char quotechar;
    private final char escape;
    private final boolean strictQuotes;
    private final boolean ignoreLeadingWhiteSpace;
    private final boolean ignoreQuotations;
    private String pending;
    private boolean inField = false;

    public CSVParser() {
        this(',', '\"', '\\');
    }

    public CSVParser(char separator) {
        this(separator, '\"', '\\');
    }

    public CSVParser(char separator, char quotechar) {
        this(separator, quotechar, '\\');
    }

    public CSVParser(char separator, char quotechar, char escape) {
        this(separator, quotechar, escape, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes) {
        this(separator, quotechar, escape, strictQuotes, true);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace, false);
    }

    public CSVParser(char separator, char quotechar, char escape, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean ignoreQuotations) {
        if (this.anyCharactersAreTheSame(separator, quotechar, escape)) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        if (separator == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.separator = separator;
        this.quotechar = quotechar;
        this.escape = escape;
        this.strictQuotes = strictQuotes;
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        this.ignoreQuotations = ignoreQuotations;
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuotechar() {
        return this.quotechar;
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isStrictQuotes() {
        return this.strictQuotes;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.ignoreLeadingWhiteSpace;
    }

    public boolean isIgnoreQuotations() {
        return this.ignoreQuotations;
    }

    private boolean anyCharactersAreTheSame(char separator, char quotechar, char escape) {
        return this.isSameCharacter(separator, quotechar) || this.isSameCharacter(separator, escape) || this.isSameCharacter(quotechar, escape);
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c1 != '\u0000' && c1 == c2;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public List<String> parseLine(String nextLine) throws ParseException {
        return this.parseLine(nextLine, false);
    }

    public List<String> parseLineMulti(String nextLine) throws ParseException {
        return this.parseLine(nextLine, true);
    }

    public String[] parseLineToArray(String nextLine) throws ParseException {
        List<String> ret = this.parseLine(nextLine);
        return ret.toArray(new String[ret.size()]);
    }

    public String[] parseLineMultiToArray(String nextLine) throws ParseException {
        List<String> ret = this.parseLineMulti(nextLine);
        return ret.toArray(new String[ret.size()]);
    }

    public String[] parseLineToArray(String[] output, String nextLine) throws ParseException {
        List<String> ret = this.parseLine(nextLine);
        return ret.toArray(output);
    }

    public String[] parseLineMultiToArray(String[] output, String nextLine) throws ParseException {
        List<String> ret = this.parseLineMulti(nextLine);
        return ret.toArray(output);
    }

    protected List<String> parseLine(String nextLine, boolean multi) throws ParseException {
        if (!multi && this.pending != null) {
            this.pending = null;
        }
        if (nextLine == null) {
            if (this.pending != null) {
                String s = this.pending;
                this.pending = null;
                return Arrays.asList(s);
            }
            return N.emptyList();
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(nextLine.length() + 128);
        boolean inQuotes = false;
        if (this.pending != null) {
            sb.append(this.pending);
            this.pending = null;
            inQuotes = !this.ignoreQuotations;
        }
        for (int i = 0; i < nextLine.length(); ++i) {
            char c = nextLine.charAt(i);
            if (c == this.escape) {
                if (!this.isNextCharacterEscapable(nextLine, this.inQuotes(inQuotes), i)) continue;
                i = this.appendNextCharacterAndAdvanceLoop(nextLine, sb, i);
                continue;
            }
            if (c == this.quotechar) {
                if (this.isNextCharacterEscapedQuote(nextLine, this.inQuotes(inQuotes), i)) {
                    i = this.appendNextCharacterAndAdvanceLoop(nextLine, sb, i);
                } else {
                    boolean bl = inQuotes = !inQuotes;
                    if (this.atStartOfField(sb)) {
                        // empty if block
                    }
                    if (!this.strictQuotes && i > 2 && nextLine.charAt(i - 1) != this.separator && nextLine.length() > i + 1 && nextLine.charAt(i + 1) != this.separator) {
                        if (this.ignoreLeadingWhiteSpace && sb.length() > 0 && StringUtil.isWhitespace(sb)) {
                            sb.setLength(0);
                        } else {
                            sb.append(c);
                        }
                    }
                }
                this.inField = !this.inField;
                continue;
            }
            if (c == this.separator && (!inQuotes || this.ignoreQuotations)) {
                tokensOnThisLine.add(sb.toString());
                sb.setLength(0);
                this.inField = false;
                continue;
            }
            if (this.strictQuotes && (!inQuotes || this.ignoreQuotations)) continue;
            sb.append(c);
            this.inField = true;
        }
        if (inQuotes && !this.ignoreQuotations) {
            if (!multi) {
                throw new ParseException("Un-terminated quoted field at end of CSV line");
            }
            sb.append('\n');
            this.pending = sb.toString();
            sb = null;
            if (this.inField) {
                // empty if block
            }
        } else {
            this.inField = false;
        }
        if (sb != null) {
            tokensOnThisLine.add(sb.toString());
        }
        return tokensOnThisLine;
    }

    private boolean atStartOfField(StringBuilder sb) {
        return sb.length() == 0;
    }

    private int appendNextCharacterAndAdvanceLoop(String line, StringBuilder sb, int i) {
        sb.append(line.charAt(i + 1));
        return ++i;
    }

    private boolean inQuotes(boolean inQuotes) {
        return inQuotes && !this.ignoreQuotations || this.inField;
    }

    private boolean isNextCharacterEscapedQuote(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.isCharacterQuoteCharacter(nextLine.charAt(i + 1));
    }

    private boolean isCharacterQuoteCharacter(char c) {
        return c == this.quotechar;
    }

    private boolean isCharacterEscapeCharacter(char c) {
        return c == this.escape;
    }

    private boolean isCharacterEscapable(char c) {
        return this.isCharacterQuoteCharacter(c) || this.isCharacterEscapeCharacter(c);
    }

    protected boolean isNextCharacterEscapable(String nextLine, boolean inQuotes, int i) {
        return inQuotes && nextLine.length() > i + 1 && this.isCharacterEscapable(nextLine.charAt(i + 1));
    }
}

