/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.core.RowDataSet;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONParser;
import com.landawn.abacus.parser.ParserFactory;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.BufferedReader;
import com.landawn.abacus.util.CSVParser;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.Function;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CSVUtil {
    static final JSONParser jsonParser = ParserFactory.createJSONParser();
    static final JSONDeserializationConfig jdc = (JSONDeserializationConfig)JSONDeserializationConfig.JDC.create().setElementType(String.class);
    static final Splitter lineSplitter = Splitter.with(',').trimResults();
    public static final Function<String, String[]> CSV_HEADER_PARSER_BY_SPLITTER = new Function<String, String[]>(){

        @Override
        public String[] apply(String line) {
            return lineSplitter.splitToArray(line);
        }
    };
    public static final BiConsumer<String[], String> CSV_LINE_PARSER_BY_SPLITTER = new BiConsumer<String[], String>(){

        @Override
        public void accept(String[] output, String line) {
            lineSplitter.splitToArray(output, (CharSequence)line);
        }
    };
    static final CSVParser csvParser = new CSVParser();
    public static final Function<String, String[]> CSV_HEADER_PARSER = new Function<String, String[]>(){

        @Override
        public String[] apply(String line) {
            return csvParser.parseLineToArray(line);
        }
    };
    public static final BiConsumer<String[], String> CSV_LINE_PARSER = new BiConsumer<String[], String>(){

        @Override
        public void accept(String[] output, String line) {
            csvParser.parseLineToArray(output, line);
        }
    };
    static final Function<String, String[]> CSV_HEADER_PARSER_IN_JSON = new Function<String, String[]>(){

        @Override
        public String[] apply(String line) {
            return jsonParser.readString(String[].class, line, jdc);
        }
    };
    static final BiConsumer<String[], String> CSV_LINE_PARSER_IN_JSON = new BiConsumer<String[], String>(){

        @Override
        public void accept(String[] output, String line) {
            jsonParser.readString(output, line, jdc);
        }
    };
    static final Function<String, String[]> defaultCsvHeadereParser = CSV_HEADER_PARSER_IN_JSON;
    static final BiConsumer<String[], String> defaultCsvLineParser = CSV_LINE_PARSER_IN_JSON;
    static final ThreadLocal<Function<String, String[]>> csvHeaderParser_TL = new ThreadLocal();
    static final ThreadLocal<BiConsumer<String[], String>> csvLineParser_TL = new ThreadLocal();

    public static void setCSVHeaderParser(Function<String, String[]> parser) {
        N.checkArgNotNull(parser, "parser");
        csvHeaderParser_TL.set(parser);
    }

    public static void setCSVLineParser(BiConsumer<String[], String> parser) {
        N.checkArgNotNull(parser, "parser");
        csvLineParser_TL.set(parser);
    }

    public static void resetCSVHeaderParser() {
        csvHeaderParser_TL.set(defaultCsvHeadereParser);
    }

    public static void resetCSVLineParser() {
        csvLineParser_TL.set(defaultCsvLineParser);
    }

    public static DataSet loadCSV(File csvFile) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, (Collection<String>)null);
    }

    public static DataSet loadCSV(File csvFile, Collection<String> selectColumnNames) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, selectColumnNames, 0L, Long.MAX_VALUE);
    }

    public static DataSet loadCSV(File csvFile, Collection<String> selectColumnNames, long offset, long count) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, selectColumnNames, offset, count, Fn.alwaysTrue());
    }

    public static <E extends Exception> DataSet loadCSV(File csvFile, Collection<String> selectColumnNames, long offset, long count, Throwables.Predicate<String[], E> filter) throws UncheckedIOException, E {
        DataSet dataSet;
        FileInputStream csvInputStream = null;
        try {
            csvInputStream = new FileInputStream(csvFile);
            dataSet = CSVUtil.loadCSV((InputStream)csvInputStream, selectColumnNames, offset, count, filter);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(csvInputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(csvInputStream);
        return dataSet;
    }

    public static DataSet loadCSV(InputStream csvInputStream) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, (Collection<String>)null);
    }

    public static DataSet loadCSV(InputStream csvInputStream, Collection<String> selectColumnNames) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, selectColumnNames, 0L, Long.MAX_VALUE);
    }

    public static DataSet loadCSV(InputStream csvInputStream, Collection<String> selectColumnNames, long offset, long count) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, selectColumnNames, offset, count, Fn.alwaysTrue());
    }

    public static <E extends Exception> DataSet loadCSV(InputStream csvInputStream, Collection<String> selectColumnNames, long offset, long count, Throwables.Predicate<String[], E> filter) throws UncheckedIOException, E {
        InputStreamReader csvReader = new InputStreamReader(csvInputStream);
        return CSVUtil.loadCSV((Reader)csvReader, selectColumnNames, offset, count, filter);
    }

    public static DataSet loadCSV(Reader csvReader) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvReader, (Collection<String>)null);
    }

    public static DataSet loadCSV(Reader csvReader, Collection<String> selectColumnNames) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvReader, selectColumnNames, 0L, Long.MAX_VALUE);
    }

    public static DataSet loadCSV(Reader csvReader, Collection<String> selectColumnNames, long offset, long count) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvReader, selectColumnNames, offset, count, Fn.alwaysTrue());
    }

    public static <E extends Exception> DataSet loadCSV(Reader csvReader, Collection<String> selectColumnNames, long offset, long count, Throwables.Predicate<String[], E> filter) throws UncheckedIOException, E {
        N.checkArgument(offset >= 0L && count >= 0L, "'offset'=%s and 'count'=%s can't be negative", offset, count);
        Function<String, String[]> headerParser = csvHeaderParser_TL.get();
        BiConsumer<String[], String> lineParser = csvLineParser_TL.get();
        BufferedReader br = csvReader instanceof BufferedReader ? (BufferedReader)csvReader : Objectory.createBufferedReader(csvReader);
        try {
            String line = br.readLine();
            Object[] titles = headerParser.apply(line);
            int columnCount = titles.length;
            Type[] columnTypes = new Type[columnCount];
            ArrayList<String> columnNameList = new ArrayList<String>(selectColumnNames == null ? columnCount : selectColumnNames.size());
            ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(selectColumnNames == null ? columnCount : selectColumnNames.size());
            Set<String> selectPropNameSet = selectColumnNames == null ? null : N.newHashSet(selectColumnNames);
            for (int i = 0; i < columnCount; ++i) {
                if (selectPropNameSet != null && !selectPropNameSet.remove(titles[i])) continue;
                columnNameList.add(titles[i]);
                columnList.add(new ArrayList());
                columnTypes[i] = N.typeOf(String.class);
            }
            if (selectPropNameSet != null && selectPropNameSet.size() > 0) {
                throw new IllegalArgumentException(selectPropNameSet + " are not included in titles: " + N.toString(titles));
            }
            Object[] strs = new String[titles.length];
            while (offset-- > 0L && br.readLine() != null) {
            }
            while (count > 0L && (line = br.readLine()) != null) {
                lineParser.accept((String[])strs, line);
                if (filter != null && !filter.test((String[])strs)) continue;
                int columnIndex = 0;
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i] == null) continue;
                    ((List)columnList.get(columnIndex++)).add(strs[i]);
                }
                N.fill(strs, null);
                --count;
            }
            RowDataSet rowDataSet = new RowDataSet(columnNameList, columnList);
            return rowDataSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (br != csvReader) {
                Objectory.recycle(br);
            }
        }
    }

    public static DataSet loadCSV(Class<?> entityClass, File csvFile) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvFile, null);
    }

    public static DataSet loadCSV(Class<?> entityClass, File csvFile, Collection<String> selectColumnNames) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvFile, selectColumnNames, 0L, Long.MAX_VALUE);
    }

    public static DataSet loadCSV(Class<?> entityClass, File csvFile, Collection<String> selectColumnNames, long offset, long count) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvFile, selectColumnNames, offset, count, Fn.alwaysTrue());
    }

    public static <E extends Exception> DataSet loadCSV(Class<?> entityClass, File csvFile, Collection<String> selectColumnNames, long offset, long count, Throwables.Predicate<String[], E> filter) throws UncheckedIOException, E {
        DataSet dataSet;
        FileInputStream csvInputStream = null;
        try {
            csvInputStream = new FileInputStream(csvFile);
            dataSet = CSVUtil.loadCSV(entityClass, csvInputStream, selectColumnNames, offset, count, filter);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(csvInputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(csvInputStream);
        return dataSet;
    }

    public static DataSet loadCSV(Class<?> entityClass, InputStream csvInputStream) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvInputStream, null);
    }

    public static DataSet loadCSV(Class<?> entityClass, InputStream csvInputStream, Collection<String> selectColumnNames) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvInputStream, selectColumnNames, 0L, Long.MAX_VALUE);
    }

    public static DataSet loadCSV(Class<?> entityClass, InputStream csvInputStream, Collection<String> selectColumnNames, long offset, long count) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvInputStream, selectColumnNames, offset, count, Fn.alwaysTrue());
    }

    public static <E extends Exception> DataSet loadCSV(Class<?> entityClass, InputStream csvInputStream, Collection<String> selectColumnNames, long offset, long count, Throwables.Predicate<String[], E> filter) throws UncheckedIOException, E {
        InputStreamReader csvReader = new InputStreamReader(csvInputStream);
        return CSVUtil.loadCSV(entityClass, csvReader, selectColumnNames, offset, count, filter);
    }

    public static DataSet loadCSV(Class<?> entityClass, Reader csvReader) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvReader, null);
    }

    public static DataSet loadCSV(Class<?> entityClass, Reader csvReader, Collection<String> selectColumnNames) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvReader, selectColumnNames, 0L, Long.MAX_VALUE);
    }

    public static DataSet loadCSV(Class<?> entityClass, Reader csvReader, Collection<String> selectColumnNames, long offset, long count) throws UncheckedIOException {
        return CSVUtil.loadCSV(entityClass, csvReader, selectColumnNames, offset, count, Fn.alwaysTrue());
    }

    public static <E extends Exception> DataSet loadCSV(Class<?> entityClass, Reader csvReader, Collection<String> selectColumnNames, long offset, long count, Throwables.Predicate<String[], E> filter) throws UncheckedIOException, E {
        N.checkArgument(offset >= 0L && count >= 0L, "'offset'=%s and 'count'=%s can't be negative", offset, count);
        Function<String, String[]> headerParser = csvHeaderParser_TL.get();
        BiConsumer<String[], String> lineParser = csvLineParser_TL.get();
        BufferedReader br = csvReader instanceof BufferedReader ? (BufferedReader)csvReader : Objectory.createBufferedReader(csvReader);
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
        try {
            String line = br.readLine();
            Object[] titles = headerParser.apply(line);
            int columnCount = titles.length;
            Type[] columnTypes = new Type[columnCount];
            ArrayList<String> columnNameList = new ArrayList<String>(selectColumnNames == null ? columnCount : selectColumnNames.size());
            ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(selectColumnNames == null ? columnCount : selectColumnNames.size());
            Set<String> selectPropNameSet = selectColumnNames == null ? null : N.newHashSet(selectColumnNames);
            for (int i = 0; i < columnCount; ++i) {
                if (selectPropNameSet != null && !selectPropNameSet.remove(titles[i])) continue;
                ParserUtil.PropInfo propInfo = entityInfo.getPropInfo(titles[i]);
                if (propInfo == null && selectPropNameSet != null) {
                    throw new IllegalArgumentException((String)titles[i] + " is not defined in entity class: " + ClassUtil.getCanonicalClassName(entityClass));
                }
                if (propInfo == null) continue;
                columnTypes[i] = propInfo.jsonXmlType;
                columnNameList.add((String)titles[i]);
                columnList.add(new ArrayList());
            }
            if (selectPropNameSet != null && selectPropNameSet.size() > 0) {
                throw new IllegalArgumentException(selectColumnNames + " are not included in titles: " + N.toString(titles));
            }
            Object[] strs = new String[titles.length];
            while (offset-- > 0L && br.readLine() != null) {
            }
            while (count > 0L && (line = br.readLine()) != null) {
                lineParser.accept((String[])strs, line);
                if (filter != null && !filter.test((String[])strs)) continue;
                int columnIndex = 0;
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i] == null) continue;
                    ((List)columnList.get(columnIndex++)).add(columnTypes[i].valueOf((String)strs[i]));
                }
                N.fill(strs, null);
                --count;
            }
            RowDataSet rowDataSet = new RowDataSet(columnNameList, columnList);
            return rowDataSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (br != csvReader) {
                Objectory.recycle(br);
            }
        }
    }

    public static DataSet loadCSV(File csvFile, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, 0L, Long.MAX_VALUE, columnTypeMap);
    }

    public static DataSet loadCSV(File csvFile, long offset, long count, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, offset, count, Fn.alwaysTrue(), columnTypeMap);
    }

    public static <E extends Exception> DataSet loadCSV(File csvFile, long offset, long count, Throwables.Predicate<String[], E> filter, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException, E {
        DataSet dataSet;
        FileInputStream csvInputStream = null;
        try {
            csvInputStream = new FileInputStream(csvFile);
            dataSet = CSVUtil.loadCSV((InputStream)csvInputStream, offset, count, filter, columnTypeMap);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(csvInputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(csvInputStream);
        return dataSet;
    }

    public static DataSet loadCSV(InputStream csvInputStream, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, 0L, Long.MAX_VALUE, columnTypeMap);
    }

    public static DataSet loadCSV(InputStream csvInputStream, long offset, long count, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, offset, count, Fn.alwaysTrue(), columnTypeMap);
    }

    public static <E extends Exception> DataSet loadCSV(InputStream csvInputStream, long offset, long count, Throwables.Predicate<String[], E> filter, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException, E {
        InputStreamReader csvReader = new InputStreamReader(csvInputStream);
        return CSVUtil.loadCSV((Reader)csvReader, offset, count, filter, columnTypeMap);
    }

    public static DataSet loadCSV(Reader csvReader, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvReader, 0L, Long.MAX_VALUE, columnTypeMap);
    }

    public static DataSet loadCSV(Reader csvReader, long offset, long count, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvReader, offset, count, Fn.alwaysTrue(), columnTypeMap);
    }

    public static <E extends Exception> DataSet loadCSV(Reader csvReader, long offset, long count, Throwables.Predicate<String[], E> filter, Map<String, ? extends Type> columnTypeMap) throws UncheckedIOException, E {
        N.checkArgument(offset >= 0L && count >= 0L, "'offset'=%s and 'count'=%s can't be negative", offset, count);
        if (N.isNullOrEmpty(columnTypeMap)) {
            throw new IllegalArgumentException("columnTypeMap can't be null or empty");
        }
        Function<String, String[]> headerParser = csvHeaderParser_TL.get();
        BiConsumer<String[], String> lineParser = csvLineParser_TL.get();
        BufferedReader br = csvReader instanceof BufferedReader ? (BufferedReader)csvReader : Objectory.createBufferedReader(csvReader);
        try {
            String line = br.readLine();
            Object[] titles = headerParser.apply(line);
            int columnCount = titles.length;
            Type[] columnTypes = new Type[columnCount];
            ArrayList<String> columnNameList = new ArrayList<String>(columnTypeMap.size());
            ArrayList<List<Object>> columnList = new ArrayList<List<Object>>(columnTypeMap.size());
            for (int i = 0; i < columnCount; ++i) {
                if (!columnTypeMap.containsKey(titles[i])) continue;
                columnTypes[i] = columnTypeMap.get(titles[i]);
                columnNameList.add(titles[i]);
                columnList.add(new ArrayList());
            }
            if (columnNameList.size() != columnTypeMap.size()) {
                ArrayList<String> keys = new ArrayList<String>(columnTypeMap.keySet());
                keys.removeAll(columnNameList);
                throw new IllegalArgumentException(keys + " are not included in titles: " + N.toString(titles));
            }
            Object[] strs = new String[titles.length];
            while (offset-- > 0L && br.readLine() != null) {
            }
            while (count > 0L && (line = br.readLine()) != null) {
                lineParser.accept((String[])strs, line);
                if (filter != null && !filter.test((String[])strs)) continue;
                int columnIndex = 0;
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i] == null) continue;
                    ((List)columnList.get(columnIndex++)).add(columnTypes[i].valueOf((String)strs[i]));
                }
                N.fill(strs, null);
                --count;
            }
            RowDataSet rowDataSet = new RowDataSet(columnNameList, columnList);
            return rowDataSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (br != csvReader) {
                Objectory.recycle(br);
            }
        }
    }

    public static DataSet loadCSV(File csvFile, List<? extends Type> columnTypeList) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, 0L, Long.MAX_VALUE, columnTypeList);
    }

    public static DataSet loadCSV(File csvFile, long offset, long count, List<? extends Type> columnTypeList) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvFile, offset, count, Fn.alwaysTrue(), columnTypeList);
    }

    public static <E extends Exception> DataSet loadCSV(File csvFile, long offset, long count, Throwables.Predicate<String[], E> filter, List<? extends Type> columnTypeList) throws UncheckedIOException, E {
        DataSet dataSet;
        FileInputStream csvInputStream = null;
        try {
            csvInputStream = new FileInputStream(csvFile);
            dataSet = CSVUtil.loadCSV((InputStream)csvInputStream, offset, count, filter, columnTypeList);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(csvInputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(csvInputStream);
        return dataSet;
    }

    public static DataSet loadCSV(InputStream csvInputStream, List<? extends Type> columnTypeList) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, 0L, Long.MAX_VALUE, columnTypeList);
    }

    public static DataSet loadCSV(InputStream csvInputStream, long offset, long count, List<? extends Type> columnTypeList) throws UncheckedIOException {
        return CSVUtil.loadCSV(csvInputStream, offset, count, Fn.alwaysTrue(), columnTypeList);
    }

    public static <E extends Exception> DataSet loadCSV(InputStream csvInputStream, long offset, long count, Throwables.Predicate<String[], E> filter, List<? extends Type> columnTypeList) throws E {
        InputStreamReader csvReader = new InputStreamReader(csvInputStream);
        return CSVUtil.loadCSV((Reader)csvReader, offset, count, filter, columnTypeList);
    }

    public static DataSet loadCSV(Reader csvReader, List<? extends Type> columnTypeList) {
        return CSVUtil.loadCSV(csvReader, 0L, Long.MAX_VALUE, columnTypeList);
    }

    public static DataSet loadCSV(Reader csvReader, long offset, long count, List<? extends Type> columnTypeList) {
        return CSVUtil.loadCSV(csvReader, offset, count, Fn.alwaysTrue(), columnTypeList);
    }

    public static <E extends Exception> DataSet loadCSV(Reader csvReader, long offset, long count, Throwables.Predicate<String[], E> filter, List<? extends Type> columnTypeList) throws UncheckedIOException, E {
        N.checkArgument(offset >= 0L && count >= 0L, "'offset'=%s and 'count'=%s can't be negative", offset, count);
        if (N.isNullOrEmpty(columnTypeList)) {
            throw new IllegalArgumentException("columnTypeList can't be null or empty");
        }
        Function<String, String[]> headerParser = csvHeaderParser_TL.get();
        BiConsumer<String[], String> lineParser = csvLineParser_TL.get();
        BufferedReader br = csvReader instanceof BufferedReader ? (BufferedReader)csvReader : Objectory.createBufferedReader(csvReader);
        Type[] columnTypes = columnTypeList.toArray(new Type[columnTypeList.size()]);
        try {
            String line = br.readLine();
            String[] titles = headerParser.apply(line);
            int columnCount = titles.length;
            ArrayList<String> columnNameList = new ArrayList<String>(columnCount);
            ArrayList<List<Object>> columnList = new ArrayList<List<Object>>();
            for (int i = 0; i < columnCount; ++i) {
                if (columnTypes[i] == null) continue;
                columnNameList.add(titles[i]);
                columnList.add(new ArrayList());
            }
            Object[] strs = new String[titles.length];
            while (offset-- > 0L && br.readLine() != null) {
            }
            while (count > 0L && (line = br.readLine()) != null) {
                lineParser.accept((String[])strs, line);
                if (filter != null && !filter.test((String[])strs)) continue;
                int columnIndex = 0;
                for (int i = 0; i < columnCount; ++i) {
                    if (columnTypes[i] == null) continue;
                    ((List)columnList.get(columnIndex++)).add(columnTypes[i].valueOf((String)strs[i]));
                }
                N.fill(strs, null);
                --count;
            }
            RowDataSet rowDataSet = new RowDataSet(columnNameList, columnList);
            return rowDataSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (br != csvReader) {
                Objectory.recycle(br);
            }
        }
    }

    static {
        csvHeaderParser_TL.set(defaultCsvHeadereParser);
        csvLineParser_TL.set(defaultCsvLineParser);
    }
}

