/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import java.util.HashMap;
import java.util.Map;

public enum CalendarUnit {
    MILLISECOND(14),
    SECOND(13),
    MINUTE(12),
    HOUR(11),
    DAY(5),
    WEEK(3),
    MONTH(2),
    YEAR(1);

    private static Map<Integer, CalendarUnit> m;
    private int intValue;

    private CalendarUnit(int intValue) {
        this.intValue = intValue;
    }

    public static CalendarUnit valueOf(int intValue) {
        CalendarUnit result = m.get(intValue);
        if (result == null) {
            throw new IllegalArgumentException("No defined CalendarUnit mapping to value: " + intValue);
        }
        return result;
    }

    public int intValue() {
        return this.intValue;
    }

    public long toMillis(long amount) {
        switch (this) {
            case MILLISECOND: {
                return amount;
            }
            case SECOND: {
                return amount * 1000L;
            }
            case MINUTE: {
                return amount * 60L * 1000L;
            }
            case HOUR: {
                return amount * 60L * 60L * 1000L;
            }
            case DAY: {
                return amount * 24L * 60L * 60L * 1000L;
            }
            case WEEK: {
                return amount * 7L * 24L * 60L * 60L * 1000L;
            }
        }
        throw new IllegalArgumentException("Unsupported unit: " + (Object)((Object)this));
    }

    static {
        m = new HashMap<Integer, CalendarUnit>();
        for (CalendarUnit value : CalendarUnit.values()) {
            m.put(value.intValue, value);
        }
    }
}

