/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;
import java.util.Comparator;

public final class Chain {
    private Chain() {
    }

    public static <T extends Comparable<? super T>> ComparisonChain compare(T left, T right) {
        return new ComparisonChain().compare(left, right);
    }

    public static <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
        return new ComparisonChain().compare(left, right, comparator);
    }

    public static <T, E extends Exception> ComparisonChain compare(T left, T right, Throwables.BiFunction<? super T, ? super T, Integer, E> func) throws E {
        return new ComparisonChain().compare(left, right, func);
    }

    public static <T extends Comparable<? super T>> ComparisonChain compareNullLess(T left, T right) {
        return new ComparisonChain().compareNullLess(left, right);
    }

    public static <T extends Comparable<? super T>> ComparisonChain compareNullBigger(T left, T right) {
        return new ComparisonChain().compareNullBigger(left, right);
    }

    public static ComparisonChain compareFalseLess(boolean left, boolean right) {
        return new ComparisonChain().compareFalseLess(left, right);
    }

    public static ComparisonChain compareTrueLess(boolean left, boolean right) {
        return new ComparisonChain().compareTrueLess(left, right);
    }

    public static ComparisonChain compare(char left, char right) {
        return new ComparisonChain().compare(left, right);
    }

    public static ComparisonChain compare(byte left, byte right) {
        return new ComparisonChain().compare(left, right);
    }

    public static ComparisonChain compare(short left, short right) {
        return new ComparisonChain().compare(left, right);
    }

    public static ComparisonChain compare(int left, int right) {
        return new ComparisonChain().compare(left, right);
    }

    public static ComparisonChain compare(long left, long right) {
        return new ComparisonChain().compare(left, right);
    }

    public static ComparisonChain compare(float left, float right) {
        return new ComparisonChain().compare(left, right);
    }

    public static ComparisonChain compare(double left, double right) {
        return new ComparisonChain().compare(left, right);
    }

    public static EquivalenceChain equals(Object left, Object right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static <T, E extends Exception> EquivalenceChain equals(T left, T right, Throwables.BiFunction<? super T, ? super T, Boolean, E> func) throws E {
        return new EquivalenceChain().equals(left, right, func);
    }

    public static EquivalenceChain equals(boolean left, boolean right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(char left, char right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(byte left, byte right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(short left, short right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(int left, int right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(long left, long right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(float left, float right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static EquivalenceChain equals(double left, double right) {
        return new EquivalenceChain().equals(left, right);
    }

    public static HashCodeChain hash(Object value) {
        return new HashCodeChain().hash(value);
    }

    public static <T, E extends Exception> HashCodeChain hash(T value, Throwables.ToIntFunction<? super T, E> func) throws E {
        return new HashCodeChain().hash(value, func);
    }

    public static HashCodeChain hash(boolean value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(char value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(byte value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(short value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(int value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(long value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(float value) {
        return new HashCodeChain().hash(value);
    }

    public static HashCodeChain hash(double value) {
        return new HashCodeChain().hash(value);
    }

    public static final class HashCodeChain {
        private int result = 0;

        private HashCodeChain() {
        }

        public HashCodeChain hash(Object value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public <T, E extends Exception> HashCodeChain hash(T value, Throwables.ToIntFunction<? super T, E> func) throws E {
            N.checkArgNotNull(func, "func");
            this.result = this.result * 31 + func.applyAsInt(value);
            return this;
        }

        public HashCodeChain hash(boolean value) {
            this.result = this.result * 31 + (value ? 1231 : 1237);
            return this;
        }

        public HashCodeChain hash(char value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public HashCodeChain hash(byte value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public HashCodeChain hash(short value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public HashCodeChain hash(int value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public HashCodeChain hash(long value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public HashCodeChain hash(float value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public HashCodeChain hash(double value) {
            this.result = this.result * 31 + N.hashCode(value);
            return this;
        }

        public int result() {
            return this.result;
        }
    }

    public static final class EquivalenceChain {
        private boolean result = true;

        private EquivalenceChain() {
        }

        public EquivalenceChain equals(Object left, Object right) {
            if (this.result) {
                this.result = N.equals(left, right);
            }
            return this;
        }

        public <T, E extends Exception> EquivalenceChain equals(T left, T right, Throwables.BiFunction<? super T, ? super T, Boolean, E> func) throws E {
            N.checkArgNotNull(func, "func");
            if (this.result) {
                this.result = func.apply(left, right);
            }
            return this;
        }

        public EquivalenceChain equals(boolean left, boolean right) {
            if (this.result) {
                this.result = left == right;
            }
            return this;
        }

        public EquivalenceChain equals(char left, char right) {
            if (this.result) {
                this.result = left == right;
            }
            return this;
        }

        public EquivalenceChain equals(byte left, byte right) {
            if (this.result) {
                this.result = left == right;
            }
            return this;
        }

        public EquivalenceChain equals(short left, short right) {
            if (this.result) {
                this.result = left == right;
            }
            return this;
        }

        public EquivalenceChain equals(int left, int right) {
            if (this.result) {
                this.result = left == right;
            }
            return this;
        }

        public EquivalenceChain equals(long left, long right) {
            if (this.result) {
                this.result = left == right;
            }
            return this;
        }

        public EquivalenceChain equals(float left, float right) {
            if (this.result) {
                this.result = Float.compare(left, right) == 0;
            }
            return this;
        }

        public EquivalenceChain equals(double left, double right) {
            if (this.result) {
                this.result = Double.compare(left, right) == 0;
            }
            return this;
        }

        public boolean result() {
            return this.result;
        }
    }

    public static final class ComparisonChain {
        private int result = 0;

        private ComparisonChain() {
        }

        public <T extends Comparable<? super T>> ComparisonChain compare(T left, T right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public <T> ComparisonChain compare(T left, T right, Comparator<T> comparator) {
            if (this.result == 0) {
                this.result = N.compare(left, right, comparator);
            }
            return this;
        }

        public <T, E extends Exception> ComparisonChain compare(T left, T right, Throwables.BiFunction<? super T, ? super T, Integer, E> func) throws E {
            N.checkArgNotNull(func, "func");
            if (this.result == 0) {
                this.result = func.apply(left, right);
            }
            return this;
        }

        public <T extends Comparable<? super T>> ComparisonChain compareNullLess(T left, T right) {
            if (this.result == 0) {
                this.result = left == null ? (right == null ? 0 : -1) : (right == null ? 1 : left.compareTo(right));
            }
            return this;
        }

        public <T extends Comparable<? super T>> ComparisonChain compareNullBigger(T left, T right) {
            if (this.result == 0) {
                this.result = left == null ? (right == null ? 0 : 1) : (right == null ? -1 : left.compareTo(right));
            }
            return this;
        }

        public ComparisonChain compareFalseLess(boolean left, boolean right) {
            if (this.result == 0) {
                this.result = left == right ? 0 : (left ? -1 : 1);
            }
            return this;
        }

        public ComparisonChain compareTrueLess(boolean left, boolean right) {
            if (this.result == 0) {
                this.result = left == right ? 0 : (left ? 1 : -1);
            }
            return this;
        }

        public ComparisonChain compare(char left, char right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public ComparisonChain compare(byte left, byte right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public ComparisonChain compare(short left, short right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public ComparisonChain compare(int left, int right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public ComparisonChain compare(long left, long right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public ComparisonChain compare(float left, float right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public ComparisonChain compare(double left, double right) {
            if (this.result == 0) {
                this.result = N.compare(left, right);
            }
            return this;
        }

        public int result() {
            return this.result;
        }
    }
}

