/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.InternalUtil;
import com.landawn.abacus.util.N;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public abstract class CharacterWriter
extends BufferedWriter {
    protected final char[][] replacementsForChars;
    protected final int lengthOfReplacementsForChars;

    CharacterWriter(char[][] replacementsForChars) {
        this.replacementsForChars = replacementsForChars;
        this.lengthOfReplacementsForChars = replacementsForChars.length - 1;
    }

    CharacterWriter(OutputStream os, char[][] replacementsForChars) {
        super(os);
        this.replacementsForChars = replacementsForChars;
        this.lengthOfReplacementsForChars = replacementsForChars.length - 1;
    }

    CharacterWriter(Writer writer, char[][] replacementsForChars) {
        super(writer);
        this.replacementsForChars = replacementsForChars;
        this.lengthOfReplacementsForChars = replacementsForChars.length - 1;
    }

    public void writeCharacter(char ch) throws IOException {
        if (ch > this.lengthOfReplacementsForChars || this.replacementsForChars[ch] == null) {
            this.write(ch);
        } else {
            this.write(this.replacementsForChars[ch]);
        }
    }

    public void writeCharacter(char[] cbuf) throws IOException {
        int i;
        int len = cbuf.length;
        char ch = '\u0000';
        int from = 0;
        int end = len;
        for (i = 0; i < end; ++i) {
            ch = cbuf[i];
            if (ch > this.lengthOfReplacementsForChars || this.replacementsForChars[ch] == null) continue;
            if (i > from) {
                this.write(cbuf, from, i - from);
                from = i;
            }
            this.write(this.replacementsForChars[ch]);
            ++from;
        }
        if (i > from) {
            this.write(cbuf, from, i - from);
        }
    }

    public void writeCharacter(char[] cbuf, int off, int len) throws IOException {
        int i;
        len = Math.min(cbuf.length - off, len);
        char ch = '\u0000';
        int from = off;
        int end = off + len;
        for (i = off; i < end; ++i) {
            ch = cbuf[i];
            if (ch > this.lengthOfReplacementsForChars || this.replacementsForChars[ch] == null) continue;
            if (i > from) {
                this.write(cbuf, from, i - from);
                from = i;
            }
            this.write(this.replacementsForChars[ch]);
            ++from;
        }
        if (i > from) {
            this.write(cbuf, from, i - from);
        }
    }

    public void writeCharacter(String str) throws IOException {
        if (str == null) {
            this.write(N.NULL_CHAR_ARRAY);
        } else {
            this.writeCharacter(InternalUtil.getCharsForReadOnly(str));
        }
    }

    public void writeCharacter(String str, int off, int len) throws IOException {
        if (str == null) {
            this.write(N.NULL_CHAR_ARRAY, off, len);
        } else {
            this.writeCharacter(InternalUtil.getCharsForReadOnly(str), off, len);
        }
    }
}

