/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.annotation.Id;
import com.landawn.abacus.annotation.Immutable;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.annotation.ReadOnlyId;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.core.NameUtil;
import com.landawn.abacus.core.RowDataSet;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.type.ObjectType;
import com.landawn.abacus.util.ArrayHashMap;
import com.landawn.abacus.util.ArrayHashSet;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.ByteArrayOutputStream;
import com.landawn.abacus.util.Duration;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.Fraction;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.Internals;
import com.landawn.abacus.util.LinkedArrayHashMap;
import com.landawn.abacus.util.LinkedArrayHashSet;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.MutableBoolean;
import com.landawn.abacus.util.MutableByte;
import com.landawn.abacus.util.MutableChar;
import com.landawn.abacus.util.MutableDouble;
import com.landawn.abacus.util.MutableFloat;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.MutableLong;
import com.landawn.abacus.util.MutableShort;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Range;
import com.landawn.abacus.util.SQLBuilder;
import com.landawn.abacus.util.SetMultimap;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.StringWriter;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.u;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.datatype.XMLGregorianCalendar;

public final class ClassUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);
    private static final String JAR_POSTFIX = ".jar";
    private static final String CLASS_POSTFIX = ".class";
    private static final String PROP_NAME_SEPARATOR = ".";
    private static final String GET = "get".intern();
    private static final String SET = "set".intern();
    private static final String IS = "is".intern();
    private static final String HAS = "has".intern();
    private static final int POOL_SIZE = Internals.POOL_SIZE;
    private static final Map<Class<?>, Boolean> entityClassPool = new ObjectPool(POOL_SIZE);
    private static final Map<String, Class<?>> BUILT_IN_TYPE = new ObjectPool(POOL_SIZE);
    private static Map<String, String> SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME;
    private static final Map<String, String> camelCasePropNamePool;
    private static final Map<String, String> lowerCaseWithUnderscorePropNamePool;
    private static final Map<String, String> upperCaseWithUnderscorePropNamePool;
    private static final Map<Class<?>, Boolean> registeredXMLBindingClassList;
    private static final Map<Class<?>, Set<String>> registeredNonPropGetSetMethodPool;
    private static final Map<Class<?>, ImmutableList<String>> entityDeclaredPropNameListPool;
    private static final Map<Class<?>, ImmutableMap<String, Field>> entityDeclaredPropFieldPool;
    private static final Map<Class<?>, Map<String, Field>> entityPropFieldPool;
    private static final Map<Class<?>, ImmutableMap<String, Method>> entityDeclaredPropGetMethodPool;
    private static final Map<Class<?>, ImmutableMap<String, Method>> entityDeclaredPropSetMethodPool;
    private static final Map<Class<?>, Map<String, Method>> entityPropGetMethodPool;
    private static final Map<Class<?>, Map<String, Method>> entityPropSetMethodPool;
    private static final Map<Class<?>, Map<String, List<Method>>> entityInlinePropGetMethodPool;
    private static final Map<String, String> formalizedPropNamePool;
    private static final Map<Method, String> methodPropNamePool;
    private static final Map<String, String> keyWordMapper;
    private static final Set<String> nonGetSetMethodName;
    private static final Map<Class<?>, Package> packagePool;
    private static final Map<Class<?>, String> packageNamePool;
    private static final Map<String, Class<?>> clsNamePool;
    private static final Map<Class<?>, String> simpleClassNamePool;
    private static final Map<Class<?>, String> nameClassPool;
    private static final Map<Class<?>, String> canonicalClassNamePool;
    private static final Map<Class<?>, Class<?>> enclosingClassPool;
    private static final Map<Class<?>, Map<Class<?>[], Constructor<?>>> classDeclaredConstructorPool;
    private static final Map<Class<?>, Map<String, Map<Class<?>[], Method>>> classDeclaredMethodPool;
    private static final Map<Class<?>, Class<?>> registeredNonEntityClass;
    @Deprecated
    @Internal
    public static final Class<?> CLASS_MASK;
    @Deprecated
    @Internal
    public static final Method METHOD_MASK;
    @Deprecated
    @Internal
    public static final Field FIELD_MASK;
    private static final Map<String, String> builtinTypeNameMap;
    private static final Map<Class<?>, ImmutableList<String>> idPropNamesMap;
    private static final ImmutableList<String> fakeIds;
    private static final Map<Class<?>, ImmutableMap<String, String>> column2PropNameNameMapPool;
    static final Map<Class<?>, Map<NamingPolicy, ImmutableMap<String, String>>> entityTablePropColumnNameMap;

    private ClassUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerXMLBindingClass(Class<?> cls) {
        if (registeredXMLBindingClassList.containsKey(cls)) {
            return;
        }
        Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
        synchronized (map) {
            registeredXMLBindingClassList.put(cls, false);
            if (entityDeclaredPropGetMethodPool.containsKey(cls)) {
                entityDeclaredPropGetMethodPool.remove(cls);
                entityDeclaredPropSetMethodPool.remove(cls);
                entityPropFieldPool.remove(cls);
                ClassUtil.loadPropGetSetMethodList(cls);
            }
            ParserUtil.refreshEntityPropInfo(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNonEntityClass(Class<?> cls) {
        registeredNonEntityClass.put(cls, cls);
        Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
        synchronized (map) {
            registeredXMLBindingClassList.put(cls, false);
            if (entityDeclaredPropGetMethodPool.containsKey(cls)) {
                entityDeclaredPropGetMethodPool.remove(cls);
                entityDeclaredPropSetMethodPool.remove(cls);
                entityPropFieldPool.remove(cls);
                ClassUtil.loadPropGetSetMethodList(cls);
            }
            ParserUtil.refreshEntityPropInfo(cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNonPropGetSetMethod(Class<?> cls, String propName) {
        Set<String> set = registeredNonPropGetSetMethodPool.get(cls);
        if (set == null) {
            Map<Class<?>, Set<String>> map = registeredNonPropGetSetMethodPool;
            synchronized (map) {
                set = registeredNonPropGetSetMethodPool.get(cls);
                if (set == null) {
                    set = N.newHashSet();
                    registeredNonPropGetSetMethodPool.put(cls, set);
                }
            }
        }
        set.add(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPropGetSetMethod(String propName, Method method) {
        Class<?> cls = method.getDeclaringClass();
        Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
        synchronized (map) {
            if (ClassUtil.isGetMethod(method)) {
                Map<String, Method> propMethodMap = entityPropGetMethodPool.get(cls);
                if (propMethodMap == null) {
                    ClassUtil.loadPropGetSetMethodList(cls);
                    propMethodMap = entityPropGetMethodPool.get(cls);
                }
                if (propMethodMap.containsKey(propName)) {
                    if (!method.equals(propMethodMap.get(propName))) {
                        throw new IllegalArgumentException(propName + " has already been regiestered with different method: " + propMethodMap.get(propName).getName());
                    }
                } else {
                    propMethodMap.put(propName, method);
                }
            } else if (ClassUtil.isSetMethod(method)) {
                Map<String, Method> propMethodMap = entityPropSetMethodPool.get(cls);
                if (propMethodMap == null) {
                    ClassUtil.loadPropGetSetMethodList(cls);
                    propMethodMap = entityPropSetMethodPool.get(cls);
                }
                if (propMethodMap.containsKey(propName)) {
                    if (!method.equals(propMethodMap.get(propName))) {
                        throw new IllegalArgumentException(propName + " has already been regiestered with different method: " + propMethodMap.get(propName).getName());
                    }
                } else {
                    propMethodMap.put(propName, method);
                }
            } else {
                throw new IllegalArgumentException("The name of property getter/setter method must start with 'get/is/has' or 'set': " + method.getName());
            }
        }
    }

    public static boolean isEntity(Class<?> cls) {
        Boolean b = entityClassPool.get(cls);
        if (b == null) {
            b = !registeredNonEntityClass.containsKey(cls) && N.notNullOrEmpty(ClassUtil.getPropNameList(cls));
            entityClassPool.put(cls, b);
        }
        return b;
    }

    public static boolean isDirtyMarker(Class<?> cls) {
        return DirtyMarkerUtil.isDirtyMarker(cls);
    }

    public static <T> Class<T> forClass(String clsName) throws IllegalArgumentException {
        return ClassUtil.forClass(clsName, true);
    }

    static <T> Class<T> forClass(String clsName, boolean cacheResult) throws IllegalArgumentException {
        Class<?> cls = clsNamePool.get(clsName);
        if (cls == null) {
            block21: {
                cls = BUILT_IN_TYPE.get(clsName);
                if (cls == null) {
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        String temp;
                        String componentTypeName;
                        int index;
                        String newClassName = clsName;
                        if (newClassName.indexOf(46) < 0 && ((index = newClassName.indexOf("[]")) < 0 && !SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.containsKey(newClassName) || index > 0 && !SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.containsKey(newClassName.substring(0, index)))) {
                            newClassName = "java.lang." + newClassName;
                            try {
                                cls = Class.forName(newClassName);
                                BUILT_IN_TYPE.put(clsName, cls);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                        }
                        if (cls != null) break block21;
                        newClassName = clsName;
                        index = newClassName.indexOf("[]");
                        if (index > 0 && (componentTypeName = newClassName.substring(0, index)).equals(temp = newClassName.replaceAll("\\[\\]", ""))) {
                            int dimensions = (newClassName.length() - temp.length()) / 2;
                            String prefixOfArray = "";
                            while (dimensions-- > 0) {
                                prefixOfArray = prefixOfArray + "[";
                            }
                            String symbolOfPrimitiveArraryClassName = SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.get(componentTypeName);
                            if (symbolOfPrimitiveArraryClassName != null) {
                                try {
                                    cls = Class.forName(prefixOfArray + symbolOfPrimitiveArraryClassName);
                                    BUILT_IN_TYPE.put(clsName, cls);
                                }
                                catch (ClassNotFoundException classNotFoundException) {}
                            } else {
                                try {
                                    com.landawn.abacus.type.Type componentType = N.typeOf(componentTypeName);
                                    if (componentType.clazz().equals(Object.class) && !componentType.name().equals(ObjectType.OBJECT)) {
                                        throw new IllegalArgumentException("No Class found by name: " + clsName);
                                    }
                                    cls = Class.forName(prefixOfArray + "L" + componentType.clazz().getCanonicalName() + ";");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                        }
                        if (cls != null) break block21;
                        newClassName = clsName;
                        int lastIndex = -1;
                        while ((lastIndex = newClassName.lastIndexOf(46)) > 0) {
                            newClassName = newClassName.substring(0, lastIndex) + "$" + newClassName.substring(lastIndex + 1);
                            try {
                                cls = Class.forName(newClassName);
                                break;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                            }
                        }
                    }
                }
            }
            if (cls == null) {
                throw new IllegalArgumentException("No class found by name: " + clsName);
            }
            if (cacheResult) {
                clsNamePool.put(clsName, cls);
            }
        }
        return cls;
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        ArrayList classes = new ArrayList();
        for (Class<?> superclass = cls.getSuperclass(); superclass != null && !superclass.equals(Object.class); superclass = superclass.getSuperclass()) {
            classes.add(superclass);
        }
        return classes;
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> cls) {
        Set<Class<?>> interfacesFound = N.newLinkedHashSet();
        ClassUtil.getAllInterfaces(cls, interfacesFound);
        return interfacesFound;
    }

    private static void getAllInterfaces(Class<?> cls, Set<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                ClassUtil.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static Set<Class<?>> getAllSuperTypes(Class<?> cls) {
        Set<Class<?>> superTypesFound = N.newLinkedHashSet();
        ClassUtil.getAllSuperTypes(cls, superTypesFound);
        return superTypesFound;
    }

    private static void getAllSuperTypes(Class<?> cls, Set<Class<?>> superTypesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!superTypesFound.add(i)) continue;
                ClassUtil.getAllInterfaces(i, superTypesFound);
            }
            Class<?> superclass = cls.getSuperclass();
            if (superclass != null && !superclass.equals(Object.class) && superTypesFound.add(superclass)) {
                ClassUtil.getAllSuperTypes(superclass, superTypesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    public static String getTypeName(Type type) {
        return ClassUtil.formatParameterizedTypeName(type.toString());
    }

    public static String getParameterizedTypeNameByField(Field field) {
        return ClassUtil.formatParameterizedTypeName(field.getGenericType().toString());
    }

    public static String getParameterizedTypeNameByMethod(Method method) {
        Object[] genericParameterTypes = method.getGenericParameterTypes();
        if (N.notNullOrEmpty(genericParameterTypes)) {
            return ClassUtil.formatParameterizedTypeName(genericParameterTypes[0].toString());
        }
        return ClassUtil.formatParameterizedTypeName(method.getGenericReturnType().toString());
    }

    public static String formatParameterizedTypeName(String parameterizedTypeName) {
        int idx;
        String res = builtinTypeNameMap.get(parameterizedTypeName);
        if (res != null) {
            return res;
        }
        res = parameterizedTypeName;
        if (res.startsWith("class [L") && res.endsWith(";")) {
            res = res.substring("class [L".length(), res.length() - 1) + "[]";
        }
        if (res.startsWith("interface [L") && res.endsWith(";")) {
            res = res.substring("interface [L".length(), res.length() - 1) + "[]";
        }
        if ((idx = (res = res.replaceAll("java.lang.", "").replaceAll("class ", "").replaceAll("interface ", "")).lastIndexOf(36)) > 0) {
            StringBuilder sb = new StringBuilder();
            int len = res.length();
            for (int i = len - 1; i >= 0; --i) {
                char ch = res.charAt(i);
                sb.append(ch);
                if (ch != '$') continue;
                int j = i;
                char x = '\u0000';
                while (--i >= 0 && (Character.isLetterOrDigit(x = res.charAt(i)) || x == '_' || x == '.')) {
                }
                String tmp = res.substring(i + 1, j);
                if (tmp.substring(0, tmp.length() / 2).equals(tmp.substring(tmp.length() / 2 + 1))) {
                    sb.append(StringUtil.reverse(tmp.substring(0, tmp.length() / 2)));
                } else {
                    sb.append(StringUtil.reverse(tmp));
                }
                ++i;
            }
            res = sb.reverse().toString();
        }
        return res;
    }

    public static Package getPackage(Class<?> cls) {
        Package pkg = packagePool.get(cls);
        if (pkg == null) {
            if (N.isPrimitiveType(cls)) {
                return null;
            }
            pkg = cls.getPackage();
            if (pkg != null) {
                packagePool.put(cls, pkg);
            }
        }
        return pkg;
    }

    public static String getPackageName(Class<?> cls) {
        String pkgName = packageNamePool.get(cls);
        if (pkgName == null) {
            Package pkg = ClassUtil.getPackage(cls);
            pkgName = pkg == null ? "" : pkg.getName();
            packageNamePool.put(cls, pkgName);
        }
        return pkgName;
    }

    public static List<Class<?>> getClassesByPackage(String pkgName, boolean isRecursive, boolean skipClassLoaddingException) throws UncheckedIOException {
        return ClassUtil.getClassesByPackage(pkgName, isRecursive, skipClassLoaddingException, Fn.alwaysTrue());
    }

    public static <E extends Exception> List<Class<?>> getClassesByPackage(String pkgName, boolean isRecursive, boolean skipClassLoaddingException, Throwables.Predicate<? super Class<?>, E> predicate) throws UncheckedIOException, E {
        if (logger.isInfoEnabled()) {
            logger.info("Looking for classes in package: " + pkgName);
        }
        String pkgPath = ClassUtil.packageName2FilePath(pkgName);
        List<URL> resourceList = ClassUtil.getResources(pkgName);
        if (N.isNullOrEmpty(resourceList)) {
            throw new IllegalArgumentException("No resource found by package " + pkgName);
        }
        ArrayList classes = new ArrayList();
        for (URL resource : resourceList) {
            File file;
            String fullPath = resource.getPath().replace("%20", " ").replaceFirst("[.]jar[!].*", JAR_POSTFIX).replaceFirst("file:", "");
            if (logger.isInfoEnabled()) {
                logger.info("ClassDiscovery: FullPath = " + fullPath);
            }
            if ((file = new File(fullPath)).exists() && file.isDirectory()) {
                Object[] files = file.listFiles();
                if (N.isNullOrEmpty(files)) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (files[i] == null) continue;
                    if (((File)files[i]).isFile() && ((File)files[i]).getName().endsWith(CLASS_POSTFIX)) {
                        String className = pkgName + '.' + ((File)files[i]).getName().substring(0, ((File)files[i]).getName().length() - CLASS_POSTFIX.length());
                        try {
                            Class clazz = ClassUtil.forClass(className, false);
                            if (clazz.getCanonicalName() == null || !predicate.test(clazz)) continue;
                            classes.add(clazz);
                            continue;
                        }
                        catch (Throwable e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("ClassNotFoundException loading " + className);
                            }
                            if (skipClassLoaddingException) continue;
                            throw new RuntimeException("ClassNotFoundException loading " + className);
                        }
                    }
                    if (!((File)files[i]).isDirectory() || !isRecursive) continue;
                    String subPkgName = pkgName + '.' + ((File)files[i]).getName();
                    classes.addAll(ClassUtil.getClassesByPackage(subPkgName, isRecursive, skipClassLoaddingException, predicate));
                }
                continue;
            }
            if (!file.exists() || !file.getName().endsWith(JAR_POSTFIX)) continue;
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file.getPath());
                Enumeration<JarEntry> entries = jarFile.entries();
                JarEntry entry = null;
                String entryName = null;
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    entryName = entry.getName();
                    if (!entryName.startsWith(pkgPath)) continue;
                    if (entryName.endsWith(CLASS_POSTFIX) && entryName.indexOf("/", pkgPath.length()) < 0) {
                        String className = ClassUtil.filePath2PackageName(entryName).replace(CLASS_POSTFIX, "");
                        try {
                            Class clazz = ClassUtil.forClass(className, false);
                            if (clazz.getCanonicalName() == null || !clazz.getPackage().getName().equals(pkgName) && (!clazz.getPackage().getName().startsWith(pkgName) || !isRecursive) || !predicate.test(clazz)) continue;
                            classes.add(clazz);
                            continue;
                        }
                        catch (Throwable e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn("ClassNotFoundException loading " + className);
                            }
                            if (skipClassLoaddingException) continue;
                            IOUtil.close(jarFile);
                            jarFile = null;
                            throw new RuntimeException("ClassNotFoundException loading " + className);
                        }
                    }
                    if (!entry.isDirectory() || entryName.length() <= pkgPath.length() + 1 || !isRecursive) continue;
                    String subPkgName = ClassUtil.filePath2PackageName(entryName);
                    classes.addAll(ClassUtil.getClassesByPackage(subPkgName, isRecursive, skipClassLoaddingException, predicate));
                }
            }
            catch (IOException e) {
                try {
                    throw new UncheckedIOException(pkgName + " (" + file + ") does not appear to be a valid package", e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(jarFile);
                    throw throwable;
                }
            }
            IOUtil.close(jarFile);
        }
        return classes;
    }

    private static String packageName2FilePath(String pkgName) {
        String pkgPath = pkgName.replace('.', '/');
        pkgPath = pkgPath.endsWith("/") ? pkgPath : pkgPath + "/";
        return pkgPath;
    }

    private static List<URL> getResources(String pkgName) {
        ArrayList<URL> resourceList = new ArrayList<URL>();
        String pkgPath = ClassUtil.packageName2FilePath(pkgName);
        ClassLoader localClassLoader = ClassUtil.class.getClassLoader();
        ClassLoader sysClassLoader = ClassLoader.getSystemClassLoader();
        try {
            Enumeration<URL> resources = localClassLoader.getResources(pkgPath);
            while (resources != null && resources.hasMoreElements()) {
                resourceList.add(resources.nextElement());
            }
            if (N.isNullOrEmpty(resourceList)) {
                resources = sysClassLoader.getResources(pkgPath);
                while (resources != null && resources.hasMoreElements()) {
                    resourceList.add(resources.nextElement());
                }
            }
            if (N.isNullOrEmpty(resourceList)) {
                resources = localClassLoader.getResources(pkgName);
                while (resources != null && resources.hasMoreElements()) {
                    resourceList.add(resources.nextElement());
                }
            }
            if (N.isNullOrEmpty(resourceList)) {
                resources = sysClassLoader.getResources(pkgName);
                while (resources != null && resources.hasMoreElements()) {
                    resourceList.add(resources.nextElement());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (logger.isInfoEnabled()) {
            logger.info("Found resources: " + resourceList + " by package name(" + pkgName + ")");
        }
        return resourceList;
    }

    private static String filePath2PackageName(String entryName) {
        String pkgName = entryName.replace('/', '.').replace('\\', '.');
        pkgName = pkgName.endsWith(PROP_NAME_SEPARATOR) ? pkgName.substring(0, pkgName.length() - 1) : pkgName;
        return pkgName;
    }

    public static String getClassName(Class<?> cls) {
        String clsName = nameClassPool.get(cls);
        if (clsName == null) {
            clsName = cls.getName();
            nameClassPool.put(cls, clsName);
        }
        return clsName;
    }

    public static String getSimpleClassName(Class<?> cls) {
        String clsName = simpleClassNamePool.get(cls);
        if (clsName == null) {
            clsName = cls.getSimpleName();
            simpleClassNamePool.put(cls, clsName);
        }
        return clsName;
    }

    public static String getCanonicalClassName(Class<?> cls) {
        String clsName = canonicalClassNamePool.get(cls);
        if (clsName == null) {
            clsName = cls.getCanonicalName();
            if (clsName == null) {
                clsName = cls.getName();
            }
            if (clsName != null) {
                canonicalClassNamePool.put(cls, clsName);
            }
        }
        return clsName;
    }

    public static Class<?> getEnclosingClass(Class<?> cls) {
        Class<?> enclosingClass = enclosingClassPool.get(cls);
        if (enclosingClass == null) {
            enclosingClass = cls.getEnclosingClass();
            if (enclosingClass == null) {
                enclosingClass = CLASS_MASK;
            }
            enclosingClassPool.put(cls, enclosingClass);
        }
        return enclosingClass == CLASS_MASK ? null : enclosingClass;
    }

    @SafeVarargs
    public static <T> Constructor<T> getDeclaredConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Map<Class<?>[], Constructor<?>> constructorPool = classDeclaredConstructorPool.get(cls);
        Constructor<Object> constructor = null;
        if (constructorPool != null) {
            constructor = constructorPool.get(parameterTypes);
        }
        if (constructor == null) {
            try {
                constructor = cls.getDeclaredConstructor(parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (constructor != null) {
                if (constructorPool == null) {
                    constructorPool = new ArrayHashMap(ConcurrentHashMap.class);
                    classDeclaredConstructorPool.put(cls, constructorPool);
                }
                constructorPool.put((Class<?>[])parameterTypes.clone(), constructor);
            }
        }
        return constructor;
    }

    @SafeVarargs
    public static Method getDeclaredMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Map<String, Map<Class<?>[], Method>> methodNamePool = classDeclaredMethodPool.get(cls);
        Map<Class<?>[], Method> methodPool = methodNamePool == null ? null : methodNamePool.get(methodName);
        Method method = null;
        if (methodPool != null) {
            method = methodPool.get(parameterTypes);
        }
        if (method == null && (method = ClassUtil.internalGetDeclaredMethod(cls, methodName, parameterTypes)) != null) {
            if (methodNamePool == null) {
                methodNamePool = new ConcurrentHashMap<String, Map<Class<?>[], Method>>();
                classDeclaredMethodPool.put(cls, methodNamePool);
            }
            if (methodPool == null) {
                methodPool = new ArrayHashMap<Class<?>[], Method>(ConcurrentHashMap.class);
                methodNamePool.put(methodName, methodPool);
            }
            methodPool.put((Class<?>[])parameterTypes.clone(), method);
        }
        return method;
    }

    static Method internalGetDeclaredMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = cls.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            Method[] methods;
            for (Method m : methods = cls.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(methodName) || !N.equals(parameterTypes, m.getParameterTypes())) continue;
                method = m;
                break;
            }
        }
        return method;
    }

    @SafeVarargs
    public static <T> T invokeConstructor(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw N.toRuntimeException(e);
        }
    }

    @SafeVarargs
    public static <T> T invokeMethod(Method method, Object ... args) {
        return ClassUtil.invokeMethod(null, method, args);
    }

    @SafeVarargs
    public static <T> T invokeMethod(Object instance, Method method, Object ... args) {
        try {
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static ImmutableList<String> getPropNameList(Class<?> cls) {
        ImmutableList<String> propNameList = entityDeclaredPropNameListPool.get(cls);
        if (propNameList == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            propNameList = entityDeclaredPropNameListPool.get(cls);
        }
        return propNameList;
    }

    public static List<String> getPropNamesExclusively(Class<?> cls, Set<String> propNameToExcluded) {
        ImmutableList<String> propNameList = ClassUtil.getPropNameList(cls);
        if (N.isNullOrEmpty(propNameToExcluded)) {
            return new ArrayList<String>(propNameList);
        }
        ArrayList<String> result = new ArrayList<String>(propNameList.size() - propNameToExcluded.size());
        for (String propName : propNameList) {
            if (propNameToExcluded.contains(propName)) continue;
            result.add(propName);
        }
        return result;
    }

    public static List<String> getPropNamesExclusively(Class<?> cls, Collection<String> propNameToExcluded) {
        if (N.isNullOrEmpty(propNameToExcluded)) {
            return new ArrayList<String>(ClassUtil.getPropNameList(cls));
        }
        if (propNameToExcluded instanceof Set) {
            return ClassUtil.getPropNamesExclusively(cls, (Set)propNameToExcluded);
        }
        return ClassUtil.getPropNamesExclusively(cls, N.newHashSet(propNameToExcluded));
    }

    public static List<String> getNonNullPropNames(Object entity) {
        return ClassUtil.getPropNames(entity, Fn.notNull());
    }

    public static <E extends Exception> List<String> getPropNames(Object entity, Throwables.Predicate<Object, E> propValueFilter) throws E {
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entity.getClass());
        int size = entityInfo.propInfoList.size();
        ArrayList<String> result = new ArrayList<String>(size < 10 ? size : size / 2);
        for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
            if (!propValueFilter.test(propInfo.getPropValue(result))) continue;
            result.add(propInfo.name);
        }
        return result;
    }

    public static <E extends Exception> List<String> getPropNames(Object entity, Throwables.BiPredicate<Object, com.landawn.abacus.type.Type<Object>, E> propValueFilter) throws E {
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entity.getClass());
        int size = entityInfo.propInfoList.size();
        ArrayList<String> result = new ArrayList<String>(size < 10 ? size : size / 2);
        for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
            if (!propValueFilter.test(propInfo.getPropValue(result), propInfo.type)) continue;
            result.add(propInfo.name);
        }
        return result;
    }

    public static ImmutableMap<String, Field> getPropFields(Class<?> cls) {
        ImmutableMap<String, Field> getterMethodList = entityDeclaredPropFieldPool.get(cls);
        if (getterMethodList == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            getterMethodList = entityDeclaredPropFieldPool.get(cls);
        }
        return getterMethodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getPropField(Class<?> cls, String propName) {
        Field field;
        Map<String, Field> propFieldMap = entityPropFieldPool.get(cls);
        if (propFieldMap == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            propFieldMap = entityPropFieldPool.get(cls);
        }
        if ((field = propFieldMap.get(propName)) == null) {
            if (!ClassUtil.isEntity(cls)) {
                throw new IllegalArgumentException("No property getter/setter method or public field found in the specified entity: " + ClassUtil.getCanonicalClassName(cls));
            }
            Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
            synchronized (map) {
                ImmutableMap<String, Method> getterMethodList = ClassUtil.getPropGetMethods(cls);
                for (String key : getterMethodList.keySet()) {
                    if (!ClassUtil.isPropName(cls, propName, key)) continue;
                    field = propFieldMap.get(key);
                    break;
                }
                if (field == null && !propName.equalsIgnoreCase(ClassUtil.formalizePropName(propName))) {
                    field = ClassUtil.getPropField(cls, ClassUtil.formalizePropName(propName));
                }
                if (field == null) {
                    field = FIELD_MASK;
                }
                propFieldMap.put(propName, field);
            }
        }
        return field == FIELD_MASK ? null : field;
    }

    public static ImmutableMap<String, Method> getPropGetMethods(Class<?> cls) {
        ImmutableMap<String, Method> getterMethodList = entityDeclaredPropGetMethodPool.get(cls);
        if (getterMethodList == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            getterMethodList = entityDeclaredPropGetMethodPool.get(cls);
        }
        return getterMethodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getPropGetMethod(Class<?> cls, String propName) {
        Method method;
        Map<String, Method> propGetMethodMap = entityPropGetMethodPool.get(cls);
        if (propGetMethodMap == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            propGetMethodMap = entityPropGetMethodPool.get(cls);
        }
        if ((method = propGetMethodMap.get(propName)) == null) {
            Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
            synchronized (map) {
                ImmutableMap<String, Method> getterMethodList = ClassUtil.getPropGetMethods(cls);
                for (String key : getterMethodList.keySet()) {
                    if (!ClassUtil.isPropName(cls, propName, key)) continue;
                    method = (Method)getterMethodList.get(key);
                    break;
                }
                if (method == null && !propName.equalsIgnoreCase(ClassUtil.formalizePropName(propName))) {
                    method = ClassUtil.getPropGetMethod(cls, ClassUtil.formalizePropName(propName));
                }
                if (method == null) {
                    method = METHOD_MASK;
                }
                propGetMethodMap.put(propName, method);
            }
        }
        return method == METHOD_MASK ? null : method;
    }

    public static ImmutableMap<String, Method> getPropSetMethods(Class<?> cls) {
        ImmutableMap<String, Method> setterMethodList = entityDeclaredPropSetMethodPool.get(cls);
        if (setterMethodList == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            setterMethodList = entityDeclaredPropSetMethodPool.get(cls);
        }
        return setterMethodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropGetSetMethodList(Class<?> cls) {
        Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
        synchronized (map) {
            if (entityDeclaredPropGetMethodPool.containsKey(cls)) {
                return;
            }
            Object instance = null;
            if (registeredXMLBindingClassList.containsKey(cls)) {
                block23: {
                    try {
                        instance = cls.newInstance();
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block23;
                        logger.warn("Failed to new instance of class: " + cls.getCanonicalName() + " to check setter method by getter method");
                    }
                }
                registeredXMLBindingClassList.put(cls, true);
            }
            LinkedHashMap<String, Field> propFieldMap = new LinkedHashMap<String, Field>();
            LinkedHashMap<String, Object> propGetMethodMap = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Method> propSetMethodMap = new LinkedHashMap<String, Method>();
            ArrayList allClasses = new ArrayList();
            allClasses.add(cls);
            Class superClass = null;
            while ((superClass = ((Class)allClasses.get(allClasses.size() - 1)).getSuperclass()) != null && !superClass.equals(Object.class)) {
                allClasses.add(superClass);
            }
            Class clazz = null;
            Method setMethod = null;
            for (int i = allClasses.size() - 1; i >= 0; --i) {
                clazz = (Class)allClasses.get(i);
                if (registeredNonEntityClass.containsKey(clazz)) continue;
                Map<String, String> staticFinalFields = ClassUtil.getPublicStaticStringFields(clazz);
                String propName = null;
                for (Field field : clazz.getDeclaredFields()) {
                    for (Method method : clazz.getMethods()) {
                        if (!ClassUtil.isFieldGetMethod(method, field)) continue;
                        propName = ClassUtil.getPropNameByMethod(method);
                        if (!field.equals(ClassUtil.getDeclaredField(clazz, propName))) {
                            propName = field.getName();
                        }
                        String string = propName = staticFinalFields.get(propName) != null ? staticFinalFields.get(propName) : propName;
                        if (propGetMethodMap.containsKey(propName)) break;
                        setMethod = ClassUtil.getSetMethod(method);
                        if (setMethod != null) {
                            ClassUtil.setAccessibleQuietly(method, true);
                            ClassUtil.setAccessibleQuietly(setMethod, true);
                            propFieldMap.put(propName, field);
                            propGetMethodMap.put(propName, method);
                            propSetMethodMap.put(propName, setMethod);
                            break;
                        }
                        if (!ClassUtil.isJAXBGetMethod(instance, method)) continue;
                        ClassUtil.setAccessibleQuietly(method, true);
                        ClassUtil.setAccessibleQuietly(setMethod, true);
                        propFieldMap.put(propName, field);
                        propGetMethodMap.put(propName, method);
                        break;
                    }
                    if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                    propName = field.getName();
                    String string = propName = staticFinalFields.get(propName) != null ? staticFinalFields.get(propName) : propName;
                    if (propGetMethodMap.containsKey(propName)) continue;
                    ClassUtil.setAccessibleQuietly(field, true);
                    propFieldMap.put(propName, field);
                }
                for (Method method : clazz.getMethods()) {
                    if (!ClassUtil.isGetMethod(method)) continue;
                    propName = ClassUtil.getPropNameByMethod(method);
                    String string = propName = staticFinalFields.get(propName) != null ? staticFinalFields.get(propName) : propName;
                    if (propGetMethodMap.containsKey(propName)) continue;
                    setMethod = ClassUtil.getSetMethod(method);
                    if (setMethod != null && !propGetMethodMap.containsValue(method)) {
                        ClassUtil.setAccessibleQuietly(method, true);
                        ClassUtil.setAccessibleQuietly(setMethod, true);
                        propGetMethodMap.put(propName, method);
                        propSetMethodMap.put(propName, setMethod);
                        continue;
                    }
                    if (!ClassUtil.isJAXBGetMethod(instance, method) || propGetMethodMap.containsValue(method)) continue;
                    ClassUtil.setAccessibleQuietly(method, true);
                    propGetMethodMap.put(propName, method);
                }
            }
            for (Class<?> key : registeredNonPropGetSetMethodPool.keySet()) {
                if (!key.isAssignableFrom(cls)) continue;
                Set<String> set = registeredNonPropGetSetMethodPool.get(key);
                ArrayList methodNames = new ArrayList(propGetMethodMap.keySet());
                block11: for (String nonPropName : set) {
                    for (String propName : methodNames) {
                        if (!propName.equalsIgnoreCase(nonPropName)) continue;
                        propFieldMap.remove(propName);
                        propGetMethodMap.remove(propName);
                        propSetMethodMap.remove(propName);
                        continue block11;
                    }
                }
            }
            ImmutableMap unmodifiableFieldMap = ImmutableMap.of(propFieldMap);
            unmodifiableFieldMap.keySet();
            entityDeclaredPropFieldPool.put(cls, unmodifiableFieldMap);
            ObjectPool<String, Field> tempFieldMap = new ObjectPool<String, Field>(N.max(64, propFieldMap.size()));
            tempFieldMap.putAll(propFieldMap);
            entityPropFieldPool.put(cls, tempFieldMap);
            ImmutableMap unmodifiableGetMethodMap = ImmutableMap.of(propGetMethodMap);
            unmodifiableGetMethodMap.keySet();
            entityDeclaredPropGetMethodPool.put(cls, unmodifiableGetMethodMap);
            if (entityPropGetMethodPool.get(cls) == null) {
                ObjectPool<String, Object> tmp = new ObjectPool<String, Object>(N.max(64, propGetMethodMap.size()));
                tmp.putAll(propGetMethodMap);
                entityPropGetMethodPool.put(cls, tmp);
            } else {
                entityPropGetMethodPool.get(cls).putAll(propGetMethodMap);
            }
            ImmutableMap unmodifiableSetMethodMap = ImmutableMap.of(propSetMethodMap);
            unmodifiableSetMethodMap.keySet();
            entityDeclaredPropSetMethodPool.put(cls, unmodifiableSetMethodMap);
            if (entityPropSetMethodPool.get(cls) == null) {
                ObjectPool<String, Method> tmp = new ObjectPool<String, Method>(N.max(64, propSetMethodMap.size()));
                tmp.putAll(propSetMethodMap);
                entityPropSetMethodPool.put(cls, tmp);
            } else {
                entityPropSetMethodPool.get(cls).putAll(propSetMethodMap);
            }
            ArrayList propNameList = new ArrayList(propFieldMap.keySet());
            for (String propName : propGetMethodMap.keySet()) {
                if (propNameList.contains(propName)) continue;
                propNameList.add(propName);
            }
            entityDeclaredPropNameListPool.put(cls, ImmutableList.of(propNameList));
        }
    }

    private static boolean isGetMethod(Method method) {
        String mn = method.getName();
        return (mn.startsWith(GET) || mn.startsWith(IS) || mn.startsWith(HAS) || ClassUtil.getDeclaredField(method.getDeclaringClass(), mn) != null) && N.isNullOrEmpty(method.getParameterTypes()) && !Void.TYPE.equals(method.getReturnType()) && !nonGetSetMethodName.contains(mn);
    }

    static boolean isFieldGetMethod(Method method, Field field) {
        if (!ClassUtil.isGetMethod(method)) {
            return false;
        }
        if (!method.getReturnType().isAssignableFrom(field.getType())) {
            return false;
        }
        String methodName = method.getName();
        if (ClassUtil.getDeclaredField(method.getDeclaringClass(), methodName) != null) {
            return true;
        }
        String fieldName = field.getName();
        String propName = methodName.substring(methodName.startsWith(IS) ? 2 : (methodName.startsWith(HAS) || methodName.startsWith(GET) || methodName.startsWith(SET) ? 3 : 0));
        return propName.equalsIgnoreCase(fieldName) || fieldName.charAt(0) == '_' && propName.equalsIgnoreCase(fieldName.substring(1));
    }

    static boolean isJAXBGetMethod(Object instance, Method method) {
        try {
            return instance != null && (Collection.class.isAssignableFrom(method.getReturnType()) || Map.class.isAssignableFrom(method.getReturnType())) && ClassUtil.invokeMethod(instance, method, new Object[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isSetMethod(Method method) {
        String mn = method.getName();
        return !(!mn.startsWith(SET) && ClassUtil.getDeclaredField(method.getDeclaringClass(), mn) == null || N.len(method.getParameterTypes()) != 1 || !Void.TYPE.equals(method.getReturnType()) && !method.getReturnType().isAssignableFrom(method.getDeclaringClass()) || nonGetSetMethodName.contains(mn));
    }

    private static Method getSetMethod(Method getMethod) {
        Class<?> declaringClass = getMethod.getDeclaringClass();
        String getMethodName = getMethod.getName();
        String setMethodName = SET + getMethodName.substring(getMethodName.startsWith(IS) ? 2 : (getMethodName.startsWith(HAS) || getMethodName.startsWith(GET) ? 3 : 0));
        Method setMethod = ClassUtil.internalGetDeclaredMethod(declaringClass, setMethodName, getMethod.getReturnType());
        if (setMethod == null && ClassUtil.getDeclaredField(declaringClass, getMethodName) != null) {
            setMethod = ClassUtil.internalGetDeclaredMethod(declaringClass, getMethodName, getMethod.getReturnType());
        }
        return setMethod != null && (Void.TYPE.equals(setMethod.getReturnType()) || setMethod.getReturnType().isAssignableFrom(setMethod.getDeclaringClass())) ? setMethod : null;
    }

    private static <T> Map<String, String> getPublicStaticStringFields(Class<T> cls) {
        HashMap<String, String> statisFinalFields = new HashMap<String, String>();
        for (Field field : cls.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !String.class.equals(field.getType())) continue;
            try {
                String value = (String)field.get(null);
                statisFinalFields.put(value, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return statisFinalFields;
    }

    static boolean isPropName(Class<?> cls, String inputPropName, String propNameByMethod) {
        if (inputPropName.length() > 128) {
            throw new IllegalArgumentException("The property name execeed 128: " + inputPropName);
        }
        return (inputPropName = inputPropName.trim()).equalsIgnoreCase(propNameByMethod) || inputPropName.replace("_", N.EMPTY_STRING).equalsIgnoreCase(propNameByMethod) || inputPropName.equalsIgnoreCase(ClassUtil.getSimpleClassName(cls) + '.' + propNameByMethod) || inputPropName.startsWith(GET) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(SET) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(IS) && inputPropName.substring(2).equalsIgnoreCase(propNameByMethod) || inputPropName.startsWith(HAS) && inputPropName.substring(3).equalsIgnoreCase(propNameByMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getPropSetMethod(Class<?> cls, String propName) {
        Method method;
        Map<String, Method> propSetMethodMap = entityPropSetMethodPool.get(cls);
        if (propSetMethodMap == null) {
            ClassUtil.loadPropGetSetMethodList(cls);
            propSetMethodMap = entityPropSetMethodPool.get(cls);
        }
        if ((method = propSetMethodMap.get(propName)) == null) {
            Map<Class<?>, ImmutableMap<String, Method>> map = entityDeclaredPropGetMethodPool;
            synchronized (map) {
                ImmutableMap<String, Method> setterMethodList = ClassUtil.getPropSetMethods(cls);
                for (String key : setterMethodList.keySet()) {
                    if (!ClassUtil.isPropName(cls, propName, key)) continue;
                    method = propSetMethodMap.get(key);
                    break;
                }
                if (method == null && !propName.equalsIgnoreCase(ClassUtil.formalizePropName(propName))) {
                    method = ClassUtil.getPropSetMethod(cls, ClassUtil.formalizePropName(propName));
                }
                if (method == null) {
                    method = METHOD_MASK;
                }
                propSetMethodMap.put(propName, method);
            }
        }
        return method == METHOD_MASK ? null : method;
    }

    public static <T> T getPropValue(Object entity, Method propGetMethod) {
        try {
            return (T)propGetMethod.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw N.toRuntimeException(e);
        }
    }

    public static void setPropValue(Object entity, Method propSetMethod, Object propValue) {
        if (propValue == null) {
            try {
                propSetMethod.invoke(entity, N.defaultValueOf(propSetMethod.getParameterTypes()[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw N.toRuntimeException(e);
            }
        }
        try {
            propSetMethod.invoke(entity, propValue);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            if (logger.isWarnEnabled()) {
                logger.warn((Throwable)e, "Failed to set property value by method: " + propSetMethod);
            }
            propValue = N.convert(propValue, ParserUtil.getEntityInfo(entity.getClass()).getPropInfo((String)propSetMethod.getName()).jsonXmlType);
            try {
                propSetMethod.invoke(entity, propValue);
            }
            catch (IllegalAccessException | InvocationTargetException e2) {
                throw N.toRuntimeException(e);
            }
        }
    }

    public static void setPropValueByGet(Object entity, Method propGetMethod, Object propValue) {
        if (propValue == null) {
            return;
        }
        Object rt = ClassUtil.invokeMethod(entity, propGetMethod, new Object[0]);
        if (rt instanceof Collection) {
            Collection c = (Collection)rt;
            c.clear();
            c.addAll((Collection)propValue);
        } else if (rt instanceof Map) {
            Map m = (Map)rt;
            m.clear();
            m.putAll((Map)propValue);
        } else {
            throw new IllegalArgumentException("Failed to set property value by getter method '" + propGetMethod.getName() + "'");
        }
    }

    public static <T> T getPropValue(Object entity, String propName) {
        return ClassUtil.getPropValue(entity, propName, false);
    }

    public static <T> T getPropValue(Object entity, String propName, boolean ignoreUnmatchedProperty) {
        Class<?> cls = entity.getClass();
        ParserUtil.PropInfo propInfo = ParserUtil.getEntityInfo(cls).getPropInfo(propName);
        if (propInfo != null) {
            return propInfo.getPropValue(entity);
        }
        Map<String, List<Method>> inlinePropGetMethodMap = entityInlinePropGetMethodPool.get(cls);
        List<Method> inlinePropGetMethodQueue = null;
        if (inlinePropGetMethodMap == null) {
            inlinePropGetMethodMap = new ObjectPool<String, List<Method>>(ClassUtil.getPropNameList(cls).size());
            entityInlinePropGetMethodPool.put(cls, inlinePropGetMethodMap);
        } else {
            inlinePropGetMethodQueue = inlinePropGetMethodMap.get(propName);
        }
        if (inlinePropGetMethodQueue == null) {
            inlinePropGetMethodQueue = new ArrayList<Method>();
            String[] strs = Splitter.with(PROP_NAME_SEPARATOR).splitToArray(propName);
            if (strs.length > 1) {
                Class<?> targetClass = cls;
                for (String str : strs) {
                    Method method = ClassUtil.getPropGetMethod(targetClass, str);
                    if (method == null) {
                        inlinePropGetMethodQueue.clear();
                        break;
                    }
                    inlinePropGetMethodQueue.add(method);
                    targetClass = method.getReturnType();
                }
            }
            inlinePropGetMethodMap.put(propName, inlinePropGetMethodQueue);
        }
        if (inlinePropGetMethodQueue.size() == 0) {
            if (ignoreUnmatchedProperty) {
                return null;
            }
            throw new IllegalArgumentException("No property method found with property name: " + propName + " in class " + ClassUtil.getCanonicalClassName(cls));
        }
        Object propEntity = entity;
        int len = inlinePropGetMethodQueue.size();
        for (int i = 0; i < len; ++i) {
            if ((propEntity = ClassUtil.getPropValue(propEntity, inlinePropGetMethodQueue.get(i))) != null) continue;
            return (T)N.defaultValueOf(inlinePropGetMethodQueue.get(len - 1).getReturnType());
        }
        return (T)propEntity;
    }

    @Deprecated
    public static void setPropValue(Object entity, String propName, Object propValue) {
        ClassUtil.setPropValue(entity, propName, propValue, false);
    }

    @Deprecated
    public static boolean setPropValue(Object entity, String propName, Object propValue, boolean ignoreUnmatchedProperty) {
        return ParserUtil.getEntityInfo(entity.getClass()).setPropValue(entity, propName, propValue, ignoreUnmatchedProperty);
    }

    public static String getPropNameByMethod(Method getSetMethod) {
        String propName = methodPropNamePool.get(getSetMethod);
        if (propName == null) {
            String methodName = getSetMethod.getName();
            Object[] paramTypes = getSetMethod.getParameterTypes();
            Object targetType = N.isNullOrEmpty(paramTypes) ? getSetMethod.getReturnType() : paramTypes[0];
            Field field = ClassUtil.getDeclaredField(getSetMethod.getDeclaringClass(), methodName);
            if (field != null && field.getType().isAssignableFrom((Class<?>)targetType)) {
                propName = field.getName();
            }
            if ((field = ClassUtil.getDeclaredField(getSetMethod.getDeclaringClass(), "_" + methodName)) != null && field.getType().isAssignableFrom((Class<?>)targetType)) {
                propName = field.getName();
            }
            if (N.isNullOrEmpty(propName) && (methodName.startsWith(IS) && methodName.length() > 2 || (methodName.startsWith(GET) || methodName.startsWith(SET) || methodName.startsWith(HAS)) && methodName.length() > 3)) {
                String newName = methodName.substring(methodName.startsWith(IS) ? 2 : 3);
                field = ClassUtil.getDeclaredField(getSetMethod.getDeclaringClass(), StringUtil.uncapitalize(newName));
                if (field != null && field.getType().isAssignableFrom((Class<?>)targetType)) {
                    propName = field.getName();
                }
                if (N.isNullOrEmpty(propName) && newName.charAt(0) != '_' && (field = ClassUtil.getDeclaredField(getSetMethod.getDeclaringClass(), "_" + StringUtil.uncapitalize(newName))) != null && field.getType().isAssignableFrom((Class<?>)targetType)) {
                    propName = field.getName();
                }
                if (N.isNullOrEmpty(propName) && (field = ClassUtil.getDeclaredField(getSetMethod.getDeclaringClass(), ClassUtil.formalizePropName(newName))) != null && field.getType().isAssignableFrom((Class<?>)targetType)) {
                    propName = field.getName();
                }
                if (N.isNullOrEmpty(propName) && newName.charAt(0) != '_' && (field = ClassUtil.getDeclaredField(getSetMethod.getDeclaringClass(), "_" + ClassUtil.formalizePropName(newName))) != null && field.getType().isAssignableFrom((Class<?>)targetType)) {
                    propName = field.getName();
                }
                if (N.isNullOrEmpty(propName)) {
                    propName = ClassUtil.formalizePropName(newName);
                }
            }
            if (N.isNullOrEmpty(propName)) {
                propName = methodName;
            }
            methodPropNamePool.put(getSetMethod, propName);
        }
        return propName;
    }

    private static Field getDeclaredField(Class<?> cls, String fieldName) {
        try {
            return cls.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException exception) {
            return null;
        }
    }

    public static String formalizePropName(String propName) {
        String newPropName = formalizedPropNamePool.get(propName);
        if (newPropName == null) {
            newPropName = ClassUtil.toCamelCase(propName);
            for (String keyWord : keyWordMapper.keySet()) {
                if (!keyWord.equalsIgnoreCase(newPropName)) continue;
                newPropName = keyWordMapper.get(keyWord);
                break;
            }
            formalizedPropNamePool.put(propName, newPropName);
        }
        return newPropName;
    }

    public static String toCamelCase(String propName) {
        String newPropName = camelCasePropNamePool.get(propName);
        if (newPropName == null) {
            newPropName = StringUtil.toCamelCase(propName);
            newPropName = NameUtil.getCachedName(newPropName);
            camelCasePropNamePool.put(propName, newPropName);
        }
        return newPropName;
    }

    public static void toCamelCase(Map<String, Object> props) {
        Map<String, Object> tmp = Objectory.createLinkedHashMap();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            tmp.put(ClassUtil.toCamelCase(entry.getKey()), entry.getValue());
        }
        props.clear();
        props.putAll(tmp);
        Objectory.recycle(tmp);
    }

    public static String toLowerCaseWithUnderscore(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        String result = lowerCaseWithUnderscorePropNamePool.get(str);
        if (result == null) {
            result = StringUtil.toLowerCaseWithUnderscore(str);
            lowerCaseWithUnderscorePropNamePool.put(str, result);
        }
        return result;
    }

    public static void toLowerCaseKeyWithUnderscore(Map<String, Object> props) {
        Map<String, Object> tmp = Objectory.createLinkedHashMap();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            tmp.put(ClassUtil.toLowerCaseWithUnderscore(entry.getKey()), entry.getValue());
        }
        props.clear();
        props.putAll(tmp);
        Objectory.recycle(tmp);
    }

    public static String toUpperCaseWithUnderscore(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        String result = upperCaseWithUnderscorePropNamePool.get(str);
        if (result == null) {
            result = StringUtil.toUpperCaseWithUnderscore(str);
            upperCaseWithUnderscorePropNamePool.put(str, result);
        }
        return result;
    }

    public static void toUpperCaseKeyWithUnderscore(Map<String, Object> props) {
        Map<String, Object> tmp = Objectory.createLinkedHashMap();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            tmp.put(ClassUtil.toUpperCaseWithUnderscore(entry.getKey()), entry.getValue());
        }
        props.clear();
        props.putAll(tmp);
        Objectory.recycle(tmp);
    }

    @Deprecated
    @Internal
    @Immutable
    public static List<String> getIdFieldNames(Class<?> targetClass) {
        return ClassUtil.getIdFieldNames(targetClass, false);
    }

    @Deprecated
    @Internal
    @Immutable
    public static List<String> getIdFieldNames(Class<?> targetClass, boolean fakeIdForEmpty) {
        ImmutableList<String> idPropNames = idPropNamesMap.get(targetClass);
        if (idPropNames == null) {
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(targetClass);
            Set idPropNameSet = N.newLinkedHashSet();
            for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
                if (propInfo.isAnnotationPresent(Id.class) || propInfo.isAnnotationPresent(ReadOnlyId.class)) {
                    idPropNameSet.add(propInfo.name);
                    continue;
                }
                try {
                    if (!propInfo.isAnnotationPresent(javax.persistence.Id.class)) continue;
                    idPropNameSet.add(propInfo.name);
                }
                catch (Throwable throwable) {}
            }
            if (targetClass.isAnnotationPresent(Id.class)) {
                String[] values = targetClass.getAnnotation(Id.class).value();
                N.checkArgNotNullOrEmpty(values, "values for annotation @Id on Type/Class can't be null or empty");
                idPropNameSet.addAll(Arrays.asList(values));
            }
            if (N.isNullOrEmpty(idPropNameSet)) {
                ParserUtil.PropInfo idPropInfo = entityInfo.getPropInfo("id");
                Set<Class<UUID>> idType = N.asSet(Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Timestamp.class, UUID.class);
                if (idPropInfo != null && idType.contains(idPropInfo.clazz)) {
                    idPropNameSet.add(idPropInfo.name);
                }
            }
            idPropNames = ImmutableList.copyOf(idPropNameSet);
            idPropNamesMap.put(targetClass, idPropNames);
        }
        return N.isNullOrEmpty(idPropNames) && fakeIdForEmpty ? fakeIds : idPropNames;
    }

    @Deprecated
    @Internal
    public static boolean isFakeId(List<String> idPropNames) {
        return idPropNames != null && idPropNames.size() == 1 && fakeIds.get(0).equals(idPropNames.get(0));
    }

    static String makePackageFolder(String srcPath, String pkgName) {
        srcPath = srcPath.endsWith("/") || srcPath.endsWith("\\") ? srcPath : srcPath + File.separator;
        String classFilePath = pkgName == null ? srcPath : srcPath + pkgName.replace('.', File.separatorChar) + File.separator;
        File classFileFolder = new File(classFilePath);
        if (!classFileFolder.exists()) {
            classFileFolder.mkdirs();
        }
        return classFilePath;
    }

    public static void setAccessible(AccessibleObject accessibleObject, boolean flag) {
        if (accessibleObject != null && accessibleObject.isAccessible() != flag) {
            accessibleObject.setAccessible(flag);
        }
    }

    public static boolean setAccessibleQuietly(AccessibleObject accessibleObject, boolean flag) {
        if (accessibleObject == null) {
            return false;
        }
        if (accessibleObject.isAccessible() == flag) {
            return true;
        }
        try {
            accessibleObject.setAccessible(flag);
        }
        catch (Exception e) {
            logger.warn("Failed to set accessible for : " + accessibleObject + " with flag: " + flag, (Throwable)e);
            return false;
        }
        return true;
    }

    public static MethodHandle createMethodHandle(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        try {
            return MethodHandles.lookup().in(declaringClass).unreflectSpecial(method, declaringClass);
        }
        catch (Exception e) {
            try {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                ClassUtil.setAccessible(constructor, true);
                return ((MethodHandles.Lookup)constructor.newInstance(declaringClass)).in(declaringClass).unreflectSpecial(method, declaringClass);
            }
            catch (Exception ex) {
                try {
                    return MethodHandles.lookup().findSpecial(declaringClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), declaringClass);
                }
                catch (Exception exx) {
                    throw new UnsupportedOperationException(exx);
                }
            }
        }
    }

    public static ImmutableMap<String, String> getColumn2PropNameMap(Class<?> entityClass) {
        ImmutableMap<String, String> result = column2PropNameNameMapPool.get(entityClass);
        if (result == null) {
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
            Map<String, String> map = N.newHashMap(entityInfo.propInfoList.size() * 3);
            for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
                if (!propInfo.columnName.isPresent()) continue;
                map.put(propInfo.columnName.get(), propInfo.name);
                map.put(propInfo.columnName.get().toLowerCase(), propInfo.name);
                map.put(propInfo.columnName.get().toUpperCase(), propInfo.name);
            }
            result = ImmutableMap.copyOf(map);
            column2PropNameNameMapPool.put(entityClass, result);
        }
        return result;
    }

    public static ImmutableMap<String, String> getProp2ColumnNameMap(Class<?> entityClass, NamingPolicy namingPolicy) {
        if (entityClass == null || Map.class.isAssignableFrom(entityClass)) {
            return ImmutableMap.empty();
        }
        Map<NamingPolicy, ImmutableMap<String, String>> namingColumnNameMap = entityTablePropColumnNameMap.get(entityClass);
        ImmutableMap<String, String> result = null;
        if (namingColumnNameMap == null || (result = namingColumnNameMap.get((Object)namingPolicy)) == null) {
            result = ClassUtil.registerEntityPropColumnNameMap(entityClass, namingPolicy, null);
        }
        return result;
    }

    static ImmutableMap<String, String> registerEntityPropColumnNameMap(Class<?> entityClass, NamingPolicy namingPolicy, Set<Class<?>> registeringClasses) {
        N.checkArgNotNull(entityClass);
        if (registeringClasses != null) {
            if (registeringClasses.contains(entityClass)) {
                throw new RuntimeException("Cycling references found among: " + registeringClasses);
            }
            registeringClasses.add(entityClass);
        }
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
        Map<String, String> propColumnNameMap = N.newHashMap(entityInfo.propInfoList.size() * 2);
        for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
            if (propInfo.columnName.isPresent()) {
                propColumnNameMap.put(propInfo.name, propInfo.columnName.get());
                continue;
            }
            propColumnNameMap.put(propInfo.name, SQLBuilder.formalizeColumnName(propInfo.name, namingPolicy));
            com.landawn.abacus.type.Type<Object> propType = propInfo.type.isCollection() ? propInfo.type.getElementType() : propInfo.type;
            if (!propType.isEntity() || registeringClasses != null && registeringClasses.contains(propType.clazz())) continue;
            Set<Object> newRegisteringClasses = registeringClasses == null ? N.newLinkedHashSet() : registeringClasses;
            newRegisteringClasses.add(entityClass);
            ImmutableMap<String, String> subPropColumnNameMap = ClassUtil.registerEntityPropColumnNameMap(propType.clazz(), namingPolicy, newRegisteringClasses);
            if (!N.notNullOrEmpty(subPropColumnNameMap)) continue;
            String subTableName = SQLBuilder.getTableName(propType.clazz(), namingPolicy);
            for (Map.Entry entry : subPropColumnNameMap.entrySet()) {
                propColumnNameMap.put(propInfo.name + PROP_NAME_SEPARATOR + (String)entry.getKey(), subTableName + PROP_NAME_SEPARATOR + (String)entry.getValue());
            }
        }
        if (N.isNullOrEmpty(propColumnNameMap)) {
            propColumnNameMap = N.emptyMap();
        }
        ImmutableMap<String, String> result = ImmutableMap.of(propColumnNameMap);
        Map<NamingPolicy, ImmutableMap<String, String>> namingPropColumnMap = entityTablePropColumnNameMap.get(entityClass);
        if (namingPropColumnMap == null) {
            namingPropColumnMap = new EnumMap<NamingPolicy, ImmutableMap<String, String>>(NamingPolicy.class);
            entityTablePropColumnNameMap.put(entityClass, namingPropColumnMap);
        }
        namingPropColumnMap.put(namingPolicy, result);
        return result;
    }

    public static ObjIterator<Class<?>> hierarchy(Class<?> type) {
        return ClassUtil.hierarchy(type, false);
    }

    public static ObjIterator<Class<?>> hierarchy(final Class<?> type, boolean includeInterface) {
        final ObjIterator superClassesIter = new ObjIterator<Class<?>>(){
            private final u.Holder<Class<?>> next;
            {
                this.next = new u.Holder<Class>(type);
            }

            @Override
            public boolean hasNext() {
                return this.next.value() != null;
            }

            @Override
            public Class<?> next() {
                Class result = (Class)this.next.value();
                this.next.setValue((Object)result.getSuperclass());
                return result;
            }
        };
        if (!includeInterface) {
            return superClassesIter;
        }
        return new ObjIterator<Class<?>>(){
            private final Set<Class<?>> seenInterfaces = new HashSet();
            private Iterator<Class<?>> interfacesIter = N.emptyIterator();

            @Override
            public boolean hasNext() {
                return this.interfacesIter.hasNext() || superClassesIter.hasNext();
            }

            @Override
            public Class<?> next() {
                if (this.interfacesIter.hasNext()) {
                    Class<?> nextInterface = this.interfacesIter.next();
                    this.seenInterfaces.add(nextInterface);
                    return nextInterface;
                }
                Class nextSuperclass = (Class)superClassesIter.next();
                LinkedHashSet currentInterfaces = new LinkedHashSet();
                this.walkInterfaces(currentInterfaces, nextSuperclass);
                this.interfacesIter = currentInterfaces.iterator();
                return nextSuperclass;
            }

            private void walkInterfaces(Set<Class<?>> addTo, Class<?> c) {
                for (Class<?> iface : c.getInterfaces()) {
                    if (!this.seenInterfaces.contains(iface)) {
                        addTo.add(iface);
                    }
                    this.walkInterfaces(addTo, iface);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int distanceOfInheritance(Class<?> child, Class<?> parent) {
        int d;
        if (child == null || parent == null) {
            return -1;
        }
        if (child.equals(parent)) {
            return 0;
        }
        Class<?> cParent = child.getSuperclass();
        int n = d = parent.equals(cParent) ? 1 : 0;
        if (d == 1) {
            return d;
        }
        return (d += ClassUtil.distanceOfInheritance(cParent, parent)) > 0 ? d + 1 : -1;
    }

    static {
        BUILT_IN_TYPE.put(Boolean.TYPE.getCanonicalName(), Boolean.TYPE);
        BUILT_IN_TYPE.put(Character.TYPE.getCanonicalName(), Character.TYPE);
        BUILT_IN_TYPE.put(Byte.TYPE.getCanonicalName(), Byte.TYPE);
        BUILT_IN_TYPE.put(Short.TYPE.getCanonicalName(), Short.TYPE);
        BUILT_IN_TYPE.put(Integer.TYPE.getCanonicalName(), Integer.TYPE);
        BUILT_IN_TYPE.put(Long.TYPE.getCanonicalName(), Long.TYPE);
        BUILT_IN_TYPE.put(Float.TYPE.getCanonicalName(), Float.TYPE);
        BUILT_IN_TYPE.put(Double.TYPE.getCanonicalName(), Double.TYPE);
        BUILT_IN_TYPE.put(Boolean.class.getCanonicalName(), Boolean.class);
        BUILT_IN_TYPE.put(Character.class.getCanonicalName(), Character.class);
        BUILT_IN_TYPE.put(Byte.class.getCanonicalName(), Byte.class);
        BUILT_IN_TYPE.put(Short.class.getCanonicalName(), Short.class);
        BUILT_IN_TYPE.put(Integer.class.getCanonicalName(), Integer.class);
        BUILT_IN_TYPE.put(Long.class.getCanonicalName(), Long.class);
        BUILT_IN_TYPE.put(Float.class.getCanonicalName(), Float.class);
        BUILT_IN_TYPE.put(Double.class.getCanonicalName(), Double.class);
        BUILT_IN_TYPE.put(String.class.getCanonicalName(), String.class);
        BUILT_IN_TYPE.put(Enum.class.getCanonicalName(), Enum.class);
        BUILT_IN_TYPE.put(Class.class.getCanonicalName(), Class.class);
        BUILT_IN_TYPE.put(Object.class.getCanonicalName(), Object.class);
        BUILT_IN_TYPE.put(BigInteger.class.getCanonicalName(), BigInteger.class);
        BUILT_IN_TYPE.put(BigDecimal.class.getCanonicalName(), BigDecimal.class);
        BUILT_IN_TYPE.put(Date.class.getCanonicalName(), Date.class);
        BUILT_IN_TYPE.put(Calendar.class.getCanonicalName(), Calendar.class);
        BUILT_IN_TYPE.put(GregorianCalendar.class.getCanonicalName(), GregorianCalendar.class);
        BUILT_IN_TYPE.put(XMLGregorianCalendar.class.getCanonicalName(), XMLGregorianCalendar.class);
        BUILT_IN_TYPE.put(Collection.class.getCanonicalName(), Collection.class);
        BUILT_IN_TYPE.put(List.class.getCanonicalName(), List.class);
        BUILT_IN_TYPE.put(ArrayList.class.getCanonicalName(), ArrayList.class);
        BUILT_IN_TYPE.put(LinkedList.class.getCanonicalName(), LinkedList.class);
        BUILT_IN_TYPE.put(Stack.class.getCanonicalName(), Stack.class);
        BUILT_IN_TYPE.put(Vector.class.getCanonicalName(), Vector.class);
        BUILT_IN_TYPE.put(Set.class.getCanonicalName(), Set.class);
        BUILT_IN_TYPE.put(HashSet.class.getCanonicalName(), HashSet.class);
        BUILT_IN_TYPE.put(LinkedHashSet.class.getCanonicalName(), LinkedHashSet.class);
        BUILT_IN_TYPE.put(SortedSet.class.getCanonicalName(), SortedSet.class);
        BUILT_IN_TYPE.put(NavigableSet.class.getCanonicalName(), NavigableSet.class);
        BUILT_IN_TYPE.put(TreeSet.class.getCanonicalName(), TreeSet.class);
        BUILT_IN_TYPE.put(Queue.class.getCanonicalName(), Queue.class);
        BUILT_IN_TYPE.put(Deque.class.getCanonicalName(), Deque.class);
        BUILT_IN_TYPE.put(BlockingDeque.class.getCanonicalName(), BlockingDeque.class);
        BUILT_IN_TYPE.put(ArrayDeque.class.getCanonicalName(), ArrayDeque.class);
        BUILT_IN_TYPE.put(ArrayBlockingQueue.class.getCanonicalName(), ArrayBlockingQueue.class);
        BUILT_IN_TYPE.put(LinkedBlockingQueue.class.getCanonicalName(), LinkedBlockingQueue.class);
        BUILT_IN_TYPE.put(ConcurrentLinkedQueue.class.getCanonicalName(), ConcurrentLinkedQueue.class);
        BUILT_IN_TYPE.put(LinkedBlockingDeque.class.getCanonicalName(), LinkedBlockingDeque.class);
        BUILT_IN_TYPE.put(ConcurrentLinkedDeque.class.getCanonicalName(), ConcurrentLinkedDeque.class);
        BUILT_IN_TYPE.put(PriorityQueue.class.getCanonicalName(), PriorityQueue.class);
        BUILT_IN_TYPE.put(DelayQueue.class.getCanonicalName(), DelayQueue.class);
        BUILT_IN_TYPE.put(Map.class.getCanonicalName(), Map.class);
        BUILT_IN_TYPE.put(HashMap.class.getCanonicalName(), HashMap.class);
        BUILT_IN_TYPE.put(LinkedHashMap.class.getCanonicalName(), LinkedHashMap.class);
        BUILT_IN_TYPE.put(IdentityHashMap.class.getCanonicalName(), IdentityHashMap.class);
        BUILT_IN_TYPE.put(ConcurrentMap.class.getCanonicalName(), ConcurrentMap.class);
        BUILT_IN_TYPE.put(ConcurrentHashMap.class.getCanonicalName(), ConcurrentHashMap.class);
        BUILT_IN_TYPE.put(SortedMap.class.getCanonicalName(), SortedMap.class);
        BUILT_IN_TYPE.put(NavigableMap.class.getCanonicalName(), NavigableMap.class);
        BUILT_IN_TYPE.put(TreeMap.class.getCanonicalName(), TreeMap.class);
        BUILT_IN_TYPE.put(Iterator.class.getCanonicalName(), Iterator.class);
        BUILT_IN_TYPE.put(File.class.getCanonicalName(), File.class);
        BUILT_IN_TYPE.put(InputStream.class.getCanonicalName(), InputStream.class);
        BUILT_IN_TYPE.put(ByteArrayInputStream.class.getCanonicalName(), ByteArrayInputStream.class);
        BUILT_IN_TYPE.put(FileInputStream.class.getCanonicalName(), FileInputStream.class);
        BUILT_IN_TYPE.put(OutputStream.class.getCanonicalName(), OutputStream.class);
        BUILT_IN_TYPE.put(ByteArrayOutputStream.class.getCanonicalName(), ByteArrayOutputStream.class);
        BUILT_IN_TYPE.put(FileOutputStream.class.getCanonicalName(), FileOutputStream.class);
        BUILT_IN_TYPE.put(Reader.class.getCanonicalName(), Reader.class);
        BUILT_IN_TYPE.put(StringReader.class.getCanonicalName(), StringReader.class);
        BUILT_IN_TYPE.put(FileReader.class.getCanonicalName(), FileReader.class);
        BUILT_IN_TYPE.put(InputStreamReader.class.getCanonicalName(), InputStreamReader.class);
        BUILT_IN_TYPE.put(Writer.class.getCanonicalName(), Writer.class);
        BUILT_IN_TYPE.put(StringWriter.class.getCanonicalName(), StringWriter.class);
        BUILT_IN_TYPE.put(FileWriter.class.getCanonicalName(), FileWriter.class);
        BUILT_IN_TYPE.put(OutputStreamWriter.class.getCanonicalName(), OutputStreamWriter.class);
        BUILT_IN_TYPE.put(java.sql.Date.class.getCanonicalName(), java.sql.Date.class);
        BUILT_IN_TYPE.put(Time.class.getCanonicalName(), Time.class);
        BUILT_IN_TYPE.put(Timestamp.class.getCanonicalName(), Timestamp.class);
        BUILT_IN_TYPE.put(Blob.class.getCanonicalName(), Blob.class);
        BUILT_IN_TYPE.put(Clob.class.getCanonicalName(), Clob.class);
        BUILT_IN_TYPE.put(NClob.class.getCanonicalName(), NClob.class);
        BUILT_IN_TYPE.put(SQLXML.class.getCanonicalName(), SQLXML.class);
        BUILT_IN_TYPE.put(RowId.class.getCanonicalName(), RowId.class);
        BUILT_IN_TYPE.put(URL.class.getCanonicalName(), URL.class);
        BUILT_IN_TYPE.put(MutableBoolean.class.getCanonicalName(), MutableBoolean.class);
        BUILT_IN_TYPE.put(MutableChar.class.getCanonicalName(), MutableChar.class);
        BUILT_IN_TYPE.put(MutableByte.class.getCanonicalName(), MutableByte.class);
        BUILT_IN_TYPE.put(MutableShort.class.getCanonicalName(), MutableShort.class);
        BUILT_IN_TYPE.put(MutableInt.class.getCanonicalName(), MutableInt.class);
        BUILT_IN_TYPE.put(MutableLong.class.getCanonicalName(), MutableLong.class);
        BUILT_IN_TYPE.put(MutableFloat.class.getCanonicalName(), MutableFloat.class);
        BUILT_IN_TYPE.put(MutableDouble.class.getCanonicalName(), MutableDouble.class);
        BUILT_IN_TYPE.put(u.OptionalBoolean.class.getCanonicalName(), u.OptionalBoolean.class);
        BUILT_IN_TYPE.put(u.OptionalChar.class.getCanonicalName(), u.OptionalChar.class);
        BUILT_IN_TYPE.put(u.OptionalByte.class.getCanonicalName(), u.OptionalByte.class);
        BUILT_IN_TYPE.put(u.OptionalShort.class.getCanonicalName(), u.OptionalShort.class);
        BUILT_IN_TYPE.put(u.OptionalInt.class.getCanonicalName(), u.OptionalInt.class);
        BUILT_IN_TYPE.put(u.OptionalLong.class.getCanonicalName(), u.OptionalLong.class);
        BUILT_IN_TYPE.put(u.OptionalFloat.class.getCanonicalName(), u.OptionalFloat.class);
        BUILT_IN_TYPE.put(u.OptionalDouble.class.getCanonicalName(), u.OptionalDouble.class);
        BUILT_IN_TYPE.put(u.Optional.class.getCanonicalName(), u.Optional.class);
        BUILT_IN_TYPE.put(u.Nullable.class.getCanonicalName(), u.Nullable.class);
        BUILT_IN_TYPE.put(Fraction.class.getCanonicalName(), Fraction.class);
        BUILT_IN_TYPE.put(Range.class.getCanonicalName(), Range.class);
        BUILT_IN_TYPE.put(Duration.class.getCanonicalName(), Duration.class);
        BUILT_IN_TYPE.put(Pair.class.getCanonicalName(), Pair.class);
        BUILT_IN_TYPE.put(Triple.class.getCanonicalName(), Triple.class);
        BUILT_IN_TYPE.put(Tuple.class.getCanonicalName(), Tuple.class);
        BUILT_IN_TYPE.put(Tuple.Tuple1.class.getCanonicalName(), Tuple.Tuple1.class);
        BUILT_IN_TYPE.put(Tuple.Tuple2.class.getCanonicalName(), Tuple.Tuple2.class);
        BUILT_IN_TYPE.put(Tuple.Tuple3.class.getCanonicalName(), Tuple.Tuple3.class);
        BUILT_IN_TYPE.put(Tuple.Tuple4.class.getCanonicalName(), Tuple.Tuple4.class);
        BUILT_IN_TYPE.put(Tuple.Tuple5.class.getCanonicalName(), Tuple.Tuple5.class);
        BUILT_IN_TYPE.put(Tuple.Tuple6.class.getCanonicalName(), Tuple.Tuple6.class);
        BUILT_IN_TYPE.put(Tuple.Tuple7.class.getCanonicalName(), Tuple.Tuple7.class);
        BUILT_IN_TYPE.put(Tuple.Tuple8.class.getCanonicalName(), Tuple.Tuple8.class);
        BUILT_IN_TYPE.put(Tuple.Tuple9.class.getCanonicalName(), Tuple.Tuple9.class);
        BUILT_IN_TYPE.put(ArrayHashMap.class.getCanonicalName(), ArrayHashMap.class);
        BUILT_IN_TYPE.put(LinkedArrayHashMap.class.getCanonicalName(), LinkedArrayHashMap.class);
        BUILT_IN_TYPE.put(ArrayHashSet.class.getCanonicalName(), ArrayHashSet.class);
        BUILT_IN_TYPE.put(LinkedArrayHashSet.class.getCanonicalName(), LinkedArrayHashSet.class);
        BUILT_IN_TYPE.put(BiMap.class.getCanonicalName(), BiMap.class);
        BUILT_IN_TYPE.put(ListMultimap.class.getCanonicalName(), ListMultimap.class);
        BUILT_IN_TYPE.put(SetMultimap.class.getCanonicalName(), SetMultimap.class);
        BUILT_IN_TYPE.put(Multimap.class.getCanonicalName(), Multimap.class);
        BUILT_IN_TYPE.put(Multiset.class.getCanonicalName(), Multiset.class);
        BUILT_IN_TYPE.put(com.landawn.abacus.type.Type.class.getCanonicalName(), com.landawn.abacus.type.Type.class);
        BUILT_IN_TYPE.put(DataSet.class.getCanonicalName(), DataSet.class);
        BUILT_IN_TYPE.put(RowDataSet.class.getCanonicalName(), RowDataSet.class);
        BUILT_IN_TYPE.put(Map.Entry.class.getCanonicalName(), Map.Entry.class);
        BUILT_IN_TYPE.put("java.util.Map.Entry", Map.Entry.class);
        BUILT_IN_TYPE.put("Map.Entry", Map.Entry.class);
        ArrayList classes = new ArrayList(BUILT_IN_TYPE.values());
        Iterator iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz;
            Class<?> arrayClass = clazz = (Class<?>)iterator.next();
            for (int i = 0; i < 7; ++i) {
                arrayClass = Array.newInstance(arrayClass, 0).getClass();
                BUILT_IN_TYPE.put(arrayClass.getCanonicalName(), arrayClass);
            }
        }
        classes = new ArrayList(BUILT_IN_TYPE.values());
        for (Class clazz : classes) {
            if (clazz.getCanonicalName().startsWith("java.util.Date")) continue;
            BUILT_IN_TYPE.put(clazz.getSimpleName(), clazz);
        }
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME = new HashMap<String, String>();
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Boolean.TYPE.getName(), "Z");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Character.TYPE.getName(), "C");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Byte.TYPE.getName(), "B");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Short.TYPE.getName(), "S");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Integer.TYPE.getName(), "I");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Long.TYPE.getName(), "J");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Float.TYPE.getName(), "F");
        SYMBOL_OF_PRIMITIVE_ARRAY_CLASS_NAME.put(Double.TYPE.getName(), "D");
        camelCasePropNamePool = new ObjectPool<String, String>(POOL_SIZE * 2);
        lowerCaseWithUnderscorePropNamePool = new ObjectPool<String, String>(POOL_SIZE * 2);
        upperCaseWithUnderscorePropNamePool = new ObjectPool<String, String>(POOL_SIZE * 2);
        registeredXMLBindingClassList = new ObjectPool(POOL_SIZE);
        registeredNonPropGetSetMethodPool = new ObjectPool(POOL_SIZE);
        entityDeclaredPropNameListPool = new ObjectPool(POOL_SIZE);
        entityDeclaredPropFieldPool = new ObjectPool(POOL_SIZE);
        entityPropFieldPool = new ObjectPool(POOL_SIZE);
        entityDeclaredPropGetMethodPool = new ObjectPool(POOL_SIZE);
        entityDeclaredPropSetMethodPool = new ObjectPool(POOL_SIZE);
        entityPropGetMethodPool = new ObjectPool(POOL_SIZE);
        entityPropSetMethodPool = new ObjectPool(POOL_SIZE);
        entityInlinePropGetMethodPool = new ObjectPool(POOL_SIZE);
        formalizedPropNamePool = new ObjectPool<String, String>(POOL_SIZE * 2);
        methodPropNamePool = new ObjectPool<Method, String>(POOL_SIZE * 2);
        keyWordMapper = new HashMap<String, String>(16);
        keyWordMapper.put("class", "clazz");
        nonGetSetMethodName = N.newHashSet(16);
        nonGetSetMethodName.add("getClass");
        nonGetSetMethodName.add("hashCode");
        packagePool = new ObjectPool(POOL_SIZE);
        packageNamePool = new ObjectPool(POOL_SIZE);
        clsNamePool = new ObjectPool(POOL_SIZE);
        simpleClassNamePool = new ObjectPool(POOL_SIZE);
        nameClassPool = new ObjectPool(POOL_SIZE);
        canonicalClassNamePool = new ObjectPool(POOL_SIZE);
        enclosingClassPool = new ObjectPool(POOL_SIZE);
        classDeclaredConstructorPool = new ObjectPool(POOL_SIZE);
        classDeclaredMethodPool = new ObjectPool(POOL_SIZE);
        registeredNonEntityClass = new ObjectPool(POOL_SIZE);
        registeredNonEntityClass.put(Object.class, Object.class);
        registeredNonEntityClass.put(Class.class, Class.class);
        registeredNonEntityClass.put(Calendar.class, Calendar.class);
        registeredNonEntityClass.put(Date.class, Date.class);
        registeredNonEntityClass.put(java.sql.Date.class, java.sql.Date.class);
        registeredNonEntityClass.put(Time.class, Time.class);
        registeredNonEntityClass.put(Timestamp.class, Timestamp.class);
        CLASS_MASK = ClassMask.class;
        METHOD_MASK = ClassUtil.internalGetDeclaredMethod(ClassMask.class, "methodMask", new Class[0]);
        try {
            FIELD_MASK = ClassMask.class.getDeclaredField("FIELD_MASK");
        }
        catch (Exception e) {
            throw N.toRuntimeException(e);
        }
        builtinTypeNameMap = new HashMap<String, String>(100);
        builtinTypeNameMap.put(boolean[].class.getName(), "boolean[]");
        builtinTypeNameMap.put(char[].class.getName(), "char[]");
        builtinTypeNameMap.put(byte[].class.getName(), "byte[]");
        builtinTypeNameMap.put(short[].class.getName(), "short[]");
        builtinTypeNameMap.put(int[].class.getName(), "int[]");
        builtinTypeNameMap.put(long[].class.getName(), "long[]");
        builtinTypeNameMap.put(float[].class.getName(), "float[]");
        builtinTypeNameMap.put(double[].class.getName(), "double[]");
        builtinTypeNameMap.put(Boolean[].class.getName(), "Boolean[]");
        builtinTypeNameMap.put(Character[].class.getName(), "Character[]");
        builtinTypeNameMap.put(Byte[].class.getName(), "Byte[]");
        builtinTypeNameMap.put(Short[].class.getName(), "Short[]");
        builtinTypeNameMap.put(Integer[].class.getName(), "Integer[]");
        builtinTypeNameMap.put(Long[].class.getName(), "Long[]");
        builtinTypeNameMap.put(Float[].class.getName(), "Float[]");
        builtinTypeNameMap.put(Double[].class.getName(), "Double[]");
        builtinTypeNameMap.put(String[].class.getName(), "String[]");
        builtinTypeNameMap.put(CharSequence[].class.getName(), "CharSequence[]");
        builtinTypeNameMap.put(Number[].class.getName(), "Number[]");
        builtinTypeNameMap.put(Object[].class.getName(), "Object[]");
        for (String key : new ArrayList<String>(builtinTypeNameMap.keySet())) {
            builtinTypeNameMap.put("class " + key, builtinTypeNameMap.get(key));
        }
        builtinTypeNameMap.put(Boolean.class.getName(), "Boolean");
        builtinTypeNameMap.put(Character.class.getName(), "Character");
        builtinTypeNameMap.put(Byte.class.getName(), "Byte");
        builtinTypeNameMap.put(Short.class.getName(), "Short");
        builtinTypeNameMap.put(Integer.class.getName(), "Integer");
        builtinTypeNameMap.put(Long.class.getName(), "Long");
        builtinTypeNameMap.put(Float.class.getName(), "Float");
        builtinTypeNameMap.put(Double.class.getName(), "Double");
        builtinTypeNameMap.put(String.class.getName(), "String");
        builtinTypeNameMap.put(CharSequence.class.getName(), "CharSequence");
        builtinTypeNameMap.put(Number.class.getName(), "Number");
        builtinTypeNameMap.put(Object.class.getName(), "Object");
        idPropNamesMap = new ConcurrentHashMap();
        fakeIds = ImmutableList.of("not_defined_fake_id_in_abacus_" + N.uuid());
        column2PropNameNameMapPool = new ConcurrentHashMap();
        entityTablePropColumnNameMap = new ObjectPool(N.POOL_SIZE);
    }

    static final class ClassMask {
        static final String FIELD_MASK = "FIELD_MASK";

        ClassMask() {
        }

        static void methodMask() {
        }
    }
}

