/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.ToDoubleFunction;
import com.landawn.abacus.util.function.ToFloatFunction;
import com.landawn.abacus.util.function.ToIntFunction;
import com.landawn.abacus.util.function.ToLongFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public abstract class Comparators {
    static final Comparator NULL_FIRST_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable a, Comparable b) {
            return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo(b));
        }
    };
    static final Comparator NULL_LAST_COMPARATOR = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable a, Comparable b) {
            return a == null ? (b == null ? 0 : 1) : (b == null ? -1 : a.compareTo(b));
        }
    };
    static final Comparator NATURAL_ORDER = NULL_FIRST_COMPARATOR;
    static final Comparator REVERSED_ORDER = Collections.reverseOrder(NATURAL_ORDER);
    static final Comparator<String> COMPARING_IGNORE_CASE = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return N.compareIgnoreCase(a, b);
        }
    };
    static final Comparator<CharSequence> COMPARING_BY_LENGTH = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence a, CharSequence b) {
            return (a == null ? 0 : a.length()) - (b == null ? 0 : b.length());
        }
    };
    static final Comparator<Collection> COMPARING_BY_SIZE = new Comparator<Collection>(){

        @Override
        public int compare(Collection a, Collection b) {
            return (a == null ? 0 : a.size()) - (b == null ? 0 : b.size());
        }
    };
    static final Comparator<Map> COMPARING_BY_MAP_SIZE = new Comparator<Map>(){

        @Override
        public int compare(Map a, Map b) {
            return (a == null ? 0 : a.size()) - (b == null ? 0 : b.size());
        }
    };
    public static final Comparator<boolean[]> BOOLEAN_ARRAY_COMPARATOR = new Comparator<boolean[]>(){

        @Override
        public int compare(boolean[] a, boolean[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                if (a[i] == b[i]) continue;
                return a[i] ? 1 : -1;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<char[]> CHAR_ARRAY_COMPARATOR = new Comparator<char[]>(){

        @Override
        public int compare(char[] a, char[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                if (a[i] == b[i]) continue;
                return a[i] > b[i] ? 1 : -1;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] a, byte[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                if (a[i] == b[i]) continue;
                return a[i] > b[i] ? 1 : -1;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<short[]> SHORT_ARRAY_COMPARATOR = new Comparator<short[]>(){

        @Override
        public int compare(short[] a, short[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                if (a[i] == b[i]) continue;
                return a[i] > b[i] ? 1 : -1;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<int[]> INT_ARRAY_COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] a, int[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                if (a[i] == b[i]) continue;
                return a[i] > b[i] ? 1 : -1;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<long[]> LONG_ARRAY_COMPARATOR = new Comparator<long[]>(){

        @Override
        public int compare(long[] a, long[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                if (a[i] == b[i]) continue;
                return a[i] > b[i] ? 1 : -1;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<float[]> FLOAT_ARRAY_COMPARATOR = new Comparator<float[]>(){

        @Override
        public int compare(float[] a, float[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int result = 0;
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                result = Float.compare(a[i], b[i]);
                if (result == 0) continue;
                return result;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<double[]> DOUBLE_ARRAY_COMPARATOR = new Comparator<double[]>(){

        @Override
        public int compare(double[] a, double[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int result = 0;
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                result = Double.compare(a[i], b[i]);
                if (result == 0) continue;
                return result;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<Object[]> OBJECT_ARRAY_COMPARATOR = new Comparator<Object[]>(){

        @Override
        public int compare(Object[] a, Object[] b) {
            int lenA = N.len(a);
            int lenB = N.len(b);
            int result = 0;
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                result = NATURAL_ORDER.compare(a[i], b[i]);
                if (result == 0) continue;
                return result;
            }
            return N.compare(lenA, lenB);
        }
    };
    public static final Comparator<Collection> COLLECTION_COMPARATOR = new Comparator<Collection>(){

        @Override
        public int compare(Collection a, Collection b) {
            if (N.isNullOrEmpty(a)) {
                return N.isNullOrEmpty(b) ? 0 : -1;
            }
            if (N.isNullOrEmpty(b)) {
                return 1;
            }
            Iterator iterA = a.iterator();
            Iterator iterB = b.iterator();
            int lenA = N.size(a);
            int lenB = N.size(b);
            int result = 0;
            int minLen = N.min(lenA, lenB);
            for (int i = 0; i < minLen; ++i) {
                result = NATURAL_ORDER.compare(iterA.next(), iterB.next());
                if (result == 0) continue;
                return result;
            }
            return N.compare(lenA, lenB);
        }
    };

    Comparators() {
    }

    public static <T extends Comparable> Comparator<T> naturalOrder() {
        return NATURAL_ORDER;
    }

    public static <T extends Comparable> Comparator<T> reversedOrder() {
        return REVERSED_ORDER;
    }

    public static <T> Comparator<T> reversedOrder(Comparator<T> cmp) {
        if (cmp == null || cmp == NATURAL_ORDER) {
            return REVERSED_ORDER;
        }
        if (cmp == REVERSED_ORDER) {
            return NATURAL_ORDER;
        }
        return Collections.reverseOrder(cmp);
    }

    public static <T extends Comparable> Comparator<T> nullsFirst() {
        return NULL_FIRST_COMPARATOR;
    }

    public static <T> Comparator<T> nullsFirst(final Comparator<T> cmp) {
        if (cmp == null || cmp == NULL_FIRST_COMPARATOR) {
            return NULL_FIRST_COMPARATOR;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : cmp.compare(a, b));
            }
        };
    }

    public static <T extends Comparable> Comparator<T> nullsLast() {
        return NULL_LAST_COMPARATOR;
    }

    public static <T> Comparator<T> nullsLast(final Comparator<T> cmp) {
        if (cmp == null || cmp == NULL_LAST_COMPARATOR) {
            return NULL_LAST_COMPARATOR;
        }
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a == null ? (b == null ? 0 : 1) : (b == null ? -1 : cmp.compare(a, b));
            }
        };
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> comparingBy(final Function<? super T, ? extends U> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return N.compare((Comparable)keyMapper.apply(a), (Comparable)keyMapper.apply(b));
            }
        };
    }

    public static <T, U extends Comparable<? super U>> Comparator<T> reversedComparingBy(final Function<? super T, ? extends U> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return N.compare((Comparable)keyMapper.apply(b), (Comparable)keyMapper.apply(a));
            }
        };
    }

    public static <T, U> Comparator<T> comparingBy(final Function<? super T, ? extends U> keyMapper, final Comparator<? super U> keyComparator) {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(keyComparator);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return keyComparator.compare(keyMapper.apply(a), keyMapper.apply(b));
            }
        };
    }

    public static <T> Comparator<T> comparingInt(final ToIntFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Integer.compare(keyMapper.applyAsInt(a), keyMapper.applyAsInt(b));
            }
        };
    }

    public static <T> Comparator<T> comparingLong(final ToLongFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Long.compare(keyMapper.applyAsLong(a), keyMapper.applyAsLong(b));
            }
        };
    }

    public static <T> Comparator<T> comparingFloat(final ToFloatFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Float.compare(keyMapper.applyAsFloat(a), keyMapper.applyAsFloat(b));
            }
        };
    }

    public static <T> Comparator<T> comparingDouble(final ToDoubleFunction<? super T> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Double.compare(keyMapper.applyAsDouble(a), keyMapper.applyAsDouble(b));
            }
        };
    }

    public static Comparator<String> comparingIgnoreCase() {
        return COMPARING_IGNORE_CASE;
    }

    public static <T> Comparator<T> comparingIgnoreCase(final Function<? super T, String> keyMapper) {
        N.checkArgNotNull(keyMapper);
        return new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return N.compareIgnoreCase((String)keyMapper.apply(a), (String)keyMapper.apply(b));
            }
        };
    }

    public static <K extends Comparable<? super K>, V> Comparator<Map.Entry<K, V>> comparingByKey() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)a.getKey(), (Comparable)b.getKey());
            }
        };
    }

    public static <K extends Comparable<? super K>, V> Comparator<Map.Entry<K, V>> reversedComparingByKey() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)b.getKey(), (Comparable)a.getKey());
            }
        };
    }

    public static <K, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> comparingByValue() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)a.getValue(), (Comparable)b.getValue());
            }
        };
    }

    public static <K, V extends Comparable<? super V>> Comparator<Map.Entry<K, V>> reversedComparingByValue() {
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return N.compare((Comparable)b.getValue(), (Comparable)a.getValue());
            }
        };
    }

    public static <K, V> Comparator<Map.Entry<K, V>> comparingByKey(final Comparator<? super K> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(a.getKey(), b.getKey());
            }
        };
    }

    public static <K, V> Comparator<Map.Entry<K, V>> comparingByValue(final Comparator<? super V> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(a.getValue(), b.getValue());
            }
        };
    }

    @Deprecated
    public static <K, V> Comparator<Map.Entry<K, V>> reversedComparingByKey(final Comparator<? super K> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(b.getKey(), a.getKey());
            }
        };
    }

    @Deprecated
    public static <K, V> Comparator<Map.Entry<K, V>> reversedComparingByValue(final Comparator<? super V> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> a, Map.Entry<K, V> b) {
                return cmp.compare(b.getValue(), a.getValue());
            }
        };
    }

    public static <T extends CharSequence> Comparator<T> comparingByLength() {
        return COMPARING_BY_LENGTH;
    }

    public static <T extends Collection> Comparator<T> comparingBySize() {
        return COMPARING_BY_SIZE;
    }

    public static <T extends Map> Comparator<T> comparingByMapSize() {
        return COMPARING_BY_MAP_SIZE;
    }

    public static <T> Comparator<T[]> comparingArray(final Comparator<T> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<T[]>(){

            @Override
            public int compare(T[] a, T[] b) {
                int lenA = N.len(a);
                int lenB = N.len(b);
                int result = 0;
                int minLen = N.min(lenA, lenB);
                for (int i = 0; i < minLen; ++i) {
                    result = cmp.compare(a[i], b[i]);
                    if (result == 0) continue;
                    return result;
                }
                return N.compare(lenA, lenB);
            }
        };
    }

    public static <T, C extends Collection<T>> Comparator<C> comparingCollection(final Comparator<T> cmp) {
        N.checkArgNotNull(cmp);
        return new Comparator<C>(){

            @Override
            public int compare(C a, C b) {
                if (N.isNullOrEmpty(a)) {
                    return N.isNullOrEmpty(b) ? 0 : -1;
                }
                if (N.isNullOrEmpty(b)) {
                    return 1;
                }
                Iterator iterA = a.iterator();
                Iterator iterB = b.iterator();
                int lenA = N.size(a);
                int lenB = N.size(b);
                int result = 0;
                int minLen = N.min(lenA, lenB);
                for (int i = 0; i < minLen; ++i) {
                    result = cmp.compare(iterA.next(), iterB.next());
                    if (result == 0) continue;
                    return result;
                }
                return N.compare(lenA, lenB);
            }
        };
    }
}

