/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Difference<L, R> {
    final L common;
    final L leftOnly;
    final R rightOnly;

    Difference(L common, L leftOnly, R rightOnly) {
        this.common = common;
        this.leftOnly = leftOnly;
        this.rightOnly = rightOnly;
    }

    public static <T1, T2, L extends List<T1>, R extends List<T2>> Difference<L, R> of(T1[] a, T2[] b) {
        return Difference.of(Arrays.asList(a), Arrays.asList(b));
    }

    public static <T1, T2, L extends List<T1>, R extends List<T2>> Difference<L, R> of(Collection<? extends T1> a, Collection<? extends T2> b) {
        ArrayList<Object> rightOnly;
        ArrayList<T1> leftOnly;
        ArrayList<T1> common;
        block7: {
            block6: {
                common = new ArrayList<T1>();
                leftOnly = new ArrayList<T1>();
                rightOnly = new ArrayList<Object>();
                if (!N.isNullOrEmpty(a)) break block6;
                if (N.isNullOrEmpty(b)) break block7;
                rightOnly.addAll(b);
                break block7;
            }
            if (N.isNullOrEmpty(b)) {
                leftOnly.addAll(a);
            } else {
                Multiset<T2> bOccurrences = Multiset.from(b);
                for (T1 e : a) {
                    if (bOccurrences.getAndRemove(e) > 0) {
                        common.add(e);
                        continue;
                    }
                    leftOnly.add(e);
                }
                for (T1 e : b) {
                    if (bOccurrences.getAndRemove(e) > 0) {
                        rightOnly.add(e);
                    }
                    if (!bOccurrences.isEmpty()) continue;
                    break;
                }
            }
        }
        return new Difference(common, leftOnly, rightOnly);
    }

    public L inCommon() {
        return this.common;
    }

    public L onLeftOnly() {
        return this.leftOnly;
    }

    public R onRightOnly() {
        return this.rightOnly;
    }

    public boolean areEqual() {
        return this.leftOnly instanceof Map && ((Map)this.leftOnly).isEmpty() && ((Map)this.rightOnly).isEmpty() || this.leftOnly instanceof Collection && ((Collection)this.leftOnly).isEmpty() && ((Collection)this.rightOnly).isEmpty();
    }

    public String toString() {
        return "{inCommon=" + this.common + ", onLeftOnly=" + this.leftOnly + ", onRightOnly=" + this.rightOnly + "}";
    }

    public static final class MapDifference<L, R, D>
    extends Difference<L, R> {
        private final D diffValues;

        MapDifference(L common, L leftOnly, R rightOnly, D diff) {
            super(common, leftOnly, rightOnly);
            this.diffValues = diff;
        }

        public static <CK, K1 extends CK, V1, K2 extends CK, V2> MapDifference<Map<K1, V1>, Map<K2, V2>, Map<CK, Pair<V1, V2>>> of(Map<? extends K1, ? extends V1> map1, Map<? extends K2, ? extends V2> map2) {
            LinkedHashMap<K1, V1> common = new LinkedHashMap<K1, V1>();
            LinkedHashMap<K1, V1> leftOnly = new LinkedHashMap<K1, V1>();
            LinkedHashMap<Object, Object> rightOnly = new LinkedHashMap<Object, Object>();
            LinkedHashMap<K1, Pair<V1, Object>> diff = new LinkedHashMap<K1, Pair<V1, Object>>();
            if (N.isNullOrEmpty(map1)) {
                if (!N.isNullOrEmpty(map2)) {
                    rightOnly.putAll(map2);
                }
            } else if (N.isNullOrEmpty(map2)) {
                leftOnly.putAll(map1);
            } else {
                Object key1 = null;
                Object val2 = null;
                for (Map.Entry<K1, V1> entry : map1.entrySet()) {
                    key1 = entry.getKey();
                    val2 = map2.get(key1);
                    if (val2 == null) {
                        if (map2.containsKey(key1)) {
                            if (entry.getValue() == null) {
                                common.put(entry.getKey(), entry.getValue());
                                continue;
                            }
                            diff.put(entry.getKey(), Pair.of(entry.getValue(), val2));
                            continue;
                        }
                        leftOnly.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (N.equals(entry.getValue(), val2)) {
                        common.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    diff.put(entry.getKey(), Pair.of(entry.getValue(), val2));
                }
                for (Map.Entry<Object, Object> entry : map2.entrySet()) {
                    if (common.containsKey(entry.getKey()) || diff.containsKey(entry.getKey())) continue;
                    rightOnly.put(entry.getKey(), entry.getValue());
                }
            }
            return new MapDifference<Map<K1, V1>, Map<K2, V2>, Map<CK, Pair<V1, V2>>>(common, leftOnly, rightOnly, diff);
        }

        public static MapDifference<Map<String, Object>, Map<String, Object>, Map<String, Pair<Object, Object>>> of(Object entity1, Object entity2) {
            if (!ClassUtil.isEntity(entity1.getClass()) || !ClassUtil.isEntity(entity2.getClass())) {
                throw new IllegalArgumentException(entity1.getClass().getCanonicalName() + " or " + entity2.getClass().getCanonicalName() + " is not an entity class");
            }
            return MapDifference.of(Maps.entity2Map(entity1), Maps.entity2Map(entity2));
        }

        public D withDifferentValues() {
            return this.diffValues;
        }

        @Override
        public boolean areEqual() {
            return super.areEqual() && ((Map)this.diffValues).isEmpty();
        }

        @Override
        public String toString() {
            return "{inCommon=" + this.common + ", onLeftOnly=" + this.leftOnly + ", onRightOnly=" + this.rightOnly + ", withDifferentValues=" + this.diffValues + "}";
        }
    }
}

