/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.function.Consumer;

public class DynamicSQLBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DynamicSQLBuilder.class);
    private Select select = new Select(Objectory.createStringBuilder());
    private From from = new From(Objectory.createStringBuilder());
    private Where where;
    private GroupBy groupBy;
    private Having having;
    private OrderBy orderBy;
    private String limitCond;
    private StringBuilder moreParts = null;

    private DynamicSQLBuilder() {
    }

    public static DynamicSQLBuilder create() {
        return new DynamicSQLBuilder();
    }

    public Select select() {
        return this.select;
    }

    public From from() {
        return this.from;
    }

    public Where where() {
        if (this.where == null) {
            this.where = new Where(Objectory.createStringBuilder());
        }
        return this.where;
    }

    public GroupBy groupBy() {
        if (this.groupBy == null) {
            this.groupBy = new GroupBy(Objectory.createStringBuilder());
        }
        return this.groupBy;
    }

    public Having having() {
        if (this.having == null) {
            this.having = new Having(Objectory.createStringBuilder());
        }
        return this.having;
    }

    public OrderBy orderBy() {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy(Objectory.createStringBuilder());
        }
        return this.orderBy;
    }

    public DynamicSQLBuilder limit(String limitCond) {
        this.limitCond = limitCond;
        return this;
    }

    public DynamicSQLBuilder limit(int count) {
        return this.limit("LIMIT " + count);
    }

    public DynamicSQLBuilder limit(int offset, int count) {
        return this.limit("LIMIT " + offset + ", " + count);
    }

    public DynamicSQLBuilder limitByRowNum(int count) {
        return this.limit("ROWNUM < " + count);
    }

    public DynamicSQLBuilder union(String query) {
        if (this.moreParts == null) {
            this.moreParts = Objectory.createStringBuilder();
        }
        this.moreParts.append(" UNION ").append(query);
        return this;
    }

    public DynamicSQLBuilder unionAll(String query) {
        if (this.moreParts == null) {
            this.moreParts = Objectory.createStringBuilder();
        }
        this.moreParts.append(" UNION ALL ").append(query);
        return this;
    }

    public DynamicSQLBuilder intersect(String query) {
        if (this.moreParts == null) {
            this.moreParts = Objectory.createStringBuilder();
        }
        this.moreParts.append(" INTERSECT ").append(query);
        return this;
    }

    public DynamicSQLBuilder except(String query) {
        if (this.moreParts == null) {
            this.moreParts = Objectory.createStringBuilder();
        }
        this.moreParts.append(" EXCEPT ").append(query);
        return this;
    }

    public DynamicSQLBuilder minus(String query) {
        if (this.moreParts == null) {
            this.moreParts = Objectory.createStringBuilder();
        }
        this.moreParts.append(" MINUS ").append(query);
        return this;
    }

    @Beta
    public DynamicSQLBuilder iF(boolean b, Consumer<DynamicSQLBuilder> actionForTrue) {
        if (b) {
            actionForTrue.accept(this);
        }
        return this;
    }

    @Beta
    public DynamicSQLBuilder ifOrElse(boolean b, Consumer<DynamicSQLBuilder> actionForTrue, Consumer<DynamicSQLBuilder> actionForFalse) {
        if (b) {
            actionForTrue.accept(this);
        } else {
            actionForFalse.accept(this);
        }
        return this;
    }

    public String build() {
        this.select.sb.append(" ").append((CharSequence)this.from.sb);
        if (this.where != null) {
            this.select.sb.append(" ").append((CharSequence)this.where.sb);
            Objectory.recycle(this.where.sb);
            this.where = null;
        }
        if (this.groupBy != null) {
            this.select.sb.append(" ").append((CharSequence)this.groupBy.sb);
            Objectory.recycle(this.groupBy.sb);
            this.groupBy = null;
        }
        if (this.having != null) {
            this.select.sb.append(" ").append((CharSequence)this.having.sb);
            Objectory.recycle(this.having.sb);
            this.having = null;
        }
        if (this.orderBy != null) {
            this.select.sb.append(" ").append((CharSequence)this.orderBy.sb);
            Objectory.recycle(this.orderBy.sb);
            this.orderBy = null;
        }
        if (N.notNullOrEmpty(this.limitCond)) {
            this.select.sb.append(" ").append(this.limitCond);
        }
        if (this.moreParts != null) {
            this.select.sb.append((CharSequence)this.moreParts);
            Objectory.recycle(this.moreParts);
        }
        String sql = this.select.sb.toString();
        Objectory.recycle(this.from.sb);
        Objectory.recycle(this.select.sb);
        this.select = null;
        this.from = null;
        if (logger.isDebugEnabled()) {
            logger.debug(sql);
        }
        return sql;
    }

    public static final class DSB
    extends DynamicSQLBuilder {
        private DSB() {
        }
    }

    public static class OrderBy {
        final StringBuilder sb;

        OrderBy(StringBuilder sb) {
            this.sb = sb;
        }

        public OrderBy append(String column) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("ORDER BY ");
            }
            this.sb.append(column);
            return this;
        }

        public OrderBy appendIf(boolean b, String str) {
            if (b) {
                if (this.sb.length() > 0) {
                    this.sb.append(", ");
                } else {
                    this.sb.append("ORDER BY ");
                }
                this.sb.append(str);
            }
            return this;
        }

        public OrderBy appendIfOrElse(boolean b, String strToAppendForTrue, String strToAppendForFalse) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("ORDER BY ");
            }
            if (b) {
                this.sb.append(strToAppendForTrue);
            } else {
                this.sb.append(strToAppendForFalse);
            }
            return this;
        }
    }

    public static class Having {
        final StringBuilder sb;

        Having(StringBuilder sb) {
            this.sb = sb;
        }

        public Having append(String cond) {
            if (this.sb.length() > 0) {
                this.sb.append(" ");
            } else {
                this.sb.append("HAVING ");
            }
            this.sb.append(cond);
            return this;
        }

        public Having and(String cond) {
            this.sb.append(" AND ").append(cond);
            return this;
        }

        public Having or(String cond) {
            this.sb.append(" OR ").append(cond);
            return this;
        }

        public Having appendIf(boolean b, String str) {
            if (b) {
                if (this.sb.length() > 0) {
                    this.sb.append(" ");
                } else {
                    this.sb.append("HAVING ");
                }
                this.sb.append(str);
            }
            return this;
        }

        public Having appendIfOrElse(boolean b, String strToAppendForTrue, String strToAppendForFalse) {
            if (this.sb.length() > 0) {
                this.sb.append(" ");
            } else {
                this.sb.append("HAVING ");
            }
            if (b) {
                this.sb.append(strToAppendForTrue);
            } else {
                this.sb.append(strToAppendForFalse);
            }
            return this;
        }
    }

    public static class GroupBy {
        final StringBuilder sb;

        GroupBy(StringBuilder sb) {
            this.sb = sb;
        }

        public GroupBy append(String column) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("GROUP BY ");
            }
            this.sb.append(column);
            return this;
        }

        public GroupBy appendIf(boolean b, String str) {
            if (b) {
                if (this.sb.length() > 0) {
                    this.sb.append(", ");
                } else {
                    this.sb.append("GROUP BY ");
                }
                this.sb.append(str);
            }
            return this;
        }

        public GroupBy appendIfOrElse(boolean b, String strToAppendForTrue, String strToAppendForFalse) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("GROUP BY ");
            }
            if (b) {
                this.sb.append(strToAppendForTrue);
            } else {
                this.sb.append(strToAppendForFalse);
            }
            return this;
        }
    }

    public static class Where {
        final StringBuilder sb;

        Where(StringBuilder sb) {
            this.sb = sb;
        }

        public Where append(String cond) {
            if (this.sb.length() > 0) {
                this.sb.append(" ");
            } else {
                this.sb.append("WHERE ");
            }
            this.sb.append(cond);
            return this;
        }

        public Where repeatQM(int n) {
            N.checkArgNotNegative(n, "n");
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.sb.append(", ?");
                    continue;
                }
                this.sb.append('?');
            }
            return this;
        }

        public Where repeatQM(int n, String prefix, String postfix) {
            N.checkArgNotNegative(n, "n");
            this.sb.append(prefix);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.sb.append(", ?");
                    continue;
                }
                this.sb.append('?');
            }
            this.sb.append(postfix);
            return this;
        }

        public Where and(String cond) {
            this.sb.append(" AND ").append(cond);
            return this;
        }

        public Where or(String cond) {
            this.sb.append(" OR ").append(cond);
            return this;
        }

        public Where appendIf(boolean b, String str) {
            if (b) {
                if (this.sb.length() > 0) {
                    this.sb.append(" ");
                } else {
                    this.sb.append("WHERE ");
                }
                this.sb.append(str);
            }
            return this;
        }

        public Where appendIfOrElse(boolean b, String strToAppendForTrue, String strToAppendForFalse) {
            if (this.sb.length() > 0) {
                this.sb.append(" ");
            } else {
                this.sb.append("WHERE ");
            }
            if (b) {
                this.sb.append(strToAppendForTrue);
            } else {
                this.sb.append(strToAppendForFalse);
            }
            return this;
        }
    }

    public static class From {
        final StringBuilder sb;

        From(StringBuilder sb) {
            this.sb = sb;
        }

        public From append(String table) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("FROM ");
            }
            this.sb.append(table);
            return this;
        }

        public From append(String table, String alias) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("FROM");
            }
            this.sb.append(table).append(" ").append(alias);
            return this;
        }

        public From join(String table, String on) {
            this.sb.append(" JOIN ").append(table).append(" ON ").append(on);
            return this;
        }

        public From innerJoin(String table, String on) {
            this.sb.append(" INNER JOIN ").append(table).append(" ON ").append(on);
            return this;
        }

        public From leftJoin(String table, String on) {
            this.sb.append(" LEFT JOIN ").append(table).append(" ON ").append(on);
            return this;
        }

        public From rightJoin(String table, String on) {
            this.sb.append(" RIGHT JOIN ").append(table).append(" ON ").append(on);
            return this;
        }

        public From fullJoin(String table, String on) {
            this.sb.append(" FULL JOIN ").append(table).append(" ON ").append(on);
            return this;
        }

        public From appendIf(boolean b, String str) {
            if (b) {
                if (this.sb.length() > 0) {
                    this.sb.append(", ");
                } else {
                    this.sb.append("FROM ");
                }
                this.sb.append(str);
            }
            return this;
        }

        public From appendIfOrElse(boolean b, String strToAppendForTrue, String strToAppendForFalse) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("FROM ");
            }
            if (b) {
                this.sb.append(strToAppendForTrue);
            } else {
                this.sb.append(strToAppendForFalse);
            }
            return this;
        }
    }

    public static class Select {
        final StringBuilder sb;

        Select(StringBuilder sb) {
            this.sb = sb;
        }

        public Select append(String column) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("SELECT ");
            }
            this.sb.append(column);
            return this;
        }

        public Select append(String column, String alias) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("SELECT ");
            }
            this.sb.append(column).append(" AS ").append(alias);
            return this;
        }

        public Select appendIf(boolean b, String str) {
            if (b) {
                if (this.sb.length() > 0) {
                    this.sb.append(", ");
                } else {
                    this.sb.append("SELECT ");
                }
                this.sb.append(str);
            }
            return this;
        }

        public Select appendIfOrElse(boolean b, String strToAppendForTrue, String strToAppendForFalse) {
            if (this.sb.length() > 0) {
                this.sb.append(", ");
            } else {
                this.sb.append("SELECT ");
            }
            if (b) {
                this.sb.append(strToAppendForTrue);
            } else {
                this.sb.append(strToAppendForFalse);
            }
            return this;
        }
    }
}

