/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.function.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public final class Enumerations {
    private static final Enumeration EMPTY = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };

    private Enumerations() {
    }

    public static <T> Enumeration<T> empty() {
        return EMPTY;
    }

    public static <T> Enumeration<T> just(final T single) {
        return new Enumeration<T>(){
            private boolean hasNext = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasNext;
            }

            @Override
            public T nextElement() {
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return single;
            }
        };
    }

    public static <T> Enumeration<T> of(final T ... a) {
        if (N.isNullOrEmpty(a)) {
            return Enumerations.empty();
        }
        return new Enumeration<T>(){
            private final int len;
            private int cursor;
            {
                this.len = a.length;
                this.cursor = 0;
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.len;
            }

            @Override
            public T nextElement() {
                if (this.cursor >= this.len) {
                    throw new NoSuchElementException();
                }
                return a[this.cursor++];
            }
        };
    }

    public static <T> Enumeration<T> of(Collection<? extends T> c) {
        if (N.isNullOrEmpty(c)) {
            return Enumerations.empty();
        }
        return Enumerations.from(c.iterator());
    }

    public static <T> Enumeration<T> from(final Iterator<? extends T> iter) {
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public T nextElement() {
                return iter.next();
            }
        };
    }

    @SafeVarargs
    public static <T> Enumeration<T> concat(Enumeration<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return Enumerations.empty();
        }
        return Enumerations.concat(Array.asList(a));
    }

    public static <T> Enumeration<T> concat(final Collection<? extends Enumeration<? extends T>> c) {
        if (N.isNullOrEmpty(c)) {
            return Enumerations.empty();
        }
        return new Enumeration<T>(){
            private final Iterator<? extends Enumeration<? extends T>> iter;
            private Enumeration<? extends T> cur;
            {
                this.iter = c.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                while ((this.cur == null || !this.cur.hasMoreElements()) && this.iter.hasNext()) {
                    this.cur = this.iter.next();
                }
                return this.cur != null && this.cur.hasMoreElements();
            }

            @Override
            public T nextElement() {
                if (!(this.cur != null && this.cur.hasMoreElements() || this.hasMoreElements())) {
                    throw new NoSuchElementException();
                }
                return this.cur.nextElement();
            }
        };
    }

    public static <T> ObjIterator<T> toIterator(final Enumeration<? extends T> e) {
        if (e == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public T next() {
                return e.nextElement();
            }
        };
    }

    public static <T> List<T> toList(Enumeration<? extends T> e) {
        if (e == null) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    public static <T> Set<T> toSet(Enumeration<? extends T> e) {
        if (e == null) {
            return new HashSet();
        }
        HashSet<T> result = new HashSet<T>();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result;
    }

    public static <T, C extends Collection<T>> C toCollection(Enumeration<? extends T> e, Supplier<? extends C> supplier) {
        Collection c = (Collection)supplier.get();
        if (e != null) {
            while (e.hasMoreElements()) {
                c.add(e.nextElement());
            }
        }
        return (C)c;
    }
}

