/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class EscapeUtil {
    static final char LF = '\n';
    static final char CR = '\r';
    public static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}).with(new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE())).with(JavaUnicodeEscaper.outsideOf(32, 127));
    public static final CharSequenceTranslator ESCAPE_ECMASCRIPT = new AggregateTranslator(new LookupTranslator({"'", "\\'"}, {"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127));
    public static final CharSequenceTranslator ESCAPE_JSON = new AggregateTranslator(new LookupTranslator({"\"", "\\\""}, {"\\", "\\\\"}, {"/", "\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127));
    public static final CharSequenceTranslator ESCAPE_XML10 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()), new LookupTranslator({"\u0000", N.EMPTY_STRING}, {"\u0001", N.EMPTY_STRING}, {"\u0002", N.EMPTY_STRING}, {"\u0003", N.EMPTY_STRING}, {"\u0004", N.EMPTY_STRING}, {"\u0005", N.EMPTY_STRING}, {"\u0006", N.EMPTY_STRING}, {"\u0007", N.EMPTY_STRING}, {"\b", N.EMPTY_STRING}, {"\u000b", N.EMPTY_STRING}, {"\f", N.EMPTY_STRING}, {"\u000e", N.EMPTY_STRING}, {"\u000f", N.EMPTY_STRING}, {"\u0010", N.EMPTY_STRING}, {"\u0011", N.EMPTY_STRING}, {"\u0012", N.EMPTY_STRING}, {"\u0013", N.EMPTY_STRING}, {"\u0014", N.EMPTY_STRING}, {"\u0015", N.EMPTY_STRING}, {"\u0016", N.EMPTY_STRING}, {"\u0017", N.EMPTY_STRING}, {"\u0018", N.EMPTY_STRING}, {"\u0019", N.EMPTY_STRING}, {"\u001a", N.EMPTY_STRING}, {"\u001b", N.EMPTY_STRING}, {"\u001c", N.EMPTY_STRING}, {"\u001d", N.EMPTY_STRING}, {"\u001e", N.EMPTY_STRING}, {"\u001f", N.EMPTY_STRING}, {"\ufffe", N.EMPTY_STRING}, {"\uffff", N.EMPTY_STRING}), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
    public static final CharSequenceTranslator ESCAPE_XML11 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()), new LookupTranslator({"\u0000", N.EMPTY_STRING}, {"\u000b", "&#11;"}, {"\f", "&#12;"}, {"\ufffe", N.EMPTY_STRING}, {"\uffff", N.EMPTY_STRING}), NumericEntityEscaper.between(1, 8), NumericEntityEscaper.between(14, 31), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
    public static final CharSequenceTranslator ESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()));
    public static final CharSequenceTranslator ESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE()));
    public static final CharSequenceTranslator ESCAPE_CSV = new CsvEscaper();
    public static final CharSequenceTranslator UNESCAPE_JAVA;
    public static final CharSequenceTranslator UNESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator UNESCAPE_JSON;
    public static final CharSequenceTranslator UNESCAPE_HTML3;
    public static final CharSequenceTranslator UNESCAPE_HTML4;
    public static final CharSequenceTranslator UNESCAPE_XML;
    public static final CharSequenceTranslator UNESCAPE_CSV;

    private EscapeUtil() {
    }

    public static final String escapeJava(String input) {
        return ESCAPE_JAVA.translate(input);
    }

    public static final String escapeEcmaScript(String input) {
        return ESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String escapeJson(String input) {
        return ESCAPE_JSON.translate(input);
    }

    public static final String unescapeJava(String input) {
        return UNESCAPE_JAVA.translate(input);
    }

    public static final String unescapeEcmaScript(String input) {
        return UNESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String unescapeJson(String input) {
        return UNESCAPE_JSON.translate(input);
    }

    public static final String escapeHtml4(String input) {
        return ESCAPE_HTML4.translate(input);
    }

    public static final String escapeHtml3(String input) {
        return ESCAPE_HTML3.translate(input);
    }

    public static final String unescapeHtml4(String input) {
        return UNESCAPE_HTML4.translate(input);
    }

    public static final String unescapeHtml3(String input) {
        return UNESCAPE_HTML3.translate(input);
    }

    public static String escapeXml10(String input) {
        return ESCAPE_XML10.translate(input);
    }

    public static String escapeXml11(String input) {
        return ESCAPE_XML11.translate(input);
    }

    public static final String unescapeXml(String input) {
        return UNESCAPE_XML.translate(input);
    }

    public static final String escapeCsv(String input) {
        return ESCAPE_CSV.translate(input);
    }

    public static final String unescapeCsv(String input) {
        return UNESCAPE_CSV.translate(input);
    }

    static {
        UNESCAPE_ECMASCRIPT = UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE()), new LookupTranslator({"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""}));
        UNESCAPE_JSON = UNESCAPE_JAVA;
        UNESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_XML = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.APOS_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_CSV = new CsvUnescaper();
    }

    static class EntityArrays {
        private static final String[][] ISO8859_1_ESCAPE = new String[][]{{"\u00a0", "&nbsp;"}, {"\u00a1", "&iexcl;"}, {"\u00a2", "&cent;"}, {"\u00a3", "&pound;"}, {"\u00a4", "&curren;"}, {"\u00a5", "&yen;"}, {"\u00a6", "&brvbar;"}, {"\u00a7", "&sect;"}, {"\u00a8", "&uml;"}, {"\u00a9", "&copy;"}, {"\u00aa", "&ordf;"}, {"\u00ab", "&laquo;"}, {"\u00ac", "&not;"}, {"\u00ad", "&shy;"}, {"\u00ae", "&reg;"}, {"\u00af", "&macr;"}, {"\u00b0", "&deg;"}, {"\u00b1", "&plusmn;"}, {"\u00b2", "&sup2;"}, {"\u00b3", "&sup3;"}, {"\u00b4", "&acute;"}, {"\u00b5", "&micro;"}, {"\u00b6", "&para;"}, {"\u00b7", "&middot;"}, {"\u00b8", "&cedil;"}, {"\u00b9", "&sup1;"}, {"\u00ba", "&ordm;"}, {"\u00bb", "&raquo;"}, {"\u00bc", "&frac14;"}, {"\u00bd", "&frac12;"}, {"\u00be", "&frac34;"}, {"\u00bf", "&iquest;"}, {"\u00c0", "&Agrave;"}, {"\u00c1", "&Aacute;"}, {"\u00c2", "&Acirc;"}, {"\u00c3", "&Atilde;"}, {"\u00c4", "&Auml;"}, {"\u00c5", "&Aring;"}, {"\u00c6", "&AElig;"}, {"\u00c7", "&Ccedil;"}, {"\u00c8", "&Egrave;"}, {"\u00c9", "&Eacute;"}, {"\u00ca", "&Ecirc;"}, {"\u00cb", "&Euml;"}, {"\u00cc", "&Igrave;"}, {"\u00cd", "&Iacute;"}, {"\u00ce", "&Icirc;"}, {"\u00cf", "&Iuml;"}, {"\u00d0", "&ETH;"}, {"\u00d1", "&Ntilde;"}, {"\u00d2", "&Ograve;"}, {"\u00d3", "&Oacute;"}, {"\u00d4", "&Ocirc;"}, {"\u00d5", "&Otilde;"}, {"\u00d6", "&Ouml;"}, {"\u00d7", "&times;"}, {"\u00d8", "&Oslash;"}, {"\u00d9", "&Ugrave;"}, {"\u00da", "&Uacute;"}, {"\u00db", "&Ucirc;"}, {"\u00dc", "&Uuml;"}, {"\u00dd", "&Yacute;"}, {"\u00de", "&THORN;"}, {"\u00df", "&szlig;"}, {"\u00e0", "&agrave;"}, {"\u00e1", "&aacute;"}, {"\u00e2", "&acirc;"}, {"\u00e3", "&atilde;"}, {"\u00e4", "&auml;"}, {"\u00e5", "&aring;"}, {"\u00e6", "&aelig;"}, {"\u00e7", "&ccedil;"}, {"\u00e8", "&egrave;"}, {"\u00e9", "&eacute;"}, {"\u00ea", "&ecirc;"}, {"\u00eb", "&euml;"}, {"\u00ec", "&igrave;"}, {"\u00ed", "&iacute;"}, {"\u00ee", "&icirc;"}, {"\u00ef", "&iuml;"}, {"\u00f0", "&eth;"}, {"\u00f1", "&ntilde;"}, {"\u00f2", "&ograve;"}, {"\u00f3", "&oacute;"}, {"\u00f4", "&ocirc;"}, {"\u00f5", "&otilde;"}, {"\u00f6", "&ouml;"}, {"\u00f7", "&divide;"}, {"\u00f8", "&oslash;"}, {"\u00f9", "&ugrave;"}, {"\u00fa", "&uacute;"}, {"\u00fb", "&ucirc;"}, {"\u00fc", "&uuml;"}, {"\u00fd", "&yacute;"}, {"\u00fe", "&thorn;"}, {"\u00ff", "&yuml;"}};
        private static final String[][] ISO8859_1_UNESCAPE = EntityArrays.invert(ISO8859_1_ESCAPE);
        private static final String[][] HTML40_EXTENDED_ESCAPE = new String[][]{{"\u0192", "&fnof;"}, {"\u0391", "&Alpha;"}, {"\u0392", "&Beta;"}, {"\u0393", "&Gamma;"}, {"\u0394", "&Delta;"}, {"\u0395", "&Epsilon;"}, {"\u0396", "&Zeta;"}, {"\u0397", "&Eta;"}, {"\u0398", "&Theta;"}, {"\u0399", "&Iota;"}, {"\u039a", "&Kappa;"}, {"\u039b", "&Lambda;"}, {"\u039c", "&Mu;"}, {"\u039d", "&Nu;"}, {"\u039e", "&Xi;"}, {"\u039f", "&Omicron;"}, {"\u03a0", "&Pi;"}, {"\u03a1", "&Rho;"}, {"\u03a3", "&Sigma;"}, {"\u03a4", "&Tau;"}, {"\u03a5", "&Upsilon;"}, {"\u03a6", "&Phi;"}, {"\u03a7", "&Chi;"}, {"\u03a8", "&Psi;"}, {"\u03a9", "&Omega;"}, {"\u03b1", "&alpha;"}, {"\u03b2", "&beta;"}, {"\u03b3", "&gamma;"}, {"\u03b4", "&delta;"}, {"\u03b5", "&epsilon;"}, {"\u03b6", "&zeta;"}, {"\u03b7", "&eta;"}, {"\u03b8", "&theta;"}, {"\u03b9", "&iota;"}, {"\u03ba", "&kappa;"}, {"\u03bb", "&lambda;"}, {"\u03bc", "&mu;"}, {"\u03bd", "&nu;"}, {"\u03be", "&xi;"}, {"\u03bf", "&omicron;"}, {"\u03c0", "&pi;"}, {"\u03c1", "&rho;"}, {"\u03c2", "&sigmaf;"}, {"\u03c3", "&sigma;"}, {"\u03c4", "&tau;"}, {"\u03c5", "&upsilon;"}, {"\u03c6", "&phi;"}, {"\u03c7", "&chi;"}, {"\u03c8", "&psi;"}, {"\u03c9", "&omega;"}, {"\u03d1", "&thetasym;"}, {"\u03d2", "&upsih;"}, {"\u03d6", "&piv;"}, {"\u2022", "&bull;"}, {"\u2026", "&hellip;"}, {"\u2032", "&prime;"}, {"\u2033", "&Prime;"}, {"\u203e", "&oline;"}, {"\u2044", "&frasl;"}, {"\u2118", "&weierp;"}, {"\u2111", "&image;"}, {"\u211c", "&real;"}, {"\u2122", "&trade;"}, {"\u2135", "&alefsym;"}, {"\u2190", "&larr;"}, {"\u2191", "&uarr;"}, {"\u2192", "&rarr;"}, {"\u2193", "&darr;"}, {"\u2194", "&harr;"}, {"\u21b5", "&crarr;"}, {"\u21d0", "&lArr;"}, {"\u21d1", "&uArr;"}, {"\u21d2", "&rArr;"}, {"\u21d3", "&dArr;"}, {"\u21d4", "&hArr;"}, {"\u2200", "&forall;"}, {"\u2202", "&part;"}, {"\u2203", "&exist;"}, {"\u2205", "&empty;"}, {"\u2207", "&nabla;"}, {"\u2208", "&isin;"}, {"\u2209", "&notin;"}, {"\u220b", "&ni;"}, {"\u220f", "&prod;"}, {"\u2211", "&sum;"}, {"\u2212", "&minus;"}, {"\u2217", "&lowast;"}, {"\u221a", "&radic;"}, {"\u221d", "&prop;"}, {"\u221e", "&infin;"}, {"\u2220", "&ang;"}, {"\u2227", "&and;"}, {"\u2228", "&or;"}, {"\u2229", "&cap;"}, {"\u222a", "&cup;"}, {"\u222b", "&int;"}, {"\u2234", "&there4;"}, {"\u223c", "&sim;"}, {"\u2245", "&cong;"}, {"\u2248", "&asymp;"}, {"\u2260", "&ne;"}, {"\u2261", "&equiv;"}, {"\u2264", "&le;"}, {"\u2265", "&ge;"}, {"\u2282", "&sub;"}, {"\u2283", "&sup;"}, {"\u2284", "&nsub;"}, {"\u2286", "&sube;"}, {"\u2287", "&supe;"}, {"\u2295", "&oplus;"}, {"\u2297", "&otimes;"}, {"\u22a5", "&perp;"}, {"\u22c5", "&sdot;"}, {"\u2308", "&lceil;"}, {"\u2309", "&rceil;"}, {"\u230a", "&lfloor;"}, {"\u230b", "&rfloor;"}, {"\u2329", "&lang;"}, {"\u232a", "&rang;"}, {"\u25ca", "&loz;"}, {"\u2660", "&spades;"}, {"\u2663", "&clubs;"}, {"\u2665", "&hearts;"}, {"\u2666", "&diams;"}, {"\u0152", "&OElig;"}, {"\u0153", "&oelig;"}, {"\u0160", "&Scaron;"}, {"\u0161", "&scaron;"}, {"\u0178", "&Yuml;"}, {"\u02c6", "&circ;"}, {"\u02dc", "&tilde;"}, {"\u2002", "&ensp;"}, {"\u2003", "&emsp;"}, {"\u2009", "&thinsp;"}, {"\u200c", "&zwnj;"}, {"\u200d", "&zwj;"}, {"\u200e", "&lrm;"}, {"\u200f", "&rlm;"}, {"\u2013", "&ndash;"}, {"\u2014", "&mdash;"}, {"\u2018", "&lsquo;"}, {"\u2019", "&rsquo;"}, {"\u201a", "&sbquo;"}, {"\u201c", "&ldquo;"}, {"\u201d", "&rdquo;"}, {"\u201e", "&bdquo;"}, {"\u2020", "&dagger;"}, {"\u2021", "&Dagger;"}, {"\u2030", "&permil;"}, {"\u2039", "&lsaquo;"}, {"\u203a", "&rsaquo;"}, {"\u20ac", "&euro;"}};
        private static final String[][] HTML40_EXTENDED_UNESCAPE = EntityArrays.invert(HTML40_EXTENDED_ESCAPE);
        private static final String[][] BASIC_ESCAPE = new String[][]{{"\"", "&quot;"}, {"&", "&amp;"}, {"<", "&lt;"}, {">", "&gt;"}};
        private static final String[][] BASIC_UNESCAPE = EntityArrays.invert(BASIC_ESCAPE);
        private static final String[][] APOS_ESCAPE = new String[][]{{"'", "&apos;"}};
        private static final String[][] APOS_UNESCAPE = EntityArrays.invert(APOS_ESCAPE);
        private static final String[][] JAVA_CTRL_CHARS_ESCAPE = new String[][]{{"\b", "\\b"}, {"\n", "\\n"}, {"\t", "\\t"}, {"\f", "\\f"}, {"\r", "\\r"}};
        private static final String[][] JAVA_CTRL_CHARS_UNESCAPE = EntityArrays.invert(JAVA_CTRL_CHARS_ESCAPE);

        EntityArrays() {
        }

        public static String[][] ISO8859_1_ESCAPE() {
            return (String[][])ISO8859_1_ESCAPE.clone();
        }

        public static String[][] ISO8859_1_UNESCAPE() {
            return (String[][])ISO8859_1_UNESCAPE.clone();
        }

        public static String[][] HTML40_EXTENDED_ESCAPE() {
            return (String[][])HTML40_EXTENDED_ESCAPE.clone();
        }

        public static String[][] HTML40_EXTENDED_UNESCAPE() {
            return (String[][])HTML40_EXTENDED_UNESCAPE.clone();
        }

        public static String[][] BASIC_ESCAPE() {
            return (String[][])BASIC_ESCAPE.clone();
        }

        public static String[][] BASIC_UNESCAPE() {
            return (String[][])BASIC_UNESCAPE.clone();
        }

        public static String[][] APOS_ESCAPE() {
            return (String[][])APOS_ESCAPE.clone();
        }

        public static String[][] APOS_UNESCAPE() {
            return (String[][])APOS_UNESCAPE.clone();
        }

        public static String[][] JAVA_CTRL_CHARS_ESCAPE() {
            return (String[][])JAVA_CTRL_CHARS_ESCAPE.clone();
        }

        public static String[][] JAVA_CTRL_CHARS_UNESCAPE() {
            return (String[][])JAVA_CTRL_CHARS_UNESCAPE.clone();
        }

        public static String[][] invert(String[][] array) {
            String[][] newarray = new String[array.length][2];
            for (int i = 0; i < array.length; ++i) {
                newarray[i][0] = array[i][1];
                newarray[i][1] = array[i][0];
            }
            return newarray;
        }
    }

    static class CsvUnescaper
    extends CharSequenceTranslator {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("CsvUnescaper should never reach the [1] index");
            }
            if (input.charAt(0) != '\"' || input.charAt(input.length() - 1) != '\"') {
                out.write(input.toString());
                return Character.codePointCount(input, 0, input.length());
            }
            String quoteless = input.subSequence(1, input.length() - 1).toString();
            if (StringUtil.containsAny(quoteless, CSV_SEARCH_CHARS)) {
                out.write(StringUtil.replaceAll(quoteless, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR));
            } else {
                out.write(input.toString());
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }

    static class CsvEscaper
    extends CharSequenceTranslator {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvEscaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("CsvEscaper should never reach the [1] index");
            }
            if (StringUtil.containsNone(input.toString(), CSV_SEARCH_CHARS)) {
                out.write(input.toString());
            } else {
                out.write(34);
                out.write(StringUtil.replaceAll(input.toString(), CSV_QUOTE_STR, CSV_QUOTE_STR + CSV_QUOTE_STR));
                out.write(34);
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }

    static abstract class CodePointTranslator
    extends CharSequenceTranslator {
        CodePointTranslator() {
        }

        @Override
        public final int translate(CharSequence input, int index, Writer out) throws IOException {
            int codepoint = Character.codePointAt(input, index);
            boolean consumed = this.translate(codepoint, out);
            return consumed ? 1 : 0;
        }

        public abstract boolean translate(int var1, Writer var2) throws IOException;
    }

    static class LookupTranslator
    extends CharSequenceTranslator {
        private final Map<String, String> lookupMap = new HashMap<String, String>();
        private final Set<Character> prefixSet = N.newHashSet();
        private final int shortest;
        private final int longest;

        @SafeVarargs
        public LookupTranslator(CharSequence[] ... lookup) {
            int _shortest = Integer.MAX_VALUE;
            int _longest = 0;
            if (lookup != null) {
                for (CharSequence[] seq : lookup) {
                    this.lookupMap.put(seq[0].toString(), seq[1].toString());
                    this.prefixSet.add(Character.valueOf(seq[0].charAt(0)));
                    int sz = seq[0].length();
                    if (sz < _shortest) {
                        _shortest = sz;
                    }
                    if (sz <= _longest) continue;
                    _longest = sz;
                }
            }
            this.shortest = _shortest;
            this.longest = _longest;
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (this.prefixSet.contains(Character.valueOf(input.charAt(index)))) {
                int max = this.longest;
                if (index + this.longest > input.length()) {
                    max = input.length() - index;
                }
                for (int i = max; i >= this.shortest; --i) {
                    CharSequence subSeq = input.subSequence(index, index + i);
                    String result = this.lookupMap.get(subSeq.toString());
                    if (result == null) continue;
                    out.write(result);
                    return i;
                }
            }
            return 0;
        }
    }

    static class NumericEntityUnescaper
    extends CharSequenceTranslator {
        private final EnumSet<OPTION> options;

        @SafeVarargs
        public NumericEntityUnescaper(OPTION ... options) {
            this.options = options.length > 0 ? EnumSet.copyOf(Arrays.asList(options)) : EnumSet.copyOf(Arrays.asList(OPTION.semiColonRequired));
        }

        public boolean isSet(OPTION option) {
            return this.options == null ? false : this.options.contains((Object)option);
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            int seqEnd = input.length();
            if (input.charAt(index) == '&' && index < seqEnd - 2 && input.charAt(index + 1) == '#') {
                int entityValue;
                boolean semiNext;
                int end;
                int start = index + 2;
                boolean isHex = false;
                char firstChar = input.charAt(start);
                if (firstChar == 'x' || firstChar == 'X') {
                    isHex = true;
                    if (++start == seqEnd) {
                        return 0;
                    }
                }
                for (end = start; end < seqEnd && (input.charAt(end) >= '0' && input.charAt(end) <= '9' || input.charAt(end) >= 'a' && input.charAt(end) <= 'f' || input.charAt(end) >= 'A' && input.charAt(end) <= 'F'); ++end) {
                }
                boolean bl = semiNext = end != seqEnd && input.charAt(end) == ';';
                if (!semiNext) {
                    if (this.isSet(OPTION.semiColonRequired)) {
                        return 0;
                    }
                    if (this.isSet(OPTION.errorIfNoSemiColon)) {
                        throw new IllegalArgumentException("Semi-colon required at end of numeric entity");
                    }
                }
                try {
                    entityValue = isHex ? Integer.parseInt(input.subSequence(start, end).toString(), 16) : Integer.parseInt(input.subSequence(start, end).toString(), 10);
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
                if (entityValue > 65535) {
                    char[] chrs = Character.toChars(entityValue);
                    out.write(chrs[0]);
                    out.write(chrs[1]);
                } else {
                    out.write(entityValue);
                }
                return 2 + end - start + (isHex ? 1 : 0) + (semiNext ? 1 : 0);
            }
            return 0;
        }

        public static enum OPTION {
            semiColonRequired,
            semiColonOptional,
            errorIfNoSemiColon;

        }
    }

    static class OctalUnescaper
    extends CharSequenceTranslator {
        OctalUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            int remaining = input.length() - index - 1;
            StringBuilder builder = new StringBuilder();
            if (input.charAt(index) == '\\' && remaining > 0 && this.isOctalDigit(input.charAt(index + 1))) {
                int next = index + 1;
                int next2 = index + 2;
                int next3 = index + 3;
                builder.append(input.charAt(next));
                if (remaining > 1 && this.isOctalDigit(input.charAt(next2))) {
                    builder.append(input.charAt(next2));
                    if (remaining > 2 && this.isZeroToThree(input.charAt(next)) && this.isOctalDigit(input.charAt(next3))) {
                        builder.append(input.charAt(next3));
                    }
                }
                out.write(Integer.parseInt(builder.toString(), 8));
                return 1 + builder.length();
            }
            return 0;
        }

        private boolean isOctalDigit(char ch) {
            return ch >= '0' && ch <= '7';
        }

        private boolean isZeroToThree(char ch) {
            return ch >= '0' && ch <= '3';
        }
    }

    static class UnicodeEscaper
    extends CodePointTranslator {
        private final int below;
        private final int above;
        private final boolean between;

        public UnicodeEscaper() {
            this(0, Integer.MAX_VALUE, true);
        }

        protected UnicodeEscaper(int below, int above, boolean between) {
            this.below = below;
            this.above = above;
            this.between = between;
        }

        public static UnicodeEscaper below(int codepoint) {
            return UnicodeEscaper.outsideOf(codepoint, Integer.MAX_VALUE);
        }

        public static UnicodeEscaper above(int codepoint) {
            return UnicodeEscaper.outsideOf(0, codepoint);
        }

        public static UnicodeEscaper outsideOf(int codepointLow, int codepointHigh) {
            return new UnicodeEscaper(codepointLow, codepointHigh, false);
        }

        public static UnicodeEscaper between(int codepointLow, int codepointHigh) {
            return new UnicodeEscaper(codepointLow, codepointHigh, true);
        }

        @Override
        public boolean translate(int codepoint, Writer out) throws IOException {
            if (this.between ? codepoint < this.below || codepoint > this.above : codepoint >= this.below && codepoint <= this.above) {
                return false;
            }
            if (codepoint > 65535) {
                out.write(this.toUtf16Escape(codepoint));
            } else {
                out.write("\\u");
                out.write(HEX_DIGITS[codepoint >> 12 & 0xF]);
                out.write(HEX_DIGITS[codepoint >> 8 & 0xF]);
                out.write(HEX_DIGITS[codepoint >> 4 & 0xF]);
                out.write(HEX_DIGITS[codepoint & 0xF]);
            }
            return true;
        }

        protected String toUtf16Escape(int codepoint) {
            return "\\u" + UnicodeEscaper.hex(codepoint);
        }
    }

    static class UnicodeUnescaper
    extends CharSequenceTranslator {
        UnicodeUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (input.charAt(index) == '\\' && index + 1 < input.length() && input.charAt(index + 1) == 'u') {
                int i = 2;
                while (index + i < input.length() && input.charAt(index + i) == 'u') {
                    ++i;
                }
                if (index + i < input.length() && input.charAt(index + i) == '+') {
                    ++i;
                }
                if (index + i + 4 <= input.length()) {
                    CharSequence unicode = input.subSequence(index + i, index + i + 4);
                    try {
                        int value = Integer.parseInt(unicode.toString(), 16);
                        out.write((char)value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                    }
                    return i + 4;
                }
                throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index, input.length()) + "' due to end of CharSequence");
            }
            return 0;
        }
    }

    static class UnicodeUnpairedSurrogateRemover
    extends CodePointTranslator {
        UnicodeUnpairedSurrogateRemover() {
        }

        @Override
        public boolean translate(int codepoint, Writer out) throws IOException {
            return codepoint >= 55296 && codepoint <= 57343;
        }
    }

    static class NumericEntityEscaper
    extends CodePointTranslator {
        private final int below;
        private final int above;
        private final boolean between;

        private NumericEntityEscaper(int below, int above, boolean between) {
            this.below = below;
            this.above = above;
            this.between = between;
        }

        public NumericEntityEscaper() {
            this(0, Integer.MAX_VALUE, true);
        }

        public static NumericEntityEscaper below(int codepoint) {
            return NumericEntityEscaper.outsideOf(codepoint, Integer.MAX_VALUE);
        }

        public static NumericEntityEscaper above(int codepoint) {
            return NumericEntityEscaper.outsideOf(0, codepoint);
        }

        public static NumericEntityEscaper between(int codepointLow, int codepointHigh) {
            return new NumericEntityEscaper(codepointLow, codepointHigh, true);
        }

        public static NumericEntityEscaper outsideOf(int codepointLow, int codepointHigh) {
            return new NumericEntityEscaper(codepointLow, codepointHigh, false);
        }

        @Override
        public boolean translate(int codepoint, Writer out) throws IOException {
            if (this.between ? codepoint < this.below || codepoint > this.above : codepoint >= this.below && codepoint <= this.above) {
                return false;
            }
            out.write("&#");
            out.write(Integer.toString(codepoint, 10));
            out.write(59);
            return true;
        }
    }

    static class JavaUnicodeEscaper
    extends UnicodeEscaper {
        public static JavaUnicodeEscaper above(int codepoint) {
            return JavaUnicodeEscaper.outsideOf(0, codepoint);
        }

        public static JavaUnicodeEscaper below(int codepoint) {
            return JavaUnicodeEscaper.outsideOf(codepoint, Integer.MAX_VALUE);
        }

        public static JavaUnicodeEscaper between(int codepointLow, int codepointHigh) {
            return new JavaUnicodeEscaper(codepointLow, codepointHigh, true);
        }

        public static JavaUnicodeEscaper outsideOf(int codepointLow, int codepointHigh) {
            return new JavaUnicodeEscaper(codepointLow, codepointHigh, false);
        }

        public JavaUnicodeEscaper(int below, int above, boolean between) {
            super(below, above, between);
        }

        @Override
        protected String toUtf16Escape(int codepoint) {
            char[] surrogatePair = Character.toChars(codepoint);
            return "\\u" + JavaUnicodeEscaper.hex(surrogatePair[0]) + "\\u" + JavaUnicodeEscaper.hex(surrogatePair[1]);
        }
    }

    static class AggregateTranslator
    extends CharSequenceTranslator {
        private final CharSequenceTranslator[] translators;

        @SafeVarargs
        public AggregateTranslator(CharSequenceTranslator ... translators) {
            this.translators = N.clone(translators);
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            for (CharSequenceTranslator translator : this.translators) {
                int consumed = translator.translate(input, index, out);
                if (consumed == 0) continue;
                return consumed;
            }
            return 0;
        }
    }

    public static abstract class CharSequenceTranslator {
        static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        public abstract int translate(CharSequence var1, int var2, Writer var3) throws IOException;

        public final String translate(CharSequence input) {
            if (input == null) {
                return null;
            }
            try {
                StringWriter writer = new StringWriter(input.length() * 2);
                this.translate(input, writer);
                return writer.toString();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        public final void translate(CharSequence input, Writer out) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException("The Writer must not be null");
            }
            if (input == null) {
                return;
            }
            int pos = 0;
            int len = input.length();
            while (pos < len) {
                int consumed = this.translate(input, pos, out);
                if (consumed == 0) {
                    char c2;
                    char c1 = input.charAt(pos);
                    out.write(c1);
                    if (!Character.isHighSurrogate(c1) || ++pos >= len || !Character.isLowSurrogate(c2 = input.charAt(pos))) continue;
                    out.write(c2);
                    ++pos;
                    continue;
                }
                for (int pt = 0; pt < consumed; ++pt) {
                    pos += Character.charCount(Character.codePointAt(input, pos));
                }
            }
        }

        @SafeVarargs
        public final CharSequenceTranslator with(CharSequenceTranslator ... translators) {
            CharSequenceTranslator[] newArray = new CharSequenceTranslator[translators.length + 1];
            newArray[0] = this;
            System.arraycopy(translators, 0, newArray, 1, translators.length);
            return new AggregateTranslator(newArray);
        }

        public static String hex(int codepoint) {
            return Integer.toHexString(codepoint).toUpperCase(Locale.ENGLISH);
        }
    }
}

