/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedException;
import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.exception.UncheckedSQLException;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.Predicate;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public final class ExceptionUtil {
    private static final Map<Class<? extends Throwable>, Function<Throwable, RuntimeException>> toRuntimeExceptionFuncMap = new HashMap<Class<? extends Throwable>, Function<Throwable, RuntimeException>>();
    private static final Function<Throwable, RuntimeException> RUNTIME_FUNC;
    private static final Function<Throwable, RuntimeException> CHECKED_FUNC;
    private static final String UncheckedSQLExceptionClassName;
    private static final String UncheckedIOExceptionClassName;

    private ExceptionUtil() {
    }

    public static RuntimeException toRuntimeException(Throwable e) {
        Class<?> cls = e.getClass();
        Function<Throwable, RuntimeException> func = toRuntimeExceptionFuncMap.get(cls);
        if (func == null) {
            for (Class<? extends Throwable> key : toRuntimeExceptionFuncMap.keySet()) {
                if (!key.isAssignableFrom(cls)) continue;
                func = toRuntimeExceptionFuncMap.get(key);
                break;
            }
            if (func == null) {
                func = e instanceof RuntimeException ? RUNTIME_FUNC : CHECKED_FUNC;
            }
        }
        return func.apply(e);
    }

    public static String getMessage(Throwable e) {
        if (e instanceof SQLException) {
            return e.getClass().getSimpleName() + "|" + ((SQLException)e).getErrorCode() + "|" + (e.getMessage() == null ? e.getCause() : e.getMessage());
        }
        return e.getClass().getSimpleName() + "|" + (e.getMessage() == null ? e.getCause() : e.getMessage());
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static boolean hasCause(Throwable throwable, Class<? extends Throwable> type) {
        while (throwable != null) {
            if (type.isAssignableFrom(throwable.getClass())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean hasCause(Throwable throwable, Predicate<? super Throwable> predicate) {
        while (throwable != null) {
            if (predicate.test(throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean hasSQLCause(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof SQLException || UncheckedSQLExceptionClassName.equals(throwable.getClass().getSimpleName())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean hasIOCause(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof IOException || UncheckedIOExceptionClassName.equals(throwable.getClass().getSimpleName())) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static List<Throwable> listCause(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return list;
    }

    public static Throwable firstCause(Throwable throwable) {
        Throwable result = throwable;
        while (result.getCause() != null) {
            result = result.getCause();
        }
        return result;
    }

    public static String getErrorMessage(Throwable e) {
        return ExceptionUtil.getErrorMessage(e, false);
    }

    public static String getErrorMessage(Throwable e, boolean withExceptionClassName) {
        String msg = e.getMessage();
        if (N.isNullOrEmpty(msg) && e.getCause() != null) {
            Throwable cause = e.getCause();
            while (!N.notNullOrEmpty(msg = cause.getMessage()) && (cause = e.getCause()) != null) {
            }
        }
        if (N.isNullOrEmpty(msg)) {
            return e.getClass().getCanonicalName();
        }
        if (withExceptionClassName) {
            return withExceptionClassName + ": " + msg;
        }
        return msg;
    }

    static {
        toRuntimeExceptionFuncMap.put(RuntimeException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return (RuntimeException)e;
            }
        });
        toRuntimeExceptionFuncMap.put(IOException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return new UncheckedIOException((IOException)e);
            }
        });
        toRuntimeExceptionFuncMap.put(SQLException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return new UncheckedSQLException((SQLException)e);
            }
        });
        toRuntimeExceptionFuncMap.put(ExecutionException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return e.getCause() == null ? new UncheckedException(e) : ExceptionUtil.toRuntimeException(e.getCause());
            }
        });
        toRuntimeExceptionFuncMap.put(InvocationTargetException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return e.getCause() == null ? new UncheckedException(e) : ExceptionUtil.toRuntimeException(e.getCause());
            }
        });
        toRuntimeExceptionFuncMap.put(UndeclaredThrowableException.class, new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return e.getCause() == null ? new UncheckedException(e) : ExceptionUtil.toRuntimeException(e.getCause());
            }
        });
        RUNTIME_FUNC = new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return (RuntimeException)e;
            }
        };
        CHECKED_FUNC = new Function<Throwable, RuntimeException>(){

            @Override
            public RuntimeException apply(Throwable e) {
                return new UncheckedException(e);
            }
        };
        UncheckedSQLExceptionClassName = UncheckedSQLException.class.getSimpleName();
        UncheckedIOExceptionClassName = UncheckedIOException.class.getSimpleName();
    }
}

