/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DataSet;
import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.annotation.IntermediateOp;
import com.landawn.abacus.annotation.LazyEvaluation;
import com.landawn.abacus.annotation.SequentialOnly;
import com.landawn.abacus.annotation.TerminalOp;
import com.landawn.abacus.annotation.TerminalOpTriggered;
import com.landawn.abacus.exception.DuplicatedResultException;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.BufferedWriter;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.If;
import com.landawn.abacus.util.Immutable;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.InternalUtil;
import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.KahanSummation;
import com.landawn.abacus.util.Keyed;
import com.landawn.abacus.util.ListMultimap;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.MergeResult;
import com.landawn.abacus.util.Multimap;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.MutableBoolean;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.MutableLong;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Percentage;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Wrapper;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.stream.Collector;
import com.landawn.abacus.util.stream.Collectors;
import com.landawn.abacus.util.u;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.Set;

@LazyEvaluation
@SequentialOnly
@com.landawn.abacus.annotation.Immutable
public class ExceptionalStream<T, E extends Exception>
implements Closeable,
Immutable {
    static final Logger logger = LoggerFactory.getLogger(ExceptionalStream.class);
    static final Random RAND = new SecureRandom();
    static final Throwables.Function<Map.Entry<Keyed<Object, Object>, Object>, Object, Exception> KK = new Throwables.Function<Map.Entry<Keyed<Object, Object>, Object>, Object, Exception>(){

        @Override
        public Object apply(Map.Entry<Keyed<Object, Object>, Object> t) throws Exception {
            return t.getKey().val();
        }
    };
    private final ExceptionalIterator<T, E> elements;
    private final boolean sorted;
    private final Comparator<? super T> cmp;
    private final Deque<Throwables.Runnable<? extends E>> closeHandlers;
    private boolean isClosed = false;
    private static Throwables.Function HOLDER_VALUE_GETTER = new Throwables.Function<u.Holder<Object>, Object, RuntimeException>(){

        @Override
        public Object apply(u.Holder<Object> t) {
            return t.value();
        }
    };
    private static final Throwables.Function<Object, String, IOException> TO_LINE_OF_STRING = new Throwables.Function<Object, String, IOException>(){

        @Override
        public String apply(Object t) throws IOException {
            return N.stringOf(t);
        }
    };

    ExceptionalStream(ExceptionalIterator<T, E> iter) {
        this(iter, false, null, null);
    }

    ExceptionalStream(ExceptionalIterator<T, E> iter, Deque<Throwables.Runnable<? extends E>> closeHandlers) {
        this(iter, false, null, closeHandlers);
    }

    ExceptionalStream(ExceptionalIterator<T, E> iter, boolean sorted, Comparator<? super T> comparator, Deque<Throwables.Runnable<? extends E>> closeHandlers) {
        this.elements = iter;
        this.sorted = sorted;
        this.cmp = comparator;
        this.closeHandlers = closeHandlers;
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> empty() {
        return new ExceptionalStream<T, E>(ExceptionalIterator.EMPTY);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> just(T e) {
        return ExceptionalStream.of(e);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> just(T e, Class<E> exceptionType) {
        return ExceptionalStream.of(e);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> ofNullable(T e) {
        if (e == null) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(e);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(final T ... a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        final int len = N.len(a);
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private int position = 0;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < len;
            }

            @Override
            public T next() throws Exception {
                if (this.position >= len) {
                    throw new NoSuchElementException();
                }
                return a[this.position++];
            }

            @Override
            public long count() throws Exception {
                return len - this.position;
            }

            @Override
            public void advance(long n) throws Exception {
                this.position = n > (long)(len - this.position) ? len : (int)((long)this.position + n);
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(Collection<? extends T> c) {
        if (N.isNullOrEmpty(c)) {
            return ExceptionalStream.empty();
        }
        final Object[] a = InternalUtil.getInternalArray(c);
        if (a != null) {
            final int len = c.size();
            return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
                private int position = 0;

                @Override
                public boolean hasNext() throws Exception {
                    return this.position < len;
                }

                @Override
                public T next() throws Exception {
                    if (this.position >= len) {
                        throw new NoSuchElementException();
                    }
                    return a[this.position++];
                }

                @Override
                public long count() throws Exception {
                    return len - this.position;
                }

                @Override
                public void advance(long n) throws Exception {
                    this.position = n > (long)(len - this.position) ? len : (int)((long)this.position + n);
                }
            });
        }
        return ExceptionalStream.of(c.iterator());
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(Iterator<? extends T> iter) {
        if (iter == null) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.newStream(ExceptionalIterator.wrap(iter));
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(Iterable<? extends T> iterable) {
        if (iterable == null) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(iterable.iterator());
    }

    public static <K, V, E extends Exception> ExceptionalStream<Map.Entry<K, V>, E> of(Map<K, V> m) {
        if (m == null) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(m.entrySet());
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(Collection<? extends T> c, Class<E> exceptionType) {
        return ExceptionalStream.of(c);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(Iterator<? extends T> iter, Class<E> exceptionType) {
        return ExceptionalStream.of(iter);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(Iterable<? extends T> iterable, Class<E> exceptionType) {
        return ExceptionalStream.of(iterable);
    }

    public static <K, V, E extends Exception> ExceptionalStream<Map.Entry<K, V>, E> of(Map<K, V> m, Class<E> exceptionType) {
        return ExceptionalStream.of(m);
    }

    public static <E extends Exception> ExceptionalStream<Integer, E> of(final int[] a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        final int len = N.len(a);
        return ExceptionalStream.newStream(new ExceptionalIterator<Integer, E>(){
            private int position = 0;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < len;
            }

            @Override
            public Integer next() throws Exception {
                return a[this.position++];
            }

            @Override
            public long count() throws Exception {
                return len - this.position;
            }

            @Override
            public void advance(long n) throws Exception {
                this.position = n > (long)(len - this.position) ? len : (int)((long)this.position + n);
            }
        });
    }

    public static <E extends Exception> ExceptionalStream<Long, E> of(final long[] a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        final int len = N.len(a);
        return ExceptionalStream.newStream(new ExceptionalIterator<Long, E>(){
            private int position = 0;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < len;
            }

            @Override
            public Long next() throws Exception {
                return a[this.position++];
            }

            @Override
            public long count() throws Exception {
                return len - this.position;
            }

            @Override
            public void advance(long n) throws Exception {
                this.position = n > (long)(len - this.position) ? len : (int)((long)this.position + n);
            }
        });
    }

    public static <E extends Exception> ExceptionalStream<Double, E> of(final double[] a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        final int len = N.len(a);
        return ExceptionalStream.newStream(new ExceptionalIterator<Double, E>(){
            private int position = 0;

            @Override
            public boolean hasNext() throws Exception {
                return this.position < len;
            }

            @Override
            public Double next() throws Exception {
                return a[this.position++];
            }

            @Override
            public long count() throws Exception {
                return len - this.position;
            }

            @Override
            public void advance(long n) throws Exception {
                this.position = n > (long)(len - this.position) ? len : (int)((long)this.position + n);
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> of(u.Optional<T> op) {
        return op == null || !op.isPresent() ? ExceptionalStream.empty() : ExceptionalStream.of(op.get());
    }

    @Beta
    public static <T, E extends Exception> ExceptionalStream<T, E> of(Throwables.Supplier<Collection<? extends T>, ? extends E> supplier) {
        N.checkArgNotNull(supplier, "supplier");
        return ExceptionalStream.just(supplier).flattMap(new Throwables.Function<Throwables.Supplier<Collection<? extends T>, ? extends E>, Collection<? extends T>, E>(){

            @Override
            public Collection<? extends T> apply(Throwables.Supplier<Collection<? extends T>, ? extends E> t) throws Exception {
                return t.get();
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> from(Throwables.Supplier<ExceptionalStream<? extends T, ? extends E>, ? extends E> supplier) {
        N.checkArgNotNull(supplier, "supplier");
        return ExceptionalStream.just(supplier).flatMap(new Throwables.Function<Throwables.Supplier<ExceptionalStream<? extends T, ? extends E>, ? extends E>, ExceptionalStream<? extends T, ? extends E>, E>(){

            @Override
            public ExceptionalStream<? extends T, ? extends E> apply(Throwables.Supplier<ExceptionalStream<? extends T, ? extends E>, ? extends E> t) throws Exception {
                return t.get();
            }
        });
    }

    public static <K, E extends Exception> ExceptionalStream<K, E> ofKeys(Map<K, ?> map) {
        if (N.isNullOrEmpty(map)) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(map.keySet());
    }

    public static <K, V, E extends Exception> ExceptionalStream<K, E> ofKeys(Map<K, V> map, Throwables.Predicate<? super V, E> valueFilter) {
        if (map == null || map.size() == 0) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(map).filter(Fn.Fnn.testByValue(valueFilter)).map(Fn.Fnn.key());
    }

    public static <K, V, E extends Exception> ExceptionalStream<K, E> ofKeys(Map<K, V> map, Throwables.BiPredicate<? super K, ? super V, E> filter) {
        if (map == null || map.size() == 0) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(map).filter(Fn.Entries.ep(filter)).map(Fn.Fnn.key());
    }

    public static <V, E extends Exception> ExceptionalStream<V, E> ofValues(Map<?, V> map) {
        if (N.isNullOrEmpty(map)) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(map.values());
    }

    public static <K, V, E extends Exception> ExceptionalStream<V, E> ofValues(Map<K, V> map, Throwables.Predicate<? super K, E> keyFilter) {
        if (map == null || map.size() == 0) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(map).filter(Fn.Fnn.testByKey(keyFilter)).map(Fn.Fnn.value());
    }

    public static <K, V, E extends Exception> ExceptionalStream<V, E> ofValues(Map<K, V> map, Throwables.BiPredicate<? super K, ? super V, E> filter) {
        if (map == null || map.size() == 0) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(map).filter(Fn.Entries.ep(filter)).map(Fn.Fnn.value());
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> iterate(final Throwables.BooleanSupplier<? extends E> hasNext, final Throwables.Supplier<? extends T, E> next) {
        N.checkArgNotNull(hasNext, "hasNext");
        N.checkArgNotNull(next, "next");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean hasNextVal = false;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.hasNextVal) {
                    this.hasNextVal = hasNext.getAsBoolean();
                }
                return this.hasNextVal;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNextVal && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextVal = false;
                return next.get();
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> iterate(final T init, final Throwables.BooleanSupplier<? extends E> hasNext, final Throwables.UnaryOperator<T, ? extends E> f) {
        N.checkArgNotNull(hasNext, "hasNext");
        N.checkArgNotNull(f, "f");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final T NONE = N.NULL_MASK;
            private T t = this.NONE;
            private boolean hasNextVal = false;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.hasNextVal) {
                    this.hasNextVal = hasNext.getAsBoolean();
                }
                return this.hasNextVal;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNextVal && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNextVal = false;
                this.t = this.t == this.NONE ? init : f.apply(this.t);
                return this.t;
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> iterate(final T init, final Throwables.Predicate<? super T, ? extends E> hasNext, final Throwables.UnaryOperator<T, ? extends E> f) {
        N.checkArgNotNull(hasNext, "hasNext");
        N.checkArgNotNull(f, "f");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final T NONE = N.NULL_MASK;
            private T t = this.NONE;
            private T cur = this.NONE;
            private boolean hasMore = true;
            private boolean hasNextVal = false;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.hasNextVal && this.hasMore) {
                    this.cur = this.t == this.NONE ? init : f.apply(this.t);
                    this.hasNextVal = hasNext.test(this.cur);
                    if (!this.hasNextVal) {
                        this.hasMore = false;
                    }
                }
                return this.hasNextVal;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNextVal && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.t = this.cur;
                this.cur = this.NONE;
                this.hasNextVal = false;
                return this.t;
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> iterate(final T init, final Throwables.UnaryOperator<T, ? extends E> f) {
        N.checkArgNotNull(f, "f");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final T NONE = N.NULL_MASK;
            private T t = this.NONE;

            @Override
            public boolean hasNext() throws Exception {
                return true;
            }

            @Override
            public T next() throws Exception {
                this.t = this.t == this.NONE ? init : f.apply(this.t);
                return this.t;
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> generate(final Throwables.Supplier<T, E> supplier) {
        N.checkArgNotNull(supplier, "supplier");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return true;
            }

            @Override
            public T next() throws Exception {
                return supplier.get();
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> repeat(final T element, final long n) {
        N.checkArgNotNegative(n, "n");
        if (n == 0L) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private long cnt;
            {
                this.cnt = n;
            }

            @Override
            public boolean hasNext() throws Exception {
                return this.cnt > 0L;
            }

            @Override
            public T next() throws Exception {
                if (this.cnt-- <= 0L) {
                    throw new NoSuchElementException();
                }
                return element;
            }
        });
    }

    public static ExceptionalStream<String, IOException> lines(File file) {
        return ExceptionalStream.lines(file, Charsets.UTF_8);
    }

    public static ExceptionalStream<String, IOException> lines(File file, Charset charset) {
        N.checkArgNotNull(file, "file");
        final ExceptionalIterator<String, IOException> iter = ExceptionalStream.createLazyLineIterator(file, null, charset, null, true);
        return ExceptionalStream.newStream(iter).onClose(new Throwables.Runnable<IOException>(){

            @Override
            public void run() throws IOException {
                iter.close();
            }
        });
    }

    public static ExceptionalStream<String, IOException> lines(Path path) {
        return ExceptionalStream.lines(path, Charsets.UTF_8);
    }

    public static ExceptionalStream<String, IOException> lines(Path path, Charset charset) {
        N.checkArgNotNull(path, "path");
        final ExceptionalIterator<String, IOException> iter = ExceptionalStream.createLazyLineIterator(null, path, charset, null, true);
        return ExceptionalStream.newStream(iter).onClose(new Throwables.Runnable<IOException>(){

            @Override
            public void run() throws IOException {
                iter.close();
            }
        });
    }

    public static ExceptionalStream<String, IOException> lines(Reader reader) {
        N.checkArgNotNull(reader, "reader");
        return ExceptionalStream.newStream(ExceptionalStream.createLazyLineIterator(null, null, Charsets.UTF_8, reader, false));
    }

    public static ExceptionalStream<File, IOException> listFiles(File parentPath) {
        if (!parentPath.exists()) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(parentPath.listFiles());
    }

    public static ExceptionalStream<File, IOException> listFiles(final File parentPath, boolean recursively) {
        if (!parentPath.exists()) {
            return ExceptionalStream.empty();
        }
        if (!recursively) {
            return ExceptionalStream.of(parentPath.listFiles());
        }
        ExceptionalIterator<File, IOException> iter = new ExceptionalIterator<File, IOException>(){
            private final Queue<File> paths;
            private File[] subFiles;
            private int cursor;
            {
                this.paths = N.asLinkedList(parentPath);
                this.subFiles = null;
                this.cursor = 0;
            }

            @Override
            public boolean hasNext() {
                if ((this.subFiles == null || this.cursor >= this.subFiles.length) && this.paths.size() > 0) {
                    this.cursor = 0;
                    this.subFiles = null;
                    while (this.paths.size() > 0) {
                        this.subFiles = this.paths.poll().listFiles();
                        if (!N.notNullOrEmpty(this.subFiles)) continue;
                    }
                }
                return this.subFiles != null && this.cursor < this.subFiles.length;
            }

            @Override
            public File next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.subFiles[this.cursor].isDirectory()) {
                    this.paths.offer(this.subFiles[this.cursor]);
                }
                return this.subFiles[this.cursor++];
            }
        };
        return ExceptionalStream.newStream(iter);
    }

    private static ExceptionalIterator<String, IOException> createLazyLineIterator(final File file, final Path path, final Charset charset, final Reader reader, final boolean closeReader) {
        return ExceptionalIterator.of(new Throwables.Supplier<ExceptionalIterator<String, IOException>, IOException>(){
            private ExceptionalIterator<String, IOException> lazyIter = null;

            @Override
            public synchronized ExceptionalIterator<String, IOException> get() {
                if (this.lazyIter == null) {
                    this.lazyIter = new ExceptionalIterator<String, IOException>(){
                        private BufferedReader bufferedReader;
                        private String cachedLine;
                        private boolean finished;
                        {
                            this.bufferedReader = reader != null ? (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader)) : (file != null ? IOUtil.newBufferedReader(file, charset == null ? Charsets.UTF_8 : charset) : IOUtil.newBufferedReader(path, charset == null ? Charsets.UTF_8 : charset));
                            this.finished = false;
                        }

                        @Override
                        public boolean hasNext() throws IOException {
                            if (this.cachedLine != null) {
                                return true;
                            }
                            if (this.finished) {
                                return false;
                            }
                            this.cachedLine = this.bufferedReader.readLine();
                            if (this.cachedLine == null) {
                                this.finished = true;
                                return false;
                            }
                            return true;
                        }

                        @Override
                        public String next() throws IOException {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException("No more lines");
                            }
                            String res = this.cachedLine;
                            this.cachedLine = null;
                            return res;
                        }

                        @Override
                        public void close() throws IOException {
                            if (closeReader) {
                                IOUtil.close(this.bufferedReader);
                            }
                        }
                    };
                }
                return this.lazyIter;
            }
        });
    }

    @SafeVarargs
    public static <T, E extends Exception> ExceptionalStream<T, E> concat(T[] ... a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(Iterators.concat(a));
    }

    @SafeVarargs
    public static <T, E extends Exception> ExceptionalStream<T, E> concat(Collection<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.of(Iterators.concat(a));
    }

    @SafeVarargs
    public static <T, E extends Exception> ExceptionalStream<T, E> concat(ExceptionalStream<? extends T, E> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.concat(Array.asList(a));
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> concat(final Collection<? extends ExceptionalStream<? extends T, E>> c) {
        if (N.isNullOrEmpty(c)) {
            return ExceptionalStream.empty();
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final Iterator<? extends ExceptionalStream<? extends T, E>> iterators;
            private ExceptionalStream<? extends T, E> cur;
            private ExceptionalIterator<? extends T, E> iter;
            {
                this.iterators = c.iterator();
            }

            @Override
            public boolean hasNext() throws Exception {
                while ((this.iter == null || !this.iter.hasNext()) && this.iterators.hasNext()) {
                    if (this.cur != null) {
                        this.cur.close();
                    }
                    this.cur = this.iterators.next();
                    this.iter = this.cur.elements;
                }
                return this.iter != null && this.iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!(this.iter != null && this.iter.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.iter.next();
            }
        }, ExceptionalStream.mergeCloseHandlers(c));
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(A[] a, B[] b, Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(ObjIterator.of(a), ObjIterator.of(b), zipFunction);
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(A[] a, B[] b, C[] c, Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(ObjIterator.of(a), ObjIterator.of(b), ObjIterator.of(c), zipFunction);
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(Collection<? extends A> a, Collection<? extends B> b, Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(N.iterate(a), N.iterate(b), zipFunction);
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(Collection<? extends A> a, Collection<? extends B> b, Collection<? extends C> c, Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(N.iterate(a), N.iterate(b), N.iterate(c), zipFunction);
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(final Iterator<? extends A> a, final Iterator<? extends B> b, final Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return a.hasNext() && b.hasNext();
            }

            @Override
            public T next() throws Exception {
                return zipFunction.apply(a.next(), b.next());
            }
        });
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(final Iterator<? extends A> a, final Iterator<? extends B> b, final Iterator<? extends C> c, final Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return a.hasNext() && b.hasNext() && c.hasNext();
            }

            @Override
            public T next() throws Exception {
                return zipFunction.apply(a.next(), b.next(), c.next());
            }
        });
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(final ExceptionalStream<? extends A, E> a, final ExceptionalStream<? extends B, E> b, final Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final ExceptionalIterator<? extends A, E> iterA;
            private final ExceptionalIterator<? extends B, E> iterB;
            {
                this.iterA = a.elements;
                this.iterB = b.elements;
            }

            @Override
            public boolean hasNext() throws Exception {
                return this.iterA.hasNext() && this.iterB.hasNext();
            }

            @Override
            public T next() throws Exception {
                return zipFunction.apply(this.iterA.next(), this.iterB.next());
            }
        }, ExceptionalStream.mergeCloseHandlers(Array.asList(a, b)));
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(final ExceptionalStream<? extends A, E> a, final ExceptionalStream<? extends B, E> b, final ExceptionalStream<? extends C, E> c, final Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final ExceptionalIterator<? extends A, E> iterA;
            private final ExceptionalIterator<? extends B, E> iterB;
            private final ExceptionalIterator<? extends C, E> iterC;
            {
                this.iterA = a.elements;
                this.iterB = b.elements;
                this.iterC = c.elements;
            }

            @Override
            public boolean hasNext() throws Exception {
                return this.iterA.hasNext() && this.iterB.hasNext() && this.iterC.hasNext();
            }

            @Override
            public T next() throws Exception {
                return zipFunction.apply(this.iterA.next(), this.iterB.next(), this.iterC.next());
            }
        }, ExceptionalStream.mergeCloseHandlers(Array.asList(a, b, c)));
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(A[] a, B[] b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(ObjIterator.of(a), ObjIterator.of(b), valueForNoneA, valueForNoneB, zipFunction);
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(ObjIterator.of(a), ObjIterator.of(b), ObjIterator.of(c), valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(Collection<? extends A> a, Collection<? extends B> b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(N.iterate(a), N.iterate(b), valueForNoneA, valueForNoneB, zipFunction);
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(Collection<? extends A> a, Collection<? extends B> b, Collection<? extends C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.zip(N.iterate(a), N.iterate(b), N.iterate(c), valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(final Iterator<? extends A> a, final Iterator<? extends B> b, final A valueForNoneA, final B valueForNoneB, final Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return a.hasNext() || b.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return zipFunction.apply(a.hasNext() ? a.next() : valueForNoneA, b.hasNext() ? b.next() : valueForNoneB);
            }
        });
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(final Iterator<? extends A> a, final Iterator<? extends B> b, final Iterator<? extends C> c, final A valueForNoneA, final B valueForNoneB, final C valueForNoneC, final Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return a.hasNext() || b.hasNext() || c.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return zipFunction.apply(a.hasNext() ? a.next() : valueForNoneA, b.hasNext() ? b.next() : valueForNoneB, c.hasNext() ? c.next() : valueForNoneC);
            }
        });
    }

    public static <A, B, T, E extends Exception> ExceptionalStream<T, E> zip(final ExceptionalStream<? extends A, E> a, final ExceptionalStream<? extends B, E> b, final A valueForNoneA, final B valueForNoneB, final Throwables.BiFunction<? super A, ? super B, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final ExceptionalIterator<? extends A, E> iterA;
            private final ExceptionalIterator<? extends B, E> iterB;
            {
                this.iterA = a.elements;
                this.iterB = b.elements;
            }

            @Override
            public boolean hasNext() throws Exception {
                return this.iterA.hasNext() || this.iterB.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return zipFunction.apply(this.iterA.hasNext() ? this.iterA.next() : valueForNoneA, this.iterB.hasNext() ? this.iterB.next() : valueForNoneB);
            }
        }, ExceptionalStream.mergeCloseHandlers(Array.asList(a, b)));
    }

    public static <A, B, C, T, E extends Exception> ExceptionalStream<T, E> zip(final ExceptionalStream<? extends A, E> a, final ExceptionalStream<? extends B, E> b, final ExceptionalStream<? extends C, E> c, final A valueForNoneA, final B valueForNoneB, final C valueForNoneC, final Throwables.TriFunction<? super A, ? super B, ? super C, T, ? extends E> zipFunction) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final ExceptionalIterator<? extends A, E> iterA;
            private final ExceptionalIterator<? extends B, E> iterB;
            private final ExceptionalIterator<? extends C, E> iterC;
            {
                this.iterA = a.elements;
                this.iterB = b.elements;
                this.iterC = c.elements;
            }

            @Override
            public boolean hasNext() throws Exception {
                return this.iterA.hasNext() || this.iterB.hasNext() || this.iterC.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return zipFunction.apply(this.iterA.hasNext() ? this.iterA.next() : valueForNoneA, this.iterB.hasNext() ? this.iterB.next() : valueForNoneB, this.iterC.hasNext() ? this.iterC.next() : valueForNoneC);
            }
        }, ExceptionalStream.mergeCloseHandlers(Array.asList(a, b, c)));
    }

    private static <E extends Exception> Deque<Throwables.Runnable<? extends E>> mergeCloseHandlers(Collection<? extends ExceptionalStream<?, E>> closeHandlersList) {
        if (N.isNullOrEmpty(closeHandlersList)) {
            return null;
        }
        int count = 0;
        for (ExceptionalStream<?, E> s : closeHandlersList) {
            count += N.size(s.closeHandlers);
        }
        if (count == 0) {
            return null;
        }
        ArrayDeque<Throwables.Runnable<Throwables.Runnable<? extends E>>> newCloseHandlers = new ArrayDeque<Throwables.Runnable<Throwables.Runnable<? extends E>>>(count);
        for (ExceptionalStream<?, E> s : closeHandlersList) {
            if (!N.notNullOrEmpty(s.closeHandlers)) continue;
            newCloseHandlers.addAll(s.closeHandlers);
        }
        return newCloseHandlers;
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(final T[] a, final T[] b, final Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        if (N.isNullOrEmpty(a)) {
            return ExceptionalStream.of(b);
        }
        if (N.isNullOrEmpty(b)) {
            return ExceptionalStream.of(a);
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final int lenA;
            private final int lenB;
            private int cursorA;
            private int cursorB;
            {
                this.lenA = a.length;
                this.lenB = b.length;
                this.cursorA = 0;
                this.cursorB = 0;
            }

            @Override
            public boolean hasNext() {
                return this.cursorA < this.lenA || this.cursorB < this.lenB;
            }

            @Override
            public T next() throws Exception {
                if (this.cursorA < this.lenA) {
                    if (this.cursorB < this.lenB) {
                        if (nextSelector.apply(a[this.cursorA], b[this.cursorB]) == MergeResult.TAKE_FIRST) {
                            return a[this.cursorA++];
                        }
                        return b[this.cursorB++];
                    }
                    return a[this.cursorA++];
                }
                if (this.cursorB < this.lenB) {
                    return b[this.cursorB++];
                }
                throw new NoSuchElementException();
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(T[] a, T[] b, T[] c, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(ExceptionalStream.merge(a, b, nextSelector).iterator(), ExceptionalIterator.wrap(N.iterate(c)), nextSelector);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(Collection<? extends T> a, Collection<? extends T> b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(N.iterate(a), N.iterate(b), nextSelector);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(Collection<? extends T> a, Collection<? extends T> b, Collection<? extends T> c, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(N.iterate(a), N.iterate(b), N.iterate(c), nextSelector);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(Iterator<? extends T> a, Iterator<? extends T> b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(ExceptionalIterator.wrap(a), ExceptionalIterator.wrap(b), nextSelector);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(ExceptionalStream.merge(a, b, nextSelector).iterator(), ExceptionalIterator.wrap(c), nextSelector);
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(final ExceptionalStream<? extends T, E> a, final ExceptionalStream<? extends T, E> b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(a.iterator(), b.iterator(), nextSelector).onClose(new Throwables.Runnable<E>(){

            @Override
            public void run() throws Exception {
                try {
                    a.close();
                }
                finally {
                    b.close();
                }
            }
        });
    }

    public static <T, E extends Exception> ExceptionalStream<T, E> merge(ExceptionalStream<? extends T, E> a, ExceptionalStream<? extends T, E> b, ExceptionalStream<? extends T, E> c, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.merge(ExceptionalStream.merge(a, b, nextSelector), c, nextSelector);
    }

    static <T, E extends Exception> ExceptionalStream<T, E> merge(final ExceptionalIterator<? extends T, E> a, final ExceptionalIterator<? extends T, E> b, final Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private T nextA = null;
            private T nextB = null;
            private boolean hasNextA = false;
            private boolean hasNextB = false;

            @Override
            public boolean hasNext() throws Exception {
                return this.hasNextA || this.hasNextB || a.hasNext() || b.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.hasNextA) {
                    if (b.hasNext()) {
                        this.nextB = b.next();
                        if (nextSelector.apply(this.nextA, this.nextB) == MergeResult.TAKE_FIRST) {
                            this.hasNextA = false;
                            this.hasNextB = true;
                            return this.nextA;
                        }
                        return this.nextB;
                    }
                    this.hasNextA = false;
                    return this.nextA;
                }
                if (this.hasNextB) {
                    if (a.hasNext()) {
                        this.nextA = a.next();
                        if (nextSelector.apply(this.nextA, this.nextB) == MergeResult.TAKE_FIRST) {
                            return this.nextA;
                        }
                        this.hasNextA = true;
                        this.hasNextB = false;
                        return this.nextB;
                    }
                    this.hasNextB = false;
                    return this.nextB;
                }
                if (a.hasNext()) {
                    if (b.hasNext()) {
                        this.nextA = a.next();
                        if (nextSelector.apply(this.nextA, this.nextB = b.next()) == MergeResult.TAKE_FIRST) {
                            this.hasNextB = true;
                            return this.nextA;
                        }
                        this.hasNextA = true;
                        return this.nextB;
                    }
                    return a.next();
                }
                if (b.hasNext()) {
                    return b.next();
                }
                throw new NoSuchElementException();
            }
        });
    }

    @IntermediateOp
    public ExceptionalStream<T, E> filter(final Throwables.Predicate<? super T, ? extends E> predicate) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.hasNext) {
                    while (ExceptionalStream.this.elements.hasNext()) {
                        this.next = ExceptionalStream.this.elements.next();
                        if (!predicate.test(this.next)) continue;
                        this.hasNext = true;
                        break;
                    }
                }
                return this.hasNext;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return this.next;
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> filter(final Throwables.Predicate<? super T, ? extends E> predicate, final Throwables.Consumer<? super T, ? extends E> actionOnDroppedItem) {
        this.assertNotClosed();
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) throws Exception {
                if (!predicate.test(value)) {
                    actionOnDroppedItem.accept(value);
                    return false;
                }
                return true;
            }
        });
    }

    @IntermediateOp
    public ExceptionalStream<T, E> takeWhile(final Throwables.Predicate<? super T, ? extends E> predicate) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean hasMore = true;
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.hasNext && this.hasMore && ExceptionalStream.this.elements.hasNext()) {
                    this.next = ExceptionalStream.this.elements.next();
                    if (predicate.test(this.next)) {
                        this.hasNext = true;
                    } else {
                        this.hasMore = false;
                    }
                }
                return this.hasNext;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return this.next;
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> dropWhile(final Throwables.Predicate<? super T, ? extends E> predicate) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean hasNext = false;
            private T next = null;
            private boolean dropped = false;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.hasNext) {
                    if (!this.dropped) {
                        this.dropped = true;
                        while (ExceptionalStream.this.elements.hasNext()) {
                            this.next = ExceptionalStream.this.elements.next();
                            if (predicate.test(this.next)) continue;
                            this.hasNext = true;
                            break;
                        }
                    } else if (ExceptionalStream.this.elements.hasNext()) {
                        this.next = ExceptionalStream.this.elements.next();
                        this.hasNext = true;
                    }
                }
                return this.hasNext;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.hasNext = false;
                return this.next;
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> dropWhile(final Throwables.Predicate<? super T, ? extends E> predicate, final Throwables.Consumer<? super T, ? extends E> actionOnDroppedItem) {
        this.assertNotClosed();
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) throws Exception {
                if (!predicate.test(value)) {
                    actionOnDroppedItem.accept(value);
                    return false;
                }
                return true;
            }
        });
    }

    @IntermediateOp
    @Beta
    public ExceptionalStream<T, E> skipUntil(Throwables.Predicate<? super T, ? extends E> predicate) {
        return this.dropWhile(Fn.Fnn.not(predicate));
    }

    @IntermediateOp
    public ExceptionalStream<T, E> distinct() {
        this.assertNotClosed();
        final Set set = N.newHashSet();
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return set.add(ExceptionalStream.hashKey(value));
            }
        });
    }

    @IntermediateOp
    public <K> ExceptionalStream<T, E> distinctBy(final Throwables.Function<? super T, K, ? extends E> keyMapper) {
        this.assertNotClosed();
        final Set set = N.newHashSet();
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) throws Exception {
                return set.add(ExceptionalStream.hashKey(keyMapper.apply(value)));
            }
        });
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K> ExceptionalStream<T, E> distinctBy(final Throwables.Function<? super T, K, ? extends E> keyMapper, final Throwables.Predicate<? super Long, ? extends E> occurrencesFilter) {
        this.assertNotClosed();
        Supplier supplier = Fn.Suppliers.ofLinkedHashMap();
        Throwables.Function keyedMapper = new Throwables.Function<T, Keyed<K, T>, E>(){

            @Override
            public Keyed<K, T> apply(T t) throws Exception {
                return Keyed.of(keyMapper.apply(t), t);
            }
        };
        Throwables.Predicate predicate = new Throwables.Predicate<Map.Entry<Keyed<K, T>, Long>, E>(){

            @Override
            public boolean test(Map.Entry<Keyed<K, T>, Long> e) throws Exception {
                return occurrencesFilter.test(e.getValue());
            }
        };
        return this.groupBy(keyedMapper, Collectors.counting(), supplier).filter(predicate).map(KK);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K> ExceptionalStream<T, E> distinctBy(Throwables.Function<? super T, K, ? extends E> keyMapper, Throwables.BinaryOperator<T, ? extends E> mergeFunction) {
        this.assertNotClosed();
        Supplier supplier = Fn.Suppliers.ofLinkedHashMap();
        return this.groupBy(keyMapper, Fn.Fnn.identity(), mergeFunction, supplier).map(Fn.Fnn.value());
    }

    @IntermediateOp
    public <U> ExceptionalStream<U, E> map(final Throwables.Function<? super T, ? extends U, ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<U, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public U next() throws Exception {
                return mapper.apply(ExceptionalStream.this.elements.next());
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> mapFirst(final Throwables.Function<? super T, ? extends T, ? extends E> mapperForFirst) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean isFirst = true;

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.isFirst) {
                    this.isFirst = false;
                    return mapperForFirst.apply(ExceptionalStream.this.elements.next());
                }
                return ExceptionalStream.this.elements.next();
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> mapFirstOrElse(final Throwables.Function<? super T, ? extends R, E> mapperForFirst, final Throwables.Function<? super T, ? extends R, E> mapperForElse) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private boolean isFirst = true;

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (this.isFirst) {
                    this.isFirst = false;
                    return mapperForFirst.apply(ExceptionalStream.this.elements.next());
                }
                return mapperForElse.apply(ExceptionalStream.this.elements.next());
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> mapLast(final Throwables.Function<? super T, ? extends T, ? extends E> mapperForLast) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                this.next = ExceptionalStream.this.elements.next();
                if (ExceptionalStream.this.elements.hasNext()) {
                    return this.next;
                }
                return mapperForLast.apply(this.next);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> mapLastOrElse(final Throwables.Function<? super T, ? extends R, E> mapperForLast, final Throwables.Function<? super T, ? extends R, E> mapperForElse) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public R next() throws Exception {
                this.next = ExceptionalStream.this.elements.next();
                if (ExceptionalStream.this.elements.hasNext()) {
                    return mapperForElse.apply(this.next);
                }
                return mapperForLast.apply(this.next);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> flatMap(final Throwables.Function<? super T, ? extends ExceptionalStream<? extends R, ? extends E>, ? extends E> mapper) {
        this.assertNotClosed();
        final ExceptionalIterator iter = new ExceptionalIterator<R, E>(){
            private ExceptionalIterator<? extends R, ? extends E> cur = null;
            private ExceptionalStream<? extends R, ? extends E> s = null;
            private Deque<? extends Throwables.Runnable<? extends E>> closeHandle = null;

            @Override
            public boolean hasNext() throws Exception {
                while (this.cur == null || !this.cur.hasNext()) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        if (this.closeHandle != null) {
                            Deque tmp = this.closeHandle;
                            this.closeHandle = null;
                            ExceptionalStream.close(tmp);
                        }
                        this.s = (ExceptionalStream)mapper.apply(ExceptionalStream.this.elements.next());
                        if (N.notNullOrEmpty(this.s.closeHandlers)) {
                            this.closeHandle = this.s.closeHandlers;
                        }
                        this.cur = this.s.elements;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }

            @Override
            public void close() throws Exception {
                if (this.closeHandle != null) {
                    ExceptionalStream.close(this.closeHandle);
                }
            }
        };
        ArrayDeque<Throwables.Runnable<Throwables.Runnable<? extends E>>> newCloseHandlers = new ArrayDeque<Throwables.Runnable<Throwables.Runnable<? extends E>>>(N.size(this.closeHandlers) + 1);
        newCloseHandlers.add(new Throwables.Runnable<E>(){

            @Override
            public void run() throws Exception {
                iter.close();
            }
        });
        if (N.notNullOrEmpty(this.closeHandlers)) {
            newCloseHandlers.addAll(this.closeHandlers);
        }
        return ExceptionalStream.newStream(iter, newCloseHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> flattMap(final Throwables.Function<? super T, ? extends Collection<? extends R>, ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private Iterator<? extends R> cur = null;
            private Collection<? extends R> c = null;

            @Override
            public boolean hasNext() throws Exception {
                while ((this.cur == null || !this.cur.hasNext()) && ExceptionalStream.this.elements.hasNext()) {
                    this.c = (Collection)mapper.apply(ExceptionalStream.this.elements.next());
                    this.cur = N.isNullOrEmpty(this.c) ? null : this.c.iterator();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> flatMapp(final Throwables.Function<? super T, R[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private R[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (Object[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public R next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Boolean, E> flatMapToBoolean(final Throwables.Function<? super T, boolean[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Boolean, E>(){
            private boolean[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (boolean[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Boolean next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Character, E> flatMapToChar(final Throwables.Function<? super T, char[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Character, E>(){
            private char[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (char[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Character next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(this.cur[this.idx++]);
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Byte, E> flatMapToByte(final Throwables.Function<? super T, byte[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Byte, E>(){
            private byte[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (byte[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Byte next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Short, E> flatMapToShort(final Throwables.Function<? super T, short[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Short, E>(){
            private short[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (short[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Short next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Integer, E> flatMapToInteger(final Throwables.Function<? super T, int[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Integer, E>(){
            private int[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (int[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Integer next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Long, E> flatMapToLong(final Throwables.Function<? super T, long[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Long, E>(){
            private long[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (long[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Long next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Float, E> flatMapToFloat(final Throwables.Function<? super T, float[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Float, E>(){
            private float[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (float[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Float next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Float.valueOf(this.cur[this.idx++]);
            }
        }, this.closeHandlers);
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Double, E> flatMapToDouble(final Throwables.Function<? super T, double[], ? extends E> mapper) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Double, E>(){
            private double[] cur = null;
            private int len = 0;
            private int idx = 0;

            @Override
            public boolean hasNext() throws Exception {
                while (this.idx >= this.len) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.cur = (double[])mapper.apply(ExceptionalStream.this.elements.next());
                        this.len = N.len(this.cur);
                        this.idx = 0;
                        continue;
                    }
                    this.cur = null;
                    break;
                }
                return this.idx < this.len;
            }

            @Override
            public Double next() throws Exception {
                if (this.idx >= this.len && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur[this.idx++];
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> slidingMap(Throwables.BiFunction<? super T, ? super T, R, ? extends E> mapper) {
        return this.slidingMap(mapper, 1);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> slidingMap(Throwables.BiFunction<? super T, ? super T, R, ? extends E> mapper, int increment) {
        return this.slidingMap(mapper, increment, false);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> slidingMap(final Throwables.BiFunction<? super T, ? super T, R, ? extends E> mapper, final int increment, final boolean ignoreNotPaired) {
        this.assertNotClosed();
        this.checkArgPositive(increment, "increment");
        int windowSize = 2;
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private final T NONE = N.NULL_MASK;
            private T prev = this.NONE;
            private T _1 = this.NONE;

            @Override
            public boolean hasNext() throws Exception {
                if (increment > 2 && this.prev != this.NONE) {
                    int skipNum = increment - 2;
                    while (skipNum-- > 0 && ExceptionalStream.this.elements.hasNext()) {
                        ExceptionalStream.this.elements.next();
                    }
                    this.prev = this.NONE;
                }
                if (ignoreNotPaired && this._1 == this.NONE && ExceptionalStream.this.elements.hasNext()) {
                    this._1 = ExceptionalStream.this.elements.next();
                }
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (ignoreNotPaired) {
                    this.prev = ExceptionalStream.this.elements.next();
                    Object res = mapper.apply(this._1, this.prev);
                    this._1 = increment == 1 ? this.prev : this.NONE;
                    return res;
                }
                if (increment == 1) {
                    this.prev = ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null;
                    return mapper.apply(this.prev == this.NONE ? ExceptionalStream.this.elements.next() : this.prev, this.prev);
                }
                this.prev = ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null;
                return mapper.apply(ExceptionalStream.this.elements.next(), this.prev);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> slidingMap(Throwables.TriFunction<? super T, ? super T, ? super T, R, ? extends E> mapper) {
        return this.slidingMap(mapper, 1);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> slidingMap(Throwables.TriFunction<? super T, ? super T, ? super T, R, ? extends E> mapper, int increment) {
        return this.slidingMap(mapper, increment, false);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> slidingMap(final Throwables.TriFunction<? super T, ? super T, ? super T, R, ? extends E> mapper, final int increment, final boolean ignoreNotPaired) {
        this.assertNotClosed();
        this.checkArgPositive(increment, "increment");
        int windowSize = 3;
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private final T NONE = N.NULL_MASK;
            private T prev = this.NONE;
            private T prev2 = this.NONE;
            private T _1 = this.NONE;
            private T _2 = this.NONE;

            @Override
            public boolean hasNext() throws Exception {
                if (increment > 3 && this.prev != this.NONE) {
                    int skipNum = increment - 3;
                    while (skipNum-- > 0 && ExceptionalStream.this.elements.hasNext()) {
                        ExceptionalStream.this.elements.next();
                    }
                    this.prev = this.NONE;
                }
                if (ignoreNotPaired) {
                    if (this._1 == this.NONE && ExceptionalStream.this.elements.hasNext()) {
                        this._1 = ExceptionalStream.this.elements.next();
                    }
                    if (this._2 == this.NONE && ExceptionalStream.this.elements.hasNext()) {
                        this._2 = ExceptionalStream.this.elements.next();
                    }
                }
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (ignoreNotPaired) {
                    this.prev = ExceptionalStream.this.elements.next();
                    Object res = mapper.apply(this._1, this._2, this.prev);
                    this._1 = increment == 1 ? this._2 : (increment == 2 ? this.prev : this.NONE);
                    this._2 = increment == 1 ? this.prev : this.NONE;
                    return res;
                }
                if (increment == 1) {
                    this.prev2 = this.prev == this.NONE ? (ExceptionalStream.this.elements.hasNext() ? ExceptionalStream.this.elements.next() : null) : this.prev;
                    this.prev = ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null;
                    return mapper.apply(this.prev2 == this.NONE ? ExceptionalStream.this.elements.next() : this.prev2, this.prev2, this.prev);
                }
                if (increment == 2) {
                    this.prev = ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null;
                    return mapper.apply(this.prev == this.NONE ? ExceptionalStream.this.elements.next() : this.prev, ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null, this.prev);
                }
                this.prev = ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null;
                return mapper.apply(ExceptionalStream.this.elements.next(), ExceptionalStream.this.elements.hasNext() ? (Object)ExceptionalStream.this.elements.next() : null, this.prev);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K> ExceptionalStream<Map.Entry<K, List<T>>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.groupBy(keyMapper, Fn.Suppliers.ofMap());
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K> ExceptionalStream<Map.Entry<K, List<T>>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Supplier<? extends Map<K, List<T>>> mapFactory) {
        return this.groupBy(keyMapper, Fn.Fnn.identity(), mapFactory);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, V> ExceptionalStream<Map.Entry<K, List<V>>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper) {
        return this.groupBy(keyMapper, valueMapper, Fn.Suppliers.ofMap());
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, V> ExceptionalStream<Map.Entry<K, List<V>>, E> groupBy(final Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, final Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, final Supplier<? extends Map<K, List<V>>> mapFactory) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Map.Entry<K, List<V>>, E>(){
            private Iterator<Map.Entry<K, List<V>>> iter = null;

            @Override
            public boolean hasNext() throws Exception {
                this.init();
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<K, List<V>> next() throws Exception {
                this.init();
                return this.iter.next();
            }

            private void init() throws Exception {
                if (this.iter == null) {
                    this.iter = ExceptionalStream.this.groupTo(keyMapper, valueMapper, mapFactory).entrySet().iterator();
                }
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, V> ExceptionalStream<Map.Entry<K, V>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Throwables.BinaryOperator<V, ? extends E> mergeFunction) {
        return this.groupBy(keyMapper, valueMapper, mergeFunction, Fn.Suppliers.ofMap());
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, V> ExceptionalStream<Map.Entry<K, V>, E> groupBy(final Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, final Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, final Throwables.BinaryOperator<V, ? extends E> mergeFunction, final Supplier<? extends Map<K, V>> mapFactory) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Map.Entry<K, V>, E>(){
            private Iterator<Map.Entry<K, V>> iter = null;

            @Override
            public boolean hasNext() throws Exception {
                this.init();
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() throws Exception {
                this.init();
                return this.iter.next();
            }

            private void init() throws Exception {
                if (this.iter == null) {
                    this.iter = ExceptionalStream.this.toMap(keyMapper, valueMapper, mergeFunction, mapFactory).entrySet().iterator();
                }
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, A, D> ExceptionalStream<Map.Entry<K, D>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Collector<? super T, A, D> downstream) {
        return this.groupBy(keyMapper, downstream, Fn.Suppliers.ofMap());
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, A, D> ExceptionalStream<Map.Entry<K, D>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Collector<? super T, A, D> downstream, Supplier<? extends Map<K, D>> mapFactory) {
        return this.groupBy(keyMapper, Fn.Fnn.identity(), downstream, mapFactory);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, V, A, D> ExceptionalStream<Map.Entry<K, D>, E> groupBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Collector<? super V, A, D> downstream) {
        return this.groupBy(keyMapper, valueMapper, downstream, Fn.Suppliers.ofMap());
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K, V, A, D> ExceptionalStream<Map.Entry<K, D>, E> groupBy(final Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, final Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, final Collector<? super V, A, D> downstream, final Supplier<? extends Map<K, D>> mapFactory) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<Map.Entry<K, D>, E>(){
            private Iterator<Map.Entry<K, D>> iter = null;

            @Override
            public boolean hasNext() throws Exception {
                this.init();
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<K, D> next() throws Exception {
                this.init();
                return this.iter.next();
            }

            private void init() throws Exception {
                if (this.iter == null) {
                    this.iter = ExceptionalStream.this.toMap(keyMapper, valueMapper, downstream, mapFactory).entrySet().iterator();
                }
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public <K> ExceptionalStream<Map.Entry<K, Integer>, E> countBy(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.groupBy(keyMapper, Collectors.countingInt());
    }

    @IntermediateOp
    public <C extends Collection<T>> ExceptionalStream<C, E> collapse(final Throwables.BiPredicate<? super T, ? super T, ? extends E> collapsible, final Supplier<? extends C> supplier) {
        this.assertNotClosed();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<C, E>(){
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return this.hasNext || iter.hasNext();
            }

            @Override
            public C next() throws Exception {
                if (!this.hasNext) {
                    this.next = iter.next();
                }
                Collection c = (Collection)supplier.get();
                c.add(this.next);
                while ((this.hasNext = iter.hasNext()) && collapsible.test(this.next = iter.next(), this.next)) {
                    c.add(this.next);
                }
                return c;
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> collapse(final Throwables.BiPredicate<? super T, ? super T, ? extends E> collapsible, final Throwables.BiFunction<? super T, ? super T, T, ? extends E> mergeFunction) {
        this.assertNotClosed();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return this.hasNext || iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                Object res;
                Object t = res = this.hasNext ? this.next : (this.next = iter.next());
                while ((this.hasNext = iter.hasNext()) && collapsible.test(this.next = iter.next(), this.next)) {
                    res = mergeFunction.apply(res, this.next);
                }
                return res;
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <U> ExceptionalStream<U, E> collapse(final Throwables.BiPredicate<? super T, ? super T, ? extends E> collapsible, final U init, final Throwables.BiFunction<U, ? super T, U, ? extends E> op) {
        this.assertNotClosed();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<U, E>(){
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return this.hasNext || iter.hasNext();
            }

            @Override
            public U next() throws Exception {
                Object res = op.apply(init, this.hasNext ? this.next : (this.next = iter.next()));
                while ((this.hasNext = iter.hasNext()) && collapsible.test(this.next = iter.next(), this.next)) {
                    res = op.apply(res, this.next);
                }
                return res;
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R> ExceptionalStream<R, E> collapse(final Throwables.BiPredicate<? super T, ? super T, ? extends E> collapsible, final Throwables.Supplier<R, E> supplier, final Throwables.BiConsumer<? super R, ? super T, ? extends E> accumulator) {
        this.assertNotClosed();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return this.hasNext || iter.hasNext();
            }

            @Override
            public R next() throws Exception {
                Object container = supplier.get();
                accumulator.accept(container, this.hasNext ? this.next : (this.next = iter.next()));
                while ((this.hasNext = iter.hasNext()) && collapsible.test(this.next = iter.next(), this.next)) {
                    accumulator.accept(container, this.next);
                }
                return container;
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R, A> ExceptionalStream<R, E> collapse(final Throwables.BiPredicate<? super T, ? super T, ? extends E> collapsible, Collector<? super T, A, R> collector) {
        this.assertNotClosed();
        final Supplier<A> supplier = collector.supplier();
        final BiConsumer<A, ? super T> accumulator = collector.accumulator();
        final Function<A, R> finisher = collector.finisher();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private boolean hasNext = false;
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return this.hasNext || iter.hasNext();
            }

            @Override
            public R next() throws Exception {
                Object container = supplier.get();
                accumulator.accept(container, this.hasNext ? this.next : (this.next = iter.next()));
                while ((this.hasNext = iter.hasNext()) && collapsible.test(this.next = iter.next(), this.next)) {
                    accumulator.accept(container, this.next);
                }
                return finisher.apply(container);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> scan(final Throwables.BiFunction<? super T, ? super T, T, ? extends E> accumulator) {
        this.assertNotClosed();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private T res = null;
            private boolean isFirst = true;

            @Override
            public boolean hasNext() throws Exception {
                return iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.isFirst) {
                    this.isFirst = false;
                    this.res = iter.next();
                    return this.res;
                }
                this.res = accumulator.apply(this.res, iter.next());
                return this.res;
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <U> ExceptionalStream<U, E> scan(final U init, final Throwables.BiFunction<U, ? super T, U, ? extends E> accumulator) {
        this.assertNotClosed();
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<U, E>(){
            private U res;
            {
                this.res = init;
            }

            @Override
            public boolean hasNext() throws Exception {
                return iter.hasNext();
            }

            @Override
            public U next() throws Exception {
                this.res = accumulator.apply(this.res, iter.next());
                return this.res;
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <U> ExceptionalStream<U, E> scan(final U init, final Throwables.BiFunction<U, ? super T, U, ? extends E> accumulator, boolean initIncluded) {
        this.assertNotClosed();
        if (!initIncluded) {
            return this.scan(init, accumulator);
        }
        final ExceptionalIterator<T, E> iter = this.elements;
        return ExceptionalStream.newStream(new ExceptionalIterator<U, E>(){
            private boolean isFirst = true;
            private U res = init;

            @Override
            public boolean hasNext() throws Exception {
                return this.isFirst || iter.hasNext();
            }

            @Override
            public U next() throws Exception {
                if (this.isFirst) {
                    this.isFirst = false;
                    return init;
                }
                this.res = accumulator.apply(this.res, iter.next());
                return this.res;
            }
        }, this.closeHandlers);
    }

    public ExceptionalStream<T, E> intersection(Collection<?> c) {
        this.assertNotClosed();
        final Multiset<?> multiset = Multiset.from(c);
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return multiset.getAndRemove(value) > 0;
            }
        });
    }

    public ExceptionalStream<T, E> intersection(final Throwables.Function<? super T, ?, E> mapper, Collection<?> c) {
        this.assertNotClosed();
        final Multiset<?> multiset = Multiset.from(c);
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) throws Exception {
                return multiset.getAndRemove(mapper.apply(value)) > 0;
            }
        });
    }

    public ExceptionalStream<T, E> difference(Collection<?> c) {
        this.assertNotClosed();
        final Multiset<?> multiset = Multiset.from(c);
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return multiset.getAndRemove(value) < 1;
            }
        });
    }

    public ExceptionalStream<T, E> difference(final Function<? super T, ?> mapper, Collection<?> c) {
        this.assertNotClosed();
        final Multiset<?> multiset = Multiset.from(c);
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) throws Exception {
                return multiset.getAndRemove(mapper.apply(value)) < 1;
            }
        });
    }

    public ExceptionalStream<T, E> symmetricDifference(Collection<T> c) {
        this.assertNotClosed();
        final Multiset<T> multiset = Multiset.from(c);
        return this.filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return multiset.getAndRemove(value) < 1;
            }
        }).append(ExceptionalStream.of(c).filter(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return multiset.getAndRemove(value) > 0;
            }
        }));
    }

    @IntermediateOp
    public final ExceptionalStream<T, E> defaultIfEmpty(T defaultValue) {
        return this.appendIfEmpty(defaultValue);
    }

    @IntermediateOp
    public final ExceptionalStream<T, E> defaultIfEmpty(Supplier<? extends ExceptionalStream<T, E>> supplier) {
        return this.appendIfEmpty(supplier);
    }

    @SafeVarargs
    @IntermediateOp
    public final ExceptionalStream<T, E> prepend(T ... a) {
        return this.prepend(ExceptionalStream.of(a));
    }

    @IntermediateOp
    public ExceptionalStream<T, E> prepend(Collection<? extends T> c) {
        return this.prepend(ExceptionalStream.of(c));
    }

    @IntermediateOp
    public ExceptionalStream<T, E> prepend(ExceptionalStream<T, E> s) {
        this.assertNotClosed();
        return ExceptionalStream.concat(s, this);
    }

    @SafeVarargs
    @IntermediateOp
    public final ExceptionalStream<T, E> append(T ... a) {
        return this.append(ExceptionalStream.of(a));
    }

    @IntermediateOp
    public ExceptionalStream<T, E> append(Collection<? extends T> c) {
        return this.append(ExceptionalStream.of(c));
    }

    @IntermediateOp
    public ExceptionalStream<T, E> append(ExceptionalStream<T, E> s) {
        this.assertNotClosed();
        return ExceptionalStream.concat(this, s);
    }

    @SafeVarargs
    @IntermediateOp
    public final ExceptionalStream<T, E> appendIfEmpty(T ... a) {
        return this.appendIfEmpty((Collection<? extends T>)Arrays.asList(a));
    }

    @IntermediateOp
    public ExceptionalStream<T, E> appendIfEmpty(final Collection<? extends T> c) {
        this.assertNotClosed();
        if (N.isNullOrEmpty(c)) {
            return ExceptionalStream.newStream(this.elements, this.closeHandlers);
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private ExceptionalIterator<T, E> iter;

            @Override
            public boolean hasNext() throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                return this.iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                return this.iter.next();
            }

            @Override
            public void advance(long n) throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                this.iter.advance(n);
            }

            @Override
            public long count() throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                return this.iter.count();
            }

            private void init() throws Exception {
                if (this.iter == null) {
                    this.iter = ExceptionalStream.this.elements.hasNext() ? ExceptionalStream.this.elements : ExceptionalIterator.wrap(c.iterator());
                }
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> appendIfEmpty(final Supplier<? extends ExceptionalStream<T, E>> supplier) {
        this.assertNotClosed();
        final u.Holder holder = new u.Holder();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private ExceptionalIterator<T, E> iter;

            @Override
            public boolean hasNext() throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                return this.iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                return this.iter.next();
            }

            @Override
            public void advance(long n) throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                this.iter.advance(n);
            }

            @Override
            public long count() throws Exception {
                if (this.iter == null) {
                    this.init();
                }
                return this.iter.count();
            }

            private void init() throws Exception {
                if (this.iter == null) {
                    if (ExceptionalStream.this.elements.hasNext()) {
                        this.iter = ExceptionalStream.this.elements;
                    } else {
                        ExceptionalStream s = (ExceptionalStream)supplier.get();
                        holder.setValue(s);
                        this.iter = s.iterator();
                    }
                }
            }
        }, this.closeHandlers).onClose(new Throwables.Runnable<E>(){

            @Override
            public void run() throws Exception {
                ExceptionalStream.this.close(holder);
            }
        });
    }

    void close(u.Holder<? extends ExceptionalStream<T, E>> holder) {
        if (holder.value() != null) {
            ((ExceptionalStream)holder.value()).close();
        }
    }

    @TerminalOp
    public <R> u.Optional<R> applyIfNotEmpty(Throwables.Function<? super ExceptionalStream<T, E>, R, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (this.elements.hasNext()) {
                u.Optional<R> optional = u.Optional.of(func.apply(this));
                return optional;
            }
            u.Optional optional = u.Optional.empty();
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public If.OrElse acceptIfNotEmpty(Throwables.Consumer<? super ExceptionalStream<T, E>, ? extends E> action) throws E {
        this.assertNotClosed();
        try {
            if (this.elements.hasNext()) {
                action.accept(this);
                If.OrElse orElse = If.OrElse.TRUE;
                return orElse;
            }
        }
        finally {
            this.close();
        }
        return If.OrElse.FALSE;
    }

    @IntermediateOp
    public ExceptionalStream<T, E> onEach(Throwables.Consumer<? super T, ? extends E> action) {
        return this.peek(action);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> peek(final Throwables.Consumer<? super T, ? extends E> action) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                Object next = ExceptionalStream.this.elements.next();
                action.accept(next);
                return next;
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> peekFirst(final Throwables.Consumer<? super T, ? extends E> action) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean isFirst = true;

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.isFirst) {
                    this.isFirst = false;
                    Object e = ExceptionalStream.this.elements.next();
                    action.accept(e);
                    return e;
                }
                return ExceptionalStream.this.elements.next();
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> peekLast(final Throwables.Consumer<? super T, ? extends E> action) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private T next = null;

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                this.next = ExceptionalStream.this.elements.next();
                if (ExceptionalStream.this.elements.hasNext()) {
                    return this.next;
                }
                Object e = ExceptionalStream.this.elements.next();
                action.accept(e);
                return e;
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<List<T>, E> splitToList(int chunkSize) {
        return this.split(chunkSize, Fn.Factory.ofList());
    }

    @IntermediateOp
    public ExceptionalStream<Set<T>, E> splitToSet(int chunkSize) {
        return this.split(chunkSize, Fn.Factory.ofSet());
    }

    @IntermediateOp
    public <C extends Collection<T>> ExceptionalStream<C, E> split(final int chunkSize, final IntFunction<? extends C> collectionSupplier) {
        this.assertNotClosed();
        this.checkArgPositive(chunkSize, "chunkSize");
        return ExceptionalStream.newStream(new ExceptionalIterator<C, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public C next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Collection result = (Collection)collectionSupplier.apply(chunkSize);
                int cnt = 0;
                while (cnt++ < chunkSize && ExceptionalStream.this.elements.hasNext()) {
                    result.add(ExceptionalStream.this.elements.next());
                }
                return result;
            }

            @Override
            public long count() throws Exception {
                long len = ExceptionalStream.this.elements.count();
                return len % (long)chunkSize == 0L ? len / (long)chunkSize : len / (long)chunkSize + 1L;
            }

            @Override
            public void advance(long n) throws Exception {
                ExceptionalStream.this.checkArgNotNegative(n, "n");
                ExceptionalStream.this.elements.advance(n > Long.MAX_VALUE / (long)chunkSize ? Long.MAX_VALUE : n * (long)chunkSize);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <R, A> ExceptionalStream<R, E> split(final int chunkSize, Collector<? super T, A, R> collector) {
        this.assertNotClosed();
        this.checkArgPositive(chunkSize, "chunkSize");
        final Supplier<A> supplier = collector.supplier();
        final BiConsumer<A, ? super T> accumulator = collector.accumulator();
        final Function<A, R> finisher = collector.finisher();
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){

            @Override
            public boolean hasNext() throws Exception {
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object container = supplier.get();
                int cnt = 0;
                while (cnt++ < chunkSize && ExceptionalStream.this.elements.hasNext()) {
                    accumulator.accept(container, ExceptionalStream.this.elements.next());
                }
                return finisher.apply(container);
            }

            @Override
            public long count() throws Exception {
                long len = ExceptionalStream.this.elements.count();
                return len % (long)chunkSize == 0L ? len / (long)chunkSize : len / (long)chunkSize + 1L;
            }

            @Override
            public void advance(long n) throws Exception {
                ExceptionalStream.this.checkArgNotNegative(n, "n");
                ExceptionalStream.this.elements.advance(n > Long.MAX_VALUE / (long)chunkSize ? Long.MAX_VALUE : n * (long)chunkSize);
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<List<T>, E> slidingToList(int windowSize, int increment) {
        return this.sliding(windowSize, increment, Fn.Factory.ofList());
    }

    @IntermediateOp
    public ExceptionalStream<Set<T>, E> slidingToSet(int windowSize, int increment) {
        return this.sliding(windowSize, increment, Fn.Factory.ofSet());
    }

    @IntermediateOp
    public <C extends Collection<T>> ExceptionalStream<C, E> sliding(final int windowSize, final int increment, final IntFunction<? extends C> collectionSupplier) {
        this.assertNotClosed();
        this.checkArgument(windowSize > 0 && increment > 0, "windowSize=%s and increment=%s must be bigger than 0", windowSize, increment);
        return ExceptionalStream.newStream(new ExceptionalIterator<C, E>(){
            private Deque<T> queue = null;
            private boolean toSkip = false;

            @Override
            public boolean hasNext() throws Exception {
                if (this.toSkip) {
                    int skipNum = increment - windowSize;
                    while (skipNum-- > 0 && ExceptionalStream.this.elements.hasNext()) {
                        ExceptionalStream.this.elements.next();
                    }
                    this.toSkip = false;
                }
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public C next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.queue == null) {
                    this.queue = new ArrayDeque(N.max(0, windowSize - increment));
                }
                Collection result = (Collection)collectionSupplier.apply(windowSize);
                int cnt = 0;
                if (this.queue.size() > 0 && increment < windowSize) {
                    cnt = this.queue.size();
                    for (Object e : this.queue) {
                        result.add(e);
                    }
                    if (this.queue.size() <= increment) {
                        this.queue.clear();
                    } else {
                        for (int i = 0; i < increment; ++i) {
                            this.queue.removeFirst();
                        }
                    }
                }
                Object next = null;
                while (cnt++ < windowSize && ExceptionalStream.this.elements.hasNext()) {
                    next = ExceptionalStream.this.elements.next();
                    result.add(next);
                    if (cnt <= increment) continue;
                    this.queue.add(next);
                }
                this.toSkip = increment > windowSize;
                return result;
            }

            @Override
            public long count() throws Exception {
                int prevSize = increment >= windowSize ? 0 : (this.queue == null ? 0 : this.queue.size());
                long len = (long)prevSize + ExceptionalStream.this.elements.count();
                if (len == (long)prevSize) {
                    return 0L;
                }
                if (len <= (long)windowSize) {
                    return 1L;
                }
                long rlen = len - (long)windowSize;
                return 1L + (rlen % (long)increment == 0L ? rlen / (long)increment : rlen / (long)increment + 1L);
            }

            @Override
            public void advance(long n) throws Exception {
                ExceptionalStream.this.checkArgNotNegative(n, "n");
                if (n == 0L) {
                    return;
                }
                if (increment >= windowSize) {
                    ExceptionalStream.this.elements.advance(n > Long.MAX_VALUE / (long)increment ? Long.MAX_VALUE : n * (long)increment);
                } else {
                    long m;
                    if (N.isNullOrEmpty(this.queue)) {
                        m = n - 1L > Long.MAX_VALUE / (long)increment ? Long.MAX_VALUE : (n - 1L) * (long)increment;
                        ExceptionalStream.this.elements.advance(m);
                    } else {
                        int prevSize;
                        long l = m = n > Long.MAX_VALUE / (long)increment ? Long.MAX_VALUE : n * (long)increment;
                        int n2 = increment >= windowSize ? 0 : (prevSize = this.queue == null ? 0 : this.queue.size());
                        if (m < (long)prevSize) {
                            int i = 0;
                            while ((long)i < m) {
                                this.queue.removeFirst();
                                ++i;
                            }
                        } else {
                            if (this.queue != null) {
                                this.queue.clear();
                            }
                            ExceptionalStream.this.elements.advance(m - (long)prevSize);
                        }
                    }
                    if (this.queue == null) {
                        this.queue = new ArrayDeque(windowSize);
                    }
                    int cnt = this.queue.size();
                    while (cnt++ < windowSize && ExceptionalStream.this.elements.hasNext()) {
                        this.queue.add(ExceptionalStream.this.elements.next());
                    }
                }
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public <A, R> ExceptionalStream<R, E> sliding(final int windowSize, final int increment, Collector<? super T, A, R> collector) {
        this.assertNotClosed();
        this.checkArgument(windowSize > 0 && increment > 0, "windowSize=%s and increment=%s must be bigger than 0", windowSize, increment);
        final Supplier<A> supplier = collector.supplier();
        final BiConsumer<A, ? super T> accumulator = collector.accumulator();
        final Function<A, R> finisher = collector.finisher();
        return ExceptionalStream.newStream(new ExceptionalIterator<R, E>(){
            private Deque<T> queue = null;
            private boolean toSkip = false;

            @Override
            public boolean hasNext() throws Exception {
                if (this.toSkip) {
                    int skipNum = increment - windowSize;
                    while (skipNum-- > 0 && ExceptionalStream.this.elements.hasNext()) {
                        ExceptionalStream.this.elements.next();
                    }
                    this.toSkip = false;
                }
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public R next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (increment < windowSize && this.queue == null) {
                    this.queue = new ArrayDeque(windowSize - increment);
                }
                Object container = supplier.get();
                int cnt = 0;
                if (increment < windowSize && this.queue.size() > 0) {
                    cnt = this.queue.size();
                    for (Object e : this.queue) {
                        accumulator.accept(container, e);
                    }
                    if (this.queue.size() <= increment) {
                        this.queue.clear();
                    } else {
                        for (int i = 0; i < increment; ++i) {
                            this.queue.removeFirst();
                        }
                    }
                }
                Object next = null;
                while (cnt++ < windowSize && ExceptionalStream.this.elements.hasNext()) {
                    next = ExceptionalStream.this.elements.next();
                    accumulator.accept(container, next);
                    if (cnt <= increment) continue;
                    this.queue.add(next);
                }
                this.toSkip = increment > windowSize;
                return finisher.apply(container);
            }

            @Override
            public long count() throws Exception {
                int prevSize = increment >= windowSize ? 0 : (this.queue == null ? 0 : this.queue.size());
                long len = (long)prevSize + ExceptionalStream.this.elements.count();
                if (len == (long)prevSize) {
                    return 0L;
                }
                if (len <= (long)windowSize) {
                    return 1L;
                }
                long rlen = len - (long)windowSize;
                return 1L + (rlen % (long)increment == 0L ? rlen / (long)increment : rlen / (long)increment + 1L);
            }

            @Override
            public void advance(long n) throws Exception {
                ExceptionalStream.this.checkArgNotNegative(n, "n");
                if (n == 0L) {
                    return;
                }
                if (increment >= windowSize) {
                    ExceptionalStream.this.elements.advance(n > Long.MAX_VALUE / (long)increment ? Long.MAX_VALUE : n * (long)increment);
                } else {
                    long m;
                    if (N.isNullOrEmpty(this.queue)) {
                        m = n - 1L > Long.MAX_VALUE / (long)increment ? Long.MAX_VALUE : (n - 1L) * (long)increment;
                        ExceptionalStream.this.elements.advance(m);
                    } else {
                        int prevSize;
                        long l = m = n > Long.MAX_VALUE / (long)increment ? Long.MAX_VALUE : n * (long)increment;
                        int n2 = increment >= windowSize ? 0 : (prevSize = this.queue == null ? 0 : this.queue.size());
                        if (m < (long)prevSize) {
                            int i = 0;
                            while ((long)i < m) {
                                this.queue.removeFirst();
                                ++i;
                            }
                        } else {
                            if (this.queue != null) {
                                this.queue.clear();
                            }
                            ExceptionalStream.this.elements.advance(m - (long)prevSize);
                        }
                    }
                    if (this.queue == null) {
                        this.queue = new ArrayDeque(windowSize);
                    }
                    int cnt = this.queue.size();
                    while (cnt++ < windowSize && ExceptionalStream.this.elements.hasNext()) {
                        this.queue.add(ExceptionalStream.this.elements.next());
                    }
                }
            }
        }, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> skip(final long n) {
        this.assertNotClosed();
        this.checkArgNotNegative(n, "n");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean skipped = false;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.skipped) {
                    this.skipped = true;
                    this.advance(n);
                }
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.skipped) {
                    this.skipped = true;
                    this.advance(n);
                }
                return ExceptionalStream.this.elements.next();
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> skipNull() {
        return this.filter(Fn.Fnn.notNull());
    }

    @IntermediateOp
    public ExceptionalStream<T, E> limit(final long maxSize) {
        this.assertNotClosed();
        this.checkArgNotNegative(maxSize, "maxSize");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private long cnt = 0L;

            @Override
            public boolean hasNext() throws Exception {
                return this.cnt < maxSize && ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (this.cnt >= maxSize) {
                    throw new NoSuchElementException();
                }
                ++this.cnt;
                return ExceptionalStream.this.elements.next();
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> top(int n) {
        this.assertNotClosed();
        return this.top(n, Comparators.NATURAL_ORDER);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> top(final int n, final Comparator<? super T> comparator) {
        this.assertNotClosed();
        this.checkArgPositive(n, "n");
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean initialized = false;
            private T[] aar = null;
            private int cursor = 0;
            private int to;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.cursor < this.to;
            }

            @Override
            public T next() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                if (this.cursor >= this.to) {
                    throw new NoSuchElementException();
                }
                return this.aar[this.cursor++];
            }

            @Override
            public long count() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.to - this.cursor;
            }

            @Override
            public void advance(long n2) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.cursor = n2 < (long)(this.to - this.cursor) ? this.cursor + (int)n2 : this.to;
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    if (ExceptionalStream.this.sorted && ExceptionalStream.isSameComparator(comparator, ExceptionalStream.this.cmp)) {
                        LinkedList queue = new LinkedList();
                        while (ExceptionalStream.this.elements.hasNext()) {
                            if (queue.size() >= n) {
                                queue.poll();
                            }
                            queue.offer(ExceptionalStream.this.elements.next());
                        }
                        this.aar = queue.toArray();
                    } else {
                        PriorityQueue heap = new PriorityQueue(n, comparator);
                        Object next = null;
                        while (ExceptionalStream.this.elements.hasNext()) {
                            next = ExceptionalStream.this.elements.next();
                            if (heap.size() >= n) {
                                if (comparator.compare(next, heap.peek()) <= 0) continue;
                                heap.poll();
                                heap.offer(next);
                                continue;
                            }
                            heap.offer(next);
                        }
                        this.aar = heap.toArray();
                    }
                    this.to = this.aar.length;
                }
            }
        }, false, null, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> last(final int n) {
        this.assertNotClosed();
        this.checkArgNotNegative(n, "n");
        if (n == 0) {
            return this.limit(0L);
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private Iterator<T> iter;
            private boolean initialized = false;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.iter.next();
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    ArrayDeque deque = new ArrayDeque(Math.min(1024, n));
                    try {
                        while (ExceptionalStream.this.elements.hasNext()) {
                            if (deque.size() >= n) {
                                deque.pollFirst();
                            }
                            deque.offerLast(ExceptionalStream.this.elements.next());
                        }
                    }
                    finally {
                        ExceptionalStream.this.close();
                    }
                    this.iter = deque.iterator();
                }
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> skipLast(final int n) {
        this.assertNotClosed();
        if (n <= 0) {
            return ExceptionalStream.newStream(this.elements, this.sorted, this.cmp, this.closeHandlers);
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private Deque<T> deque = null;

            @Override
            public boolean hasNext() throws Exception {
                if (this.deque == null) {
                    this.deque = new ArrayDeque(Math.min(1024, n));
                    while (this.deque.size() < n && ExceptionalStream.this.elements.hasNext()) {
                        this.deque.offerLast(ExceptionalStream.this.elements.next());
                    }
                }
                return ExceptionalStream.this.elements.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.deque.offerLast(ExceptionalStream.this.elements.next());
                return this.deque.pollFirst();
            }
        }, this.sorted, this.cmp, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> reversed() {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean initialized = false;
            private T[] aar;
            private int cursor;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.cursor > 0;
            }

            @Override
            public T next() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                if (this.cursor <= 0) {
                    throw new NoSuchElementException();
                }
                return this.aar[--this.cursor];
            }

            @Override
            public long count() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.cursor;
            }

            @Override
            public void advance(long n) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.cursor = n < (long)this.cursor ? this.cursor - (int)n : 0;
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.aar = ExceptionalStream.this.toArrayForIntermediateOp();
                    this.cursor = this.aar.length;
                }
            }
        }, false, null, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> rotated(final int distance) {
        this.assertNotClosed();
        if (distance == 0) {
            return ExceptionalStream.newStream(this.elements, this.closeHandlers);
        }
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean initialized = false;
            private T[] aar;
            private int len;
            private int start;
            private int cnt = 0;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.cnt < this.len;
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.aar[(this.start + this.cnt++) % this.len];
            }

            @Override
            public long count() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.len - this.cnt;
            }

            @Override
            public void advance(long n) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.cnt = n < (long)(this.len - this.cnt) ? this.cnt + (int)n : this.len;
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.aar = ExceptionalStream.this.toArrayForIntermediateOp();
                    this.len = this.aar.length;
                    if (this.len > 0) {
                        this.start = distance % this.len;
                        if (this.start < 0) {
                            this.start += this.len;
                        }
                        this.start = this.len - this.start;
                    }
                }
            }
        }, false, null, this.closeHandlers);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> shuffled() {
        return this.shuffled(RAND);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> shuffled(final Random rnd) {
        this.assertNotClosed();
        return this.lazyLoad(new Function<Object[], Object[]>(){

            @Override
            public Object[] apply(Object[] a) {
                N.shuffle(a, rnd);
                return a;
            }
        }, false, null);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> sorted() {
        return this.sorted(Comparators.NATURAL_ORDER);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> reverseSorted() {
        return this.sorted(Comparators.REVERSED_ORDER);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> sorted(Comparator<? super T> comparator) {
        Comparator<? super T> cmp;
        this.assertNotClosed();
        Comparator<? super T> comparator2 = cmp = comparator == null ? Comparators.NATURAL_ORDER : comparator;
        if (this.sorted && cmp == this.cmp) {
            return ExceptionalStream.newStream(this.elements, this.sorted, comparator, this.closeHandlers);
        }
        return this.lazyLoad(new Function<Object[], Object[]>(){

            @Override
            public Object[] apply(Object[] a) {
                N.sort(a, cmp);
                return a;
            }
        }, true, cmp);
    }

    @IntermediateOp
    @TerminalOpTriggered
    public ExceptionalStream<T, E> sortedBy(final Function<? super T, ? extends Comparable> keyMapper) {
        this.assertNotClosed();
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return N.compare((Comparable)keyMapper.apply(o1), (Comparable)keyMapper.apply(o2));
            }
        };
        return this.sorted(comparator);
    }

    private ExceptionalStream<T, E> lazyLoad(final Function<Object[], Object[]> op, boolean sorted, Comparator<? super T> cmp) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private boolean initialized = false;
            private T[] aar;
            private int cursor = 0;
            private int len;

            @Override
            public boolean hasNext() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.cursor < this.len;
            }

            @Override
            public T next() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                if (this.cursor >= this.len) {
                    throw new NoSuchElementException();
                }
                return this.aar[this.cursor++];
            }

            @Override
            public long count() throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                return this.len - this.cursor;
            }

            @Override
            public void advance(long n) throws Exception {
                ExceptionalStream.this.checkArgNotNegative(n, "n");
                if (!this.initialized) {
                    this.init();
                }
                this.cursor = n > (long)(this.len - this.cursor) ? this.len : this.cursor + (int)n;
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.aar = (Object[])op.apply(ExceptionalStream.this.toArrayForIntermediateOp());
                    this.len = this.aar.length;
                }
            }
        }, sorted, cmp, this.closeHandlers);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> intersperse(final T delimiter) {
        this.assertNotClosed();
        return ExceptionalStream.newStream(new ExceptionalIterator<T, E>(){
            private final ExceptionalIterator<T, E> iter;
            private boolean toInsert;
            {
                this.iter = ExceptionalStream.this.iterator();
                this.toInsert = false;
            }

            @Override
            public boolean hasNext() throws Exception {
                return this.iter.hasNext();
            }

            @Override
            public T next() throws Exception {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.toInsert) {
                    this.toInsert = false;
                    return delimiter;
                }
                Object res = this.iter.next();
                this.toInsert = true;
                return res;
            }
        });
    }

    @Beta
    @IntermediateOp
    public ExceptionalStream<Indexed<T>, E> indexed() {
        this.assertNotClosed();
        return this.map(new Throwables.Function<T, Indexed<T>, E>(){
            private final MutableLong idx = new MutableLong(0L);

            @Override
            public Indexed<T> apply(T t) {
                return Indexed.of(t, this.idx.getAndIncrement());
            }
        });
    }

    @IntermediateOp
    public ExceptionalStream<T, E> mergeWith(Collection<? extends T> b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        this.assertNotClosed();
        return this.mergeWith(ExceptionalStream.of(b), nextSelector);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> mergeWith(ExceptionalStream<? extends T, E> b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) {
        this.assertNotClosed();
        return ExceptionalStream.merge(this, b, nextSelector);
    }

    @IntermediateOp
    public <T2, R> ExceptionalStream<R, E> zipWith(Collection<T2> b, Throwables.BiFunction<? super T, ? super T2, R, ? extends E> zipFunction) {
        this.assertNotClosed();
        return ExceptionalStream.zip(this, ExceptionalStream.of(b), zipFunction);
    }

    @IntermediateOp
    public <T2, R> ExceptionalStream<R, E> zipWith(Collection<T2> b, T valueForNoneA, T2 valueForNoneB, Throwables.BiFunction<? super T, ? super T2, R, ? extends E> zipFunction) {
        this.assertNotClosed();
        return ExceptionalStream.zip(this, ExceptionalStream.of(b), valueForNoneA, valueForNoneB, zipFunction);
    }

    @IntermediateOp
    public <T2, R> ExceptionalStream<R, E> zipWith(ExceptionalStream<T2, E> b, Throwables.BiFunction<? super T, ? super T2, R, ? extends E> zipFunction) {
        this.assertNotClosed();
        return ExceptionalStream.zip(this, b, zipFunction);
    }

    @IntermediateOp
    public <T2, R> ExceptionalStream<R, E> zipWith(ExceptionalStream<T2, E> b, T valueForNoneA, T2 valueForNoneB, Throwables.BiFunction<? super T, ? super T2, R, ? extends E> zipFunction) {
        this.assertNotClosed();
        return ExceptionalStream.zip(this, b, valueForNoneA, valueForNoneB, zipFunction);
    }

    @IntermediateOp
    public <T2, T3, R> ExceptionalStream<R, E> zipWith(ExceptionalStream<T2, E> b, ExceptionalStream<T3, E> c, Throwables.TriFunction<? super T, ? super T2, ? super T3, R, ? extends E> zipFunction) {
        this.assertNotClosed();
        return ExceptionalStream.zip(this, b, c, zipFunction);
    }

    @IntermediateOp
    public <T2, T3, R> ExceptionalStream<R, E> zipWith(ExceptionalStream<T2, E> b, ExceptionalStream<T3, E> c, T valueForNoneA, T2 valueForNoneB, T3 valueForNoneC, Throwables.TriFunction<? super T, ? super T2, ? super T3, R, ? extends E> zipFunction) {
        this.assertNotClosed();
        return ExceptionalStream.zip(this, b, c, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
    }

    @IntermediateOp
    public <U> ExceptionalStream<Pair<T, U>, E> crossJoin(Collection<? extends U> b) {
        return this.crossJoin(b, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, R> ExceptionalStream<R, E> crossJoin(final Collection<? extends U> b, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                return ExceptionalStream.of(b).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        return func.apply(t, u2);
                    }
                });
            }
        });
    }

    @IntermediateOp
    public <U, R> ExceptionalStream<R, E> crossJoin(final ExceptionalStream<? extends U, E> b, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private Collection<? extends U> c = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                if (this.c == null) {
                    this.c = b.toList();
                }
                return ExceptionalStream.of(this.c).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        return func.apply(t, u2);
                    }
                });
            }
        });
    }

    @IntermediateOp
    public <U, K> ExceptionalStream<Pair<T, U>, E> innerJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper) {
        return this.innerJoin(b, leftKeyMapper, rightKeyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> innerJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                if (this.rightKeyMap == null) {
                    this.rightKeyMap = ListMultimap.from(b, rightKeyMapper);
                }
                return ExceptionalStream.of(this.rightKeyMap.get(leftKeyMapper.apply(t))).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        return func.apply(t, u2);
                    }
                });
            }
        });
    }

    public <K> ExceptionalStream<Pair<T, T>, E> innerJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.innerJoin(b, keyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <K, R> ExceptionalStream<R, E> innerJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.BiFunction<? super T, ? super T, R, ? extends E> func) {
        return this.innerJoin(b, keyMapper, keyMapper, func);
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> innerJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                if (this.rightKeyMap == null) {
                    this.rightKeyMap = b.toMultimap(rightKeyMapper);
                }
                return ExceptionalStream.of(this.rightKeyMap.get(leftKeyMapper.apply(t))).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        return func.apply(t, u2);
                    }
                });
            }
        });
    }

    @IntermediateOp
    public <U> ExceptionalStream<Pair<T, U>, E> innerJoin(final Collection<? extends U> b, final Throwables.BiPredicate<? super T, ? super U, ? extends E> predicate) {
        this.assertNotClosed();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<Pair<T, U>, E>, E>(){

            @Override
            public ExceptionalStream<Pair<T, U>, E> apply(final T t) {
                return ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

                    @Override
                    public boolean test(U u2) throws Exception {
                        return predicate.test(t, u2);
                    }
                }).map(new Throwables.Function<U, Pair<T, U>, E>(){

                    @Override
                    public Pair<T, U> apply(U u2) {
                        return Pair.of(t, u2);
                    }
                });
            }
        });
    }

    @IntermediateOp
    public <U, K> ExceptionalStream<Pair<T, U>, E> fullJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper) {
        return this.fullJoin(b, leftKeyMapper, rightKeyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> fullJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        final IdentityHashMap joinedRights = new IdentityHashMap();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                List values;
                if (this.rightKeyMap == null) {
                    this.rightKeyMap = ListMultimap.from(b, rightKeyMapper);
                }
                return N.isNullOrEmpty(values = (List)this.rightKeyMap.get(leftKeyMapper.apply(t))) ? ExceptionalStream.of(func.apply(t, null)) : ExceptionalStream.of(values).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        joinedRights.put(u2, u2);
                        return func.apply(t, u2);
                    }
                });
            }
        }).append(ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

            @Override
            public boolean test(U u2) {
                return !joinedRights.containsKey(u2);
            }
        }).map(new Throwables.Function<U, R, E>(){

            @Override
            public R apply(U u2) throws Exception {
                return func.apply(null, u2);
            }
        }));
    }

    public <K> ExceptionalStream<Pair<T, T>, E> fullJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.fullJoin(b, keyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <K, R> ExceptionalStream<R, E> fullJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.BiFunction<? super T, ? super T, R, ? extends E> func) {
        return this.fullJoin(b, keyMapper, keyMapper, func);
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> fullJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        final IdentityHashMap joinedRights = new IdentityHashMap();
        final u.Holder holder = new u.Holder();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private List<U> c = null;
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                List values;
                if (this.rightKeyMap == null) {
                    this.c = b.toList();
                    this.rightKeyMap = ListMultimap.from(this.c, rightKeyMapper);
                    holder.setValue(this.c);
                }
                return N.isNullOrEmpty(values = (List)this.rightKeyMap.get(leftKeyMapper.apply(t))) ? ExceptionalStream.of(func.apply(t, null)) : ExceptionalStream.of(values).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        joinedRights.put(u2, u2);
                        return func.apply(t, u2);
                    }
                });
            }
        }).append(ExceptionalStream.of(holder).flattMap(HOLDER_VALUE_GETTER).filter(new Throwables.Predicate<U, E>(){

            @Override
            public boolean test(U u2) {
                return !joinedRights.containsKey(u2);
            }
        }).map(new Throwables.Function<U, R, E>(){

            @Override
            public R apply(U u2) throws Exception {
                return func.apply(null, u2);
            }
        }));
    }

    @IntermediateOp
    public <U> ExceptionalStream<Pair<T, U>, E> fullJoin(final Collection<? extends U> b, final Throwables.BiPredicate<? super T, ? super U, ? extends E> predicate) {
        this.assertNotClosed();
        final IdentityHashMap joinedRights = new IdentityHashMap();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<Pair<T, U>, E>, E>(){

            @Override
            public ExceptionalStream<Pair<T, U>, E> apply(final T t) {
                return ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

                    @Override
                    public boolean test(U u2) throws Exception {
                        return predicate.test(t, u2);
                    }
                }).map(new Throwables.Function<U, Pair<T, U>, E>(){

                    @Override
                    public Pair<T, U> apply(U u2) {
                        joinedRights.put(u2, u2);
                        return Pair.of(t, u2);
                    }
                }).appendIfEmpty(Pair.of(t, null));
            }
        }).append(ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

            @Override
            public boolean test(U u2) {
                return !joinedRights.containsKey(u2);
            }
        }).map(new Throwables.Function<U, Pair<T, U>, E>(){

            @Override
            public Pair<T, U> apply(U u2) {
                return Pair.of(null, u2);
            }
        }));
    }

    @IntermediateOp
    public <U, K> ExceptionalStream<Pair<T, U>, E> leftJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper) {
        return this.leftJoin(b, leftKeyMapper, rightKeyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> leftJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                List values;
                if (this.rightKeyMap == null) {
                    this.rightKeyMap = ListMultimap.from(b, rightKeyMapper);
                }
                return N.isNullOrEmpty(values = (List)this.rightKeyMap.get(leftKeyMapper.apply(t))) ? ExceptionalStream.of(func.apply(t, null)) : ExceptionalStream.of(values).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        return func.apply(t, u2);
                    }
                });
            }
        });
    }

    public <K> ExceptionalStream<Pair<T, T>, E> leftJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.leftJoin(b, keyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <K, R> ExceptionalStream<R, E> leftJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.BiFunction<? super T, ? super T, R, ? extends E> func) {
        return this.leftJoin(b, keyMapper, keyMapper, func);
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> leftJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                List values;
                if (this.rightKeyMap == null) {
                    this.rightKeyMap = b.toMultimap(rightKeyMapper);
                }
                return N.isNullOrEmpty(values = (List)this.rightKeyMap.get(leftKeyMapper.apply(t))) ? ExceptionalStream.of(func.apply(t, null)) : ExceptionalStream.of(values).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        return func.apply(t, u2);
                    }
                });
            }
        });
    }

    @IntermediateOp
    public <U> ExceptionalStream<Pair<T, U>, E> leftJoin(final Collection<? extends U> b, final Throwables.BiPredicate<? super T, ? super U, ? extends E> predicate) {
        this.assertNotClosed();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<Pair<T, U>, E>, E>(){

            @Override
            public ExceptionalStream<Pair<T, U>, E> apply(final T t) {
                return ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

                    @Override
                    public boolean test(U u2) throws Exception {
                        return predicate.test(t, u2);
                    }
                }).map(new Throwables.Function<U, Pair<T, U>, E>(){

                    @Override
                    public Pair<T, U> apply(U u2) {
                        return Pair.of(t, u2);
                    }
                }).appendIfEmpty(Pair.of(t, null));
            }
        });
    }

    @IntermediateOp
    public <U, K> ExceptionalStream<Pair<T, U>, E> rightJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper) {
        return this.rightJoin(b, leftKeyMapper, rightKeyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> rightJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        final IdentityHashMap joinedRights = new IdentityHashMap();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                if (this.rightKeyMap == null) {
                    this.rightKeyMap = ListMultimap.from(b, rightKeyMapper);
                }
                return ExceptionalStream.of(this.rightKeyMap.get(leftKeyMapper.apply(t))).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        joinedRights.put(u2, u2);
                        return func.apply(t, u2);
                    }
                });
            }
        }).append(ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

            @Override
            public boolean test(U u2) {
                return !joinedRights.containsKey(u2);
            }
        }).map(new Throwables.Function<U, R, E>(){

            @Override
            public R apply(U u2) throws Exception {
                return func.apply(null, u2);
            }
        }));
    }

    public <K> ExceptionalStream<Pair<T, T>, E> rightJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.rightJoin(b, keyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <K, R> ExceptionalStream<R, E> rightJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.BiFunction<? super T, ? super T, R, ? extends E> func) {
        return this.rightJoin(b, keyMapper, keyMapper, func);
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> rightJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        final IdentityHashMap joinedRights = new IdentityHashMap();
        final u.Holder holder = new u.Holder();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<R, E>, E>(){
            private List<U> c = null;
            private ListMultimap<K, U> rightKeyMap = null;

            @Override
            public ExceptionalStream<R, E> apply(final T t) throws Exception {
                if (this.rightKeyMap == null) {
                    this.c = b.toList();
                    this.rightKeyMap = ListMultimap.from(this.c, rightKeyMapper);
                    holder.setValue(this.c);
                }
                return ExceptionalStream.of(this.rightKeyMap.get(leftKeyMapper.apply(t))).map(new Throwables.Function<U, R, E>(){

                    @Override
                    public R apply(U u2) throws Exception {
                        joinedRights.put(u2, u2);
                        return func.apply(t, u2);
                    }
                });
            }
        }).append(ExceptionalStream.of(holder).flattMap(HOLDER_VALUE_GETTER).filter(new Throwables.Predicate<U, E>(){

            @Override
            public boolean test(U u2) {
                return !joinedRights.containsKey(u2);
            }
        }).map(new Throwables.Function<U, R, E>(){

            @Override
            public R apply(U u2) throws Exception {
                return func.apply(null, u2);
            }
        }));
    }

    @IntermediateOp
    public <U> ExceptionalStream<Pair<T, U>, E> rightJoin(final Collection<? extends U> b, final Throwables.BiPredicate<? super T, ? super U, ? extends E> predicate) {
        this.assertNotClosed();
        final IdentityHashMap joinedRights = new IdentityHashMap();
        return this.flatMap(new Throwables.Function<T, ExceptionalStream<Pair<T, U>, E>, E>(){

            @Override
            public ExceptionalStream<Pair<T, U>, E> apply(final T t) {
                return ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

                    @Override
                    public boolean test(U u2) throws Exception {
                        return predicate.test(t, u2);
                    }
                }).map(new Throwables.Function<U, Pair<T, U>, E>(){

                    @Override
                    public Pair<T, U> apply(U u2) {
                        joinedRights.put(u2, u2);
                        return Pair.of(t, u2);
                    }
                });
            }
        }).append(ExceptionalStream.of(b).filter(new Throwables.Predicate<U, E>(){

            @Override
            public boolean test(U u2) {
                return !joinedRights.containsKey(u2);
            }
        }).map(new Throwables.Function<U, Pair<T, U>, E>(){

            @Override
            public Pair<T, U> apply(U u2) {
                return Pair.of(null, u2);
            }
        }));
    }

    @IntermediateOp
    public <U, K> ExceptionalStream<Pair<T, List<U>>, E> groupJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper) {
        return this.groupJoin(b, leftKeyMapper, rightKeyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> groupJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super List<U>, R, ? extends E> func) {
        this.assertNotClosed();
        Throwables.Function mapper = new Throwables.Function<T, R, E>(){
            private volatile boolean initialized = false;
            private volatile Map<K, List<U>> map = null;
            private List<U> val = null;

            @Override
            public R apply(T t) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.val = this.map.get(leftKeyMapper.apply(t));
                if (this.val == null) {
                    return func.apply(t, new ArrayList(0));
                }
                return func.apply(t, this.val);
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.map = ExceptionalStream.of(b).groupTo(rightKeyMapper);
                }
            }
        };
        return this.map(mapper);
    }

    public <K> ExceptionalStream<Pair<T, List<T>>, E> groupJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) {
        return this.groupJoin(b, keyMapper, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <K, R> ExceptionalStream<R, E> groupJoin(Collection<? extends T> b, Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.BiFunction<? super T, ? super List<T>, R, ? extends E> func) {
        return this.groupJoin(b, keyMapper, keyMapper, func);
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> groupJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BiFunction<? super T, ? super List<U>, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        Throwables.Function mapper = new Throwables.Function<T, R, E>(){
            private volatile boolean initialized = false;
            private volatile Map<K, List<U>> map = null;
            private List<U> val = null;

            @Override
            public R apply(T t) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.val = this.map.get(leftKeyMapper.apply(t));
                if (this.val == null) {
                    return func.apply(t, new ArrayList(0));
                }
                return func.apply(t, this.val);
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.map = b.groupTo(rightKeyMapper);
                }
            }
        };
        return this.map(mapper);
    }

    @IntermediateOp
    public <U, K> ExceptionalStream<Pair<T, U>, E> groupJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, Throwables.BinaryOperator<U, ? extends E> mergeFunction) {
        return this.groupJoin(b, leftKeyMapper, rightKeyMapper, mergeFunction, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> groupJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BinaryOperator<U, ? extends E> mergeFunction, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        Throwables.Function mapper = new Throwables.Function<T, R, E>(){
            private volatile boolean initialized = false;
            private volatile Map<K, U> map = null;
            private U val = null;

            @Override
            public R apply(T t) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.val = this.map.get(leftKeyMapper.apply(t));
                if (this.val == null) {
                    return func.apply(t, null);
                }
                return func.apply(t, this.val);
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.map = ExceptionalStream.of(b).toMap(rightKeyMapper, Fn.Fnn.identity(), mergeFunction);
                }
            }
        };
        return this.map(mapper);
    }

    @IntermediateOp
    public <U, K, R> ExceptionalStream<R, E> groupJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Throwables.BinaryOperator<U, ? extends E> mergeFunction, final Throwables.BiFunction<? super T, ? super U, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        Throwables.Function mapper = new Throwables.Function<T, R, E>(){
            private volatile boolean initialized = false;
            private volatile Map<K, U> map = null;
            private U val = null;

            @Override
            public R apply(T t) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.val = this.map.get(leftKeyMapper.apply(t));
                if (this.val == null) {
                    return func.apply(t, null);
                }
                return func.apply(t, this.val);
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.map = b.toMap(rightKeyMapper, Fn.Fnn.identity(), mergeFunction);
                }
            }
        };
        return this.map(mapper);
    }

    @IntermediateOp
    public <U, K, A, D> ExceptionalStream<Pair<T, D>, E> groupJoin(Collection<? extends U> b, Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, Collector<? super U, A, D> downstream) {
        return this.groupJoin(b, leftKeyMapper, rightKeyMapper, downstream, Fn.Fnn.pair());
    }

    @IntermediateOp
    public <U, K, A, D, R> ExceptionalStream<R, E> groupJoin(final Collection<? extends U> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Collector<? super U, A, D> downstream, final Throwables.BiFunction<? super T, ? super D, R, ? extends E> func) {
        this.assertNotClosed();
        Throwables.Function mapper = new Throwables.Function<T, R, E>(){
            private volatile boolean initialized = false;
            private volatile Map<K, D> map = null;
            private D val = null;

            @Override
            public R apply(T t) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.val = this.map.get(leftKeyMapper.apply(t));
                if (this.val == null) {
                    return func.apply(t, ExceptionalStream.empty().collect(downstream));
                }
                return func.apply(t, this.val);
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.map = ExceptionalStream.of(b).toMap(rightKeyMapper, Fn.Fnn.identity(), downstream);
                }
            }
        };
        return this.map(mapper);
    }

    @IntermediateOp
    public <U, K, A, D, R> ExceptionalStream<R, E> groupJoin(final ExceptionalStream<? extends U, E> b, final Throwables.Function<? super T, ? extends K, ? extends E> leftKeyMapper, final Throwables.Function<? super U, ? extends K, ? extends E> rightKeyMapper, final Collector<? super U, A, D> downstream, final Throwables.BiFunction<? super T, ? super D, R, ? extends E> func) {
        this.assertNotClosed();
        this.checkArgNotNull(b, "stream");
        Throwables.Function mapper = new Throwables.Function<T, R, E>(){
            private volatile boolean initialized = false;
            private volatile Map<K, D> map = null;
            private D val = null;

            @Override
            public R apply(T t) throws Exception {
                if (!this.initialized) {
                    this.init();
                }
                this.val = this.map.get(leftKeyMapper.apply(t));
                if (this.val == null) {
                    return func.apply(t, ExceptionalStream.empty().collect(downstream));
                }
                return func.apply(t, this.val);
            }

            private void init() throws Exception {
                if (!this.initialized) {
                    this.initialized = true;
                    this.map = b.toMap(rightKeyMapper, Fn.Fnn.identity(), downstream);
                }
            }
        };
        return this.map(mapper);
    }

    @TerminalOp
    public <E2 extends Exception> void forEach(Throwables.Consumer<? super T, ? extends E2> action) throws E, E2 {
        this.assertNotClosed();
        this.checkArgNotNull(action, "action");
        try {
            while (this.elements.hasNext()) {
                action.accept(this.elements.next());
            }
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <E2 extends Exception> void forEachIndexed(Throwables.IndexedConsumer<? super T, ? extends E2> action) throws E, E2 {
        this.assertNotClosed();
        this.checkArgNotNull(action, "action");
        MutableInt idx = MutableInt.of(0);
        try {
            while (this.elements.hasNext()) {
                action.accept(idx.getAndIncrement(), this.elements.next());
            }
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    @Beta
    public void forEachToBreak(final Throwables.BiConsumer<? super T, MutableBoolean, E> action) throws E {
        this.assertNotClosed();
        final MutableBoolean flagToBreak = MutableBoolean.of(false);
        Throwables.Consumer tmp = new Throwables.Consumer<T, E>(){

            @Override
            public void accept(T t) throws Exception {
                action.accept(t, flagToBreak);
            }
        };
        this.takeWhile(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return flagToBreak.isFalse();
            }
        }).forEach(tmp);
    }

    @TerminalOp
    @Beta
    public void forEachToBreak(final MutableBoolean flagToBreak, Throwables.Consumer<? super T, E> action) throws E {
        this.assertNotClosed();
        this.takeWhile(new Throwables.Predicate<T, E>(){

            @Override
            public boolean test(T value) {
                return flagToBreak.isFalse();
            }
        }).forEach(action);
    }

    @TerminalOp
    public <E2 extends Exception, E3 extends Exception> void forEach(Throwables.Consumer<? super T, ? extends E2> action, Throwables.Runnable<? extends E3> onComplete) throws E, E2, E3 {
        this.assertNotClosed();
        this.checkArgNotNull(action, "action");
        this.checkArgNotNull(onComplete, "onComplete");
        try {
            while (this.elements.hasNext()) {
                action.accept(this.elements.next());
            }
            onComplete.run();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <U, E2 extends Exception, E3 extends Exception> void forEach(Throwables.Function<? super T, ? extends Collection<? extends U>, ? extends E2> flatMapper, Throwables.BiConsumer<? super T, ? super U, ? extends E3> action) throws E, E2, E3 {
        this.assertNotClosed();
        this.checkArgNotNull(flatMapper, "flatMapper");
        this.checkArgNotNull(action, "action");
        Collection<U> c = null;
        Object next = null;
        try {
            while (this.elements.hasNext()) {
                next = this.elements.next();
                c = flatMapper.apply(next);
                if (!N.notNullOrEmpty(c)) continue;
                for (U u2 : c) {
                    action.accept(next, u2);
                }
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <T2, T3, E2 extends Exception, E3 extends Exception, E4 extends Exception> void forEach(Throwables.Function<? super T, ? extends Collection<T2>, ? extends E2> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, ? extends E3> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, ? extends E4> action) throws E, E2, E3, E4 {
        this.assertNotClosed();
        this.checkArgNotNull(flatMapper, "flatMapper");
        this.checkArgNotNull(flatMapper2, "flatMapper2");
        this.checkArgNotNull(action, "action");
        Collection<T2> c2 = null;
        Collection<T3> c3 = null;
        Object next = null;
        try {
            while (this.elements.hasNext()) {
                next = this.elements.next();
                c2 = flatMapper.apply(next);
                if (!N.notNullOrEmpty(c2)) continue;
                for (T2 t2 : c2) {
                    c3 = flatMapper2.apply(t2);
                    if (!N.notNullOrEmpty(c3)) continue;
                    for (T3 t3 : c3) {
                        action.accept(next, t2, t3);
                    }
                }
            }
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <E2 extends Exception> void forEachPair(Throwables.BiConsumer<? super T, ? super T, ? extends E2> action) throws E, E2 {
        this.forEachPair(action, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <E2 extends Exception> void forEachPair(Throwables.BiConsumer<? super T, ? super T, ? extends E2> action, int increment) throws E, E2 {
        this.assertNotClosed();
        int windowSize = 2;
        this.checkArgPositive(increment, "increment");
        try {
            boolean isFirst = true;
            Object prev = null;
            while (this.elements.hasNext()) {
                if (increment > 2 && !isFirst) {
                    int skipNum = increment - 2;
                    while (skipNum-- > 0 && this.elements.hasNext()) {
                        this.elements.next();
                    }
                    if (!this.elements.hasNext()) {
                        break;
                    }
                }
                if (increment == 1) {
                    Object u2 = isFirst ? (Object)this.elements.next() : prev;
                    prev = this.elements.hasNext() ? (Object)this.elements.next() : null;
                    action.accept(u2, prev);
                } else {
                    action.accept(this.elements.next(), this.elements.hasNext() ? (Object)this.elements.next() : null);
                }
                isFirst = false;
            }
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <E2 extends Exception> void forEachTriple(Throwables.TriConsumer<? super T, ? super T, ? super T, ? extends E2> action) throws E, E2 {
        this.forEachTriple(action, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <E2 extends Exception> void forEachTriple(Throwables.TriConsumer<? super T, ? super T, ? super T, ? extends E2> action, int increment) throws E, E2 {
        this.assertNotClosed();
        int windowSize = 3;
        this.checkArgPositive(increment, "increment");
        try {
            boolean isFirst = true;
            Object prev = null;
            Object prev2 = null;
            while (this.elements.hasNext()) {
                if (increment > 3 && !isFirst) {
                    int skipNum = increment - 3;
                    while (skipNum-- > 0 && this.elements.hasNext()) {
                        this.elements.next();
                    }
                    if (!this.elements.hasNext()) {
                        break;
                    }
                }
                if (increment == 1) {
                    Object c = isFirst ? (Object)this.elements.next() : prev2;
                    prev2 = isFirst ? (this.elements.hasNext() ? (Object)this.elements.next() : null) : prev;
                    prev = this.elements.hasNext() ? (Object)this.elements.next() : null;
                    action.accept(c, prev2, prev);
                } else if (increment == 2) {
                    Object c = isFirst ? (Object)this.elements.next() : prev;
                    prev = this.elements.hasNext() ? (Object)this.elements.next() : null;
                    action.accept(c, this.elements.hasNext() ? (Object)this.elements.next() : null, prev);
                } else {
                    action.accept(this.elements.next(), this.elements.hasNext() ? (Object)this.elements.next() : null, this.elements.hasNext() ? (Object)this.elements.next() : null);
                }
                isFirst = false;
            }
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> min(Comparator<? super T> comparator) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            if (this.sorted && ExceptionalStream.isSameComparator(comparator, comparator)) {
                u.Optional<T> optional = u.Optional.of(this.elements.next());
                return optional;
            }
            comparator = comparator == null ? Comparators.NATURAL_ORDER : comparator;
            T candidate = this.elements.next();
            Object next = null;
            while (this.elements.hasNext()) {
                next = this.elements.next();
                if (comparator.compare(next, candidate) >= 0) continue;
                candidate = next;
            }
            u.Optional<T> optional = u.Optional.of(candidate);
            return optional;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> minBy(Function<? super T, ? extends Comparable> keyMapper) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(keyMapper, "keyMapper");
        try {
            Comparator<? super T> comparator = Fn.comparingBy(keyMapper);
            u.Optional<? super T> optional = this.min(comparator);
            return optional;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> max(Comparator<? super T> comparator) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            if (this.sorted && ExceptionalStream.isSameComparator(comparator, comparator)) {
                Object next = null;
                while (this.elements.hasNext()) {
                    next = this.elements.next();
                }
                u.Optional<Object> optional = u.Optional.of(next);
                return optional;
            }
            comparator = comparator == null ? Comparators.NATURAL_ORDER : comparator;
            T candidate = this.elements.next();
            Object next = null;
            while (this.elements.hasNext()) {
                next = this.elements.next();
                if (comparator.compare(next, candidate) <= 0) continue;
                candidate = next;
            }
            u.Optional<T> optional = u.Optional.of(candidate);
            return optional;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> maxBy(Function<? super T, ? extends Comparable> keyMapper) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(keyMapper, "keyMapper");
        try {
            Comparator<? super T> comparator = Fn.comparingBy(keyMapper);
            u.Optional<? super T> optional = this.max(comparator);
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public boolean anyMatch(Throwables.Predicate<? super T, ? extends E> predicate) throws E {
        this.assertNotClosed();
        try {
            while (this.elements.hasNext()) {
                if (!predicate.test(this.elements.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public boolean allMatch(Throwables.Predicate<? super T, ? extends E> predicate) throws E {
        this.assertNotClosed();
        try {
            while (this.elements.hasNext()) {
                if (predicate.test(this.elements.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public boolean noneMatch(Throwables.Predicate<? super T, ? extends E> predicate) throws E {
        this.assertNotClosed();
        try {
            while (this.elements.hasNext()) {
                if (!predicate.test(this.elements.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public boolean nMatch(long atLeast, long atMost, Throwables.Predicate<? super T, ? extends E> predicate) throws E {
        this.assertNotClosed();
        this.checkArgNotNegative(atLeast, "atLeast");
        this.checkArgNotNegative(atMost, "atMost");
        this.checkArgument(atLeast <= atMost, "'atLeast' must be <= 'atMost'");
        long cnt = 0L;
        try {
            while (this.elements.hasNext()) {
                if (!predicate.test(this.elements.next()) || ++cnt <= atMost) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.close();
        }
        return cnt >= atLeast && cnt <= atMost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> findFirst(Throwables.Predicate<? super T, E> predicate) throws E {
        this.assertNotClosed();
        try {
            while (this.elements.hasNext()) {
                T e = this.elements.next();
                if (!predicate.test(e)) continue;
                u.Optional<T> optional = u.Optional.of(e);
                return optional;
            }
        }
        finally {
            this.close();
        }
        return u.Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> findLast(Throwables.Predicate<? super T, E> predicate) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            boolean hasResult = false;
            Object e = null;
            Object result = null;
            while (this.elements.hasNext()) {
                e = this.elements.next();
                if (!predicate.test(e)) continue;
                result = e;
                hasResult = true;
            }
            u.Optional<Object> optional = hasResult ? u.Optional.of(result) : u.Optional.empty();
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public u.Optional<T> findAny(Throwables.Predicate<? super T, E> predicate) throws E {
        return this.findFirst(predicate);
    }

    @SafeVarargs
    @TerminalOp
    public final boolean containsAll(final T ... a) throws E {
        this.assertNotClosed();
        try {
            if (N.isNullOrEmpty(a)) {
                boolean bl = true;
                return bl;
            }
            if (a.length == 1 || a.length == 2 && N.equals(a[0], a[1])) {
                boolean bl = this.anyMatch(Fn.Fnn.pp(Fn.equal(a[0])));
                return bl;
            }
            if (a.length == 2) {
                boolean bl = this.filter(new Throwables.Predicate<T, E>(){
                    private final T val1;
                    private final T val2;
                    {
                        this.val1 = a[0];
                        this.val2 = a[1];
                    }

                    @Override
                    public boolean test(T t) {
                        return N.equals(t, this.val1) || N.equals(t, this.val2);
                    }
                }).distinct().limit(2L).count() == 2L;
                return bl;
            }
            boolean bl = this.containsAll((Collection<? extends T>)N.asSet(a));
            return bl;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public boolean containsAll(Collection<? extends T> c) throws E {
        this.assertNotClosed();
        try {
            if (N.isNullOrEmpty(c)) {
                boolean bl = true;
                return bl;
            }
            if (c.size() == 1) {
                Object val = c instanceof List ? ((List)c).get(0) : c.iterator().next();
                boolean bl = this.anyMatch(Fn.Fnn.pp(Fn.equal(val)));
                return bl;
            }
            final Set<T> set = c instanceof Set ? (Set<T>)c : N.newHashSet(c);
            int distinctCount = set.size();
            boolean bl = this.filter(new Throwables.Predicate<T, E>(){

                @Override
                public boolean test(T t) {
                    return set.contains(t);
                }
            }).distinct().limit(distinctCount).count() == (long)distinctCount;
            return bl;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    @TerminalOp
    public final boolean containsAny(final T ... a) throws E {
        this.assertNotClosed();
        try {
            if (N.isNullOrEmpty(a)) {
                boolean bl = false;
                return bl;
            }
            if (a.length == 1 || a.length == 2 && N.equals(a[0], a[1])) {
                boolean bl = this.anyMatch(Fn.Fnn.pp(Fn.equal(a[0])));
                return bl;
            }
            if (a.length == 2) {
                boolean bl = this.anyMatch(new Throwables.Predicate<T, E>(){
                    private final T val1;
                    private final T val2;
                    {
                        this.val1 = a[0];
                        this.val2 = a[1];
                    }

                    @Override
                    public boolean test(T t) {
                        return N.equals(t, this.val1) || N.equals(t, this.val2);
                    }
                });
                return bl;
            }
            final Set<T> set = N.asSet(a);
            boolean bl = this.anyMatch(new Throwables.Predicate<T, E>(){

                @Override
                public boolean test(T t) {
                    return set.contains(t);
                }
            });
            return bl;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public boolean containsAny(Collection<? extends T> c) throws E {
        this.assertNotClosed();
        try {
            if (N.isNullOrEmpty(c)) {
                boolean bl = false;
                return bl;
            }
            if (c.size() == 1) {
                Object val = c instanceof List ? ((List)c).get(0) : c.iterator().next();
                boolean bl = this.anyMatch(Fn.Fnn.pp(Fn.equal(val)));
                return bl;
            }
            final Set<? extends T> set = c instanceof Set ? (Set<? extends T>)c : N.newHashSet(c);
            boolean bl = this.anyMatch(new Throwables.Predicate<T, E>(){

                @Override
                public boolean test(T t) {
                    return set.contains(t);
                }
            });
            return bl;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public boolean hasDuplicates() throws E {
        this.assertNotClosed();
        try {
            Set set = N.newHashSet();
            while (this.elements.hasNext()) {
                if (set.add(this.elements.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<T> kthLargest(int k, Comparator<? super T> comparator) throws E {
        this.assertNotClosed();
        this.checkArgPositive(k, "k");
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            if (this.sorted && ExceptionalStream.isSameComparator(comparator, this.cmp)) {
                LinkedList<T> queue = new LinkedList<T>();
                while (this.elements.hasNext()) {
                    if (queue.size() >= k) {
                        queue.poll();
                    }
                    queue.offer(this.elements.next());
                }
                u.Optional optional = queue.size() < k ? u.Optional.empty() : u.Optional.of(queue.peek());
                return optional;
            }
            comparator = comparator == null ? Comparators.NATURAL_ORDER : comparator;
            PriorityQueue<T> queue = new PriorityQueue<T>(k, comparator);
            Object e = null;
            while (this.elements.hasNext()) {
                e = this.elements.next();
                if (queue.size() < k) {
                    queue.offer(e);
                    continue;
                }
                if (comparator.compare(e, queue.peek()) <= 0) continue;
                queue.poll();
                queue.offer(e);
            }
            u.Optional optional = queue.size() < k ? u.Optional.empty() : u.Optional.of(queue.peek());
            return optional;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.Optional<Map<Percentage, T>> percentiles(Comparator<? super T> comparator) throws E {
        this.assertNotClosed();
        try {
            Object[] a = this.sorted(comparator).toArray();
            if (N.isNullOrEmpty(a)) {
                u.Optional<Map<Percentage, T>> optional = u.Optional.empty();
                return optional;
            }
            u.Optional<Map<Percentage, T>> optional = u.Optional.of(N.percentiles(a));
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public u.Optional<T> first() throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            u.Optional<T> optional = u.Optional.of(this.elements.next());
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public u.Optional<T> last() throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            T next = this.elements.next();
            while (this.elements.hasNext()) {
                next = this.elements.next();
            }
            u.Optional<T> optional = u.Optional.of(next);
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    @Beta
    public u.Optional<T> elementAt(long position) throws E {
        this.assertNotClosed();
        this.checkArgNotNegative(position, "position");
        if (position == 0L) {
            return this.first();
        }
        return this.skip(position).first();
    }

    @TerminalOp
    public u.Optional<T> onlyOne() throws DuplicatedResultException, E {
        this.assertNotClosed();
        try {
            u.Optional result = u.Optional.empty();
            if (this.elements.hasNext()) {
                result = u.Optional.of(this.elements.next());
                if (this.elements.hasNext()) {
                    throw new DuplicatedResultException("There are at least two elements: " + StringUtil.Strings.concat(result.get(), (Object)", ", this.elements.next()));
                }
            }
            u.Optional optional = result;
            return optional;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public long count() throws E {
        this.assertNotClosed();
        try {
            long l = this.elements.count();
            return l;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public Object[] toArray() throws E {
        return this.toArray(true);
    }

    Object[] toArray(boolean closeStream) throws E {
        this.assertNotClosed();
        try {
            Object[] objectArray = this.toList().toArray();
            return objectArray;
        }
        finally {
            if (closeStream) {
                this.close();
            }
        }
    }

    Object[] toArrayForIntermediateOp() throws E {
        return this.toArray(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <A> A[] toArray(IntFunction<A[]> generator) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(generator, "generator");
        try {
            List<A> list = this.toList();
            A[] AArray = list.toArray(generator.apply(list.size()));
            return AArray;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public List<T> toList() throws E {
        this.assertNotClosed();
        try {
            ArrayList<T> result = new ArrayList<T>();
            while (this.elements.hasNext()) {
                result.add(this.elements.next());
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public Set<T> toSet() throws E {
        this.assertNotClosed();
        try {
            Set result = N.newHashSet();
            while (this.elements.hasNext()) {
                result.add(this.elements.next());
            }
            Set set = result;
            return set;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public ImmutableList<T> toImmutableList() throws E {
        return ImmutableList.of(this.toList());
    }

    @TerminalOp
    public ImmutableSet<T> toImmutableSet() throws E {
        return ImmutableSet.of(this.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <C extends Collection<T>> C toCollection(Supplier<? extends C> supplier) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(supplier, "supplier");
        try {
            Collection result = (Collection)supplier.get();
            while (this.elements.hasNext()) {
                result.add(this.elements.next());
            }
            Collection collection = result;
            return (C)collection;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <R> R toListAndThen(Throwables.Function<? super List<T>, R, E> func) throws E {
        this.assertNotClosed();
        return func.apply(this.toList());
    }

    @TerminalOp
    public <R> R toSetAndThen(Throwables.Function<? super Set<T>, R, E> func) throws E {
        this.assertNotClosed();
        return func.apply(this.toSet());
    }

    @TerminalOp
    public <R, CC extends Collection<T>> R toCollectionAndThen(Supplier<? extends CC> supplier, Throwables.Function<? super CC, R, E> func) throws E {
        this.assertNotClosed();
        return func.apply(this.toCollection(supplier));
    }

    @TerminalOp
    public <K, V> Map<K, V> toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper) throws E, IllegalStateException {
        return this.toMap(keyMapper, valueMapper, Fn.Suppliers.ofMap());
    }

    @TerminalOp
    public <K, V, M extends Map<K, V>> M toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Supplier<? extends M> mapFactory) throws E, IllegalStateException {
        return this.toMap(keyMapper, valueMapper, Fn.Fnn.throwingMerger(), mapFactory);
    }

    @TerminalOp
    public <K, V> Map<K, V> toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Throwables.BinaryOperator<V, ? extends E> mergeFunction) throws E {
        return this.toMap(keyMapper, valueMapper, mergeFunction, Fn.Suppliers.ofMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <K, V, M extends Map<K, V>> M toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Throwables.BinaryOperator<V, ? extends E> mergeFunction, Supplier<? extends M> mapFactory) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(keyMapper, "keyMapper");
        this.checkArgNotNull(valueMapper, "valueMapper");
        this.checkArgNotNull(mergeFunction, "mergeFunction");
        this.checkArgNotNull(mapFactory, "mapFactory");
        try {
            Map result = (Map)mapFactory.get();
            Object next = null;
            while (this.elements.hasNext()) {
                next = this.elements.next();
                Maps.merge(result, keyMapper.apply(next), valueMapper.apply(next), mergeFunction);
            }
            Map map = result;
            return (M)map;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <K, A, D> Map<K, D> toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Collector<? super T, A, D> downstream) throws E {
        return this.toMap(keyMapper, downstream, Fn.Suppliers.ofMap());
    }

    @TerminalOp
    public <K, A, D, M extends Map<K, D>> M toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Collector<? super T, A, D> downstream, Supplier<? extends M> mapFactory) throws E {
        return this.toMap(keyMapper, Fn.Fnn.identity(), downstream, mapFactory);
    }

    @TerminalOp
    public <K, V, A, D> Map<K, D> toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Collector<? super V, A, D> downstream) throws E {
        return this.toMap(keyMapper, valueMapper, downstream, Fn.Suppliers.ofMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <K, V, A, D, M extends Map<K, D>> M toMap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Collector<? super V, A, D> downstream, Supplier<? extends M> mapFactory) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(keyMapper, "keyMapper");
        this.checkArgNotNull(valueMapper, "valueMapper");
        this.checkArgNotNull(downstream, "downstream");
        this.checkArgNotNull(mapFactory, "mapFactory");
        try {
            Map result;
            Supplier<A> downstreamSupplier = downstream.supplier();
            BiConsumer<A, Object> downstreamAccumulator = downstream.accumulator();
            Function<A, D> downstreamFinisher = downstream.finisher();
            Map tmp = result = (Map)mapFactory.get();
            Object next = null;
            Object key = null;
            Object container = null;
            while (this.elements.hasNext()) {
                next = this.elements.next();
                key = keyMapper.apply(next);
                container = tmp.get(key);
                if (container == null) {
                    container = downstreamSupplier.get();
                    tmp.put(key, container);
                }
                downstreamAccumulator.accept(container, valueMapper.apply(next));
            }
            for (Map.Entry entry : result.entrySet()) {
                entry.setValue(downstreamFinisher.apply(entry.getValue()));
            }
            Map map = result;
            return (M)map;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <K> Map<K, List<T>> groupTo(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) throws E {
        return this.groupTo(keyMapper, Fn.Suppliers.ofMap());
    }

    @TerminalOp
    public <K, M extends Map<K, List<T>>> M groupTo(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Supplier<? extends M> mapFactory) throws E {
        Throwables.Function valueMapper = Fn.Fnn.identity();
        return this.groupTo(keyMapper, valueMapper, mapFactory);
    }

    @TerminalOp
    public <K, V> Map<K, List<V>> groupTo(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper) throws E {
        return this.groupTo(keyMapper, valueMapper, Fn.Suppliers.ofMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <K, V, M extends Map<K, List<V>>> M groupTo(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Supplier<? extends M> mapFactory) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(keyMapper, "keyMapper");
        this.checkArgNotNull(valueMapper, "valueMapper");
        this.checkArgNotNull(mapFactory, "mapFactory");
        try {
            Map result = (Map)mapFactory.get();
            Object next = null;
            Object key = null;
            while (this.elements.hasNext()) {
                next = this.elements.next();
                key = keyMapper.apply(next);
                if (!result.containsKey(key)) {
                    result.put(key, new ArrayList());
                }
                ((List)result.get(key)).add(valueMapper.apply(next));
            }
            Map map = result;
            return (M)map;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <K> ListMultimap<K, T> toMultimap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper) throws E {
        return this.toMultimap(keyMapper, Fn.Suppliers.ofListMultimap());
    }

    @TerminalOp
    public <K, V extends Collection<T>, M extends Multimap<K, T, V>> M toMultimap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Supplier<? extends M> mapFactory) throws E {
        Throwables.Function valueMapper = Fn.Fnn.identity();
        return this.toMultimap(keyMapper, valueMapper, mapFactory);
    }

    @TerminalOp
    public <K, V> ListMultimap<K, V> toMultimap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper) throws E {
        return this.toMultimap(keyMapper, valueMapper, Fn.Suppliers.ofListMultimap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <K, V, C extends Collection<V>, M extends Multimap<K, V, C>> M toMultimap(Throwables.Function<? super T, ? extends K, ? extends E> keyMapper, Throwables.Function<? super T, ? extends V, ? extends E> valueMapper, Supplier<? extends M> mapFactory) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(keyMapper, "keyMapper");
        this.checkArgNotNull(valueMapper, "valueMapper");
        this.checkArgNotNull(mapFactory, "mapFactory");
        try {
            Multimap result = (Multimap)mapFactory.get();
            Object next = null;
            while (this.elements.hasNext()) {
                next = this.elements.next();
                result.put(keyMapper.apply(next), valueMapper.apply(next));
            }
            Multimap multimap = result;
            return (M)multimap;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public Multiset<T> toMultiset() throws E {
        return this.toMultiset(Fn.Suppliers.ofMultiset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public Multiset<T> toMultiset(Supplier<? extends Multiset<T>> supplier) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(supplier, "supplier");
        try {
            Multiset<T> result = supplier.get();
            while (this.elements.hasNext()) {
                result.add(this.elements.next());
            }
            Multiset<T> multiset = result;
            return multiset;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public DataSet toDataSet() throws E {
        return N.newDataSet(this.toList());
    }

    @TerminalOp
    public DataSet toDataSet(List<String> columnNames) throws E {
        return N.newDataSet(columnNames, this.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.OptionalLong sumInt(Throwables.ToIntFunction<? super T, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.OptionalLong optionalLong = u.OptionalLong.empty();
                return optionalLong;
            }
            long sum = 0L;
            while (this.elements.hasNext()) {
                sum += (long)func.applyAsInt(this.elements.next());
            }
            u.OptionalLong optionalLong = u.OptionalLong.of(sum);
            return optionalLong;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.OptionalLong sumLong(Throwables.ToLongFunction<? super T, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.OptionalLong optionalLong = u.OptionalLong.empty();
                return optionalLong;
            }
            long sum = 0L;
            while (this.elements.hasNext()) {
                sum += func.applyAsLong(this.elements.next());
            }
            u.OptionalLong optionalLong = u.OptionalLong.of(sum);
            return optionalLong;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.OptionalDouble sumDouble(Throwables.ToDoubleFunction<? super T, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.OptionalDouble optionalDouble = u.OptionalDouble.empty();
                return optionalDouble;
            }
            KahanSummation summation = new KahanSummation();
            while (this.elements.hasNext()) {
                summation.add(func.applyAsDouble(this.elements.next()));
            }
            u.OptionalDouble optionalDouble = u.OptionalDouble.of(summation.sum());
            return optionalDouble;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.OptionalDouble averageInt(Throwables.ToIntFunction<? super T, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.OptionalDouble optionalDouble = u.OptionalDouble.empty();
                return optionalDouble;
            }
            long sum = 0L;
            long count = 0L;
            while (this.elements.hasNext()) {
                sum += (long)func.applyAsInt(this.elements.next());
                ++count;
            }
            u.OptionalDouble optionalDouble = u.OptionalDouble.of((double)sum / (double)count);
            return optionalDouble;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.OptionalDouble averageLong(Throwables.ToLongFunction<? super T, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.OptionalDouble optionalDouble = u.OptionalDouble.empty();
                return optionalDouble;
            }
            long sum = 0L;
            long count = 0L;
            while (this.elements.hasNext()) {
                sum += func.applyAsLong(this.elements.next());
                ++count;
            }
            u.OptionalDouble optionalDouble = u.OptionalDouble.of((double)sum / (double)count);
            return optionalDouble;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public u.OptionalDouble averageDouble(Throwables.ToDoubleFunction<? super T, ? extends E> func) throws E {
        this.assertNotClosed();
        try {
            if (!this.elements.hasNext()) {
                u.OptionalDouble optionalDouble = u.OptionalDouble.empty();
                return optionalDouble;
            }
            KahanSummation summation = new KahanSummation();
            while (this.elements.hasNext()) {
                summation.add(func.applyAsDouble(this.elements.next()));
            }
            u.OptionalDouble optionalDouble = summation.average();
            return optionalDouble;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <E2 extends Exception> u.Optional<T> reduce(Throwables.BinaryOperator<T, ? extends E2> accumulator) throws E, E2 {
        this.assertNotClosed();
        this.checkArgNotNull(accumulator, "accumulator");
        try {
            if (!this.elements.hasNext()) {
                u.Optional optional = u.Optional.empty();
                return optional;
            }
            Object result = this.elements.next();
            while (this.elements.hasNext()) {
                result = accumulator.apply(result, this.elements.next());
            }
            u.Optional<T> optional = u.Optional.of(result);
            return optional;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <U, E2 extends Exception> U reduce(U identity, Throwables.BiFunction<U, ? super T, U, ? extends E2> accumulator) throws E, E2 {
        this.assertNotClosed();
        this.checkArgNotNull(accumulator, "accumulator");
        try {
            U result = identity;
            while (this.elements.hasNext()) {
                result = accumulator.apply(result, this.elements.next());
            }
            U u2 = result;
            return u2;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <R, E2 extends Exception, E3 extends Exception> R collect(Throwables.Supplier<R, ? extends E2> supplier, Throwables.BiConsumer<? super R, ? super T, ? extends E3> accumulator) throws E, E2, E3 {
        this.assertNotClosed();
        this.checkArgNotNull(supplier, "supplier");
        this.checkArgNotNull(accumulator, "accumulator");
        try {
            R result = supplier.get();
            while (this.elements.hasNext()) {
                accumulator.accept(result, this.elements.next());
            }
            R r = result;
            return r;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <R, RR, E2 extends Exception, E3 extends Exception, E4 extends Exception> RR collect(Throwables.Supplier<R, ? extends E2> supplier, Throwables.BiConsumer<? super R, ? super T, ? extends E3> accumulator, Throwables.Function<? super R, ? extends RR, ? extends E4> finisher) throws E, E2, E3, E4 {
        this.assertNotClosed();
        this.checkArgNotNull(supplier, "supplier");
        this.checkArgNotNull(accumulator, "accumulator");
        this.checkArgNotNull(finisher, "finisher");
        try {
            R result = supplier.get();
            while (this.elements.hasNext()) {
                accumulator.accept(result, this.elements.next());
            }
            RR RR = finisher.apply(result);
            return RR;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public <R, A> R collect(Collector<? super T, A, R> collector) throws E {
        this.assertNotClosed();
        this.checkArgNotNull(collector, "collector");
        try {
            A container = collector.supplier().get();
            BiConsumer<A, A> accumulator = collector.accumulator();
            while (this.elements.hasNext()) {
                accumulator.accept(container, this.elements.next());
            }
            R r = collector.finisher().apply(container);
            return r;
        }
        finally {
            this.close();
        }
    }

    @TerminalOp
    public <R, RR, A, E2 extends Exception> RR collectAndThen(Collector<? super T, A, R> collector, Throwables.Function<? super R, ? extends RR, ? extends E2> func) throws E, E2 {
        this.assertNotClosed();
        this.checkArgNotNull(collector, "collector");
        this.checkArgNotNull(func, "func");
        return func.apply(this.collect(collector));
    }

    @TerminalOp
    public String join(CharSequence delimiter) throws E {
        return this.join(delimiter, "", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TerminalOp
    public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) throws E {
        this.assertNotClosed();
        try {
            Joiner joiner = Joiner.with(delimiter, prefix, suffix).reuseCachedBuffer();
            while (this.elements.hasNext()) {
                joiner.append(this.elements.next());
            }
            String string = joiner.toString();
            return string;
        }
        finally {
            this.close();
        }
    }

    public long persist(File file) throws E, IOException {
        return this.persist(TO_LINE_OF_STRING, file);
    }

    public long persist(String header, String tail, File file) throws E, IOException {
        return this.persist(TO_LINE_OF_STRING, header, tail, file);
    }

    public long persist(Throwables.Function<? super T, String, IOException> toLine, File file) throws E, IOException {
        return this.persist(toLine, null, null, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(Throwables.Function<? super T, String, IOException> toLine, String header, String tail, File file) throws E, IOException {
        this.assertNotClosed();
        FileWriter writer = new FileWriter(file);
        try {
            long l = this.persist(toLine, header, tail, writer);
            return l;
        }
        finally {
            IOUtil.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(Throwables.Function<? super T, String, IOException> toLine, OutputStream os) throws E, IOException {
        this.assertNotClosed();
        BufferedWriter bw = Objectory.createBufferedWriter(os);
        try {
            long l = this.persist(toLine, bw);
            return l;
        }
        finally {
            Objectory.recycle(bw);
        }
    }

    public long persist(Throwables.Function<? super T, String, IOException> toLine, Writer writer) throws E, IOException {
        this.assertNotClosed();
        return this.persist(toLine, null, null, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(Throwables.Function<? super T, String, IOException> toLine, String header, String tail, Writer writer) throws E, IOException {
        this.assertNotClosed();
        try {
            boolean isBufferedWriter = writer instanceof BufferedWriter || writer instanceof java.io.BufferedWriter;
            Writer bw = isBufferedWriter ? writer : Objectory.createBufferedWriter(writer);
            ExceptionalIterator<T, E> iter = this.iterator();
            long cnt = 0L;
            try {
                if (header != null) {
                    bw.write(header);
                    bw.write(IOUtil.LINE_SEPARATOR);
                }
                while (iter.hasNext()) {
                    bw.write(toLine.apply(iter.next()));
                    bw.write(IOUtil.LINE_SEPARATOR);
                    ++cnt;
                }
                if (tail != null) {
                    bw.write(tail);
                    bw.write(IOUtil.LINE_SEPARATOR);
                }
                bw.flush();
            }
            finally {
                if (!isBufferedWriter) {
                    Objectory.recycle((BufferedWriter)bw);
                }
            }
            long l = cnt;
            return l;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(Connection conn, String insertSQL, int batchSize, int batchInterval, Throwables.BiConsumer<? super PreparedStatement, ? super T, SQLException> stmtSetter) throws E, SQLException {
        this.assertNotClosed();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(insertSQL);
            long l = this.persist(stmt, batchSize, batchInterval, stmtSetter);
            return l;
        }
        finally {
            IOUtil.closeQuietly(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long persist(PreparedStatement stmt, int batchSize, int batchInterval, Throwables.BiConsumer<? super PreparedStatement, ? super T, SQLException> stmtSetter) throws E, SQLException {
        this.assertNotClosed();
        this.checkArgument(batchSize > 0 && batchInterval >= 0, "'batchSize'=%s must be greater than 0 and 'batchInterval'=%s can't be negative", batchSize, batchInterval);
        try {
            ExceptionalIterator<T, E> iter = this.iterator();
            long cnt = 0L;
            while (iter.hasNext()) {
                stmtSetter.accept((PreparedStatement)((PreparedStatement)stmt), (PreparedStatement)iter.next());
                stmt.addBatch();
                if (++cnt % (long)batchSize != 0L) continue;
                this.executeBatch(stmt);
                if (batchInterval <= 0) continue;
                N.sleep(batchInterval);
            }
            if (cnt % (long)batchSize > 0L) {
                this.executeBatch(stmt);
            }
            long l = cnt;
            return l;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeBatch(PreparedStatement stmt) throws SQLException {
        try {
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        finally {
            try {
                stmt.clearBatch();
            }
            catch (SQLException e) {
                logger.error("Failed to clear batch parameters after executeBatch", (Throwable)e);
            }
        }
    }

    @TerminalOp
    @Beta
    public void println() throws E {
        N.println(this.join(", ", "[", "]"));
    }

    @IntermediateOp
    @Beta
    public <TT, EE extends Exception> ExceptionalStream<TT, EE> __(Function<? super ExceptionalStream<T, E>, ExceptionalStream<TT, EE>> transfer) {
        this.assertNotClosed();
        this.checkArgNotNull(transfer, "transfer");
        return transfer.apply(this);
    }

    @IntermediateOp
    public ExceptionalStream<T, E> onClose(final Throwables.Runnable<? extends E> closeHandler) {
        this.assertNotClosed();
        this.checkArgNotNull(closeHandler, "closeHandler");
        ArrayDeque<Throwables.Runnable<Throwables.Runnable<? extends E>>> newCloseHandlers = new ArrayDeque<Throwables.Runnable<Throwables.Runnable<? extends E>>>(N.size(this.closeHandlers) + 1);
        newCloseHandlers.add(new Throwables.Runnable<E>(){
            private volatile boolean isClosed = false;

            @Override
            public void run() throws Exception {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
                closeHandler.run();
            }
        });
        if (N.notNullOrEmpty(this.closeHandlers)) {
            newCloseHandlers.addAll(this.closeHandlers);
        }
        return ExceptionalStream.newStream(this.elements, newCloseHandlers);
    }

    @Override
    @TerminalOp
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        if (N.isNullOrEmpty(this.closeHandlers)) {
            this.isClosed = true;
            return;
        }
        this.isClosed = true;
        logger.info("Closing ExceptionalStream");
        ExceptionalStream.close(this.closeHandlers);
    }

    static <E extends Exception> void close(Deque<? extends Throwables.Runnable<? extends E>> closeHandlers) {
        Exception ex = null;
        for (Throwables.Runnable<E> closeHandler : closeHandlers) {
            try {
                closeHandler.run();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw N.toRuntimeException(ex);
        }
    }

    ExceptionalIterator<T, E> iterator() {
        return this.elements;
    }

    void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("This stream has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkArgPositive(int arg, String argNameOrErrorMsg) {
        if (arg <= 0) {
            try {
                N.checkArgPositive(arg, argNameOrErrorMsg);
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkArgNotNegative(long arg, String argNameOrErrorMsg) {
        if (arg < 0L) {
            try {
                N.checkArgNotNegative(arg, argNameOrErrorMsg);
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ARG> ARG checkArgNotNull(ARG obj, String errorMessage) {
        if (obj == null) {
            try {
                N.checkArgNotNull(obj, errorMessage);
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkArgument(boolean b, String errorMessage) {
        if (!b) {
            try {
                N.checkArgument(b, errorMessage);
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkArgument(boolean b, String errorMessageTemplate, int p1, int p2) {
        if (!b) {
            try {
                N.checkArgument(b, errorMessageTemplate, p1, p2);
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw N.toRuntimeException(e);
                }
            }
        }
    }

    static <T, E extends Exception> ExceptionalStream<T, E> newStream(ExceptionalIterator<T, E> iter) {
        return new ExceptionalStream<T, E>(iter, null);
    }

    static <T, E extends Exception> ExceptionalStream<T, E> newStream(ExceptionalIterator<T, E> iter, Deque<Throwables.Runnable<? extends E>> closeHandlers) {
        return new ExceptionalStream<T, E>(iter, closeHandlers);
    }

    static <T, E extends Exception> ExceptionalStream<T, E> newStream(ExceptionalIterator<T, E> iter, boolean sorted, Comparator<? super T> comparator, Deque<Throwables.Runnable<? extends E>> closeHandlers) {
        return new ExceptionalStream<T, E>(iter, sorted, comparator, closeHandlers);
    }

    static Object hashKey(Object obj) {
        return obj == null || !obj.getClass().isArray() ? obj : Wrapper.of(obj);
    }

    static boolean isSameComparator(Comparator<?> a, Comparator<?> b) {
        return a == b || a == null && b == Comparators.NATURAL_ORDER || b == null && a == Comparators.NATURAL_ORDER;
    }

    @Beta
    public static final class Seq {
        private Seq() {
        }

        public static <T> ExceptionalStream<T, RuntimeException> empty() {
            return ExceptionalStream.empty();
        }

        public static <T> ExceptionalStream<T, RuntimeException> just(T e) {
            return ExceptionalStream.just(e);
        }

        public static <T> ExceptionalStream<T, RuntimeException> ofNullable(T e) {
            return ExceptionalStream.ofNullable(e);
        }

        public static <T> ExceptionalStream<T, RuntimeException> of(T ... a) {
            return ExceptionalStream.of(a);
        }

        public static <T> ExceptionalStream<T, RuntimeException> of(Collection<? extends T> c) {
            return ExceptionalStream.of(c);
        }

        public static <T> ExceptionalStream<T, RuntimeException> of(Iterator<? extends T> iter) {
            return ExceptionalStream.of(iter);
        }

        public static <T> ExceptionalStream<T, RuntimeException> of(Iterable<? extends T> iterable) {
            return ExceptionalStream.of(iterable);
        }

        public static <K, V> ExceptionalStream<Map.Entry<K, V>, RuntimeException> of(Map<K, V> m) {
            return ExceptionalStream.of(m);
        }

        public static ExceptionalStream<Integer, RuntimeException> of(int[] a) {
            return ExceptionalStream.of(a);
        }

        public static ExceptionalStream<Long, RuntimeException> of(long[] a) {
            return ExceptionalStream.of(a);
        }

        public static ExceptionalStream<Double, RuntimeException> of(double[] a) {
            return ExceptionalStream.of(a);
        }

        public static <T> ExceptionalStream<T, RuntimeException> of(u.Optional<T> op) {
            return ExceptionalStream.of(op);
        }

        public static <T> ExceptionalStream<T, RuntimeException> of(Throwables.Supplier<Collection<? extends T>, RuntimeException> supplier) {
            return ExceptionalStream.of(supplier);
        }

        public static <T> ExceptionalStream<T, RuntimeException> from(Throwables.Supplier<ExceptionalStream<? extends T, ? extends RuntimeException>, RuntimeException> supplier) {
            return ExceptionalStream.from(supplier);
        }

        public static <K> ExceptionalStream<K, RuntimeException> ofKeys(Map<K, ?> map) {
            return ExceptionalStream.ofKeys(map);
        }

        public static <K, V> ExceptionalStream<K, RuntimeException> ofKeys(Map<K, V> map, Throwables.Predicate<? super V, RuntimeException> valueFilter) {
            return ExceptionalStream.ofKeys(map, valueFilter);
        }

        public static <K, V> ExceptionalStream<K, RuntimeException> ofKeys(Map<K, V> map, Throwables.BiPredicate<? super K, ? super V, RuntimeException> filter) {
            return ExceptionalStream.ofKeys(map, filter);
        }

        public static <V> ExceptionalStream<V, RuntimeException> ofValues(Map<?, V> map) {
            return ExceptionalStream.ofValues(map);
        }

        public static <K, V> ExceptionalStream<V, RuntimeException> ofValues(Map<K, V> map, Throwables.Predicate<? super K, RuntimeException> keyFilter) {
            return ExceptionalStream.ofValues(map, keyFilter);
        }

        public static <K, V> ExceptionalStream<V, RuntimeException> ofValues(Map<K, V> map, Throwables.BiPredicate<? super K, ? super V, RuntimeException> filter) {
            return ExceptionalStream.ofValues(map, filter);
        }

        public static <T> ExceptionalStream<T, RuntimeException> iterate(Throwables.BooleanSupplier<? extends RuntimeException> hasNext, Throwables.Supplier<? extends T, RuntimeException> next) {
            return ExceptionalStream.iterate(hasNext, next);
        }

        public static <T> ExceptionalStream<T, RuntimeException> iterate(T init, Throwables.BooleanSupplier<? extends RuntimeException> hasNext, Throwables.UnaryOperator<T, ? extends RuntimeException> f) {
            return ExceptionalStream.iterate(init, hasNext, f);
        }

        public static <T> ExceptionalStream<T, RuntimeException> iterate(T init, Throwables.Predicate<? super T, RuntimeException> hasNext, Throwables.UnaryOperator<T, RuntimeException> f) {
            return ExceptionalStream.iterate(init, hasNext, f);
        }

        public static <T> ExceptionalStream<T, RuntimeException> iterate(T init, Throwables.UnaryOperator<T, RuntimeException> f) {
            return ExceptionalStream.iterate(init, f);
        }

        public static <T> ExceptionalStream<T, RuntimeException> generate(Throwables.Supplier<T, RuntimeException> supplier) {
            return ExceptionalStream.generate(supplier);
        }

        public static <T> ExceptionalStream<T, RuntimeException> repeat(T element, long n) {
            return ExceptionalStream.repeat(element, n);
        }

        @SafeVarargs
        public static <T> ExceptionalStream<T, RuntimeException> concat(T[] ... a) {
            return ExceptionalStream.concat(a);
        }

        @SafeVarargs
        public static <T> ExceptionalStream<T, RuntimeException> concat(Collection<? extends T> ... a) {
            return ExceptionalStream.concat(a);
        }

        public static <A, B, T> ExceptionalStream<T, RuntimeException> zip(A[] a, B[] b, Throwables.BiFunction<? super A, ? super B, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, zipFunction);
        }

        public static <A, B, C, T> ExceptionalStream<T, RuntimeException> zip(A[] a, B[] b, C[] c, Throwables.TriFunction<? super A, ? super B, ? super C, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, c, zipFunction);
        }

        public static <A, B, T> ExceptionalStream<T, RuntimeException> zip(Collection<? extends A> a, Collection<? extends B> b, Throwables.BiFunction<? super A, ? super B, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, zipFunction);
        }

        public static <A, B, C, T> ExceptionalStream<T, RuntimeException> zip(Collection<? extends A> a, Collection<? extends B> b, Collection<? extends C> c, Throwables.TriFunction<? super A, ? super B, ? super C, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, c, zipFunction);
        }

        public static <A, B, T> ExceptionalStream<T, RuntimeException> zip(Iterator<? extends A> a, Iterator<? extends B> b, Throwables.BiFunction<? super A, ? super B, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, zipFunction);
        }

        public static <A, B, C, T> ExceptionalStream<T, RuntimeException> zip(Iterator<? extends A> a, Iterator<? extends B> b, Iterator<? extends C> c, Throwables.TriFunction<? super A, ? super B, ? super C, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, c, zipFunction);
        }

        public static <A, B, T> ExceptionalStream<T, RuntimeException> zip(A[] a, B[] b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, valueForNoneA, valueForNoneB, zipFunction);
        }

        public static <A, B, C, T> ExceptionalStream<T, RuntimeException> zip(A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, c, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
        }

        public static <A, B, T> ExceptionalStream<T, RuntimeException> zip(Collection<? extends A> a, Collection<? extends B> b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, valueForNoneA, valueForNoneB, zipFunction);
        }

        public static <A, B, C, T> ExceptionalStream<T, RuntimeException> zip(Collection<? extends A> a, Collection<? extends B> b, Collection<? extends C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, c, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
        }

        public static <A, B, T> ExceptionalStream<T, RuntimeException> zip(Iterator<? extends A> a, Iterator<? extends B> b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, valueForNoneA, valueForNoneB, zipFunction);
        }

        public static <A, B, C, T> ExceptionalStream<T, RuntimeException> zip(Iterator<? extends A> a, Iterator<? extends B> b, Iterator<? extends C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, T, RuntimeException> zipFunction) {
            return ExceptionalStream.zip(a, b, c, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
        }

        public static <T> ExceptionalStream<T, RuntimeException> merge(T[] a, T[] b, Throwables.BiFunction<? super T, ? super T, MergeResult, RuntimeException> nextSelector) {
            return ExceptionalStream.merge(a, b, nextSelector);
        }

        public static <T> ExceptionalStream<T, RuntimeException> merge(T[] a, T[] b, T[] c, Throwables.BiFunction<? super T, ? super T, MergeResult, RuntimeException> nextSelector) {
            return ExceptionalStream.merge(a, b, c, nextSelector);
        }

        public static <T> ExceptionalStream<T, RuntimeException> merge(Collection<? extends T> a, Collection<? extends T> b, Throwables.BiFunction<? super T, ? super T, MergeResult, RuntimeException> nextSelector) {
            return ExceptionalStream.merge(a, b, nextSelector);
        }

        public static <T> ExceptionalStream<T, RuntimeException> merge(Collection<? extends T> a, Collection<? extends T> b, Collection<? extends T> c, Throwables.BiFunction<? super T, ? super T, MergeResult, RuntimeException> nextSelector) {
            return ExceptionalStream.merge(a, b, c, nextSelector);
        }

        public static <T> ExceptionalStream<T, RuntimeException> merge(Iterator<? extends T> a, Iterator<? extends T> b, Throwables.BiFunction<? super T, ? super T, MergeResult, RuntimeException> nextSelector) {
            return ExceptionalStream.merge(a, b, nextSelector);
        }

        public static <T> ExceptionalStream<T, RuntimeException> merge(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c, Throwables.BiFunction<? super T, ? super T, MergeResult, RuntimeException> nextSelector) {
            return ExceptionalStream.merge(a, b, c, nextSelector);
        }
    }

    public static final class StreamE<T, E extends Exception>
    extends ExceptionalStream<T, E> {
        StreamE(ExceptionalIterator<T, E> iter, boolean sorted, Comparator<? super T> comparator, Deque<Throwables.Runnable<? extends E>> closeHandlers) {
            super(iter, sorted, comparator, closeHandlers);
        }
    }

    @com.landawn.abacus.annotation.Immutable
    static abstract class ExceptionalIterator<T, E extends Exception>
    implements Immutable {
        private static final ExceptionalIterator EMPTY = new ExceptionalIterator(){

            @Override
            public boolean hasNext() throws Exception {
                return false;
            }

            public Object next() throws Exception {
                throw new NoSuchElementException();
            }
        };

        ExceptionalIterator() {
        }

        public static <T, E extends Exception> ExceptionalIterator<T, E> wrap(final Iterator<? extends T> iter) {
            if (iter == null) {
                return EMPTY;
            }
            return new ExceptionalIterator<T, E>(){

                @Override
                public boolean hasNext() throws Exception {
                    return iter.hasNext();
                }

                @Override
                public T next() throws Exception {
                    return iter.next();
                }
            };
        }

        public static <T, E extends Exception> ExceptionalIterator<T, E> of(final Throwables.Supplier<ExceptionalIterator<T, E>, E> iteratorSupplier) {
            N.checkArgNotNull(iteratorSupplier, "iteratorSupplier");
            return new ExceptionalIterator<T, E>(){
                private ExceptionalIterator<T, E> iter = null;
                private boolean isInitialized = false;

                @Override
                public boolean hasNext() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    return this.iter.hasNext();
                }

                @Override
                public T next() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    return this.iter.next();
                }

                @Override
                public void advance(long n) throws Exception {
                    N.checkArgNotNegative(n, "n");
                    if (!this.isInitialized) {
                        this.init();
                    }
                    this.iter.advance(n);
                }

                @Override
                public long count() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    return this.iter.count();
                }

                @Override
                public void close() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    this.iter.close();
                }

                private void init() throws Exception {
                    if (!this.isInitialized) {
                        this.isInitialized = true;
                        this.iter = (ExceptionalIterator)iteratorSupplier.get();
                    }
                }
            };
        }

        public static <T, E extends Exception> ExceptionalIterator<T, E> oF(final Throwables.Supplier<T[], E> arraySupplier) {
            N.checkArgNotNull(arraySupplier, "arraySupplier");
            return new ExceptionalIterator<T, E>(){
                private T[] a;
                private int len;
                private int position = 0;
                private boolean isInitialized = false;

                @Override
                public boolean hasNext() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    return this.position < this.len;
                }

                @Override
                public T next() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    if (this.position >= this.len) {
                        throw new NoSuchElementException();
                    }
                    return this.a[this.position++];
                }

                @Override
                public long count() throws Exception {
                    if (!this.isInitialized) {
                        this.init();
                    }
                    return this.len - this.position;
                }

                @Override
                public void advance(long n) throws Exception {
                    N.checkArgNotNegative(n, "n");
                    if (!this.isInitialized) {
                        this.init();
                    }
                    this.position = n > (long)(this.len - this.position) ? this.len : (int)((long)this.position + n);
                }

                private void init() throws Exception {
                    if (!this.isInitialized) {
                        this.isInitialized = true;
                        this.a = (Object[])arraySupplier.get();
                        this.len = N.len(this.a);
                    }
                }
            };
        }

        public abstract boolean hasNext() throws E;

        public abstract T next() throws E;

        public void advance(long n) throws E {
            N.checkArgNotNegative(n, "n");
            while (n-- > 0L && this.hasNext()) {
                this.next();
            }
        }

        public long count() throws E {
            long result = 0L;
            while (this.hasNext()) {
                this.next();
                ++result;
            }
            return result;
        }

        public void close() throws E {
        }
    }
}

