/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Immutable;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;

@com.landawn.abacus.annotation.Immutable
public final class ImmutableArray<T>
implements Immutable {
    private final T[] elements;
    public final int length;

    ImmutableArray(T[] elements) {
        this.elements = elements == null ? N.EMPTY_OBJECT_ARRAY : elements;
        this.length = N.len(this.elements);
    }

    public static <T> ImmutableArray<T> of(T[] elements) {
        return new ImmutableArray<T>(elements);
    }

    public static <T> ImmutableArray<T> copyOf(T[] elements) {
        return new ImmutableArray<T>(elements == null ? null : (Object[])elements.clone());
    }

    public T get(int index) {
        return this.elements[index];
    }

    public <E extends Exception> void forEach(Throwables.Consumer<T, E> consumer) throws E {
        N.checkArgNotNull(consumer, "consumer");
        for (int i = 0; i < this.length; ++i) {
            consumer.accept(this.elements[i]);
        }
    }

    public int hashCode() {
        return N.hashCode(this.elements);
    }

    public boolean equals(Object obj) {
        return obj instanceof ImmutableArray && N.equals(this.elements, ((ImmutableArray)obj).elements);
    }

    public String toString() {
        return N.toString(this.elements);
    }
}

