/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.N;
import java.util.Map;

public final class ImmutableBiMap<K, V>
extends ImmutableMap<K, V> {
    private static final ImmutableBiMap EMPTY = new ImmutableBiMap(new BiMap());
    private final BiMap<K, V> biMap;

    ImmutableBiMap(BiMap<? extends K, ? extends V> map) {
        super(map);
        this.biMap = map;
    }

    public static <K, V> ImmutableBiMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1) {
        BiMap<K, V> biMap = BiMap.of(k1, v1);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2) {
        BiMap<K, V> biMap = BiMap.of(k1, v1, k2, v2);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        BiMap<K, V> biMap = BiMap.of(k1, v1, k2, v2, k3, v3);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        BiMap<K, V> biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        BiMap<K, V> biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        BiMap<K, V> biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        BiMap<K, V> biMap = BiMap.of(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        return new ImmutableBiMap<K, V>(biMap);
    }

    public static <K, V> ImmutableBiMap<K, V> of(BiMap<? extends K, ? extends V> map) {
        if (map == null) {
            return ImmutableBiMap.empty();
        }
        return new ImmutableBiMap<K, V>(map);
    }

    public static <K, V> ImmutableBiMap<K, V> copyOf(BiMap<? extends K, ? extends V> map) {
        if (N.isNullOrEmpty(map)) {
            return ImmutableBiMap.empty();
        }
        return new ImmutableBiMap<K, V>(map.copy());
    }

    @Deprecated
    public static <K, V> ImmutableMap<K, V> of(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public K getByValue(Object value) {
        return this.biMap.getByValue(value);
    }
}

