/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableCollection;
import com.landawn.abacus.util.N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public final class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E> {
    private static final ImmutableList EMPTY = new ImmutableList(Collections.EMPTY_LIST);
    private final List<E> list;

    ImmutableList(List<? extends E> list) {
        super(Collections.unmodifiableList(list));
        this.list = (List)this.coll;
    }

    public static <E> ImmutableList<E> empty() {
        return EMPTY;
    }

    public static <E> ImmutableList<E> just(E e) {
        return new ImmutableList<E>(Collections.singletonList(e));
    }

    public static <E> ImmutableList<E> of(E e) {
        return new ImmutableList<E>(Collections.singletonList(e));
    }

    @SafeVarargs
    public static <E> ImmutableList<E> of(E ... a) {
        if (N.isNullOrEmpty(a)) {
            return ImmutableList.empty();
        }
        return new ImmutableList<E>(Arrays.asList(a));
    }

    public static <E> ImmutableList<E> of(List<? extends E> list) {
        if (list == null) {
            return ImmutableList.empty();
        }
        if (list instanceof ImmutableList) {
            return (ImmutableList)list;
        }
        return new ImmutableList<E>(list);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> copyOf(E ... a) {
        if (N.isNullOrEmpty(a)) {
            return ImmutableList.empty();
        }
        return new ImmutableList<E>(Arrays.asList(N.clone(a)));
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> list) {
        if (N.isNullOrEmpty(list)) {
            return ImmutableList.empty();
        }
        return new ImmutableList<E>(new ArrayList<E>(list));
    }

    @Deprecated
    public static <E> ImmutableCollection<E> of(Collection<? extends E> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    @Deprecated
    public final boolean addAll(int index, Collection<? extends E> newElements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E set(int index, E element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void add(int index, E element) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E remove(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

