/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Immutable;
import com.landawn.abacus.util.N;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

@com.landawn.abacus.annotation.Immutable
public class ImmutableMap<K, V>
extends AbstractMap<K, V>
implements Immutable {
    private static final ImmutableMap EMPTY = new ImmutableMap(Collections.EMPTY_MAP);
    private final Map<K, V> map;

    ImmutableMap(Map<? extends K, ? extends V> map) {
        this.map = Collections.unmodifiableMap(map);
    }

    public static <K, V> ImmutableMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        return new ImmutableMap<K, V>(Collections.singletonMap(k1, v1));
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        Map<K, V> map = N.asLinkedHashMap(k1, v1, k2, v2);
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        Map<K, V> map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3);
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        Map<K, V> map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4);
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        Map<K, V> map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5);
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        Map<K, V> map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6);
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        Map<K, V> map = N.asLinkedHashMap(k1, v1, k2, v2, k3, v3, k4, v4, k5, v5, k6, v6, k7, v7);
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> of(Map<? extends K, ? extends V> map) {
        if (map == null) {
            return ImmutableMap.empty();
        }
        if (map instanceof ImmutableMap) {
            return (ImmutableMap)map;
        }
        return new ImmutableMap<K, V>(map);
    }

    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        if (N.isNullOrEmpty(map)) {
            return ImmutableMap.empty();
        }
        AbstractMap tmp = map instanceof IdentityHashMap ? new IdentityHashMap<K, V>(map) : (map instanceof LinkedHashMap || map instanceof SortedMap ? new LinkedHashMap<K, V>(map) : new HashMap<K, V>(map));
        return new ImmutableMap<K, V>(tmp);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        V val = this.get(key);
        return val == null && !this.containsKey(key) ? defaultValue : val;
    }

    @Override
    @Deprecated
    public final V put(K k, V v) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> Builder<K, V> builder(Map<K, V> backedMap) {
        N.checkArgNotNull(backedMap);
        return new Builder<K, V>(backedMap);
    }

    public static class Builder<K, V> {
        private final Map<K, V> map;

        Builder() {
            this.map = new HashMap();
        }

        Builder(Map<K, V> backedMap) {
            this.map = backedMap;
        }

        public Builder<K, V> put(K key, V value) {
            this.map.put(key, value);
            return this;
        }

        public Builder<K, V> putAll(Map<? extends K, ? extends V> m) {
            this.map.putAll(m);
            return this;
        }

        public ImmutableMap<K, V> build() {
            return ImmutableMap.of(this.map);
        }
    }
}

