/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableNavigableSet;
import com.landawn.abacus.util.ImmutableSortedMap;
import com.landawn.abacus.util.N;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.TreeMap;

public class ImmutableNavigableMap<K, V>
extends ImmutableSortedMap<K, V>
implements NavigableMap<K, V> {
    private static final ImmutableNavigableMap EMPTY = new ImmutableNavigableMap(new TreeMap());
    private final NavigableMap<K, V> navigableMap;

    ImmutableNavigableMap(NavigableMap<? extends K, ? extends V> navigableMap) {
        super(navigableMap);
        this.navigableMap = navigableMap;
    }

    public static <K, V> ImmutableNavigableMap<K, V> empty() {
        return EMPTY;
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        return new ImmutableNavigableMap(map);
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1, K k2, V v2) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        return new ImmutableNavigableMap(map);
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return new ImmutableNavigableMap(map);
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return new ImmutableNavigableMap(map);
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return new ImmutableNavigableMap(map);
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return new ImmutableNavigableMap(map);
    }

    public static <K extends Comparable<? super K>, V> ImmutableNavigableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        TreeMap<K, V> map = N.newTreeMap();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return new ImmutableNavigableMap(map);
    }

    public static <K, V> ImmutableNavigableMap<K, V> of(NavigableMap<? extends K, ? extends V> navigableMap) {
        if (navigableMap == null) {
            return ImmutableNavigableMap.empty();
        }
        if (navigableMap instanceof ImmutableNavigableMap) {
            return (ImmutableNavigableMap)navigableMap;
        }
        return new ImmutableNavigableMap<K, V>(navigableMap);
    }

    public static <K, V> ImmutableNavigableMap<K, V> copyOf(SortedMap<? extends K, ? extends V> sortedMap) {
        if (N.isNullOrEmpty(sortedMap)) {
            return ImmutableNavigableMap.empty();
        }
        return new ImmutableNavigableMap<K, V>(new TreeMap<K, V>(sortedMap));
    }

    @Deprecated
    public static <K, V> ImmutableSortedMap<K, V> of(SortedMap<? extends K, ? extends V> sortedMap) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return this.navigableMap.lowerEntry(key);
    }

    @Override
    public K lowerKey(K key) {
        return this.navigableMap.lowerKey(key);
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return this.navigableMap.floorEntry(key);
    }

    @Override
    public K floorKey(K key) {
        return this.navigableMap.floorKey(key);
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return this.navigableMap.ceilingEntry(key);
    }

    @Override
    public K ceilingKey(K key) {
        return this.navigableMap.ceilingKey(key);
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return this.navigableMap.higherEntry(key);
    }

    @Override
    public K higherKey(K key) {
        return this.navigableMap.higherKey(key);
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.navigableMap.firstEntry();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.navigableMap.lastEntry();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.navigableMap.pollFirstEntry();
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.navigableMap.pollLastEntry();
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return ImmutableNavigableMap.of(this.navigableMap.descendingMap());
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return ImmutableNavigableSet.of(this.navigableMap.navigableKeySet());
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return ImmutableNavigableSet.of(this.navigableMap.descendingKeySet());
    }

    @Override
    public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        return ImmutableNavigableMap.of(this.navigableMap.subMap(fromKey, fromInclusive, toKey, toInclusive));
    }

    @Override
    public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return ImmutableNavigableMap.of(this.navigableMap.headMap(toKey, inclusive));
    }

    @Override
    public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return ImmutableNavigableMap.of(this.navigableMap.tailMap(fromKey, inclusive));
    }
}

