/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableCollection;
import com.landawn.abacus.util.N;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;

public class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private static final ImmutableSet EMPTY = new ImmutableSet(Collections.EMPTY_SET);

    ImmutableSet(Set<? extends E> set) {
        super(Collections.unmodifiableSet(set));
    }

    public static <E> ImmutableSet<E> empty() {
        return EMPTY;
    }

    public static <E> ImmutableSet<E> just(E e) {
        return new ImmutableSet<E>(Collections.singleton(e));
    }

    public static <E> ImmutableSet<E> of(E e) {
        return new ImmutableSet<E>(Collections.singleton(e));
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E ... a) {
        if (N.isNullOrEmpty(a)) {
            return ImmutableSet.empty();
        }
        return new ImmutableSet<E>(N.asLinkedHashSet(a));
    }

    public static <E> ImmutableSet<E> of(Set<? extends E> set) {
        if (set == null) {
            return ImmutableSet.empty();
        }
        if (set instanceof ImmutableSet) {
            return (ImmutableSet)set;
        }
        return new ImmutableSet<E>(set);
    }

    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> set) {
        if (N.isNullOrEmpty(set)) {
            return ImmutableSet.empty();
        }
        return new ImmutableSet<E>(set instanceof LinkedHashSet || set instanceof SortedSet ? N.newLinkedHashSet(set) : N.newHashSet(set));
    }

    @Deprecated
    public static <E> ImmutableCollection<E> of(Collection<? extends E> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

