/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableCollection;
import com.landawn.abacus.util.Index;
import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.KahanSummation;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.u;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class Iterables {
    private Iterables() {
    }

    @SafeVarargs
    public static u.OptionalChar min(char ... a) {
        return a == null || a.length == 0 ? u.OptionalChar.empty() : u.OptionalChar.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalByte min(byte ... a) {
        return a == null || a.length == 0 ? u.OptionalByte.empty() : u.OptionalByte.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalShort min(short ... a) {
        return a == null || a.length == 0 ? u.OptionalShort.empty() : u.OptionalShort.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalInt min(int ... a) {
        return a == null || a.length == 0 ? u.OptionalInt.empty() : u.OptionalInt.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalLong min(long ... a) {
        return a == null || a.length == 0 ? u.OptionalLong.empty() : u.OptionalLong.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalFloat min(float ... a) {
        return a == null || a.length == 0 ? u.OptionalFloat.empty() : u.OptionalFloat.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalDouble min(double ... a) {
        return a == null || a.length == 0 ? u.OptionalDouble.empty() : u.OptionalDouble.of(N.min(a));
    }

    @SafeVarargs
    public static u.OptionalChar max(char ... a) {
        return a == null || a.length == 0 ? u.OptionalChar.empty() : u.OptionalChar.of(N.max(a));
    }

    @SafeVarargs
    public static u.OptionalByte max(byte ... a) {
        return a == null || a.length == 0 ? u.OptionalByte.empty() : u.OptionalByte.of(N.max(a));
    }

    @SafeVarargs
    public static u.OptionalShort max(short ... a) {
        return a == null || a.length == 0 ? u.OptionalShort.empty() : u.OptionalShort.of(N.max(a));
    }

    @SafeVarargs
    public static u.OptionalInt max(int ... a) {
        return a == null || a.length == 0 ? u.OptionalInt.empty() : u.OptionalInt.of(N.max(a));
    }

    @SafeVarargs
    public static u.OptionalLong max(long ... a) {
        return a == null || a.length == 0 ? u.OptionalLong.empty() : u.OptionalLong.of(N.max(a));
    }

    @SafeVarargs
    public static u.OptionalFloat max(float ... a) {
        return a == null || a.length == 0 ? u.OptionalFloat.empty() : u.OptionalFloat.of(N.max(a));
    }

    @SafeVarargs
    public static u.OptionalDouble max(double ... a) {
        return a == null || a.length == 0 ? u.OptionalDouble.empty() : u.OptionalDouble.of(N.max(a));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> min(T[] a) {
        return N.isNullOrEmpty(a) ? u.Nullable.empty() : u.Nullable.of(N.min(a));
    }

    public static <T> u.Nullable<T> min(T[] a, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(a) ? u.Nullable.empty() : u.Nullable.of(N.min(a, cmp));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> min(Collection<? extends T> c) {
        return N.isNullOrEmpty(c) ? u.Nullable.empty() : u.Nullable.of(N.min(c));
    }

    public static <T> u.Nullable<T> min(Collection<? extends T> c, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(c) ? u.Nullable.empty() : u.Nullable.of(N.min(c, cmp));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> min(Iterator<? extends T> iter) {
        return Iterables.min(iter, N.NULL_MAX_COMPARATOR);
    }

    public static <T> u.Nullable<T> min(Iterator<? extends T> iter, Comparator<? super T> cmp) {
        Comparator<Object> comparator = cmp = cmp == null ? N.NULL_MAX_COMPARATOR : cmp;
        if (iter == null || !iter.hasNext()) {
            return u.Nullable.empty();
        }
        Object candidate = null;
        Object next = null;
        do {
            if ((next = (Object)iter.next()) == null && cmp == N.NULL_MIN_COMPARATOR) {
                return u.Nullable.of(next);
            }
            if (cmp.compare(next, candidate) >= 0) continue;
            candidate = next;
        } while (iter.hasNext());
        return u.Nullable.of(candidate);
    }

    public static <T> u.Nullable<T> minBy(T[] a, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.min(a, Fn.comparingBy(keyMapper));
    }

    public static <T> u.Nullable<T> minBy(Collection<? extends T> c, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.min(c, Fn.comparingBy(keyMapper));
    }

    public static <T> u.Nullable<T> minBy(Iterator<? extends T> iter, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.min(iter, Fn.comparingBy(keyMapper));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> max(T[] a) {
        return N.isNullOrEmpty(a) ? u.Nullable.empty() : u.Nullable.of(N.max(a));
    }

    public static <T> u.Nullable<T> max(T[] a, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(a) ? u.Nullable.empty() : u.Nullable.of(N.max(a, cmp));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> max(Collection<? extends T> c) {
        return N.isNullOrEmpty(c) ? u.Nullable.empty() : u.Nullable.of(N.max(c));
    }

    public static <T> u.Nullable<T> max(Collection<? extends T> c, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(c) ? u.Nullable.empty() : u.Nullable.of(N.max(c, cmp));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> max(Iterator<? extends T> iter) {
        return Iterables.max(iter, N.NULL_MIN_COMPARATOR);
    }

    public static <T> u.Nullable<T> max(Iterator<? extends T> iter, Comparator<? super T> cmp) {
        Comparator<Object> comparator = cmp = cmp == null ? N.NULL_MIN_COMPARATOR : cmp;
        if (iter == null || !iter.hasNext()) {
            return u.Nullable.empty();
        }
        Object candidate = null;
        Object next = null;
        do {
            if ((next = (Object)iter.next()) == null && cmp == N.NULL_MAX_COMPARATOR) {
                return u.Nullable.of(next);
            }
            if (cmp.compare(next, candidate) <= 0) continue;
            candidate = next;
        } while (iter.hasNext());
        return u.Nullable.of(candidate);
    }

    public static <T> u.Nullable<T> maxBy(T[] a, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.max(a, Fn.comparingBy(keyMapper));
    }

    public static <T> u.Nullable<T> maxBy(Collection<? extends T> c, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.max(c, Fn.comparingBy(keyMapper));
    }

    public static <T> u.Nullable<T> maxBy(Iterator<? extends T> iter, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.max(iter, Fn.comparingBy(keyMapper));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> median(T[] a) {
        return N.isNullOrEmpty(a) ? u.Nullable.empty() : u.Nullable.of(N.median(a));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> median(Collection<? extends T> c) {
        return N.isNullOrEmpty(c) ? u.Nullable.empty() : u.Nullable.of(N.median(c));
    }

    public static <T> u.Nullable<T> median(T[] a, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(a) ? u.Nullable.empty() : u.Nullable.of(N.median(a, cmp));
    }

    public static <T> u.Nullable<T> median(Collection<? extends T> c, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(c) ? u.Nullable.empty() : u.Nullable.of(N.median(c, cmp));
    }

    public static <T> u.Nullable<T> medianBy(T[] a, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.median(a, Fn.comparingBy(keyMapper));
    }

    public static <T> u.Nullable<T> medianBy(Collection<? extends T> c, Function<? super T, ? extends Comparable> keyMapper) {
        return Iterables.median(c, Fn.comparingBy(keyMapper));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> kthLargest(Collection<? extends T> c, int k) {
        return N.isNullOrEmpty(c) || c.size() < k ? u.Nullable.empty() : u.Nullable.of(N.kthLargest(c, k));
    }

    public static <T extends Comparable<? super T>> u.Nullable<T> kthLargest(T[] a, int k) {
        return N.isNullOrEmpty(a) || a.length < k ? u.Nullable.empty() : u.Nullable.of(N.kthLargest(a, (int)k));
    }

    public static <T> u.Nullable<T> kthLargest(Collection<? extends T> c, int k, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(c) || c.size() < k ? u.Nullable.empty() : u.Nullable.of(N.kthLargest(c, k, cmp));
    }

    public static <T> u.Nullable<T> kthLargest(T[] a, int k, Comparator<? super T> cmp) {
        return N.isNullOrEmpty(a) || a.length < k ? u.Nullable.empty() : u.Nullable.of(N.kthLargest(a, k, cmp));
    }

    public static <T extends Number> u.OptionalDouble averageInt(T[] a) {
        return Iterables.averageInt(a, Fn.numToInt());
    }

    public static <T extends Number> u.OptionalDouble averageInt(T[] a, int fromIndex, int toIndex) {
        return Iterables.averageInt(a, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(T[] a, Throwables.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalDouble.empty();
        }
        return Iterables.averageInt(a, 0, a.length, func);
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(T[] a, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumInt(a, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageInt(Collection<? extends T> c) {
        return Iterables.averageInt(c, Fn.numToInt());
    }

    public static <T extends Number> u.OptionalDouble averageInt(Collection<? extends T> c, int fromIndex, int toIndex) {
        return Iterables.averageInt(c, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(Collection<? extends T> c, Throwables.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumInt(c, func) / (double)c.size());
    }

    public static <T, E extends Exception> u.OptionalDouble averageInt(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumInt(c, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageLong(T[] a) {
        return Iterables.averageLong(a, Fn.numToLong());
    }

    public static <T extends Number> u.OptionalDouble averageLong(T[] a, int fromIndex, int toIndex) {
        return Iterables.averageLong(a, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(T[] a, Throwables.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalDouble.empty();
        }
        return Iterables.averageLong(a, 0, a.length, func);
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(T[] a, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumLong(a, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageLong(Collection<? extends T> c) {
        return Iterables.averageLong(c, Fn.numToLong());
    }

    public static <T extends Number> u.OptionalDouble averageLong(Collection<? extends T> c, int fromIndex, int toIndex) {
        return Iterables.averageLong(c, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(Collection<? extends T> c, Throwables.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumLong(c, func) / (double)c.size());
    }

    public static <T, E extends Exception> u.OptionalDouble averageLong(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        return u.OptionalDouble.of((double)N.sumLong(c, fromIndex, toIndex, func) / (double)(toIndex - fromIndex));
    }

    public static <T extends Number> u.OptionalDouble averageDouble(T[] a) {
        return Iterables.averageDouble(a, Fn.numToDouble());
    }

    public static <T extends Number> u.OptionalDouble averageDouble(T[] a, int fromIndex, int toIndex) {
        return Iterables.averageDouble(a, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(T[] a, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return u.OptionalDouble.empty();
        }
        return Iterables.averageDouble(a, 0, a.length, func);
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(T[] a, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(func.applyAsDouble(a[i]));
        }
        return summation.average();
    }

    public static <T extends Number> u.OptionalDouble averageDouble(Collection<? extends T> c) {
        return Iterables.averageDouble(c, Fn.numToDouble());
    }

    public static <T extends Number> u.OptionalDouble averageDouble(Collection<? extends T> c, int fromIndex, int toIndex) {
        return Iterables.averageDouble(c, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(Collection<? extends T> c, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return u.OptionalDouble.empty();
        }
        KahanSummation summation = new KahanSummation();
        for (T e : c) {
            summation.add(func.applyAsDouble(e));
        }
        return summation.average();
    }

    public static <T, E extends Exception> u.OptionalDouble averageDouble(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return u.OptionalDouble.empty();
        }
        KahanSummation summation = new KahanSummation();
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                summation.add(func.applyAsDouble(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                summation.add(func.applyAsDouble(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return summation.average();
    }

    public static u.OptionalInt indexOf(Object[] a, Object objToFind) {
        return Index.of(a, objToFind);
    }

    public static u.OptionalInt indexOf(Collection<?> c, Object objToFind) {
        return Index.of(c, objToFind);
    }

    public static u.OptionalInt lastIndexOf(Object[] a, Object objToFind) {
        return Index.last(a, objToFind);
    }

    public static u.OptionalInt lastIndexOf(Collection<?> c, Object objToFind) {
        return Index.last(c, objToFind);
    }

    public static <T> boolean padLeft(List<T> list, int minLen, T objToAdd) {
        N.checkArgNotNegative(minLen, "minLen");
        int size = N.size(list);
        if (size < minLen) {
            int elementCountToAdd = minLen - size;
            Object[] a = new Object[elementCountToAdd];
            if (objToAdd != null) {
                N.fill(a, objToAdd);
                list.addAll(0, Arrays.asList(a));
            }
            return true;
        }
        return false;
    }

    public static <T> boolean padRight(Collection<T> c, int minLen, T objToAdd) {
        N.checkArgNotNegative(minLen, "minLen");
        int size = N.size(c);
        if (size < minLen) {
            int elementCountToAdd = minLen - size;
            Object[] a = new Object[elementCountToAdd];
            if (objToAdd != null) {
                N.fill(a, objToAdd);
                c.addAll(Arrays.asList(a));
            }
            return true;
        }
        return false;
    }

    static final class Slice<T>
    extends ImmutableCollection<T> {
        private final int fromIndex;
        private final int toIndex;

        Slice(T[] a, int fromIndex, int toIndex) {
            this(Array.asList(a), fromIndex, toIndex);
        }

        Slice(Collection<? extends T> c, int fromIndex, int toIndex) {
            super(c);
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
        }

        @Override
        public boolean contains(Object o) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (!N.equals(iter.next(), o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public int size() {
            return this.toIndex - this.fromIndex;
        }

        @Override
        public ObjIterator<T> iterator() {
            if (this.coll == null || this.fromIndex == this.toIndex) {
                return ObjIterator.empty();
            }
            Iterator iter = this.coll.iterator();
            if (this.fromIndex == 0 && this.toIndex == this.coll.size()) {
                return ObjIterator.of(iter);
            }
            if (this.fromIndex == 0) {
                return Iterators.limit(iter, this.toIndex - this.fromIndex);
            }
            if (this.toIndex == this.coll.size()) {
                return Iterators.skip(iter, this.fromIndex);
            }
            return Iterators.skipAndLimit(iter, this.fromIndex, this.toIndex - this.fromIndex);
        }

        @Override
        public Object[] toArray() {
            Iterator iter = this.iterator();
            Object[] a = new Object[this.size()];
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                a[i] = iter.next();
            }
            return a;
        }

        @Override
        public <A> A[] toArray(A[] a) {
            if (a.length < this.size()) {
                a = N.copyOf(a, this.size());
            }
            Iterator iter = this.iterator();
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                a[i] = iter.next();
            }
            return a;
        }
    }
}

