/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.BiIterator;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.MergeResult;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.BiConsumer;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.Predicate;
import com.landawn.abacus.util.function.TriFunction;
import com.landawn.abacus.util.u;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Iterators {
    private Iterators() {
    }

    public static <T> u.Nullable<T> get(Iterator<? extends T> iter, long index) {
        N.checkArgNotNegative(index, "index");
        if (iter == null) {
            return u.Nullable.empty();
        }
        while (iter.hasNext()) {
            if (index-- == 0L) {
                return u.Nullable.of(iter.next());
            }
            iter.next();
        }
        return u.Nullable.empty();
    }

    public static long count(Iterator<?> iter) {
        if (iter == null) {
            return 0L;
        }
        long res = 0L;
        while (iter.hasNext()) {
            iter.next();
            ++res;
        }
        return res;
    }

    public static <T, E extends Exception> long count(Iterator<? extends T> iter, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return 0L;
        }
        long res = 0L;
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            ++res;
        }
        return res;
    }

    public static <T> ObjIterator<T> repeat(final T e, final int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: %s", n);
        if (n == 0) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private int cnt;
            {
                this.cnt = n;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0;
            }

            @Override
            public T next() {
                if (this.cnt <= 0) {
                    throw new NoSuchElementException();
                }
                --this.cnt;
                return e;
            }
        };
    }

    public static <T> ObjIterator<T> repeatEach(final Collection<? extends T> c, final int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: %s", n);
        if (n == 0 || N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private Iterator<? extends T> iter;
            private T next;
            private int cnt;
            {
                this.iter = c.iterator();
                this.next = null;
                this.cnt = 0;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0 || this.iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.cnt <= 0) {
                    this.next = this.iter.next();
                    this.cnt = n;
                }
                --this.cnt;
                return this.next;
            }
        };
    }

    public static <T> ObjIterator<T> repeatAll(final Collection<? extends T> c, final int n) {
        N.checkArgument(n >= 0, "'n' can't be negative: %s", n);
        if (n == 0 || N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private Iterator<? extends T> iter = null;
            private int cnt = n;

            @Override
            public boolean hasNext() {
                return this.cnt > 0 || this.iter != null && this.iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null || !this.iter.hasNext()) {
                    this.iter = c.iterator();
                    --this.cnt;
                }
                return this.iter.next();
            }
        };
    }

    public static <T> ObjIterator<T> repeatEachToSize(final Collection<? extends T> c, final int size) {
        N.checkArgument(size >= 0, "'size' can't be negative: %s", size);
        N.checkArgument(size == 0 || N.notNullOrEmpty(c), "Collection can't be empty or null when size > 0");
        if (N.isNullOrEmpty(c) || size == 0) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final int n;
            private int mod;
            private Iterator<? extends T> iter;
            private T next;
            private int cnt;
            {
                this.n = size / c.size();
                this.mod = size % c.size();
                this.iter = null;
                this.next = null;
                this.cnt = this.mod-- > 0 ? this.n + 1 : this.n;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0 || (this.n > 0 || this.mod > 0) && this.iter != null && this.iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null) {
                    this.iter = c.iterator();
                    this.next = this.iter.next();
                } else if (this.cnt <= 0) {
                    this.next = this.iter.next();
                    this.cnt = this.mod-- > 0 ? this.n + 1 : this.n;
                }
                --this.cnt;
                return this.next;
            }
        };
    }

    public static <T> ObjIterator<T> repeatAllToSize(final Collection<? extends T> c, final int size) {
        N.checkArgument(size >= 0, "'size' can't be negative: %s", size);
        N.checkArgument(size == 0 || N.notNullOrEmpty(c), "Collection can't be empty or null when size > 0");
        if (N.isNullOrEmpty(c) || size == 0) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private Iterator<? extends T> iter = null;
            private int cnt = size;

            @Override
            public boolean hasNext() {
                return this.cnt > 0;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.iter == null || !this.iter.hasNext()) {
                    this.iter = c.iterator();
                }
                --this.cnt;
                return this.iter.next();
            }
        };
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(T[] ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        ArrayList<ObjIterator<Object>> list = new ArrayList<ObjIterator<Object>>(a.length);
        for (Object[] objectArray : a) {
            if (!N.notNullOrEmpty(objectArray)) continue;
            list.add(ObjIterator.of(objectArray));
        }
        return Iterators.concat(list);
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(Collection<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        ArrayList<Iterator<? extends T>> list = new ArrayList<Iterator<? extends T>>(a.length);
        for (Collection<T> collection : a) {
            if (!N.notNullOrEmpty(collection)) continue;
            list.add(collection.iterator());
        }
        return Iterators.concat(list);
    }

    @SafeVarargs
    public static <K, V> ObjIterator<Map.Entry<K, V>> concat(Map<? extends K, ? extends V> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        ArrayList<Iterator<Map.Entry<? extends K, ? extends V>>> list = new ArrayList<Iterator<Map.Entry<? extends K, ? extends V>>>(a.length);
        for (Map<K, V> map : a) {
            if (!N.notNullOrEmpty(map)) continue;
            list.add(map.entrySet().iterator());
        }
        return Iterators.concat(list);
    }

    public static <T> ObjIterator<T> concatt(final Collection<? extends Collection<? extends T>> c) {
        if (N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final Iterator<? extends Collection<? extends T>> iter;
            private Iterator<? extends T> cur;
            {
                this.iter = c.iterator();
            }

            @Override
            public boolean hasNext() {
                while ((this.cur == null || !this.cur.hasNext()) && this.iter.hasNext()) {
                    Collection c2 = this.iter.next();
                    this.cur = N.isNullOrEmpty(c2) ? null : c2.iterator();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public T next() {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        };
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(Iterator<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return ObjIterator.empty();
        }
        return Iterators.concat(Array.asList(a));
    }

    public static <T> ObjIterator<T> concat(final Collection<? extends Iterator<? extends T>> c) {
        if (N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final Iterator<? extends Iterator<? extends T>> iter;
            private Iterator<? extends T> cur;
            {
                this.iter = c.iterator();
            }

            @Override
            public boolean hasNext() {
                while ((this.cur == null || !this.cur.hasNext()) && this.iter.hasNext()) {
                    this.cur = this.iter.next();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public T next() {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        };
    }

    @SafeVarargs
    public static <A, B> BiIterator<A, B> concat(final BiIterator<A, B> ... a) {
        if (N.isNullOrEmpty(a)) {
            return BiIterator.empty();
        }
        return new BiIterator<A, B>(){
            private final Iterator<BiIterator<A, B>> iter;
            private BiIterator<A, B> cur;
            {
                this.iter = Arrays.asList(a).iterator();
            }

            @Override
            public boolean hasNext() {
                while ((this.cur == null || !this.cur.hasNext()) && this.iter.hasNext()) {
                    this.cur = this.iter.next();
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public Pair<A, B> next() {
                if (!(this.cur != null && this.cur.hasNext() || this.hasNext())) {
                    throw new NoSuchElementException();
                }
                return (Pair)this.cur.next();
            }

            @Override
            public <E extends Exception> void forEachRemaining(Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
                while (this.hasNext()) {
                    this.cur.forEachRemaining(action);
                }
            }

            @Override
            public <R> ObjIterator<R> map(final BiFunction<? super A, ? super B, R> mapper) {
                N.checkArgNotNull(mapper);
                return new ObjIterator<R>(){
                    private ObjIterator<R> mappedIter = null;

                    @Override
                    public boolean hasNext() {
                        if (this.mappedIter == null || !this.mappedIter.hasNext()) {
                            while ((cur == null || !cur.hasNext()) && iter.hasNext()) {
                                cur = (BiIterator)iter.next();
                            }
                            if (cur != null) {
                                this.mappedIter = cur.map(mapper);
                            }
                        }
                        return this.mappedIter != null && this.mappedIter.hasNext();
                    }

                    @Override
                    public R next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        return this.mappedIter.next();
                    }
                };
            }
        };
    }

    public static <T> ObjIterator<T> merge(Collection<? extends T> a, Collection<? extends T> b, BiFunction<? super T, ? super T, MergeResult> nextSelector) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.merge(iterA, iterB, nextSelector);
    }

    public static <T> ObjIterator<T> merge(final Iterator<? extends T> a, final Iterator<? extends T> b, final BiFunction<? super T, ? super T, MergeResult> nextSelector) {
        N.checkArgNotNull(nextSelector);
        return new ObjIterator<T>(){
            private final Iterator<? extends T> iterA;
            private final Iterator<? extends T> iterB;
            private T nextA;
            private T nextB;
            private boolean hasNextA;
            private boolean hasNextB;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
                this.nextA = null;
                this.nextB = null;
                this.hasNextA = false;
                this.hasNextB = false;
            }

            @Override
            public boolean hasNext() {
                return this.hasNextA || this.hasNextB || this.iterA.hasNext() || this.iterB.hasNext();
            }

            @Override
            public T next() {
                if (this.hasNextA) {
                    if (this.iterB.hasNext()) {
                        this.nextB = this.iterB.next();
                        if (nextSelector.apply(this.nextA, this.nextB) == MergeResult.TAKE_FIRST) {
                            this.hasNextA = false;
                            this.hasNextB = true;
                            return this.nextA;
                        }
                        return this.nextB;
                    }
                    this.hasNextA = false;
                    return this.nextA;
                }
                if (this.hasNextB) {
                    if (this.iterA.hasNext()) {
                        this.nextA = this.iterA.next();
                        if (nextSelector.apply(this.nextA, this.nextB) == MergeResult.TAKE_FIRST) {
                            return this.nextA;
                        }
                        this.hasNextA = true;
                        this.hasNextB = false;
                        return this.nextB;
                    }
                    this.hasNextB = false;
                    return this.nextB;
                }
                if (this.iterA.hasNext()) {
                    if (this.iterB.hasNext()) {
                        this.nextA = this.iterA.next();
                        if (nextSelector.apply(this.nextA, this.nextB = this.iterB.next()) == MergeResult.TAKE_FIRST) {
                            this.hasNextB = true;
                            return this.nextA;
                        }
                        this.hasNextA = true;
                        return this.nextB;
                    }
                    return this.iterA.next();
                }
                return this.iterB.next();
            }
        };
    }

    public static <T> ObjIterator<T> merge(List<? extends Collection<? extends T>> c, BiFunction<? super T, ? super T, MergeResult> nextSelector) {
        return Iterators.mergge(c, nextSelector);
    }

    public static <T> ObjIterator<T> mergge(Collection<? extends Collection<? extends T>> c, BiFunction<? super T, ? super T, MergeResult> nextSelector) {
        N.checkArgNotNull(nextSelector);
        if (N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        if (c.size() == 1) {
            return ObjIterator.of(c.iterator().next());
        }
        if (c.size() == 2) {
            Iterator<Collection<T>> iter = c.iterator();
            return Iterators.merge(iter.next(), iter.next(), nextSelector);
        }
        ArrayList<Iterator<T>> iterList = new ArrayList<Iterator<T>>(c.size());
        for (Collection<T> collection : c) {
            iterList.add(N.iterate(collection));
        }
        return Iterators.merge(iterList, nextSelector);
    }

    public static <T> ObjIterator<T> merge(Collection<? extends Iterator<? extends T>> c, BiFunction<? super T, ? super T, MergeResult> nextSelector) {
        N.checkArgNotNull(nextSelector);
        if (N.isNullOrEmpty(c)) {
            return ObjIterator.empty();
        }
        if (c.size() == 1) {
            return ObjIterator.of(c.iterator().next());
        }
        if (c.size() == 2) {
            Iterator<Iterator<T>> iter = c.iterator();
            return Iterators.merge(iter.next(), iter.next(), nextSelector);
        }
        Iterator<Iterator<T>> iter = c.iterator();
        ObjIterator<? super T> result = Iterators.merge(iter.next(), iter.next(), nextSelector);
        while (iter.hasNext()) {
            result = Iterators.merge(result, iter.next(), nextSelector);
        }
        return result;
    }

    public static <T extends Comparable> ObjIterator<T> mergeSorted(Collection<? extends T> a, Collection<? extends T> b) {
        return Iterators.mergeSorted(a, b, Comparators.naturalOrder());
    }

    public static <T> ObjIterator<T> mergeSorted(Collection<? extends T> a, Collection<? extends T> b, Comparator<? super T> cmp) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.mergeSorted(iterA, iterB, cmp);
    }

    public static <T extends Comparable> ObjIterator<T> mergeSorted(Iterator<? extends T> a, Iterator<? extends T> b) {
        return Iterators.mergeSorted(a, b, Comparators.naturalOrder());
    }

    public static <T> ObjIterator<T> mergeSorted(Iterator<? extends T> a, Iterator<? extends T> b, Comparator<? super T> cmp) {
        N.checkArgNotNull(cmp);
        return Iterators.merge(a, b, MergeResult.minFirst(cmp));
    }

    public static <A, B, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, BiFunction<? super A, ? super B, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.zip(iterA, iterB, zipFunction);
    }

    public static <A, B, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final BiFunction<? super A, ? super B, R> zipFunction) {
        N.checkArgNotNull(zipFunction);
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() && this.iterB.hasNext();
            }

            @Override
            public R next() {
                return zipFunction.apply(this.iterA.next(), this.iterB.next());
            }
        };
    }

    public static <A, B, C, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = N.isNullOrEmpty(c) ? ObjIterator.empty() : c.iterator();
        return Iterators.zip(iterA, iterB, iterC, zipFunction);
    }

    public static <A, B, C, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final Iterator<C> c, final TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        N.checkArgNotNull(zipFunction);
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            private final Iterator<C> iterC;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
                this.iterC = c == null ? ObjIterator.empty() : c;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() && this.iterB.hasNext() && this.iterC.hasNext();
            }

            @Override
            public R next() {
                return zipFunction.apply(this.iterA.next(), this.iterB.next(), this.iterC.next());
            }
        };
    }

    public static <A, B, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB, BiFunction<? super A, ? super B, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        return Iterators.zip(iterA, iterB, valueForNoneA, valueForNoneB, zipFunction);
    }

    public static <A, B, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final A valueForNoneA, final B valueForNoneB, final BiFunction<? super A, ? super B, R> zipFunction) {
        N.checkArgNotNull(zipFunction);
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() || this.iterB.hasNext();
            }

            @Override
            public R next() {
                if (this.iterA.hasNext()) {
                    return zipFunction.apply(this.iterA.next(), this.iterB.hasNext() ? this.iterB.next() : valueForNoneB);
                }
                return zipFunction.apply(valueForNoneA, this.iterB.next());
            }
        };
    }

    public static <A, B, C, R> ObjIterator<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        Iterator<Object> iterA = N.isNullOrEmpty(a) ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = N.isNullOrEmpty(b) ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = N.isNullOrEmpty(c) ? ObjIterator.empty() : c.iterator();
        return Iterators.zip(iterA, iterB, iterC, valueForNoneA, valueForNoneB, valueForNoneC, zipFunction);
    }

    public static <A, B, C, R> ObjIterator<R> zip(final Iterator<A> a, final Iterator<B> b, final Iterator<C> c, final A valueForNoneA, final B valueForNoneB, final C valueForNoneC, final TriFunction<? super A, ? super B, ? super C, R> zipFunction) {
        return new ObjIterator<R>(){
            private final Iterator<A> iterA;
            private final Iterator<B> iterB;
            private final Iterator<C> iterC;
            {
                this.iterA = a == null ? ObjIterator.empty() : a;
                this.iterB = b == null ? ObjIterator.empty() : b;
                this.iterC = c == null ? ObjIterator.empty() : c;
            }

            @Override
            public boolean hasNext() {
                return this.iterA.hasNext() || this.iterB.hasNext() || this.iterC.hasNext();
            }

            @Override
            public R next() {
                if (this.iterA.hasNext()) {
                    return zipFunction.apply(this.iterA.next(), this.iterB.hasNext() ? this.iterB.next() : valueForNoneB, this.iterC.hasNext() ? this.iterC.next() : valueForNoneC);
                }
                if (this.iterB.hasNext()) {
                    return zipFunction.apply(valueForNoneA, this.iterB.next(), this.iterC.hasNext() ? this.iterC.next() : valueForNoneC);
                }
                return zipFunction.apply(valueForNoneA, valueForNoneB, this.iterC.next());
            }
        };
    }

    public static <T, L, R> BiIterator<L, R> unzip(Iterator<? extends T> iter, BiConsumer<? super T, Pair<L, R>> unzip) {
        return BiIterator.unzip(iter, unzip);
    }

    public static <T, L, R> BiIterator<L, R> unzip(Collection<? extends T> c, BiConsumer<? super T, Pair<L, R>> unzip) {
        return BiIterator.unzip(c == null ? ObjIterator.empty() : c.iterator(), unzip);
    }

    public static long advance(Iterator<?> iterator, long numberToAdvance) {
        long i;
        N.checkArgNotNegative(numberToAdvance, "numberToAdvance");
        for (i = 0L; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }

    public static <T> ObjIterator<T> skip(final Iterator<? extends T> iter, final long n) {
        N.checkArgNotNegative(n, "n");
        if (iter == null || n == 0L) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private boolean skipped = false;

            @Override
            public boolean hasNext() {
                if (!this.skipped) {
                    this.skip();
                }
                return iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return iter.next();
            }

            private void skip() {
                long idx = 0L;
                while (idx++ < n && iter.hasNext()) {
                    iter.next();
                }
                this.skipped = true;
            }
        };
    }

    public static <T> ObjIterator<T> limit(final Iterator<? extends T> iter, final long count) {
        N.checkArgNotNegative(count, "count");
        if (iter == null || count == 0L) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private long cnt;
            {
                this.cnt = count;
            }

            @Override
            public boolean hasNext() {
                return this.cnt > 0L && iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                --this.cnt;
                return iter.next();
            }
        };
    }

    public static <T> ObjIterator<T> skipAndLimit(final Iterator<? extends T> iter, final long offset, final long count) {
        N.checkArgNotNegative(count, "offset");
        N.checkArgNotNegative(count, "count");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private long cnt;
            private boolean skipped;
            {
                this.cnt = count;
                this.skipped = false;
            }

            @Override
            public boolean hasNext() {
                if (!this.skipped) {
                    this.skip();
                }
                return this.cnt > 0L && iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                --this.cnt;
                return iter.next();
            }

            private void skip() {
                long idx = 0L;
                while (idx++ < offset && iter.hasNext()) {
                    iter.next();
                }
                this.skipped = true;
            }
        };
    }

    public static <T> ObjIterator<T> skipNull(Iterator<? extends T> iter) {
        return Iterators.filter(iter, Fn.notNull());
    }

    public static <T> ObjIterator<T> distinct(final Iterator<? extends T> iter) {
        if (iter == null) {
            return ObjIterator.empty();
        }
        final HashSet set = new HashSet();
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private T tmp = null;

            @Override
            public boolean hasNext() {
                if (this.next == this.NONE) {
                    while (iter.hasNext()) {
                        this.tmp = iter.next();
                        if (!set.add(this.tmp)) continue;
                        this.next = this.tmp;
                        break;
                    }
                }
                return this.next != this.NONE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.tmp = this.next;
                this.next = this.NONE;
                return this.tmp;
            }
        };
    }

    public static <T> ObjIterator<T> distinctBy(final Iterator<? extends T> iter, final Function<? super T, ?> keyMapper) {
        if (iter == null) {
            return ObjIterator.empty();
        }
        final HashSet set = new HashSet();
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private T tmp = null;

            @Override
            public boolean hasNext() {
                if (this.next == this.NONE) {
                    while (iter.hasNext()) {
                        this.tmp = iter.next();
                        if (!set.add(keyMapper.apply(this.tmp))) continue;
                        this.next = this.tmp;
                        break;
                    }
                }
                return this.next != this.NONE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.tmp = this.next;
                this.next = this.NONE;
                return this.tmp;
            }
        };
    }

    public static <T> ObjIterator<T> filter(final Iterator<? extends T> iter, final Predicate<? super T> filter) {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private T tmp = null;

            @Override
            public boolean hasNext() {
                if (this.next == this.NONE) {
                    while (iter.hasNext()) {
                        this.tmp = iter.next();
                        if (!filter.test(this.tmp)) continue;
                        this.next = this.tmp;
                        break;
                    }
                }
                return this.next != this.NONE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.tmp = this.next;
                this.next = this.NONE;
                return this.tmp;
            }
        };
    }

    public static <T> ObjIterator<T> takeWhile(final Iterator<? extends T> iter, final Predicate<? super T> filter) {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private T tmp = null;
            private boolean hasMore = true;

            @Override
            public boolean hasNext() {
                if (this.next == this.NONE && this.hasMore && iter.hasNext()) {
                    this.tmp = iter.next();
                    if (filter.test(this.tmp)) {
                        this.next = this.tmp;
                    } else {
                        this.hasMore = false;
                    }
                }
                return this.next != this.NONE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.tmp = this.next;
                this.next = this.NONE;
                return this.tmp;
            }
        };
    }

    public static <T> ObjIterator<T> takeWhileInclusive(final Iterator<? extends T> iter, final Predicate<? super T> filter) {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private T tmp = null;
            private boolean hasMore = true;

            @Override
            public boolean hasNext() {
                if (this.next == this.NONE && this.hasMore && iter.hasNext()) {
                    this.tmp = iter.next();
                    if (filter.test(this.tmp)) {
                        this.next = this.tmp;
                    } else {
                        this.next = this.tmp;
                        this.hasMore = false;
                    }
                }
                return this.next != this.NONE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.tmp = this.next;
                this.next = this.NONE;
                return this.tmp;
            }
        };
    }

    public static <T> ObjIterator<T> dropWhile(final Iterator<? extends T> iter, final Predicate<? super T> filter) {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private boolean hasDropped = false;

            @Override
            public boolean hasNext() {
                if (!this.hasDropped) {
                    while (iter.hasNext()) {
                        this.next = iter.next();
                        if (filter.test(this.next)) {
                            this.next = this.NONE;
                            continue;
                        }
                        this.hasDropped = true;
                        break;
                    }
                }
                return this.next != this.NONE || iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.next != this.NONE) {
                    Object tmp = this.next;
                    this.next = this.NONE;
                    return tmp;
                }
                return iter.next();
            }
        };
    }

    public static <T> ObjIterator<T> skipUntil(final Iterator<? extends T> iter, final Predicate<? super T> filter) {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<T>(){
            private final T NONE = N.NULL_MASK;
            private T next = this.NONE;
            private boolean hasSkipped = false;

            @Override
            public boolean hasNext() {
                if (!this.hasSkipped) {
                    while (iter.hasNext()) {
                        this.next = iter.next();
                        if (filter.test(this.next)) {
                            this.hasSkipped = true;
                            break;
                        }
                        this.next = this.NONE;
                    }
                }
                return this.next != this.NONE || iter.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.next != this.NONE) {
                    Object tmp = this.next;
                    this.next = this.NONE;
                    return tmp;
                }
                return iter.next();
            }
        };
    }

    public static <T, U> ObjIterator<U> map(final Iterator<? extends T> iter, final Function<? super T, U> mapper) {
        N.checkArgNotNull(mapper, "mapper");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<U>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(iter.next());
            }
        };
    }

    public static <T, U> ObjIterator<U> flatMap(final Iterator<? extends T> iter, final Function<? super T, ? extends Collection<? extends U>> mapper) {
        N.checkArgNotNull(mapper, "mapper");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<U>(){
            private Collection<? extends U> c = null;
            private Iterator<? extends U> cur = null;

            @Override
            public boolean hasNext() {
                if (this.cur == null || !this.cur.hasNext()) {
                    while (iter.hasNext()) {
                        this.c = (Collection)mapper.apply(iter.next());
                        Iterator<Object> iterator = this.cur = this.c == null || this.c.size() == 0 ? null : this.c.iterator();
                        if (this.cur == null || !this.cur.hasNext()) continue;
                    }
                }
                return this.cur != null && this.cur.hasNext();
            }

            @Override
            public U next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.cur.next();
            }
        };
    }

    public static <T, U> ObjIterator<U> flattMap(final Iterator<? extends T> iter, final Function<? super T, ? extends U[]> mapper) {
        N.checkArgNotNull(mapper, "mapper");
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<U>(){
            private U[] a = null;
            private int len = 0;
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                if (this.cursor >= this.len) {
                    while (iter.hasNext()) {
                        this.a = (Object[])mapper.apply(iter.next());
                        this.len = N.len(this.a);
                        this.cursor = 0;
                        if (this.len <= 0) continue;
                    }
                }
                return this.cursor < this.len;
            }

            @Override
            public U next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.a[this.cursor++];
            }
        };
    }

    public static <T, U> ObjIterator<T> generate(final U init, final Predicate<? super U> hasNext, final Function<? super U, T> supplier) {
        N.checkArgNotNull(hasNext);
        N.checkArgNotNull(supplier);
        return new ObjIterator<T>(){

            @Override
            public boolean hasNext() {
                return hasNext.test(init);
            }

            @Override
            public T next() {
                return supplier.apply(init);
            }
        };
    }

    public static <T, U> ObjIterator<T> generate(final U init, final BiPredicate<? super U, T> hasNext, final BiFunction<? super U, T, T> supplier) {
        N.checkArgNotNull(hasNext);
        N.checkArgNotNull(supplier);
        return new ObjIterator<T>(){
            private T prev = null;

            @Override
            public boolean hasNext() {
                return hasNext.test(init, this.prev);
            }

            @Override
            public T next() {
                this.prev = supplier.apply(init, this.prev);
                return this.prev;
            }
        };
    }
}

