/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.Supplier;

public final class LazyInitializer<T>
implements Supplier<T> {
    private volatile boolean initialized = false;
    private volatile T value = null;
    private final Supplier<T> supplier;

    LazyInitializer(Supplier<T> supplier) {
        N.checkArgNotNull(supplier, "supplier");
        this.supplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T get() {
        if (!this.initialized) {
            LazyInitializer lazyInitializer = this;
            synchronized (lazyInitializer) {
                if (!this.initialized) {
                    this.value = this.supplier.get();
                    this.initialized = true;
                }
            }
        }
        return this.value;
    }

    public static <T> LazyInitializer<T> of(Supplier<T> supplier) {
        N.checkArgNotNull(supplier);
        if (supplier instanceof LazyInitializer) {
            return (LazyInitializer)supplier;
        }
        return new LazyInitializer<T>(supplier);
    }
}

