/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.exception.UncheckedIOException;
import com.landawn.abacus.util.Charsets;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.ImmutableIterator;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;

public final class LineIterator
extends ImmutableIterator<String>
implements Closeable {
    private final BufferedReader bufferedReader;
    private String cachedLine;
    private boolean finished = false;
    private boolean isClosed = false;

    public LineIterator(Reader reader) throws IllegalArgumentException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader must not be null");
        }
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static LineIterator of(File file) {
        return LineIterator.of(file, Charsets.UTF_8);
    }

    public static LineIterator of(File file, Charset encoding) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            return LineIterator.of(in, encoding);
        }
        catch (IOException ex) {
            IOUtil.closeQuietly(in);
            throw new UncheckedIOException(ex);
        }
        catch (RuntimeException ex) {
            IOUtil.closeQuietly(in);
            throw ex;
        }
    }

    public static LineIterator of(InputStream input) {
        return LineIterator.of(input, Charsets.UTF_8);
    }

    public static LineIterator of(InputStream input, Charset encoding) throws UncheckedIOException {
        try {
            return new LineIterator(IOUtil.createReader(input, encoding));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LineIterator of(Reader reader) {
        return new LineIterator(reader);
    }

    @Override
    public boolean hasNext() {
        if (this.cachedLine != null) {
            return true;
        }
        if (this.finished) {
            return false;
        }
        try {
            this.cachedLine = this.bufferedReader.readLine();
            if (this.cachedLine == null) {
                this.finished = true;
                return false;
            }
            return true;
        }
        catch (IOException ioe) {
            this.close();
            throw new UncheckedIOException(ioe);
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more lines");
        }
        String res = this.cachedLine;
        this.cachedLine = null;
        return res;
    }

    public <E extends Exception> void foreachRemaining(Throwables.Consumer<? super String, E> action) throws E {
        N.checkArgNotNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    public <E extends Exception> void foreachIndexed(Throwables.IndexedConsumer<? super String, E> action) throws E {
        N.checkArgNotNull(action);
        int idx = 0;
        while (this.hasNext()) {
            action.accept(idx++, this.next());
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.finished = true;
        this.cachedLine = null;
        IOUtil.closeQuietly(this.bufferedReader);
    }
}

