/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.ImmutableEntry;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Splitter;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.u;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Maps {
    private Maps() {
    }

    public static <T, K, E extends Exception> Map<K, T> newMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends K, E> keyMapper) throws E {
        N.checkArgNotNull(keyMapper);
        if (N.isNullOrEmpty(c)) {
            return new HashMap();
        }
        Map<K, T> result = N.newHashMap(c.size());
        for (T e : c) {
            result.put(keyMapper.apply(e), e);
        }
        return result;
    }

    public static <T, K, V, E extends Exception, E2 extends Exception> Map<K, V> newMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends K, E> keyMapper, Throwables.Function<? super T, ? extends V, E2> valueExtractor) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (N.isNullOrEmpty(c)) {
            return new HashMap();
        }
        Map<K, V> result = N.newHashMap(c.size());
        for (T e : c) {
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return result;
    }

    public static <T, K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception> M newMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends K, E> keyMapper, Throwables.Function<? super T, ? extends V, E2> valueExtractor, IntFunction<? extends M> mapSupplier) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (N.isNullOrEmpty(c)) {
            return (M)((Map)mapSupplier.apply(0));
        }
        Map result = (Map)mapSupplier.apply(c.size());
        for (T e : c) {
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return (M)result;
    }

    public static <T, K, E extends Exception> Map<K, T> newMap(Iterator<? extends T> iter, Throwables.Function<? super T, K, E> keyMapper) throws E {
        N.checkArgNotNull(keyMapper);
        if (iter == null) {
            return new HashMap();
        }
        HashMap<K, Object> result = new HashMap<K, Object>();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            result.put(keyMapper.apply(e), e);
        }
        return result;
    }

    public static <T, K, V, E extends Exception, E2 extends Exception> Map<K, V> newMap(Iterator<? extends T> iter, Throwables.Function<? super T, K, E> keyMapper, Throwables.Function<? super T, ? extends V, E2> valueExtractor) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (iter == null) {
            return new HashMap();
        }
        HashMap<K, V> result = new HashMap<K, V>();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return result;
    }

    public static <T, K, V, M extends Map<K, V>, E extends Exception, E2 extends Exception> M newMap(Iterator<? extends T> iter, Throwables.Function<? super T, K, E> keyMapper, Throwables.Function<? super T, ? extends V, E2> valueExtractor, Supplier<? extends M> mapSupplier) throws E, E2 {
        N.checkArgNotNull(keyMapper);
        N.checkArgNotNull(valueExtractor);
        if (iter == null) {
            return (M)((Map)mapSupplier.get());
        }
        Map result = (Map)mapSupplier.get();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            result.put(keyMapper.apply(e), valueExtractor.apply(e));
        }
        return (M)result;
    }

    static Map newTargetMap(Map<?, ?> m) {
        return Maps.newTargetMap(m, m == null ? 0 : m.size());
    }

    static Map newTargetMap(Map<?, ?> m, int size) {
        if (m == null) {
            return new HashMap();
        }
        Map res = null;
        if (HashMap.class.equals(m.getClass())) {
            res = N.newHashMap(size);
        } else if (m instanceof SortedMap) {
            res = new TreeMap(((SortedMap)m).comparator());
        } else if (m instanceof IdentityHashMap) {
            res = N.newIdentityHashMap(size);
        } else if (m instanceof LinkedHashMap) {
            res = N.newLinkedHashMap(size);
        } else if (m instanceof ImmutableMap) {
            res = N.newLinkedHashMap(size);
        } else {
            try {
                res = (Map)N.newInstance(m.getClass());
            }
            catch (Exception e) {
                res = N.newLinkedHashMap(size);
            }
        }
        return res;
    }

    static Map newOrderingMap(Map<?, ?> m) {
        if (m == null) {
            return new HashMap();
        }
        Map res = null;
        if (HashMap.class.equals(m.getClass())) {
            res = N.newHashMap(m.size());
        } else if (m instanceof SortedMap) {
            res = N.newLinkedHashMap(m.size());
        } else if (m instanceof IdentityHashMap) {
            res = N.newIdentityHashMap(m.size());
        } else if (m instanceof LinkedHashMap) {
            res = N.newLinkedHashMap(m.size());
        } else if (m instanceof ImmutableMap) {
            res = N.newLinkedHashMap(m.size());
        } else {
            try {
                res = (Map)N.newInstance(m.getClass());
            }
            catch (Exception e) {
                res = N.newLinkedHashMap(m.size());
            }
        }
        return res;
    }

    @Deprecated
    public static <K, V> Map.Entry<K, V> newEntry(K key, V value) {
        return N.newEntry(key, value);
    }

    @Deprecated
    public static <K, V> ImmutableEntry<K, V> newImmutableEntry(K key, V value) {
        return N.newImmutableEntry(key, value);
    }

    public static <K, V> Map<K, V> zip(Collection<? extends K> keys, Collection<? extends V> values) {
        if (N.isNullOrEmpty(keys) || N.isNullOrEmpty(values)) {
            return new HashMap();
        }
        Iterator<K> keyIter = keys.iterator();
        Iterator<V> valueIter = values.iterator();
        int minLen = N.min(keys.size(), values.size());
        Map<K, V> result = N.newHashMap(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.put(keyIter.next(), valueIter.next());
        }
        return result;
    }

    public static <K, V, M extends Map<K, V>> Map<K, V> zip(Collection<? extends K> keys, Collection<? extends V> values, IntFunction<? extends M> mapSupplier) {
        if (N.isNullOrEmpty(keys) || N.isNullOrEmpty(values)) {
            return new HashMap();
        }
        Iterator<K> keyIter = keys.iterator();
        Iterator<V> valueIter = values.iterator();
        int minLen = N.min(keys.size(), values.size());
        Map result = (Map)mapSupplier.apply(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.put(keyIter.next(), valueIter.next());
        }
        return result;
    }

    public static <K, V> u.Nullable<V> get(Map<K, ? extends V> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return u.Nullable.empty();
        }
        V val = map.get(key);
        if (val != null || map.containsKey(key)) {
            return u.Nullable.of(val);
        }
        return u.Nullable.empty();
    }

    public static <K, V> List<V> getIfPresentForEach(Map<K, ? extends V> map, Collection<?> keys) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(keys)) {
            return new ArrayList(0);
        }
        ArrayList<Object> result = new ArrayList<Object>(keys.size());
        Object val = null;
        for (Object key : keys) {
            val = map.get(key);
            if (val == null && !map.containsKey(key)) continue;
            result.add(val);
        }
        return result;
    }

    public static <K, V> V getOrDefault(Map<K, ? extends V> map, Object key, V defaultValue) {
        if (N.isNullOrEmpty(map)) {
            return defaultValue;
        }
        V val = map.get(key);
        if (val != null || map.containsKey(key)) {
            return val;
        }
        return defaultValue;
    }

    public static <K, V> V getOrDefaultIfNull(Map<K, ? extends V> map, Object key, V defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        V val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        return val;
    }

    public static <K> Boolean getBoolean(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return N.parseBoolean(N.toString(val));
    }

    public static <K> boolean getBoolean(Map<? super K, ?> map, Object key, boolean defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return N.parseBoolean(N.toString(val));
    }

    public static <K> Character getChar(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Character) {
            return (Character)val;
        }
        return Character.valueOf(N.parseChar(N.toString(val)));
    }

    public static <K> char getChar(Map<? super K, ?> map, Object key, char defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        return N.parseChar(N.toString(val));
    }

    public static <K> Byte getByte(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return Numbers.toByte(N.toString(val));
    }

    public static <K> byte getByte(Map<? super K, ?> map, Object key, byte defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return Numbers.toByte(N.toString(val));
    }

    public static <K> Short getShort(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        return Numbers.toShort(N.toString(val));
    }

    public static <K> short getShort(Map<? super K, ?> map, Object key, short defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        return Numbers.toShort(N.toString(val));
    }

    public static <K> Integer getInt(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return Numbers.toInt(N.toString(val));
    }

    public static <K> int getInt(Map<? super K, ?> map, Object key, int defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        return Numbers.toInt(N.toString(val));
    }

    public static <K> Long getLong(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return Numbers.toLong(N.toString(val));
    }

    public static <K> long getLong(Map<? super K, ?> map, Object key, long defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return Numbers.toLong(N.toString(val));
    }

    public static <K> Float getFloat(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        return Float.valueOf(Numbers.toFloat(N.toString(val)));
    }

    public static <K> float getFloat(Map<? super K, ?> map, Object key, float defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        return Numbers.toFloat(N.toString(val));
    }

    public static <K> Double getDouble(Map<? super K, ?> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        Object val = map.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return Numbers.toDouble(N.toString(val));
    }

    public static <K> double getDouble(Map<? super K, ?> map, Object key, double defaultForNull) {
        if (N.isNullOrEmpty(map)) {
            return defaultForNull;
        }
        Object val = map.get(key);
        if (val == null) {
            return defaultForNull;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        return Numbers.toDouble(N.toString(val));
    }

    public static <K, E, V extends List<E>> List<E> getOrEmptyList(Map<K, V> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return N.emptyList();
        }
        List val = (List)map.get(key);
        if (val != null || map.containsKey(key)) {
            return val;
        }
        return N.emptyList();
    }

    public static <K, E, V extends Set<E>> Set<E> getOrEmptySet(Map<K, V> map, Object key) {
        if (N.isNullOrEmpty(map)) {
            return N.emptySet();
        }
        Set val = (Set)map.get(key);
        if (val != null || map.containsKey(key)) {
            return val;
        }
        return N.emptySet();
    }

    public static <K, V> List<V> getOrDefaultForEach(Map<K, V> map, Collection<?> keys, V defaultValue) {
        if (N.isNullOrEmpty(keys)) {
            return new ArrayList(0);
        }
        if (N.isNullOrEmpty(map)) {
            return N.repeat(defaultValue, keys.size());
        }
        ArrayList<V> result = new ArrayList<V>(keys.size());
        Object val = null;
        for (Object key : keys) {
            val = map.get(key);
            if (val != null || map.containsKey(key)) {
                result.add(val);
                continue;
            }
            result.add(defaultValue);
        }
        return result;
    }

    public static <K, E> List<E> getAndPutListIfAbsent(Map<K, List<E>> map, K key) {
        List<E> v = map.get(key);
        if (v == null) {
            v = new ArrayList();
            v = map.put(key, v);
        }
        return v;
    }

    public static <K, E> Set<E> getAndPutSetIfAbsent(Map<K, Set<E>> map, K key) {
        Set<Object> v = map.get(key);
        if (v == null) {
            v = N.newHashSet();
            v = map.put(key, v);
        }
        return v;
    }

    public static <K, E> Set<E> getAndPutLinkedHashSetIfAbsent(Map<K, Set<E>> map, K key) {
        Set<Object> v = map.get(key);
        if (v == null) {
            v = N.newLinkedHashSet();
            v = map.put(key, v);
        }
        return v;
    }

    public static <K, KK, VV> Map<KK, VV> getAndPutMapIfAbsent(Map<K, Map<KK, VV>> map, K key) {
        Map<KK, VV> v = map.get(key);
        if (v == null) {
            v = new HashMap<KK, VV>();
            v = map.put(key, v);
        }
        return v;
    }

    public static boolean contains(Map<?, ?> map, Map.Entry<?, ?> entry) {
        return Maps.contains(map, entry.getKey(), entry.getValue());
    }

    public static boolean contains(Map<?, ?> map, Object key, Object value) {
        if (N.isNullOrEmpty(map)) {
            return false;
        }
        Object val = map.get(key);
        return val == null ? value == null && map.containsKey(key) : N.equals(val, value);
    }

    public static <K, V> Map<K, V> intersection(Map<K, V> map, Map<? extends K, ? extends V> map2) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(map2)) {
            return new LinkedHashMap();
        }
        AbstractMap result = map instanceof IdentityHashMap ? new IdentityHashMap() : new LinkedHashMap();
        Object val = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            val = map2.get(entry.getKey());
            if ((val == null || !N.equals(val, entry.getValue())) && (entry.getValue() != null || !map.containsKey(entry.getKey()))) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<K, Pair<V, u.Nullable<V>>> difference(Map<K, V> map, Map<K, V> map2) {
        AbstractMap result;
        if (N.isNullOrEmpty(map)) {
            return new LinkedHashMap();
        }
        AbstractMap abstractMap = result = map instanceof IdentityHashMap ? new IdentityHashMap() : new LinkedHashMap();
        if (N.isNullOrEmpty(map2)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                result.put(entry.getKey(), Pair.of(entry.getValue(), u.Nullable.empty()));
            }
        } else {
            Object val = null;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                val = map2.get(entry.getKey());
                if (val == null && !map2.containsKey(entry.getKey())) {
                    result.put(entry.getKey(), Pair.of(entry.getValue(), u.Nullable.empty()));
                    continue;
                }
                if (N.equals(val, entry.getValue())) continue;
                result.put(entry.getKey(), Pair.of(entry.getValue(), u.Nullable.of(val)));
            }
        }
        return result;
    }

    public static <K, V> Map<K, Pair<u.Nullable<V>, u.Nullable<V>>> symmetricDifference(Map<K, V> map, Map<K, V> map2) {
        AbstractMap result;
        block10: {
            boolean isIdentityHashMap = N.notNullOrEmpty(map) && map instanceof IdentityHashMap || N.notNullOrEmpty(map2) && map2 instanceof IdentityHashMap;
            AbstractMap abstractMap = result = isIdentityHashMap ? new IdentityHashMap() : new LinkedHashMap();
            if (N.notNullOrEmpty(map)) {
                if (N.isNullOrEmpty(map2)) {
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        result.put(entry.getKey(), Pair.of(u.Nullable.of(entry.getValue()), u.Nullable.empty()));
                    }
                } else {
                    Object key = null;
                    Object val2 = null;
                    for (Map.Entry<K, V> entry : map.entrySet()) {
                        key = entry.getKey();
                        val2 = map2.get(key);
                        if (val2 == null && !map2.containsKey(key)) {
                            result.put(key, Pair.of(u.Nullable.of(entry.getValue()), u.Nullable.empty()));
                            continue;
                        }
                        if (N.equals(val2, entry.getValue())) continue;
                        result.put(key, Pair.of(u.Nullable.of(entry.getValue()), u.Nullable.of(val2)));
                    }
                }
            }
            if (!N.notNullOrEmpty(map2)) break block10;
            if (N.isNullOrEmpty(map)) {
                for (Map.Entry<K, V> entry : map2.entrySet()) {
                    result.put(entry.getKey(), Pair.of(u.Nullable.empty(), u.Nullable.of(entry.getValue())));
                }
            } else {
                for (Map.Entry<K, V> entry : map2.entrySet()) {
                    if (map.containsKey(entry.getKey())) continue;
                    result.put(entry.getKey(), Pair.of(u.Nullable.empty(), u.Nullable.of(entry.getValue())));
                }
            }
        }
        return result;
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, V value) {
        V v = map.get(key);
        if (v == null) {
            v = map.put(key, value);
        }
        return v;
    }

    public static <K, V> V putIfAbsent(Map<K, V> map, K key, Supplier<V> supplier) {
        V v = map.get(key);
        if (v == null) {
            v = map.put(key, supplier.get());
        }
        return v;
    }

    public static <K, V> boolean remove(Map<K, V> map, Map.Entry<?, ?> entry) {
        return Maps.remove(map, entry.getKey(), entry.getValue());
    }

    public static <K, V> boolean remove(Map<K, V> map, Object key, Object value) {
        if (N.isNullOrEmpty(map)) {
            return false;
        }
        V curValue = map.get(key);
        if (!N.equals(curValue, value) || curValue == null && !map.containsKey(key)) {
            return false;
        }
        map.remove(key);
        return true;
    }

    public static boolean removeKeys(Map<?, ?> map, Collection<?> keysToRemove) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(keysToRemove)) {
            return false;
        }
        int originalSize = map.size();
        for (Object key : keysToRemove) {
            map.remove(key);
        }
        return map.size() < originalSize;
    }

    public static boolean removeEntries(Map<?, ?> map, Map<?, ?> entriesToRemove) {
        if (N.isNullOrEmpty(map) || N.isNullOrEmpty(entriesToRemove)) {
            return false;
        }
        int originalSize = map.size();
        for (Map.Entry<?, ?> entry : entriesToRemove.entrySet()) {
            if (!N.equals(map.get(entry.getKey()), entry.getValue())) continue;
            map.remove(entry.getKey());
        }
        return map.size() < originalSize;
    }

    public static <K, V, E extends Exception> boolean removeIf(Map<K, V> map, Throwables.Predicate<? super Map.Entry<K, V>, E> filter) throws E {
        ArrayList<K> keysToRemove = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry)) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<K>(7);
            }
            keysToRemove.add(entry.getKey());
        }
        if (N.notNullOrEmpty(keysToRemove)) {
            for (Map.Entry<K, V> key : keysToRemove) {
                map.remove(key);
            }
            return true;
        }
        return false;
    }

    public static <K, V, E extends Exception> boolean removeIfKey(Map<K, V> map, Throwables.Predicate<? super K, E> filter) throws E {
        ArrayList<K> keysToRemove = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry.getKey())) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<K>(7);
            }
            keysToRemove.add(entry.getKey());
        }
        if (N.notNullOrEmpty(keysToRemove)) {
            for (Map.Entry<K, V> key : keysToRemove) {
                map.remove(key);
            }
            return true;
        }
        return false;
    }

    public static <K, V, E extends Exception> boolean removeIfValue(Map<K, V> map, Throwables.Predicate<? super V, E> filter) throws E {
        ArrayList<K> keysToRemove = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter.test(entry.getValue())) continue;
            if (keysToRemove == null) {
                keysToRemove = new ArrayList<K>(7);
            }
            keysToRemove.add(entry.getKey());
        }
        if (N.notNullOrEmpty(keysToRemove)) {
            for (Map.Entry<K, V> key : keysToRemove) {
                map.remove(key);
            }
            return true;
        }
        return false;
    }

    public static <K, V> boolean replace(Map<K, V> map, K key, V oldValue, V newValue) {
        if (N.isNullOrEmpty(map)) {
            return false;
        }
        V curValue = map.get(key);
        if (!N.equals(curValue, oldValue) || curValue == null && !map.containsKey(key)) {
            return false;
        }
        map.put(key, newValue);
        return true;
    }

    public static <K, V> V replace(Map<K, V> map, K key, V newValue) {
        if (N.isNullOrEmpty(map)) {
            return null;
        }
        V curValue = null;
        V v = map.get(key);
        curValue = v;
        if (v != null || map.containsKey(key)) {
            curValue = map.put(key, newValue);
        }
        return curValue;
    }

    public static <K, V, E extends Exception> void replaceAll(Map<K, V> map, Throwables.BiFunction<? super K, ? super V, ? extends V, E> function) throws E {
        N.checkArgNotNull(function);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        Object k = null;
        Object v = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            v = function.apply(k, v);
            try {
                entry.setValue(v);
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
        }
    }

    public static <K, V, E extends Exception> void forEach(Map<K, V> map, Throwables.Consumer<? super Map.Entry<K, V>, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.accept(entry);
        }
    }

    public static <K, V, E extends Exception> void forEach(Map<K, V> map, Throwables.BiConsumer<? super K, ? super V, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    public static <K, V, E extends Exception> Map<K, V> filter(Map<K, V> map, Throwables.BiPredicate<? super K, ? super V, E> predicate) throws E {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newTargetMap(map, 0);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getKey(), entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V, E extends Exception> Map<K, V> filterByKey(Map<K, V> map, Throwables.Predicate<? super K, E> predicate) throws E {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newTargetMap(map, 0);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V, E extends Exception> Map<K, V> filterByValue(Map<K, V> map, Throwables.Predicate<? super V, E> predicate) throws E {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newTargetMap(map, 0);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!predicate.test(entry.getValue())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> Map<V, K> invert(Map<K, V> map) {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newOrderingMap(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V, E extends Exception> Map<V, K> invert(Map<K, V> map, Throwables.BinaryOperator<K, E> mergeOp) throws E {
        N.checkArgNotNull(mergeOp, "mergeOp");
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newOrderingMap(map);
        Object oldVal = null;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            oldVal = result.get(entry.getValue());
            if (oldVal != null || result.containsKey(entry.getValue())) {
                result.put(entry.getValue(), mergeOp.apply(oldVal, entry.getKey()));
                continue;
            }
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> Map<V, List<K>> flatInvert(Map<K, ? extends Collection<? extends V>> map) {
        if (map == null) {
            return new HashMap();
        }
        Map result = Maps.newOrderingMap(map);
        for (Map.Entry<K, Collection<V>> entry : map.entrySet()) {
            Collection<V> c = entry.getValue();
            if (!N.notNullOrEmpty(c)) continue;
            for (V v : c) {
                ArrayList<K> list = (ArrayList<K>)result.get(v);
                if (list == null) {
                    list = new ArrayList<K>();
                    result.put(v, list);
                }
                list.add(entry.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> List<Map<K, V>> flatToMap(Map<K, ? extends Collection<? extends V>> map) {
        void var3_5;
        if (map == null) {
            return new ArrayList<Map<K, V>>();
        }
        int maxValueSize = 0;
        for (Collection<V> collection : map.values()) {
            maxValueSize = N.max(maxValueSize, N.size(collection));
        }
        ArrayList<Map<K, V>> result = new ArrayList<Map<K, V>>(maxValueSize);
        boolean bl = false;
        while (var3_5 < maxValueSize) {
            result.add(Maps.newOrderingMap(map));
            ++var3_5;
        }
        Object var3_6 = null;
        Iterator<V> iter = null;
        for (Map.Entry<K, Collection<V>> entry : map.entrySet()) {
            if (N.isNullOrEmpty(entry.getValue())) continue;
            K k = entry.getKey();
            iter = entry.getValue().iterator();
            int i = 0;
            while (iter.hasNext()) {
                ((Map)result.get(i)).put(k, iter.next());
                ++i;
            }
        }
        return result;
    }

    public static Map<String, Object> flatten(Map<String, Object> map) {
        return Maps.flatten(map, Fn.Suppliers.ofMap());
    }

    public static <M extends Map<String, Object>> M flatten(Map<String, Object> map, Supplier<? extends M> mapSupplier) {
        return Maps.flatten(map, ".", mapSupplier);
    }

    public static <M extends Map<String, Object>> M flatten(Map<String, Object> map, String delimiter, Supplier<? extends M> mapSupplier) {
        Map result = (Map)mapSupplier.get();
        Maps.flatten(map, null, delimiter, result);
        return (M)result;
    }

    private static void flatten(Map<String, Object> map, String prefix, String delimiter, Map<String, Object> output) {
        if (N.isNullOrEmpty(map)) {
            return;
        }
        if (N.isNullOrEmpty(prefix)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    Maps.flatten((Map)entry.getValue(), entry.getKey(), delimiter, output);
                    continue;
                }
                output.put(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getValue() instanceof Map) {
                    Maps.flatten((Map)entry.getValue(), prefix + delimiter + entry.getKey(), delimiter, output);
                    continue;
                }
                output.put(prefix + delimiter + entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> unflatten(Map<String, Object> map) {
        return Maps.unflatten(map, Fn.Suppliers.ofMap());
    }

    public static <M extends Map<String, Object>> M unflatten(Map<String, Object> map, Supplier<? extends M> mapSupplier) {
        return Maps.unflatten(map, ".", mapSupplier);
    }

    public static <M extends Map<String, Object>> M unflatten(Map<String, Object> map, String delimiter, Supplier<? extends M> mapSupplier) {
        Map result = (Map)mapSupplier.get();
        Splitter keySplitter = Splitter.with(delimiter);
        if (N.notNullOrEmpty(map)) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey().indexOf(delimiter) >= 0) {
                    String[] keys = keySplitter.splitToArray(entry.getKey());
                    Map lastMap = result;
                    int to = keys.length - 1;
                    for (int i = 0; i < to; ++i) {
                        Map tmp = (Map)lastMap.get(keys[i]);
                        if (tmp == null) {
                            tmp = (Map)mapSupplier.get();
                            lastMap.put(keys[i], tmp);
                        }
                        lastMap = tmp;
                    }
                    lastMap.put(keys[keys.length - 1], entry.getValue());
                    continue;
                }
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return (M)result;
    }

    static Supplier mapType2Supplier(final Class<? extends Map> mapType) {
        if (HashMap.class.equals(mapType)) {
            return Fn.Suppliers.ofMap();
        }
        if (SortedMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofTreeMap();
        }
        if (IdentityHashMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofIdentityHashMap();
        }
        if (LinkedHashMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofLinkedHashMap();
        }
        if (ImmutableMap.class.isAssignableFrom(mapType)) {
            return Fn.Suppliers.ofLinkedHashMap();
        }
        return new Supplier<Map>(){

            @Override
            public Map get() {
                try {
                    return (Map)N.newInstance(mapType);
                }
                catch (Exception e) {
                    return new LinkedHashMap();
                }
            }
        };
    }

    static <K, V> void replaceAll(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        N.checkArgNotNull(function);
        try {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                entry.setValue(function.apply(entry.getKey(), entry.getValue()));
            }
        }
        catch (IllegalStateException ise) {
            throw new ConcurrentModificationException(ise);
        }
    }

    static <K, V, E extends Exception> void merge(Map<K, V> map, K key, V value, Throwables.BinaryOperator<V, E> remappingFunction) throws E {
        V oldValue = map.get(key);
        if (oldValue == null && !map.containsKey(key)) {
            map.put(key, value);
        } else {
            map.put(key, remappingFunction.apply(oldValue, value));
        }
    }

    public static <T> T map2Entity(Class<T> targetClass, Map<String, Object> m) {
        return Maps.map2Entity(targetClass, m, false, true);
    }

    public static <T> T map2Entity(Class<T> targetClass, Map<String, Object> m, boolean ignoreNullProperty, boolean ignoreUnmatchedProperty) {
        Maps.checkEntityClass(targetClass);
        T entity = N.newInstance(targetClass);
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(targetClass);
        ParserUtil.PropInfo propInfo = null;
        String propName = null;
        Object propValue = null;
        for (Map.Entry<String, Object> entry : m.entrySet()) {
            propName = entry.getKey();
            propValue = entry.getValue();
            if (ignoreNullProperty && propValue == null) continue;
            propInfo = entityInfo.getPropInfo(propName);
            if (propInfo == null) {
                entityInfo.setPropValue(entity, propName, propValue, ignoreUnmatchedProperty);
                continue;
            }
            if (propValue != null && N.typeOf(propValue.getClass()).isMap() && propInfo.type.isEntity()) {
                propInfo.setPropValue(entity, Maps.map2Entity(propInfo.clazz, (Map)propValue, ignoreNullProperty, ignoreUnmatchedProperty));
                continue;
            }
            propInfo.setPropValue(entity, propValue);
        }
        return entity;
    }

    public static <T> T map2Entity(Class<T> targetClass, Map<String, Object> m, Collection<String> selectPropNames) {
        Maps.checkEntityClass(targetClass);
        T entity = N.newInstance(targetClass);
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(targetClass);
        ParserUtil.PropInfo propInfo = null;
        Object propValue = null;
        for (String propName : selectPropNames) {
            propValue = m.get(propName);
            if (propValue == null && !m.containsKey(propName)) {
                throw new IllegalArgumentException("Property name: " + propName + " is not found in map with key set: " + m.keySet());
            }
            propInfo = entityInfo.getPropInfo(propName);
            if (propInfo == null) {
                entityInfo.setPropValue(entity, propName, propValue, false);
                continue;
            }
            if (propValue != null && N.typeOf(propValue.getClass()).isMap() && propInfo.type.isEntity()) {
                propInfo.setPropValue(entity, Maps.map2Entity(propInfo.clazz, (Map)propValue));
                continue;
            }
            propInfo.setPropValue(entity, propValue);
        }
        return entity;
    }

    public static <T> List<T> map2Entity(Class<T> targetClass, Collection<Map<String, Object>> mList) {
        return Maps.map2Entity(targetClass, mList, false, true);
    }

    public static <T> List<T> map2Entity(Class<T> targetClass, Collection<Map<String, Object>> mList, boolean igoreNullProperty, boolean ignoreUnmatchedProperty) {
        Maps.checkEntityClass(targetClass);
        ArrayList<T> entityList = new ArrayList<T>(mList.size());
        for (Map<String, Object> m : mList) {
            entityList.add(Maps.map2Entity(targetClass, m, igoreNullProperty, ignoreUnmatchedProperty));
        }
        return entityList;
    }

    public static <T> List<T> map2Entity(Class<T> targetClass, Collection<Map<String, Object>> mList, Collection<String> selectPropNames) {
        Maps.checkEntityClass(targetClass);
        ArrayList<T> entityList = new ArrayList<T>(mList.size());
        for (Map<String, Object> m : mList) {
            entityList.add(Maps.map2Entity(targetClass, m, selectPropNames));
        }
        return entityList;
    }

    public static Map<String, Object> entity2Map(Object entity) {
        return Maps.entity2Map(entity, false);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty) {
        return Maps.entity2Map(entity, ignoreNullProperty, null);
    }

    public static Map<String, Object> entity2Map(Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entity, false, ignoredPropNames);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        int initCapacity = entity instanceof DirtyMarker ? DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() : ClassUtil.getPropNameList(entity.getClass()).size();
        Map<String, Object> resultMap = N.newLinkedHashMap(initCapacity);
        Maps.entity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy);
        return resultMap;
    }

    public static <M extends Map<String, Object>> M entity2Map(Object entity, Supplier<? extends M> mapSupplier) {
        return (M)Maps.entity2Map((Map)mapSupplier.get(), entity);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity) {
        return Maps.entity2Map(resultMap, entity, false);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, boolean ignoreNullProperty) {
        return Maps.entity2Map(resultMap, entity, ignoreNullProperty, null);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(resultMap, entity, false, ignoredPropNames);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static <M extends Map<String, Object>> M entity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        block5: {
            ParserUtil.EntityInfo entityInfo;
            boolean hasIgnoredPropNames;
            boolean isLowerCamelCaseOrNoChange;
            block4: {
                keyNamingPolicy = keyNamingPolicy == null ? NamingPolicy.LOWER_CAMEL_CASE : keyNamingPolicy;
                isLowerCamelCaseOrNoChange = NamingPolicy.LOWER_CAMEL_CASE.equals((Object)keyNamingPolicy) || NamingPolicy.NO_CHANGE.equals((Object)keyNamingPolicy);
                hasIgnoredPropNames = N.notNullOrEmpty(ignoredPropNames);
                Class<?> entityClass = entity.getClass();
                entityInfo = ParserUtil.getEntityInfo(entityClass);
                if (!(entity instanceof DirtyMarker)) break block4;
                Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)entity);
                if (!N.notNullOrEmpty(signedPropNames)) break block5;
                Object propValue = null;
                ParserUtil.PropInfo propInfo = null;
                for (String propName : signedPropNames) {
                    propInfo = entityInfo.getPropInfo(propName);
                    propName = propInfo.name;
                    if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                    propValue = propInfo.getPropValue(entity);
                    if (ignoreNullProperty && propValue == null) continue;
                    if (isLowerCamelCaseOrNoChange) {
                        resultMap.put((String)propName, propValue);
                        continue;
                    }
                    resultMap.put((String)keyNamingPolicy.convert(propName), propValue);
                }
                break block5;
            }
            String propName = null;
            Object propValue = null;
            for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
                propName = propInfo.name;
                if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                propValue = propInfo.getPropValue(entity);
                if (ignoreNullProperty && propValue == null) continue;
                if (isLowerCamelCaseOrNoChange) {
                    resultMap.put((String)propName, propValue);
                    continue;
                }
                resultMap.put((String)keyNamingPolicy.convert(propName), propValue);
            }
        }
        return resultMap;
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList) {
        return Maps.entity2Map(entityList, false);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, boolean ignoreNullProperty) {
        return Maps.entity2Map(entityList, ignoreNullProperty, null);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entityList, false, ignoredPropNames);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2Map(entityList, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static List<Map<String, Object>> entity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Object entity : entityList) {
            resultList.add(Maps.entity2Map(entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy));
        }
        return resultList;
    }

    public static Map<String, Object> deepEntity2Map(Object entity) {
        return Maps.deepEntity2Map(entity, false);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty) {
        return Maps.deepEntity2Map(entity, ignoreNullProperty, null);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(entity, false, ignoredPropNames);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        int initCapacity = entity instanceof DirtyMarker ? DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() : ClassUtil.getPropNameList(entity.getClass()).size();
        Map<String, Object> resultMap = N.newLinkedHashMap(initCapacity);
        Maps.deepEntity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy);
        return resultMap;
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(Object entity, Supplier<? extends M> mapSupplier) {
        return (M)Maps.deepEntity2Map((Map)mapSupplier.get(), entity);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity) {
        return Maps.deepEntity2Map(resultMap, entity, false);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, boolean ignoreNullProperty) {
        return Maps.deepEntity2Map(resultMap, entity, ignoreNullProperty, null);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(resultMap, entity, false, ignoredPropNames);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(resultMap, entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static <M extends Map<String, Object>> M deepEntity2Map(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        block9: {
            ParserUtil.EntityInfo entityInfo;
            boolean hasIgnoredPropNames;
            boolean isLowerCamelCaseOrNoChange;
            block8: {
                keyNamingPolicy = keyNamingPolicy == null ? NamingPolicy.LOWER_CAMEL_CASE : keyNamingPolicy;
                isLowerCamelCaseOrNoChange = NamingPolicy.LOWER_CAMEL_CASE.equals((Object)keyNamingPolicy) || NamingPolicy.NO_CHANGE.equals((Object)keyNamingPolicy);
                hasIgnoredPropNames = N.notNullOrEmpty(ignoredPropNames);
                Class<?> entityClass = entity.getClass();
                entityInfo = ParserUtil.getEntityInfo(entityClass);
                if (!(entity instanceof DirtyMarker)) break block8;
                Set<String> signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)entity);
                if (!N.notNullOrEmpty(signedPropNames)) break block9;
                Object propValue = null;
                ParserUtil.PropInfo propInfo = null;
                for (String propName : signedPropNames) {
                    propInfo = entityInfo.getPropInfo(propName);
                    propName = propInfo.name;
                    if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                    propValue = propInfo.getPropValue(entity);
                    if (ignoreNullProperty && propValue == null) continue;
                    if (propValue == null || !propInfo.jsonXmlType.isEntity()) {
                        if (isLowerCamelCaseOrNoChange) {
                            resultMap.put((String)propName, propValue);
                            continue;
                        }
                        resultMap.put((String)keyNamingPolicy.convert(propName), propValue);
                        continue;
                    }
                    if (isLowerCamelCaseOrNoChange) {
                        resultMap.put((String)propName, Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
                        continue;
                    }
                    resultMap.put((String)keyNamingPolicy.convert(propName), Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
                }
                break block9;
            }
            Object propValue = null;
            String propName = null;
            for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
                propName = propInfo.name;
                if (hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
                propValue = propInfo.getPropValue(entity);
                if (ignoreNullProperty && propValue == null) continue;
                if (propValue == null || !propInfo.jsonXmlType.isEntity()) {
                    if (isLowerCamelCaseOrNoChange) {
                        resultMap.put((String)propName, propValue);
                        continue;
                    }
                    resultMap.put((String)keyNamingPolicy.convert(propName), propValue);
                    continue;
                }
                if (isLowerCamelCaseOrNoChange) {
                    resultMap.put((String)propName, Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
                    continue;
                }
                resultMap.put((String)keyNamingPolicy.convert(propName), Maps.deepEntity2Map(propValue, ignoreNullProperty, null, keyNamingPolicy));
            }
        }
        return resultMap;
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList) {
        return Maps.deepEntity2Map(entityList, false);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, boolean ignoreNullProperty) {
        return Maps.deepEntity2Map(entityList, ignoreNullProperty, null);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, Collection<String> ignoredPropNames) {
        boolean ignoreNullProperty = N.isNullOrEmpty(entityList) ? true : !((entityList instanceof ArrayList ? ((ArrayList)entityList).get(0) : entityList.iterator().next()) instanceof DirtyMarker);
        return Maps.deepEntity2Map(entityList, ignoreNullProperty, ignoredPropNames);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.deepEntity2Map(entityList, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static List<Map<String, Object>> deepEntity2Map(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Object entity : entityList) {
            resultList.add(Maps.deepEntity2Map(entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy));
        }
        return resultList;
    }

    public static Map<String, Object> entity2FlatMap(Object entity) {
        return Maps.entity2FlatMap(entity, false);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty) {
        return Maps.entity2FlatMap(entity, ignoreNullProperty, null);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entity, false, ignoredPropNames);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        int initCapacity = entity instanceof DirtyMarker ? DirtyMarkerUtil.signedPropNames((DirtyMarker)entity).size() : ClassUtil.getPropNameList(entity.getClass()).size();
        Map<String, Object> resultMap = N.newLinkedHashMap(initCapacity);
        Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy);
        return resultMap;
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(Object entity, Supplier<? extends M> mapSupplier) {
        return (M)Maps.entity2FlatMap((Map)mapSupplier.get(), entity);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity) {
        return Maps.entity2FlatMap(resultMap, entity, false);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, boolean ignoreNullProperty) {
        return Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, null);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(resultMap, entity, false, ignoredPropNames);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static <M extends Map<String, Object>> M entity2FlatMap(M resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        return Maps.entity2FlatMap(resultMap, entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy, null);
    }

    static <T extends Map<String, Object>> T entity2FlatMap(T resultMap, Object entity, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy, String parentPropName) {
        boolean hasIgnoredPropNames = N.notNullOrEmpty(ignoredPropNames);
        boolean isNullParentPropName = parentPropName == null;
        Class<?> entityClass = entity.getClass();
        Set<String> signedPropNames = null;
        if (entity instanceof DirtyMarker) {
            signedPropNames = DirtyMarkerUtil.signedPropNames((DirtyMarker)entity);
            if (signedPropNames.size() == 0) {
                return resultMap;
            }
            Set tmp = N.newHashSet(signedPropNames.size());
            for (String propName : signedPropNames) {
                tmp.add(ClassUtil.getPropNameByMethod(ClassUtil.getPropGetMethod(entityClass, propName)));
            }
            signedPropNames = tmp;
        }
        boolean isLowerCamelCaseOrNoChange = NamingPolicy.LOWER_CAMEL_CASE.equals((Object)keyNamingPolicy) || NamingPolicy.NO_CHANGE.equals((Object)keyNamingPolicy);
        String propName = null;
        Object propValue = null;
        for (ParserUtil.PropInfo propInfo : ParserUtil.getEntityInfo(entityClass).propInfoList) {
            propName = propInfo.name;
            if (signedPropNames != null && !signedPropNames.contains(propName) || hasIgnoredPropNames && ignoredPropNames.contains(propName)) continue;
            propValue = propInfo.getPropValue(entity);
            if (ignoreNullProperty && propValue == null) continue;
            if (propValue == null || !propInfo.jsonXmlType.isEntity()) {
                if (isNullParentPropName) {
                    if (isLowerCamelCaseOrNoChange) {
                        resultMap.put((String)propName, propValue);
                        continue;
                    }
                    resultMap.put((String)keyNamingPolicy.convert(propName), propValue);
                    continue;
                }
                if (isLowerCamelCaseOrNoChange) {
                    resultMap.put((String)(parentPropName + "." + propName), propValue);
                    continue;
                }
                resultMap.put((String)keyNamingPolicy.convert(parentPropName + "." + propName), propValue);
                continue;
            }
            if (isNullParentPropName) {
                Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, propName);
                continue;
            }
            Maps.entity2FlatMap(resultMap, propValue, ignoreNullProperty, null, keyNamingPolicy, parentPropName + "." + propName);
        }
        return resultMap;
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList) {
        return Maps.entity2FlatMap(entityList, false);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, boolean ignoreNullProperty) {
        return Maps.entity2FlatMap(entityList, ignoreNullProperty, null);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entityList, false, ignoredPropNames);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames) {
        return Maps.entity2FlatMap(entityList, ignoreNullProperty, ignoredPropNames, NamingPolicy.LOWER_CAMEL_CASE);
    }

    public static List<Map<String, Object>> entity2FlatMap(Collection<?> entityList, boolean ignoreNullProperty, Collection<String> ignoredPropNames, NamingPolicy keyNamingPolicy) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(entityList.size());
        for (Object entity : entityList) {
            resultList.add(Maps.entity2FlatMap(entity, ignoreNullProperty, ignoredPropNames, keyNamingPolicy));
        }
        return resultList;
    }

    private static <T> void checkEntityClass(Class<T> cls) {
        if (!ClassUtil.isEntity(cls)) {
            throw new IllegalArgumentException("No property getter/setter method is found in the specified class: " + ClassUtil.getCanonicalClassName(cls));
        }
    }
}

