/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.annotation.SequentialOnly;
import com.landawn.abacus.annotation.Stateful;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.function.BiFunction;
import java.util.Comparator;

public enum MergeResult {
    TAKE_FIRST,
    TAKE_SECOND;

    private static final BiFunction<Comparable, Comparable, MergeResult> MIN_FIRST_BF;
    private static final BiFunction<Comparable, Comparable, MergeResult> MAX_FIRST_BF;

    public static <T extends Comparable<? super T>> MergeResult minFirst(T a, T b) {
        return N.compare(a, b) <= 0 ? TAKE_FIRST : TAKE_SECOND;
    }

    public static <T> MergeResult minFirst(T a, T b, Comparator<? super T> cmp) {
        return cmp.compare(a, b) <= 0 ? TAKE_FIRST : TAKE_SECOND;
    }

    public static <T extends Comparable<? super T>> MergeResult maxFirst(T a, T b) {
        return N.compare(a, b) >= 0 ? TAKE_FIRST : TAKE_SECOND;
    }

    public static <T> MergeResult maxFirst(T a, T b, Comparator<? super T> cmp) {
        return cmp.compare(a, b) >= 0 ? TAKE_FIRST : TAKE_SECOND;
    }

    public static <T extends Comparable> BiFunction<T, T, MergeResult> minFirst() {
        return MIN_FIRST_BF;
    }

    public static <T> BiFunction<T, T, MergeResult> minFirst(final Comparator<? super T> cmp) {
        N.checkArgNotNull(cmp, "cmp");
        return new BiFunction<T, T, MergeResult>(){

            @Override
            public MergeResult apply(T a, T b) {
                return cmp.compare(a, b) <= 0 ? TAKE_FIRST : TAKE_SECOND;
            }
        };
    }

    public static <T extends Comparable> BiFunction<T, T, MergeResult> maxFirst() {
        return MAX_FIRST_BF;
    }

    public static <T> BiFunction<T, T, MergeResult> maxFirst(final Comparator<? super T> cmp) {
        N.checkArgNotNull(cmp, "cmp");
        return new BiFunction<T, T, MergeResult>(){

            @Override
            public MergeResult apply(T a, T b) {
                return cmp.compare(a, b) >= 0 ? TAKE_FIRST : TAKE_SECOND;
            }
        };
    }

    @Deprecated
    @Beta
    @SequentialOnly
    @Stateful
    public static <T> BiFunction<T, T, MergeResult> alternated() {
        return Fn.alternated();
    }

    static {
        MIN_FIRST_BF = new BiFunction<Comparable, Comparable, MergeResult>(){

            @Override
            public MergeResult apply(Comparable a, Comparable b) {
                return N.compare(a, b) <= 0 ? TAKE_FIRST : TAKE_SECOND;
            }
        };
        MAX_FIRST_BF = new BiFunction<Comparable, Comparable, MergeResult>(){

            @Override
            public MergeResult apply(Comparable a, Comparable b) {
                return N.compare(a, b) >= 0 ? TAKE_FIRST : TAKE_SECOND;
            }
        };
    }
}

