/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.N;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class MoreExecutors {
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor) {
        return MoreExecutors.getExitingExecutorService(executor, 120L, TimeUnit.SECONDS);
    }

    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
        MoreExecutors.useDaemonThreadFactory(executor);
        ExecutorService service = Executors.unconfigurableExecutorService(executor);
        MoreExecutors.addDelayedShutdownHook(service, terminationTimeout, timeUnit);
        return service;
    }

    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
        return MoreExecutors.getExitingScheduledExecutorService(executor, 120L, TimeUnit.SECONDS);
    }

    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
        MoreExecutors.useDaemonThreadFactory(executor);
        ScheduledExecutorService service = Executors.unconfigurableScheduledExecutorService(executor);
        MoreExecutors.addDelayedShutdownHook(service, terminationTimeout, timeUnit);
        return service;
    }

    public static void addDelayedShutdownHook(final ExecutorService service, final long terminationTimeout, final TimeUnit timeUnit) {
        N.checkArgNotNull(service);
        N.checkArgNotNull(timeUnit);
        MoreExecutors.addShutdownHook(MoreExecutors.newThread("DelayedShutdownHook-for-" + service, new Runnable(){

            @Override
            public void run() {
                try {
                    service.shutdown();
                    service.awaitTermination(terminationTimeout, timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }));
    }

    static void addShutdownHook(Thread hook) {
        Runtime.getRuntime().addShutdownHook(hook);
    }

    private static void useDaemonThreadFactory(final ThreadPoolExecutor executor) {
        executor.setThreadFactory(new ThreadFactory(){
            private ThreadFactory impl;
            {
                this.impl = executor.getThreadFactory();
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread res = this.impl.newThread(r);
                res.setDaemon(true);
                return res;
            }
        });
    }

    static Thread newThread(String name, Runnable runnable) {
        N.checkArgNotNull(name);
        N.checkArgNotNull(runnable);
        Thread result = Executors.defaultThreadFactory().newThread(runnable);
        try {
            result.setName(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }
}

