/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.Throwables;
import java.io.Serializable;

public final class MutableBoolean
implements Mutable,
Serializable,
Comparable<MutableBoolean> {
    private static final long serialVersionUID = -4830728138360036487L;
    private boolean value;

    MutableBoolean() {
    }

    MutableBoolean(boolean value) {
        this.value = value;
    }

    public static MutableBoolean of(boolean value) {
        return new MutableBoolean(value);
    }

    public boolean value() {
        return this.value;
    }

    @Deprecated
    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public boolean getAndSet(boolean value) {
        boolean result = this.value;
        this.value = value;
        return result;
    }

    public boolean setAndGet(boolean value) {
        this.value = value;
        return this.value;
    }

    public boolean getAndInvert() {
        boolean result = this.value;
        this.value = !this.value;
        return result;
    }

    public boolean invertAndGet() {
        this.value = !this.value;
        return this.value;
    }

    public <E extends Exception> boolean setIf(boolean newValue, Throwables.BooleanPredicate<E> predicate) throws E {
        if (predicate.test(this.value)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Deprecated
    public <E extends Exception> boolean setIf(boolean newValue, Throwables.BooleanBiPredicate<E> predicate) throws E {
        if (predicate.test(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public void setFalse() {
        this.value = false;
    }

    public void setTrue() {
        this.value = true;
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public void invert() {
        this.value = !this.value;
    }

    @Override
    public int compareTo(MutableBoolean other) {
        return this.value == other.value ? 0 : (this.value ? 1 : -1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableBoolean) {
            return this.value == ((MutableBoolean)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

