/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.Throwables;

public final class MutableFloat
extends Number
implements Comparable<MutableFloat>,
Mutable {
    private static final long serialVersionUID = 5787169186L;
    private float value;

    MutableFloat() {
    }

    MutableFloat(float value) {
        this.value = value;
    }

    public static MutableFloat of(float value) {
        return new MutableFloat(value);
    }

    public float value() {
        return this.value;
    }

    @Deprecated
    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getAndSet(float value) {
        float result = this.value;
        this.value = value;
        return result;
    }

    public float setAndGet(float value) {
        this.value = value;
        return this.value;
    }

    public <E extends Exception> boolean setIf(float newValue, Throwables.FloatPredicate<E> predicate) throws E {
        if (predicate.test(this.value)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Deprecated
    public <E extends Exception> boolean setIf(float newValue, Throwables.FloatBiPredicate<E> predicate) throws E {
        if (predicate.test(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public boolean isNaN() {
        return Float.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public void increment() {
        this.value += 1.0f;
    }

    public void decrement() {
        this.value -= 1.0f;
    }

    public void add(float operand) {
        this.value += operand;
    }

    public void subtract(float operand) {
        this.value -= operand;
    }

    public final float getAndIncrement() {
        float f = this.value;
        this.value = f + 1.0f;
        return f;
    }

    public final float getAndDecrement() {
        float f = this.value;
        this.value = f - 1.0f;
        return f;
    }

    public final float incrementAndGet() {
        return this.value += 1.0f;
    }

    public final float decrementAndGet() {
        return this.value -= 1.0f;
    }

    public final float getAndAdd(float delta) {
        float prev = this.value;
        this.value += delta;
        return prev;
    }

    public final float addAndGet(float delta) {
        return this.value += delta;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableFloat other) {
        return Float.compare(this.value, other.value);
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableFloat && Float.compare(((MutableFloat)obj).value, this.value) == 0;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

