/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.Throwables;

public final class MutableInt
extends Number
implements Comparable<MutableInt>,
Mutable {
    private static final long serialVersionUID = 512176391864L;
    private int value;

    MutableInt() {
    }

    MutableInt(int value) {
        this.value = value;
    }

    public static MutableInt of(int value) {
        return new MutableInt(value);
    }

    public int value() {
        return this.value;
    }

    @Deprecated
    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getAndSet(int value) {
        int result = this.value;
        this.value = value;
        return result;
    }

    public int setAndGet(int value) {
        this.value = value;
        return this.value;
    }

    public <E extends Exception> boolean setIf(int newValue, Throwables.IntPredicate<E> predicate) throws E {
        if (predicate.test(this.value)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Deprecated
    public <E extends Exception> boolean setIf(int newValue, Throwables.IntBiPredicate<E> predicate) throws E {
        if (predicate.test(this.value, newValue)) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    public void increment() {
        ++this.value;
    }

    public void decrement() {
        --this.value;
    }

    public void add(int operand) {
        this.value += operand;
    }

    public void subtract(int operand) {
        this.value -= operand;
    }

    public final int getAndIncrement() {
        return this.value++;
    }

    public final int getAndDecrement() {
        return this.value--;
    }

    public final int incrementAndGet() {
        return ++this.value;
    }

    public final int decrementAndGet() {
        return --this.value;
    }

    public final int getAndAdd(int delta) {
        int prev = this.value;
        this.value += delta;
        return prev;
    }

    public final int addAndGet(int delta) {
        return this.value += delta;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(MutableInt other) {
        return this.value > other.value ? 1 : (this.value == other.value ? 0 : -1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableInt) {
            return this.value == ((MutableInt)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

