/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.core.MapEntity;
import com.landawn.abacus.exception.DuplicatedResultException;
import com.landawn.abacus.exception.UncheckedException;
import com.landawn.abacus.parser.DeserializationConfig;
import com.landawn.abacus.parser.JSONDeserializationConfig;
import com.landawn.abacus.parser.JSONSerializationConfig;
import com.landawn.abacus.parser.XMLDeserializationConfig;
import com.landawn.abacus.parser.XMLSerializationConfig;
import com.landawn.abacus.type.Type;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.BiMap;
import com.landawn.abacus.util.CommonUtil;
import com.landawn.abacus.util.Comparators;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.ExceptionalStream;
import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.Indexed;
import com.landawn.abacus.util.InternalUtil;
import com.landawn.abacus.util.Iterables;
import com.landawn.abacus.util.Iterators;
import com.landawn.abacus.util.Joiner;
import com.landawn.abacus.util.KahanSummation;
import com.landawn.abacus.util.LazyInitializer;
import com.landawn.abacus.util.MergeResult;
import com.landawn.abacus.util.Multiset;
import com.landawn.abacus.util.MutableInt;
import com.landawn.abacus.util.ObjIterator;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Percentage;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Triple;
import com.landawn.abacus.util.Utils;
import com.landawn.abacus.util.Wrapper;
import com.landawn.abacus.util.function.BiFunction;
import com.landawn.abacus.util.function.IntFunction;
import com.landawn.abacus.util.function.Supplier;
import com.landawn.abacus.util.u;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public final class N
extends CommonUtil {
    public static final int CPU_CORES = Runtime.getRuntime().availableProcessors();
    private static final float LOAD_FACTOR_FOR_FLAT_MAP = 1.75f;
    private static final int LOAD_FACTOR_FOR_TWO_FLAT_MAP = 2;
    static final BiMap<Class<?>, Class<?>> PRIMITIVE_2_WRAPPER = new BiMap();

    private N() {
    }

    public static int occurrencesOf(boolean[] a, boolean valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != valueToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(char[] a, char valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != valueToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(byte[] a, byte valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != valueToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(short[] a, short valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != valueToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(int[] a, int valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != valueToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(long[] a, long valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != valueToFind) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(float[] a, float valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Float.compare(a[i], valueToFind) != 0) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(double[] a, double valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Double.compare(a[i], valueToFind) != 0) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(Object[] a, Object valueToFind) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int occurrences = 0;
        if (valueToFind == null) {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (a[i] != null) continue;
                ++occurrences;
            }
        } else {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (!valueToFind.equals(a[i])) continue;
                ++occurrences;
            }
        }
        return occurrences;
    }

    public static int occurrencesOf(Collection<?> c, Object valueToFind) {
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        return Collections.frequency(c, valueToFind);
    }

    public static long occurrencesOf(Iterator<?> iter, Object valueToFind) {
        if (iter == null) {
            return 0L;
        }
        long occurrences = 0L;
        while (iter.hasNext()) {
            if (!N.equals(iter.next(), valueToFind)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    public static int occurrencesOf(String str, String substr) {
        return StringUtil.occurrencesOf(str, substr);
    }

    public static boolean contains(boolean[] a, boolean valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(char[] a, char valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(byte[] a, byte valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(short[] a, short valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(int[] a, int valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(long[] a, long valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(float[] a, float valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(double[] a, double valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(Object[] a, Object valueToFind) {
        return N.indexOf(a, valueToFind) != -1;
    }

    public static boolean contains(Collection<?> c, Object valueToFind) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return c.contains(valueToFind);
    }

    public static boolean contains(Iterator<?> iter, Object valueToFind) {
        if (iter == null) {
            return false;
        }
        while (iter.hasNext()) {
            if (!N.equals(iter.next(), valueToFind)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAll(Collection<?> c, Collection<?> valuesToFind) {
        if (N.isNullOrEmpty(valuesToFind)) {
            return true;
        }
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return c.containsAll(valuesToFind);
    }

    public static boolean containsAll(Collection<?> c, Object[] valuesToFind) {
        if (N.isNullOrEmpty(valuesToFind)) {
            return true;
        }
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return c.containsAll(Array.asList(valuesToFind));
    }

    public static boolean containsAll(Iterator<?> iter, Collection<?> valuesToFind) {
        if (N.isNullOrEmpty(valuesToFind)) {
            return true;
        }
        if (iter == null) {
            return false;
        }
        HashSet set = new HashSet(valuesToFind);
        while (iter.hasNext()) {
            if (!set.remove(iter.next()) || set.size() != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(Collection<?> c, Collection<?> valuesToFind) {
        if (N.isNullOrEmpty(c) || N.isNullOrEmpty(valuesToFind)) {
            return false;
        }
        return !N.disjoint(c, valuesToFind);
    }

    public static boolean containsAny(Collection<?> c, Object[] valuesToFind) {
        if (N.isNullOrEmpty(c) || N.isNullOrEmpty(valuesToFind)) {
            return false;
        }
        return !N.disjoint(c, Array.asList(valuesToFind));
    }

    public static boolean containsAny(Iterator<?> iter, Set<?> valuesToFind) {
        if (iter == null || N.isNullOrEmpty(valuesToFind)) {
            return false;
        }
        while (iter.hasNext()) {
            if (!valuesToFind.contains(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static <T> u.Nullable<T> getOnlyElement(Iterable<? extends T> iterable) throws DuplicatedResultException {
        if (iterable == null) {
            return u.Nullable.empty();
        }
        return N.getOnlyElement(iterable.iterator());
    }

    public static <T> u.Nullable<T> getOnlyElement(Iterator<? extends T> iter) throws DuplicatedResultException {
        if (iter == null) {
            return u.Nullable.empty();
        }
        T first = iter.next();
        if (iter.hasNext()) {
            throw new DuplicatedResultException("Expected at most one element but was: [" + StringUtil.concat(first, (Object)", ", iter.next(), (Object)"...]"));
        }
        return u.Nullable.of(first);
    }

    public static List<boolean[]> split(boolean[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<boolean[]>();
        }
        int len = a.length;
        ArrayList<boolean[]> res = new ArrayList<boolean[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<boolean[]> split(boolean[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<boolean[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<boolean[]> res = new ArrayList<boolean[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<char[]> split(char[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<char[]>();
        }
        int len = a.length;
        ArrayList<char[]> res = new ArrayList<char[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<char[]> split(char[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<char[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<char[]> res = new ArrayList<char[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<byte[]> split(byte[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<byte[]>();
        }
        int len = a.length;
        ArrayList<byte[]> res = new ArrayList<byte[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<byte[]> split(byte[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<byte[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<byte[]> res = new ArrayList<byte[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<short[]> split(short[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<short[]>();
        }
        int len = a.length;
        ArrayList<short[]> res = new ArrayList<short[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<short[]> split(short[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<short[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<short[]> res = new ArrayList<short[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<int[]> split(int[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<int[]>();
        }
        int len = a.length;
        ArrayList<int[]> res = new ArrayList<int[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<int[]> split(int[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<int[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<int[]> res = new ArrayList<int[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<long[]> split(long[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<long[]>();
        }
        int len = a.length;
        ArrayList<long[]> res = new ArrayList<long[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<long[]> split(long[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<long[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<long[]> res = new ArrayList<long[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<float[]> split(float[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<float[]>();
        }
        int len = a.length;
        ArrayList<float[]> res = new ArrayList<float[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<float[]> split(float[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<float[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<float[]> res = new ArrayList<float[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static List<double[]> split(double[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<double[]>();
        }
        int len = a.length;
        ArrayList<double[]> res = new ArrayList<double[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static List<double[]> split(double[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<double[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<double[]> res = new ArrayList<double[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static <T> List<T[]> split(T[] a, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList<T[]>();
        }
        int len = a.length;
        ArrayList<T[]> res = new ArrayList<T[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int toIndex = a.length;
        for (int fromIndex = 0; fromIndex < toIndex; fromIndex += chunkSize) {
            res.add(N.copyOfRange(a, fromIndex, fromIndex <= toIndex - chunkSize ? fromIndex + chunkSize : toIndex));
        }
        return res;
    }

    public static <T> List<T[]> split(T[] a, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList<T[]>();
        }
        int len = toIndex - fromIndex;
        ArrayList<T[]> res = new ArrayList<T[]>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(N.copyOfRange(a, i, i <= toIndex - chunkSize ? i + chunkSize : toIndex));
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static <T> List<List<T>> split(Collection<? extends T> c, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(c)) {
            return new ArrayList<List<T>>();
        }
        return N.split(c, 0, c.size(), chunkSize);
    }

    public static <T> List<List<T>> split(Collection<? extends T> c, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(c) || fromIndex == toIndex) {
            return new ArrayList<List<T>>();
        }
        int len = toIndex - fromIndex;
        ArrayList<List<T>> res = new ArrayList<List<T>>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        if (c instanceof List) {
            List list = (List)c;
            int i = fromIndex;
            while (i < toIndex) {
                res.add(new ArrayList(list.subList(i, i <= toIndex - chunkSize ? i + chunkSize : toIndex)));
                i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
            }
        } else {
            Iterator<T> iter = c.iterator();
            int i = 0;
            while (i < toIndex) {
                int j;
                if (i < fromIndex) {
                    iter.next();
                    ++i;
                    continue;
                }
                ArrayList<T> subList = new ArrayList<T>(N.min(chunkSize, toIndex - i));
                int n = j = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
                while (i < j) {
                    subList.add(iter.next());
                    ++i;
                }
                res.add(subList);
            }
        }
        return res;
    }

    public static <T> ObjIterator<List<T>> split(final Iterator<? extends T> iter, final int chunkSize) {
        N.checkArgument(chunkSize > 0, "'chunkSize' must be greater than 0, can't be: %s", chunkSize);
        if (iter == null) {
            return ObjIterator.empty();
        }
        return new ObjIterator<List<T>>(){
            private final Iterator<? extends T> iterator;
            {
                this.iterator = iter;
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public List<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList next = new ArrayList(chunkSize);
                for (int i = 0; i < chunkSize && this.iterator.hasNext(); ++i) {
                    next.add(this.iterator.next());
                }
                return next;
            }
        };
    }

    public static List<String> split(CharSequence str, int chunkSize) {
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(str)) {
            return new ArrayList<String>();
        }
        return N.split(str, 0, str.length(), chunkSize);
    }

    public static List<String> split(CharSequence str, int fromIndex, int toIndex, int chunkSize) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(str));
        N.checkArgPositive(chunkSize, "chunkSize");
        if (N.isNullOrEmpty(str)) {
            return new ArrayList<String>();
        }
        int len = toIndex - fromIndex;
        ArrayList<String> res = new ArrayList<String>(len % chunkSize == 0 ? len / chunkSize : len / chunkSize + 1);
        int i = fromIndex;
        while (i < toIndex) {
            res.add(str.subSequence(i, i <= toIndex - chunkSize ? i + chunkSize : toIndex).toString());
            i = i <= toIndex - chunkSize ? i + chunkSize : toIndex;
        }
        return res;
    }

    public static <T> List<T> intersection(T[] a, Object[] b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        Multiset<Object> bOccurrences = Multiset.of(b);
        ArrayList<T> result = new ArrayList<T>(N.min(9, a.length, b.length));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) <= 0) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> List<T> intersection(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        Multiset<?> bOccurrences = Multiset.from(b);
        ArrayList<T> result = new ArrayList<T>(N.min(9, a.size(), b.size()));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) <= 0) continue;
            result.add(e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<T> intersection(Collection<? extends Collection<? extends T>> c) {
        void var2_4;
        List<T> list;
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        if (c.size() == 1) {
            return N.newArrayList(c.iterator().next());
        }
        for (Collection<T> collection : c) {
            if (!N.isNullOrEmpty(collection)) continue;
            return new ArrayList();
        }
        Iterator<Collection<T>> iter = c.iterator();
        List<T> list2 = N.intersection(iter.next(), iter.next());
        while (iter.hasNext() && (list = N.intersection(var2_4, iter.next())).size() != 0) {
        }
        return var2_4;
    }

    public static <T> List<T> difference(T[] a, Object[] b) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        if (N.isNullOrEmpty(b)) {
            return N.asList(a);
        }
        Multiset<Object> bOccurrences = Multiset.of(b);
        ArrayList<T> result = new ArrayList<T>(N.min(a.length, N.max(9, a.length - b.length)));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> List<T> difference(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        if (N.isNullOrEmpty(b)) {
            return new ArrayList<T>(a);
        }
        Multiset<?> bOccurrences = Multiset.from(b);
        ArrayList<T> result = new ArrayList<T>(N.min(a.size(), N.max(9, a.size() - b.size())));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> List<T> symmetricDifference(T[] a, T[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.asList(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.asList(a);
        }
        Multiset<T> bOccurrences = Multiset.of(b);
        ArrayList<T> result = new ArrayList<T>(N.max(9, Math.abs(a.length - b.length)));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        for (T e : b) {
            if (bOccurrences.getAndRemove(e) > 0) {
                result.add(e);
            }
            if (bOccurrences.isEmpty()) break;
        }
        return result;
    }

    public static <T> List<T> symmetricDifference(Collection<? extends T> a, Collection<? extends T> b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList() : new ArrayList<T>(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? new ArrayList() : new ArrayList<T>(a);
        }
        Multiset<T> bOccurrences = Multiset.from(b);
        ArrayList<T> result = new ArrayList<T>(N.max(9, Math.abs(a.size() - b.size())));
        for (T e : a) {
            if (bOccurrences.getAndRemove(e) >= 1) continue;
            result.add(e);
        }
        for (T e : b) {
            if (bOccurrences.getAndRemove(e) > 0) {
                result.add(e);
            }
            if (!bOccurrences.isEmpty()) continue;
            break;
        }
        return result;
    }

    public static <T> Set<T> differentSet(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a)) {
            return N.newHashSet();
        }
        if (N.isNullOrEmpty(b)) {
            return N.newHashSet(a);
        }
        Set<? extends T> result = N.newHashSet(a);
        N.removeAll(result, b);
        return result;
    }

    public static <T> Set<T> symmetricDifferentSet(Collection<? extends T> a, Collection<? extends T> b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? N.newHashSet() : N.newHashSet(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? N.newHashSet() : N.newHashSet(a);
        }
        Set<T> commonSet = N.commonSet(a, b);
        Set result = N.newHashSet();
        for (T e : a) {
            if (commonSet.contains(e)) continue;
            result.add(e);
        }
        for (T e : b) {
            if (commonSet.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> Set<T> commonSet(Collection<? extends T> a, Collection<?> b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return N.newHashSet();
        }
        return N.commonSet(Array.asList(a, b));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Set<T> commonSet(Collection<? extends Collection<? extends T>> c) {
        void var3_6;
        if (N.isNullOrEmpty(c)) {
            return N.newHashSet();
        }
        if (c.size() == 1) {
            return N.newHashSet(c.iterator().next());
        }
        Collection<T> smallest = null;
        for (Collection<T> collection : c) {
            if (N.isNullOrEmpty(collection)) {
                return N.newHashSet();
            }
            if (smallest != null && collection.size() >= smallest.size()) continue;
            smallest = collection;
        }
        HashMap map = new HashMap();
        for (Object e3 : smallest) {
            map.put(e3, new MutableInt(1));
        }
        boolean bl = true;
        MutableInt val = null;
        for (Collection<T> ec : c) {
            if (ec == smallest) continue;
            for (T e4 : ec) {
                val = (MutableInt)map.get(e4);
                if (val == null || val.intValue() < var3_6 || val.intValue() != var3_6) continue;
                val.increment();
            }
            ++var3_6;
        }
        Set result = N.newHashSet(map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (((MutableInt)entry.getValue()).intValue() != var3_6) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public static <T> List<T> exclude(Collection<T> c, Object objToExclude) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(c.size() - 1);
        for (T e : c) {
            if (N.equals(e, objToExclude)) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> Set<T> excludeToSet(Collection<T> c, Object objToExclude) {
        if (N.isNullOrEmpty(c)) {
            return new HashSet();
        }
        Set<T> result = N.newHashSet(c);
        result.remove(objToExclude);
        return result;
    }

    public static <T> List<T> excludeAll(Collection<T> c, Collection<?> objsToExclude) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        if (N.isNullOrEmpty(objsToExclude)) {
            return new ArrayList<T>(c);
        }
        if (objsToExclude.size() == 1) {
            return N.exclude(c, N.firstOrNullIfEmpty(objsToExclude));
        }
        Set<Object> set = objsToExclude instanceof Set ? (Set<Object>)objsToExclude : new HashSet(objsToExclude);
        ArrayList<T> result = new ArrayList<T>(N.max(0, c.size() - set.size()));
        for (T e : c) {
            if (set.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static <T> Set<T> excludeAllToSet(Collection<T> c, Collection<?> objsToExclude) {
        if (N.isNullOrEmpty(c)) {
            return new HashSet();
        }
        if (N.isNullOrEmpty(objsToExclude)) {
            return new HashSet<T>(c);
        }
        if (objsToExclude.size() == 1) {
            return N.excludeToSet(c, N.firstOrNullIfEmpty(objsToExclude));
        }
        Set<Object> set = objsToExclude instanceof Set ? (Set<Object>)objsToExclude : new HashSet(objsToExclude);
        Set result = N.newHashSet(N.max(0, c.size() - set.size()));
        for (T e : c) {
            if (set.contains(e)) continue;
            result.add(e);
        }
        return result;
    }

    public static boolean isSubCollection(Collection<?> subColl, Collection<?> coll) {
        N.checkArgNotNull(subColl, "a");
        N.checkArgNotNull(coll, "b");
        if (N.isNullOrEmpty(coll)) {
            return true;
        }
        if (N.isNullOrEmpty(subColl)) {
            return false;
        }
        Multiset<?> multisetA = Multiset.from(subColl);
        Multiset<?> multisetB = Multiset.from(coll);
        for (Object e : subColl) {
            if (multisetA.occurrencesOf(e) <= multisetB.occurrencesOf(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection<?> subColl, Collection<?> coll) {
        N.checkArgNotNull(subColl, "a");
        N.checkArgNotNull(coll, "b");
        return subColl.size() < coll.size() && N.isSubCollection(subColl, coll);
    }

    public static boolean isEqualCollection(Collection<?> a, Collection<?> b) {
        int sizeB;
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null || a != null && b == null) {
            return false;
        }
        int sizeA = N.size(a);
        if (sizeA != (sizeB = N.size(b))) {
            return false;
        }
        Multiset<?> multisetA = Multiset.from(a);
        Multiset<?> multisetB = Multiset.from(b);
        if (multisetA.size() != multisetB.size()) {
            return false;
        }
        for (Object e : b) {
            if (multisetA.occurrencesOf(e) == multisetB.occurrencesOf(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean[] concat(boolean[] a, boolean[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_BOOLEAN_ARRAY : (boolean[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_BOOLEAN_ARRAY : (boolean[])a.clone();
        }
        boolean[] c = new boolean[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static boolean[] concat(boolean[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_BOOLEAN_ARRAY : (boolean[])aa[0].clone();
        }
        int len = 0;
        for (boolean[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        boolean[] c = new boolean[len];
        int fromIndex = 0;
        for (boolean[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static char[] concat(char[] a, char[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_CHAR_ARRAY : (char[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_CHAR_ARRAY : (char[])a.clone();
        }
        char[] c = new char[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static char[] concat(char[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_CHAR_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_CHAR_ARRAY : (char[])aa[0].clone();
        }
        int len = 0;
        for (char[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        char[] c = new char[len];
        int fromIndex = 0;
        for (char[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static byte[] concat(byte[] a, byte[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_BYTE_ARRAY : (byte[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_BYTE_ARRAY : (byte[])a.clone();
        }
        byte[] c = new byte[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static byte[] concat(byte[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_BYTE_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_BYTE_ARRAY : (byte[])aa[0].clone();
        }
        int len = 0;
        for (byte[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        byte[] c = new byte[len];
        int fromIndex = 0;
        for (byte[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static short[] concat(short[] a, short[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_SHORT_ARRAY : (short[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_SHORT_ARRAY : (short[])a.clone();
        }
        short[] c = new short[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static short[] concat(short[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_SHORT_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_SHORT_ARRAY : (short[])aa[0].clone();
        }
        int len = 0;
        for (short[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        short[] c = new short[len];
        int fromIndex = 0;
        for (short[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static int[] concat(int[] a, int[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_INT_ARRAY : (int[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_INT_ARRAY : (int[])a.clone();
        }
        int[] c = new int[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static int[] concat(int[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_INT_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_INT_ARRAY : (int[])aa[0].clone();
        }
        int len = 0;
        for (int[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        int[] c = new int[len];
        int fromIndex = 0;
        for (int[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static long[] concat(long[] a, long[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_LONG_ARRAY : (long[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_LONG_ARRAY : (long[])a.clone();
        }
        long[] c = new long[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static long[] concat(long[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_LONG_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_LONG_ARRAY : (long[])aa[0].clone();
        }
        int len = 0;
        for (long[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        long[] c = new long[len];
        int fromIndex = 0;
        for (long[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static float[] concat(float[] a, float[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_FLOAT_ARRAY : (float[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_FLOAT_ARRAY : (float[])a.clone();
        }
        float[] c = new float[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static float[] concat(float[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_FLOAT_ARRAY : (float[])aa[0].clone();
        }
        int len = 0;
        for (float[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        float[] c = new float[len];
        int fromIndex = 0;
        for (float[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static double[] concat(double[] a, double[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? EMPTY_DOUBLE_ARRAY : (double[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return N.isNullOrEmpty(a) ? EMPTY_DOUBLE_ARRAY : (double[])a.clone();
        }
        double[] c = new double[a.length + b.length];
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static double[] concat(double[] ... aa) {
        if (N.isNullOrEmpty((Object[])aa)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (aa.length == 1) {
            return N.isNullOrEmpty(aa[0]) ? EMPTY_DOUBLE_ARRAY : (double[])aa[0].clone();
        }
        int len = 0;
        for (double[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            len += a.length;
        }
        double[] c = new double[len];
        int fromIndex = 0;
        for (double[] a : aa) {
            if (N.isNullOrEmpty(a)) continue;
            System.arraycopy(a, 0, c, fromIndex, a.length);
            fromIndex += a.length;
        }
        return c;
    }

    public static <T> T[] concat(T[] a, T[] b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? a : (Object[])b.clone();
        }
        if (N.isNullOrEmpty(b)) {
            return (Object[])a.clone();
        }
        Object[] c = (Object[])N.newArray(a.getClass().getComponentType(), a.length + b.length);
        N.copy(a, 0, c, 0, a.length);
        N.copy(b, 0, c, a.length, b.length);
        return c;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] ... aa) throws IllegalArgumentException {
        if (aa == null) {
            return null;
        }
        if (aa.length == 0) {
            return (Object[])N.newArray(aa.getClass().getComponentType().getComponentType(), 0);
        }
        if (aa.length == 1) {
            return aa[0] == null ? (Object[])N.newArray(aa.getClass().getComponentType().getComponentType(), 0) : (Object[])aa[0].clone();
        }
        int len = 0;
        for (Object[] objectArray : aa) {
            if (N.isNullOrEmpty(objectArray)) continue;
            len += objectArray.length;
        }
        Object[] c = (Object[])N.newArray(aa.getClass().getComponentType().getComponentType(), len);
        int fromIndex = 0;
        for (Object[] objectArray : aa) {
            if (N.isNullOrEmpty(objectArray)) continue;
            System.arraycopy(objectArray, 0, c, fromIndex, objectArray.length);
            fromIndex += objectArray.length;
        }
        return c;
    }

    public static <T> List<T> concat(Collection<? extends T> a, Collection<? extends T> b) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList(0) : new ArrayList<T>(b);
        }
        if (N.isNullOrEmpty(b)) {
            return new ArrayList<T>(a);
        }
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    @SafeVarargs
    public static <T> List<T> concat(Collection<? extends T> ... a) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.concat(Arrays.asList(a));
    }

    public static <T> List<T> concat(Collection<? extends Collection<? extends T>> c) {
        return N.concat(c, Fn.Factory.ofList());
    }

    public static <T, C extends Collection<T>> C concat(Collection<? extends Collection<? extends T>> c, IntFunction<? extends C> supplier) {
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        int count = 0;
        for (Collection<T> e : c) {
            if (!N.notNullOrEmpty(e)) continue;
            count += e.size();
        }
        Collection result = (Collection)supplier.apply(count);
        for (Collection<T> collection : c) {
            if (!N.notNullOrEmpty(collection)) continue;
            result.addAll(collection);
        }
        return (C)result;
    }

    public static <T> ObjIterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b) {
        return Iterators.concat(a, b);
    }

    @SafeVarargs
    public static <T> ObjIterator<T> concat(Iterator<? extends T> ... a) {
        return Iterators.concat(a);
    }

    public static int replaceAll(boolean[] a, boolean oldVal, boolean newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(char[] a, char oldVal, char newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(byte[] a, byte oldVal, byte newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(short[] a, short oldVal, short newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(int[] a, int oldVal, int newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(long[] a, long oldVal, long newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] != oldVal) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(float[] a, float oldVal, float newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Float.compare(a[i], oldVal) != 0) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static int replaceAll(double[] a, double oldVal, double newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (Double.compare(a[i], oldVal) != 0) continue;
            a[i] = newVal;
            ++result;
        }
        return result;
    }

    public static <T> int replaceAll(T[] a, Object oldVal, T newVal) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        if (oldVal == null) {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (a[i] != null) continue;
                a[i] = newVal;
                ++result;
            }
        } else {
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                if (!N.equals(a[i], oldVal)) continue;
                a[i] = newVal;
                ++result;
            }
        }
        return result;
    }

    public static <T> int replaceAll(List<T> list, Object oldVal, T newVal) {
        if (N.isNullOrEmpty(list)) {
            return 0;
        }
        int result = 0;
        int size = list.size();
        if (size < 11 || list instanceof RandomAccess) {
            if (oldVal == null) {
                for (int i = 0; i < size; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, newVal);
                    ++result;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!oldVal.equals(list.get(i))) continue;
                    list.set(i, newVal);
                    ++result;
                }
            }
        } else {
            ListIterator<T> itr = list.listIterator();
            if (oldVal == null) {
                for (int i = 0; i < size; ++i) {
                    if (itr.next() != null) continue;
                    itr.set(newVal);
                    ++result;
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    if (!oldVal.equals(itr.next())) continue;
                    itr.set(newVal);
                    ++result;
                }
            }
        }
        return result;
    }

    public static <E extends Exception> void replaceAll(boolean[] a, Throwables.BooleanUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsBoolean(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(char[] a, Throwables.CharUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsChar(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(byte[] a, Throwables.ByteUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsByte(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(short[] a, Throwables.ShortUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsShort(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(int[] a, Throwables.IntUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsInt(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(long[] a, Throwables.LongUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsLong(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(float[] a, Throwables.FloatUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsFloat(a[i]);
        }
    }

    public static <E extends Exception> void replaceAll(double[] a, Throwables.DoubleUnaryOperator<E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.applyAsDouble(a[i]);
        }
    }

    public static <T, E extends Exception> void replaceAll(T[] a, Throwables.UnaryOperator<T, E> operator) throws E {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            a[i] = operator.apply(a[i]);
        }
    }

    public static <T, E extends Exception> int replaceAll(List<T> list, Throwables.UnaryOperator<T, E> operator) throws E {
        if (N.isNullOrEmpty(list)) {
            return 0;
        }
        int result = 0;
        int size = list.size();
        if (size < 11 || list instanceof RandomAccess) {
            for (int i = 0; i < size; ++i) {
                list.set(i, operator.apply(list.get(i)));
            }
        } else {
            ListIterator<T> itr = list.listIterator();
            for (int i = 0; i < size; ++i) {
                itr.set(operator.apply(itr.next()));
            }
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(boolean[] a, Throwables.BooleanPredicate<E> predicate, boolean newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(char[] a, Throwables.CharPredicate<E> predicate, char newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(byte[] a, Throwables.BytePredicate<E> predicate, byte newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(short[] a, Throwables.ShortPredicate<E> predicate, short newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(int[] a, Throwables.IntPredicate<E> predicate, int newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(long[] a, Throwables.LongPredicate<E> predicate, long newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(float[] a, Throwables.FloatPredicate<E> predicate, float newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <E extends Exception> int replaceIf(double[] a, Throwables.DoublePredicate<E> predicate, double newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <T, E extends Exception> int replaceIf(T[] a, Throwables.Predicate<? super T, E> predicate, T newValue) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        int result = 0;
        int n = a.length;
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(a[i])) continue;
            a[i] = newValue;
            ++result;
        }
        return result;
    }

    public static <T, E extends Exception> int replaceIf(List<T> c, Throwables.Predicate<? super T, E> predicate, T newValue) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        int result = 0;
        int n = c.size();
        for (int i = 0; i < n; ++i) {
            if (!predicate.test(c.get(i))) continue;
            c.set(i, newValue);
            ++result;
        }
        return result;
    }

    public static boolean[] add(boolean[] a, boolean elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        boolean[] newArray = new boolean[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static char[] add(char[] a, char elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        char[] newArray = new char[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static byte[] add(byte[] a, byte elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        byte[] newArray = new byte[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static short[] add(short[] a, short elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        short[] newArray = new short[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static int[] add(int[] a, int elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        int[] newArray = new int[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static long[] add(long[] a, long elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        long[] newArray = new long[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static float[] add(float[] a, float elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        float[] newArray = new float[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static double[] add(double[] a, double elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return Array.of(elementToAdd);
        }
        double[] newArray = new double[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static String[] add(String[] a, String elementToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.asArray(elementToAdd);
        }
        Object[] newArray = new String[a.length + 1];
        N.copy(a, 0, newArray, 0, a.length);
        newArray[a.length] = elementToAdd;
        return newArray;
    }

    public static <T> T[] add(T[] a, T elementToAdd) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        int len = a.length;
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), len + 1);
        if (len > 0) {
            N.copy(a, 0, newArray, 0, len);
        }
        newArray[len] = elementToAdd;
        return newArray;
    }

    @SafeVarargs
    public static boolean[] addAll(boolean[] a, boolean ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_BOOLEAN_ARRAY : (boolean[])elementsToAdd.clone();
        }
        boolean[] newArray = new boolean[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static char[] addAll(char[] a, char ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_CHAR_ARRAY : (char[])elementsToAdd.clone();
        }
        char[] newArray = new char[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static byte[] addAll(byte[] a, byte ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_BYTE_ARRAY : (byte[])elementsToAdd.clone();
        }
        byte[] newArray = new byte[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static short[] addAll(short[] a, short ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_SHORT_ARRAY : (short[])elementsToAdd.clone();
        }
        short[] newArray = new short[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static int[] addAll(int[] a, int ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_INT_ARRAY : (int[])elementsToAdd.clone();
        }
        int[] newArray = new int[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static long[] addAll(long[] a, long ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_LONG_ARRAY : (long[])elementsToAdd.clone();
        }
        long[] newArray = new long[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static float[] addAll(float[] a, float ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_FLOAT_ARRAY : (float[])elementsToAdd.clone();
        }
        float[] newArray = new float[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static double[] addAll(double[] a, double ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_DOUBLE_ARRAY : (double[])elementsToAdd.clone();
        }
        double[] newArray = new double[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static String[] addAll(String[] a, String ... elementsToAdd) {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? EMPTY_STRING_ARRAY : (String[])elementsToAdd.clone();
        }
        Object[] newArray = new String[a.length + elementsToAdd.length];
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] a, T ... elementsToAdd) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(elementsToAdd) ? (Object[])a.clone() : (Object[])elementsToAdd.clone();
        }
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + elementsToAdd.length);
        N.copy(a, 0, newArray, 0, a.length);
        N.copy(elementsToAdd, 0, newArray, a.length, elementsToAdd.length);
        return newArray;
    }

    public static <T> boolean addAll(Collection<T> c, Iterator<? extends T> elementsToAdd) throws IllegalArgumentException {
        N.checkArgNotNull(c, "c");
        if (elementsToAdd == null) {
            return false;
        }
        boolean modified = false;
        if (elementsToAdd.hasNext()) {
            c.add(elementsToAdd.next());
            modified = true;
        }
        while (elementsToAdd.hasNext()) {
            c.add(elementsToAdd.next());
        }
        return modified;
    }

    public static boolean[] insert(boolean[] a, int index, boolean elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        boolean[] newArray = new boolean[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static char[] insert(char[] a, int index, char elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        char[] newArray = new char[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static byte[] insert(byte[] a, int index, byte elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        byte[] newArray = new byte[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static short[] insert(short[] a, int index, short elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        short[] newArray = new short[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static int[] insert(int[] a, int index, int elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        int[] newArray = new int[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static long[] insert(long[] a, int index, long elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        long[] newArray = new long[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static float[] insert(float[] a, int index, float elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        float[] newArray = new float[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static double[] insert(double[] a, int index, double elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return Array.of(elementToInsert);
        }
        double[] newArray = new double[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static String[] insert(String[] a, int index, String elementToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return N.asArray(elementToInsert);
        }
        Object[] newArray = new String[a.length + 1];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static <T> T[] insert(T[] a, int index, T elementToInsert) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        Object[] newArray = (Object[])N.newArray(a.getClass().getComponentType(), a.length + 1);
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        newArray[index] = elementToInsert;
        if (index < a.length) {
            N.copy(a, index, newArray, index + 1, a.length - index);
        }
        return newArray;
    }

    public static String insert(String str, int index, String strToInsert) {
        N.checkIndex(index, N.len(str));
        if (N.isNullOrEmpty(strToInsert)) {
            return N.nullToEmpty(str);
        }
        if (N.isNullOrEmpty(str)) {
            return N.nullToEmpty(strToInsert);
        }
        if (index == str.length()) {
            return StringUtil.concat(str + strToInsert);
        }
        return str;
    }

    @SafeVarargs
    public static boolean[] insertAll(boolean[] a, int index, boolean ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (boolean[])elementsToInsert.clone();
        }
        boolean[] newArray = new boolean[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static char[] insertAll(char[] a, int index, char ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (char[])elementsToInsert.clone();
        }
        char[] newArray = new char[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static byte[] insertAll(byte[] a, int index, byte ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (byte[])elementsToInsert.clone();
        }
        byte[] newArray = new byte[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static short[] insertAll(short[] a, int index, short ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (short[])elementsToInsert.clone();
        }
        short[] newArray = new short[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static int[] insertAll(int[] a, int index, int ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (int[])elementsToInsert.clone();
        }
        int[] newArray = new int[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static long[] insertAll(long[] a, int index, long ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (long[])elementsToInsert.clone();
        }
        long[] newArray = new long[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static float[] insertAll(float[] a, int index, float ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (float[])elementsToInsert.clone();
        }
        float[] newArray = new float[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static double[] insertAll(double[] a, int index, double ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (double[])elementsToInsert.clone();
        }
        double[] newArray = new double[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static String[] insertAll(String[] a, int index, String ... elementsToInsert) {
        if (N.isNullOrEmpty(a) && index == 0) {
            return (String[])elementsToInsert.clone();
        }
        Object[] newArray = new String[a.length + elementsToInsert.length];
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    @SafeVarargs
    public static <T> T[] insertAll(T[] a, int index, T ... elementsToInsert) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        Object[] newArray = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + elementsToInsert.length);
        if (index > 0) {
            N.copy(a, 0, newArray, 0, index);
        }
        N.copy(elementsToInsert, 0, newArray, index, elementsToInsert.length);
        if (index < a.length) {
            N.copy(a, index, newArray, index + elementsToInsert.length, a.length - index);
        }
        return newArray;
    }

    public static boolean[] delete(boolean[] a, int index) {
        N.checkArgNotNull(a, "a");
        boolean[] result = new boolean[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static char[] delete(char[] a, int index) {
        N.checkArgNotNull(a, "a");
        char[] result = new char[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static byte[] delete(byte[] a, int index) {
        N.checkArgNotNull(a, "a");
        byte[] result = new byte[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static short[] delete(short[] a, int index) {
        N.checkArgNotNull(a, "a");
        short[] result = new short[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static int[] delete(int[] a, int index) {
        N.checkArgNotNull(a, "a");
        int[] result = new int[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static long[] delete(long[] a, int index) {
        N.checkArgNotNull(a, "a");
        long[] result = new long[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static float[] delete(float[] a, int index) {
        N.checkArgNotNull(a, "a");
        float[] result = new float[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static double[] delete(double[] a, int index) {
        N.checkArgNotNull(a, "a");
        double[] result = new double[a.length - 1];
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    public static <T> T[] delete(T[] a, int index) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        Object[] result = (Object[])N.newArray(a.getClass().getComponentType(), a.length - 1);
        if (index > 0) {
            N.copy(a, 0, result, 0, index);
        }
        if (index + 1 < a.length) {
            N.copy(a, index + 1, result, index, a.length - index - 1);
        }
        return result;
    }

    @SafeVarargs
    public static boolean[] deleteAll(boolean[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_BOOLEAN_ARRAY : (boolean[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        boolean[] result = new boolean[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static char[] deleteAll(char[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_CHAR_ARRAY : (char[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        char[] result = new char[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static byte[] deleteAll(byte[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_BYTE_ARRAY : (byte[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        byte[] result = new byte[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static short[] deleteAll(short[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_SHORT_ARRAY : (short[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        short[] result = new short[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static int[] deleteAll(int[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_INT_ARRAY : (int[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        int[] result = new int[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static long[] deleteAll(long[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_LONG_ARRAY : (long[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        long[] result = new long[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static float[] deleteAll(float[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_FLOAT_ARRAY : (float[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        float[] result = new float[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static double[] deleteAll(double[] a, int ... indices) {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_DOUBLE_ARRAY : (double[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        double[] result = new double[a.length - diff];
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static String[] deleteAll(String[] a, int ... indices) throws IllegalArgumentException {
        if (N.isNullOrEmpty(indices)) {
            return a == null ? EMPTY_STRING_ARRAY : (String[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        return N.deleteAllBySortedIndices(a, indices);
    }

    @SafeVarargs
    public static <T> T[] deleteAll(T[] a, int ... indices) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        if (N.isNullOrEmpty(indices)) {
            return (Object[])a.clone();
        }
        if (indices.length == 1) {
            return N.delete(a, indices[0]);
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        return N.deleteAllBySortedIndices(a, indices);
    }

    private static <T> T[] deleteAllBySortedIndices(T[] a, int ... indices) {
        int lastIndex = indices[indices.length - 1];
        if (indices[0] < 0 || lastIndex >= a.length) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + lastIndex);
        }
        int diff = 1;
        int len = indices.length;
        for (int i = 1; i < len; ++i) {
            if (indices[i] == indices[i - 1]) continue;
            ++diff;
        }
        Object[] result = (Object[])N.newArray(a.getClass().getComponentType(), a.length - diff);
        int dest = 0;
        int len2 = 0;
        int preIndex = -1;
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] - preIndex > 1) {
                len2 = indices[i] - preIndex - 1;
                N.copy(a, preIndex + 1, result, dest, len2);
                dest += len2;
            }
            preIndex = indices[i];
        }
        if (lastIndex < a.length - 1) {
            len2 = a.length - lastIndex - 1;
            N.copy(a, lastIndex + 1, result, dest, len2);
            dest += len2;
        }
        return result;
    }

    @SafeVarargs
    public static boolean deleteAll(List<?> list, int ... indices) {
        N.checkArgNotNull(list);
        if (N.isNullOrEmpty(indices)) {
            return false;
        }
        if (indices.length == 1) {
            list.remove(indices[0]);
            return true;
        }
        indices = (int[])indices.clone();
        N.sort(indices);
        if (indices[0] < 0 || indices[indices.length - 1] >= list.size()) {
            throw new IndexOutOfBoundsException("The specified indices are from: " + indices[0] + " to: " + indices[indices.length - 1]);
        }
        if (list instanceof LinkedList) {
            Iterator<?> iterator = list.iterator();
            int idx = -1;
            int len = indices.length;
            for (int i = 0; i < len; ++i) {
                if (i > 0 && indices[i] == indices[i - 1]) continue;
                while (idx < indices[i]) {
                    ++idx;
                    iterator.next();
                }
                iterator.remove();
            }
        } else {
            Object[] a = list.toArray();
            Object[] res = N.deleteAllBySortedIndices(a, indices);
            list.clear();
            list.addAll(Arrays.asList(res));
        }
        return true;
    }

    public static boolean[] remove(boolean[] a, boolean elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (boolean[])a.clone() : N.delete(a, index);
    }

    public static char[] remove(char[] a, char elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (char[])a.clone() : N.delete(a, index);
    }

    public static byte[] remove(byte[] a, byte elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (byte[])a.clone() : N.delete(a, index);
    }

    public static short[] remove(short[] a, short elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (short[])a.clone() : N.delete(a, index);
    }

    public static int[] remove(int[] a, int elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (int[])a.clone() : N.delete(a, index);
    }

    public static long[] remove(long[] a, long elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (long[])a.clone() : N.delete(a, index);
    }

    public static float[] remove(float[] a, float elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (float[])a.clone() : N.delete(a, index);
    }

    public static double[] remove(double[] a, double elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (double[])a.clone() : N.delete(a, index);
    }

    public static String[] remove(String[] a, String elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_STRING_ARRAY;
        }
        int index = N.indexOf(a, 0, (Object)elementToRemove);
        return index == -1 ? (String[])a.clone() : N.delete(a, index);
    }

    public static <T> T[] remove(T[] a, T elementToRemove) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        int index = N.indexOf(a, 0, elementToRemove);
        return index == -1 ? (Object[])a.clone() : N.delete(a, index);
    }

    public static <T> boolean remove(Collection<T> c, T elementToRemove) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return c.remove(elementToRemove);
    }

    public static boolean[] removeAllOccurrences(boolean[] a, boolean elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] copy = (boolean[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == elementToRemove) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static char[] removeAllOccurrences(char[] a, char elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] copy = (char[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == elementToRemove) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static byte[] removeAllOccurrences(byte[] a, byte elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] copy = (byte[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == elementToRemove) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static short[] removeAllOccurrences(short[] a, short elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] copy = (short[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == elementToRemove) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static int[] removeAllOccurrences(int[] a, int elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        int[] copy = (int[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == elementToRemove) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static long[] removeAllOccurrences(long[] a, long elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        long[] copy = (long[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (a[i] == elementToRemove) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static float[] removeAllOccurrences(float[] a, float elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] copy = (float[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], elementToRemove)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static double[] removeAllOccurrences(double[] a, double elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] copy = (double[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], elementToRemove)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static String[] removeAllOccurrences(String[] a, String elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_STRING_ARRAY;
        }
        String[] copy = (String[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], elementToRemove)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static <T> T[] removeAllOccurrences(T[] a, T elementToRemove) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        Object[] copy = (Object[])a.clone();
        int idx = 0;
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            if (N.equals(a[i], elementToRemove)) continue;
            copy[idx++] = a[i];
        }
        return idx == copy.length ? copy : N.copyOfRange(copy, 0, idx);
    }

    public static <T> boolean removeAllOccurrences(Collection<T> c, T elementToRemove) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        return N.removeAll(c, N.asSet(elementToRemove));
    }

    @SafeVarargs
    public static String[] removeAll(String[] a, String ... elementsToRemove) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_STRING_ARRAY;
        }
        if (N.isNullOrEmpty(elementsToRemove)) {
            return (String[])a.clone();
        }
        if (elementsToRemove.length == 1) {
            return N.removeAllOccurrences(a, elementsToRemove[0]);
        }
        Set<String> set = N.asSet(elementsToRemove);
        ArrayList<String> result = new ArrayList<String>();
        for (String e : a) {
            if (set.contains(e)) continue;
            result.add(e);
        }
        return result.toArray(new String[result.size()]);
    }

    @SafeVarargs
    public static <T> T[] removeAll(T[] a, T ... elementsToRemove) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        if (N.isNullOrEmpty(elementsToRemove)) {
            return (Object[])a.clone();
        }
        if (elementsToRemove.length == 1) {
            return N.removeAllOccurrences(a, elementsToRemove[0]);
        }
        Set<T> set = N.asSet(elementsToRemove);
        ArrayList<T> result = new ArrayList<T>();
        for (T e : a) {
            if (set.contains(e)) continue;
            result.add(e);
        }
        return result.toArray((Object[])N.newArray(a.getClass().getComponentType(), result.size()));
    }

    @SafeVarargs
    public static <T> boolean removeAll(Collection<T> c, T ... elementsToRemove) {
        if (N.isNullOrEmpty(c) || N.isNullOrEmpty(elementsToRemove)) {
            return false;
        }
        return N.removeAll(c, N.asSet(elementsToRemove));
    }

    public static <T> boolean removeAll(Collection<T> c, Collection<?> elementsToRemove) {
        if (N.isNullOrEmpty(c) || N.isNullOrEmpty(elementsToRemove)) {
            return false;
        }
        if (c instanceof HashSet && !(elementsToRemove instanceof Set)) {
            boolean result = false;
            for (Object e : elementsToRemove) {
                result |= c.remove(e);
                if (c.size() != 0) continue;
                break;
            }
            return result;
        }
        return c.removeAll(elementsToRemove);
    }

    public static <T> boolean removeAll(Collection<T> c, Iterator<?> elementsToRemove) {
        if (N.isNullOrEmpty(c) || elementsToRemove == null) {
            return false;
        }
        if (c instanceof Set) {
            Set set = (Set)c;
            int originalSize = set.size();
            while (elementsToRemove.hasNext()) {
                set.remove(elementsToRemove.next());
            }
            return set.size() != originalSize;
        }
        return N.removeAll(c, N.toSet(elementsToRemove));
    }

    public static boolean[] deleteRange(boolean[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_BOOLEAN_ARRAY : (boolean[])a.clone();
        }
        int len = N.len(a);
        boolean[] b = new boolean[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static char[] deleteRange(char[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_CHAR_ARRAY : (char[])a.clone();
        }
        int len = N.len(a);
        char[] b = new char[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static byte[] deleteRange(byte[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_BYTE_ARRAY : (byte[])a.clone();
        }
        int len = N.len(a);
        byte[] b = new byte[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static short[] deleteRange(short[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_SHORT_ARRAY : (short[])a.clone();
        }
        int len = N.len(a);
        short[] b = new short[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static int[] deleteRange(int[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_INT_ARRAY : (int[])a.clone();
        }
        int len = N.len(a);
        int[] b = new int[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static long[] deleteRange(long[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_LONG_ARRAY : (long[])a.clone();
        }
        int len = N.len(a);
        long[] b = new long[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static float[] deleteRange(float[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_FLOAT_ARRAY : (float[])a.clone();
        }
        int len = N.len(a);
        float[] b = new float[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static double[] deleteRange(double[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_DOUBLE_ARRAY : (double[])a.clone();
        }
        int len = N.len(a);
        double[] b = new double[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static String[] deleteRange(String[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return a == null ? EMPTY_STRING_ARRAY : (String[])a.clone();
        }
        int len = N.len(a);
        Object[] b = new String[len - (toIndex - fromIndex)];
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static <T> T[] deleteRange(T[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return (Object[])a.clone();
        }
        int len = N.len(a);
        Object[] b = (Object[])Array.newInstance(a.getClass().getComponentType(), len - (toIndex - fromIndex));
        if (fromIndex > 0) {
            N.copy(a, 0, b, 0, fromIndex);
        }
        if (toIndex < len) {
            N.copy(a, toIndex, b, fromIndex, len - toIndex);
        }
        return b;
    }

    public static <T> boolean deleteRange(List<T> c, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return false;
        }
        int size = N.size(c);
        if (c instanceof LinkedList || toIndex - fromIndex <= 3) {
            c.subList(fromIndex, toIndex).clear();
        } else {
            ArrayList<T> tmp = new ArrayList<T>(size - (toIndex - fromIndex));
            if (fromIndex > 0) {
                tmp.addAll(c.subList(0, fromIndex));
            }
            if (toIndex < size) {
                tmp.addAll(c.subList(toIndex, size));
            }
            c.clear();
            c.addAll(tmp);
        }
        return true;
    }

    public static String deleteRange(String str, int fromIndex, int toIndex) {
        int len = N.len(str);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (fromIndex == toIndex || fromIndex >= len) {
            return str == null ? EMPTY_STRING : str;
        }
        if (toIndex - fromIndex >= len) {
            return EMPTY_STRING;
        }
        return StringUtil.concat(str.substring(0, fromIndex) + str.subSequence(toIndex, len));
    }

    public static void moveRange(boolean[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        boolean[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(char[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        char[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(byte[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        byte[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(short[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        short[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(int[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        int[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(long[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        long[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(float[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        float[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static void moveRange(double[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        double[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static <T> void moveRange(T[] a, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(a);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return;
        }
        Object[] rangeTmp = N.copyOfRange(a, fromIndex, toIndex);
        if (newPositionStartIndex < fromIndex) {
            N.copy(a, newPositionStartIndex, a, toIndex - (fromIndex - newPositionStartIndex), fromIndex - newPositionStartIndex);
        } else {
            N.copy(a, toIndex, a, fromIndex, newPositionStartIndex - fromIndex);
        }
        N.copy(rangeTmp, 0, a, newPositionStartIndex, rangeTmp.length);
    }

    public static <T> boolean moveRange(List<T> c, int fromIndex, int toIndex, int newPositionStartIndex) {
        int size = N.size(c);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, size);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return false;
        }
        Object[] tmp = c.toArray();
        N.moveRange(tmp, fromIndex, toIndex, newPositionStartIndex);
        c.clear();
        c.addAll(Arrays.asList(tmp));
        return true;
    }

    public static String moveRange(String str, int fromIndex, int toIndex, int newPositionStartIndex) {
        int len = N.len(str);
        N.checkIndexAndStartPositionForMoveRange(fromIndex, toIndex, newPositionStartIndex, len);
        if (fromIndex == toIndex || fromIndex == newPositionStartIndex) {
            return str;
        }
        char[] a = str.toCharArray();
        N.moveRange(a, fromIndex, toIndex, newPositionStartIndex);
        return InternalUtil.newString(a, true);
    }

    private static void checkIndexAndStartPositionForMoveRange(int fromIndex, int toIndex, int newPositionStartIndex, int len) {
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (newPositionStartIndex < 0 || newPositionStartIndex > len - (toIndex - fromIndex)) {
            throw new IndexOutOfBoundsException("newPositionStartIndex " + newPositionStartIndex + " is out-of-bounds: [0, " + (len - (toIndex - fromIndex)) + "=(array.length - (toIndex - fromIndex))]");
        }
    }

    public static boolean[] removeDuplicates(boolean[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length);
    }

    public static boolean[] removeDuplicates(boolean[] a, int fromIndex, int toIndex) {
        boolean[] blArray;
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Boolean[] b = new Boolean[2];
        for (int i = fromIndex; i < toIndex; ++i) {
            if (b[0] == null) {
                b[0] = a[i];
                continue;
            }
            if (b[0] == a[i]) continue;
            b[1] = a[i];
            break;
        }
        if (b[1] == null) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = b[0];
        } else {
            boolean[] blArray3 = new boolean[2];
            blArray3[0] = b[0];
            blArray = blArray3;
            blArray3[1] = b[1];
        }
        return blArray;
    }

    public static char[] removeDuplicates(char[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static char[] removeDuplicates(char[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static char[] removeDuplicates(char[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            char[] b = fromIndex == 0 && toIndex == a.length ? (char[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(Character.valueOf(a[i]));
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (char[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        char[] result = new char[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            char e = ((Character)iterator.next()).charValue();
            result[i++] = e;
        }
        return result;
    }

    public static byte[] removeDuplicates(byte[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static byte[] removeDuplicates(byte[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static byte[] removeDuplicates(byte[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            byte[] b = fromIndex == 0 && toIndex == a.length ? (byte[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(a[i]);
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (byte[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        byte[] result = new byte[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            byte e = (Byte)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static short[] removeDuplicates(short[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static short[] removeDuplicates(short[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static short[] removeDuplicates(short[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            short[] b = fromIndex == 0 && toIndex == a.length ? (short[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(a[i]);
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (short[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        short[] result = new short[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            short e = (Short)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static int[] removeDuplicates(int[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static int[] removeDuplicates(int[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static int[] removeDuplicates(int[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            int[] b = fromIndex == 0 && toIndex == a.length ? (int[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(a[i]);
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (int[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        int[] result = new int[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int e = (Integer)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static long[] removeDuplicates(long[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static long[] removeDuplicates(long[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static long[] removeDuplicates(long[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            long[] b = fromIndex == 0 && toIndex == a.length ? (long[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (b[i] == b[i - 1]) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(a[i]);
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (long[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        long[] result = new long[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long e = (Long)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static float[] removeDuplicates(float[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static float[] removeDuplicates(float[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static float[] removeDuplicates(float[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            float[] b = fromIndex == 0 && toIndex == a.length ? (float[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(Float.valueOf(a[i]));
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (float[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        float[] result = new float[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            float e = ((Float)iterator.next()).floatValue();
            result[i++] = e;
        }
        return result;
    }

    public static double[] removeDuplicates(double[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted(a));
    }

    public static double[] removeDuplicates(double[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static double[] removeDuplicates(double[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            double[] b = fromIndex == 0 && toIndex == a.length ? (double[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(a[i]);
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (double[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        double[] result = new double[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            double e = (Double)iterator.next();
            result[i++] = e;
        }
        return result;
    }

    public static String[] removeDuplicates(String[] a) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_STRING_ARRAY;
        }
        return N.removeDuplicates(a, N.isSorted((Comparable[])a));
    }

    public static String[] removeDuplicates(String[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return EMPTY_STRING_ARRAY;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static String[] removeDuplicates(String[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            String[] b = fromIndex == 0 && toIndex == a.length ? (String[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        Set<String> set = N.newLinkedHashSet(a.length);
        for (int i = fromIndex; i < toIndex; ++i) {
            set.add(a[i]);
        }
        if (set.size() == toIndex - fromIndex) {
            return fromIndex == 0 && toIndex == a.length ? (String[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
        }
        String[] result = new String[set.size()];
        int i = 0;
        for (String e : set) {
            result[i++] = e;
        }
        return result;
    }

    public static <T> T[] removeDuplicates(T[] a) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        return N.removeDuplicates(a, false);
    }

    public static <T> T[] removeDuplicates(T[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return a;
        }
        return N.removeDuplicates(a, 0, a.length, isSorted);
    }

    public static <T> T[] removeDuplicates(T[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) && fromIndex == 0 && toIndex == 0) {
            return a;
        }
        if (toIndex - fromIndex <= 1) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        if (isSorted) {
            T[] b = fromIndex == 0 && toIndex == a.length ? (Object[])a.clone() : N.copyOfRange(a, fromIndex, toIndex);
            int idx = 1;
            int len = b.length;
            for (int i = 1; i < len; ++i) {
                if (N.equals(b[i], b[i - 1])) continue;
                b[idx++] = b[i];
            }
            return idx == b.length ? b : N.copyOfRange(b, 0, idx);
        }
        List<Object> list = N.distinct(a, fromIndex, toIndex);
        return list.toArray((Object[])N.newArray(a.getClass().getComponentType(), list.size()));
    }

    public static boolean removeDuplicates(Collection<?> c) {
        return N.removeDuplicates(c, false);
    }

    public static boolean removeDuplicates(Collection<?> c, boolean isSorted) {
        boolean hasDuplicates;
        if (N.isNullOrEmpty(c) || c.size() == 1 || c instanceof Set) {
            return false;
        }
        if (c.size() == 2) {
            Iterator<?> iter = c.iterator();
            Object first = iter.next();
            if (N.equals(first, iter.next())) {
                iter.remove();
                return true;
            }
            return false;
        }
        if (isSorted) {
            boolean hasDuplicates2 = false;
            Iterator<?> it = c.iterator();
            Object pre = it.next();
            Object next = null;
            while (it.hasNext()) {
                next = it.next();
                if (N.equals(next, pre)) {
                    it.remove();
                    hasDuplicates2 = true;
                    continue;
                }
                pre = next;
            }
            return hasDuplicates2;
        }
        List<?> list = N.distinct(c);
        boolean bl = hasDuplicates = list.size() != c.size();
        if (hasDuplicates) {
            c.clear();
            c.addAll(list);
        }
        return hasDuplicates;
    }

    public static boolean[] replaceRange(boolean[] a, int fromIndex, int toIndex, boolean[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_BOOLEAN_ARRAY : (boolean[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        boolean[] result = new boolean[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static char[] replaceRange(char[] a, int fromIndex, int toIndex, char[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_CHAR_ARRAY : (char[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        char[] result = new char[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static byte[] replaceRange(byte[] a, int fromIndex, int toIndex, byte[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_BYTE_ARRAY : (byte[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        byte[] result = new byte[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static short[] replaceRange(short[] a, int fromIndex, int toIndex, short[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_SHORT_ARRAY : (short[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        short[] result = new short[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static int[] replaceRange(int[] a, int fromIndex, int toIndex, int[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_INT_ARRAY : (int[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        int[] result = new int[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static long[] replaceRange(long[] a, int fromIndex, int toIndex, long[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_LONG_ARRAY : (long[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        long[] result = new long[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static float[] replaceRange(float[] a, int fromIndex, int toIndex, float[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_FLOAT_ARRAY : (float[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        float[] result = new float[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static double[] replaceRange(double[] a, int fromIndex, int toIndex, double[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_DOUBLE_ARRAY : (double[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        double[] result = new double[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static String[] replaceRange(String[] a, int fromIndex, int toIndex, String[] replacement) {
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? EMPTY_STRING_ARRAY : (String[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        Object[] result = new String[len - (toIndex - fromIndex) + replacement.length];
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static <T> T[] replaceRange(T[] a, int fromIndex, int toIndex, T[] replacement) throws IllegalArgumentException {
        N.checkArgNotNull(a, "a");
        int len = N.len(a);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(replacement) ? a : (Object[])replacement.clone();
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(a, fromIndex, toIndex);
        }
        Object[] result = (Object[])CommonUtil.newArray(a.getClass().getComponentType(), len - (toIndex - fromIndex) + replacement.length);
        if (fromIndex > 0) {
            N.copy(a, 0, result, 0, fromIndex);
        }
        N.copy(replacement, 0, result, fromIndex, replacement.length);
        if (toIndex < len) {
            N.copy(a, toIndex, result, fromIndex + replacement.length, len - toIndex);
        }
        return result;
    }

    public static <T> boolean replaceRange(List<T> c, int fromIndex, int toIndex, Collection<? extends T> replacement) throws IllegalArgumentException {
        ArrayList<T> endList;
        N.checkArgNotNull(c, "c");
        int size = N.size(c);
        N.checkFromToIndex(fromIndex, toIndex, size);
        if (N.isNullOrEmpty(replacement)) {
            if (fromIndex == toIndex) {
                return false;
            }
            return N.deleteRange(c, fromIndex, toIndex);
        }
        ArrayList<T> arrayList = endList = toIndex < size ? new ArrayList<T>(c.subList(toIndex, size)) : null;
        if (fromIndex < size) {
            N.deleteRange(c, fromIndex, size);
        }
        c.addAll(replacement);
        if (N.notNullOrEmpty(endList)) {
            c.addAll(endList);
        }
        return true;
    }

    public static String replaceRange(String str, int fromIndex, int toIndex, String replacement) {
        int len = N.len(str);
        N.checkFromToIndex(fromIndex, toIndex, len);
        if (N.isNullOrEmpty(str)) {
            return N.isNullOrEmpty(replacement) ? str : replacement;
        }
        if (N.isNullOrEmpty(replacement)) {
            return N.deleteRange(str, fromIndex, toIndex);
        }
        char[] a = InternalUtil.getCharsForReadOnly(str);
        char[] tmp = N.replaceRange(a, fromIndex, toIndex, InternalUtil.getCharsForReadOnly(replacement));
        return InternalUtil.newString(tmp, true);
    }

    public static boolean hasDuplicates(char[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(char[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(char[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(Character.valueOf(a[i]))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(byte[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(byte[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(byte[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(short[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(short[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(short[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(int[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(int[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(int[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(long[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(long[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(long[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return a[fromIndex] == a[fromIndex + 1];
        }
        if (toIndex - fromIndex == 3) {
            return a[fromIndex] == a[fromIndex + 1] || a[fromIndex] == a[fromIndex + 2] || a[fromIndex + 1] == a[fromIndex + 2];
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (a[i] != a[i - 1]) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(float[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(float[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(float[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return N.equals(a[fromIndex], a[fromIndex + 1]);
        }
        if (toIndex - fromIndex == 3) {
            return N.equals(a[fromIndex], a[fromIndex + 1]) || N.equals(a[fromIndex], a[fromIndex + 2]) || N.equals(a[fromIndex + 1], a[fromIndex + 2]);
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (!N.equals(a[i], a[i - 1])) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(Float.valueOf(a[i]))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(double[] a) {
        return N.hasDuplicates(a, false);
    }

    public static boolean hasDuplicates(double[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static boolean hasDuplicates(double[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return N.equals(a[fromIndex], a[fromIndex + 1]);
        }
        if (toIndex - fromIndex == 3) {
            return N.equals(a[fromIndex], a[fromIndex + 1]) || N.equals(a[fromIndex], a[fromIndex + 2]) || N.equals(a[fromIndex + 1], a[fromIndex + 2]);
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (!N.equals(a[i], a[i - 1])) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(a[i])) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean hasDuplicates(T[] a) {
        return N.hasDuplicates(a, false);
    }

    public static <T> boolean hasDuplicates(T[] a, boolean isSorted) {
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        return N.hasDuplicates(a, 0, a.length, isSorted);
    }

    static <T> boolean hasDuplicates(T[] a, int fromIndex, int toIndex, boolean isSorted) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 2) {
            return false;
        }
        if (toIndex - fromIndex == 2) {
            return N.equals(a[fromIndex], a[fromIndex + 1]);
        }
        if (toIndex - fromIndex == 3) {
            return N.equals(a[fromIndex], a[fromIndex + 1]) || N.equals(a[fromIndex], a[fromIndex + 2]) || N.equals(a[fromIndex + 1], a[fromIndex + 2]);
        }
        if (isSorted) {
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                if (!N.equals(a[i], a[i - 1])) continue;
                return true;
            }
            return false;
        }
        Set set = N.newHashSet(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (set.add(N.hashKey(a[i]))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDuplicates(Collection<?> c) {
        return N.hasDuplicates(c, false);
    }

    public static boolean hasDuplicates(Collection<?> c, boolean isSorted) {
        if (N.isNullOrEmpty(c) || c.size() == 1) {
            return false;
        }
        if (isSorted) {
            Iterator<?> it = c.iterator();
            Object pre = it.next();
            Object next = null;
            while (it.hasNext()) {
                next = it.next();
                if (N.equals(next, pre)) {
                    return true;
                }
                pre = next;
            }
            return false;
        }
        Set set = N.newHashSet(c.size());
        for (Object e : c) {
            if (set.add(N.hashKey(e))) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean retainAll(Collection<T> c, Collection<? extends T> objsToKeep) {
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        if (N.isNullOrEmpty(objsToKeep)) {
            c.clear();
            return true;
        }
        if (c instanceof HashSet && !(objsToKeep instanceof Set) && (c.size() > 9 || objsToKeep.size() > 9)) {
            return c.retainAll(N.newHashSet(objsToKeep));
        }
        return c.retainAll(objsToKeep);
    }

    static Object hashKey(Object obj) {
        return obj == null || !obj.getClass().isArray() ? obj : Wrapper.of(obj);
    }

    @SafeVarargs
    public static int sum(char ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(char[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static int sum(byte ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(byte[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static int sum(short ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(short[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static int sum(int ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sum(a, 0, a.length);
    }

    public static int sum(int[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static long sum(long ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0L;
        }
        return N.sum(a, 0, a.length);
    }

    public static long sum(long[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0L;
        }
        long sum = 0L;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += a[i];
        }
        return sum;
    }

    @SafeVarargs
    public static float sum(float ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0f;
        }
        return N.sum(a, 0, a.length);
    }

    public static float sum(float[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0f;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(a[i]);
        }
        return (float)summation.sum();
    }

    @SafeVarargs
    public static double sum(double ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.sum(a, 0, a.length);
    }

    public static double sum(double[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(a[i]);
        }
        return summation.sum();
    }

    @SafeVarargs
    public static double average(char ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(char[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sum(a, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    @SafeVarargs
    public static double average(byte ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(byte[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sum(a, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    @SafeVarargs
    public static double average(short ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(short[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sum(a, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    @SafeVarargs
    public static double average(int ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(int[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sum(a, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    @SafeVarargs
    public static double average(long ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(long[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sum(a, fromIndex, toIndex) / (double)(toIndex - fromIndex);
    }

    @SafeVarargs
    public static double average(float ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(float[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(a[i]);
        }
        return summation.average().orZero();
    }

    @SafeVarargs
    public static double average(double ... a) {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.average(a, 0, a.length);
    }

    public static double average(double[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(a[i]);
        }
        return summation.average().orZero();
    }

    public static char min(char a, char b) {
        return a <= b ? a : b;
    }

    public static byte min(byte a, byte b) {
        return a <= b ? a : b;
    }

    public static short min(short a, short b) {
        return a <= b ? a : b;
    }

    public static int min(int a, int b) {
        return a <= b ? a : b;
    }

    public static long min(long a, long b) {
        return a <= b ? a : b;
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static <T extends Comparable<? super T>> T min(T a, T b) {
        return (T)((Comparable)((Object)N.min(a, b, NULL_MAX_COMPARATOR)));
    }

    public static <T> T min(T a, T b, Comparator<? super T> cmp) {
        return (cmp == null ? NULL_MAX_COMPARATOR : cmp).compare(a, b) <= 0 ? a : b;
    }

    public static char min(char a, char b, char c) {
        char m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static byte min(byte a, byte b, byte c) {
        byte m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static short min(short a, short b, short c) {
        short m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static int min(int a, int b, int c) {
        int m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static long min(long a, long b, long c) {
        long m = a <= b ? a : b;
        return m <= c ? m : c;
    }

    public static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public static double min(double a, double b, double c) {
        return Math.min(Math.min(a, b), c);
    }

    public static <T extends Comparable<? super T>> T min(T a, T b, T c) {
        return N.min(a, b, c, NULL_MAX_COMPARATOR);
    }

    public static <T> T min(T a, T b, T c, Comparator<? super T> cmp) {
        return (T)N.min(N.min(a, b, cmp), c, cmp);
    }

    @SafeVarargs
    public static char min(char ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        if (N.isNullOrEmpty(a)) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return N.min(a, 0, a.length);
    }

    public static char min(char[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        char min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static byte min(byte ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static byte min(byte[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        byte min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static short min(short ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static short min(short[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        short min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static int min(int ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static int min(int[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        int min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static long min(long ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static long min(long[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        long min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
        }
        return min;
    }

    @SafeVarargs
    public static float min(float ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static float min(float[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        float min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (!Float.isNaN(min = Math.min(min, a[i]))) continue;
            return min;
        }
        return min;
    }

    @SafeVarargs
    public static double min(double ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length);
    }

    public static double min(double[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        double min = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (!Double.isNaN(min = Math.min(min, a[i]))) continue;
            return min;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T min(T[] a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, false, a.length);
    }

    public static <T extends Comparable<? super T>> T min(T[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        return (T)((Comparable)N.min(a, fromIndex, toIndex, NULL_MAX_COMPARATOR));
    }

    public static <T> T min(T[] a, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.min(a, 0, a.length, cmp);
    }

    public static <T> T min(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        T candidate = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (cmp.compare(a[i], candidate) < 0) {
                candidate = a[i];
            }
            if (candidate != null || cmp != NULL_MIN_COMPARATOR) continue;
            return null;
        }
        return candidate;
    }

    public static <T extends Comparable<? super T>> T min(Collection<? extends T> c) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.min(c, 0, c.size());
    }

    public static <T extends Comparable<? super T>> T min(Collection<? extends T> c, int fromIndex, int toIndex) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return (T)((Comparable)N.min(c, fromIndex, toIndex, NULL_MAX_COMPARATOR));
    }

    public static <T> T min(Collection<? extends T> c, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.min(c, 0, c.size(), cmp);
    }

    public static <T> T min(Collection<? extends T> c, int fromIndex, int toIndex, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) || toIndex - fromIndex < 1 || fromIndex >= c.size()) {
            throw new IllegalArgumentException("The size of collection can not be null or empty");
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        Object candidate = null;
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            candidate = list.get(fromIndex);
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                e = list.get(i);
                if (cmp.compare(e, candidate) < 0) {
                    candidate = e;
                }
                if (candidate != null || cmp != NULL_MIN_COMPARATOR) continue;
                return null;
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < toIndex; ++i) {
                if (i < fromIndex) {
                    it.next();
                    continue;
                }
                if (i == fromIndex) {
                    candidate = it.next();
                    continue;
                }
                e = it.next();
                if (cmp.compare(e, candidate) < 0) {
                    candidate = e;
                }
                if (candidate != null || cmp != NULL_MIN_COMPARATOR) continue;
                return null;
            }
        }
        return candidate;
    }

    public static <T extends Comparable<? super T>> List<T> minAll(T[] a) {
        return N.minAll(a, NULL_MAX_COMPARATOR);
    }

    public static <T> List<T> minAll(T[] a, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        ArrayList<T> result = new ArrayList<T>();
        T candicate = a[0];
        int cp = 0;
        result.add(candicate);
        int len = a.length;
        for (int i = 1; i < len; ++i) {
            cp = cmp.compare(a[i], candicate);
            if (cp == 0) {
                result.add(a[i]);
                continue;
            }
            if (cp >= 0) continue;
            result.clear();
            result.add(a[i]);
            candicate = a[i];
        }
        return result;
    }

    public static <T extends Comparable<? super T>> List<T> minAll(Collection<T> c) {
        return N.minAll(c, NULL_MAX_COMPARATOR);
    }

    public static <T> List<T> minAll(Collection<T> c, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.minAll(c.iterator(), cmp);
    }

    public static <T extends Comparable<? super T>> List<T> minAll(Iterator<? extends T> iter) {
        return N.maxAll(iter, NULL_MAX_COMPARATOR);
    }

    public static <T> List<T> minAll(Iterator<? extends T> iter, Comparator<? super T> cmp) {
        cmp = cmp == null ? NULL_MAX_COMPARATOR : cmp;
        ArrayList<T> result = new ArrayList<T>();
        T candicate = iter.next();
        Object next = null;
        int cp = 0;
        result.add(candicate);
        while (iter.hasNext()) {
            next = iter.next();
            cp = cmp.compare(next, candicate);
            if (cp == 0) {
                result.add(next);
                continue;
            }
            if (cp >= 0) continue;
            result.clear();
            result.add(next);
            candicate = next;
        }
        return result;
    }

    public static char max(char a, char b) {
        return a >= b ? a : b;
    }

    public static byte max(byte a, byte b) {
        return a >= b ? a : b;
    }

    public static short max(short a, short b) {
        return a >= b ? a : b;
    }

    public static int max(int a, int b) {
        return a >= b ? a : b;
    }

    public static long max(long a, long b) {
        return a >= b ? a : b;
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static <T extends Comparable<? super T>> T max(T a, T b) {
        return (T)((Comparable)((Object)N.max(a, b, NULL_MIN_COMPARATOR)));
    }

    public static <T> T max(T a, T b, Comparator<? super T> cmp) {
        return (cmp == null ? NULL_MIN_COMPARATOR : cmp).compare(a, b) >= 0 ? a : b;
    }

    public static char max(char a, char b, char c) {
        char m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static byte max(byte a, byte b, byte c) {
        byte m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static short max(short a, short b, short c) {
        short m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static int max(int a, int b, int c) {
        int m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static long max(long a, long b, long c) {
        long m = a >= b ? a : b;
        return m >= c ? m : c;
    }

    public static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static <T extends Comparable<? super T>> T max(T a, T b, T c) {
        return N.max(a, b, c, NULL_MIN_COMPARATOR);
    }

    public static <T> T max(T a, T b, T c, Comparator<? super T> cmp) {
        return (T)N.max(N.max(a, b, cmp), c, cmp);
    }

    @SafeVarargs
    public static char max(char ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static char max(char[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        char max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static byte max(byte ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static byte max(byte[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        byte max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static short max(short ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static short max(short[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        short max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static int max(int ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static int max(int[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        int max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static long max(long ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static long max(long[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        long max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    @SafeVarargs
    public static float max(float ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static float max(float[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        float max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (!Float.isNaN(max = Math.max(max, a[i]))) continue;
            return max;
        }
        return max;
    }

    @SafeVarargs
    public static double max(double ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length);
    }

    public static double max(double[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        double max = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (!Double.isNaN(max = Math.max(max, a[i]))) continue;
            return max;
        }
        return max;
    }

    public static <T extends Comparable<? super T>> T max(T[] a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, false, a.length);
    }

    public static <T extends Comparable<? super T>> T max(T[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        return (T)((Comparable)N.max(a, fromIndex, toIndex, NULL_MIN_COMPARATOR));
    }

    public static <T> T max(T[] a, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.max(a, 0, a.length, cmp);
    }

    public static <T> T max(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        T candidate = a[fromIndex];
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            if (cmp.compare(a[i], candidate) > 0) {
                candidate = a[i];
            }
            if (candidate != null || cmp != NULL_MAX_COMPARATOR) continue;
            return null;
        }
        return candidate;
    }

    public static <T extends Comparable<? super T>> T max(Collection<? extends T> c) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.max(c, 0, c.size());
    }

    public static <T extends Comparable<? super T>> T max(Collection<? extends T> c, int fromIndex, int toIndex) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return (T)((Comparable)N.max(c, fromIndex, toIndex, NULL_MIN_COMPARATOR));
    }

    public static <T> T max(Collection<? extends T> c, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.max(c, 0, c.size(), cmp);
    }

    public static <T> T max(Collection<? extends T> c, int fromIndex, int toIndex, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) || toIndex - fromIndex < 1 || fromIndex >= c.size()) {
            throw new IllegalArgumentException("The size of collection can not be null or empty");
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        Object candidate = null;
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            candidate = list.get(fromIndex);
            for (int i = fromIndex + 1; i < toIndex; ++i) {
                e = list.get(i);
                if (cmp.compare(e, candidate) > 0) {
                    candidate = e;
                }
                if (candidate != null || cmp != NULL_MAX_COMPARATOR) continue;
                return null;
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < toIndex; ++i) {
                if (i < fromIndex) {
                    it.next();
                    continue;
                }
                if (i == fromIndex) {
                    candidate = it.next();
                } else {
                    e = it.next();
                    if (cmp.compare(e, candidate) > 0) {
                        candidate = e;
                    }
                }
                if (candidate != null || cmp != NULL_MAX_COMPARATOR) continue;
                return null;
            }
        }
        return candidate;
    }

    public static <T extends Comparable<? super T>> List<T> maxAll(T[] a) {
        return N.maxAll(a, NULL_MIN_COMPARATOR);
    }

    public static <T> List<T> maxAll(T[] a, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        ArrayList<T> result = new ArrayList<T>();
        T candicate = a[0];
        int cp = 0;
        result.add(candicate);
        int len = a.length;
        for (int i = 1; i < len; ++i) {
            cp = cmp.compare(a[i], candicate);
            if (cp == 0) {
                result.add(a[i]);
                continue;
            }
            if (cp <= 0) continue;
            result.clear();
            result.add(a[i]);
            candicate = a[i];
        }
        return result;
    }

    public static <T extends Comparable<? super T>> List<T> maxAll(Collection<? extends T> c) {
        return N.maxAll(c, NULL_MIN_COMPARATOR);
    }

    public static <T> List<T> maxAll(Collection<? extends T> c, Comparator<? super T> cmp) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.maxAll(c.iterator(), cmp);
    }

    public static <T extends Comparable<? super T>> List<T> maxAll(Iterator<? extends T> iter) {
        return N.maxAll(iter, NULL_MIN_COMPARATOR);
    }

    public static <T> List<T> maxAll(Iterator<? extends T> iter, Comparator<? super T> cmp) {
        cmp = cmp == null ? NULL_MIN_COMPARATOR : cmp;
        ArrayList<T> result = new ArrayList<T>();
        T candicate = iter.next();
        Object next = null;
        int cp = 0;
        result.add(candicate);
        while (iter.hasNext()) {
            next = iter.next();
            cp = cmp.compare(next, candicate);
            if (cp == 0) {
                result.add(next);
                continue;
            }
            if (cp <= 0) continue;
            result.clear();
            result.add(next);
            candicate = next;
        }
        return result;
    }

    public static char median(char a, char b, char c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static byte median(byte a, byte b, byte c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static short median(short a, short b, short c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static int median(int a, int b, int c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static long median(long a, long b, long c) {
        if (a >= b && a <= c || a >= c && a <= b) {
            return a;
        }
        if (b >= a && b <= c || b >= c && b <= a) {
            return b;
        }
        return c;
    }

    public static float median(float a, float b, float c) {
        int ab = Float.compare(a, b);
        int ac = Float.compare(a, c);
        int bc = 0;
        if (ab >= 0 && ac <= 0 || ac >= 0 && ab <= 0) {
            return a;
        }
        bc = Float.compare(b, c);
        if (bc <= 0 && ab <= 0 || bc >= 0 && ab >= 0) {
            return b;
        }
        return c;
    }

    public static double median(double a, double b, double c) {
        int ab = Double.compare(a, b);
        int ac = Double.compare(a, c);
        int bc = 0;
        if (ab >= 0 && ac <= 0 || ac >= 0 && ab <= 0) {
            return a;
        }
        bc = Double.compare(b, c);
        if (bc <= 0 && ab <= 0 || bc >= 0 && ab >= 0) {
            return b;
        }
        return c;
    }

    public static <T extends Comparable<? super T>> T median(T a, T b, T c) {
        return N.median(a, b, c, NATURAL_ORDER);
    }

    public static <T> T median(T a, T b, T c, Comparator<? super T> cmp) {
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int ab = cmp.compare(a, b);
        int ac = cmp.compare(a, c);
        int bc = 0;
        if (ab >= 0 && ac <= 0 || ac >= 0 && ab <= 0) {
            return a;
        }
        bc = cmp.compare(b, c);
        if (bc <= 0 && ab <= 0 || bc >= 0 && ab >= 0) {
            return b;
        }
        return c;
    }

    @SafeVarargs
    public static char median(char ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static char median(char[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    @SafeVarargs
    public static byte median(byte ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static byte median(byte[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    @SafeVarargs
    public static short median(short ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static short median(short[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    @SafeVarargs
    public static int median(int ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static int median(int[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    @SafeVarargs
    public static long median(long ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static long median(long[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    @SafeVarargs
    public static float median(float ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static float median(float[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    @SafeVarargs
    public static double median(double ... a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length);
    }

    public static double median(double[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        int len = toIndex - fromIndex;
        if (len == 1) {
            return a[fromIndex];
        }
        if (len == 2) {
            return N.min(a[fromIndex], a[fromIndex + 1]);
        }
        if (len == 3) {
            return N.median(a[fromIndex], a[fromIndex + 1], a[fromIndex + 2]);
        }
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1);
    }

    public static <T extends Comparable<? super T>> T median(T[] a) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, false, a.length);
    }

    public static <T extends Comparable<? super T>> T median(T[] a, int fromIndex, int toIndex) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return (T)((Comparable)N.median(a, fromIndex, toIndex, NATURAL_ORDER));
    }

    public static <T> T median(T[] a, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.median(a, 0, a.length, cmp);
    }

    public static <T> T median(T[] a, int fromIndex, int toIndex, Comparator<? super T> cmp) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a.length);
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int len = toIndex - fromIndex;
        return N.kthLargest(a, fromIndex, toIndex, len / 2 + 1, cmp);
    }

    public static <T extends Comparable<? super T>> T median(Collection<? extends T> c) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.median(c, 0, c.size());
    }

    public static <T extends Comparable<? super T>> T median(Collection<? extends T> c, int fromIndex, int toIndex) throws IllegalArgumentException {
        return (T)((Comparable)N.median(c, fromIndex, toIndex, NATURAL_ORDER));
    }

    public static <T> T median(Collection<? extends T> c, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.median(c, 0, c.size(), cmp);
    }

    public static <T> T median(Collection<? extends T> c, int fromIndex, int toIndex, Comparator<? super T> cmp) throws IllegalArgumentException {
        if (N.isNullOrEmpty(c) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The length of collection can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, c.size());
        cmp = cmp == null ? NATURAL_ORDER : cmp;
        int len = toIndex - fromIndex;
        return N.kthLargest(c, fromIndex, toIndex, len / 2 + 1, cmp);
    }

    public static char kthLargest(char[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static char kthLargest(char[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Character.valueOf(a[i]));
                    continue;
                }
                if (a[i] <= ((Character)queue.peek()).charValue()) continue;
                queue.remove();
                queue.add(Character.valueOf(a[i]));
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Character>(k, new Comparator<Character>(){

                @Override
                public int compare(Character o1, Character o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Character.valueOf(a[i]));
                    continue;
                }
                if (a[i] >= ((Character)queue.peek()).charValue()) continue;
                queue.remove();
                queue.add(Character.valueOf(a[i]));
            }
        }
        return ((Character)queue.peek()).charValue();
    }

    public static byte kthLargest(byte[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static byte kthLargest(byte[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Byte)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Byte>(k, new Comparator<Byte>(){

                @Override
                public int compare(Byte o1, Byte o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Byte)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Byte)queue.peek();
    }

    public static short kthLargest(short[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static short kthLargest(short[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Short)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Short>(k, new Comparator<Short>(){

                @Override
                public int compare(Short o1, Short o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Short)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Short)queue.peek();
    }

    public static int kthLargest(int[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static int kthLargest(int[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Integer)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Integer>(k, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Integer)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Integer)queue.peek();
    }

    public static long kthLargest(long[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static long kthLargest(long[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] <= (Long)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Long>(k, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (a[i] >= (Long)queue.peek()) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Long)queue.peek();
    }

    public static float kthLargest(float[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static float kthLargest(float[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Float.valueOf(a[i]));
                    continue;
                }
                if (Float.compare(a[i], ((Float)queue.peek()).floatValue()) <= 0) continue;
                queue.remove();
                queue.add(Float.valueOf(a[i]));
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Float>(k, new Comparator<Float>(){

                @Override
                public int compare(Float o1, Float o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(Float.valueOf(a[i]));
                    continue;
                }
                if (Float.compare(a[i], ((Float)queue.peek()).floatValue()) >= 0) continue;
                queue.remove();
                queue.add(Float.valueOf(a[i]));
            }
        }
        return ((Float)queue.peek()).floatValue();
    }

    public static double kthLargest(double[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k);
    }

    public static double kthLargest(double[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue(k);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (Double.compare(a[i], (Double)queue.peek()) <= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue<Double>(k, new Comparator<Double>(){

                @Override
                public int compare(Double o1, Double o2) {
                    return o2.compareTo(o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (Double.compare(a[i], (Double)queue.peek()) >= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (Double)queue.peek();
    }

    public static <T extends Comparable<? super T>> T kthLargest(T[] a, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return (T)N.kthLargest(a, (int)0, (int)a.length, (int)k);
    }

    public static <T extends Comparable<? super T>> T kthLargest(T[] a, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        return (T)((Comparable)N.kthLargest(a, fromIndex, toIndex, k, Comparators.naturalOrder()));
    }

    public static <T> T kthLargest(T[] a, int k, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(a, "The spcified array can not be null or empty");
        return N.kthLargest(a, 0, a.length, k, cmp);
    }

    public static <T> T kthLargest(T[] a, int fromIndex, int toIndex, int k, Comparator<? super T> cmp) throws IllegalArgumentException {
        if (N.isNullOrEmpty(a) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The spcified array can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, a == null ? 0 : a.length);
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        final Comparator<T> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(a, fromIndex, toIndex, comparator);
        }
        if (k == len) {
            return N.min(a, fromIndex, toIndex, comparator);
        }
        PriorityQueue<Object> queue = null;
        if (k <= len / 2) {
            queue = new PriorityQueue<T>(k, comparator);
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (comparator.compare(a[i], queue.peek()) <= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        } else {
            k = len - k + 1;
            queue = new PriorityQueue(k, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return comparator.compare(o2, o1);
                }
            });
            for (int i = fromIndex; i < toIndex; ++i) {
                if (queue.size() < k) {
                    queue.add(a[i]);
                    continue;
                }
                if (comparator.compare(a[i], queue.peek()) >= 0) continue;
                queue.remove();
                queue.add(a[i]);
            }
        }
        return (T)queue.peek();
    }

    public static <T extends Comparable<? super T>> T kthLargest(Collection<? extends T> c, int k) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.kthLargest(c, 0, c.size(), k);
    }

    public static <T extends Comparable<? super T>> T kthLargest(Collection<? extends T> c, int fromIndex, int toIndex, int k) throws IllegalArgumentException {
        if (N.isNullOrEmpty(c) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The length of collection can not be null or empty");
        }
        return (T)((Comparable)N.kthLargest(c, fromIndex, toIndex, k, Comparators.naturalOrder()));
    }

    public static <T> T kthLargest(Collection<? extends T> c, int k, Comparator<? super T> cmp) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(c, "The spcified collection can not be null or empty");
        return N.kthLargest(c, 0, c.size(), k, cmp);
    }

    public static <T> T kthLargest(Collection<? extends T> c, int fromIndex, int toIndex, int k, Comparator<? super T> cmp) throws IllegalArgumentException {
        if (N.isNullOrEmpty(c) || toIndex - fromIndex < 1) {
            throw new IllegalArgumentException("The length of collection can not be null or empty");
        }
        N.checkFromToIndex(fromIndex, toIndex, c == null ? 0 : c.size());
        N.checkArgument(k > 0 && k <= toIndex - fromIndex, "'k' (%s) is out of range %s", k, toIndex - fromIndex);
        final Comparator comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        int len = toIndex - fromIndex;
        if (k == 1) {
            return N.max(c, fromIndex, toIndex, comparator);
        }
        if (k == len) {
            return N.min(c, fromIndex, toIndex, comparator);
        }
        Iterator<T> iter = c.iterator();
        PriorityQueue queue = null;
        if (k <= len / 2) {
            int cursor;
            queue = new PriorityQueue(k);
            for (cursor = 0; cursor < fromIndex && iter.hasNext(); ++cursor) {
                iter.next();
            }
            Object e = null;
            while (cursor < toIndex && iter.hasNext()) {
                e = iter.next();
                if (queue.size() < k) {
                    queue.add(e);
                } else if (comparator.compare(e, queue.peek()) > 0) {
                    queue.remove();
                    queue.add(e);
                }
                ++cursor;
            }
        } else {
            int cursor;
            k = len - k + 1;
            queue = new PriorityQueue(k, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return comparator.compare(o2, o1);
                }
            });
            for (cursor = 0; cursor < fromIndex && iter.hasNext(); ++cursor) {
                iter.next();
            }
            Object e = null;
            while (cursor < toIndex && iter.hasNext()) {
                e = iter.next();
                if (queue.size() < k) {
                    queue.add(e);
                } else if (comparator.compare(e, queue.peek()) < 0) {
                    queue.remove();
                    queue.add(e);
                }
                ++cursor;
            }
        }
        return (T)queue.peek();
    }

    public static Map<Percentage, Character> percentiles(char[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Character> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, Character.valueOf(sortedArray[(int)((double)len * p.doubleValue())]));
        }
        return m;
    }

    public static Map<Percentage, Byte> percentiles(byte[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Byte> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return m;
    }

    public static Map<Percentage, Short> percentiles(short[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Short> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return m;
    }

    public static Map<Percentage, Integer> percentiles(int[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Integer> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return m;
    }

    public static Map<Percentage, Long> percentiles(long[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Long> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return m;
    }

    public static Map<Percentage, Float> percentiles(float[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Float> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, Float.valueOf(sortedArray[(int)((double)len * p.doubleValue())]));
        }
        return m;
    }

    public static Map<Percentage, Double> percentiles(double[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, Double> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return m;
    }

    public static <T> Map<Percentage, T> percentiles(T[] sortedArray) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedArray, "The spcified 'sortedArray' can not be null or empty");
        int len = sortedArray.length;
        Map<Percentage, T> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedArray[(int)((double)len * p.doubleValue())]);
        }
        return m;
    }

    public static <T> Map<Percentage, T> percentiles(List<T> sortedList) throws IllegalArgumentException {
        N.checkArgNotNullOrEmpty(sortedList, "The spcified 'sortedList' can not be null or empty");
        int size = sortedList.size();
        Map<Percentage, T> m = N.newLinkedHashMap(Percentage.values().length);
        for (Percentage p : Percentage.values()) {
            m.put(p, sortedList.get((int)((double)size * p.doubleValue())));
        }
        return m;
    }

    public static <T extends Number> int sumInt(T[] a) {
        return N.sumInt(a, Fn.numToInt());
    }

    public static <T extends Number> int sumInt(T[] a, int fromIndex, int toIndex) {
        return N.sumInt(a, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> int sumInt(T[] a, Throwables.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.sumInt(a, 0, a.length, func);
    }

    public static <T, E extends Exception> int sumInt(T[] a, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += func.applyAsInt(a[i]);
        }
        return sum;
    }

    public static <T extends Number> int sumInt(Collection<? extends T> c) {
        return N.sumInt(c, Fn.numToInt());
    }

    public static <T extends Number> int sumInt(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.sumInt(c, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> int sumInt(Collection<? extends T> c, Throwables.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        int sum = 0;
        for (T e : c) {
            sum += func.applyAsInt(e);
        }
        return sum;
    }

    public static <T, E extends Exception> int sumInt(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0;
        }
        int sum = 0;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                sum += func.applyAsInt(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                sum += func.applyAsInt(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return sum;
    }

    public static <T extends Number> long sumLong(T[] a) {
        return N.sumLong(a, Fn.numToLong());
    }

    public static <T extends Number> long sumLong(T[] a, int fromIndex, int toIndex) {
        return N.sumLong(a, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> long sumLong(T[] a, Throwables.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0L;
        }
        return N.sumLong(a, 0, a.length, func);
    }

    public static <T, E extends Exception> long sumLong(T[] a, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0L;
        }
        long sum = 0L;
        for (int i = fromIndex; i < toIndex; ++i) {
            sum += func.applyAsLong(a[i]);
        }
        return sum;
    }

    public static <T extends Number> long sumLong(Collection<? extends T> c) {
        return N.sumLong(c, Fn.numToLong());
    }

    public static <T extends Number> long sumLong(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.sumLong(c, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> long sumLong(Collection<? extends T> c, Throwables.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0L;
        }
        long sum = 0L;
        for (T e : c) {
            sum += func.applyAsLong(e);
        }
        return sum;
    }

    public static <T, E extends Exception> long sumLong(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0L;
        }
        long sum = 0L;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                sum += func.applyAsLong(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                sum += func.applyAsLong(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return sum;
    }

    public static <T extends Number> double sumDouble(T[] a) {
        return N.sumDouble(a, Fn.numToDouble());
    }

    public static <T extends Number> double sumDouble(T[] a, int fromIndex, int toIndex) {
        return N.sumDouble(a, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> double sumDouble(T[] a, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.sumDouble(a, 0, a.length, func);
    }

    public static <T, E extends Exception> double sumDouble(T[] a, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (int i = fromIndex; i < toIndex; ++i) {
            summation.add(func.applyAsDouble(a[i]));
        }
        return summation.sum();
    }

    public static <T extends Number> double sumDouble(Collection<? extends T> c) {
        return N.sumDouble(c, Fn.numToDouble());
    }

    public static <T extends Number> double sumDouble(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.sumDouble(c, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> double sumDouble(Collection<? extends T> c, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        for (T e : c) {
            summation.add(func.applyAsDouble(e));
        }
        return summation.sum();
    }

    public static <T, E extends Exception> double sumDouble(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        KahanSummation summation = new KahanSummation();
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                summation.add(func.applyAsDouble(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                summation.add(func.applyAsDouble(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return summation.sum();
    }

    public static <T extends Number> double averageInt(T[] a) {
        return N.averageInt(a, Fn.numToInt());
    }

    public static <T extends Number> double averageInt(T[] a, int fromIndex, int toIndex) {
        return N.averageInt(a, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> double averageInt(T[] a, Throwables.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.averageInt(a, 0, a.length, func);
    }

    public static <T, E extends Exception> double averageInt(T[] a, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sumInt(a, fromIndex, toIndex, func) / (double)(toIndex - fromIndex);
    }

    public static <T extends Number> double averageInt(Collection<? extends T> c) {
        return N.averageInt(c, Fn.numToInt());
    }

    public static <T extends Number> double averageInt(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.averageInt(c, fromIndex, toIndex, Fn.numToInt());
    }

    public static <T, E extends Exception> double averageInt(Collection<? extends T> c, Throwables.ToIntFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0.0;
        }
        return (double)N.sumInt(c, func) / (double)c.size();
    }

    public static <T, E extends Exception> double averageInt(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sumInt(c, fromIndex, toIndex, func) / (double)(toIndex - fromIndex);
    }

    public static <T extends Number> double averageLong(T[] a) {
        return N.averageLong(a, Fn.numToLong());
    }

    public static <T extends Number> double averageLong(T[] a, int fromIndex, int toIndex) {
        return N.averageLong(a, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> double averageLong(T[] a, Throwables.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.averageLong(a, 0, a.length, func);
    }

    public static <T, E extends Exception> double averageLong(T[] a, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sumLong(a, fromIndex, toIndex, func) / (double)(toIndex - fromIndex);
    }

    public static <T extends Number> double averageLong(Collection<? extends T> c) {
        return N.averageLong(c, Fn.numToLong());
    }

    public static <T extends Number> double averageLong(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.averageLong(c, fromIndex, toIndex, Fn.numToLong());
    }

    public static <T, E extends Exception> double averageLong(Collection<? extends T> c, Throwables.ToLongFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0.0;
        }
        return (double)N.sumLong(c, func) / (double)c.size();
    }

    public static <T, E extends Exception> double averageLong(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        return (double)N.sumLong(c, fromIndex, toIndex, func) / (double)(toIndex - fromIndex);
    }

    public static <T extends Number> double averageDouble(T[] a) {
        return N.averageDouble(a, Fn.numToDouble());
    }

    public static <T extends Number> double averageDouble(T[] a, int fromIndex, int toIndex) {
        return N.averageDouble(a, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> double averageDouble(T[] a, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(a)) {
            return 0.0;
        }
        return N.averageDouble(a, 0, a.length, func);
    }

    public static <T, E extends Exception> double averageDouble(T[] a, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        return Iterables.averageDouble(a, fromIndex, toIndex, func).orZero();
    }

    public static <T extends Number> double averageDouble(Collection<? extends T> c) {
        return N.averageDouble(c, Fn.numToDouble());
    }

    public static <T extends Number> double averageDouble(Collection<? extends T> c, int fromIndex, int toIndex) {
        return N.averageDouble(c, fromIndex, toIndex, Fn.numToDouble());
    }

    public static <T, E extends Exception> double averageDouble(Collection<? extends T> c, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        if (N.isNullOrEmpty(c)) {
            return 0.0;
        }
        return Iterables.averageDouble(c, func).orZero();
    }

    public static <T, E extends Exception> double averageDouble(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (fromIndex == toIndex) {
            return 0.0;
        }
        return Iterables.averageDouble(c, fromIndex, toIndex, func).orZero();
    }

    public static short[] top(short[] a, int n) {
        return N.top(a, n, null);
    }

    public static short[] top(short[] a, int n, Comparator<? super Short> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static short[] top(short[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static short[] top(short[] a, int fromIndex, int toIndex, int n, Comparator<? super Short> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Short> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Short> heap = new PriorityQueue<Short>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Short)heap.peek(), (Short)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Short)a[i]);
                continue;
            }
            heap.offer((Short)a[i]);
        }
        Iterator iter = heap.iterator();
        short[] res = new short[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Short)iter.next();
        }
        return res;
    }

    public static int[] top(int[] a, int n) {
        return N.top(a, n, null);
    }

    public static int[] top(int[] a, int n, Comparator<? super Integer> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static int[] top(int[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static int[] top(int[] a, int fromIndex, int toIndex, int n, Comparator<? super Integer> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Integer> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Integer> heap = new PriorityQueue<Integer>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Integer)heap.peek(), (Integer)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Integer)a[i]);
                continue;
            }
            heap.offer((Integer)a[i]);
        }
        Iterator iter = heap.iterator();
        int[] res = new int[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Integer)iter.next();
        }
        return res;
    }

    public static long[] top(long[] a, int n) {
        return N.top(a, n, null);
    }

    public static long[] top(long[] a, int n, Comparator<? super Long> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static long[] top(long[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static long[] top(long[] a, int fromIndex, int toIndex, int n, Comparator<? super Long> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Long> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Long> heap = new PriorityQueue<Long>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Long)heap.peek(), (Long)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Long)a[i]);
                continue;
            }
            heap.offer((Long)a[i]);
        }
        Iterator iter = heap.iterator();
        long[] res = new long[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Long)iter.next();
        }
        return res;
    }

    public static float[] top(float[] a, int n) {
        return N.top(a, n, null);
    }

    public static float[] top(float[] a, int n, Comparator<? super Float> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static float[] top(float[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static float[] top(float[] a, int fromIndex, int toIndex, int n, Comparator<? super Float> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Float> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Float> heap = new PriorityQueue<Float>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Float)heap.peek(), Float.valueOf(a[i])) >= 0) continue;
                heap.poll();
                heap.add(Float.valueOf(a[i]));
                continue;
            }
            heap.offer(Float.valueOf(a[i]));
        }
        Iterator iter = heap.iterator();
        float[] res = new float[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = ((Float)iter.next()).floatValue();
        }
        return res;
    }

    public static double[] top(double[] a, int n) {
        return N.top(a, n, null);
    }

    public static double[] top(double[] a, int n, Comparator<? super Double> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static double[] top(double[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, null);
    }

    public static double[] top(double[] a, int fromIndex, int toIndex, int n, Comparator<? super Double> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (n >= toIndex - fromIndex) {
            return N.copyOfRange(a, fromIndex, toIndex);
        }
        Comparator<? super Double> comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<? super Double> heap = new PriorityQueue<Double>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare((Double)heap.peek(), (Double)a[i]) >= 0) continue;
                heap.poll();
                heap.add((Double)a[i]);
                continue;
            }
            heap.offer((Double)a[i]);
        }
        Iterator iter = heap.iterator();
        double[] res = new double[n];
        int idx = 0;
        while (iter.hasNext()) {
            res[idx++] = (Double)iter.next();
        }
        return res;
    }

    public static <T extends Comparable<? super T>> List<T> top(T[] a, int n) {
        return N.top(a, n, NATURAL_ORDER);
    }

    public static <T> List<T> top(T[] a, int n, Comparator<? super T> cmp) {
        return N.top(a, 0, N.len(a), n, cmp);
    }

    public static <T extends Comparable<? super T>> List<T> top(T[] a, int fromIndex, int toIndex, int n) {
        return N.top(a, fromIndex, toIndex, n, NATURAL_ORDER);
    }

    public static <T> List<T> top(T[] a, int fromIndex, int toIndex, int n, Comparator<? super T> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            return N.toList(a, fromIndex, toIndex);
        }
        Comparator comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<Object> heap = new PriorityQueue<Object>(n, comparator);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (heap.size() >= n) {
                if (comparator.compare(heap.peek(), a[i]) >= 0) continue;
                heap.poll();
                heap.add(a[i]);
                continue;
            }
            heap.offer(a[i]);
        }
        return InternalUtil.createList(heap.toArray(EMPTY_OBJECT_ARRAY));
    }

    public static <T extends Comparable<? super T>> List<T> top(Collection<? extends T> c, int n) {
        return N.top(c, n, null);
    }

    public static <T> List<T> top(Collection<? extends T> c, int n, Comparator<? super T> cmp) {
        return N.top(c, 0, N.size(c), n, cmp);
    }

    public static <T extends Comparable<? super T>> List<T> top(Collection<? extends T> c, int fromIndex, int toIndex, int n) {
        return N.top(c, fromIndex, toIndex, n, null);
    }

    public static <T> List<T> top(Collection<? extends T> c, int fromIndex, int toIndex, int n, Comparator<? super T> cmp) {
        N.checkArgNotNegative(n, "n");
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            if (fromIndex == 0 && toIndex == c.size()) {
                return new ArrayList<T>(c);
            }
            ArrayList<Object> res = new ArrayList<Object>(toIndex - fromIndex);
            Iterator<T> iter = c.iterator();
            Object e = null;
            for (int i = 0; i < toIndex && iter.hasNext(); ++i) {
                e = iter.next();
                if (i < fromIndex) continue;
                res.add(e);
            }
            return res;
        }
        Comparator comparator = cmp == null ? Comparators.NATURAL_ORDER : cmp;
        PriorityQueue<Object> heap = new PriorityQueue<Object>(n, comparator);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Object e = null;
            for (int i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                if (heap.size() >= n) {
                    if (comparator.compare(heap.peek(), e) >= 0) continue;
                    heap.poll();
                    heap.add(e);
                    continue;
                }
                heap.offer(e);
            }
        } else {
            Iterator<T> iter = c.iterator();
            Object e = null;
            for (int i = 0; i < toIndex && iter.hasNext(); ++i) {
                e = iter.next();
                if (i < fromIndex) continue;
                if (heap.size() >= n) {
                    if (comparator.compare(heap.peek(), e) >= 0) continue;
                    heap.poll();
                    heap.add(e);
                    continue;
                }
                heap.offer(e);
            }
        }
        return InternalUtil.createList(heap.toArray(EMPTY_OBJECT_ARRAY));
    }

    public static <T extends Comparable<? super T>> List<T> top(T[] a, int n, boolean keepEncounterOrder) {
        return N.top(a, n, NATURAL_ORDER, keepEncounterOrder);
    }

    public static <T> List<T> top(T[] a, int n, Comparator<? super T> cmp, boolean keepEncounterOrder) {
        return N.top(a, 0, N.len(a), n, cmp, keepEncounterOrder);
    }

    public static <T extends Comparable<? super T>> List<T> top(T[] a, int fromIndex, int toIndex, int n, boolean keepEncounterOrder) {
        return N.top(a, fromIndex, toIndex, n, NATURAL_ORDER, keepEncounterOrder);
    }

    public static <T> List<T> top(T[] a, int fromIndex, int toIndex, int n, final Comparator<? super T> cmp, boolean keepEncounterOrder) {
        N.checkArgNotNegative(n, "n");
        if (!keepEncounterOrder) {
            return N.top(a, fromIndex, toIndex, n, cmp);
        }
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            return N.toList(a, fromIndex, toIndex);
        }
        Comparator<Indexed<Comparable>> comparator = cmp == null ? new Comparator<Indexed<Comparable>>(){

            @Override
            public int compare(Indexed<Comparable> o1, Indexed<Comparable> o2) {
                return N.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return cmp.compare(o1.value(), o2.value());
            }
        };
        PriorityQueue<Indexed<Comparable>> heap = new PriorityQueue<Indexed<Comparable>>(n, comparator);
        Indexed<T> indexed = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            indexed = Indexed.of(a[i], i);
            if (heap.size() >= n) {
                if (comparator.compare((Indexed<Comparable>)heap.peek(), (Indexed<Comparable>)indexed) >= 0) continue;
                heap.poll();
                heap.add(indexed);
                continue;
            }
            heap.offer(indexed);
        }
        Indexed[] arrayOfIndexed = heap.toArray(new Indexed[heap.size()]);
        N.sort(arrayOfIndexed, new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return o1.index() - o2.index();
            }
        });
        ArrayList res = new ArrayList(arrayOfIndexed.length);
        for (Indexed element : arrayOfIndexed) {
            res.add(element.value());
        }
        return res;
    }

    public static <T extends Comparable<? super T>> List<T> top(Collection<? extends T> c, int n, boolean keepEncounterOrder) {
        return N.top(c, n, NATURAL_ORDER, keepEncounterOrder);
    }

    public static <T> List<T> top(Collection<? extends T> c, int n, Comparator<? super T> cmp, boolean keepEncounterOrder) {
        return N.top(c, 0, N.size(c), n, cmp, keepEncounterOrder);
    }

    public static <T extends Comparable<? super T>> List<T> top(Collection<? extends T> c, int fromIndex, int toIndex, int n, boolean keepEncounterOrder) {
        return N.top(c, fromIndex, toIndex, n, NATURAL_ORDER, keepEncounterOrder);
    }

    public static <T> List<T> top(Collection<? extends T> c, int fromIndex, int toIndex, int n, final Comparator<? super T> cmp, boolean keepEncounterOrder) {
        int i;
        Object e;
        Indexed<Object> indexed;
        N.checkArgNotNegative(n, "n");
        if (!keepEncounterOrder) {
            return N.top(c, fromIndex, toIndex, n, cmp);
        }
        if (n == 0) {
            return new ArrayList();
        }
        if (n >= toIndex - fromIndex) {
            if (fromIndex == 0 && toIndex == c.size()) {
                return new ArrayList<T>(c);
            }
            ArrayList<Object> res = new ArrayList<Object>(toIndex - fromIndex);
            Iterator<T> iter = c.iterator();
            Object e2 = null;
            for (int i2 = 0; i2 < toIndex && iter.hasNext(); ++i2) {
                e2 = iter.next();
                if (i2 < fromIndex) continue;
                res.add(e2);
            }
            return res;
        }
        Comparator<Indexed<Comparable>> comparator = cmp == null ? new Comparator<Indexed<Comparable>>(){

            @Override
            public int compare(Indexed<Comparable> o1, Indexed<Comparable> o2) {
                return N.compare(o1.value(), o2.value());
            }
        } : new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return cmp.compare(o1.value(), o2.value());
            }
        };
        PriorityQueue<Indexed<Comparable>> heap = new PriorityQueue<Indexed<Comparable>>(n, comparator);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            indexed = null;
            e = null;
            for (i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                indexed = Indexed.of(e, i);
                if (heap.size() >= n) {
                    if (comparator.compare((Indexed<Comparable>)heap.peek(), (Indexed<Comparable>)indexed) >= 0) continue;
                    heap.poll();
                    heap.add(indexed);
                    continue;
                }
                heap.offer(indexed);
            }
        } else {
            Iterator<T> iter = c.iterator();
            indexed = null;
            e = null;
            for (i = 0; i < toIndex && iter.hasNext(); ++i) {
                e = iter.next();
                if (i < fromIndex) continue;
                indexed = Indexed.of(e, i);
                if (heap.size() >= n) {
                    if (comparator.compare((Indexed<Comparable>)heap.peek(), (Indexed<Comparable>)indexed) >= 0) continue;
                    heap.poll();
                    heap.add(indexed);
                    continue;
                }
                heap.offer(indexed);
            }
        }
        Indexed[] arrayOfIndexed = heap.toArray(new Indexed[heap.size()]);
        N.sort(arrayOfIndexed, new Comparator<Indexed<T>>(){

            @Override
            public int compare(Indexed<T> o1, Indexed<T> o2) {
                return o1.index() - o2.index();
            }
        });
        ArrayList res = new ArrayList(arrayOfIndexed.length);
        for (Indexed element : arrayOfIndexed) {
            res.add(element.value());
        }
        return res;
    }

    public static <E extends Exception> void forEach(int startInclusive, int endExclusive, Throwables.Runnable<E> action) throws E {
        N.forEach(startInclusive, endExclusive, 1, action);
    }

    public static <E extends Exception> void forEach(int startInclusive, int endExclusive, int step, Throwables.Runnable<E> action) throws E {
        N.checkArgument(step != 0, "The input parameter 'step' can not be zero");
        if (endExclusive == startInclusive || endExclusive > startInclusive != step > 0) {
            return;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)step + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)step == 0L ? 0 : 1);
        while (len-- > 0L) {
            action.run();
        }
    }

    public static <E extends Exception> void forEach(int startInclusive, int endExclusive, Throwables.IntConsumer<E> action) throws E {
        N.forEach(startInclusive, endExclusive, 1, action);
    }

    public static <E extends Exception> void forEach(int startInclusive, int endExclusive, int step, Throwables.IntConsumer<E> action) throws E {
        N.checkArgument(step != 0, "The input parameter 'step' can not be zero");
        if (endExclusive == startInclusive || endExclusive > startInclusive != step > 0) {
            return;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)step + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)step == 0L ? 0 : 1);
        int start = startInclusive;
        while (len-- > 0L) {
            action.accept(start);
            start += step;
        }
    }

    @Deprecated
    public static <T, E extends Exception> void forEach(int startInclusive, int endExclusive, T a, Throwables.ObjIntConsumer<? super T, E> action) throws E {
        N.forEach(startInclusive, endExclusive, 1, a, action);
    }

    @Deprecated
    public static <T, E extends Exception> void forEach(int startInclusive, int endExclusive, int step, T a, Throwables.ObjIntConsumer<? super T, E> action) throws E {
        N.checkArgument(step != 0, "The input parameter 'step' can not be zero");
        if (endExclusive == startInclusive || endExclusive > startInclusive != step > 0) {
            return;
        }
        long len = ((long)endExclusive * 1L - (long)startInclusive) / (long)step + (long)(((long)endExclusive * 1L - (long)startInclusive) % (long)step == 0L ? 0 : 1);
        int start = startInclusive;
        while (len-- > 0L) {
            action.accept(a, start);
            start += step;
        }
    }

    public static <T, E extends Exception> void forEach(T[] a, Throwables.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            action.accept(e);
        }
    }

    public static <T, E extends Exception> void forEach(T[] a, int fromIndex, int toIndex, Throwables.Consumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.len(a));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        if (fromIndex <= toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                action.accept(a[i]);
            }
        } else {
            for (int i = N.min(a.length - 1, toIndex); i > toIndex; --i) {
                action.accept(a[i]);
            }
        }
    }

    public static <T, E extends Exception> void forEach(Collection<? extends T> c, Throwables.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            action.accept(e);
        }
    }

    public static <T, E extends Exception> void forEach(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Consumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.size(c));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return;
        }
        fromIndex = N.min(c.size() - 1, fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            if (fromIndex <= toIndex) {
                for (int i = fromIndex; i < toIndex; ++i) {
                    action.accept(list.get(i));
                }
            } else {
                for (int i = fromIndex; i > toIndex; --i) {
                    action.accept(list.get(i));
                }
            }
        } else {
            int idx;
            Iterator<T> iter = c.iterator();
            if (fromIndex <= toIndex) {
                for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    action.accept(iter.next());
                    if (++idx < toIndex) continue;
                    break;
                }
            } else {
                while (idx <= toIndex && iter.hasNext()) {
                    iter.next();
                    ++idx;
                }
                Object[] a = new Object[fromIndex - toIndex];
                while (iter.hasNext()) {
                    a[idx - 1 - toIndex] = iter.next();
                    if (idx++ < fromIndex) continue;
                }
                for (int i = a.length - 1; i >= 0; --i) {
                    action.accept(a[i]);
                }
            }
        }
    }

    public static <T, E extends Exception> void forEach(Iterator<? extends T> iter, Throwables.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        while (iter.hasNext()) {
            action.accept(iter.next());
        }
    }

    public static <K, V, E extends Exception> void forEach(Map<K, V> map, Throwables.Consumer<? super Map.Entry<K, V>, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        N.forEach(map.entrySet(), action);
    }

    public static <T, E extends Exception> void forEachIndexed(T[] a, Throwables.IndexedConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        N.forEachIndexed(a, 0, a.length, action);
    }

    public static <T, E extends Exception> void forEachIndexed(T[] a, int fromIndex, int toIndex, Throwables.IndexedConsumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.len(a));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return;
        }
        if (fromIndex <= toIndex) {
            for (int i = fromIndex; i < toIndex; ++i) {
                action.accept(i, a[i]);
            }
        } else {
            for (int i = N.min(a.length - 1, toIndex); i > toIndex; --i) {
                action.accept(i, a[i]);
            }
        }
    }

    public static <T, E extends Exception> void forEachIndexed(Collection<? extends T> c, Throwables.IndexedConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        int idx = 0;
        for (T e : c) {
            action.accept(idx++, e);
        }
    }

    public static <T, E extends Exception> void forEachIndexed(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.IndexedConsumer<? super T, E> action) throws E {
        N.checkFromToIndex(fromIndex < toIndex ? fromIndex : (toIndex == -1 ? 0 : toIndex), fromIndex < toIndex ? toIndex : fromIndex, N.size(c));
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return;
        }
        fromIndex = N.min(c.size() - 1, fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            if (fromIndex <= toIndex) {
                for (int i = fromIndex; i < toIndex; ++i) {
                    action.accept(i, list.get(i));
                }
            } else {
                for (int i = fromIndex; i > toIndex; --i) {
                    action.accept(i, list.get(i));
                }
            }
        } else {
            int idx;
            Iterator<T> iter = c.iterator();
            if (fromIndex < toIndex) {
                for (idx = 0; idx < fromIndex && iter.hasNext(); ++idx) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    action.accept(idx, iter.next());
                    if (++idx < toIndex) continue;
                    break;
                }
            } else {
                while (idx <= toIndex && iter.hasNext()) {
                    iter.next();
                    ++idx;
                }
                Object[] a = new Object[fromIndex - toIndex];
                while (iter.hasNext()) {
                    a[idx - 1 - toIndex] = iter.next();
                    if (idx++ < fromIndex) continue;
                }
                for (int i = a.length - 1; i >= 0; --i) {
                    action.accept(i + toIndex + 1, a[i]);
                }
            }
        }
    }

    public static <T, E extends Exception> void forEachIndexed(Iterator<? extends T> iter, Throwables.IndexedConsumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        int idx = 0;
        while (iter.hasNext()) {
            action.accept(idx++, iter.next());
        }
    }

    public static <K, V, E extends Exception> void forEachIndexed(Map<K, V> map, Throwables.IndexedConsumer<? super Map.Entry<K, V>, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(map)) {
            return;
        }
        N.forEachIndexed(map.entrySet(), action);
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEach(T[] a, Throwables.Function<? super T, ? extends Collection<U>, E> flatMapper, Throwables.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T t : a) {
            Collection<U> c2 = flatMapper.apply(t);
            if (!N.notNullOrEmpty(c2)) continue;
            for (U u2 : c2) {
                action.accept(t, u2);
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEach(Collection<T> c, Throwables.Function<? super T, ? extends Collection<U>, E> flatMapper, Throwables.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T t : c) {
            Collection<U> c2 = flatMapper.apply(t);
            if (!N.notNullOrEmpty(c2)) continue;
            for (U u2 : c2) {
                action.accept(t, u2);
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEach(Iterator<? extends T> iter, Throwables.Function<? super T, ? extends Collection<U>, E> flatMapper, Throwables.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object t = null;
        while (iter.hasNext()) {
            t = iter.next();
            Collection<U> c2 = flatMapper.apply(t);
            if (!N.notNullOrEmpty(c2)) continue;
            for (U u2 : c2) {
                action.accept(t, u2);
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(T[] a, Throwables.Function<? super T, ? extends Collection<T2>, E> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T t : a) {
            Collection<T2> c2 = flatMapper.apply(t);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = flatMapper2.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    action.accept(t, t2, t3);
                }
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(Collection<T> c, Throwables.Function<? super T, ? extends Collection<T2>, E> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T t : c) {
            Collection<T2> c2 = flatMapper.apply(t);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = flatMapper2.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    action.accept(t, t2, t3);
                }
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEach(Iterator<? extends T> iter, Throwables.Function<? super T, ? extends Collection<T2>, E> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object t = null;
        while (iter.hasNext()) {
            t = iter.next();
            Collection<T2> c2 = flatMapper.apply(t);
            if (!N.notNullOrEmpty(c2)) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3 = flatMapper2.apply(t2);
                if (!N.notNullOrEmpty(c3)) continue;
                for (T3 t3 : c3) {
                    action.accept(t, t2, t3);
                }
            }
        }
    }

    public static <A, B, E extends Exception> void forEach(A[] a, B[] b, Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return;
        }
        int minLen = N.min(a.length, b.length);
        for (int i = 0; i < minLen; ++i) {
            action.accept(a[i], b[i]);
        }
    }

    public static <A, B, E extends Exception> void forEach(Collection<A> a, Collection<B> b, Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return;
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        int minLen = N.min(a.size(), b.size());
        for (int i = 0; i < minLen; ++i) {
            action.accept(iterA.next(), iterB.next());
        }
    }

    public static <A, B, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        if (a == null || b == null) {
            return;
        }
        while (a.hasNext() && b.hasNext()) {
            action.accept(a.next(), b.next());
        }
    }

    public static <A, B, C, E extends Exception> void forEach(A[] a, B[] b, C[] c, Throwables.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return;
        }
        int minLen = N.min(a.length, b.length, c.length);
        for (int i = 0; i < minLen; ++i) {
            action.accept(a[i], b[i], c[i]);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Collection<A> a, Collection<B> b, Collection<C> c, Throwables.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return;
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        Iterator<C> iterC = c.iterator();
        int minLen = N.min(a.size(), b.size(), c.size());
        for (int i = 0; i < minLen; ++i) {
            action.accept(iterA.next(), iterB.next(), iterC.next());
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, Iterator<C> c, Throwables.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        if (a == null || b == null || c == null) {
            return;
        }
        while (a.hasNext() && b.hasNext() && c.hasNext()) {
            action.accept(a.next(), b.next(), c.next());
        }
    }

    public static <A, B, E extends Exception> void forEach(A[] a, B[] b, A valueForNoneA, B valueForNoneB, Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int maxLen = N.max(lenA, lenB);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB);
        }
    }

    public static <A, B, E extends Exception> void forEach(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB, Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int maxLen = N.max(lenA, lenB);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB);
        }
    }

    public static <A, B, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, A valueForNoneA, B valueForNoneB, Throwables.BiConsumer<? super A, ? super B, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a;
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b;
        Object nextA = null;
        Object nextB = null;
        while (iterA.hasNext() || iterB.hasNext()) {
            nextA = iterA.hasNext() ? iterA.next() : valueForNoneA;
            nextB = iterB.hasNext() ? iterB.next() : valueForNoneB;
            action.accept(nextA, nextB);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int lenC = N.len(c);
        int maxLen = N.max(lenA, lenB, lenC);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB, i < lenC ? c[i] : valueForNoneC);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Collection<A> a, Collection<B> b, Collection<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = c == null ? ObjIterator.empty() : c.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int lenC = N.size(c);
        int maxLen = N.max(lenA, lenB, lenC);
        for (int i = 0; i < maxLen; ++i) {
            action.accept(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB, i < lenC ? iterC.next() : valueForNoneC);
        }
    }

    public static <A, B, C, E extends Exception> void forEach(Iterator<A> a, Iterator<B> b, Iterator<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriConsumer<? super A, ? super B, ? super C, E> action) throws E {
        N.checkArgNotNull(action);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a;
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b;
        Iterator<Object> iterC = b == null ? ObjIterator.empty() : c;
        Object nextA = null;
        Object nextB = null;
        Object nextC = null;
        while (iterA.hasNext() || iterB.hasNext() || iterC.hasNext()) {
            nextA = iterA.hasNext() ? iterA.next() : valueForNoneA;
            nextB = iterB.hasNext() ? iterB.next() : valueForNoneB;
            nextC = iterC.hasNext() ? iterC.next() : valueForNoneC;
            action.accept(nextA, nextB, nextC);
        }
    }

    public static <T, E extends Exception> void forEachNonNull(T[] a, Throwables.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            if (e == null) continue;
            action.accept(e);
        }
    }

    public static <T, E extends Exception> void forEachNonNull(Collection<T> c, Throwables.Consumer<? super T, E> action) throws E {
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            if (e == null) continue;
            action.accept(e);
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEachNonNull(T[] a, Throwables.Function<? super T, ? extends Collection<U>, E> flatMapper, Throwables.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            Collection<U> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (U u2 : c2) {
                if (u2 == null) continue;
                action.accept(e, u2);
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEachNonNull(Collection<T> c, Throwables.Function<? super T, ? extends Collection<U>, E> flatMapper, Throwables.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            Collection<U> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (U u2 : c2) {
                if (u2 == null) continue;
                action.accept(e, u2);
            }
        }
    }

    public static <T, U, E extends Exception, E2 extends Exception> void forEachNonNull(Iterator<? extends T> iter, Throwables.Function<? super T, ? extends Collection<U>, E> flatMapper, Throwables.BiConsumer<? super T, ? super U, E2> action) throws E, E2 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object e = null;
        while (iter.hasNext()) {
            Collection<U> c2;
            e = iter.next();
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (U u2 : c2) {
                if (u2 == null) continue;
                action.accept(e, u2);
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(T[] a, Throwables.Function<? super T, ? extends Collection<T2>, E> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        for (T e : a) {
            Collection<T2> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3;
                if (t2 == null || !N.notNullOrEmpty(c3 = flatMapper2.apply(t2))) continue;
                for (T3 t3 : c3) {
                    if (t3 == null) continue;
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(Collection<T> c, Throwables.Function<? super T, ? extends Collection<T2>, E> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        for (T e : c) {
            Collection<T2> c2;
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3;
                if (t2 == null || !N.notNullOrEmpty(c3 = flatMapper2.apply(t2))) continue;
                for (T3 t3 : c3) {
                    if (t3 == null) continue;
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, T2, T3, E extends Exception, E2 extends Exception, E3 extends Exception> void forEachNonNull(Iterator<? extends T> iter, Throwables.Function<? super T, ? extends Collection<T2>, E> flatMapper, Throwables.Function<? super T2, ? extends Collection<T3>, E2> flatMapper2, Throwables.TriConsumer<? super T, ? super T2, ? super T3, E3> action) throws E, E2, E3 {
        N.checkArgNotNull(flatMapper);
        N.checkArgNotNull(flatMapper2);
        N.checkArgNotNull(action);
        if (iter == null) {
            return;
        }
        Object e = null;
        while (iter.hasNext()) {
            Collection<T2> c2;
            e = iter.next();
            if (e == null || !N.notNullOrEmpty(c2 = flatMapper.apply(e))) continue;
            for (T2 t2 : c2) {
                Collection<T3> c3;
                if (t2 == null || !N.notNullOrEmpty(c3 = flatMapper2.apply(t2))) continue;
                for (T3 t3 : c3) {
                    if (t3 == null) continue;
                    action.accept(e, t2, t3);
                }
            }
        }
    }

    public static <T, E extends Exception> void forEachPair(T[] a, Throwables.BiConsumer<? super T, ? super T, E> action) throws E {
        N.forEachPair(a, action, 1);
    }

    public static <T, E extends Exception> void forEachPair(T[] a, Throwables.BiConsumer<? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 2;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 2, increment);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        ObjIterator<T> iter = ObjIterator.of(a);
        N.forEachPair(iter, action, increment);
    }

    public static <T, E extends Exception> void forEachPair(Collection<? extends T> c, Throwables.BiConsumer<? super T, ? super T, E> action) throws E {
        N.forEachPair(c, action, 1);
    }

    public static <T, E extends Exception> void forEachPair(Collection<? extends T> c, Throwables.BiConsumer<? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 2;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 2, increment);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        Iterator<? extends T> iter = c.iterator();
        N.forEachPair(iter, action, increment);
    }

    public static <T, E extends Exception> void forEachPair(Iterator<? extends T> iter, Throwables.BiConsumer<? super T, ? super T, E> action) throws E {
        N.forEachPair(iter, action, 1);
    }

    public static <T, E extends Exception> void forEachPair(Iterator<? extends T> iter, Throwables.BiConsumer<? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 2;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 2, increment);
        if (iter == null) {
            return;
        }
        boolean isFirst = true;
        Object prev = null;
        while (iter.hasNext()) {
            if (increment > 2 && !isFirst) {
                int skipNum = increment - 2;
                while (skipNum-- > 0 && iter.hasNext()) {
                    iter.next();
                }
                if (!iter.hasNext()) break;
            }
            if (increment == 1) {
                Object u2 = isFirst ? (Object)iter.next() : prev;
                prev = iter.hasNext() ? (Object)iter.next() : null;
                action.accept(u2, prev);
            } else {
                action.accept(iter.next(), iter.hasNext() ? (Object)iter.next() : null);
            }
            isFirst = false;
        }
    }

    public static <T, E extends Exception> void forEachTriple(T[] a, Throwables.TriConsumer<? super T, ? super T, ? super T, E> action) throws E {
        N.forEachTriple(a, action, 1);
    }

    public static <T, E extends Exception> void forEachTriple(T[] a, Throwables.TriConsumer<? super T, ? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 3;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 3, increment);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        ObjIterator<T> iter = ObjIterator.of(a);
        N.forEachTriple(iter, action, increment);
    }

    public static <T, E extends Exception> void forEachTriple(Collection<? extends T> c, Throwables.TriConsumer<? super T, ? super T, ? super T, E> action) throws E {
        N.forEachTriple(c, action, 1);
    }

    public static <T, E extends Exception> void forEachTriple(Collection<? extends T> c, Throwables.TriConsumer<? super T, ? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 3;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 3, increment);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        Iterator<? extends T> iter = c.iterator();
        N.forEachTriple(iter, action, increment);
    }

    public static <T, E extends Exception> void forEachTriple(Iterator<? extends T> iter, Throwables.TriConsumer<? super T, ? super T, ? super T, E> action) throws E {
        N.forEachTriple(iter, action, 1);
    }

    public static <T, E extends Exception> void forEachTriple(Iterator<? extends T> iter, Throwables.TriConsumer<? super T, ? super T, ? super T, E> action, int increment) throws E {
        N.checkArgNotNull(action);
        int windowSize = 3;
        N.checkArgument(increment > 0, "windowSize=%s and increment=%s must be bigger than 0", 3, increment);
        if (iter == null) {
            return;
        }
        boolean isFirst = true;
        Object prev = null;
        Object prev2 = null;
        while (iter.hasNext()) {
            if (increment > 3 && !isFirst) {
                int skipNum = increment - 3;
                while (skipNum-- > 0 && iter.hasNext()) {
                    iter.next();
                }
                if (!iter.hasNext()) break;
            }
            if (increment == 1) {
                Object c = isFirst ? (Object)iter.next() : prev2;
                prev2 = isFirst ? (iter.hasNext() ? (Object)iter.next() : null) : prev;
                prev = iter.hasNext() ? (Object)iter.next() : null;
                action.accept(c, prev2, prev);
            } else if (increment == 2) {
                Object c = isFirst ? (Object)iter.next() : prev;
                prev = iter.hasNext() ? (Object)iter.next() : null;
                action.accept(c, iter.hasNext() ? (Object)iter.next() : null, prev);
            } else {
                action.accept(iter.next(), iter.hasNext() ? (Object)iter.next() : null, iter.hasNext() ? (Object)iter.next() : null);
            }
            isFirst = false;
        }
    }

    public static <E extends Exception> boolean[] filter(boolean[] a, Throwables.BooleanPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> boolean[] filter(boolean[] a, Throwables.BooleanPredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> boolean[] filter(boolean[] a, int fromIndex, int toIndex, Throwables.BooleanPredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> boolean[] filter(boolean[] a, int fromIndex, int toIndex, Throwables.BooleanPredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> char[] filter(char[] a, Throwables.CharPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> char[] filter(char[] a, Throwables.CharPredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> char[] filter(char[] a, int fromIndex, int toIndex, Throwables.CharPredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> char[] filter(char[] a, int fromIndex, int toIndex, Throwables.CharPredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> byte[] filter(byte[] a, Throwables.BytePredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> byte[] filter(byte[] a, Throwables.BytePredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> byte[] filter(byte[] a, int fromIndex, int toIndex, Throwables.BytePredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> byte[] filter(byte[] a, int fromIndex, int toIndex, Throwables.BytePredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> short[] filter(short[] a, Throwables.ShortPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> short[] filter(short[] a, Throwables.ShortPredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> short[] filter(short[] a, int fromIndex, int toIndex, Throwables.ShortPredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> short[] filter(short[] a, int fromIndex, int toIndex, Throwables.ShortPredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> int[] filter(int[] a, Throwables.IntPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> int[] filter(int[] a, Throwables.IntPredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> int[] filter(int[] a, int fromIndex, int toIndex, Throwables.IntPredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> int[] filter(int[] a, int fromIndex, int toIndex, Throwables.IntPredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> long[] filter(long[] a, Throwables.LongPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> long[] filter(long[] a, Throwables.LongPredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> long[] filter(long[] a, int fromIndex, int toIndex, Throwables.LongPredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> long[] filter(long[] a, int fromIndex, int toIndex, Throwables.LongPredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> float[] filter(float[] a, Throwables.FloatPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> float[] filter(float[] a, Throwables.FloatPredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> float[] filter(float[] a, int fromIndex, int toIndex, Throwables.FloatPredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> float[] filter(float[] a, int fromIndex, int toIndex, Throwables.FloatPredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <E extends Exception> double[] filter(double[] a, Throwables.DoublePredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.filter(a, 0, a.length, filter);
    }

    public static <E extends Exception> double[] filter(double[] a, Throwables.DoublePredicate<E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <E extends Exception> double[] filter(double[] a, int fromIndex, int toIndex, Throwables.DoublePredicate<E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <E extends Exception> double[] filter(double[] a, int fromIndex, int toIndex, Throwables.DoublePredicate<E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[(toIndex - fromIndex) / 2];
        int len = result.length;
        int count = 0;
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            if (count == len) {
                result = N.copyOf(result, toIndex - fromIndex);
                len = result.length;
            }
            result[count++] = a[i];
        }
        return result.length == count ? result : N.copyOfRange(result, 0, count);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.filter(a, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, Throwables.Predicate<? super T, E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.filter(a, 0, a.length, filter, max);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(T[] a, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(N.min(9, max, toIndex - fromIndex));
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            result.add(a[i]);
            ++cnt;
        }
        return result;
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.filter(c, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter, int max) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.filter(c, 0, c.size(), filter, max);
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter) throws E {
        return N.filter(c, fromIndex, toIndex, filter, Integer.MAX_VALUE);
    }

    public static <T, E extends Exception> List<T> filter(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter, int max) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(N.min(9, max, toIndex - fromIndex));
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Object e = null;
            int cnt = 0;
            for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
                e = list.get(i);
                if (!filter.test(e)) continue;
                result.add(e);
                ++cnt;
            }
        } else {
            int idx = 0;
            int cnt = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                if (filter.test(e)) {
                    result.add(e);
                    if (++cnt >= max) break;
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, Throwables.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(a, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, Throwables.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(a, 0, a.length, filter, max, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        return N.filter(a, fromIndex, toIndex, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(T[] a, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return (R)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(N.min(9, max, toIndex - fromIndex));
        int cnt = 0;
        for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
            if (!filter.test(a[i])) continue;
            result.add(a[i]);
            ++cnt;
        }
        return (R)result;
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(c, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return (R)((Collection)supplier.apply(0));
        }
        return N.filter(c, 0, c.size(), filter, max, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter, IntFunction<R> supplier) throws E {
        return N.filter(c, fromIndex, toIndex, filter, Integer.MAX_VALUE, supplier);
    }

    public static <T, R extends Collection<T>, E extends Exception> R filter(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter, int max, IntFunction<R> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return (R)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(N.min(9, max, toIndex - fromIndex));
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex && fromIndex < c.size()) {
            return (R)result;
        }
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            Object e = null;
            int cnt = 0;
            for (int i = fromIndex; i < toIndex && cnt < max; ++i) {
                e = list.get(i);
                if (!filter.test(e)) continue;
                result.add(e);
                ++cnt;
            }
        } else {
            int idx = 0;
            int cnt = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                if (filter.test(e)) {
                    result.add(e);
                    if (++cnt >= max) break;
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return (R)result;
    }

    public static <T, E extends Exception> boolean[] mapToBoolean(T[] a, Throwables.ToBooleanFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.mapToBoolean(a, 0, a.length, func);
    }

    public static <T, E extends Exception> boolean[] mapToBoolean(T[] a, int fromIndex, int toIndex, Throwables.ToBooleanFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsBoolean(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> boolean[] mapToBoolean(Collection<? extends T> c, Throwables.ToBooleanFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return N.mapToBoolean(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> boolean[] mapToBoolean(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToBooleanFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsBoolean(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsBoolean(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> char[] mapToChar(T[] a, Throwables.ToCharFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.mapToChar(a, 0, a.length, func);
    }

    public static <T, E extends Exception> char[] mapToChar(T[] a, int fromIndex, int toIndex, Throwables.ToCharFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsChar(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> char[] mapToChar(Collection<? extends T> c, Throwables.ToCharFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_CHAR_ARRAY;
        }
        return N.mapToChar(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> char[] mapToChar(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToCharFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsChar(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsChar(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> byte[] mapToByte(T[] a, Throwables.ToByteFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.mapToByte(a, 0, a.length, func);
    }

    public static <T, E extends Exception> byte[] mapToByte(T[] a, int fromIndex, int toIndex, Throwables.ToByteFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsByte(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> byte[] mapToByte(Collection<? extends T> c, Throwables.ToByteFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_BYTE_ARRAY;
        }
        return N.mapToByte(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> byte[] mapToByte(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToByteFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsByte(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsByte(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> short[] mapToShort(T[] a, Throwables.ToShortFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.mapToShort(a, 0, a.length, func);
    }

    public static <T, E extends Exception> short[] mapToShort(T[] a, int fromIndex, int toIndex, Throwables.ToShortFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsShort(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> short[] mapToShort(Collection<? extends T> c, Throwables.ToShortFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_SHORT_ARRAY;
        }
        return N.mapToShort(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> short[] mapToShort(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToShortFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsShort(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsShort(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> int[] mapToInt(T[] a, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_INT_ARRAY;
        }
        return N.mapToInt(a, 0, a.length, func);
    }

    public static <T, E extends Exception> int[] mapToInt(T[] a, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsInt(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> int[] mapToInt(Collection<? extends T> c, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_INT_ARRAY;
        }
        return N.mapToInt(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> int[] mapToInt(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToIntFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsInt(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsInt(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> long[] mapToLong(T[] a, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.mapToLong(a, 0, a.length, func);
    }

    public static <T, E extends Exception> long[] mapToLong(T[] a, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsLong(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> long[] mapToLong(Collection<? extends T> c, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_LONG_ARRAY;
        }
        return N.mapToLong(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> long[] mapToLong(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToLongFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsLong(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsLong(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> float[] mapToFloat(T[] a, Throwables.ToFloatFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.mapToFloat(a, 0, a.length, func);
    }

    public static <T, E extends Exception> float[] mapToFloat(T[] a, int fromIndex, int toIndex, Throwables.ToFloatFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsFloat(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> float[] mapToFloat(Collection<? extends T> c, Throwables.ToFloatFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_FLOAT_ARRAY;
        }
        return N.mapToFloat(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> float[] mapToFloat(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToFloatFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsFloat(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsFloat(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, E extends Exception> double[] mapToDouble(T[] a, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.mapToDouble(a, 0, a.length, func);
    }

    public static <T, E extends Exception> double[] mapToDouble(T[] a, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[toIndex - fromIndex];
        for (int i = fromIndex; i < toIndex; ++i) {
            result[i - fromIndex] = func.applyAsDouble(a[i]);
        }
        return result;
    }

    public static <T, E extends Exception> double[] mapToDouble(Collection<? extends T> c, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return N.mapToDouble(c, 0, c.size(), func);
    }

    public static <T, E extends Exception> double[] mapToDouble(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.ToDoubleFunction<? super T, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[toIndex - fromIndex];
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result[i - fromIndex] = func.applyAsDouble(list.get(i));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result[idx - fromIndex] = func.applyAsDouble(e);
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> map(T[] a, Throwables.Function<? super T, ? extends R, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.map(a, 0, a.length, func);
    }

    public static <T, R, E extends Exception> List<R> map(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList();
        }
        ArrayList<R> result = new ArrayList<R>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(func.apply(a[i]));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> map(Collection<? extends T> c, Throwables.Function<? super T, ? extends R, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.map(c, 0, c.size(), func);
    }

    public static <T, R, E extends Exception> List<R> map(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return new ArrayList();
        }
        ArrayList<R> result = new ArrayList<R>(toIndex - fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result.add(func.apply(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result.add(func.apply(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(T[] a, Throwables.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.map(a, 0, a.length, func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(func.apply(a[i]));
        }
        return (C)result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(Collection<? extends T> c, Throwables.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.map(c, 0, c.size(), func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C map(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        Collection result = (Collection)supplier.apply(toIndex - fromIndex);
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                result.add(func.apply(list.get(i)));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                result.add(func.apply(e));
                if (idx < toIndex) continue;
                break;
            }
        }
        return (C)result;
    }

    public static <T, R, E extends Exception> List<R> flatMap(T[] a, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.flatMap(a, 0, a.length, func);
    }

    public static <T, R, E extends Exception> List<R> flatMap(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList();
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        ArrayList<? extends R> result = new ArrayList<R>(len);
        Collection<? extends R> mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(mr);
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> flatMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.flatMap(c, 0, c.size(), func);
    }

    public static <T, R, E extends Exception> List<R> flatMap(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return new ArrayList();
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        ArrayList<Object> result = new ArrayList<Object>(len);
        Collection<Object> mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(mr);
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(mr);
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(T[] a, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flatMap(a, 0, a.length, func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        Collection result = (Collection)supplier.apply(len);
        Collection<? extends R> mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(mr);
        }
        return (C)result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flatMap(c, 0, c.size(), func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flatMap(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends Collection<? extends R>, E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        Collection result = (Collection)supplier.apply(len);
        Collection<Object> mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(mr);
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(mr);
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return (C)result;
    }

    public static <T, T2, R, E extends Exception, E2 extends Exception> List<R> flatMap(T[] a, Throwables.Function<? super T, ? extends Collection<? extends T2>, E> func, Throwables.Function<? super T2, ? extends Collection<? extends R>, E2> func2) throws E, E2 {
        return N.flatMap(a, func, func2, Fn.Factory.ofList());
    }

    public static <T, T2, R, C extends Collection<R>, E extends Exception, E2 extends Exception> C flatMap(T[] a, Throwables.Function<? super T, ? extends Collection<? extends T2>, E> func, Throwables.Function<? super T2, ? extends Collection<? extends R>, E2> func2, IntFunction<? extends C> supplier) throws E, E2 {
        N.checkArgNotNull(func);
        N.checkArgNotNull(func2);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        int len = a.length > 0x3FFFFFFB ? 0x7FFFFFF7 : a.length * 2;
        Collection result = (Collection)supplier.apply(len);
        for (T e : a) {
            Collection<T2> c1 = func.apply(e);
            if (!N.notNullOrEmpty(c1)) continue;
            for (T2 e2 : c1) {
                Collection<? extends R> c2 = func2.apply(e2);
                if (!N.notNullOrEmpty(c2)) continue;
                result.addAll(c2);
            }
        }
        return (C)result;
    }

    public static <T, T2, R, E extends Exception, E2 extends Exception> List<R> flatMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends Collection<? extends T2>, E> func, Throwables.Function<? super T2, ? extends Collection<? extends R>, E2> func2) throws E, E2 {
        return N.flatMap(c, func, func2, Fn.Factory.ofList());
    }

    public static <T, T2, R, C extends Collection<R>, E extends Exception, E2 extends Exception> C flatMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends Collection<? extends T2>, E> func, Throwables.Function<? super T2, ? extends Collection<? extends R>, E2> func2, IntFunction<? extends C> supplier) throws E, E2 {
        N.checkArgNotNull(func);
        N.checkArgNotNull(func2);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        int len = c.size() > 0x3FFFFFFB ? 0x7FFFFFF7 : c.size() * 2;
        Collection result = (Collection)supplier.apply(len);
        for (T e : c) {
            Collection<T2> c1 = func.apply(e);
            if (!N.notNullOrEmpty(c1)) continue;
            for (T2 e2 : c1) {
                Collection<? extends R> c2 = func2.apply(e2);
                if (!N.notNullOrEmpty(c2)) continue;
                result.addAll(c2);
            }
        }
        return (C)result;
    }

    public static <T, R, E extends Exception> List<R> flattMap(T[] a, Throwables.Function<? super T, ? extends R[], E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.flattMap(a, 0, a.length, func);
    }

    public static <T, R, E extends Exception> List<R> flattMap(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R[], E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList();
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        ArrayList<Object> result = new ArrayList<Object>(len);
        Object[] mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(Arrays.asList(mr));
        }
        return result;
    }

    public static <T, R, E extends Exception> List<R> flattMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends R[], E> func) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.flattMap(c, 0, c.size(), func);
    }

    public static <T, R, E extends Exception> List<R> flattMap(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R[], E> func) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return new ArrayList();
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        ArrayList<Object> result = new ArrayList<Object>(len);
        Object[] mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(Arrays.asList(mr));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(Arrays.asList(mr));
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(T[] a, Throwables.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flattMap(a, 0, a.length, func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        Collection result = (Collection)supplier.apply(len);
        Object[] mr = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mr = func.apply(a[i]);
            if (!N.notNullOrEmpty(mr)) continue;
            result.addAll(Arrays.asList(mr));
        }
        return (C)result;
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(Collection<? extends T> c, Throwables.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.apply(0));
        }
        return N.flattMap(c, 0, c.size(), func, supplier);
    }

    public static <T, R, C extends Collection<R>, E extends Exception> C flattMap(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ? extends R[], E> func, IntFunction<? extends C> supplier) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(func);
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return (C)((Collection)supplier.apply(0));
        }
        int len = (float)(toIndex - fromIndex) > 1.2271336E9f ? 0x7FFFFFF7 : (int)((float)(toIndex - fromIndex) * 1.75f);
        Collection result = (Collection)supplier.apply(len);
        Object[] mr = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                mr = func.apply(list.get(i));
                if (!N.notNullOrEmpty(mr)) continue;
                result.addAll(Arrays.asList(mr));
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                mr = func.apply(e);
                if (N.notNullOrEmpty(mr)) {
                    result.addAll(Arrays.asList(mr));
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return (C)result;
    }

    public static <T, E extends Exception> List<T> takeWhile(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.size(c)));
        if (N.isNullOrEmpty(c)) {
            return result;
        }
        for (T e : c) {
            if (!filter.test(e)) break;
            result.add(e);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> takeWhile(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.len(a)));
        if (N.isNullOrEmpty(a)) {
            return result;
        }
        for (T e : a) {
            if (!filter.test(e)) break;
            result.add(e);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> takeWhileInclusive(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.size(c)));
        if (N.isNullOrEmpty(c)) {
            return result;
        }
        for (T e : c) {
            result.add(e);
            if (filter.test(e)) continue;
            break;
        }
        return result;
    }

    public static <T, E extends Exception> List<T> takeWhileInclusive(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.len(a)));
        if (N.isNullOrEmpty(a)) {
            return result;
        }
        for (T e : a) {
            result.add(e);
            if (!filter.test(e)) break;
        }
        return result;
    }

    public static <T, E extends Exception> List<T> dropWhile(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.size(c)));
        if (N.isNullOrEmpty(c)) {
            return result;
        }
        Iterator<T> iter = c.iterator();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            if (filter.test(e)) continue;
            result.add(e);
            break;
        }
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static <T, E extends Exception> List<T> dropWhile(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        int idx;
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.len(a)));
        if (N.isNullOrEmpty(a)) {
            return result;
        }
        int len = a.length;
        for (idx = 0; idx < len && filter.test(a[idx]); ++idx) {
        }
        while (idx < len) {
            result.add(a[idx++]);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> skipUntil(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.size(c)));
        if (N.isNullOrEmpty(c)) {
            return result;
        }
        Iterator<T> iter = c.iterator();
        Object e = null;
        while (iter.hasNext()) {
            e = iter.next();
            if (!filter.test(e)) continue;
            result.add(e);
            break;
        }
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static <T, E extends Exception> List<T> skipUntil(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        int idx;
        N.checkArgNotNull(filter, "filter");
        ArrayList<T> result = new ArrayList<T>(N.min(9, N.len(a)));
        if (N.isNullOrEmpty(a)) {
            return result;
        }
        int len = a.length;
        for (idx = 0; idx < len && !filter.test(a[idx]); ++idx) {
        }
        while (idx < len) {
            result.add(a[idx++]);
        }
        return result;
    }

    public static boolean[] distinct(boolean[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static boolean[] distinct(boolean[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex);
    }

    public static char[] distinct(char[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static char[] distinct(char[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static byte[] distinct(byte[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static byte[] distinct(byte[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static short[] distinct(short[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static short[] distinct(short[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static int[] distinct(int[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static int[] distinct(int[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static long[] distinct(long[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static long[] distinct(long[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static float[] distinct(float[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static float[] distinct(float[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static double[] distinct(double[] a) {
        return N.distinct(a, 0, N.len(a));
    }

    public static double[] distinct(double[] a, int fromIndex, int toIndex) {
        return N.removeDuplicates(a, fromIndex, toIndex, false);
    }

    public static <T> List<T> distinct(T[] a) {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.distinct(a, 0, a.length);
    }

    public static <T> List<T> distinct(T[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList();
        }
        int initCapacity = (toIndex - fromIndex) / 2 + 1;
        ArrayList<T> result = new ArrayList<T>(initCapacity);
        Set set = N.newHashSet(initCapacity);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!set.add(N.hashKey(a[i]))) continue;
            result.add(a[i]);
        }
        return result;
    }

    public static <T> List<T> distinct(Collection<? extends T> c) {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.distinct(c, 0, c.size());
    }

    public static <T> List<T> distinct(Collection<? extends T> c, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return new ArrayList();
        }
        int initCapacity = (toIndex - fromIndex) / 2 + 1;
        ArrayList<Object> result = new ArrayList<Object>(initCapacity);
        Set set = N.newHashSet(initCapacity);
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                if (!set.add(N.hashKey(e))) continue;
                result.add(e);
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < toIndex && it.hasNext(); ++i) {
                e = it.next();
                if (i < fromIndex || !set.add(N.hashKey(e))) continue;
                result.add(e);
            }
        }
        return result;
    }

    public static <T, E extends Exception> List<T> distinctBy(T[] a, Throwables.Function<? super T, ?, E> keyMapper) throws E {
        if (N.isNullOrEmpty(a)) {
            return new ArrayList();
        }
        return N.distinctBy(a, 0, a.length, keyMapper);
    }

    public static <T, E extends Exception> List<T> distinctBy(T[] a, int fromIndex, int toIndex, Throwables.Function<? super T, ?, E> keyMapper) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return new ArrayList();
        }
        int initCapacity = (toIndex - fromIndex) / 2 + 1;
        ArrayList<T> result = new ArrayList<T>(initCapacity);
        Set set = N.newHashSet(initCapacity);
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!set.add(N.hashKey(keyMapper.apply(a[i])))) continue;
            result.add(a[i]);
        }
        return result;
    }

    public static <T, C extends Collection<T>, E extends Exception> C distinctBy(T[] a, Throwables.Function<? super T, ?, E> keyMapper, Supplier<C> supplier) throws E {
        if (N.isNullOrEmpty(a)) {
            return (C)((Collection)supplier.get());
        }
        Collection result = (Collection)supplier.get();
        Set set = N.newHashSet(N.len(a) / 2 + 1);
        for (T e : a) {
            if (!set.add(N.hashKey(keyMapper.apply(e)))) continue;
            result.add(e);
        }
        return (C)result;
    }

    public static <T, E extends Exception> List<T> distinctBy(Collection<? extends T> c, Throwables.Function<? super T, ?, E> keyMapper) throws E {
        if (N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        return N.distinctBy(c, 0, c.size(), keyMapper);
    }

    public static <T, E extends Exception> List<T> distinctBy(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Function<? super T, ?, E> keyMapper) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex) {
            return new ArrayList();
        }
        int initCapacity = (toIndex - fromIndex) / 2 + 1;
        ArrayList<Object> result = new ArrayList<Object>(initCapacity);
        Set set = N.newHashSet(initCapacity);
        Object e = null;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                e = list.get(i);
                if (!set.add(N.hashKey(keyMapper.apply(e)))) continue;
                result.add(e);
            }
        } else {
            Iterator<T> it = c.iterator();
            for (int i = 0; i < toIndex && it.hasNext(); ++i) {
                e = it.next();
                if (i < fromIndex || !set.add(N.hashKey(keyMapper.apply(e)))) continue;
                result.add(e);
            }
        }
        return result;
    }

    public static <T, C extends Collection<T>, E extends Exception> C distinctBy(Collection<? extends T> c, Throwables.Function<? super T, ?, E> keyMapper, Supplier<C> supplier) throws E {
        if (N.isNullOrEmpty(c)) {
            return (C)((Collection)supplier.get());
        }
        Collection result = (Collection)supplier.get();
        Set set = N.newHashSet(N.size(c) / 2 + 1);
        for (T e : c) {
            if (!set.add(N.hashKey(keyMapper.apply(e)))) continue;
            result.add(e);
        }
        return (C)result;
    }

    public static <T, E extends Exception> boolean allMatch(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return true;
        }
        for (T e : a) {
            if (filter.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean allMatch(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return true;
        }
        for (T e : c) {
            if (filter.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean allMatch(Iterator<? extends T> iter, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return true;
        }
        while (iter.hasNext()) {
            if (filter.test(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean anyMatch(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return false;
        }
        for (T e : a) {
            if (!filter.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <T, E extends Exception> boolean anyMatch(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return false;
        }
        for (T e : c) {
            if (!filter.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <T, E extends Exception> boolean anyMatch(Iterator<? extends T> iter, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return false;
        }
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            return true;
        }
        return false;
    }

    public static <T, E extends Exception> boolean noneMatch(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return true;
        }
        for (T e : a) {
            if (!filter.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean noneMatch(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return true;
        }
        for (T e : c) {
            if (!filter.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean noneMatch(Iterator<? extends T> iter, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return true;
        }
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static <T, E extends Exception> boolean nMatch(T[] a, int atLeast, int atMost, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNegative(atLeast, "atLeast");
        N.checkArgNotNegative(atMost, "atMost");
        N.checkArgument(atLeast <= atMost, "'atLeast' must be <= 'atMost'");
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return atLeast == 0;
        }
        int len = N.len(a);
        if (len < atLeast) {
            return false;
        }
        long cnt = 0L;
        for (int i = 0; i < len; ++i) {
            if (!filter.test(a[i]) || ++cnt <= (long)atMost) continue;
            return false;
        }
        return cnt >= (long)atLeast && cnt <= (long)atMost;
    }

    public static <T, E extends Exception> boolean nMatch(Collection<? extends T> c, int atLeast, int atMost, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNegative(atLeast, "atLeast");
        N.checkArgNotNegative(atMost, "atMost");
        N.checkArgument(atLeast <= atMost, "'atLeast' must be <= 'atMost'");
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return atLeast == 0;
        }
        int size = N.size(c);
        if (size < atLeast) {
            return false;
        }
        long cnt = 0L;
        for (T e : c) {
            if (!filter.test(e) || ++cnt <= (long)atMost) continue;
            return false;
        }
        return cnt >= (long)atLeast && cnt <= (long)atMost;
    }

    public static <T, E extends Exception> boolean nMatch(Iterator<? extends T> iter, int atLeast, int atMost, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNegative(atLeast, "atLeast");
        N.checkArgNotNegative(atMost, "atMost");
        N.checkArgument(atLeast <= atMost, "'atLeast' must be <= 'atMost'");
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return atLeast == 0;
        }
        long cnt = 0L;
        while (iter.hasNext()) {
            if (!filter.test(iter.next()) || ++cnt <= (long)atMost) continue;
            return false;
        }
        return cnt >= (long)atLeast && cnt <= (long)atMost;
    }

    public static <E extends Exception> int count(boolean[] a, Throwables.BooleanPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(boolean[] a, int fromIndex, int toIndex, Throwables.BooleanPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(char[] a, Throwables.CharPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(char[] a, int fromIndex, int toIndex, Throwables.CharPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(byte[] a, Throwables.BytePredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(byte[] a, int fromIndex, int toIndex, Throwables.BytePredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(short[] a, Throwables.ShortPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(short[] a, int fromIndex, int toIndex, Throwables.ShortPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(int[] a, Throwables.IntPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(int[] a, int fromIndex, int toIndex, Throwables.IntPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(long[] a, Throwables.LongPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(long[] a, int fromIndex, int toIndex, Throwables.LongPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(float[] a, Throwables.FloatPredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(float[] a, int fromIndex, int toIndex, Throwables.FloatPredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int count(double[] a, Throwables.DoublePredicate<E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <E extends Exception> int count(double[] a, int fromIndex, int toIndex, Throwables.DoublePredicate<E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <T, E extends Exception> int count(T[] a, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a)) {
            return 0;
        }
        return N.count(a, 0, a.length, filter);
    }

    public static <T, E extends Exception> int count(T[] a, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(a) || fromIndex == toIndex) {
            return 0;
        }
        int count = 0;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (!filter.test(a[i])) continue;
            ++count;
        }
        return count;
    }

    public static <T, E extends Exception> int count(Collection<? extends T> c, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c)) {
            return 0;
        }
        return N.count(c, 0, c.size(), filter);
    }

    public static <T, E extends Exception> int count(Collection<? extends T> c, int fromIndex, int toIndex, Throwables.Predicate<? super T, E> filter) throws E {
        N.checkFromToIndex(fromIndex, toIndex, N.size(c));
        N.checkArgNotNull(filter, "filter");
        if (N.isNullOrEmpty(c) && fromIndex == 0 && toIndex == 0 || fromIndex == toIndex && fromIndex < c.size()) {
            return 0;
        }
        int count = 0;
        if (c instanceof List && c instanceof RandomAccess) {
            List list = (List)c;
            for (int i = fromIndex; i < toIndex; ++i) {
                if (!filter.test(list.get(i))) continue;
                ++count;
            }
        } else {
            int idx = 0;
            for (T e : c) {
                if (idx++ < fromIndex) continue;
                if (filter.test(e)) {
                    ++count;
                }
                if (idx < toIndex) continue;
                break;
            }
        }
        return count;
    }

    public static int count(Iterator<?> iter) throws ArithmeticException {
        if (iter == null) {
            return 0;
        }
        long res = 0L;
        while (iter.hasNext()) {
            iter.next();
            ++res;
        }
        return N.toIntExact(res);
    }

    public static <T, E extends Exception> int count(Iterator<? extends T> iter, Throwables.Predicate<? super T, E> filter) throws ArithmeticException, E {
        N.checkArgNotNull(filter, "filter");
        if (iter == null) {
            return 0;
        }
        long res = 0L;
        while (iter.hasNext()) {
            if (!filter.test(iter.next())) continue;
            ++res;
        }
        return N.toIntExact(res);
    }

    public static String toJSON(Object obj) {
        return Utils.jsonParser.serialize(obj, Utils.jsc);
    }

    public static String toJSON(Object obj, boolean prettyFormat) {
        return Utils.jsonParser.serialize(obj, prettyFormat ? Utils.jscPrettyFormat : Utils.jsc);
    }

    public static String toJSON(Object obj, JSONSerializationConfig config) {
        return Utils.jsonParser.serialize(obj, config);
    }

    public static void toJSON(File file, Object obj) {
        Utils.jsonParser.serialize(file, obj);
    }

    public static void toJSON(File file, Object obj, JSONSerializationConfig config) {
        Utils.jsonParser.serialize(file, obj, config);
    }

    public static void toJSON(OutputStream os, Object obj) {
        Utils.jsonParser.serialize(os, obj);
    }

    public static void toJSON(OutputStream os, Object obj, JSONSerializationConfig config) {
        Utils.jsonParser.serialize(os, obj, config);
    }

    public static void toJSON(Writer writer, Object obj) {
        Utils.jsonParser.serialize(writer, obj);
    }

    public static void toJSON(Writer writer, Object obj, JSONSerializationConfig config) {
        Utils.jsonParser.serialize(writer, obj, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, File json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, File json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, InputStream json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, InputStream json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, Reader json) {
        return Utils.jsonParser.deserialize(targetClass, json);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, Reader json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, config);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json, int fromIndex, int toIndex) {
        return Utils.jsonParser.deserialize(targetClass, json, fromIndex, toIndex);
    }

    public static <T> T fromJSON(Class<? extends T> targetClass, String json, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetClass, json, fromIndex, toIndex, config);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, File json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, File json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, InputStream json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, InputStream json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, Reader json) {
        return N.fromJSON(targetType, json, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, Reader json, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, N.setConfig(targetType, config, true));
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json, int fromIndex, int toIndex) {
        return N.fromJSON(targetType, json, fromIndex, toIndex, null);
    }

    public static <T> T fromJSON(Type<? extends T> targetType, String json, int fromIndex, int toIndex, JSONDeserializationConfig config) {
        return Utils.jsonParser.deserialize(targetType.clazz(), json, fromIndex, toIndex, N.setConfig(targetType, config, true));
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, String source) {
        return Utils.jsonParser.stream(elementClass, source);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, String source, JSONDeserializationConfig config) {
        return Utils.jsonParser.stream(elementClass, source, config);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, File source) {
        return Utils.jsonParser.stream(elementClass, source);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, File source, JSONDeserializationConfig config) {
        return Utils.jsonParser.stream(elementClass, source, config);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, InputStream source) {
        return Utils.jsonParser.stream(elementClass, source);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, InputStream source, JSONDeserializationConfig config) {
        return Utils.jsonParser.stream(elementClass, source, config);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, Reader source) {
        return Utils.jsonParser.stream(elementClass, source);
    }

    public static <T> ExceptionalStream<T, IOException> streamJSON(Class<T> elementClass, Reader source, JSONDeserializationConfig config) {
        return Utils.jsonParser.stream(elementClass, source, config);
    }

    public static String formatJSON(String json) {
        return N.formatJSON(Object.class, json);
    }

    public static String formatJSON(Class<?> type, String json) {
        return N.toJSON(N.fromJSON(type, json), Utils.jscPrettyFormat);
    }

    public static String formatJSON(Type<?> type, String json) {
        return N.toJSON(N.fromJSON(type, json), Utils.jscPrettyFormat);
    }

    public static String toXML(Object obj) {
        return Utils.xmlParser.serialize(obj);
    }

    public static String toXML(Object obj, boolean prettyFormat) {
        return Utils.xmlParser.serialize(obj, prettyFormat ? Utils.xscPrettyFormat : Utils.xsc);
    }

    public static String toXML(Object obj, XMLSerializationConfig config) {
        return Utils.xmlParser.serialize(obj, config);
    }

    public static void toXML(File file, Object obj) {
        Utils.xmlParser.serialize(file, obj);
    }

    public static void toXML(File file, Object obj, XMLSerializationConfig config) {
        Utils.xmlParser.serialize(file, obj, config);
    }

    public static void toXML(OutputStream os, Object obj) {
        Utils.xmlParser.serialize(os, obj);
    }

    public static void toXML(OutputStream os, Object obj, XMLSerializationConfig config) {
        Utils.xmlParser.serialize(os, obj, config);
    }

    public static void toXML(Writer writer, Object obj) {
        Utils.xmlParser.serialize(writer, obj);
    }

    public static void toXML(Writer writer, Object obj, XMLSerializationConfig config) {
        Utils.xmlParser.serialize(writer, obj, config);
    }

    public static String formatXML(String xml) {
        return N.formatXML(MapEntity.class, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, String xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, String xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, File xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, File xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, InputStream xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, InputStream xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, Reader xml) {
        return Utils.xmlParser.deserialize(targetClass, xml);
    }

    public static <T> T fromXML(Class<? extends T> targetClass, Reader xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetClass, xml, config);
    }

    public static <T> T fromXML(Type<? extends T> targetType, String xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, String xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    public static <T> T fromXML(Type<? extends T> targetType, File xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, File xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    public static <T> T fromXML(Type<? extends T> targetType, InputStream xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, InputStream xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    public static <T> T fromXML(Type<? extends T> targetType, Reader xml) {
        return N.fromJSON(targetType, xml, null);
    }

    public static <T> T fromXML(Type<? extends T> targetType, Reader xml, XMLDeserializationConfig config) {
        return Utils.xmlParser.deserialize(targetType.clazz(), xml, N.setConfig(targetType, config, false));
    }

    private static <C extends DeserializationConfig<C>> C setConfig(Type<?> targetType, C config, boolean isJSON) {
        Object configToReturn = config;
        if (targetType.isCollection() || targetType.isArray()) {
            if (config == null || config.getElementType() == null) {
                configToReturn = config == null ? (isJSON ? JSONDeserializationConfig.JDC.create() : XMLDeserializationConfig.XDC.create()) : (DeserializationConfig)config.copy();
                ((DeserializationConfig)configToReturn).setElementType(targetType.getParameterTypes()[0]);
            }
        } else if (targetType.isMap() && (config == null || config.getMapKeyType() == null || config.getMapValueType() == null)) {
            Object object = config == null ? (isJSON ? JSONDeserializationConfig.JDC.create() : XMLDeserializationConfig.XDC.create()) : (configToReturn = (DeserializationConfig)config.copy());
            if (((DeserializationConfig)configToReturn).getMapKeyType() == null) {
                ((DeserializationConfig)configToReturn).setMapKeyType(targetType.getParameterTypes()[0]);
            }
            if (((DeserializationConfig)configToReturn).getMapValueType() == null) {
                ((DeserializationConfig)configToReturn).setMapValueType(targetType.getParameterTypes()[1]);
            }
        }
        return (C)configToReturn;
    }

    public static String formatXML(Class<?> type, String xml) {
        return N.toXML(N.fromXML(type, xml), Utils.xscPrettyFormat);
    }

    public static String formatXML(Type<?> type, String xml) {
        return N.toXML(N.fromXML(type, xml), Utils.xscPrettyFormat);
    }

    public static String xml2JSON(String xml) {
        return N.xml2JSON(Map.class, xml);
    }

    public static String xml2JSON(Class<?> cls, String xml) {
        return Utils.jsonParser.serialize(Utils.xmlParser.deserialize(cls, xml), Utils.jsc);
    }

    public static String json2XML(String json) {
        return N.json2XML(Map.class, json);
    }

    public static String json2XML(Class<?> cls, String json) {
        return Utils.xmlParser.serialize(Utils.jsonParser.deserialize(cls, json));
    }

    public static void runUninterruptibly(Throwables.Runnable<InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        while (true) {
            try {
                cmd.run();
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void runUninterruptibly(long timeoutInMillis, Throwables.LongConsumer<InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        try {
            long remainingMillis = timeoutInMillis;
            long sysMillis = System.currentTimeMillis();
            long end = remainingMillis >= Long.MAX_VALUE - sysMillis ? Long.MAX_VALUE : sysMillis + remainingMillis;
            while (true) {
                try {
                    cmd.accept(remainingMillis);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingMillis = end - System.currentTimeMillis();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void runUninterruptibly(long timeout, TimeUnit unit, Throwables.BiConsumer<Long, TimeUnit, InterruptedException> cmd) throws IllegalArgumentException {
        N.checkArgNotNull(unit, "unit");
        N.checkArgNotNull(cmd, "cmd");
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                try {
                    cmd.accept(remainingNanos, TimeUnit.NANOSECONDS);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T callUninterruptibly(Throwables.Callable<T, InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        while (true) {
            try {
                T t = cmd.call();
                return t;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T callUninterruptibly(long timeoutInMillis, Throwables.LongFunction<T, InterruptedException> cmd) {
        N.checkArgNotNull(cmd);
        boolean interrupted = false;
        try {
            long remainingMillis = timeoutInMillis;
            long sysMillis = System.currentTimeMillis();
            long end = remainingMillis >= Long.MAX_VALUE - sysMillis ? Long.MAX_VALUE : sysMillis + remainingMillis;
            while (true) {
                T t;
                try {
                    t = cmd.apply(remainingMillis);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingMillis = end - System.currentTimeMillis();
                    continue;
                }
                return t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static <T> T callUninterruptibly(long timeout, TimeUnit unit, Throwables.BiFunction<Long, TimeUnit, T, InterruptedException> cmd) throws IllegalArgumentException {
        N.checkArgNotNull(unit, "unit");
        N.checkArgNotNull(cmd, "cmd");
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                T t;
                try {
                    t = cmd.apply(remainingNanos, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                return t;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void sleep(long timeoutInMillis) {
        if (timeoutInMillis <= 0L) {
            return;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(timeoutInMillis);
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
    }

    public static void sleep(long timeout, TimeUnit unit) throws IllegalArgumentException {
        N.checkArgNotNull(unit, "unit");
        if (timeout <= 0L) {
            return;
        }
        try {
            unit.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
    }

    public static void sleepUninterruptibly(long timeoutInMillis) {
        if (timeoutInMillis <= 0L) {
            return;
        }
        boolean interrupted = false;
        try {
            long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeoutInMillis);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void sleepUninterruptibly(long timeout, TimeUnit unit) throws IllegalArgumentException {
        N.checkArgNotNull(unit, "unit");
        if (timeout <= 0L) {
            return;
        }
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(timeout);
            long sysNanos = System.nanoTime();
            long end = remainingNanos >= Long.MAX_VALUE - sysNanos ? Long.MAX_VALUE : sysNanos + remainingNanos;
            while (true) {
                try {
                    TimeUnit.NANOSECONDS.sleep(remainingNanos);
                    return;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static RuntimeException toRuntimeException(Throwable e) {
        return ExceptionUtil.toRuntimeException(e);
    }

    public static boolean hasCause(Throwable e, Class<? extends Throwable> type) {
        return ExceptionUtil.hasCause(e, type);
    }

    public static Throwable firstCause(Throwable e) {
        return ExceptionUtil.firstCause(e);
    }

    public static <T> T println(T obj) {
        if (obj instanceof Collection) {
            System.out.println(Joiner.with(ELEMENT_SEPARATOR, "[", "]").reuseCachedBuffer().appendAll((Collection)obj));
        } else if (obj instanceof Map) {
            System.out.println(Joiner.with(ELEMENT_SEPARATOR, "=", "{", "}").reuseCachedBuffer().appendEntries((Map)obj));
        } else {
            System.out.println(N.toString(obj));
        }
        return obj;
    }

    @SafeVarargs
    public static <T> T[] fprintln(String format, T ... args) {
        System.out.printf(format, args);
        System.out.println();
        return args;
    }

    public static int toIntExact(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    @Beta
    public static <T> u.Nullable<T> castIfAssignable(Object val, Class<T> targetType) {
        if (N.isPrimitiveType(targetType)) {
            return val != null && N.wrap(targetType).isAssignableFrom(val.getClass()) ? u.Nullable.of(val) : u.Nullable.empty();
        }
        return val == null || targetType.isAssignableFrom(val.getClass()) ? u.Nullable.of(val) : u.Nullable.empty();
    }

    @Beta
    public static <R> u.Nullable<R> tryOrEmpty(Callable<R> cmd) {
        try {
            return u.Nullable.of(cmd.call());
        }
        catch (Exception e) {
            return u.Nullable.empty();
        }
    }

    @Beta
    public static <T, R, E extends Exception> u.Nullable<R> tryOrEmpty(T init, Throwables.Function<? super T, R, E> func) {
        try {
            return u.Nullable.of(func.apply(init));
        }
        catch (Exception e) {
            return u.Nullable.empty();
        }
    }

    @Beta
    public static <R, E extends Exception> u.Nullable<R> ifOrEmpty(boolean b, Throwables.Supplier<R, E> supplier) throws E {
        if (b) {
            return u.Nullable.of(supplier.get());
        }
        return u.Nullable.empty();
    }

    @Beta
    public static <T, R, E extends Exception> u.Nullable<R> ifOrEmpty(boolean b, T init, Throwables.Function<? super T, R, E> func) throws E {
        if (b) {
            return u.Nullable.of(func.apply(init));
        }
        return u.Nullable.empty();
    }

    @Beta
    public static <E1 extends Exception, E2 extends Exception> void ifOrElse(boolean b, Throwables.Runnable<E1> actionForTrue, Throwables.Runnable<E2> actionForFalse) throws E1, E2 {
        if (b) {
            if (actionForTrue != null) {
                actionForTrue.run();
            }
        } else if (actionForFalse != null) {
            actionForFalse.run();
        }
    }

    @Beta
    public static <T, E1 extends Exception, E2 extends Exception> void ifOrElse(boolean b, T init, Throwables.Consumer<? super T, E1> actionForTrue, Throwables.Consumer<? super T, E2> actionForFalse) throws E1, E2 {
        if (b) {
            if (actionForTrue != null) {
                actionForTrue.accept(init);
            }
        } else if (actionForFalse != null) {
            actionForFalse.accept(init);
        }
    }

    @Beta
    public static <T> LazyInitializer<T> lazyInit(Supplier<T> supplier) {
        return LazyInitializer.of(supplier);
    }

    @Beta
    public static <T, E extends Exception> Throwables.LazyInitializer<T, E> lazyInitialize(Throwables.Supplier<T, E> supplier) {
        return Throwables.LazyInitializer.of(supplier);
    }

    @Beta
    public static <T> ObjIterator<T> iterate(T[] a) {
        return ObjIterator.of(a);
    }

    @Beta
    public static <T> ObjIterator<T> iterate(T[] a, int fromIndex, int toIndex) {
        return ObjIterator.of(a, fromIndex, toIndex);
    }

    @Beta
    public static <T> Iterator<T> iterate(Iterable<? extends T> iterable) {
        return iterable == null ? ObjIterator.empty() : iterable.iterator();
    }

    public static boolean disjoint(Object[] a, Object[] b) {
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return true;
        }
        return a.length >= b.length ? N.disjoint(Arrays.asList(a), N.asSet(b)) : N.disjoint(N.asSet(a), Arrays.asList(b));
    }

    public static boolean disjoint(Collection<?> c1, Collection<?> c2) {
        if (N.isNullOrEmpty(c1) || N.isNullOrEmpty(c2)) {
            return true;
        }
        if (c1 instanceof Set || !(c2 instanceof Set) && c1.size() > c2.size()) {
            for (Object e : c2) {
                if (!c1.contains(e)) continue;
                return false;
            }
        } else {
            for (Object e : c1) {
                if (!c2.contains(e)) continue;
                return false;
            }
        }
        return true;
    }

    public static <T, E extends Exception> List<T> merge(T[] a, T[] b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) throws E {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList() : N.asList(b);
        }
        if (N.isNullOrEmpty(b)) {
            return N.asList(a);
        }
        ArrayList<T> result = new ArrayList<T>(a.length + b.length);
        int lenA = a.length;
        int lenB = b.length;
        int cursorA = 0;
        int cursorB = 0;
        while (cursorA < lenA || cursorB < lenB) {
            if (cursorA < lenA) {
                if (cursorB < lenB) {
                    if (nextSelector.apply(a[cursorA], b[cursorB]) == MergeResult.TAKE_FIRST) {
                        result.add(a[cursorA++]);
                        continue;
                    }
                    result.add(b[cursorB++]);
                    continue;
                }
                result.add(a[cursorA++]);
                continue;
            }
            result.add(b[cursorB++]);
        }
        return result;
    }

    public static <T, E extends Exception> List<T> merge(Collection<? extends T> a, Collection<? extends T> b, Throwables.BiFunction<? super T, ? super T, MergeResult, E> nextSelector) throws E {
        if (N.isNullOrEmpty(a)) {
            return N.isNullOrEmpty(b) ? new ArrayList() : new ArrayList<T>(b);
        }
        if (N.isNullOrEmpty(b)) {
            return new ArrayList<T>(a);
        }
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        Iterator<T> iterA = a.iterator();
        Iterator<T> iterB = b.iterator();
        Object nextA = null;
        Object nextB = null;
        boolean hasNextA = false;
        boolean hasNextB = false;
        while (hasNextA || hasNextB || iterA.hasNext() || iterB.hasNext()) {
            if (hasNextA) {
                if (iterB.hasNext()) {
                    T t = iterB.next();
                    nextB = t;
                    if (nextSelector.apply(nextA, t) == MergeResult.TAKE_FIRST) {
                        hasNextA = false;
                        hasNextB = true;
                        result.add(nextA);
                        continue;
                    }
                    result.add(nextB);
                    continue;
                }
                hasNextA = false;
                result.add(nextA);
                continue;
            }
            if (hasNextB) {
                if (iterA.hasNext()) {
                    T t = iterA.next();
                    nextA = t;
                    if (nextSelector.apply(t, nextB) == MergeResult.TAKE_FIRST) {
                        result.add(nextA);
                        continue;
                    }
                    hasNextA = true;
                    hasNextB = false;
                    result.add(nextB);
                    continue;
                }
                hasNextB = false;
                result.add(nextB);
                continue;
            }
            if (iterA.hasNext()) {
                if (iterB.hasNext()) {
                    T t = iterA.next();
                    nextA = t;
                    T t2 = iterB.next();
                    nextB = t2;
                    if (nextSelector.apply(t, t2) == MergeResult.TAKE_FIRST) {
                        hasNextB = true;
                        result.add(nextA);
                        continue;
                    }
                    hasNextA = true;
                    result.add(nextB);
                    continue;
                }
                result.add(iterA.next());
                continue;
            }
            result.add(iterB.next());
        }
        return result;
    }

    public static <T> List<T> merge(Collection<? extends Collection<? extends T>> c, BiFunction<? super T, ? super T, MergeResult> nextSelector) {
        return N.toList(Iterators.mergge(c, nextSelector));
    }

    public static <T, C extends Collection<T>> C merge(Collection<? extends Collection<? extends T>> c, BiFunction<? super T, ? super T, MergeResult> nextSelector, final IntFunction<? extends C> supplier) {
        int size = 0;
        for (Collection<T> collection : c) {
            size += N.size(collection);
        }
        final int totalCount = size;
        Supplier supplier2 = new Supplier<C>(){

            @Override
            public C get() {
                return (Collection)supplier.apply(totalCount);
            }
        };
        return N.toCollection(Iterators.mergge(c, nextSelector), supplier2);
    }

    public static <A, B, R, E extends Exception> List<R> zip(A[] a, B[] b, Throwables.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        int minLen = N.min(a.length, b.length);
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(a[i], b[i]));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, Throwables.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b)) {
            return new ArrayList();
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        int minLen = N.min(a.size(), b.size());
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(iterA.next(), iterB.next()));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(A[] a, B[] b, C[] c, Throwables.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        int minLen = N.min(a.length, b.length, c.length);
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(a[i], b[i], c[i]));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, Throwables.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        if (N.isNullOrEmpty(a) || N.isNullOrEmpty(b) || N.isNullOrEmpty(c)) {
            return new ArrayList();
        }
        Iterator<A> iterA = a.iterator();
        Iterator<B> iterB = b.iterator();
        Iterator<C> iterC = c.iterator();
        int minLen = N.min(a.size(), b.size(), c.size());
        ArrayList<R> result = new ArrayList<R>(minLen);
        for (int i = 0; i < minLen; ++i) {
            result.add(zipFunction.apply(iterA.next(), iterB.next(), iterC.next()));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(A[] a, B[] b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int maxLen = N.max(lenA, lenB);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int maxLen = N.max(lenA, lenB);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int lenC = N.len(c);
        int maxLen = N.max(lenA, lenB, lenC);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB, i < lenC ? c[i] : valueForNoneC));
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> List<R> zip(Collection<A> a, Collection<B> b, Collection<C> c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        Iterator<Object> iterA = a == null ? ObjIterator.empty() : a.iterator();
        Iterator<Object> iterB = b == null ? ObjIterator.empty() : b.iterator();
        Iterator<Object> iterC = c == null ? ObjIterator.empty() : c.iterator();
        int lenA = N.size(a);
        int lenB = N.size(b);
        int lenC = N.size(c);
        int maxLen = N.max(lenA, lenB, lenC);
        ArrayList<R> result = new ArrayList<R>(maxLen);
        for (int i = 0; i < maxLen; ++i) {
            result.add(zipFunction.apply(i < lenA ? iterA.next() : valueForNoneA, i < lenB ? iterB.next() : valueForNoneB, i < lenC ? iterC.next() : valueForNoneC));
        }
        return result;
    }

    public static <A, B, R, E extends Exception> R[] zip(Class<R> targetElementType, A[] a, B[] b, Throwables.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int minLen = N.min(lenA, lenB);
        Object[] result = (Object[])N.newArray(targetElementType, minLen);
        for (int i = 0; i < minLen; ++i) {
            result[i] = zipFunction.apply(a[i], b[i]);
        }
        return result;
    }

    public static <A, B, R, E extends Exception> R[] zip(Class<R> targetElementType, A[] a, B[] b, A valueForNoneA, B valueForNoneB, Throwables.BiFunction<? super A, ? super B, R, E> zipFunction) throws E {
        Object[] result;
        block4: {
            int i;
            int maxLen;
            int lenB;
            block3: {
                N.checkArgNotNull(zipFunction);
                int lenA = N.len(a);
                lenB = N.len(b);
                int minLen = N.min(lenA, lenB);
                maxLen = N.max(lenA, lenB);
                result = (Object[])N.newArray(targetElementType, maxLen);
                for (i = 0; i < minLen; ++i) {
                    result[i] = zipFunction.apply(a[i], b[i]);
                }
                if (lenA >= maxLen) break block3;
                for (i = lenA; i < maxLen; ++i) {
                    result[i] = zipFunction.apply(valueForNoneA, b[i]);
                }
                break block4;
            }
            if (lenB >= maxLen) break block4;
            for (i = lenB; i < maxLen; ++i) {
                result[i] = zipFunction.apply(a[i], valueForNoneB);
            }
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> R[] zip(Class<R> targetElementType, A[] a, B[] b, C[] c, Throwables.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        N.checkArgNotNull(zipFunction);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int lenC = N.len(c);
        int minLen = N.min(lenA, lenB, lenC);
        Object[] result = (Object[])N.newArray(targetElementType, minLen);
        for (int i = 0; i < minLen; ++i) {
            result[i] = zipFunction.apply(a[i], b[i], c[i]);
        }
        return result;
    }

    public static <A, B, C, R, E extends Exception> R[] zip(Class<R> targetElementType, A[] a, B[] b, C[] c, A valueForNoneA, B valueForNoneB, C valueForNoneC, Throwables.TriFunction<? super A, ? super B, ? super C, R, E> zipFunction) throws E {
        int i;
        N.checkArgNotNull(zipFunction);
        int lenA = N.len(a);
        int lenB = N.len(b);
        int lenC = N.len(c);
        int minLen = N.min(lenA, lenB, lenC);
        int maxLen = N.max(lenA, lenB, lenC);
        Object[] result = (Object[])N.newArray(targetElementType, maxLen);
        for (i = 0; i < minLen; ++i) {
            result[i] = zipFunction.apply(a[i], b[i], c[i]);
        }
        if (minLen < maxLen) {
            for (i = minLen; i < maxLen; ++i) {
                result[i] = zipFunction.apply(i < lenA ? a[i] : valueForNoneA, i < lenB ? b[i] : valueForNoneB, i < lenC ? c[i] : valueForNoneC);
            }
        }
        return result;
    }

    public static <T, L, R, E extends Exception> Pair<List<L>, List<R>> unzip(Collection<? extends T> c, Throwables.BiConsumer<? super T, Pair<L, R>, E> unzip) throws E {
        N.checkArgNotNull(unzip);
        int len = N.size(c);
        ArrayList l = new ArrayList(len);
        ArrayList r = new ArrayList(len);
        Pair p = new Pair();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, p);
                l.add(p.left);
                r.add(p.right);
            }
        }
        return Pair.of(l, r);
    }

    public static <T, L, R, LC extends Collection<L>, RC extends Collection<R>, E extends Exception> Pair<LC, RC> unzip(Collection<? extends T> c, Throwables.BiConsumer<? super T, Pair<L, R>, E> unzip, IntFunction<? extends Collection<?>> supplier) throws E {
        N.checkArgNotNull(unzip);
        int len = N.size(c);
        Collection<?> l = supplier.apply(len);
        Collection<?> r = supplier.apply(len);
        Pair p = new Pair();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, p);
                l.add(p.left);
                r.add(p.right);
            }
        }
        return Pair.of(l, r);
    }

    public static <T, L, M, R, E extends Exception> Triple<List<L>, List<M>, List<R>> unzipp(Collection<? extends T> c, Throwables.BiConsumer<? super T, Triple<L, M, R>, E> unzip) throws E {
        N.checkArgNotNull(unzip);
        int len = N.size(c);
        ArrayList l = new ArrayList(len);
        ArrayList m = new ArrayList(len);
        ArrayList r = new ArrayList(len);
        Triple t = new Triple();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, t);
                l.add(t.left);
                m.add(t.middle);
                r.add(t.right);
            }
        }
        return Triple.of(l, m, r);
    }

    public static <T, L, M, R, LC extends Collection<L>, MC extends Collection<M>, RC extends Collection<R>, E extends Exception> Triple<LC, MC, RC> unzipp(Collection<? extends T> c, Throwables.BiConsumer<? super T, Triple<L, M, R>, E> unzip, IntFunction<? extends Collection<?>> supplier) throws E {
        N.checkArgNotNull(unzip);
        int len = N.size(c);
        Collection<?> l = supplier.apply(len);
        Collection<?> m = supplier.apply(len);
        Collection<?> r = supplier.apply(len);
        Triple t = new Triple();
        if (N.notNullOrEmpty(c)) {
            for (T e : c) {
                unzip.accept(e, t);
                l.add(t.left);
                m.add(t.middle);
                r.add(t.right);
            }
        }
        return Triple.of(l, m, r);
    }

    public static boolean isPrimitiveType(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        return N.typeOf(cls).isPrimitiveType();
    }

    public static boolean isWrapperType(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        return N.typeOf(cls).isPrimitiveWrapper();
    }

    public static boolean isPrimitiveArrayType(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        return N.typeOf(cls).isPrimitiveArray();
    }

    public static Class<?> wrap(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        Class<?> wrapped = PRIMITIVE_2_WRAPPER.get(cls);
        return wrapped == null ? cls : wrapped;
    }

    public static Class<?> unwrap(Class<?> cls) {
        N.checkArgNotNull(cls, "cls");
        Class<?> unwrapped = PRIMITIVE_2_WRAPPER.getByValue(cls);
        return unwrapped == null ? cls : unwrapped;
    }

    @Beta
    public static void invert(boolean[] a) {
        if (N.isNullOrEmpty(a)) {
            return;
        }
        N.invert(a, 0, a.length);
    }

    @Beta
    public static void invert(boolean[] a, int fromIndex, int toIndex) {
        N.checkFromToIndex(fromIndex, toIndex, N.len(a));
        if (fromIndex == toIndex) {
            return;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            a[i] = !a[i];
        }
    }

    @Beta
    public static <T, E extends Exception> void applyToEach(T[] a, Throwables.Function<? super T, ? extends T, E> converter) throws E {
        N.checkArgNotNull(converter);
        if (N.isNullOrEmpty(a)) {
            return;
        }
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = converter.apply(a[i]);
        }
    }

    @Beta
    public static <T, E extends Exception> void applyToEach(List<T> c, Throwables.Function<? super T, ? extends T, E> converter) throws E {
        N.checkArgNotNull(converter);
        if (N.isNullOrEmpty(c)) {
            return;
        }
        if (c instanceof ArrayList) {
            int size = c.size();
            for (int i = 0; i < size; ++i) {
                c.set(i, converter.apply(c.get(i)));
            }
        } else {
            ListIterator<T> iter = c.listIterator();
            while (iter.hasNext()) {
                iter.set(converter.apply(iter.next()));
            }
        }
    }

    public static <T, E extends Exception> T[] copyThenApply(T[] a, Throwables.Function<? super T, ? extends T, E> converter) throws E {
        N.checkArgNotNull(converter);
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return (Object[])a.clone();
        }
        Object[] copy = (Object[])a.clone();
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            copy[i] = converter.apply(a[i]);
        }
        return a;
    }

    static {
        PRIMITIVE_2_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_2_WRAPPER.put(Character.TYPE, Character.class);
        PRIMITIVE_2_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_2_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_2_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_2_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_2_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_2_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_2_WRAPPER.put(boolean[].class, Boolean[].class);
        PRIMITIVE_2_WRAPPER.put(char[].class, Character[].class);
        PRIMITIVE_2_WRAPPER.put(byte[].class, Byte[].class);
        PRIMITIVE_2_WRAPPER.put(short[].class, Short[].class);
        PRIMITIVE_2_WRAPPER.put(int[].class, Integer[].class);
        PRIMITIVE_2_WRAPPER.put(long[].class, Long[].class);
        PRIMITIVE_2_WRAPPER.put(float[].class, Float[].class);
        PRIMITIVE_2_WRAPPER.put(double[].class, Double[].class);
    }
}

