/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.CommonUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.u;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public final class Numbers {
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    private static final long ONE_BITS = Double.doubleToRawLongBits(1.0);
    static final int INT_MAX_POWER_OF_SQRT2_UNSIGNED = -1257966797;
    static final long MAX_POWER_OF_SQRT2_UNSIGNED = -5402926248376769404L;
    static final long MAX_SIGNED_POWER_OF_TWO = 0x4000000000000000L;
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    static final int FLOOR_SQRT_MAX_INT = 46340;
    static final long SIGNIFICAND_MASK = 0xFFFFFFFFFFFFFL;
    static final int SIGNIFICAND_BITS = 52;
    static final long EXPONENT_MASK = 0x7FF0000000000000L;
    static final long SIGN_MASK = Long.MIN_VALUE;
    static final int EXPONENT_BIAS = 1023;
    static final long IMPLICIT_BIT = 0x10000000000000L;
    private static final double MIN_INT_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
    static final byte[] int_maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    static final int[] int_powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] int_factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    static int[] int_biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};
    static final int[] int_halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    static final byte[] maxLog10ForLeadingZeros = new byte[]{19, 18, 18, 18, 18, 17, 17, 17, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0};
    static final long[] powersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    static final long[] halfPowersOf10 = new long[]{3L, 31L, 316L, 3162L, 31622L, 316227L, 3162277L, 31622776L, 316227766L, 3162277660L, 31622776601L, 316227766016L, 3162277660168L, 31622776601683L, 316227766016837L, 3162277660168379L, 31622776601683793L, 316227766016837933L, 3162277660168379331L};
    static final long[] long_factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};
    static final int[] biggestSimpleBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2642246, 86251, 11724, 3218, 1313, 684, 419, 287, 214, 169, 139, 119, 105, 95, 87, 81, 76, 73, 70, 68, 66, 64, 63, 62, 62, 61, 61, 61};
    private static final int SIEVE_30 = -545925251;
    private static final long[][] millerRabinBaseSets = new long[][]{{291830L, 126401071349994536L}, {885594168L, 725270293939359937L, 3569819667048198375L}, {273919523040L, 15L, 7363882082L, 992620450144556L}, {47636622961200L, 2L, 2570940L, 211991001L, 3749873356L}, {7999252175582850L, 2L, 4130806001517L, 149795463772692060L, 186635894390467037L, 3967304179347715805L}, {585226005592931976L, 2L, 123635709730000L, 9233062284813009L, 43835965440333360L, 761179012939631437L, 1263739024124850375L}, {Long.MAX_VALUE, 2L, 325L, 9375L, 28178L, 450775L, 9780504L, 1795265022L}};
    static final double F_1_3 = 0.3333333333333333;
    static final double F_1_5 = 0.2;
    static final double F_1_7 = 0.14285714285714285;
    static final double F_1_9 = 0.1111111111111111;
    static final double F_1_11 = 0.09090909090909091;
    static final double F_1_13 = 0.07692307692307693;
    static final double F_1_15 = 0.06666666666666667;
    static final double F_1_17 = 0.058823529411764705;
    static final double F_3_4 = 0.75;
    static final double F_15_16 = 0.9375;
    static final double F_13_14 = 0.9285714285714286;
    static final double F_11_12 = 0.9166666666666666;
    static final double F_9_10 = 0.9;
    static final double F_7_8 = 0.875;
    static final double F_5_6 = 0.8333333333333334;
    static final double F_1_2 = 0.5;
    static final double F_1_4 = 0.25;
    static boolean[] alphanumerics = new boolean[128];
    static final int SQRT2_PRECOMPUTE_THRESHOLD = 256;
    static final BigInteger SQRT2_PRECOMPUTED_BITS;
    private static final double LN_10;
    private static final double LN_2;
    static final int MAX_FACTORIAL = 170;
    static final double[] everySixteenthFactorial;

    private Numbers() {
    }

    public static byte toByte(String str) throws NumberFormatException {
        return Numbers.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) throws NumberFormatException {
        Integer result;
        if (N.isNullOrEmpty(str)) {
            return defaultValue;
        }
        if (str.length() < 5 && (result = CommonUtil.stringIntCache.get(str)) != null) {
            if (result < -128 || result > 127) {
                throw new NumberFormatException("Value out of range. Value:\"" + str + "\" Radix: 10");
            }
            return result.byteValue();
        }
        return Byte.parseByte(str);
    }

    public static short toShort(String str) throws NumberFormatException {
        return Numbers.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) throws NumberFormatException {
        Integer result;
        if (N.isNullOrEmpty(str)) {
            return defaultValue;
        }
        if (str.length() < 5 && (result = CommonUtil.stringIntCache.get(str)) != null) {
            return result.shortValue();
        }
        return Short.parseShort(str);
    }

    public static int toInt(String str) throws NumberFormatException {
        return Numbers.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) throws NumberFormatException {
        Integer result;
        if (N.isNullOrEmpty(str)) {
            return defaultValue;
        }
        if (str.length() < 5 && (result = CommonUtil.stringIntCache.get(str)) != null) {
            return result;
        }
        return Integer.parseInt(str);
    }

    public static long toLong(String str) throws NumberFormatException {
        return Numbers.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) throws NumberFormatException {
        Integer result;
        if (N.isNullOrEmpty(str)) {
            return defaultValue;
        }
        if (str.length() < 5 && (result = CommonUtil.stringIntCache.get(str)) != null) {
            return result.intValue();
        }
        return Long.parseLong(str);
    }

    public static float toFloat(String str) throws NumberFormatException {
        return Numbers.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) throws NumberFormatException {
        if (N.isNullOrEmpty(str)) {
            return defaultValue;
        }
        return Float.parseFloat(str);
    }

    public static double toDouble(String str) throws NumberFormatException {
        return Numbers.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) throws NumberFormatException {
        if (N.isNullOrEmpty(str)) {
            return defaultValue;
        }
        return Double.parseDouble(str);
    }

    public static double toDouble(BigDecimal value) {
        return Numbers.toDouble(value, 0.0);
    }

    public static double toDouble(BigDecimal value, double defaultValue) {
        return value == null ? defaultValue : value.doubleValue();
    }

    public static u.OptionalInt createInteger(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalInt.empty();
        }
        try {
            return u.OptionalInt.of(Integer.decode(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalInt.empty();
        }
    }

    public static u.OptionalLong createLong(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalLong.empty();
        }
        try {
            return u.OptionalLong.of(Long.decode(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalLong.empty();
        }
    }

    public static u.OptionalFloat createFloat(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalFloat.empty();
        }
        try {
            return u.OptionalFloat.of(Float.parseFloat(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalFloat.empty();
        }
    }

    public static u.OptionalDouble createDouble(String str) {
        if (N.isNullOrEmpty(str)) {
            return u.OptionalDouble.empty();
        }
        try {
            return u.OptionalDouble.of(Double.parseDouble(str));
        }
        catch (NumberFormatException e) {
            return u.OptionalDouble.empty();
        }
    }

    public static u.Optional<BigInteger> createBigInteger(String str) {
        if (N.isNullOrEmptyOrBlank(str)) {
            return u.Optional.empty();
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        try {
            BigInteger value = new BigInteger(str.substring(pos), radix);
            return u.Optional.of(negate ? value.negate() : value);
        }
        catch (NumberFormatException e) {
            return u.Optional.empty();
        }
    }

    public static u.Optional<BigDecimal> createBigDecimal(String str) {
        if (N.isNullOrEmptyOrBlank(str) || str.trim().startsWith("--")) {
            return u.Optional.empty();
        }
        try {
            return u.Optional.of(new BigDecimal(str));
        }
        catch (NumberFormatException e) {
            return u.Optional.empty();
        }
    }

    public static u.Optional<Number> createNumber(String str) {
        String exp;
        String mant;
        String dec;
        if (N.isNullOrEmptyOrBlank(str)) {
            return u.Optional.empty();
        }
        char ch = '\u0000';
        ch = str.charAt(0);
        if (!(ch < '\u0080' && alphanumerics[ch] && (ch = str.charAt(str.length() - 1)) < '\u0080' && alphanumerics[ch] && (ch = str.charAt(str.length() / 2)) < '\u0080' && alphanumerics[ch])) {
            return u.Optional.empty();
        }
        String[] hex_prefixes = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
        int pfxLen = 0;
        for (String pfx : hex_prefixes) {
            if (!str.startsWith(pfx)) continue;
            pfxLen += pfx.length();
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i = pfxLen; i < str.length() && (firstSigDigit = str.charAt(i)) == '0'; ++i) {
                ++pfxLen;
            }
            int hexDigits = str.length() - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return Numbers.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return Numbers.createLong(str).boxed();
            }
            return Numbers.createInteger(str).boxed();
        }
        char lastChar = str.charAt(str.length() - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        u.Optional<Number> op = null;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos || expPos > str.length()) {
                    return u.Optional.empty();
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = Numbers.getMantissa(str, decPos);
        } else {
            if (expPos > -1) {
                if (expPos > str.length()) {
                    return u.Optional.empty();
                }
                mant = Numbers.getMantissa(str, expPos);
            } else {
                mant = Numbers.getMantissa(str);
            }
            dec = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length() - 1) : null;
            String numeric = str.substring(0, str.length() - 1);
            boolean allZeros = Numbers.isAllZeros(mant) && Numbers.isAllZeros(exp);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp == null && (numeric.charAt(0) == '-' && StringUtil.isNumeric(numeric.substring(1)) || StringUtil.isNumeric(numeric))) {
                        op = Numbers.createLong(numeric).boxed();
                        if (op.isPresent()) {
                            return op;
                        }
                        return Numbers.createBigInteger(numeric);
                    }
                    return u.Optional.empty();
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = Float.valueOf(str);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return u.Optional.of(f);
                        }
                    }
                    catch (NumberFormatException f) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = Double.valueOf(str);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return u.Optional.of(d);
                        }
                    }
                    catch (NumberFormatException d) {
                        // empty catch block
                    }
                    return Numbers.createBigDecimal(numeric);
                }
            }
            return u.Optional.empty();
        }
        exp = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length()) : null;
        if (dec == null && exp == null) {
            op = Numbers.createInteger(str).boxed();
            if (op.isPresent()) {
                return op;
            }
            op = Numbers.createLong(str).boxed();
            if (op.isPresent()) {
                return op;
            }
            return Numbers.createBigInteger(str);
        }
        boolean allZeros = Numbers.isAllZeros(mant) && Numbers.isAllZeros(exp);
        try {
            Float f = Float.valueOf(str);
            Double d = Double.valueOf(str);
            if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros) && f.toString().equals(d.toString())) {
                return u.Optional.of(f);
            }
            if (!d.isInfinite() && (d != 0.0 || allZeros)) {
                u.Optional<Number> b = Numbers.createBigDecimal(str);
                if (b.isPresent() && b.get().compareTo(BigDecimal.valueOf(d)) == 0) {
                    return u.Optional.of(d);
                }
                return b;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Numbers.createBigDecimal(str);
    }

    static String getMantissa(String str) {
        return Numbers.getMantissa(str, str.length());
    }

    static String getMantissa(String str, int stopPos) {
        char firstChar = str.charAt(0);
        boolean hasSign = firstChar == '-' || firstChar == '+';
        return hasSign ? str.substring(1, stopPos) : str.substring(0, stopPos);
    }

    static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            if (str.charAt(i) == '0') continue;
            return false;
        }
        return str.length() > 0;
    }

    public static boolean isCreatable(String str) {
        int i;
        int start;
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' || chars[0] == '+' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && !StringUtil.contains(str, 46)) {
            if (chars[start + 1] == 'x' || chars[start + 1] == 'X') {
                int i2 = start + 2;
                if (i2 == sz) {
                    return false;
                }
                while (i2 < chars.length) {
                    if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            if (Character.isDigit(chars[start + 1])) {
                for (int i3 = start + 1; i3 < chars.length; ++i3) {
                    if (chars[i3] >= '0' && chars[i3] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public static boolean isParsable(String str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            if (str.length() == 1) {
                return false;
            }
            return Numbers.withDecimalsParsing(str, 1);
        }
        return Numbers.withDecimalsParsing(str, 0);
    }

    public static boolean isDigits(String str) {
        return StringUtil.isNumeric(str);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        for (int i = beginIdx; i < str.length(); ++i) {
            boolean isDecimalPoint;
            boolean bl = isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrime(long n) {
        if (n < 2L) {
            Numbers.checkNonNegative("n", n);
            return false;
        }
        if (n < 14L && (n == 2L || n == 3L || n == 5L || n == 7L || n == 11L || n == 13L)) {
            return true;
        }
        if ((0xDF75D77D & 1 << (int)(n % 30L)) != 0) {
            return false;
        }
        if (n % 7L == 0L || n % 11L == 0L || n % 13L == 0L) {
            return false;
        }
        if (n < 289L) {
            return true;
        }
        for (long[] baseSet : millerRabinBaseSets) {
            if (n > baseSet[0]) continue;
            for (int i = 1; i < baseSet.length; ++i) {
                if (MillerRabinTester.test(baseSet[i], n)) continue;
                return false;
            }
            return true;
        }
        throw new AssertionError();
    }

    public static boolean isPerfectSquare(int n) {
        if (n < 0) {
            return false;
        }
        switch (n & 0xF) {
            case 0: 
            case 1: 
            case 4: 
            case 9: {
                long tst = (long)Math.sqrt(n);
                return tst * tst == (long)n;
            }
        }
        return false;
    }

    public static boolean isPerfectSquare(long n) {
        if (n < 0L) {
            return false;
        }
        switch ((int)(n & 0xFL)) {
            case 0: 
            case 1: 
            case 4: 
            case 9: {
                long tst = (long)Math.sqrt(n);
                return tst * tst == n;
            }
        }
        return false;
    }

    public static boolean isPowerOfTwo(int x) {
        return x > 0 & (x & x - 1) == 0;
    }

    public static boolean isPowerOfTwo(long x) {
        return x > 0L & (x & x - 1L) == 0L;
    }

    public static boolean isPowerOfTwo(double x) {
        return x > 0.0 && Numbers.isFinite(x) && Numbers.isPowerOfTwo(Numbers.getSignificand(x));
    }

    public static boolean isPowerOfTwo(BigInteger x) {
        N.checkArgNotNull(x);
        return x.signum() > 0 && x.getLowestSetBit() == x.bitLength() - 1;
    }

    public static double log(double a) {
        return Math.log(a);
    }

    public static int log2(int x, RoundingMode mode) {
        Numbers.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(Numbers.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Integer.numberOfLeadingZeros(x);
                int cmp = -1257966797 >>> leadingZeros;
                int logFloor = 31 - leadingZeros;
                return logFloor + Numbers.lessThanBranchFree(cmp, x);
            }
        }
        throw new AssertionError();
    }

    public static int log2(long x, RoundingMode mode) {
        Numbers.checkPositive("x", x);
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(Numbers.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return 63 - Long.numberOfLeadingZeros(x);
            }
            case UP: 
            case CEILING: {
                return 64 - Long.numberOfLeadingZeros(x - 1L);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Long.numberOfLeadingZeros(x);
                long cmp = -5402926248376769404L >>> leadingZeros;
                int logFloor = 63 - leadingZeros;
                return logFloor + Numbers.lessThanBranchFree(cmp, x);
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    public static double log2(double x) {
        return Math.log(x) / LN_2;
    }

    public static int log2(double x, RoundingMode mode) {
        boolean increment;
        N.checkArgument(x > 0.0 && Numbers.isFinite(x), "x must be positive and finite");
        int exponent = Math.getExponent(x);
        if (!Numbers.isNormal(x)) {
            return Numbers.log2(x * 4.503599627370496E15, mode) - 52;
        }
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(Numbers.isPowerOfTwo(x));
            }
            case FLOOR: {
                increment = false;
                break;
            }
            case CEILING: {
                increment = !Numbers.isPowerOfTwo(x);
                break;
            }
            case DOWN: {
                increment = exponent < 0 & !Numbers.isPowerOfTwo(x);
                break;
            }
            case UP: {
                increment = exponent >= 0 & !Numbers.isPowerOfTwo(x);
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                double xScaled = Numbers.scaleNormalize(x);
                increment = xScaled * xScaled > 2.0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? exponent + 1 : exponent;
    }

    public static int log2(BigInteger x, RoundingMode mode) {
        Numbers.checkPositive("x", N.checkArgNotNull(x));
        int logFloor = x.bitLength() - 1;
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(Numbers.isPowerOfTwo(x));
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return Numbers.isPowerOfTwo(x) ? logFloor : logFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                if (logFloor < 256) {
                    BigInteger halfPower = SQRT2_PRECOMPUTED_BITS.shiftRight(256 - logFloor);
                    if (x.compareTo(halfPower) <= 0) {
                        return logFloor;
                    }
                    return logFloor + 1;
                }
                BigInteger x2 = x.pow(2);
                int logX2Floor = x2.bitLength() - 1;
                return logX2Floor < 2 * logFloor + 1 ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    public static int log10(int x, RoundingMode mode) {
        Numbers.checkPositive("x", x);
        int logFloor = Numbers.log10Floor(x);
        int floorPow = int_powersOf10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(x == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return logFloor + Numbers.lessThanBranchFree(floorPow, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return logFloor + Numbers.lessThanBranchFree(int_halfPowersOf10[logFloor], x);
            }
        }
        throw new AssertionError();
    }

    private static int log10Floor(int x) {
        byte y = int_maxLog10ForLeadingZeros[Integer.numberOfLeadingZeros(x)];
        return y - Numbers.lessThanBranchFree(x, int_powersOf10[y]);
    }

    public static int log10(long x, RoundingMode mode) {
        Numbers.checkPositive("x", x);
        int logFloor = Numbers.log10Floor(x);
        long floorPow = powersOf10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(x == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return logFloor + Numbers.lessThanBranchFree(floorPow, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return logFloor + Numbers.lessThanBranchFree(halfPowersOf10[logFloor], x);
            }
        }
        throw new AssertionError();
    }

    public static double log10(double x) {
        return Math.log10(x);
    }

    public static int log10(BigInteger x, RoundingMode mode) {
        Numbers.checkPositive("x", x);
        if (Numbers.fitsInLong(x)) {
            return Numbers.log10(x.longValue(), mode);
        }
        int approxLog10 = (int)((double)Numbers.log2(x, RoundingMode.FLOOR) * LN_2 / LN_10);
        BigInteger approxPow = BigInteger.TEN.pow(approxLog10);
        int approxCmp = approxPow.compareTo(x);
        if (approxCmp > 0) {
            do {
                --approxLog10;
            } while ((approxCmp = (approxPow = approxPow.divide(BigInteger.TEN)).compareTo(x)) > 0);
        } else {
            BigInteger nextPow = BigInteger.TEN.multiply(approxPow);
            int nextCmp = nextPow.compareTo(x);
            while (nextCmp <= 0) {
                ++approxLog10;
                approxPow = nextPow;
                approxCmp = nextCmp;
                nextPow = BigInteger.TEN.multiply(approxPow);
                nextCmp = nextPow.compareTo(x);
            }
        }
        int floorLog = approxLog10;
        BigInteger floorPow = approxPow;
        int floorCmp = approxCmp;
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(floorCmp == 0);
            }
            case DOWN: 
            case FLOOR: {
                return floorLog;
            }
            case UP: 
            case CEILING: {
                return floorPow.equals(x) ? floorLog : floorLog + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                BigInteger x2 = x.pow(2);
                BigInteger halfPowerSquared = floorPow.pow(2).multiply(BigInteger.TEN);
                return x2.compareTo(halfPowerSquared) <= 0 ? floorLog : floorLog + 1;
            }
        }
        throw new AssertionError();
    }

    static boolean fitsInLong(BigInteger x) {
        return x.bitLength() <= 63;
    }

    public static int pow(int b, int k) {
        Numbers.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                return k == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k & 1) == 0 ? 1 : -1;
            }
            case 2: {
                return k < 32 ? 1 << k : 0;
            }
            case -2: {
                if (k < 32) {
                    return (k & 1) == 0 ? 1 << k : -(1 << k);
                }
                return 0;
            }
        }
        int accum = 1;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return b * accum;
                }
            }
            accum *= (k & 1) == 0 ? 1 : b;
            b *= b;
            k >>= 1;
        }
    }

    public static long pow(long b, int k) {
        Numbers.checkNonNegative("exponent", k);
        if (-2L <= b && b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    return k < 64 ? 1L << k : 0L;
                }
                case -2: {
                    if (k < 64) {
                        return (k & 1) == 0 ? 1L << k : -(1L << k);
                    }
                    return 0L;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * b;
                }
            }
            accum *= (k & 1) == 0 ? 1L : b;
            b *= b;
            k >>= 1;
        }
    }

    public static long ceilingPowerOfTwo(long x) {
        Numbers.checkPositive("x", x);
        if (x > 0x4000000000000000L) {
            throw new ArithmeticException("ceilingPowerOfTwo(" + x + ") is not representable as a long");
        }
        return 1L << -Long.numberOfLeadingZeros(x - 1L);
    }

    public static BigInteger ceilingPowerOfTwo(BigInteger x) {
        return BigInteger.ZERO.setBit(Numbers.log2(x, RoundingMode.CEILING));
    }

    public static long floorPowerOfTwo(long x) {
        Numbers.checkPositive("x", x);
        return 1L << 63 - Long.numberOfLeadingZeros(x);
    }

    public static BigInteger floorPowerOfTwo(BigInteger x) {
        return BigInteger.ZERO.setBit(Numbers.log2(x, RoundingMode.FLOOR));
    }

    public static int sqrt(int x, RoundingMode mode) {
        Numbers.checkNonNegative("x", x);
        int sqrtFloor = Numbers.sqrtFloor(x);
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor + Numbers.lessThanBranchFree(sqrtFloor * sqrtFloor, x);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + Numbers.lessThanBranchFree(halfSquare, x);
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int x) {
        return (int)Math.sqrt(x);
    }

    public static long sqrt(long x, RoundingMode mode) {
        Numbers.checkNonNegative("x", x);
        if (Numbers.fitsInInt(x)) {
            return Numbers.sqrt((int)x, mode);
        }
        long guess = (long)Math.sqrt(x);
        long guessSquared = guess * guess;
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(guessSquared == x);
                return guess;
            }
            case DOWN: 
            case FLOOR: {
                if (x < guessSquared) {
                    return guess - 1L;
                }
                return guess;
            }
            case UP: 
            case CEILING: {
                if (x > guessSquared) {
                    return guess + 1L;
                }
                return guess;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long sqrtFloor = guess - (long)(x < guessSquared ? 1 : 0);
                long halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + (long)Numbers.lessThanBranchFree(halfSquare, x);
            }
        }
        throw new AssertionError();
    }

    public static BigInteger sqrt(BigInteger x, RoundingMode mode) {
        Numbers.checkNonNegative("x", x);
        if (Numbers.fitsInLong(x)) {
            return BigInteger.valueOf(Numbers.sqrt(x.longValue(), mode));
        }
        BigInteger sqrtFloor = Numbers.sqrtFloor(x);
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(sqrtFloor.pow(2).equals(x));
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                int sqrtFloorInt = sqrtFloor.intValue();
                boolean sqrtFloorIsExact = sqrtFloorInt * sqrtFloorInt == x.intValue() && sqrtFloor.pow(2).equals(x);
                return sqrtFloorIsExact ? sqrtFloor : sqrtFloor.add(BigInteger.ONE);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                BigInteger halfSquare = sqrtFloor.pow(2).add(sqrtFloor);
                return halfSquare.compareTo(x) >= 0 ? sqrtFloor : sqrtFloor.add(BigInteger.ONE);
            }
        }
        throw new AssertionError();
    }

    private static BigInteger sqrtFloor(BigInteger x) {
        BigInteger sqrt0;
        int log2 = Numbers.log2(x, RoundingMode.FLOOR);
        if (log2 < 1023) {
            sqrt0 = Numbers.sqrtApproxWithDoubles(x);
        } else {
            int shift = log2 - 52 & 0xFFFFFFFE;
            sqrt0 = Numbers.sqrtApproxWithDoubles(x.shiftRight(shift)).shiftLeft(shift >> 1);
        }
        BigInteger sqrt1 = sqrt0.add(x.divide(sqrt0)).shiftRight(1);
        if (sqrt0.equals(sqrt1)) {
            return sqrt0;
        }
        while ((sqrt1 = (sqrt0 = sqrt1).add(x.divide(sqrt0)).shiftRight(1)).compareTo(sqrt0) < 0) {
        }
        return sqrt0;
    }

    private static BigInteger sqrtApproxWithDoubles(BigInteger x) {
        return Numbers.roundToBigInteger(Math.sqrt(Numbers.bigToDouble(x)), RoundingMode.HALF_EVEN);
    }

    public static int divide(int p, int q, RoundingMode mode) {
        boolean increment;
        N.checkArgNotNull(mode);
        if (q == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div = p / q;
        int rem = p - q * div;
        if (rem == 0) {
            return div;
        }
        int signum = 1 | (p ^ q) >> 31;
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(rem == 0);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    increment = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_EVEN & (div & 1) != 0;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + signum : div;
    }

    public static long divide(long p, long q, RoundingMode mode) {
        boolean increment;
        N.checkArgNotNull(mode);
        long div = p / q;
        long rem = p - q * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p ^ q) >> 63);
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(rem == 0L);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    public static BigInteger divide(BigInteger p, BigInteger q, RoundingMode mode) {
        BigDecimal pDec = new BigDecimal(p);
        BigDecimal qDec = new BigDecimal(q);
        return pDec.divide(qDec, 0, mode).toBigIntegerExact();
    }

    public static int mod(int x, int m) {
        if (m <= 0) {
            throw new ArithmeticException("Modulus " + m + " must be > 0");
        }
        int result = x % m;
        return result >= 0 ? result : result + m;
    }

    public static int mod(long x, int m) {
        return (int)Numbers.mod(x, (long)m);
    }

    public static long mod(long x, long m) {
        if (m <= 0L) {
            throw new ArithmeticException("Modulus must be positive");
        }
        long result = x % m;
        return result >= 0L ? result : result + m;
    }

    public static int gcd(int a, int b) {
        Numbers.checkNonNegative("a", a);
        Numbers.checkNonNegative("b", b);
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            int delta = a - b;
            int minDeltaOrZero = delta & delta >> 31;
            a = delta - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static long gcd(long a, long b) {
        Numbers.checkNonNegative("a", a);
        Numbers.checkNonNegative("b", b);
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        int aTwos = Long.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Long.numberOfTrailingZeros(b);
        b >>= bTwos;
        while (a != b) {
            long delta = a - b;
            long minDeltaOrZero = delta & delta >> 63;
            a = delta - minDeltaOrZero - minDeltaOrZero;
            b += minDeltaOrZero;
            a >>= Long.numberOfTrailingZeros(a);
        }
        return a << Math.min(aTwos, bTwos);
    }

    public static int lcm(int a, int b) throws ArithmeticException {
        if (a == 0 || b == 0) {
            return 0;
        }
        int lcm = Math.abs(Numbers.addExact(a / Numbers.gcd(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return lcm;
    }

    public static long lcm(long a, long b) throws ArithmeticException {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        long lcm = Math.abs(Numbers.addExact(a / Numbers.gcd(a, b), b));
        if (lcm == Integer.MIN_VALUE) {
            throw new ArithmeticException();
        }
        return lcm;
    }

    public static int addExact(int a, int b) {
        long result = (long)a + (long)b;
        Numbers.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static long addExact(long a, long b) {
        long result = a + b;
        Numbers.checkNoOverflow((a ^ b) < 0L | (a ^ result) >= 0L);
        return result;
    }

    public static int subtractExact(int a, int b) {
        long result = (long)a - (long)b;
        Numbers.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static long subtractExact(long a, long b) {
        long result = a - b;
        Numbers.checkNoOverflow((a ^ b) >= 0L | (a ^ result) >= 0L);
        return result;
    }

    public static int multiplyExact(int a, int b) {
        long result = (long)a * (long)b;
        Numbers.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static long multiplyExact(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        Numbers.checkNoOverflow(leadingZeros >= 64);
        Numbers.checkNoOverflow(a >= 0L | b != Long.MIN_VALUE);
        long result = a * b;
        Numbers.checkNoOverflow(a == 0L || result / a == b);
        return result;
    }

    public static int powExact(int b, int k) {
        Numbers.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                return k == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k & 1) == 0 ? 1 : -1;
            }
            case 2: {
                Numbers.checkNoOverflow(k < 31);
                return 1 << k;
            }
            case -2: {
                Numbers.checkNoOverflow(k < 32);
                return (k & 1) == 0 ? 1 << k : -1 << k;
            }
        }
        int accum = 1;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Numbers.multiplyExact(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Numbers.multiplyExact(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            Numbers.checkNoOverflow(-46340 <= b & b <= 46340);
            b *= b;
        }
    }

    public static long powExact(long b, int k) {
        Numbers.checkNonNegative("exponent", k);
        if (b >= -2L & b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    Numbers.checkNoOverflow(k < 63);
                    return 1L << k;
                }
                case -2: {
                    Numbers.checkNoOverflow(k < 64);
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Numbers.multiplyExact(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Numbers.multiplyExact(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            Numbers.checkNoOverflow(-3037000499L <= b && b <= 3037000499L);
            b *= b;
        }
    }

    public static int castExact(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new IllegalArgumentException("Out of range: " + value);
        }
        return result;
    }

    public static int saturatedAdd(int a, int b) {
        return Numbers.saturatedCast((long)a + (long)b);
    }

    public static long saturatedAdd(long a, long b) {
        long naiveSum;
        if ((a ^ b) < 0L | (a ^ (naiveSum = a + b)) >= 0L) {
            return naiveSum;
        }
        return Long.MAX_VALUE + (naiveSum >>> 63 ^ 1L);
    }

    public static int saturatedSubtract(int a, int b) {
        return Numbers.saturatedCast((long)a - (long)b);
    }

    public static long saturatedSubtract(long a, long b) {
        long naiveDifference;
        if ((a ^ b) >= 0L | (a ^ (naiveDifference = a - b)) >= 0L) {
            return naiveDifference;
        }
        return Long.MAX_VALUE + (naiveDifference >>> 63 ^ 1L);
    }

    public static int saturatedMultiply(int a, int b) {
        return Numbers.saturatedCast((long)a * (long)b);
    }

    public static long saturatedMultiply(long a, long b) {
        int leadingZeros = Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(a ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b) + Long.numberOfLeadingZeros(b ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a * b;
        }
        long limit = Long.MAX_VALUE + ((a ^ b) >>> 63);
        if (leadingZeros < 64 | a < 0L & b == Long.MIN_VALUE) {
            return limit;
        }
        long result = a * b;
        if (a == 0L || result / a == b) {
            return result;
        }
        return limit;
    }

    public static int saturatedPow(int b, int k) {
        Numbers.checkNonNegative("exponent", k);
        switch (b) {
            case 0: {
                return k == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k & 1) == 0 ? 1 : -1;
            }
            case 2: {
                if (k >= 31) {
                    return Integer.MAX_VALUE;
                }
                return 1 << k;
            }
            case -2: {
                if (k >= 32) {
                    return Integer.MAX_VALUE + (k & 1);
                }
                return (k & 1) == 0 ? 1 << k : -1 << k;
            }
        }
        int accum = 1;
        int limit = Integer.MAX_VALUE + (b >>> 31 & (k & 1));
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Numbers.saturatedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Numbers.saturatedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            if (-46340 > b | b > 46340) {
                return limit;
            }
            b *= b;
        }
    }

    public static long saturatedPow(long b, int k) {
        Numbers.checkNonNegative("exponent", k);
        if (b >= -2L & b <= 2L) {
            switch ((int)b) {
                case 0: {
                    return k == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    if (k >= 63) {
                        return Long.MAX_VALUE;
                    }
                    return 1L << k;
                }
                case -2: {
                    if (k >= 64) {
                        return Long.MAX_VALUE + (long)(k & 1);
                    }
                    return (k & 1) == 0 ? 1L << k : -1L << k;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        long limit = Long.MAX_VALUE + (b >>> 63 & (long)(k & 1));
        while (true) {
            switch (k) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return Numbers.saturatedMultiply(accum, b);
                }
            }
            if ((k & 1) != 0) {
                accum = Numbers.saturatedMultiply(accum, b);
            }
            if ((k >>= 1) <= 0) continue;
            if (-3037000499L > b | b > 3037000499L) {
                return limit;
            }
            b *= b;
        }
    }

    public static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)value;
    }

    public static int factorial(int n) {
        Numbers.checkNonNegative("n", n);
        return n < int_factorials.length ? int_factorials[n] : Integer.MAX_VALUE;
    }

    public static long factoriall(int n) {
        Numbers.checkNonNegative("n", n);
        return n < long_factorials.length ? long_factorials[n] : Long.MAX_VALUE;
    }

    public static double factorialll(int n) {
        Numbers.checkNonNegative("n", n);
        if (n > 170) {
            return Double.POSITIVE_INFINITY;
        }
        double accum = 1.0;
        for (int i = 1 + (n & 0xFFFFFFF0); i <= n; ++i) {
            accum *= (double)i;
        }
        return accum * everySixteenthFactorial[n >> 4];
    }

    public static BigInteger facttorial(int n) {
        Numbers.checkNonNegative("n", n);
        if (n < long_factorials.length) {
            return BigInteger.valueOf(long_factorials[n]);
        }
        int approxSize = Numbers.divide(n * Numbers.log2(n, RoundingMode.CEILING), 64, RoundingMode.CEILING);
        ArrayList<BigInteger> bignums = new ArrayList<BigInteger>(approxSize);
        int startingNumber = long_factorials.length;
        long product = long_factorials[startingNumber - 1];
        int shift = Long.numberOfTrailingZeros(product);
        int productBits = Numbers.log2(product >>= shift, RoundingMode.FLOOR) + 1;
        int bits = Numbers.log2(startingNumber, RoundingMode.FLOOR) + 1;
        int nextPowerOfTwo = 1 << bits - 1;
        for (long num = (long)startingNumber; num <= (long)n; ++num) {
            if ((num & (long)nextPowerOfTwo) != 0L) {
                nextPowerOfTwo <<= 1;
                ++bits;
            }
            int tz = Long.numberOfTrailingZeros(num);
            long normalizedNum = num >> tz;
            shift += tz;
            int normalizedBits = bits - tz;
            if (normalizedBits + productBits >= 64) {
                bignums.add(BigInteger.valueOf(product));
                product = 1L;
                productBits = 0;
            }
            productBits = Numbers.log2(product *= normalizedNum, RoundingMode.FLOOR) + 1;
        }
        if (product > 1L) {
            bignums.add(BigInteger.valueOf(product));
        }
        return Numbers.listProduct(bignums).shiftLeft(shift);
    }

    static BigInteger listProduct(List<BigInteger> nums) {
        return Numbers.listProduct(nums, 0, nums.size());
    }

    static BigInteger listProduct(List<BigInteger> nums, int start, int end) {
        switch (end - start) {
            case 0: {
                return BigInteger.ONE;
            }
            case 1: {
                return nums.get(start);
            }
            case 2: {
                return nums.get(start).multiply(nums.get(start + 1));
            }
            case 3: {
                return nums.get(start).multiply(nums.get(start + 1)).multiply(nums.get(start + 2));
            }
        }
        int m = end + start >>> 1;
        return Numbers.listProduct(nums, start, m).multiply(Numbers.listProduct(nums, m, end));
    }

    public static int binomial(int n, int k) {
        Numbers.checkNonNegative("n", n);
        Numbers.checkNonNegative("k", k);
        N.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        if (k >= int_biggestBinomials.length || n > int_biggestBinomials[k]) {
            return Integer.MAX_VALUE;
        }
        switch (k) {
            case 0: {
                return 1;
            }
            case 1: {
                return n;
            }
        }
        long result = 1L;
        for (int i = 0; i < k; ++i) {
            result *= (long)(n - i);
            result /= (long)(i + 1);
        }
        return (int)result;
    }

    public static long binomiall(int n, int k) {
        Numbers.checkNonNegative("n", n);
        Numbers.checkNonNegative("k", k);
        N.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        switch (k) {
            case 0: {
                return 1L;
            }
            case 1: {
                return n;
            }
        }
        if (n < long_factorials.length) {
            return long_factorials[n] / (long_factorials[k] * long_factorials[n - k]);
        }
        if (k >= biggestBinomials.length || n > biggestBinomials[k]) {
            return Long.MAX_VALUE;
        }
        if (k < biggestSimpleBinomials.length && n <= biggestSimpleBinomials[k]) {
            long result = n--;
            for (int i = 2; i <= k; ++i) {
                result *= (long)n;
                result /= (long)i;
                --n;
            }
            return result;
        }
        int nBits = Numbers.log2(n, RoundingMode.CEILING);
        long result = 1L;
        long numerator = n--;
        long denominator = 1L;
        int numeratorBits = nBits;
        int i = 2;
        while (i <= k) {
            if (numeratorBits + nBits < 63) {
                numerator *= (long)n;
                denominator *= (long)i;
                numeratorBits += nBits;
            } else {
                result = Numbers.multiplyFraction(result, numerator, denominator);
                numerator = n;
                denominator = i;
                numeratorBits = nBits;
            }
            ++i;
            --n;
        }
        return Numbers.multiplyFraction(result, numerator, denominator);
    }

    public static BigInteger binnomial(int n, int k) {
        int bits;
        Numbers.checkNonNegative("n", n);
        Numbers.checkNonNegative("k", k);
        N.checkArgument(k <= n, "k (%s) > n (%s)", k, n);
        if (k > n >> 1) {
            k = n - k;
        }
        if (k < biggestBinomials.length && n <= biggestBinomials[k]) {
            return BigInteger.valueOf(Numbers.binomial(n, k));
        }
        BigInteger accum = BigInteger.ONE;
        long numeratorAccum = n;
        long denominatorAccum = 1L;
        int numeratorBits = bits = Numbers.log2(n, RoundingMode.CEILING);
        for (int i = 1; i < k; ++i) {
            int p = n - i;
            int q = i + 1;
            if (numeratorBits + bits >= 63) {
                accum = accum.multiply(BigInteger.valueOf(numeratorAccum)).divide(BigInteger.valueOf(denominatorAccum));
                numeratorAccum = p;
                denominatorAccum = q;
                numeratorBits = bits;
                continue;
            }
            numeratorAccum *= (long)p;
            denominatorAccum *= (long)q;
            numeratorBits += bits;
        }
        return accum.multiply(BigInteger.valueOf(numeratorAccum)).divide(BigInteger.valueOf(denominatorAccum));
    }

    public static int mean(int x, int y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static long mean(long x, long y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    public static double mean(double x, double y) {
        return Numbers.checkFinite(x) + (Numbers.checkFinite(y) - x) / 2.0;
    }

    @SafeVarargs
    public static double mean(int ... values) {
        N.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long sum = 0L;
        for (int index = 0; index < values.length; ++index) {
            sum += (long)values[index];
        }
        return (double)sum / (double)values.length;
    }

    @SafeVarargs
    public static double mean(long ... values) {
        N.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long count = 1L;
        double mean = values[0];
        for (int index = 1; index < values.length; ++index) {
            mean += ((double)values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    @SafeVarargs
    public static double mean(double ... values) {
        N.checkArgument(values.length > 0, "Cannot take mean of 0 values");
        long count = 1L;
        double mean = Numbers.checkFinite(values[0]);
        for (int index = 1; index < values.length; ++index) {
            Numbers.checkFinite(values[index]);
            mean += (values[index] - mean) / (double)(++count);
        }
        return mean;
    }

    private static double checkFinite(double argument) {
        N.checkArgument(Numbers.isFinite(argument));
        return argument;
    }

    static double roundIntermediate(double x, RoundingMode mode) {
        if (!Numbers.isFinite(x)) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        switch (mode) {
            case UNNECESSARY: {
                Numbers.checkRoundingUnnecessary(Numbers.isMathematicalInteger(x));
                return x;
            }
            case FLOOR: {
                if (x >= 0.0 || Numbers.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x - 1L;
            }
            case CEILING: {
                if (x <= 0.0 || Numbers.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + 1L;
            }
            case DOWN: {
                return x;
            }
            case UP: {
                if (Numbers.isMathematicalInteger(x)) {
                    return x;
                }
                return (long)x + (long)(x > 0.0 ? 1 : -1);
            }
            case HALF_EVEN: {
                return Math.rint(x);
            }
            case HALF_UP: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z;
            }
            case HALF_DOWN: {
                double z = Math.rint(x);
                if (Math.abs(x - z) == 0.5) {
                    return x;
                }
                return z;
            }
        }
        throw new AssertionError();
    }

    public static int roundToInt(double x, RoundingMode mode) {
        double z = Numbers.roundIntermediate(x, mode);
        Numbers.checkInRange(z > -2.147483649E9 & z < 2.147483648E9);
        return (int)z;
    }

    public static long roundToLong(double x, RoundingMode mode) {
        double z = Numbers.roundIntermediate(x, mode);
        Numbers.checkInRange(-9.223372036854776E18 - z < 1.0 & z < 9.223372036854776E18);
        return (long)z;
    }

    public static BigInteger roundToBigInteger(double x, RoundingMode mode) {
        if (-9.223372036854776E18 - (x = Numbers.roundIntermediate(x, mode)) < 1.0 & x < 9.223372036854776E18) {
            return BigInteger.valueOf((long)x);
        }
        int exponent = Math.getExponent(x);
        long significand = Numbers.getSignificand(x);
        BigInteger result = BigInteger.valueOf(significand).shiftLeft(exponent - 52);
        return x < 0.0 ? result.negate() : result;
    }

    public static boolean fuzzyEquals(double a, double b, double tolerance) {
        Numbers.checkNonNegative("tolerance", tolerance);
        return Math.copySign(a - b, 1.0) <= tolerance || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    public static int fuzzyCompare(double a, double b, double tolerance) {
        if (Numbers.fuzzyEquals(a, b, tolerance)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return Boolean.compare(Double.isNaN(a), Double.isNaN(b));
    }

    public static boolean isMathematicalInteger(double x) {
        return Numbers.isFinite(x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(Numbers.getSignificand(x)) <= Math.getExponent(x));
    }

    static int lessThanBranchFree(long x, long y) {
        return (int)((x - y ^ 0xFFFFFFFFFFFFFFFFL ^ 0xFFFFFFFFFFFFFFFFL) >>> 63);
    }

    static int log10Floor(long x) {
        byte y = maxLog10ForLeadingZeros[Long.numberOfLeadingZeros(x)];
        return y - Numbers.lessThanBranchFree(x, powersOf10[y]);
    }

    static long multiplyFraction(long x, long numerator, long denominator) {
        if (x == 1L) {
            return numerator / denominator;
        }
        long commonDivisor = Numbers.gcd(x, denominator);
        return (x /= commonDivisor) * (numerator / (denominator /= commonDivisor));
    }

    static double nextDown(double d) {
        return -Math.nextUp(-d);
    }

    static long getSignificand(double d) {
        N.checkArgument(Numbers.isFinite(d), "not a normal value");
        int exponent = Math.getExponent(d);
        long bits = Double.doubleToRawLongBits(d);
        return exponent == -1023 ? bits << 1 : (bits &= 0xFFFFFFFFFFFFFL) | 0x10000000000000L;
    }

    static boolean isFinite(double d) {
        return Math.getExponent(d) <= 1023;
    }

    static boolean isNormal(double d) {
        return Math.getExponent(d) >= -1022;
    }

    static double scaleNormalize(double x) {
        long significand = Double.doubleToRawLongBits(x) & 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(significand | ONE_BITS);
    }

    static double bigToDouble(BigInteger x) {
        BigInteger absX = x.abs();
        int exponent = absX.bitLength() - 1;
        if (exponent < 63) {
            return x.longValue();
        }
        if (exponent > 1023) {
            return (double)x.signum() * Double.POSITIVE_INFINITY;
        }
        int shift = exponent - 52 - 1;
        long twiceSignifFloor = absX.shiftRight(shift).longValue();
        long signifFloor = twiceSignifFloor >> 1;
        boolean increment = (twiceSignifFloor & 1L) != 0L && (((signifFloor &= 0xFFFFFFFFFFFFFL) & 1L) != 0L || absX.getLowestSetBit() < shift);
        long signifRounded = increment ? signifFloor + 1L : signifFloor;
        long bits = (long)(exponent + 1023) << 52;
        bits += signifRounded;
        return Double.longBitsToDouble(bits |= (long)x.signum() & Long.MIN_VALUE);
    }

    static double ensureNonNegative(double value) {
        N.checkArgument(!Double.isNaN(value));
        if (value > 0.0) {
            return value;
        }
        return 0.0;
    }

    static int lessThanBranchFree(int x, int y) {
        return ~(~(x - y)) >>> 31;
    }

    static boolean fitsInInt(long x) {
        return (long)((int)x) == x;
    }

    static int checkPositive(String role, int x) {
        if (x <= 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static long checkPositive(String role, long x) {
        if (x <= 0L) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static BigInteger checkPositive(String role, BigInteger x) {
        if (x.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be > 0");
        }
        return x;
    }

    static int checkNonNegative(String role, int x) {
        if (x < 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static long checkNonNegative(String role, long x) {
        if (x < 0L) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static BigInteger checkNonNegative(String role, BigInteger x) {
        if (x.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static double checkNonNegative(String role, double x) {
        if (!(x >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x + ") must be >= 0");
        }
        return x;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("not in range");
        }
    }

    static void checkNoOverflow(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("overflow");
        }
    }

    public static double asinh(double a) {
        double absAsinh;
        boolean negative = false;
        if (a < 0.0) {
            negative = true;
            a = -a;
        }
        if (a > 0.167) {
            absAsinh = Math.log(Math.sqrt(a * a + 1.0) + a);
        } else {
            double a2 = a * a;
            absAsinh = a > 0.097 ? a * (1.0 - a2 * (0.3333333333333333 - a2 * (0.2 - a2 * (0.14285714285714285 - a2 * (0.1111111111111111 - a2 * (0.09090909090909091 - a2 * (0.07692307692307693 - a2 * (0.06666666666666667 - a2 * 0.058823529411764705 * 0.9375) * 0.9285714285714286) * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (a > 0.036 ? a * (1.0 - a2 * (0.3333333333333333 - a2 * (0.2 - a2 * (0.14285714285714285 - a2 * (0.1111111111111111 - a2 * (0.09090909090909091 - a2 * 0.07692307692307693 * 0.9166666666666666) * 0.9) * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : (a > 0.0036 ? a * (1.0 - a2 * (0.3333333333333333 - a2 * (0.2 - a2 * (0.14285714285714285 - a2 * 0.1111111111111111 * 0.875) * 0.8333333333333334) * 0.75) * 0.5) : a * (1.0 - a2 * (0.3333333333333333 - a2 * 0.2 * 0.75) * 0.5)));
        }
        return negative ? -absAsinh : absAsinh;
    }

    public static double acosh(double a) {
        return Math.log(a + Math.sqrt(a * a - 1.0));
    }

    public static double atanh(double a) {
        double absAtanh;
        boolean negative = false;
        if (a < 0.0) {
            negative = true;
            a = -a;
        }
        if (a > 0.15) {
            absAtanh = 0.5 * Math.log((1.0 + a) / (1.0 - a));
        } else {
            double a2 = a * a;
            absAtanh = a > 0.087 ? a * (1.0 + a2 * (0.3333333333333333 + a2 * (0.2 + a2 * (0.14285714285714285 + a2 * (0.1111111111111111 + a2 * (0.09090909090909091 + a2 * (0.07692307692307693 + a2 * (0.06666666666666667 + a2 * 0.058823529411764705)))))))) : (a > 0.031 ? a * (1.0 + a2 * (0.3333333333333333 + a2 * (0.2 + a2 * (0.14285714285714285 + a2 * (0.1111111111111111 + a2 * (0.09090909090909091 + a2 * 0.07692307692307693)))))) : (a > 0.003 ? a * (1.0 + a2 * (0.3333333333333333 + a2 * (0.2 + a2 * (0.14285714285714285 + a2 * 0.1111111111111111)))) : a * (1.0 + a2 * (0.3333333333333333 + a2 * 0.2))));
        }
        return negative ? -absAtanh : absAtanh;
    }

    static {
        Numbers.alphanumerics[48] = true;
        Numbers.alphanumerics[49] = true;
        Numbers.alphanumerics[50] = true;
        Numbers.alphanumerics[51] = true;
        Numbers.alphanumerics[52] = true;
        Numbers.alphanumerics[53] = true;
        Numbers.alphanumerics[54] = true;
        Numbers.alphanumerics[55] = true;
        Numbers.alphanumerics[56] = true;
        Numbers.alphanumerics[57] = true;
        Numbers.alphanumerics[43] = true;
        Numbers.alphanumerics[45] = true;
        Numbers.alphanumerics[46] = true;
        Numbers.alphanumerics[35] = true;
        Numbers.alphanumerics[120] = true;
        Numbers.alphanumerics[88] = true;
        Numbers.alphanumerics[101] = true;
        Numbers.alphanumerics[69] = true;
        Numbers.alphanumerics[97] = true;
        Numbers.alphanumerics[98] = true;
        Numbers.alphanumerics[99] = true;
        Numbers.alphanumerics[100] = true;
        Numbers.alphanumerics[101] = true;
        Numbers.alphanumerics[102] = true;
        Numbers.alphanumerics[108] = true;
        Numbers.alphanumerics[76] = true;
        Numbers.alphanumerics[102] = true;
        Numbers.alphanumerics[70] = true;
        Numbers.alphanumerics[100] = true;
        Numbers.alphanumerics[68] = true;
        SQRT2_PRECOMPUTED_BITS = new BigInteger("16a09e667f3bcc908b2fb1366ea957d3e3adec17512775099da2f590b0667322a", 16);
        LN_10 = Math.log(10.0);
        LN_2 = Math.log(2.0);
        everySixteenthFactorial = new double[]{1.0, 2.0922789888E13, 2.631308369336935E35, 1.2413915592536073E61, 1.2688693218588417E89, 7.156945704626381E118, 9.916779348709496E149, 1.974506857221074E182, 3.856204823625804E215, 5.5502938327393044E249, 4.7147236359920616E284};
    }

    private static enum MillerRabinTester {
        SMALL{

            @Override
            long mulMod(long a, long b, long m) {
                return a * b % m;
            }

            @Override
            long squareMod(long a, long m) {
                return a * a % m;
            }
        }
        ,
        LARGE{

            private long plusMod(long a, long b, long m) {
                return a >= m - b ? a + b - m : a + b;
            }

            private long times2ToThe32Mod(long a, long m) {
                int shift;
                int remainingPowersOf2 = 32;
                do {
                    shift = Math.min(remainingPowersOf2, Long.numberOfLeadingZeros(a));
                    a = UnsignedLongs.remainder(a << shift, m);
                } while ((remainingPowersOf2 -= shift) > 0);
                return a;
            }

            @Override
            long mulMod(long a, long b, long m) {
                long aHi = a >>> 32;
                long bHi = b >>> 32;
                long aLo = a & 0xFFFFFFFFL;
                long bLo = b & 0xFFFFFFFFL;
                long result = this.times2ToThe32Mod(aHi * bHi, m);
                if ((result += aHi * bLo) < 0L) {
                    result = UnsignedLongs.remainder(result, m);
                }
                result += aLo * bHi;
                result = this.times2ToThe32Mod(result, m);
                return this.plusMod(result, UnsignedLongs.remainder(aLo * bLo, m), m);
            }

            @Override
            long squareMod(long a, long m) {
                long aHi = a >>> 32;
                long aLo = a & 0xFFFFFFFFL;
                long result = this.times2ToThe32Mod(aHi * aHi, m);
                long hiLo = aHi * aLo * 2L;
                if (hiLo < 0L) {
                    hiLo = UnsignedLongs.remainder(hiLo, m);
                }
                result += hiLo;
                result = this.times2ToThe32Mod(result, m);
                return this.plusMod(result, UnsignedLongs.remainder(aLo * aLo, m), m);
            }
        };


        static boolean test(long base, long n) {
            return (n <= 3037000499L ? SMALL : LARGE).testWitness(base, n);
        }

        abstract long mulMod(long var1, long var3, long var5);

        abstract long squareMod(long var1, long var3);

        private long powMod(long a, long p, long m) {
            long res = 1L;
            while (p != 0L) {
                if ((p & 1L) != 0L) {
                    res = this.mulMod(res, a, m);
                }
                a = this.squareMod(a, m);
                p >>= 1;
            }
            return res;
        }

        private boolean testWitness(long base, long n) {
            int r = Long.numberOfTrailingZeros(n - 1L);
            long d = n - 1L >> r;
            if ((base %= n) == 0L) {
                return true;
            }
            long a = this.powMod(base, d, n);
            if (a == 1L) {
                return true;
            }
            int j = 0;
            while (a != n - 1L) {
                if (++j == r) {
                    return false;
                }
                a = this.squareMod(a, n);
            }
            return true;
        }
    }

    static final class UnsignedLongs {
        public static final long MAX_VALUE = -1L;

        private UnsignedLongs() {
        }

        private static long flip(long a) {
            return a ^ Long.MIN_VALUE;
        }

        static int compare(long a, long b) {
            return Long.compare(UnsignedLongs.flip(a), UnsignedLongs.flip(b));
        }

        static long remainder(long dividend, long divisor) {
            long rem;
            if (divisor < 0L) {
                if (UnsignedLongs.compare(dividend, divisor) < 0) {
                    return dividend;
                }
                return dividend - divisor;
            }
            if (dividend >= 0L) {
                return dividend % divisor;
            }
            long quotient = (dividend >>> 1) / divisor << 1;
            return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
        }
    }
}

