/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.util.ImmutableEntry;
import com.landawn.abacus.util.Mutable;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.u;
import java.util.AbstractMap;
import java.util.Map;

public final class Pair<L, R>
implements Mutable {
    public L left;
    public R right;
    private static final Pair<?, ?>[] EMPTY_ARRAY = new Pair[0];

    public Pair() {
    }

    Pair(L l, R r) {
        this.left = l;
        this.right = r;
    }

    public static <L, R> Pair<L, R> of(L l, R r) {
        return new Pair<L, R>(l, r);
    }

    public static <K, V> Pair<K, V> from(Map.Entry<K, V> entry) {
        return new Pair<K, V>(entry.getKey(), entry.getValue());
    }

    public static <L, R> Pair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public L getLeft() {
        return this.left;
    }

    public void setLeft(L left) {
        this.left = left;
    }

    public R getRight() {
        return this.right;
    }

    public void setRight(R right) {
        this.right = right;
    }

    public void set(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public L getAndSetLeft(L newLeft) {
        L res = this.left;
        this.left = newLeft;
        return res;
    }

    public L setAndGetLeft(L newLeft) {
        this.left = newLeft;
        return this.left;
    }

    public R getAndSetRight(R newRight) {
        R res = newRight;
        this.right = newRight;
        return res;
    }

    public R setAndGetRight(R newRight) {
        this.right = newRight;
        return this.right;
    }

    public <E extends Exception> boolean setLeftIf(L newLeft, Throwables.BiPredicate<? super Pair<L, R>, ? super L, E> predicate) throws E {
        if (predicate.test(this, newLeft)) {
            this.left = newLeft;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setRightIf(R newRight, Throwables.BiPredicate<? super Pair<L, R>, ? super R, E> predicate) throws E {
        if (predicate.test(this, newRight)) {
            this.right = newRight;
            return true;
        }
        return false;
    }

    public <E extends Exception> boolean setIf(L newLeft, R newRight, Throwables.TriPredicate<? super Pair<L, R>, ? super L, ? super R, E> predicate) throws E {
        if (predicate.test(this, newLeft, newRight)) {
            this.left = newLeft;
            this.right = newRight;
            return true;
        }
        return false;
    }

    @Beta
    public Pair<R, L> reverse() {
        return new Pair<R, L>(this.right, this.left);
    }

    public Pair<L, R> copy() {
        return new Pair<L, R>(this.left, this.right);
    }

    public Object[] toArray() {
        return new Object[]{this.left, this.right};
    }

    public <A> A[] toArray(A[] a) {
        if (a.length < 2) {
            a = N.copyOf(a, 2);
        }
        a[0] = this.left;
        a[1] = this.right;
        return a;
    }

    public <E extends Exception> void forEach(Throwables.Consumer<?, E> comsumer) throws E {
        Throwables.Consumer<?, E> objComsumer = comsumer;
        objComsumer.accept(this.left);
        objComsumer.accept(this.right);
    }

    public <E extends Exception> void accept(Throwables.BiConsumer<? super L, ? super R, E> action) throws E {
        action.accept(this.left, this.right);
    }

    public <E extends Exception> void accept(Throwables.Consumer<? super Pair<L, R>, E> action) throws E {
        action.accept(this);
    }

    public <U, E extends Exception> U map(Throwables.BiFunction<? super L, ? super R, U, E> mapper) throws E {
        return mapper.apply(this.left, this.right);
    }

    public <U, E extends Exception> U map(Throwables.Function<? super Pair<L, R>, U, E> mapper) throws E {
        return mapper.apply(this);
    }

    public <E extends Exception> u.Optional<Pair<L, R>> filter(Throwables.BiPredicate<? super L, ? super R, E> predicate) throws E {
        return predicate.test(this.left, this.right) ? u.Optional.of(this) : u.Optional.empty();
    }

    public <E extends Exception> u.Optional<Pair<L, R>> filter(Throwables.Predicate<? super Pair<L, R>, E> predicate) throws E {
        return predicate.test(this) ? u.Optional.of(this) : u.Optional.empty();
    }

    public u.Optional<Pair<L, R>> toOptional() {
        return u.Optional.of(this);
    }

    public Tuple.Tuple2<L, R> toTuple() {
        return Tuple.of(this.left, this.right);
    }

    public Map.Entry<L, R> toEntry() {
        return new AbstractMap.SimpleEntry<L, R>(this.left, this.right);
    }

    public ImmutableEntry<L, R> toImmutableEntry() {
        return ImmutableEntry.of(this.left, this.right);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + N.hashCode(this.left);
        result = 31 * result + N.hashCode(this.right);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return N.equals(this.left, other.left) && N.equals(this.right, other.right);
        }
        return false;
    }

    public String toString() {
        return "[" + N.toString(this.left) + ", " + N.toString(this.right) + "]";
    }
}

