/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.pool.KeyedObjectPool;
import com.landawn.abacus.pool.PoolFactory;
import com.landawn.abacus.pool.PoolableWrapper;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Numbers;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.SQLParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class ParsedSql {
    private static final int EVICT_TIME = 60000;
    private static final int LIVE_TIME = 86400000;
    private static final int MAX_IDLE_TIME = 86400000;
    private static final Set<String> opSqlPrefixSet = N.asSet("INSERT", "SELECT", "UPDATE", "DELETE", "WITH", "MERGE");
    private static final int factor = Math.min(Math.max(1, IOUtil.MAX_MEMORY_IN_MB / 1024), 8);
    private static final KeyedObjectPool<String, PoolableWrapper<ParsedSql>> pool = PoolFactory.createKeyedObjectPool(1000 * factor, 60000L);
    private static final String PREFIX_OF_NAMED_PARAMETER = ":";
    private static final char _PREFIX_OF_NAMED_PARAMETER = ":".charAt(0);
    private static final String LEFT_OF_IBATIS_NAMED_PARAMETER = "#{";
    private static final String RIGHT_OF_IBATIS_NAMED_PARAMETER = "}";
    private static final String PREFIX_OF_COUCHBASE_NAMED_PARAMETER = "$";
    private static final char _PREFIX_OF_COUCHBASE_NAMED_PARAMETER = "$".charAt(0);
    private final String sql;
    private final String parameterizedSql;
    private String couchbaseParameterizedSql;
    private final ImmutableList<String> namedParameters;
    private ImmutableList<String> couchbaseNamedParameters;
    private int parameterCount;
    private int couchbaseParameterCount;

    private ParsedSql(String sql) {
        this.sql = sql.trim();
        List<String> words = SQLParser.parse(this.sql);
        boolean isOpSqlPrefix = false;
        for (String word : words) {
            if (!N.notNullOrEmpty(word) || word.equals(" ") || word.startsWith("--") || word.startsWith("/*")) continue;
            isOpSqlPrefix = opSqlPrefixSet.contains(word.toUpperCase());
            break;
        }
        ArrayList<String> namedParameterList = new ArrayList<String>();
        if (isOpSqlPrefix) {
            StringBuilder sb = Objectory.createStringBuilder();
            for (String word : words) {
                if (word.equals("?")) {
                    if (namedParameterList.size() > 0) {
                        throw new IllegalArgumentException("can't mix '?' with name parameter ':propName' or '#{propName}' in the same sql script");
                    }
                    ++this.parameterCount;
                } else if (word.startsWith(LEFT_OF_IBATIS_NAMED_PARAMETER) && word.endsWith(RIGHT_OF_IBATIS_NAMED_PARAMETER)) {
                    namedParameterList.add(word.substring(2, word.length() - 1));
                    word = "?";
                    ++this.parameterCount;
                } else if (word.length() >= 2 && word.charAt(0) == _PREFIX_OF_NAMED_PARAMETER && ParsedSql.isValidNamedParameterChar(word.charAt(1))) {
                    namedParameterList.add(word.substring(1));
                    word = "?";
                    ++this.parameterCount;
                }
                sb.append(word);
            }
            this.parameterizedSql = sb.toString();
            this.namedParameters = ImmutableList.of(namedParameterList);
            Objectory.recycle(sb);
        } else {
            this.parameterizedSql = sql;
            this.namedParameters = ImmutableList.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParsedSql parse(String sql) {
        ParsedSql result = null;
        PoolableWrapper<ParsedSql> w = pool.get(sql);
        if (w == null || w.value() == null) {
            KeyedObjectPool<String, PoolableWrapper<ParsedSql>> keyedObjectPool = pool;
            synchronized (keyedObjectPool) {
                result = new ParsedSql(sql);
                pool.put(sql, PoolableWrapper.of(result, 86400000L, 86400000L));
            }
        } else {
            result = w.value();
        }
        return result;
    }

    public String sql() {
        return this.sql;
    }

    public String getParameterizedSql() {
        return this.parameterizedSql;
    }

    public String getParameterizedSql(boolean isForCouchbase) {
        if (isForCouchbase) {
            if (N.isNullOrEmpty(this.couchbaseParameterizedSql)) {
                this.parseForCouchbase();
            }
            return this.couchbaseParameterizedSql;
        }
        return this.parameterizedSql;
    }

    public ImmutableList<String> getNamedParameters() {
        return this.namedParameters;
    }

    public ImmutableList<String> getNamedParameters(boolean isForCouchbase) {
        if (isForCouchbase) {
            if (N.isNullOrEmpty(this.couchbaseParameterizedSql)) {
                this.parseForCouchbase();
            }
            return this.couchbaseNamedParameters;
        }
        return this.namedParameters;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    public int getParameterCount(boolean isForCouchbase) {
        if (isForCouchbase) {
            if (N.isNullOrEmpty(this.couchbaseParameterizedSql)) {
                this.parseForCouchbase();
            }
            return this.couchbaseParameterCount;
        }
        return this.parameterCount;
    }

    private void parseForCouchbase() {
        ArrayList<String> couchbaseNamedParameterList = new ArrayList<String>();
        List<String> words = SQLParser.parse(this.sql);
        boolean isOpSqlPrefix = false;
        for (String word : words) {
            if (!N.notNullOrEmpty(word)) continue;
            isOpSqlPrefix = opSqlPrefixSet.contains(word.toUpperCase());
            break;
        }
        if (isOpSqlPrefix) {
            StringBuilder sb = Objectory.createStringBuilder();
            int countOfParameter = 0;
            for (String word : words) {
                if (word.equals("?")) {
                    if (couchbaseNamedParameterList.size() > 0) {
                        throw new IllegalArgumentException("can't mix '?' with name parameter ':propName' or '#{propName}' in the same sql script");
                    }
                    word = PREFIX_OF_COUCHBASE_NAMED_PARAMETER + ++countOfParameter;
                } else if (word.startsWith(LEFT_OF_IBATIS_NAMED_PARAMETER) && word.endsWith(RIGHT_OF_IBATIS_NAMED_PARAMETER)) {
                    couchbaseNamedParameterList.add(word.substring(2, word.length() - 1));
                    word = PREFIX_OF_COUCHBASE_NAMED_PARAMETER + ++countOfParameter;
                } else if (word.length() >= 2 && (word.charAt(0) == _PREFIX_OF_NAMED_PARAMETER || word.charAt(0) == _PREFIX_OF_COUCHBASE_NAMED_PARAMETER) && ParsedSql.isValidNamedParameterChar(word.charAt(1))) {
                    couchbaseNamedParameterList.add(word.substring(1));
                    word = PREFIX_OF_COUCHBASE_NAMED_PARAMETER + ++countOfParameter;
                }
                sb.append(word);
            }
            boolean isNamedParametersByNum = true;
            for (int i = 0; i < countOfParameter; ++i) {
                try {
                    if (Numbers.toInt((String)couchbaseNamedParameterList.get(i)) == i + 1) continue;
                    isNamedParametersByNum = false;
                }
                catch (Exception e) {
                    isNamedParametersByNum = false;
                }
                break;
            }
            if (isNamedParametersByNum) {
                couchbaseNamedParameterList.clear();
            }
            this.couchbaseParameterizedSql = sb.toString();
            this.couchbaseNamedParameters = ImmutableList.of(couchbaseNamedParameterList);
            this.couchbaseParameterCount = countOfParameter;
            Objectory.recycle(sb);
        } else {
            this.couchbaseParameterizedSql = this.sql;
            this.couchbaseNamedParameters = ImmutableList.empty();
            this.couchbaseParameterCount = 0;
        }
    }

    private static boolean isValidNamedParameterChar(char ch) {
        return !(ch < '0' || ch > '9' && ch < 'A' || ch > 'Z' && ch < 'a' || ch > 'z' && ch < '\u0080');
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParsedSql) {
            ParsedSql other = (ParsedSql)obj;
            return N.equals(this.sql, other.sql);
        }
        return false;
    }

    public String toString() {
        return "{sql=" + this.sql + ", parameterizedSql=" + this.parameterizedSql + RIGHT_OF_IBATIS_NAMED_PARAMETER;
    }
}

