/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.N;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public enum Percentage {
    _0_0001("0.0001%", 1.0E-6),
    _0_001("0.001%", 1.0E-5),
    _0_01("0.01%", 1.0E-4),
    _0_1("0.1%", 0.001),
    _1("1%", 0.01),
    _2("2%", 0.02),
    _3("3%", 0.03),
    _4("4%", 0.04),
    _5("5%", 0.05),
    _6("6%", 0.06),
    _7("7%", 0.07),
    _8("8%", 0.08),
    _9("9%", 0.09),
    _10("10%", 0.1),
    _20("20%", 0.2),
    _30("30%", 0.3),
    _40("40%", 0.4),
    _50("50%", 0.5),
    _60("60%", 0.6),
    _70("70%", 0.7),
    _80("80%", 0.8),
    _90("90%", 0.9),
    _91("91%", 0.91),
    _92("92%", 0.92),
    _93("93%", 0.93),
    _94("94%", 0.94),
    _95("95%", 0.95),
    _96("96%", 0.96),
    _97("97%", 0.97),
    _98("98%", 0.98),
    _99("99%", 0.99),
    _99_9("99.9%", 0.999),
    _99_99("99.99%", 0.9999),
    _99_999("99.999%", 0.99999),
    _99_9999("99.9999%", 0.999999);

    private static final Map<Integer, Percentage> valuePool;
    private static final Map<String, ImmutableSet<Percentage>> rangePool;
    private final String str;
    private final double val;

    private Percentage(String str, double val) {
        this.str = str;
        this.val = val;
    }

    public static ImmutableSet<Percentage> range(Percentage startInclusive, Percentage endExclusive) {
        String key = "(" + startInclusive.str + ", " + endExclusive.str + ")";
        ImmutableSet<Percentage> result = rangePool.get(key);
        if (result == null) {
            Set set = N.newLinkedHashSet();
            for (Percentage e : Percentage.values()) {
                if (N.compare(e.val, startInclusive.val) < 0 || N.compare(e.val, endExclusive.val) >= 0) continue;
                set.add(e);
            }
            result = ImmutableSet.of(set);
            rangePool.put(key, result);
        }
        return result;
    }

    public static ImmutableSet<Percentage> range(Percentage startInclusive, Percentage endExclusive, Percentage by) {
        String key = "(" + startInclusive.str + ", " + endExclusive.str + ", " + by.str + ")";
        ImmutableSet<Percentage> result = rangePool.get(key);
        if (result == null) {
            Set set = N.newLinkedHashSet();
            int startVal = Percentage.intValue(startInclusive);
            int endVal = Percentage.intValue(endExclusive);
            int byVal = Percentage.intValue(by);
            for (Percentage p : Percentage.values()) {
                int val = Percentage.intValue(p);
                if (val < startVal || val >= endVal || (val - startVal) % byVal != 0) continue;
                set.add(p);
            }
            result = ImmutableSet.of(set);
            rangePool.put(key, result);
        }
        return result;
    }

    public static ImmutableSet<Percentage> rangeClosed(Percentage startInclusive, Percentage endInclusive) {
        String key = "(" + startInclusive.str + ", " + endInclusive.str + "]";
        ImmutableSet<Percentage> result = rangePool.get(key);
        if (result == null) {
            Set set = N.newLinkedHashSet();
            for (Percentage e : Percentage.values()) {
                if (N.compare(e.val, startInclusive.val) < 0 || N.compare(e.val, endInclusive.val) > 0) continue;
                set.add(e);
            }
            result = ImmutableSet.of(set);
            rangePool.put(key, result);
        }
        return result;
    }

    public static ImmutableSet<Percentage> rangeClosed(Percentage startInclusive, Percentage endInclusive, Percentage by) {
        String key = "(" + startInclusive.str + ", " + endInclusive.str + ", " + by.str + "]";
        ImmutableSet<Percentage> result = rangePool.get(key);
        if (result == null) {
            Set set = N.newLinkedHashSet();
            int startVal = Percentage.intValue(startInclusive);
            int endVal = Percentage.intValue(endInclusive);
            int byVal = Percentage.intValue(by);
            for (Percentage p : Percentage.values()) {
                int val = Percentage.intValue(p);
                if (val < startVal || val > endVal || (val - startVal) % byVal != 0) continue;
                set.add(p);
            }
            result = ImmutableSet.of(set);
            rangePool.put(key, result);
        }
        return result;
    }

    private static int intValue(Percentage p) {
        return (int)(p.val * 1000000.0);
    }

    public double doubleValue() {
        return this.val;
    }

    public String toString() {
        return this.str;
    }

    static {
        valuePool = new HashMap<Integer, Percentage>();
        for (Percentage p : Percentage.values()) {
            valuePool.put(Percentage.intValue(p), p);
        }
        rangePool = new ConcurrentHashMap<String, ImmutableSet<Percentage>>();
    }
}

