/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.DateUtil;
import com.landawn.abacus.util.ExceptionUtil;
import com.landawn.abacus.util.IOUtil;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Throwables;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

public final class Profiler {
    private static final Logger logger = LoggerFactory.getLogger(Profiler.class);
    private static final DecimalFormat elapsedTimeFormat = new DecimalFormat("#0.000");
    private static boolean suspended = false;

    private Profiler() {
    }

    public static MultiLoopsStatistics run(int threadNum, int loopNum, int roundNum, Throwables.Runnable<? extends Exception> command) {
        return Profiler.run(threadNum, loopNum, roundNum, "run", command);
    }

    public static MultiLoopsStatistics run(int threadNum, int loopNum, int roundNum, String label, Throwables.Runnable<? extends Exception> command) {
        return Profiler.run(threadNum, 0L, loopNum, 0L, roundNum, label, command);
    }

    public static MultiLoopsStatistics run(int threadNum, long threadDelay, int loopNum, long loopDelay, int roundNum, String label, Throwables.Runnable<? extends Exception> command) {
        return Profiler.run(command, label, Profiler.getMethod(command, "run"), null, null, null, null, null, threadNum, threadDelay, loopNum, loopDelay, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, String method, int threadNum, int loopNum, int roundNum) {
        return Profiler.run(instance, Profiler.getMethod(instance, method), threadNum, loopNum, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, Method method, int threadNum, int loopNum, int roundNum) {
        return Profiler.run(instance, method, null, threadNum, loopNum, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, Method method, Object arg, int threadNum, int loopNum, int roundNum) {
        return Profiler.run(instance, method, arg, threadNum, 0L, loopNum, 0L, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, Method method, Object arg, int threadNum, long threadDelay, int loopNum, long loopDelay, int roundNum) {
        return Profiler.run(instance, method, arg == null ? null : Array.asList(arg), null, null, null, null, threadNum, threadDelay, loopNum, loopDelay, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, Method method, List<?> args, int threadNum, int loopNum, int roundNum) {
        return Profiler.run(instance, method, args, null, null, null, null, threadNum, 0L, loopNum, 0L, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, Method method, List<?> args, Method setUpForMethod, Method tearDownForMethod, Method setUpForLoop, Method tearDownForLoop, int threadNum, long threadDelay, int loopNum, long loopDelay, int roundNum) {
        return Profiler.run(instance, method.getName(), method, args, setUpForMethod, tearDownForMethod, setUpForLoop, tearDownForLoop, threadNum, threadDelay, loopNum, loopDelay, roundNum);
    }

    static MultiLoopsStatistics run(Object instance, String methodName, Method method, List<?> args, Method setUpForMethod, Method tearDownForMethod, Method setUpForLoop, Method tearDownForLoop, int threadNum, long threadDelay, int loopNum, long loopDelay, int roundNum) {
        if (threadNum <= 0 || loopNum <= 0 || threadDelay < 0L || loopDelay < 0L) {
            throw new IllegalArgumentException("threadNum=" + threadNum + ", loopNum=" + loopNum + ", threadDelay=" + threadDelay + ", loopDelay=" + loopDelay);
        }
        if (N.notNullOrEmpty(args) && args.size() > 1 && args.size() != threadNum) {
            throw new IllegalArgumentException("The input args must be null or size = 1 or size = threadNum. It's the input parameter for the every loop in each thread ");
        }
        if (threadNum * loopNum > IOUtil.MAX_MEMORY_IN_MB * 1000) {
            if (IOUtil.MAX_MEMORY_IN_MB < 1024) {
                logger.warn("Saving big number loop result in small memory may slow down the performance of target method. Conside increasing the maximium JVM memory size.");
            } else {
                logger.warn("Saving big number loop result may slow down the performance of target method. Conside adding for-loop to outter of the target method and reducing the loop number (" + loopNum + ") to a smaller number");
            }
        }
        if (roundNum == 1) {
            return Profiler.run(instance, methodName, method, args, setUpForMethod, tearDownForMethod, setUpForLoop, tearDownForLoop, threadNum, threadDelay, loopNum, loopDelay);
        }
        MultiLoopsStatistics result = null;
        for (int i = 0; i < roundNum; ++i) {
            if (result != null) {
                result.printResult();
                result = null;
            }
            result = Profiler.run(instance, methodName, method, args, setUpForMethod, tearDownForMethod, setUpForLoop, tearDownForLoop, threadNum, threadDelay, loopNum, loopDelay);
        }
        return result;
    }

    private static MultiLoopsStatistics run(final Object instance, final String methodName, final Method method, List<?> args, final Method setUpForMethod, final Method tearDownForMethod, final Method setUpForLoop, final Method tearDownForLoop, int threadNum, long threadDelay, final int loopNum, final long loopDelay) {
        if (!method.isAccessible()) {
            ClassUtil.setAccessibleQuietly(method, true);
        }
        Profiler.gc();
        N.sleep(1000L);
        ExecutorService asyncExecutor = Executors.newFixedThreadPool(threadNum);
        final AtomicInteger threadCounter = new AtomicInteger();
        final List<LoopStatistics> loopStatisticsList = Collections.synchronizedList(new ArrayList());
        final PrintStream ps = System.out;
        long startTimeInMillis = System.currentTimeMillis();
        long startTimeInNano = System.nanoTime();
        for (int threadIndex = 0; threadIndex < (suspended ? 1 : threadNum); ++threadIndex) {
            final Object arg = N.isNullOrEmpty(args) ? null : (args.size() == 1 ? args.get(0) : args.get(threadIndex));
            threadCounter.incrementAndGet();
            asyncExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Profiler.runLoops(instance, methodName, method, arg, setUpForMethod, tearDownForMethod, setUpForLoop, tearDownForLoop, loopNum, loopDelay, loopStatisticsList, ps);
                    }
                    finally {
                        threadCounter.decrementAndGet();
                    }
                }
            });
            N.sleep(threadDelay);
        }
        while (threadCounter.get() > 0) {
            N.sleep(1L);
        }
        long endTimeInNano = System.nanoTime();
        long endTimeInMillis = System.currentTimeMillis();
        return new MultiLoopsStatistics(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano, threadNum, loopStatisticsList);
    }

    private static void runLoops(Object instance, String methodName, Method method, Object arg, Method setUpForMethod, Method tearDownForMethod, Method setUpForLoop, Method tearDownForLoop, int loopNum, long loopDelay, List<LoopStatistics> loopStatisticsList, PrintStream ps) {
        for (int loopIndex = 0; loopIndex < (suspended ? 1 : loopNum); ++loopIndex) {
            if (setUpForLoop != null) {
                try {
                    setUpForLoop.invoke(instance, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace(ps);
                    logger.warn(ExceptionUtil.getMessage(e));
                }
            }
            long startTimeInMillis = System.currentTimeMillis();
            long startTimeInNano = System.nanoTime();
            List<MethodStatistics> methodStatisticsList = Profiler.runLoop(instance, methodName, method, arg, setUpForMethod, tearDownForMethod, ps);
            long endTimeInNano = System.nanoTime();
            long endTimeInMillis = System.currentTimeMillis();
            if (tearDownForLoop != null) {
                try {
                    tearDownForLoop.invoke(instance, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace(ps);
                    logger.warn(ExceptionUtil.getMessage(e));
                }
            }
            SingleLoopStatistics loopStatistics = new SingleLoopStatistics(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano, methodStatisticsList);
            loopStatisticsList.add(loopStatistics);
            N.sleep(loopDelay);
        }
    }

    private static List<MethodStatistics> runLoop(Object instance, String methodName, Method method, Object arg, Method setUpForMethod, Method tearDownForMethod, PrintStream ps) {
        ArrayList<MethodStatistics> methodStatisticsList = new ArrayList<MethodStatistics>();
        if (setUpForMethod != null) {
            try {
                setUpForMethod.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace(ps);
                logger.warn(ExceptionUtil.getMessage(e));
            }
        }
        long startTimeInMillis = System.currentTimeMillis();
        long startTimeInNano = System.nanoTime();
        Throwable result = null;
        try {
            if (method.getParameterTypes().length == 0) {
                method.invoke(instance, new Object[0]);
            } else {
                method.invoke(instance, arg);
            }
        }
        catch (InvocationTargetException e) {
            e.printStackTrace(ps);
            logger.warn(ExceptionUtil.getMessage(e));
            result = e.getTargetException();
        }
        catch (Exception e) {
            e.printStackTrace(ps);
            logger.warn(ExceptionUtil.getMessage(e));
            result = e;
        }
        long endTimeInNano = System.nanoTime();
        long endTimeInMillis = System.currentTimeMillis();
        if (tearDownForMethod != null) {
            try {
                tearDownForMethod.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace(ps);
                logger.warn(ExceptionUtil.getMessage(e));
            }
        }
        MethodStatistics methodStatistics = new MethodStatistics(methodName, startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano, result);
        methodStatisticsList.add(methodStatistics);
        return methodStatisticsList;
    }

    private static Method getMethod(Object instance, String methodName) {
        Method method = ClassUtil.getDeclaredMethod(instance.getClass(), methodName, new Class[0]);
        if (method == null) {
            throw new IllegalArgumentException("No method found by name: " + methodName);
        }
        if (!method.isAccessible()) {
            ClassUtil.setAccessibleQuietly(method, true);
        }
        return method;
    }

    private static void gc() {
        Runtime.getRuntime().gc();
        N.sleep(3000L);
    }

    static void suspend(boolean yesOrNo) {
        suspended = yesOrNo;
    }

    public static class MultiLoopsStatistics
    extends AbstractStatistics
    implements LoopStatistics {
        private static final String SEPARATOR_LINE = "========================================================================================================================";
        private final int threadNum;
        private List<LoopStatistics> loopStatisticsList;

        public MultiLoopsStatistics(long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano, int threadNum) {
            this(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano, threadNum, null);
        }

        public MultiLoopsStatistics(long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano, int threadNum, List<LoopStatistics> loopStatisticsList) {
            super(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano);
            this.threadNum = threadNum;
            this.loopStatisticsList = loopStatisticsList;
        }

        public int getThreadNum() {
            return this.threadNum;
        }

        @Override
        public List<String> getMethodNameList() {
            List<String> result = null;
            result = this.loopStatisticsList == null ? new ArrayList<String>() : this.loopStatisticsList.get(0).getMethodNameList();
            return result;
        }

        public List<LoopStatistics> getLoopStatisticsList() {
            if (this.loopStatisticsList == null) {
                this.loopStatisticsList = new ArrayList<LoopStatistics>();
            }
            return this.loopStatisticsList;
        }

        public void setLoopStatisticsList(List<LoopStatistics> loopStatisticsList) {
            this.loopStatisticsList = loopStatisticsList;
        }

        public void addMethodStatisticsList(LoopStatistics loopStatistics) {
            this.getLoopStatisticsList().add(loopStatistics);
        }

        @Override
        public MethodStatistics getMaxElapsedTimeMethod() {
            MethodStatistics result = null;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    MethodStatistics methodStatistics = loopStatistics.getMaxElapsedTimeMethod();
                    if (result != null && !(methodStatistics.getElapsedTimeInMillis() > result.getElapsedTimeInMillis())) continue;
                    result = methodStatistics;
                }
            }
            return result;
        }

        @Override
        public MethodStatistics getMinElapsedTimeMethod() {
            MethodStatistics result = null;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    MethodStatistics methodStatistics = loopStatistics.getMinElapsedTimeMethod();
                    if (result != null && !(methodStatistics.getElapsedTimeInMillis() < result.getElapsedTimeInMillis())) continue;
                    result = methodStatistics;
                }
            }
            return result;
        }

        @Override
        public double getMethodTotalElapsedTimeInMillis(String methodName) {
            double result = 0.0;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    result += loopStatistics.getMethodTotalElapsedTimeInMillis(methodName);
                }
            }
            return result;
        }

        @Override
        public double getMethodMaxElapsedTimeInMillis(String methodName) {
            double result = 0.0;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    double loopMethodMaxTime = loopStatistics.getMethodMaxElapsedTimeInMillis(methodName);
                    if (!(loopMethodMaxTime > result)) continue;
                    result = loopMethodMaxTime;
                }
            }
            return result;
        }

        @Override
        public double getMethodMinElapsedTimeInMillis(String methodName) {
            double result = 2.147483647E9;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    double loopMethodMinTime = loopStatistics.getMethodMinElapsedTimeInMillis(methodName);
                    if (!(loopMethodMinTime < result)) continue;
                    result = loopMethodMinTime;
                }
            }
            return result;
        }

        @Override
        public double getMethodAverageElapsedTimeInMillis(String methodName) {
            double totalTime = 0.0;
            int methodNum = 0;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    double loopMethodTotalTime = loopStatistics.getMethodTotalElapsedTimeInMillis(methodName);
                    int loopMethodSize = loopStatistics.getMethodSize(methodName);
                    totalTime += loopMethodTotalTime;
                    methodNum += loopMethodSize;
                }
            }
            return methodNum > 0 ? totalTime / (double)methodNum : totalTime;
        }

        @Override
        public double getTotalElapsedTimeInMillis() {
            double result = 0.0;
            if (this.loopStatisticsList != null) {
                for (int index = 0; index < this.loopStatisticsList.size(); ++index) {
                    LoopStatistics loopStatistics = this.loopStatisticsList.get(index);
                    result += loopStatistics.getTotalElapsedTimeInMillis();
                }
            }
            return result;
        }

        @Override
        public int getMethodSize(String methodName) {
            int result = 0;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    result += loopStatistics.getMethodSize(methodName);
                }
            }
            return result;
        }

        @Override
        public List<MethodStatistics> getMethodStatisticsList(String methodName) {
            ArrayList<MethodStatistics> methodStatisticsList = new ArrayList<MethodStatistics>(this.getMethodSize(methodName));
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    methodStatisticsList.addAll(loopStatistics.getMethodStatisticsList(methodName));
                }
            }
            return methodStatisticsList;
        }

        @Override
        public List<MethodStatistics> getFailedMethodStatisticsList(String methodName) {
            ArrayList<MethodStatistics> result = new ArrayList<MethodStatistics>();
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    result.addAll(loopStatistics.getFailedMethodStatisticsList(methodName));
                }
            }
            return result;
        }

        @Override
        public List<MethodStatistics> getAllFailedMethodStatisticsList() {
            ArrayList<MethodStatistics> result = new ArrayList<MethodStatistics>();
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    result.addAll(loopStatistics.getAllFailedMethodStatisticsList());
                }
            }
            return result;
        }

        private int getTotalCall() {
            int res = 0;
            if (this.loopStatisticsList != null) {
                for (LoopStatistics loopStatistics : this.loopStatisticsList) {
                    res += loopStatistics.getMethodNameList().size();
                }
            }
            return res;
        }

        public void printResult() {
            this.writeResult(new PrintWriter(System.out));
        }

        public void writeResult(OutputStream os) {
            this.writeResult(new PrintWriter(os));
        }

        public void writeResult(Writer writer) {
            this.writeResult(new PrintWriter(writer));
        }

        private void writeResult(PrintWriter writer) {
            writer.println();
            writer.println(SEPARATOR_LINE);
            writer.println("(unit: milliseconds)");
            writer.println("threadNum=" + this.threadNum + "; loops=" + this.loopStatisticsList.size() / this.threadNum);
            writer.println("startTime: " + this.time2String(this.getStartTimeInMillis()));
            writer.println("endTime:   " + this.time2String(this.getEndTimeInMillis()));
            writer.println("totalElapsedTime: " + elapsedTimeFormat.format(this.getElapsedTimeInMillis()));
            writer.println();
            String methodNameTitil = "<method name>";
            List<String> methodNameList = this.getMethodNameList();
            int maxMethodNameLength = methodNameTitil.length();
            if (methodNameList.size() > 0) {
                for (String methodName : methodNameList) {
                    if (methodName.length() <= maxMethodNameLength) continue;
                    maxMethodNameLength = methodName.length();
                }
            }
            writer.println();
            writer.println(StringUtil.padEnd(methodNameTitil + ",  ", maxMethodNameLength += 3) + "|avg time|, |min time|, |max time|, |0.01% >=|, |0.1% >=|,  |1% >=|,    |10% >=|,   |20% >=|,   |50% >=|,   |80% >=|,   |90% >=|,   |99% >=|,   |99.9% >=|, |99.99% >=|");
            for (String methodName : methodNameList) {
                List<MethodStatistics> methodStatisticsList = this.getMethodStatisticsList(methodName);
                int size = methodStatisticsList.size();
                Collections.sort(methodStatisticsList, new Comparator<MethodStatistics>(){

                    @Override
                    public int compare(MethodStatistics o1, MethodStatistics o2) {
                        return o1.getElapsedTimeInMillis() == o2.getElapsedTimeInMillis() ? 0 : (o1.getElapsedTimeInMillis() > o2.getElapsedTimeInMillis() ? -1 : 1);
                    }
                });
                double avgTime = this.getMethodAverageElapsedTimeInMillis(methodName);
                double maxTime = methodStatisticsList.get(0).getElapsedTimeInMillis();
                double minTime = methodStatisticsList.get(size - 1).getElapsedTimeInMillis();
                int minLen = 12;
                writer.println(StringUtil.padEnd(methodName + ",  ", maxMethodNameLength) + StringUtil.padEnd(elapsedTimeFormat.format(avgTime) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(minTime) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(maxTime) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 1.0E-4)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.001)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.01)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.1)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.2)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.5)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.8)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.9)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.99)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.999)).getElapsedTimeInMillis()) + ",  ", 12) + StringUtil.padEnd(elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.9999)).getElapsedTimeInMillis()) + ",  ", 12));
            }
            writer.println();
            this.writeError(writer);
            writer.println(SEPARATOR_LINE);
            writer.flush();
        }

        private void writeError(PrintWriter writer) {
            List<MethodStatistics> failedMethodList = this.getAllFailedMethodStatisticsList();
            if (failedMethodList.size() > 0) {
                writer.println();
                writer.println("Errors:" + failedMethodList.size() + " (" + (double)failedMethodList.size() * 100.0 / (double)this.getTotalCall() + "%)");
                for (int index = 0; index < failedMethodList.size(); ++index) {
                    writer.println("--------------------------------------------------------------------------------");
                    MethodStatistics methodStatistics = failedMethodList.get(index);
                    writer.println(methodStatistics.toString());
                }
            }
        }

        public void writeHtmlResult(OutputStream os) {
            this.writeHtmlResult(new PrintWriter(os));
        }

        public void writeHtmlResult(Writer writer) {
            this.writeHtmlResult(new PrintWriter(writer));
        }

        private void writeHtmlResult(PrintWriter writer) {
            writer.println(SEPARATOR_LINE);
            writer.println("<br/>(unit: milliseconds)");
            writer.println("<br/>threadNum=" + this.threadNum + "; loops=" + this.loopStatisticsList.size() / this.threadNum + "");
            writer.println("<br/>startTime: " + this.time2String(this.getStartTimeInMillis()) + "");
            writer.println("<br/>endTime:   " + this.time2String(this.getEndTimeInMillis()) + "");
            writer.println("<br/>totalElapsedTime: " + elapsedTimeFormat.format(this.getElapsedTimeInMillis()) + "");
            writer.println("<br/>");
            writer.println("<br/>");
            writer.println("<table width=\"1200\" border=\"1\">");
            writer.println("<tr>");
            writer.println("<th>method name</th>");
            writer.println("<th>avg time</th>");
            writer.println("<th>min time</th>");
            writer.println("<th>max time</th>");
            writer.println("<th>0.01% &gt;=</th>");
            writer.println("<th>0.1% &gt;=</th>");
            writer.println("<th>1% &gt;=</th>");
            writer.println("<th>10% &gt;=</th>");
            writer.println("<th>20% &gt;=</th>");
            writer.println("<th>50% &gt;=</th>");
            writer.println("<th>80% &gt;=</th>");
            writer.println("<th>90% &gt;=</th>");
            writer.println("<th>99% &gt;=</th>");
            writer.println("<th>99.9% &gt;=</th>");
            writer.println("<th>99.99% &gt;=</th>");
            writer.println("</tr>");
            List<String> methodNameList = this.getMethodNameList();
            for (String methodName : methodNameList) {
                List<MethodStatistics> methodStatisticsList = this.getMethodStatisticsList(methodName);
                int size = methodStatisticsList.size();
                Collections.sort(methodStatisticsList, new Comparator<MethodStatistics>(){

                    @Override
                    public int compare(MethodStatistics o1, MethodStatistics o2) {
                        return o1.getElapsedTimeInMillis() == o2.getElapsedTimeInMillis() ? 0 : (o1.getElapsedTimeInMillis() > o2.getElapsedTimeInMillis() ? -1 : 1);
                    }
                });
                double avgTime = this.getMethodAverageElapsedTimeInMillis(methodName);
                double minTime = methodStatisticsList.get(size - 1).getElapsedTimeInMillis();
                double maxTime = methodStatisticsList.get(0).getElapsedTimeInMillis();
                writer.println("<tr>");
                writer.println("<td>" + methodName + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(avgTime) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(minTime) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(maxTime) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 1.0E-4)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.001)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.01)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.1)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.2)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.5)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.8)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.9)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.99)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.999)).getElapsedTimeInMillis()) + "</td>");
                writer.println("<td>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.9999)).getElapsedTimeInMillis()) + "</td>");
                writer.println("</tr>");
            }
            writer.println("</table>");
            this.writeHtmlError(writer);
            writer.println(SEPARATOR_LINE);
            writer.flush();
        }

        private void writeHtmlError(PrintWriter writer) {
            List<MethodStatistics> failedMethodList = this.getAllFailedMethodStatisticsList();
            if (failedMethodList.size() > 0) {
                writer.println("<h4>Errors:" + failedMethodList.size() + " (" + (double)failedMethodList.size() * 100.0 / (double)this.getTotalCall() + "%)</h4>");
                for (int index = 0; index < failedMethodList.size(); ++index) {
                    writer.println("<br/>--------------------------------------------------------------------------------");
                    MethodStatistics methodStatistics = failedMethodList.get(index);
                    writer.println("<br/>" + methodStatistics.toString());
                }
            }
        }

        public void writeXmlResult(OutputStream os) {
            this.writeXmlResult(new PrintWriter(os));
        }

        public void writeXmlResult(Writer writer) {
            this.writeXmlResult(new PrintWriter(writer));
        }

        private void writeXmlResult(PrintWriter writer) {
            writer.println("<result>");
            writer.println("<unit>milliseconds</unit>");
            writer.println("<threadNum>" + this.threadNum + "</threadNum>");
            writer.println("<loops>" + this.loopStatisticsList.size() / this.threadNum + "</loops>");
            writer.println("<startTime>" + this.time2String(this.getStartTimeInMillis()) + "</startTime>");
            writer.println("<endTime>" + this.time2String(this.getEndTimeInMillis()) + "</endTime>");
            writer.println("<totalElapsedTime>" + elapsedTimeFormat.format(this.getElapsedTimeInMillis()) + "</totalElapsedTime>");
            writer.println();
            List<String> methodNameList = this.getMethodNameList();
            for (String methodName : methodNameList) {
                List<MethodStatistics> methodStatisticsList = this.getMethodStatisticsList(methodName);
                int size = methodStatisticsList.size();
                Collections.sort(methodStatisticsList, new Comparator<MethodStatistics>(){

                    @Override
                    public int compare(MethodStatistics o1, MethodStatistics o2) {
                        return o1.getElapsedTimeInMillis() == o2.getElapsedTimeInMillis() ? 0 : (o1.getElapsedTimeInMillis() > o2.getElapsedTimeInMillis() ? -1 : 1);
                    }
                });
                double avgTime = this.getMethodAverageElapsedTimeInMillis(methodName);
                double minTime = methodStatisticsList.get(size - 1).getElapsedTimeInMillis();
                double maxTime = methodStatisticsList.get(0).getElapsedTimeInMillis();
                writer.println("<method name=\"" + methodName + "\">");
                writer.println("<avgTime>" + elapsedTimeFormat.format(avgTime) + "</avgTime>");
                writer.println("<minTime>" + elapsedTimeFormat.format(minTime) + "</minTime>");
                writer.println("<maxTime>" + elapsedTimeFormat.format(maxTime) + "</maxTime>");
                writer.println("<_0.0001>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 1.0E-4)).getElapsedTimeInMillis()) + "</_0.0001>");
                writer.println("<_0.001>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.001)).getElapsedTimeInMillis()) + "</_0.001>");
                writer.println("<_0.01>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.01)).getElapsedTimeInMillis()) + "</_0.01>");
                writer.println("<_0.2>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.2)).getElapsedTimeInMillis()) + "</_0.2>");
                writer.println("<_0.5>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.5)).getElapsedTimeInMillis()) + "</_0.5>");
                writer.println("<_0.8>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.8)).getElapsedTimeInMillis()) + "</_0.8>");
                writer.println("<_0.9>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.9)).getElapsedTimeInMillis()) + "</_0.9>");
                writer.println("<_0.99>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.99)).getElapsedTimeInMillis()) + "</_0.99>");
                writer.println("<_0.999>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.999)).getElapsedTimeInMillis()) + "</_0.999>");
                writer.println("<_0.9999>" + elapsedTimeFormat.format(methodStatisticsList.get((int)((double)size * 0.9999)).getElapsedTimeInMillis()) + "</_0.9999>");
                writer.println("</method>");
            }
            List<MethodStatistics> failedMethodList = this.getAllFailedMethodStatisticsList();
            if (failedMethodList.size() > 0) {
                writer.println("<errors>" + failedMethodList.size() + " (" + (double)failedMethodList.size() * 100.0 / (double)this.getTotalCall() + "%)</errors>");
                for (MethodStatistics methodStatistics : failedMethodList) {
                    writer.println("<error>" + methodStatistics.toString() + "</error>");
                }
            }
            writer.println("</result>");
            writer.flush();
        }
    }

    static class SingleLoopStatistics
    extends AbstractStatistics
    implements LoopStatistics {
        private List<MethodStatistics> methodStatisticsList;

        public SingleLoopStatistics() {
        }

        public SingleLoopStatistics(long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano) {
            this(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano, null);
        }

        public SingleLoopStatistics(long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano, List<MethodStatistics> methodStatisticsList) {
            super(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano);
            this.methodStatisticsList = methodStatisticsList;
        }

        @Override
        public List<String> getMethodNameList() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (result.contains(methodStatistics.getMethodName())) continue;
                    result.add(methodStatistics.getMethodName());
                }
            }
            return result;
        }

        public List<MethodStatistics> getMethodStatisticsList() {
            if (this.methodStatisticsList == null) {
                this.methodStatisticsList = new ArrayList<MethodStatistics>();
            }
            return this.methodStatisticsList;
        }

        public void setMethodStatisticsList(List<MethodStatistics> methodStatisticsList) {
            this.methodStatisticsList = methodStatisticsList;
        }

        public void addMethodStatisticsList(MethodStatistics methodStatistics) {
            this.getMethodStatisticsList().add(methodStatistics);
        }

        @Override
        public MethodStatistics getMaxElapsedTimeMethod() {
            MethodStatistics result = null;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (result != null && !(methodStatistics.getElapsedTimeInMillis() > result.getElapsedTimeInMillis())) continue;
                    result = methodStatistics;
                }
            }
            return result;
        }

        @Override
        public MethodStatistics getMinElapsedTimeMethod() {
            MethodStatistics result = null;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (result != null && !(methodStatistics.getElapsedTimeInMillis() < result.getElapsedTimeInMillis())) continue;
                    result = methodStatistics;
                }
            }
            return result;
        }

        @Override
        public double getMethodTotalElapsedTimeInMillis(String methodName) {
            double result = 0.0;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.getMethodName().equals(methodName)) continue;
                    result += methodStatistics.getElapsedTimeInMillis();
                }
            }
            return result;
        }

        @Override
        public double getMethodMaxElapsedTimeInMillis(String methodName) {
            double result = 0.0;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.getMethodName().equals(methodName) || !(methodStatistics.getElapsedTimeInMillis() > result)) continue;
                    result = methodStatistics.getElapsedTimeInMillis();
                }
            }
            return result;
        }

        @Override
        public double getMethodMinElapsedTimeInMillis(String methodName) {
            double result = 2.147483647E9;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.getMethodName().equals(methodName) || !(methodStatistics.getElapsedTimeInMillis() < result)) continue;
                    result = methodStatistics.getElapsedTimeInMillis();
                }
            }
            return result;
        }

        @Override
        public double getMethodAverageElapsedTimeInMillis(String methodName) {
            double totalTime = 0.0;
            int methodNum = 0;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.getMethodName().equals(methodName)) continue;
                    totalTime += methodStatistics.getElapsedTimeInMillis();
                    ++methodNum;
                }
            }
            return methodNum > 0 ? totalTime / (double)methodNum : totalTime;
        }

        @Override
        public double getTotalElapsedTimeInMillis() {
            double result = 0.0;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    result += methodStatistics.getElapsedTimeInMillis();
                }
            }
            return result;
        }

        @Override
        public int getMethodSize(String methodName) {
            int methodSize = 0;
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.getMethodName().equals(methodName)) continue;
                    ++methodSize;
                }
            }
            return methodSize;
        }

        @Override
        public List<MethodStatistics> getMethodStatisticsList(String methodName) {
            ArrayList<MethodStatistics> result = new ArrayList<MethodStatistics>(this.getMethodSize(methodName));
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.getMethodName().equals(methodName)) continue;
                    result.add(methodStatistics);
                }
            }
            return result;
        }

        @Override
        public List<MethodStatistics> getFailedMethodStatisticsList(String methodName) {
            ArrayList<MethodStatistics> result = new ArrayList<MethodStatistics>();
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.isFailed() || !methodStatistics.getMethodName().equals(methodName)) continue;
                    result.add(methodStatistics);
                }
            }
            return result;
        }

        @Override
        public List<MethodStatistics> getAllFailedMethodStatisticsList() {
            ArrayList<MethodStatistics> result = new ArrayList<MethodStatistics>();
            if (this.methodStatisticsList != null) {
                for (MethodStatistics methodStatistics : this.methodStatisticsList) {
                    if (!methodStatistics.isFailed()) continue;
                    result.add(methodStatistics);
                }
            }
            return result;
        }
    }

    static class MethodStatistics
    extends AbstractStatistics {
        private final String methodName;
        private Object result;

        public MethodStatistics(String methodName) {
            this.methodName = methodName;
        }

        public MethodStatistics(String methodName, long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano) {
            this(methodName, startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano, null);
        }

        public MethodStatistics(String methodName, long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano, Object result) {
            super(startTimeInMillis, endTimeInMillis, startTimeInNano, endTimeInNano);
            this.methodName = methodName;
            this.result = result;
        }

        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void setResult(Object result) {
            this.result = result;
        }

        public boolean isFailed() {
            return this.result != null && this.result instanceof Exception;
        }

        public String toString() {
            if (this.isFailed()) {
                Exception e = (Exception)this.result;
                return "method=" + this.methodName + ", startTime=" + this.time2String(this.getStartTimeInMillis()) + ", endTime=" + this.time2String(this.getEndTimeInMillis()) + ", result=" + ClassUtil.getSimpleClassName(e.getClass()) + ": " + e.getMessage() + ".";
            }
            return "method=" + this.methodName + ", startTime=" + this.time2String(this.getStartTimeInMillis()) + ", endTime=" + this.time2String(this.getEndTimeInMillis()) + ", result=" + this.result + ".";
        }
    }

    static abstract class AbstractStatistics
    implements Statistics {
        private long startTimeInMillis;
        private long endTimeInMillis;
        private long startTimeInNano;
        private long endTimeInNano;
        private Object result;

        public AbstractStatistics() {
            this(0L, 0L, 0L, 0L);
        }

        public AbstractStatistics(long startTimeInMillis, long endTimeInMillis, long startTimeInNano, long endTimeInNano) {
            this.startTimeInMillis = startTimeInMillis;
            this.endTimeInMillis = endTimeInMillis;
            this.startTimeInNano = startTimeInNano;
            this.endTimeInNano = endTimeInNano;
        }

        @Override
        public long getStartTimeInMillis() {
            return this.startTimeInMillis;
        }

        @Override
        public void setStartTimeInMillis(long startTimeInMillis) {
            this.startTimeInMillis = startTimeInMillis;
        }

        @Override
        public long getEndTimeInMillis() {
            return this.endTimeInMillis;
        }

        @Override
        public void setEndTimeInMillis(long endTimeInMillis) {
            this.endTimeInMillis = endTimeInMillis;
        }

        @Override
        public long getStartTimeInNano() {
            return this.startTimeInNano;
        }

        @Override
        public void setStartTimeInNano(long startTimeInNano) {
            this.startTimeInNano = startTimeInNano;
        }

        @Override
        public long getEndTimeInNano() {
            return this.endTimeInNano;
        }

        @Override
        public void setEndTimeInNano(long endTimeInNano) {
            this.endTimeInNano = endTimeInNano;
        }

        @Override
        public double getElapsedTimeInMillis() {
            return (double)(this.endTimeInNano - this.startTimeInNano) / 1000000.0;
        }

        @Override
        public Object getResult() {
            return this.result;
        }

        @Override
        public void setResult(Object result) {
            this.result = result;
        }

        protected String time2String(long timeInMillis) {
            Timestamp timestamp = DateUtil.createTimestamp(timeInMillis);
            return DateUtil.format(timestamp, "yyyy-MM-dd HH:mm:ss.SSS");
        }
    }

    static interface LoopStatistics
    extends Statistics {
        public List<String> getMethodNameList();

        public MethodStatistics getMinElapsedTimeMethod();

        public MethodStatistics getMaxElapsedTimeMethod();

        public double getMethodTotalElapsedTimeInMillis(String var1);

        public double getMethodMaxElapsedTimeInMillis(String var1);

        public double getMethodMinElapsedTimeInMillis(String var1);

        public double getMethodAverageElapsedTimeInMillis(String var1);

        public double getTotalElapsedTimeInMillis();

        public int getMethodSize(String var1);

        public List<MethodStatistics> getMethodStatisticsList(String var1);

        public List<MethodStatistics> getFailedMethodStatisticsList(String var1);

        public List<MethodStatistics> getAllFailedMethodStatisticsList();
    }

    static interface Statistics {
        public Object getResult();

        public void setResult(Object var1);

        public long getStartTimeInMillis();

        public void setStartTimeInMillis(long var1);

        public long getEndTimeInMillis();

        public void setEndTimeInMillis(long var1);

        public long getStartTimeInNano();

        public void setStartTimeInNano(long var1);

        public long getEndTimeInNano();

        public void setEndTimeInNano(long var1);

        public double getElapsedTimeInMillis();
    }
}

