/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Immutable;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.u;
import java.io.Serializable;
import java.util.Collection;

@com.landawn.abacus.annotation.Immutable
public final class Range<T extends Comparable<? super T>>
implements Serializable,
Immutable {
    private static final long serialVersionUID = 545606166758706779L;
    private final LowerEndpoint<T> lowerEndpoint;
    private final UpperEndpoint<T> upperEndpoint;
    private final BoundType boundType;

    private Range(LowerEndpoint<T> lowerEndpoint, UpperEndpoint<T> upperEndpoint, BoundType boundType) {
        this.lowerEndpoint = lowerEndpoint;
        this.upperEndpoint = upperEndpoint;
        this.boundType = boundType;
    }

    public static <T extends Comparable<? super T>> Range<T> just(T element) {
        return Range.closed(element, element);
    }

    public static <T extends Comparable<? super T>> Range<T> open(T min, T max) {
        if (min == null || max == null || min.compareTo(max) > 0) {
            throw new IllegalArgumentException("'fromInclusive' and 'toInclusive' can't be null, or min > max");
        }
        return new Range<T>(new LowerEndpoint<T>(min, false), new UpperEndpoint<T>(max, false), BoundType.OPEN_OPEN);
    }

    public static <T extends Comparable<? super T>> Range<T> openClosed(T min, T max) {
        if (min == null || max == null || min.compareTo(max) > 0) {
            throw new IllegalArgumentException("'fromInclusive' and 'toInclusive' can't be null, or min > max");
        }
        return new Range<T>(new LowerEndpoint<T>(min, false), new UpperEndpoint<T>(max, true), BoundType.OPEN_CLOSED);
    }

    public static <T extends Comparable<? super T>> Range<T> closedOpen(T min, T max) {
        if (min == null || max == null || min.compareTo(max) > 0) {
            throw new IllegalArgumentException("'fromInclusive' and 'toInclusive' can't be null, or min > max");
        }
        return new Range<T>(new LowerEndpoint<T>(min, true), new UpperEndpoint<T>(max, false), BoundType.CLOSED_OPEN);
    }

    public static <T extends Comparable<? super T>> Range<T> closed(T min, T max) {
        if (min == null || max == null || min.compareTo(max) > 0) {
            throw new IllegalArgumentException("'fromInclusive' and 'toInclusive' can't be null, or min > max");
        }
        return new Range<T>(new LowerEndpoint<T>(min, true), new UpperEndpoint<T>(max, true), BoundType.CLOSED_CLOSED);
    }

    public BoundType boundType() {
        return this.boundType;
    }

    public T lowerEndpoint() {
        return (T)this.lowerEndpoint.value;
    }

    public T upperEndpoint() {
        return (T)this.upperEndpoint.value;
    }

    public boolean contains(T element) {
        if (element == null) {
            return false;
        }
        return this.lowerEndpoint.includes(element) && this.upperEndpoint.includes(element);
    }

    public boolean containsAll(Collection<? extends T> c) {
        if (N.isNullOrEmpty(c)) {
            return true;
        }
        for (Comparable e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean isStartedBy(T element) {
        if (element == null) {
            return false;
        }
        return this.lowerEndpoint.isClosed && this.lowerEndpoint.compareTo(element) == 0;
    }

    public boolean isEndedBy(T element) {
        if (element == null) {
            return false;
        }
        return this.upperEndpoint.isClosed && this.upperEndpoint.compareTo(element) == 0;
    }

    public boolean isAfter(T element) {
        if (element == null) {
            return false;
        }
        return !this.lowerEndpoint.includes(element);
    }

    public boolean isBefore(T element) {
        if (element == null) {
            return false;
        }
        return !this.upperEndpoint.includes(element);
    }

    public int compareTo(T element) {
        if (element == null) {
            throw new NullPointerException("Element is null");
        }
        if (this.isBefore(element)) {
            return -1;
        }
        if (this.isAfter(element)) {
            return 1;
        }
        return 0;
    }

    public boolean containsRange(Range<T> other) {
        if (other == null) {
            return false;
        }
        return (other.lowerEndpoint.isClosed ? this.contains(other.lowerEndpoint.value) : this.lowerEndpoint.value.compareTo(other.lowerEndpoint.value) <= 0) && (other.upperEndpoint.isClosed ? this.contains(other.upperEndpoint.value) : this.upperEndpoint.value.compareTo(other.upperEndpoint.value) >= 0);
    }

    public boolean isAfterRange(Range<T> other) {
        if (other == null) {
            return false;
        }
        return other.upperEndpoint.isClosed ? this.isAfter(other.upperEndpoint.value) : this.lowerEndpoint.compareTo(other.upperEndpoint.value) >= 0;
    }

    public boolean isBeforeRange(Range<T> other) {
        if (other == null) {
            return false;
        }
        return other.lowerEndpoint.isClosed ? this.isBefore(other.lowerEndpoint.value) : this.upperEndpoint.compareTo(other.lowerEndpoint.value) <= 0;
    }

    public boolean isOverlappedBy(Range<T> other) {
        if (other == null) {
            return false;
        }
        return !this.isAfterRange(other) && !this.isBeforeRange(other);
    }

    public u.Optional<Range<T>> intersection(Range<T> other) {
        if (!this.isOverlappedBy(other)) {
            return u.Optional.empty();
        }
        if (this.equals(other)) {
            return u.Optional.of(this);
        }
        LowerEndpoint<T> newLowerEndpoint = this.lowerEndpoint.includes(other.lowerEndpoint.value) ? other.lowerEndpoint : this.lowerEndpoint;
        UpperEndpoint<T> newUpperEndpoint = this.upperEndpoint.includes(other.upperEndpoint.value) ? other.upperEndpoint : this.upperEndpoint;
        BoundType boundType = null;
        boundType = newLowerEndpoint.isClosed ? (newUpperEndpoint.isClosed ? BoundType.CLOSED_CLOSED : BoundType.CLOSED_OPEN) : (newUpperEndpoint.isClosed ? BoundType.OPEN_CLOSED : BoundType.OPEN_OPEN);
        return u.Optional.of(new Range<T>(newLowerEndpoint, newUpperEndpoint, boundType));
    }

    public Range<T> span(Range<T> other) {
        LowerEndpoint<T> newLowerEndpoint = this.lowerEndpoint.includes(other.lowerEndpoint.value) ? this.lowerEndpoint : other.lowerEndpoint;
        UpperEndpoint<T> newUpperEndpoint = this.upperEndpoint.includes(other.upperEndpoint.value) ? this.upperEndpoint : other.upperEndpoint;
        BoundType boundType = null;
        boundType = newLowerEndpoint.isClosed ? (newUpperEndpoint.isClosed ? BoundType.CLOSED_CLOSED : BoundType.CLOSED_OPEN) : (newUpperEndpoint.isClosed ? BoundType.OPEN_CLOSED : BoundType.OPEN_OPEN);
        return new Range<T>(newLowerEndpoint, newUpperEndpoint, boundType);
    }

    public boolean isEmpty() {
        return !this.lowerEndpoint.isClosed && !this.upperEndpoint.isClosed && this.lowerEndpoint.compareTo(this.upperEndpoint.value) == 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Range) {
            Range other = (Range)obj;
            return N.equals(this.lowerEndpoint, other.lowerEndpoint) && N.equals(this.upperEndpoint, other.upperEndpoint);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + this.lowerEndpoint.hashCode();
        result = 37 * result + this.upperEndpoint.hashCode();
        return result;
    }

    public String toString() {
        return this.lowerEndpoint.toString() + ", " + this.upperEndpoint.toString();
    }

    static class UpperEndpoint<T extends Comparable<? super T>>
    extends Endpoint<T> {
        private static final long serialVersionUID = 3180376045860768477L;

        UpperEndpoint(T value, boolean isClosed) {
            super(value, isClosed);
        }

        @Override
        public boolean includes(T value) {
            return this.isClosed ? N.compare(value, this.value) <= 0 : N.compare(value, this.value) < 0;
        }

        public int hashCode() {
            int result = this.isClosed ? 0 : 1;
            result = 37 * result + N.hashCode(this.value);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UpperEndpoint) {
                UpperEndpoint other = (UpperEndpoint)obj;
                return N.equals(this.isClosed, other.isClosed) && N.equals(this.value, other.value);
            }
            return false;
        }

        public String toString() {
            return N.toString(this.value) + (this.isClosed ? "]" : ")");
        }
    }

    static class LowerEndpoint<T extends Comparable<? super T>>
    extends Endpoint<T> {
        private static final long serialVersionUID = -1369183906861608859L;

        LowerEndpoint(T value, boolean isClosed) {
            super(value, isClosed);
        }

        @Override
        public boolean includes(T value) {
            return this.isClosed ? N.compare(value, this.value) >= 0 : N.compare(value, this.value) > 0;
        }

        public int hashCode() {
            int result = this.isClosed ? 0 : 1;
            result = 37 * result + N.hashCode(this.value);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LowerEndpoint) {
                LowerEndpoint other = (LowerEndpoint)obj;
                return N.equals(this.isClosed, other.isClosed) && N.equals(this.value, other.value);
            }
            return false;
        }

        public String toString() {
            return (this.isClosed ? "[" : "(") + N.toString(this.value);
        }
    }

    static abstract class Endpoint<T extends Comparable<? super T>>
    implements Serializable {
        private static final long serialVersionUID = -1404748904424344410L;
        final T value;
        final boolean isClosed;

        protected Endpoint(T value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        public int compareTo(T value) {
            return N.compare(this.value, value);
        }

        public abstract boolean includes(T var1);
    }

    public static enum BoundType {
        OPEN_OPEN,
        OPEN_CLOSED,
        CLOSED_OPEN,
        CLOSED_CLOSED;

    }
}

