/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.util.Fn;
import com.landawn.abacus.util.Immutable;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Pair;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.function.Function;
import com.landawn.abacus.util.function.Supplier;

@com.landawn.abacus.annotation.Immutable
public final class Result<T, E extends Throwable>
implements Immutable {
    private final T value;
    private final E exception;

    Result(T value, E exception) {
        this.value = value;
        this.exception = exception;
    }

    public static <T, E extends Throwable> Result<T, E> of(T value, E exception) {
        return new Result<T, E>(value, exception);
    }

    public boolean isFailure() {
        return this.exception != null;
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public <E2 extends Throwable> void ifFailure(Throwables.Consumer<? super E, E2> actionOnFailure) throws E2 {
        this.ifFailureOrElse(actionOnFailure, Fn.doNothing());
    }

    public <E2 extends Throwable, E3 extends Throwable> void ifFailureOrElse(Throwables.Consumer<? super E, E2> actionOnFailure, Throwables.Consumer<? super T, E3> actionOnSuccess) throws E2, E3 {
        N.checkArgNotNull(actionOnFailure, "actionOnFailure");
        N.checkArgNotNull(actionOnSuccess, "actionOnSuccess");
        if (this.exception != null) {
            actionOnFailure.accept(this.exception);
        } else {
            actionOnSuccess.accept(this.value);
        }
    }

    public <E2 extends Throwable> void ifSuccess(Throwables.Consumer<? super T, E2> actionOnSuccess) throws E2 {
        this.ifSuccessOrElse(actionOnSuccess, Fn.doNothing());
    }

    public <E2 extends Throwable, E3 extends Throwable> void ifSuccessOrElse(Throwables.Consumer<? super T, E2> actionOnSuccess, Throwables.Consumer<? super E, E3> actionOnFailure) throws E2, E3 {
        N.checkArgNotNull(actionOnSuccess, "actionOnSuccess");
        N.checkArgNotNull(actionOnFailure, "actionOnFailure");
        if (this.exception == null) {
            actionOnSuccess.accept(this.value);
        } else {
            actionOnFailure.accept(this.exception);
        }
    }

    @Deprecated
    public T orElse(T defaultValueIfErrorOccurred) {
        return this.orElseIfFailure(defaultValueIfErrorOccurred);
    }

    @Deprecated
    public <E2 extends Throwable> T orElseGet(Throwables.Supplier<? extends T, E2> otherIfErrorOccurred) throws E2 {
        return this.orElseGetIfFailure(otherIfErrorOccurred);
    }

    public T orElseIfFailure(T defaultValueIfErrorOccurred) {
        if (this.exception == null) {
            return this.value;
        }
        return defaultValueIfErrorOccurred;
    }

    public <E2 extends Throwable> T orElseGetIfFailure(Throwables.Supplier<? extends T, E2> otherIfErrorOccurred) throws E2 {
        N.checkArgNotNull(otherIfErrorOccurred, "otherIfErrorOccurred");
        if (this.exception == null) {
            return this.value;
        }
        return otherIfErrorOccurred.get();
    }

    public T orElseThrow() throws E {
        if (this.exception == null) {
            return this.value;
        }
        throw this.exception;
    }

    public <E2 extends Throwable> T orElseThrow(Function<? super E, E2> exceptionSupplierIfErrorOccurred) throws E2 {
        N.checkArgNotNull(exceptionSupplierIfErrorOccurred, "exceptionSupplierIfErrorOccurred");
        if (this.exception == null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplierIfErrorOccurred.apply(this.exception);
    }

    public <E2 extends Throwable> T orElseThrow(E2 exception) throws E2 {
        if (exception == null) {
            return this.value;
        }
        throw exception;
    }

    public <E2 extends Throwable> T orElseThrow(Supplier<? extends E2> exceptionSupplier) throws E2 {
        if (this.exception == null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public E getExceptionIfPresent() {
        return this.exception;
    }

    public Pair<T, E> toPair() {
        return Pair.of(this.value, this.exception);
    }

    public Tuple.Tuple2<T, E> toTuple() {
        return Tuple.of(this.value, this.exception);
    }

    public int hashCode() {
        return this.exception == null ? N.hashCode(this.value) : this.exception.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Result) {
            Result other = (Result)obj;
            return N.equals(other.value, this.value) && N.equals(other.exception, this.exception);
        }
        return false;
    }

    public String toString() {
        return "{value=" + N.toString(this.value) + ", exception=" + N.toString(this.exception) + "}";
    }
}

