/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.function.BiPredicate;
import com.landawn.abacus.util.function.Predicate;
import java.util.Iterator;
import java.util.concurrent.Callable;

public final class Retry<T> {
    private static final Logger logger = LoggerFactory.getLogger(Retry.class);
    private final int retryTimes;
    private final long retryInterval;
    private final Predicate<? super Exception> retryCondition;
    private final BiPredicate<? super T, ? super Exception> retryCondition2;

    Retry(int retryTimes, long retryInterval, Predicate<? super Exception> retryCondition, BiPredicate<? super T, ? super Exception> retryCondition2) {
        this.retryTimes = retryTimes;
        this.retryInterval = retryInterval;
        this.retryCondition = retryCondition;
        this.retryCondition2 = retryCondition2;
    }

    public static Retry<Void> of(int retryTimes, long retryInterval, Predicate<? super Exception> retryCondition) {
        N.checkArgNotNegative(retryTimes, "retryTimes");
        N.checkArgNotNegative(retryInterval, "retryInterval");
        N.checkArgNotNull(retryCondition);
        return new Retry<Void>(retryTimes, retryInterval, retryCondition, null);
    }

    public static <R> Retry<R> of(int retryTimes, long retryInterval, BiPredicate<? super R, ? super Exception> retryCondition) {
        N.checkArgNotNegative(retryTimes, "retryTimes");
        N.checkArgNotNegative(retryInterval, "retryInterval");
        N.checkArgNotNull(retryCondition);
        return new Retry<R>(retryTimes, retryInterval, null, retryCondition);
    }

    public void run(Throwables.Runnable<? extends Exception> cmd) throws Exception {
        if (this.retryTimes > 0) {
            try {
                cmd.run();
            }
            catch (Exception e) {
                logger.error("Failed to run", (Throwable)e);
                Exception ex = e;
                for (int retriedTimes = 0; retriedTimes < this.retryTimes && (this.retryCondition != null && this.retryCondition.test(ex) || this.retryCondition2 != null && this.retryCondition2.test(null, ex)); ++retriedTimes) {
                    try {
                        if (this.retryInterval > 0L) {
                            N.sleepUninterruptibly(this.retryInterval);
                        }
                        logger.info("Start " + retriedTimes + " retry");
                        cmd.run();
                        return;
                    }
                    catch (Exception e2) {
                        logger.error("Retried: " + retriedTimes, (Throwable)e2);
                        ex = e2;
                        continue;
                    }
                }
                throw ex;
            }
        } else {
            cmd.run();
        }
    }

    public T call(Callable<T> callable) throws Exception {
        if (this.retryTimes > 0) {
            Object result = null;
            int retriedTimes = 0;
            try {
                result = callable.call();
                while (retriedTimes < this.retryTimes && this.retryCondition2 != null && this.retryCondition2.test(result, null)) {
                    ++retriedTimes;
                    if (this.retryInterval > 0L) {
                        N.sleepUninterruptibly(this.retryInterval);
                    }
                    logger.info("Start " + retriedTimes + " retry");
                    result = callable.call();
                    if (this.retryCondition2 != null && this.retryCondition2.test(result, null)) continue;
                    return result;
                }
            }
            catch (Exception e) {
                logger.error("Failed to call", (Throwable)e);
                Exception ex = e;
                while (retriedTimes < this.retryTimes && (this.retryCondition != null && this.retryCondition.test(ex) || this.retryCondition2 != null && this.retryCondition2.test(null, ex))) {
                    ++retriedTimes;
                    try {
                        if (this.retryInterval > 0L) {
                            N.sleepUninterruptibly(this.retryInterval);
                        }
                        logger.info("Start " + retriedTimes + " retry");
                        result = callable.call();
                        if (this.retryCondition2 != null && this.retryCondition2.test(result, null)) continue;
                        return result;
                    }
                    catch (Exception e2) {
                        logger.error("Retried: " + retriedTimes, (Throwable)e2);
                        ex = e2;
                    }
                }
                throw ex;
            }
            if (this.retryTimes > 0 && this.retryCondition2 != null && this.retryCondition2.test(result, null)) {
                throw new RuntimeException("Still failed after retried " + this.retryTimes + " times for result: " + N.toString(result));
            }
            return result;
        }
        return callable.call();
    }

    public static final class RetryR<T> {
        private static final Logger logger = LoggerFactory.getLogger(RetryR.class);
        private final int retryTimes;
        private final long retryInterval;
        private final Predicate<? super RuntimeException> retryCondition;
        private final BiPredicate<? super T, ? super RuntimeException> retryCondition2;

        RetryR(int retryTimes, long retryInterval, Predicate<? super RuntimeException> retryCondition, BiPredicate<? super T, ? super RuntimeException> retryCondition2) {
            this.retryTimes = retryTimes;
            this.retryInterval = retryInterval;
            this.retryCondition = retryCondition;
            this.retryCondition2 = retryCondition2;
        }

        public static RetryR<Void> of(int retryTimes, long retryInterval, Predicate<? super RuntimeException> retryCondition) {
            N.checkArgNotNegative(retryTimes, "retryTimes");
            N.checkArgNotNegative(retryInterval, "retryInterval");
            N.checkArgNotNull(retryCondition);
            return new RetryR<Void>(retryTimes, retryInterval, retryCondition, null);
        }

        public static <R> RetryR<R> of(int retryTimes, long retryInterval, BiPredicate<? super R, ? super RuntimeException> retryCondition) {
            N.checkArgNotNegative(retryTimes, "retryTimes");
            N.checkArgNotNegative(retryInterval, "retryInterval");
            N.checkArgNotNull(retryCondition);
            return new RetryR<R>(retryTimes, retryInterval, null, retryCondition);
        }

        public void run(Runnable cmd) {
            if (this.retryTimes > 0) {
                try {
                    cmd.run();
                }
                catch (RuntimeException e) {
                    logger.error("Failed to run", (Throwable)e);
                    RuntimeException ex = e;
                    for (int retriedTimes = 0; retriedTimes < this.retryTimes && (this.retryCondition != null && this.retryCondition.test(ex) || this.retryCondition2 != null && this.retryCondition2.test(null, ex)); ++retriedTimes) {
                        try {
                            if (this.retryInterval > 0L) {
                                N.sleepUninterruptibly(this.retryInterval);
                            }
                            logger.info("Start " + retriedTimes + " retry");
                            cmd.run();
                            return;
                        }
                        catch (RuntimeException e2) {
                            logger.error("Retried: " + retriedTimes, (Throwable)e2);
                            ex = e2;
                            continue;
                        }
                    }
                    throw ex;
                }
            } else {
                cmd.run();
            }
        }

        public T call(Throwables.Callable<T, RuntimeException> callable) {
            if (this.retryTimes > 0) {
                Object result = null;
                int retriedTimes = 0;
                try {
                    result = callable.call();
                    while (retriedTimes < this.retryTimes && this.retryCondition2 != null && this.retryCondition2.test(result, null)) {
                        ++retriedTimes;
                        if (this.retryInterval > 0L) {
                            N.sleepUninterruptibly(this.retryInterval);
                        }
                        logger.info("Start " + retriedTimes + " retry");
                        result = callable.call();
                        if (this.retryCondition2 != null && this.retryCondition2.test(result, null)) continue;
                        return result;
                    }
                }
                catch (RuntimeException e) {
                    logger.error("Failed to call", (Throwable)e);
                    RuntimeException ex = e;
                    while (retriedTimes < this.retryTimes && (this.retryCondition != null && this.retryCondition.test(ex) || this.retryCondition2 != null && this.retryCondition2.test(null, ex))) {
                        ++retriedTimes;
                        try {
                            if (this.retryInterval > 0L) {
                                N.sleepUninterruptibly(this.retryInterval);
                            }
                            logger.info("Start " + retriedTimes + " retry");
                            result = callable.call();
                            if (this.retryCondition2 != null && this.retryCondition2.test(result, null)) continue;
                            return result;
                        }
                        catch (RuntimeException e2) {
                            logger.error("Retried: " + retriedTimes, (Throwable)e2);
                            ex = e2;
                        }
                    }
                    throw ex;
                }
                if (this.retryTimes > 0 && this.retryCondition2 != null && this.retryCondition2.test(result, null)) {
                    throw new RuntimeException("Still failed after retried " + this.retryTimes + " times for result: " + N.toString(result));
                }
                return result;
            }
            return callable.call();
        }

        @Deprecated
        public <E> Iterator<E> iterate(Iterator<E> iter) {
            return this.iterate(iter, Integer.MAX_VALUE);
        }

        public <E> Iterator<E> iterate(final Iterator<E> iter, final int totalRetryTimes) {
            N.checkArgPositive(totalRetryTimes, "totalRetryTimes");
            return new Iterator<E>(){
                private int totalRetriedTimes = 0;

                @Override
                public boolean hasNext() {
                    try {
                        return iter.hasNext();
                    }
                    catch (RuntimeException e) {
                        logger.error("Failed to hasNext()", (Throwable)e);
                        RuntimeException ex = e;
                        for (int retriedTimes = 0; this.totalRetriedTimes < totalRetryTimes && retriedTimes < RetryR.this.retryTimes && (RetryR.this.retryCondition != null && RetryR.this.retryCondition.test(ex) || RetryR.this.retryCondition2 != null && RetryR.this.retryCondition2.test(null, ex)); ++retriedTimes) {
                            ++this.totalRetriedTimes;
                            try {
                                if (RetryR.this.retryInterval > 0L) {
                                    N.sleepUninterruptibly(RetryR.this.retryInterval);
                                }
                                logger.info("Start " + retriedTimes + " retry in hasNext()");
                                return iter.hasNext();
                            }
                            catch (RuntimeException e2) {
                                logger.error("Retried: " + retriedTimes + " in hasNext()", (Throwable)e2);
                                ex = e2;
                                continue;
                            }
                        }
                        throw ex;
                    }
                }

                @Override
                public E next() {
                    try {
                        return iter.next();
                    }
                    catch (RuntimeException e) {
                        logger.error("Failed to next()", (Throwable)e);
                        RuntimeException ex = e;
                        for (int retriedTimes = 0; this.totalRetriedTimes < totalRetryTimes && retriedTimes < RetryR.this.retryTimes && (RetryR.this.retryCondition != null && RetryR.this.retryCondition.test(ex) || RetryR.this.retryCondition2 != null && RetryR.this.retryCondition2.test(null, ex)); ++retriedTimes) {
                            ++this.totalRetriedTimes;
                            try {
                                if (RetryR.this.retryInterval > 0L) {
                                    N.sleepUninterruptibly(RetryR.this.retryInterval);
                                }
                                logger.info("Start " + retriedTimes + " retry in next()");
                                return iter.next();
                            }
                            catch (RuntimeException e2) {
                                logger.error("Retried: " + retriedTimes + " in next()", (Throwable)e2);
                                ex = e2;
                                continue;
                            }
                        }
                        throw ex;
                    }
                }

                @Override
                public void remove() {
                    try {
                        iter.remove();
                    }
                    catch (RuntimeException e) {
                        logger.error("Failed to remove()", (Throwable)e);
                        int retriedTimes = 0;
                        RuntimeException ex = e;
                        while (this.totalRetriedTimes < totalRetryTimes && retriedTimes < RetryR.this.retryTimes && (RetryR.this.retryCondition != null && RetryR.this.retryCondition.test(ex) || RetryR.this.retryCondition2 != null && RetryR.this.retryCondition2.test(null, ex))) {
                            ++this.totalRetriedTimes;
                            ++retriedTimes;
                            try {
                                if (RetryR.this.retryInterval > 0L) {
                                    N.sleepUninterruptibly(RetryR.this.retryInterval);
                                }
                                logger.info("Start " + retriedTimes + " retry in remove()");
                                iter.remove();
                            }
                            catch (RuntimeException e2) {
                                logger.error("Retried: " + retriedTimes + " in remove()", (Throwable)e2);
                                ex = e2;
                            }
                        }
                        throw ex;
                    }
                }
            };
        }
    }
}

