/*
 * Decompiled with CFR 0.152.
 */
package com.landawn.abacus.util;

import com.landawn.abacus.DirtyMarker;
import com.landawn.abacus.annotation.Beta;
import com.landawn.abacus.annotation.Internal;
import com.landawn.abacus.annotation.NonUpdatable;
import com.landawn.abacus.annotation.NotColumn;
import com.landawn.abacus.annotation.ReadOnly;
import com.landawn.abacus.annotation.ReadOnlyId;
import com.landawn.abacus.condition.Between;
import com.landawn.abacus.condition.Binary;
import com.landawn.abacus.condition.Cell;
import com.landawn.abacus.condition.Clause;
import com.landawn.abacus.condition.Condition;
import com.landawn.abacus.condition.ConditionFactory;
import com.landawn.abacus.condition.Criteria;
import com.landawn.abacus.condition.Expression;
import com.landawn.abacus.condition.Having;
import com.landawn.abacus.condition.In;
import com.landawn.abacus.condition.InSubQuery;
import com.landawn.abacus.condition.Join;
import com.landawn.abacus.condition.Junction;
import com.landawn.abacus.condition.Limit;
import com.landawn.abacus.condition.NotIn;
import com.landawn.abacus.condition.NotInSubQuery;
import com.landawn.abacus.condition.SubQuery;
import com.landawn.abacus.condition.Where;
import com.landawn.abacus.core.DirtyMarkerUtil;
import com.landawn.abacus.logging.Logger;
import com.landawn.abacus.logging.LoggerFactory;
import com.landawn.abacus.parser.ParserUtil;
import com.landawn.abacus.util.Array;
import com.landawn.abacus.util.ClassUtil;
import com.landawn.abacus.util.ImmutableList;
import com.landawn.abacus.util.ImmutableMap;
import com.landawn.abacus.util.ImmutableSet;
import com.landawn.abacus.util.Maps;
import com.landawn.abacus.util.N;
import com.landawn.abacus.util.NamingPolicy;
import com.landawn.abacus.util.ObjectPool;
import com.landawn.abacus.util.Objectory;
import com.landawn.abacus.util.OperationType;
import com.landawn.abacus.util.SQLParser;
import com.landawn.abacus.util.SortDirection;
import com.landawn.abacus.util.StringUtil;
import com.landawn.abacus.util.Throwables;
import com.landawn.abacus.util.Tuple;
import com.landawn.abacus.util.WD;
import com.landawn.abacus.util.u;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class SQLBuilder {
    private static final Logger logger;
    public static final String ALL = "ALL";
    public static final String TOP = "TOP";
    public static final String UNIQUE = "UNIQUE";
    public static final String DISTINCT = "DISTINCT";
    public static final String DISTINCTROW = "DISTINCTROW";
    public static final String ASTERISK = "*";
    public static final String COUNT_ALL = "count(*)";
    public static final String _1 = "1";
    public static final List<String> _1_list;
    static final char[] _INSERT;
    static final char[] _SPACE_INSERT_SPACE;
    static final char[] _INTO;
    static final char[] _SPACE_INTO_SPACE;
    static final char[] _VALUES;
    static final char[] _SPACE_VALUES_SPACE;
    static final char[] _SELECT;
    static final char[] _SPACE_SELECT_SPACE;
    static final char[] _FROM;
    static final char[] _SPACE_FROM_SPACE;
    static final char[] _UPDATE;
    static final char[] _SPACE_UPDATE_SPACE;
    static final char[] _SET;
    static final char[] _SPACE_SET_SPACE;
    static final char[] _DELETE;
    static final char[] _SPACE_DELETE_SPACE;
    static final char[] _JOIN;
    static final char[] _SPACE_JOIN_SPACE;
    static final char[] _LEFT_JOIN;
    static final char[] _SPACE_LEFT_JOIN_SPACE;
    static final char[] _RIGHT_JOIN;
    static final char[] _SPACE_RIGHT_JOIN_SPACE;
    static final char[] _FULL_JOIN;
    static final char[] _SPACE_FULL_JOIN_SPACE;
    static final char[] _CROSS_JOIN;
    static final char[] _SPACE_CROSS_JOIN_SPACE;
    static final char[] _INNER_JOIN;
    static final char[] _SPACE_INNER_JOIN_SPACE;
    static final char[] _NATURAL_JOIN;
    static final char[] _SPACE_NATURAL_JOIN_SPACE;
    static final char[] _ON;
    static final char[] _SPACE_ON_SPACE;
    static final char[] _USING;
    static final char[] _SPACE_USING_SPACE;
    static final char[] _WHERE;
    static final char[] _SPACE_WHERE_SPACE;
    static final char[] _GROUP_BY;
    static final char[] _SPACE_GROUP_BY_SPACE;
    static final char[] _HAVING;
    static final char[] _SPACE_HAVING_SPACE;
    static final char[] _ORDER_BY;
    static final char[] _SPACE_ORDER_BY_SPACE;
    static final char[] _LIMIT;
    static final char[] _SPACE_LIMIT_SPACE;
    static final char[] _OFFSET;
    static final char[] _SPACE_OFFSET_SPACE;
    static final char[] _AND;
    static final char[] _SPACE_AND_SPACE;
    static final char[] _OR;
    static final char[] _SPACE_OR_SPACE;
    static final char[] _UNION;
    static final char[] _SPACE_UNION_SPACE;
    static final char[] _UNION_ALL;
    static final char[] _SPACE_UNION_ALL_SPACE;
    static final char[] _INTERSECT;
    static final char[] _SPACE_INTERSECT_SPACE;
    static final char[] _EXCEPT;
    static final char[] _SPACE_EXCEPT_SPACE;
    static final char[] _EXCEPT2;
    static final char[] _SPACE_EXCEPT2_SPACE;
    static final char[] _AS;
    static final char[] _SPACE_AS_SPACE;
    static final char[] _SPACE_EQUAL_SPACE;
    static final char[] _SPACE_FOR_UPDATE;
    static final char[] _COMMA_SPACE;
    static final String SPACE_AS_SPACE = " AS ";
    private static final Set<String> sqlKeyWords;
    private static final Map<Class<?>, ImmutableSet<String>> subEntityPropNamesPool;
    private static final Map<Class<?>, ImmutableSet<String>> nonSubEntityPropNamesPool;
    private static final Map<Class<?>, Set<String>[]> defaultPropNamesPool;
    private static final Map<NamingPolicy, Map<Class<?>, String>> fullSelectPartsPool;
    private static final Map<String, char[]> tableDeleteFrom;
    private static final Map<Class<?>, String[]> classTableNameMap;
    private static final AtomicInteger activeStringBuilderCounter;
    private final NamingPolicy namingPolicy;
    private final SQLPolicy sqlPolicy;
    private final List<Object> parameters = new ArrayList<Object>();
    private StringBuilder sb;
    private Class<?> entityClass;
    private ImmutableMap<String, Tuple.Tuple2<String, Boolean>> propColumnNameMap;
    private String alias;
    private OperationType op;
    private String tableName;
    private String preselect;
    private Collection<String> columnNames;
    private Map<String, String> columnAliases;
    private List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects;
    private Map<String, Map<String, Tuple.Tuple2<String, Boolean>>> aliasPropColumnNameMap;
    private Map<String, Object> props;
    private Collection<Map<String, Object>> propsList;
    private boolean hasFromBeenSet = false;
    private boolean isForConditionOnly = false;
    private static final Map<Integer, String> QM_CACHE;
    static final Map<Class<?>, Map<NamingPolicy, ImmutableMap<String, Tuple.Tuple2<String, Boolean>>>> entityTablePropColumnNameMap;

    SQLBuilder(NamingPolicy namingPolicy, SQLPolicy sqlPolicy) {
        if (activeStringBuilderCounter.incrementAndGet() > 1024) {
            logger.error("Too many(" + activeStringBuilderCounter.get() + ") StringBuilder instances are created in SQLBuilder. The method sql()/pair() must be called to release resources and close SQLBuilder");
        }
        this.sb = Objectory.createStringBuilder();
        this.namingPolicy = namingPolicy == null ? NamingPolicy.LOWER_CASE_WITH_UNDERSCORE : namingPolicy;
        this.sqlPolicy = sqlPolicy == null ? SQLPolicy.SQL : sqlPolicy;
    }

    static String getTableName(Class<?> entityClass, NamingPolicy namingPolicy) {
        String[] entityTableNames = classTableNameMap.get(entityClass);
        if (entityTableNames == null) {
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
            if (entityInfo.tableName.isPresent()) {
                entityTableNames = Array.repeat(entityInfo.tableName.get(), 4);
            } else {
                String simpleClassName = ClassUtil.getSimpleClassName(entityClass);
                entityTableNames = new String[]{ClassUtil.toLowerCaseWithUnderscore(simpleClassName), ClassUtil.toUpperCaseWithUnderscore(simpleClassName), ClassUtil.toCamelCase(simpleClassName), simpleClassName};
            }
            classTableNameMap.put(entityClass, entityTableNames);
        }
        switch (namingPolicy) {
            case LOWER_CASE_WITH_UNDERSCORE: {
                return entityTableNames[0];
            }
            case UPPER_CASE_WITH_UNDERSCORE: {
                return entityTableNames[1];
            }
            case LOWER_CAMEL_CASE: {
                return entityTableNames[2];
            }
        }
        return entityTableNames[3];
    }

    @Internal
    public static Collection<String> getInsertPropNames(Object entity, Set<String> excludedPropNames) {
        Class<?> entityClass = entity.getClass();
        boolean isDirtyMarker = ClassUtil.isDirtyMarker(entityClass);
        if (isDirtyMarker) {
            Set<String> signedPropNames = ((DirtyMarker)entity).signedPropNames();
            if (N.isNullOrEmpty(excludedPropNames)) {
                return signedPropNames;
            }
            ArrayList<String> tmp = new ArrayList<String>(signedPropNames);
            tmp.removeAll(excludedPropNames);
            return tmp;
        }
        Set<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        if (N.isNullOrEmpty(excludedPropNames)) {
            List<String> idPropNames = ClassUtil.getIdFieldNames(entityClass);
            if (N.isNullOrEmpty(idPropNames)) {
                return val[2];
            }
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
            for (String idPropName : idPropNames) {
                if (SQLBuilder.isDefaultIdPropValue(entityInfo.getPropInfo(idPropName))) continue;
                return val[2];
            }
            return val[3];
        }
        ArrayList<String> tmp = new ArrayList<String>(val[2]);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    @Internal
    public static Collection<String> getInsertPropNames(Class<?> entityClass, Set<String> excludedPropNames) {
        Set<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Set<String> propNames = val[2];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(propNames);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    @Internal
    public static Collection<String> getSelectPropNames(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
        Set<String> propNames;
        Set<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Set<String> set = propNames = includeSubEntityProperties ? val[0] : val[1];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(N.max(0, propNames.size() - excludedPropNames.size()));
        int idx = 0;
        for (String propName : propNames) {
            if (excludedPropNames.contains(propName) || (idx = propName.indexOf(46)) > 0 && excludedPropNames.contains(propName.substring(0, idx))) continue;
            tmp.add(propName);
        }
        return tmp;
    }

    @Internal
    static boolean isDefaultIdPropValue(Object propValue) {
        return propValue == null || propValue instanceof Number && ((Number)propValue).longValue() == 0L;
    }

    @Internal
    public static Collection<String> getUpdatePropNames(Class<?> entityClass, Set<String> excludedPropNames) {
        Set<String>[] val = SQLBuilder.loadPropNamesByClass(entityClass);
        Set<String> propNames = val[4];
        if (N.isNullOrEmpty(excludedPropNames)) {
            return propNames;
        }
        ArrayList<String> tmp = new ArrayList<String>(propNames);
        tmp.removeAll(excludedPropNames);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<String>[] loadPropNamesByClass(Class<?> entityClass) {
        Set<String>[] val = defaultPropNamesPool.get(entityClass);
        if (val == null) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                Set<String> entityPropNames = N.newLinkedHashSet(ClassUtil.getPropNameList(entityClass));
                ImmutableSet<String> subEntityPropNames = SQLBuilder.getSubEntityPropNames(entityClass);
                if (N.notNullOrEmpty(subEntityPropNames)) {
                    entityPropNames.removeAll(subEntityPropNames);
                }
                val = new Set[]{N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames), N.newLinkedHashSet(entityPropNames)};
                ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
                Class<Object> subEntityClass = null;
                Set<String> subEntityPropNameList = null;
                for (String subEntityPropName : subEntityPropNames) {
                    ParserUtil.PropInfo propInfo = entityInfo.getPropInfo(subEntityPropName);
                    subEntityClass = (propInfo.type.isCollection() ? propInfo.type.getElementType() : propInfo.type).clazz();
                    subEntityPropNameList = N.newLinkedHashSet(ClassUtil.getPropNameList(subEntityClass));
                    subEntityPropNameList.removeAll(SQLBuilder.getSubEntityPropNames(subEntityClass));
                    for (String pn : subEntityPropNameList) {
                        val[0].add(StringUtil.concat(subEntityPropName, ".", pn));
                    }
                }
                Set nonUpdatableNonWritablePropNames = N.newHashSet();
                Set nonUpdatablePropNames = N.newHashSet();
                Set transientPropNames = N.newHashSet();
                for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
                    if (propInfo.isAnnotationPresent(ReadOnly.class) || propInfo.isAnnotationPresent(ReadOnlyId.class)) {
                        nonUpdatableNonWritablePropNames.add(propInfo.name);
                    }
                    if (propInfo.isAnnotationPresent(NonUpdatable.class)) {
                        nonUpdatablePropNames.add(propInfo.name);
                    }
                    if (!propInfo.isTransient && !propInfo.isAnnotationPresent(NotColumn.class)) continue;
                    nonUpdatableNonWritablePropNames.add(propInfo.name);
                    transientPropNames.add(propInfo.name);
                }
                nonUpdatablePropNames.addAll(nonUpdatableNonWritablePropNames);
                val[0].removeAll(transientPropNames);
                val[1].removeAll(transientPropNames);
                val[2].removeAll(nonUpdatableNonWritablePropNames);
                val[3].removeAll(nonUpdatableNonWritablePropNames);
                val[4].removeAll(nonUpdatablePropNames);
                for (String idPropName : ClassUtil.getIdFieldNames(entityClass)) {
                    val[3].remove(idPropName);
                    val[3].remove(ClassUtil.getPropNameByMethod(ClassUtil.getPropGetMethod(entityClass, idPropName)));
                }
                val[0] = ImmutableSet.of(val[0]);
                val[1] = ImmutableSet.of(val[1]);
                val[2] = ImmutableSet.of(val[2]);
                val[3] = ImmutableSet.of(val[3]);
                val[4] = ImmutableSet.of(val[4]);
                defaultPropNamesPool.put(entityClass, val);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImmutableSet<String> getSubEntityPropNames(Class<?> entityClass) {
        Class<?> clazz = entityClass;
        synchronized (clazz) {
            ImmutableSet<String> subEntityPropNames = subEntityPropNamesPool.get(entityClass);
            if (subEntityPropNames == null) {
                ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
                ImmutableSet<String> nonSubEntityPropNames = nonSubEntityPropNamesPool.get(entityClass);
                Set subEntityPropNameSet = N.newLinkedHashSet();
                for (ParserUtil.PropInfo propInfo : entityInfo.propInfoList) {
                    if (propInfo.isMarkedToColumn || !propInfo.type.isEntity() && (!propInfo.type.isCollection() || !propInfo.type.getElementType().isEntity()) || nonSubEntityPropNames != null && nonSubEntityPropNames.contains(propInfo.name)) continue;
                    subEntityPropNameSet.add(propInfo.name);
                }
                subEntityPropNames = ImmutableSet.of(subEntityPropNameSet);
                subEntityPropNamesPool.put(entityClass, subEntityPropNames);
            }
            return subEntityPropNames;
        }
    }

    private static List<String> getSelectTableNames(Class<?> entityClass, String alias, Set<String> excludedPropNames, NamingPolicy namingPolicy) {
        ImmutableSet<String> subEntityPropNames = SQLBuilder.getSubEntityPropNames(entityClass);
        if (N.isNullOrEmpty(subEntityPropNames)) {
            return N.emptyList();
        }
        ArrayList<String> res = new ArrayList<String>(subEntityPropNames.size() + 1);
        if (N.isNullOrEmpty(alias)) {
            res.add(SQLBuilder.getTableName(entityClass, namingPolicy));
        } else {
            res.add(SQLBuilder.getTableName(entityClass, namingPolicy) + " " + alias);
        }
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
        ParserUtil.PropInfo propInfo = null;
        Class<Object> subEntityClass = null;
        for (String subEntityPropName : subEntityPropNames) {
            if (excludedPropNames != null && excludedPropNames.contains(subEntityPropName)) continue;
            propInfo = entityInfo.getPropInfo(subEntityPropName);
            subEntityClass = (propInfo.type.isCollection() ? propInfo.type.getElementType() : propInfo.type).clazz();
            res.add(SQLBuilder.getTableName(subEntityClass, namingPolicy));
        }
        return res;
    }

    @Beta
    static Map<String, Expression> named(String ... propNames) {
        Map<String, Expression> m = N.newLinkedHashMap(propNames.length);
        for (String propName : propNames) {
            m.put(propName, ConditionFactory.CF.QME);
        }
        return m;
    }

    @Beta
    static Map<String, Expression> named(Collection<String> propNames) {
        Map<String, Expression> m = N.newLinkedHashMap(propNames.size());
        for (String propName : propNames) {
            m.put(propName, ConditionFactory.CF.QME);
        }
        return m;
    }

    public static String repeatQM(int n) {
        N.checkArgNotNegative(n, "count");
        String result = QM_CACHE.get(n);
        if (result == null) {
            result = StringUtil.repeat("?", n, ", ");
        }
        return result;
    }

    @Deprecated
    @Beta
    public static ImmutableMap<String, Tuple.Tuple2<String, Boolean>> getProp2ColumnNameMap(Class<?> entityClass, NamingPolicy namingPolicy) {
        Map<NamingPolicy, ImmutableMap<String, Tuple.Tuple2<String, Boolean>>> namingPropColumnNameMap = entityTablePropColumnNameMap.get(entityClass);
        ImmutableMap<String, Tuple.Tuple2<String, Boolean>> result = null;
        if (namingPropColumnNameMap == null || (result = namingPropColumnNameMap.get((Object)namingPolicy)) == null) {
            ImmutableMap<String, String> prop2ColumnNameMap = ClassUtil.getProp2ColumnNameMap(entityClass, namingPolicy);
            Map<String, Tuple.Tuple2<String, Boolean>> newProp2ColumnNameMap = N.newHashMap(prop2ColumnNameMap.size() * 2);
            for (Map.Entry<String, String> entry : prop2ColumnNameMap.entrySet()) {
                newProp2ColumnNameMap.put(entry.getKey(), Tuple.of(entry.getValue(), entry.getKey().indexOf(46) < 0));
                if (prop2ColumnNameMap.containsKey(entry.getValue())) continue;
                newProp2ColumnNameMap.put(entry.getValue(), Tuple.of(entry.getValue(), entry.getValue().indexOf(46) < 0));
            }
            result = ImmutableMap.of(newProp2ColumnNameMap);
            if (namingPropColumnNameMap == null) {
                namingPropColumnNameMap = new EnumMap<NamingPolicy, ImmutableMap<String, Tuple.Tuple2<String, Boolean>>>(NamingPolicy.class);
                entityTablePropColumnNameMap.put(entityClass, namingPropColumnNameMap);
            }
            namingPropColumnNameMap.put(namingPolicy, result);
        }
        return result;
    }

    public SQLBuilder into(String tableName) {
        block24: {
            int i;
            block23: {
                if (this.op != OperationType.ADD) {
                    throw new RuntimeException("Invalid operation: " + (Object)((Object)this.op));
                }
                if (N.isNullOrEmpty(this.columnNames) && N.isNullOrEmpty(this.props) && N.isNullOrEmpty(this.propsList)) {
                    throw new RuntimeException("Column names or props must be set first by insert");
                }
                this.tableName = tableName;
                this.sb.append(_INSERT);
                this.sb.append(_SPACE_INTO_SPACE);
                this.sb.append(tableName);
                this.sb.append(' ');
                this.sb.append('(');
                if (N.notNullOrEmpty(this.columnNames)) {
                    i = 0;
                    for (String string : this.columnNames) {
                        if (i++ > 0) {
                            this.sb.append(_COMMA_SPACE);
                        }
                        this.appendColumnName(this.propColumnNameMap, string);
                    }
                } else {
                    Map<String, Object> props = N.isNullOrEmpty(this.props) ? this.propsList.iterator().next() : this.props;
                    int i2 = 0;
                    for (String columnName : props.keySet()) {
                        if (i2++ > 0) {
                            this.sb.append(_COMMA_SPACE);
                        }
                        this.appendColumnName(this.propColumnNameMap, columnName);
                    }
                }
                this.sb.append(')');
                this.sb.append(_SPACE_VALUES_SPACE);
                this.sb.append('(');
                if (!N.notNullOrEmpty(this.columnNames)) break block23;
                switch (this.sqlPolicy) {
                    case SQL: 
                    case PARAMETERIZED_SQL: {
                        int size = this.columnNames.size();
                        for (i = 0; i < size; ++i) {
                            if (i > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append('?');
                        }
                        break block24;
                    }
                    case NAMED_SQL: {
                        i = 0;
                        for (String string : this.columnNames) {
                            if (i++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append(":");
                            this.sb.append(string);
                        }
                        break block24;
                    }
                    case IBATIS_SQL: {
                        i = 0;
                        for (String string : this.columnNames) {
                            if (i++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append("#{");
                            this.sb.append(string);
                            this.sb.append('}');
                        }
                        break block24;
                    }
                    default: {
                        throw new RuntimeException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
                    }
                }
            }
            if (N.notNullOrEmpty(this.props)) {
                this.appendInsertProps(this.props);
            } else {
                i = 0;
                for (Map map : this.propsList) {
                    if (i++ > 0) {
                        this.sb.append(')');
                        this.sb.append(_COMMA_SPACE);
                        this.sb.append('(');
                    }
                    this.appendInsertProps(map);
                }
            }
        }
        this.sb.append(')');
        return this;
    }

    public SQLBuilder into(Class<?> entityClass) {
        if (this.entityClass == null) {
            this.entityClass = entityClass;
            this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        }
        return this.into(SQLBuilder.getTableName(entityClass, this.namingPolicy));
    }

    public SQLBuilder distinct() {
        return this.preselect(DISTINCT);
    }

    public SQLBuilder preselect(String preselect) {
        N.checkArgNotNull(preselect, "preselect");
        if (this.sb.length() > 0) {
            throw new IllegalStateException("'distinct|preselect' must be called before 'from' operation");
        }
        this.preselect = N.isNullOrEmpty(this.preselect) ? preselect : this.preselect + preselect;
        return this;
    }

    public SQLBuilder from(String expr) {
        int idx = (expr = expr.trim()).indexOf(44);
        String tableName = idx > 0 ? expr.substring(0, idx) : expr;
        return this.from(tableName.trim(), expr);
    }

    @SafeVarargs
    public final SQLBuilder from(String ... tableNames) {
        if (tableNames.length == 1) {
            return this.from(tableNames[0].trim());
        }
        String tableName = tableNames[0].trim();
        return this.from(tableName, StringUtil.join((Object[])tableNames, ", "));
    }

    public SQLBuilder from(Collection<String> tableNames) {
        if (tableNames.size() == 1) {
            return this.from(tableNames.iterator().next().trim());
        }
        String tableName = tableNames.iterator().next().trim();
        return this.from(tableName, StringUtil.join(tableNames, ", "));
    }

    public SQLBuilder from(Class<?> entityClass) {
        if (this.entityClass == null) {
            this.entityClass = entityClass;
            this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        }
        return this.from(SQLBuilder.getTableName(entityClass, this.namingPolicy));
    }

    public SQLBuilder from(Class<?> entityClass, String alias) {
        if (this.entityClass == null) {
            this.entityClass = entityClass;
            this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        }
        if (N.isNullOrEmpty(alias)) {
            return this.from(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        }
        return this.from(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
    }

    private SQLBuilder from(Class<?> entityClass, Collection<String> tableNames) {
        if (this.entityClass == null) {
            this.entityClass = entityClass;
            this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        }
        return this.from(tableNames);
    }

    private SQLBuilder from(String tableName, String fromCause) {
        boolean isForSelect;
        if (this.op != OperationType.QUERY) {
            throw new RuntimeException("Invalid operation: " + (Object)((Object)this.op));
        }
        this.hasFromBeenSet = true;
        if (N.isNullOrEmpty(this.columnNames) && N.isNullOrEmpty(this.columnAliases) && N.isNullOrEmpty(this.multiSelects)) {
            throw new RuntimeException("Column names or props must be set first by select");
        }
        int idx = tableName.indexOf(32);
        if (idx > 0) {
            this.tableName = tableName.substring(0, idx).trim();
            this.alias = tableName.substring(idx + 1).trim();
        } else {
            this.tableName = tableName.trim();
        }
        if (this.entityClass != null && N.notNullOrEmpty(this.alias)) {
            this.addPropColumnMapForAlias(this.entityClass, this.alias);
        }
        this.sb.append(_SELECT);
        this.sb.append(' ');
        if (N.notNullOrEmpty(this.preselect)) {
            this.sb.append(this.preselect);
            this.sb.append(' ');
        }
        boolean withAlias = N.notNullOrEmpty(this.alias);
        boolean bl = isForSelect = this.op == OperationType.QUERY;
        if (N.notNullOrEmpty(this.columnNames)) {
            if (this.entityClass != null && !withAlias && this.columnNames == SQLBuilder.getSelectPropNames(this.entityClass, false, null)) {
                String fullSelectParts = fullSelectPartsPool.get((Object)this.namingPolicy).get(this.entityClass);
                if (N.isNullOrEmpty(fullSelectParts)) {
                    fullSelectParts = "";
                    int i = 0;
                    for (String columnName : this.columnNames) {
                        if (i++ > 0) {
                            fullSelectParts = fullSelectParts + ", ";
                        }
                        fullSelectParts = fullSelectParts + this.formalizeColumnName(this.propColumnNameMap, columnName);
                        if (this.namingPolicy == NamingPolicy.LOWER_CAMEL_CASE || this.namingPolicy == NamingPolicy.NO_CHANGE || ASTERISK.equals(columnName)) continue;
                        fullSelectParts = fullSelectParts + SPACE_AS_SPACE;
                        fullSelectParts = fullSelectParts + "\"";
                        fullSelectParts = fullSelectParts + columnName;
                        fullSelectParts = fullSelectParts + "\"";
                    }
                    fullSelectPartsPool.get((Object)this.namingPolicy).put(this.entityClass, fullSelectParts);
                }
                this.sb.append(fullSelectParts);
            } else {
                ImmutableSet<String> subEntityPropNames;
                if (this.entityClass != null && N.notNullOrEmpty(subEntityPropNames = SQLBuilder.getSubEntityPropNames(this.entityClass)) && N.containsAny(subEntityPropNames, this.columnNames)) {
                    ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(this.entityClass);
                    ArrayList<String> tmp = new ArrayList<String>(this.columnNames.size() + 16);
                    ParserUtil.PropInfo propInfo = null;
                    for (String propName : this.columnNames) {
                        if (subEntityPropNames.contains(propName)) {
                            propInfo = entityInfo.getPropInfo(propName);
                            Collection<String> subSelectPropNames = SQLBuilder.getSelectPropNames(propInfo.type.isCollection() ? propInfo.type.getElementType().clazz() : propInfo.clazz, false, null);
                            for (String subPropName : subSelectPropNames) {
                                tmp.add(propName + "." + subPropName);
                            }
                            continue;
                        }
                        tmp.add(propName);
                    }
                    this.columnNames = tmp;
                }
                int i = 0;
                for (String columnName : this.columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, columnName, null, false, null, isForSelect);
                }
            }
        } else if (N.notNullOrEmpty(this.columnAliases)) {
            int i = 0;
            for (Map.Entry<String, String> entry : this.columnAliases.entrySet()) {
                if (i++ > 0) {
                    this.sb.append(_COMMA_SPACE);
                }
                this.appendColumnName(this.propColumnNameMap, entry.getKey(), entry.getValue(), false, null, isForSelect);
            }
        } else if (N.notNullOrEmpty(this.multiSelects)) {
            this.aliasPropColumnNameMap = N.newHashMap(this.multiSelects.size());
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : this.multiSelects) {
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                this.aliasPropColumnNameMap.put((String)tp._2, (Map<String, Tuple.Tuple2<String, Boolean>>)SQLBuilder.getProp2ColumnNameMap((Class)tp._1, this.namingPolicy));
            }
            String tmp = this.alias;
            int i = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : this.multiSelects) {
                this.alias = (String)tp._2;
                String classAlias = (String)tp._3;
                boolean withClassAlias = N.notNullOrEmpty(classAlias);
                ImmutableMap<String, Tuple.Tuple2<String, Boolean>> eachPropColumnNameMap = SQLBuilder.getProp2ColumnNameMap((Class)tp._1, this.namingPolicy);
                for (String propName : SQLBuilder.getSelectPropNames((Class)tp._1, false, (Set)tp._4)) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(eachPropColumnNameMap, propName, null, withClassAlias, classAlias, isForSelect);
                }
            }
            this.alias = tmp;
        } else {
            throw new UnsupportedOperationException("No select part specified");
        }
        this.sb.append(_SPACE_FROM_SPACE);
        this.sb.append(fromCause);
        return this;
    }

    private void addPropColumnMapForAlias(Class<?> entityClass, String alias) {
        if (this.aliasPropColumnNameMap == null) {
            this.aliasPropColumnNameMap = new HashMap<String, Map<String, Tuple.Tuple2<String, Boolean>>>();
        }
        if (N.isNullOrEmpty(this.propColumnNameMap) && entityClass != null && ClassUtil.isEntity(entityClass)) {
            this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(entityClass, this.namingPolicy);
        }
        this.aliasPropColumnNameMap.put(alias, this.propColumnNameMap);
    }

    public SQLBuilder join(String expr) {
        this.sb.append(_SPACE_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder join(Class<?> entityClass) {
        this.sb.append(_SPACE_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder join(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder innerJoin(String expr) {
        this.sb.append(_SPACE_INNER_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder innerJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_INNER_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder innerJoin(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_INNER_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder leftJoin(String expr) {
        this.sb.append(_SPACE_LEFT_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder leftJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_LEFT_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder leftJoin(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_LEFT_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder rightJoin(String expr) {
        this.sb.append(_SPACE_RIGHT_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder rightJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_RIGHT_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder rightJoin(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_RIGHT_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder fullJoin(String expr) {
        this.sb.append(_SPACE_FULL_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder fullJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_FULL_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder fullJoin(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_FULL_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder crossJoin(String expr) {
        this.sb.append(_SPACE_CROSS_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder crossJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_CROSS_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder crossJoin(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_CROSS_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder naturalJoin(String expr) {
        this.sb.append(_SPACE_NATURAL_JOIN_SPACE);
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder naturalJoin(Class<?> entityClass) {
        this.sb.append(_SPACE_NATURAL_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy));
        return this;
    }

    public SQLBuilder naturalJoin(Class<?> entityClass, String alias) {
        this.addPropColumnMapForAlias(entityClass, alias);
        this.sb.append(_SPACE_NATURAL_JOIN_SPACE);
        this.sb.append(SQLBuilder.getTableName(entityClass, this.namingPolicy) + " " + alias);
        return this;
    }

    public SQLBuilder on(String expr) {
        this.sb.append(_SPACE_ON_SPACE);
        this.appendStringExpr(expr, false);
        return this;
    }

    public SQLBuilder on(Condition cond) {
        this.sb.append(_SPACE_ON_SPACE);
        this.appendCondition(cond);
        return this;
    }

    public SQLBuilder using(String expr) {
        this.sb.append(_SPACE_USING_SPACE);
        this.appendColumnName(expr);
        return this;
    }

    public SQLBuilder where(String expr) {
        this.init(true);
        this.sb.append(_SPACE_WHERE_SPACE);
        this.appendStringExpr(expr, false);
        return this;
    }

    public SQLBuilder where(Condition cond) {
        this.init(true);
        this.sb.append(_SPACE_WHERE_SPACE);
        this.appendCondition(cond);
        return this;
    }

    public SQLBuilder groupBy(String expr) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        this.appendColumnName(expr);
        return this;
    }

    @SafeVarargs
    public final SQLBuilder groupBy(String ... columnNames) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        int len = columnNames.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.appendColumnName(this.propColumnNameMap, columnNames[i]);
        }
        return this;
    }

    public SQLBuilder groupBy(String columnName, SortDirection direction) {
        this.groupBy(columnName);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder groupBy(Collection<String> columnNames) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        int i = 0;
        for (String columnName : columnNames) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.appendColumnName(this.propColumnNameMap, columnName);
        }
        return this;
    }

    public SQLBuilder groupBy(Collection<String> columnNames, SortDirection direction) {
        this.groupBy(columnNames);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder groupBy(Map<String, SortDirection> orders) {
        this.sb.append(_SPACE_GROUP_BY_SPACE);
        int i = 0;
        for (Map.Entry<String, SortDirection> entry : orders.entrySet()) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.appendColumnName(this.propColumnNameMap, entry.getKey());
            this.sb.append(' ');
            this.sb.append(entry.getValue().toString());
        }
        return this;
    }

    public SQLBuilder having(String expr) {
        this.sb.append(_SPACE_HAVING_SPACE);
        this.appendStringExpr(expr, false);
        return this;
    }

    public SQLBuilder having(Condition cond) {
        this.sb.append(_SPACE_HAVING_SPACE);
        this.appendCondition(cond);
        return this;
    }

    public SQLBuilder orderBy(String expr) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        this.appendColumnName(expr);
        return this;
    }

    @SafeVarargs
    public final SQLBuilder orderBy(String ... columnNames) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        int len = columnNames.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.appendColumnName(this.propColumnNameMap, columnNames[i]);
        }
        return this;
    }

    public SQLBuilder orderBy(String columnName, SortDirection direction) {
        this.orderBy(columnName);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder orderBy(Collection<String> columnNames) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        int i = 0;
        for (String columnName : columnNames) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.appendColumnName(this.propColumnNameMap, columnName);
        }
        return this;
    }

    public SQLBuilder orderBy(Collection<String> columnNames, SortDirection direction) {
        this.orderBy(columnNames);
        this.sb.append(' ');
        this.sb.append(direction.toString());
        return this;
    }

    public SQLBuilder orderBy(Map<String, SortDirection> orders) {
        this.sb.append(_SPACE_ORDER_BY_SPACE);
        int i = 0;
        for (Map.Entry<String, SortDirection> entry : orders.entrySet()) {
            if (i++ > 0) {
                this.sb.append(_COMMA_SPACE);
            }
            this.appendColumnName(this.propColumnNameMap, entry.getKey());
            this.sb.append(' ');
            this.sb.append(entry.getValue().toString());
        }
        return this;
    }

    public SQLBuilder limit(int count) {
        this.sb.append(_SPACE_LIMIT_SPACE);
        this.sb.append(count);
        return this;
    }

    public SQLBuilder limit(int offset, int count) {
        this.sb.append(_SPACE_LIMIT_SPACE);
        this.sb.append(count);
        this.sb.append(_SPACE_OFFSET_SPACE);
        this.sb.append(offset);
        return this;
    }

    public SQLBuilder offset(int offset) {
        this.sb.append(_SPACE_OFFSET_SPACE);
        this.sb.append(offset);
        return this;
    }

    public SQLBuilder fetchNextNRowsOnly(int count) {
        this.sb.append(" FETCH NEXT ").append(count).append(" ROWS ONLY");
        return this;
    }

    public SQLBuilder fetchFirstNRowsOnly(int count) {
        this.sb.append(" FETCH FIRST ").append(count).append(" ROWS ONLY");
        return this;
    }

    public SQLBuilder append(Condition cond) {
        this.init(true);
        if (cond instanceof Criteria) {
            Limit limit;
            Cell cell;
            List<Cell> aggregations;
            Cell having;
            Cell groupBy;
            Cell where;
            Criteria criteria = (Criteria)cond;
            List<Join> joins = criteria.getJoins();
            if (N.notNullOrEmpty(joins)) {
                for (Join join : joins) {
                    this.sb.append(' ').append((Object)join.getOperator()).append(' ');
                    if (join.getJoinEntities().size() == 1) {
                        this.sb.append(join.getJoinEntities().get(0));
                    } else {
                        this.sb.append('(');
                        int idx = 0;
                        for (String string : join.getJoinEntities()) {
                            if (idx++ > 0) {
                                this.sb.append(_COMMA_SPACE);
                            }
                            this.sb.append(string);
                        }
                        this.sb.append(')');
                    }
                    this.appendCondition((Condition)join.getCondition());
                }
            }
            if ((where = criteria.getWhere()) != null) {
                this.sb.append(_SPACE_WHERE_SPACE);
                this.appendCondition((Condition)where.getCondition());
            }
            if ((groupBy = criteria.getGroupBy()) != null) {
                this.sb.append(_SPACE_GROUP_BY_SPACE);
                this.appendCondition((Condition)groupBy.getCondition());
            }
            if ((having = criteria.getHaving()) != null) {
                this.sb.append(_SPACE_HAVING_SPACE);
                this.appendCondition((Condition)having.getCondition());
            }
            if (N.notNullOrEmpty(aggregations = criteria.getAggregation())) {
                for (Cell aggregation : aggregations) {
                    this.sb.append(' ').append((Object)aggregation.getOperator()).append(' ');
                    this.appendCondition((Condition)aggregation.getCondition());
                }
            }
            if ((cell = criteria.getOrderBy()) != null) {
                this.sb.append(_SPACE_ORDER_BY_SPACE);
                this.appendCondition((Condition)cell.getCondition());
            }
            if ((limit = criteria.getLimit()) != null) {
                if (N.notNullOrEmpty(limit.getExpr())) {
                    this.sb.append(' ').append(limit.getExpr());
                } else if (limit.getOffset() > 0) {
                    this.limit(limit.getOffset(), limit.getCount());
                } else {
                    this.limit(limit.getCount());
                }
            }
        } else if (cond instanceof Clause) {
            this.sb.append(' ').append((Object)cond.getOperator()).append(' ');
            this.appendCondition((Condition)((Clause)cond).getCondition());
        } else {
            if (!this.isForConditionOnly) {
                this.sb.append(_SPACE_WHERE_SPACE);
            }
            this.appendCondition(cond);
        }
        return this;
    }

    public SQLBuilder append(String expr) {
        this.sb.append(expr);
        return this;
    }

    public SQLBuilder union(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.union(sql);
    }

    public SQLBuilder union(String query) {
        return this.union(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder union(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = Array.asList(columnNames);
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder union(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_SPACE);
        return this;
    }

    public SQLBuilder unionAll(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.unionAll(sql);
    }

    public SQLBuilder unionAll(String query) {
        return this.unionAll(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder unionAll(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = Array.asList(columnNames);
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_ALL_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder unionAll(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_UNION_ALL_SPACE);
        return this;
    }

    public SQLBuilder intersect(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.intersect(sql);
    }

    public SQLBuilder intersect(String query) {
        return this.intersect(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder intersect(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = Array.asList(columnNames);
        this.columnAliases = null;
        this.sb.append(_SPACE_INTERSECT_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder intersect(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_INTERSECT_SPACE);
        return this;
    }

    public SQLBuilder except(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.except(sql);
    }

    public SQLBuilder except(String query) {
        return this.except(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder except(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = Array.asList(columnNames);
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder except(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT_SPACE);
        return this;
    }

    public SQLBuilder minus(SQLBuilder sqlBuilder) {
        String sql = sqlBuilder.sql();
        if (N.notNullOrEmpty(sqlBuilder.parameters())) {
            this.parameters.addAll(sqlBuilder.parameters());
        }
        return this.minus(sql);
    }

    public SQLBuilder minus(String query) {
        return this.minus(N.asArray(query));
    }

    @SafeVarargs
    public final SQLBuilder minus(String ... columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = Array.asList(columnNames);
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT2_SPACE);
        if (this.isSubQuery(columnNames)) {
            this.sb.append(columnNames[0]);
            this.columnNames = null;
        }
        return this;
    }

    public SQLBuilder minus(Collection<String> columnNames) {
        this.op = OperationType.QUERY;
        this.columnNames = columnNames;
        this.columnAliases = null;
        this.sb.append(_SPACE_EXCEPT2_SPACE);
        return this;
    }

    public SQLBuilder forUpdate() {
        this.sb.append(_SPACE_FOR_UPDATE);
        return this;
    }

    public SQLBuilder set(String expr) {
        return this.set(Array.asList(expr));
    }

    @SafeVarargs
    public final SQLBuilder set(String ... columnNames) {
        return this.set(Array.asList(columnNames));
    }

    public SQLBuilder set(Collection<String> columnNames) {
        this.init(false);
        switch (this.sqlPolicy) {
            case SQL: 
            case PARAMETERIZED_SQL: {
                int i = 0;
                for (String columnName : columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, columnName);
                    if (columnName.indexOf(61) >= 0) continue;
                    this.sb.append(" = ?");
                }
                break;
            }
            case NAMED_SQL: {
                int i = 0;
                for (String columnName : columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, columnName);
                    if (columnName.indexOf(61) >= 0) continue;
                    this.sb.append(" = :");
                    this.sb.append(columnName);
                }
                break;
            }
            case IBATIS_SQL: {
                int i = 0;
                for (String columnName : columnNames) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, columnName);
                    if (columnName.indexOf(61) >= 0) continue;
                    this.sb.append(" = #{");
                    this.sb.append(columnName);
                    this.sb.append('}');
                }
                break;
            }
            default: {
                throw new RuntimeException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
        this.columnNames = null;
        return this;
    }

    public SQLBuilder set(Map<String, Object> props) {
        this.init(false);
        switch (this.sqlPolicy) {
            case SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, entry.getKey());
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForSQL(entry.getValue());
                }
                break;
            }
            case PARAMETERIZED_SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, entry.getKey());
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForRawSQL(entry.getValue());
                }
                break;
            }
            case NAMED_SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, entry.getKey());
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForNamedSQL(entry.getKey(), entry.getValue());
                }
                break;
            }
            case IBATIS_SQL: {
                int i = 0;
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(this.propColumnNameMap, entry.getKey());
                    this.sb.append(_SPACE_EQUAL_SPACE);
                    this.setParameterForIbatisNamedSQL(entry.getKey(), entry.getValue());
                }
                break;
            }
            default: {
                throw new RuntimeException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
        this.columnNames = null;
        return this;
    }

    public SQLBuilder set(Object entity) {
        return this.set(entity, null);
    }

    public SQLBuilder set(Object entity, Set<String> excludedPropNames) {
        if (entity instanceof String) {
            return this.set(N.asArray((String)entity));
        }
        if (entity instanceof Map) {
            if (N.isNullOrEmpty(excludedPropNames)) {
                return this.set((Map)entity);
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>((Map)entity);
            Maps.removeKeys(props, excludedPropNames);
            return this.set(props);
        }
        Class<?> entityClass = entity.getClass();
        this.entityClass = entityClass;
        this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        Collection<String> propNames = SQLBuilder.getUpdatePropNames(entityClass, excludedPropNames);
        Set<String> dirtyPropNames = DirtyMarkerUtil.isDirtyMarker(entityClass) ? DirtyMarkerUtil.dirtyPropNames((DirtyMarker)entity) : null;
        boolean isEmptyDirtyPropNames = N.isNullOrEmpty(dirtyPropNames);
        Map<String, Object> props = N.newHashMap(N.isNullOrEmpty(dirtyPropNames) ? propNames.size() : dirtyPropNames.size());
        ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
        for (String propName : propNames) {
            if (!isEmptyDirtyPropNames && !dirtyPropNames.contains(propName)) continue;
            props.put(propName, entityInfo.getPropValue(entity, propName));
        }
        return this.set(props);
    }

    public SQLBuilder set(Class<?> entityClass) {
        this.entityClass = entityClass;
        this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        return this.set(entityClass, null);
    }

    public SQLBuilder set(Class<?> entityClass, Set<String> excludedPropNames) {
        this.entityClass = entityClass;
        this.propColumnNameMap = SQLBuilder.getProp2ColumnNameMap(this.entityClass, this.namingPolicy);
        return this.set(SQLBuilder.getUpdatePropNames(entityClass, excludedPropNames));
    }

    public String sql() {
        if (this.sb == null) {
            throw new RuntimeException("This SQLBuilder has been closed after sql() was called previously");
        }
        this.init(true);
        String sql = null;
        try {
            sql = this.sb.charAt(0) == ' ' ? this.sb.substring(1) : this.sb.toString();
        }
        finally {
            Objectory.recycle(this.sb);
            this.sb = null;
            activeStringBuilderCounter.decrementAndGet();
        }
        if (logger.isDebugEnabled()) {
            logger.debug(sql);
        }
        return sql;
    }

    public List<Object> parameters() {
        return this.parameters;
    }

    public SP pair() {
        String sql = this.sql();
        return new SP(sql, this.parameters);
    }

    public <T, E extends Exception> T apply(Throwables.Function<? super SP, T, E> func) throws E {
        return func.apply(this.pair());
    }

    public <T, E extends Exception> T apply(Throwables.BiFunction<? super String, ? super List<Object>, T, E> func) throws E {
        SP sp = this.pair();
        return func.apply(sp.sql, sp.parameters);
    }

    public <E extends Exception> void accept(Throwables.Consumer<? super SP, E> consumer) throws E {
        consumer.accept(this.pair());
    }

    public <E extends Exception> void accept(Throwables.BiConsumer<? super String, ? super List<Object>, E> consumer) throws E {
        SP sp = this.pair();
        consumer.accept(sp.sql, sp.parameters);
    }

    void init(boolean setForUpdate) {
        if (this.sb.length() > 0) {
            return;
        }
        if (this.op == OperationType.UPDATE) {
            this.sb.append(_UPDATE);
            this.sb.append(' ');
            this.sb.append(this.tableName);
            this.sb.append(_SPACE_SET_SPACE);
            if (setForUpdate && N.notNullOrEmpty(this.columnNames)) {
                this.set(this.columnNames);
            }
        } else if (this.op == OperationType.DELETE) {
            String newTableName = this.tableName;
            char[] deleteFromTableChars = tableDeleteFrom.get(newTableName);
            if (deleteFromTableChars == null) {
                deleteFromTableChars = ("DELETE FROM " + newTableName).toCharArray();
                tableDeleteFrom.put(newTableName, deleteFromTableChars);
            }
            this.sb.append(deleteFromTableChars);
        } else if (this.op == OperationType.QUERY && !this.hasFromBeenSet && !this.isForConditionOnly) {
            throw new RuntimeException("'from' methods has not been called for query: " + (Object)((Object)this.op));
        }
    }

    private void setParameterForSQL(Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append('?');
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append(Expression.formalize(propValue));
        }
    }

    private void setParameterForRawSQL(Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append('?');
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append('?');
            this.parameters.add(propValue);
        }
    }

    private void setParameterForIbatisNamedSQL(String propName, Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append("#{");
            this.sb.append(propName);
            this.sb.append('}');
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append("#{");
            this.sb.append(propName);
            this.sb.append('}');
            this.parameters.add(propValue);
        }
    }

    private void setParameterForNamedSQL(String propName, Object propValue) {
        if (ConditionFactory.CF.QME.equals(propValue)) {
            this.sb.append(":");
            this.sb.append(propName);
        } else if (propValue instanceof Condition) {
            this.appendCondition((Condition)propValue);
        } else {
            this.sb.append(":");
            this.sb.append(propName);
            this.parameters.add(propValue);
        }
    }

    private void setParameter(String propName, Object propValue) {
        switch (this.sqlPolicy) {
            case SQL: {
                this.setParameterForSQL(propValue);
                break;
            }
            case PARAMETERIZED_SQL: {
                this.setParameterForRawSQL(propValue);
                break;
            }
            case NAMED_SQL: {
                this.setParameterForNamedSQL(propName, propValue);
                break;
            }
            case IBATIS_SQL: {
                this.setParameterForIbatisNamedSQL(propName, propValue);
                break;
            }
            default: {
                throw new RuntimeException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
    }

    private void appendInsertProps(Map<String, Object> props) {
        switch (this.sqlPolicy) {
            case SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForSQL(propValue);
                }
                break;
            }
            case PARAMETERIZED_SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForRawSQL(propValue);
                }
                break;
            }
            case NAMED_SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForNamedSQL(propName, propValue);
                }
                break;
            }
            case IBATIS_SQL: {
                int i = 0;
                Object propValue = null;
                for (String propName : props.keySet()) {
                    if (i++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    propValue = props.get(propName);
                    this.setParameterForIbatisNamedSQL(propName, propValue);
                }
                break;
            }
            default: {
                throw new RuntimeException("Not supported SQL policy: " + (Object)((Object)this.sqlPolicy));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void appendCondition(Condition cond) {
        if (cond instanceof Binary) {
            Binary binary = (Binary)cond;
            String propName = binary.getPropName();
            this.appendColumnName(propName);
            this.sb.append(' ');
            this.sb.append(binary.getOperator().toString());
            this.sb.append(' ');
            Object propValue = binary.getPropValue();
            this.setParameter(propName, propValue);
            return;
        } else if (cond instanceof Between) {
            Between bt = (Between)cond;
            String propName = bt.getPropName();
            this.appendColumnName(propName);
            this.sb.append(' ');
            this.sb.append(bt.getOperator().toString());
            this.sb.append(' ');
            Object minValue = bt.getMinValue();
            if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                this.setParameter("min" + StringUtil.capitalize(propName), minValue);
            } else {
                this.setParameter(propName, minValue);
            }
            this.sb.append(' ');
            this.sb.append("AND");
            this.sb.append(' ');
            Object maxValue = bt.getMaxValue();
            if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                this.setParameter("max" + StringUtil.capitalize(propName), maxValue);
                return;
            } else {
                this.setParameter(propName, maxValue);
            }
            return;
        } else if (cond instanceof In) {
            In in = (In)cond;
            String propName = in.getPropName();
            List<Object> parameters = in.getParameters();
            this.appendColumnName(propName);
            this.sb.append(' ');
            this.sb.append(in.getOperator().toString());
            this.sb.append(" (");
            int len = parameters.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(", ");
                }
                if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                    this.setParameter(propName + (i + 1), parameters.get(i));
                    continue;
                }
                this.setParameter(propName, parameters.get(i));
            }
            this.sb.append(')');
            return;
        } else if (cond instanceof InSubQuery) {
            InSubQuery inSubQuery = (InSubQuery)cond;
            String propName = inSubQuery.getPropName();
            if (N.notNullOrEmpty(propName)) {
                this.appendColumnName(propName);
            } else {
                this.sb.append('(');
                int idx = 0;
                for (String e : inSubQuery.getPropNames()) {
                    if (idx++ > 0) {
                        this.sb.append(_COMMA_SPACE);
                    }
                    this.appendColumnName(e);
                }
                this.sb.append(')');
            }
            this.sb.append(' ');
            this.sb.append(inSubQuery.getOperator().toString());
            this.sb.append(" (");
            this.appendCondition(inSubQuery.getSubQuery());
            this.sb.append(')');
            return;
        } else if (cond instanceof NotIn) {
            NotIn notIn = (NotIn)cond;
            String propName = notIn.getPropName();
            List<Object> parameters = notIn.getParameters();
            this.appendColumnName(propName);
            this.sb.append(' ');
            this.sb.append(notIn.getOperator().toString());
            this.sb.append(" (");
            int len = parameters.size();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    this.sb.append(", ");
                }
                if (this.sqlPolicy == SQLPolicy.NAMED_SQL || this.sqlPolicy == SQLPolicy.IBATIS_SQL) {
                    this.setParameter(propName + (i + 1), parameters.get(i));
                    continue;
                }
                this.setParameter(propName, parameters.get(i));
            }
            this.sb.append(')');
            return;
        } else if (cond instanceof NotInSubQuery) {
            NotInSubQuery notInSubQuery = (NotInSubQuery)cond;
            String propName = notInSubQuery.getPropName();
            this.appendColumnName(propName);
            this.sb.append(' ');
            this.sb.append(notInSubQuery.getOperator().toString());
            this.sb.append(" (");
            this.appendCondition(notInSubQuery.getSubQuery());
            this.sb.append(')');
            return;
        } else if (cond instanceof Where || cond instanceof Having) {
            Cell cell = (Cell)cond;
            this.sb.append(' ');
            this.sb.append(cell.getOperator().toString());
            this.sb.append(' ');
            this.appendCondition((Condition)cell.getCondition());
            return;
        } else if (cond instanceof Cell) {
            Cell cell = (Cell)cond;
            this.sb.append(' ');
            this.sb.append(cell.getOperator().toString());
            this.sb.append(' ');
            this.sb.append('(');
            this.appendCondition((Condition)cell.getCondition());
            this.sb.append(')');
            return;
        } else if (cond instanceof Junction) {
            Junction junction = (Junction)cond;
            List<Condition> conditionList = junction.getConditions();
            if (N.isNullOrEmpty(conditionList)) {
                throw new IllegalArgumentException("The junction condition(" + junction.getOperator().toString() + ") doesn't include any element.");
            }
            if (conditionList.size() == 1) {
                this.appendCondition(conditionList.get(0));
                return;
            } else {
                int size = conditionList.size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        this.sb.append(' ');
                        this.sb.append(junction.getOperator().toString());
                        this.sb.append(' ');
                    }
                    this.sb.append('(');
                    this.appendCondition(conditionList.get(i));
                    this.sb.append(')');
                }
            }
            return;
        } else if (cond instanceof SubQuery) {
            SubQuery subQuery = (SubQuery)cond;
            Condition subCond = subQuery.getCondition();
            if (N.notNullOrEmpty(subQuery.getSql())) {
                this.sb.append(subQuery.getSql());
                return;
            } else if (subQuery.getEntityClass() != null) {
                if (this instanceof SCSB) {
                    this.sb.append(SCSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof PSC) {
                    this.sb.append(PSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof MSC) {
                    this.sb.append(MSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof NSC) {
                    this.sb.append(NSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof ACSB) {
                    this.sb.append(ACSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof PAC) {
                    this.sb.append(PAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof MAC) {
                    this.sb.append(MAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof NAC) {
                    this.sb.append(NAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof LCSB) {
                    this.sb.append(LCSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof PLC) {
                    this.sb.append(PLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof MLC) {
                    this.sb.append(MLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof NLC) {
                    this.sb.append(NLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else if (this instanceof PSB) {
                    this.sb.append(PSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                    return;
                } else {
                    if (!(this instanceof NSB)) throw new RuntimeException("Unsupproted subQuery condition: " + cond);
                    this.sb.append(NSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityClass()).append(subCond).sql());
                }
                return;
            } else if (this instanceof SCSB) {
                this.sb.append(SCSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof PSC) {
                this.sb.append(PSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof MSC) {
                this.sb.append(MSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof NSC) {
                this.sb.append(NSC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof ACSB) {
                this.sb.append(ACSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof PAC) {
                this.sb.append(PAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof MAC) {
                this.sb.append(MAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof NAC) {
                this.sb.append(NAC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof LCSB) {
                this.sb.append(LCSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof PLC) {
                this.sb.append(PLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof MLC) {
                this.sb.append(MLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof NLC) {
                this.sb.append(NLC.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else if (this instanceof PSB) {
                this.sb.append(PSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
                return;
            } else {
                if (!(this instanceof NSB)) throw new RuntimeException("Unsupproted subQuery condition: " + cond);
                this.sb.append(NSB.select(subQuery.getSelectPropNames()).from(subQuery.getEntityName()).append(subCond).sql());
            }
            return;
        } else {
            if (!(cond instanceof Expression)) throw new IllegalArgumentException("Unsupported condtion: " + cond.toString());
            this.appendStringExpr(((Expression)cond).getLiteral(), false);
        }
    }

    private void appendStringExpr(String expr, boolean isFromAppendColumn) {
        int i;
        int len;
        if (expr.length() < 16) {
            boolean allChars = true;
            char ch = '\u0000';
            len = expr.length();
            for (i = 0; i < len; ++i) {
                ch = expr.charAt(i);
                if (ch >= 'A' && (ch <= 'Z' || ch >= '_') && ch <= 'z') continue;
                allChars = false;
                break;
            }
            if (allChars) {
                if (isFromAppendColumn) {
                    this.sb.append(SQLBuilder.formalizeColumnName(expr, this.namingPolicy));
                } else {
                    this.sb.append(this.formalizeColumnName(this.propColumnNameMap, expr));
                }
                return;
            }
        }
        List<String> words = SQLParser.parse(expr);
        String word = null;
        len = words.size();
        for (i = 0; i < len; ++i) {
            word = words.get(i);
            if (!StringUtil.isAsciiAlpha(word.charAt(0))) {
                this.sb.append(word);
                continue;
            }
            if (SQLParser.isFunctionName(words, len, i)) {
                this.sb.append(word);
                continue;
            }
            this.sb.append(this.formalizeColumnName(this.propColumnNameMap, word));
        }
    }

    private void appendColumnName(String propName) {
        this.appendColumnName(this.propColumnNameMap, propName);
    }

    private void appendColumnName(ImmutableMap<String, Tuple.Tuple2<String, Boolean>> propColumnNameMap, String propName) {
        this.appendColumnName(propColumnNameMap, propName, null, false, null, false);
    }

    private void appendColumnName(ImmutableMap<String, Tuple.Tuple2<String, Boolean>> propColumnNameMap, String propName, String propAlias, boolean withClassAlias, String classAlias, boolean isForSelect) {
        String newPropName;
        String propTableAlias;
        Map<String, Tuple.Tuple2<String, Boolean>> newPropColumnNameMap;
        int index;
        Tuple.Tuple2<String, Boolean> tp;
        Tuple.Tuple2<String, Boolean> tuple2 = tp = propColumnNameMap == null ? null : propColumnNameMap.get(propName);
        if (tp != null) {
            if (((Boolean)tp._2).booleanValue() && this.alias != null && this.alias.length() > 0) {
                this.sb.append(this.alias).append('.');
            }
            this.sb.append((String)tp._1);
            if (isForSelect && this.namingPolicy != NamingPolicy.NO_CHANGE) {
                this.sb.append(_SPACE_AS_SPACE);
                this.sb.append('\"');
                if (withClassAlias) {
                    this.sb.append(classAlias).append('.');
                }
                this.sb.append(N.notNullOrEmpty(propAlias) ? propAlias : propName);
                this.sb.append('\"');
            }
            return;
        }
        if (this.aliasPropColumnNameMap != null && this.aliasPropColumnNameMap.size() > 0 && (index = propName.indexOf(46)) > 0 && (newPropColumnNameMap = this.aliasPropColumnNameMap.get(propTableAlias = propName.substring(0, index))) != null && (tp = newPropColumnNameMap.get(newPropName = propName.substring(index + 1))) != null) {
            this.sb.append(propTableAlias).append('.').append((String)tp._1);
            if (isForSelect && this.namingPolicy != NamingPolicy.NO_CHANGE) {
                this.sb.append(_SPACE_AS_SPACE);
                this.sb.append('\"');
                if (withClassAlias) {
                    this.sb.append(classAlias).append('.');
                }
                this.sb.append(N.notNullOrEmpty(propAlias) ? propAlias : propName);
                this.sb.append('\"');
            }
            return;
        }
        if (N.notNullOrEmpty(propAlias)) {
            this.appendStringExpr(propName, true);
            if (isForSelect && this.namingPolicy != NamingPolicy.NO_CHANGE) {
                this.sb.append(_SPACE_AS_SPACE);
                this.sb.append('\"');
                if (withClassAlias) {
                    this.sb.append(classAlias).append('.');
                }
                this.sb.append(propAlias);
                this.sb.append('\"');
            }
        } else if (isForSelect) {
            index = propName.indexOf(SPACE_AS_SPACE);
            if (index < 0) {
                index = propName.indexOf(" as ");
            }
            if (index > 0) {
                this.appendColumnName(propColumnNameMap, propName.substring(0, index).trim(), propName.substring(index + 4).trim(), withClassAlias, classAlias, isForSelect);
            } else {
                this.appendStringExpr(propName, true);
                if (this.namingPolicy != NamingPolicy.NO_CHANGE && propName.charAt(propName.length() - 1) != '*') {
                    this.sb.append(_SPACE_AS_SPACE);
                    this.sb.append('\"');
                    if (withClassAlias) {
                        this.sb.append(classAlias).append('.');
                    }
                    this.sb.append(propName);
                    this.sb.append('\"');
                }
            }
        } else {
            this.appendStringExpr(propName, true);
        }
    }

    private boolean isSubQuery(String ... columnNames) {
        int index;
        if (columnNames.length == 1 && (index = SQLParser.indexWord(columnNames[0], "SELECT", 0, false)) >= 0) {
            return (index = SQLParser.indexWord(columnNames[0], "FROM", index, false)) >= 1;
        }
        return false;
    }

    public void println() {
        N.println(this.sql());
    }

    public String toString() {
        return this.sql();
    }

    static String formalizeColumnName(String word, NamingPolicy namingPolicy) {
        if (sqlKeyWords.contains(word) || namingPolicy == NamingPolicy.NO_CHANGE) {
            return word;
        }
        if (namingPolicy == NamingPolicy.LOWER_CAMEL_CASE) {
            return ClassUtil.formalizePropName(word);
        }
        return namingPolicy.convert(word);
    }

    private String formalizeColumnName(ImmutableMap<String, Tuple.Tuple2<String, Boolean>> propColumnNameMap, String propName) {
        String newPropName;
        String propTableAlias;
        Map<String, Tuple.Tuple2<String, Boolean>> newPropColumnNameMap;
        int index;
        Tuple.Tuple2<String, Boolean> tp;
        Tuple.Tuple2<String, Boolean> tuple2 = tp = propColumnNameMap == null ? null : propColumnNameMap.get(propName);
        if (tp != null) {
            if (((Boolean)tp._2).booleanValue() && this.alias != null && this.alias.length() > 0) {
                return this.alias + "." + (String)tp._1;
            }
            return (String)tp._1;
        }
        if (this.aliasPropColumnNameMap != null && this.aliasPropColumnNameMap.size() > 0 && (index = propName.indexOf(46)) > 0 && (newPropColumnNameMap = this.aliasPropColumnNameMap.get(propTableAlias = propName.substring(0, index))) != null && (tp = newPropColumnNameMap.get(newPropName = propName.substring(index + 1))) != null) {
            return propTableAlias + "." + (String)tp._1;
        }
        return SQLBuilder.formalizeColumnName(propName, this.namingPolicy);
    }

    private static void parseInsertEntity(SQLBuilder instance, Object entity, Set<String> excludedPropNames) {
        if (entity instanceof String) {
            instance.columnNames = Array.asList((String)entity);
        } else if (entity instanceof Map) {
            if (N.isNullOrEmpty(excludedPropNames)) {
                instance.props = (Map)entity;
            } else {
                instance.props = new LinkedHashMap<String, Object>((Map)entity);
                Maps.removeKeys(instance.props, excludedPropNames);
            }
        } else {
            Collection<String> propNames = SQLBuilder.getInsertPropNames(entity, excludedPropNames);
            Map map = N.newHashMap(propNames.size());
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entity.getClass());
            for (String propName : propNames) {
                map.put(propName, entityInfo.getPropValue(entity, propName));
            }
            instance.props = map;
        }
    }

    private static Collection<Map<String, Object>> toInsertPropsList(Collection<?> propsList) {
        u.Optional<?> first = N.firstNonNull(propsList);
        if (first.isPresent() && first.get() instanceof Map) {
            return (List)propsList;
        }
        Class<?> entityClass = first.get().getClass();
        Collection<String> propNames = SQLBuilder.getInsertPropNames(entityClass, null);
        ArrayList<Map<String, Object>> newPropsList = new ArrayList<Map<String, Object>>(propsList.size());
        for (Object entity : propsList) {
            Map props = N.newHashMap(propNames.size());
            ParserUtil.EntityInfo entityInfo = ParserUtil.getEntityInfo(entityClass);
            for (String propName : propNames) {
                props.put(propName, entityInfo.getPropValue(entity, propName));
            }
            newPropsList.add(props);
        }
        return newPropsList;
    }

    static void checkMultiSelects(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
        N.checkArgNotNullOrEmpty(multiSelects, "multiSelects");
        for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
            N.checkArgNotNull(tp._1, "Class can't be null in 'multiSelects'");
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_3;
        logger = LoggerFactory.getLogger(SQLBuilder.class);
        _1_list = ImmutableList.of(_1);
        _INSERT = "INSERT".toCharArray();
        _SPACE_INSERT_SPACE = " INSERT ".toCharArray();
        _INTO = "INTO".toCharArray();
        _SPACE_INTO_SPACE = " INTO ".toCharArray();
        _VALUES = "VALUES".toCharArray();
        _SPACE_VALUES_SPACE = " VALUES ".toCharArray();
        _SELECT = "SELECT".toCharArray();
        _SPACE_SELECT_SPACE = " SELECT ".toCharArray();
        _FROM = "FROM".toCharArray();
        _SPACE_FROM_SPACE = " FROM ".toCharArray();
        _UPDATE = "UPDATE".toCharArray();
        _SPACE_UPDATE_SPACE = " UPDATE ".toCharArray();
        _SET = "SET".toCharArray();
        _SPACE_SET_SPACE = " SET ".toCharArray();
        _DELETE = "DELETE".toCharArray();
        _SPACE_DELETE_SPACE = " DELETE ".toCharArray();
        _JOIN = "JOIN".toCharArray();
        _SPACE_JOIN_SPACE = " JOIN ".toCharArray();
        _LEFT_JOIN = "LEFT JOIN".toCharArray();
        _SPACE_LEFT_JOIN_SPACE = " LEFT JOIN ".toCharArray();
        _RIGHT_JOIN = "RIGHT JOIN".toCharArray();
        _SPACE_RIGHT_JOIN_SPACE = " RIGHT JOIN ".toCharArray();
        _FULL_JOIN = "FULL JOIN".toCharArray();
        _SPACE_FULL_JOIN_SPACE = " FULL JOIN ".toCharArray();
        _CROSS_JOIN = "CROSS JOIN".toCharArray();
        _SPACE_CROSS_JOIN_SPACE = " CROSS JOIN ".toCharArray();
        _INNER_JOIN = "INNER JOIN".toCharArray();
        _SPACE_INNER_JOIN_SPACE = " INNER JOIN ".toCharArray();
        _NATURAL_JOIN = "NATURAL JOIN".toCharArray();
        _SPACE_NATURAL_JOIN_SPACE = " NATURAL JOIN ".toCharArray();
        _ON = "ON".toCharArray();
        _SPACE_ON_SPACE = " ON ".toCharArray();
        _USING = "USING".toCharArray();
        _SPACE_USING_SPACE = " USING ".toCharArray();
        _WHERE = "WHERE".toCharArray();
        _SPACE_WHERE_SPACE = " WHERE ".toCharArray();
        _GROUP_BY = "GROUP BY".toCharArray();
        _SPACE_GROUP_BY_SPACE = " GROUP BY ".toCharArray();
        _HAVING = "HAVING".toCharArray();
        _SPACE_HAVING_SPACE = " HAVING ".toCharArray();
        _ORDER_BY = "ORDER BY".toCharArray();
        _SPACE_ORDER_BY_SPACE = " ORDER BY ".toCharArray();
        _LIMIT = " LIMIT ".toCharArray();
        _SPACE_LIMIT_SPACE = " LIMIT ".toCharArray();
        _OFFSET = "OFFSET".toCharArray();
        _SPACE_OFFSET_SPACE = " OFFSET ".toCharArray();
        _AND = "AND".toCharArray();
        _SPACE_AND_SPACE = " AND ".toCharArray();
        _OR = "OR".toCharArray();
        _SPACE_OR_SPACE = " OR ".toCharArray();
        _UNION = "UNION".toCharArray();
        _SPACE_UNION_SPACE = " UNION ".toCharArray();
        _UNION_ALL = "UNION ALL".toCharArray();
        _SPACE_UNION_ALL_SPACE = " UNION ALL ".toCharArray();
        _INTERSECT = "INTERSECT".toCharArray();
        _SPACE_INTERSECT_SPACE = " INTERSECT ".toCharArray();
        _EXCEPT = "EXCEPT".toCharArray();
        _SPACE_EXCEPT_SPACE = " EXCEPT ".toCharArray();
        _EXCEPT2 = "MINUS".toCharArray();
        _SPACE_EXCEPT2_SPACE = " MINUS ".toCharArray();
        _AS = "AS".toCharArray();
        _SPACE_AS_SPACE = SPACE_AS_SPACE.toCharArray();
        _SPACE_EQUAL_SPACE = " = ".toCharArray();
        _SPACE_FOR_UPDATE = " FOR UPDATE".toCharArray();
        _COMMA_SPACE = ", ".toCharArray();
        sqlKeyWords = N.newHashSet(1024);
        Field[] fieldArray = WD.class.getDeclaredFields();
        int m = 0;
        for (Field field : fieldArray) {
            m = field.getModifiers();
            if (!Modifier.isPublic(m) || !Modifier.isStatic(m) || !Modifier.isFinal(m) || !field.getType().equals(String.class)) continue;
            try {
                String value = (String)field.get(null);
                for (String e : StringUtil.split(value, ' ', true)) {
                    sqlKeyWords.add(e);
                    sqlKeyWords.add(e.toUpperCase());
                    sqlKeyWords.add(e.toLowerCase());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        subEntityPropNamesPool = new ObjectPool(N.POOL_SIZE);
        nonSubEntityPropNamesPool = new ObjectPool(N.POOL_SIZE);
        defaultPropNamesPool = new ObjectPool(N.POOL_SIZE);
        fullSelectPartsPool = N.newHashMap(NamingPolicy.values().length);
        for (NamingPolicy namingPolicy : NamingPolicy.values()) {
            fullSelectPartsPool.put(namingPolicy, new ConcurrentHashMap());
        }
        tableDeleteFrom = new ConcurrentHashMap<String, char[]>();
        classTableNameMap = new ConcurrentHashMap();
        activeStringBuilderCounter = new AtomicInteger();
        QM_CACHE = new HashMap<Integer, String>();
        boolean bl = false;
        while (var0_3 <= 30) {
            QM_CACHE.put((int)var0_3, StringUtil.repeat("?", (int)var0_3, ", "));
            ++var0_3;
        }
        QM_CACHE.put(100, StringUtil.repeat("?", 100, ", "));
        QM_CACHE.put(200, StringUtil.repeat("?", 200, ", "));
        QM_CACHE.put(300, StringUtil.repeat("?", 300, ", "));
        QM_CACHE.put(500, StringUtil.repeat("?", 500, ", "));
        QM_CACHE.put(1000, StringUtil.repeat("?", 1000, ", "));
        entityTablePropColumnNameMap = new ObjectPool(N.POOL_SIZE);
    }

    public static final class SP {
        public final String sql;
        public final List<Object> parameters;

        SP(String sql, List<Object> parameters) {
            this.sql = sql;
            this.parameters = ImmutableList.of(parameters);
        }

        public int hashCode() {
            return N.hashCode(this.sql) * 31 + N.hashCode(this.parameters);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof SP) {
                SP other = (SP)obj;
                return N.equals(other.sql, this.sql) && N.equals(other.parameters, this.parameters);
            }
            return false;
        }

        public String toString() {
            return "{sql=" + this.sql + ", parameters=" + N.toString(this.parameters) + "}";
        }
    }

    @Deprecated
    public static class MLC
    extends SQLBuilder {
        MLC() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.IBATIS_SQL);
        }

        static MLC createInstance() {
            return new MLC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return MLC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MLC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MLC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MLC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MLC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MLC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MLC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNames = MLC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MLC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MLC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MLC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MLC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MLC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return MLC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MLC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return MLC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MLC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return MLC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return MLC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CAMEL_CASE);
                return MLC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return MLC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MLC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MLC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MLC.checkMultiSelects(multiSelects);
            MLC instance = MLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = MLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MLC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MLC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MLC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CAMEL_CASE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(MLC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return MLC.select(multiSelects).from(fromClause);
        }
    }

    @Deprecated
    public static class MAC
    extends SQLBuilder {
        MAC() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.IBATIS_SQL);
        }

        static MAC createInstance() {
            return new MAC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return MAC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MAC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MAC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MAC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MAC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MAC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MAC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = MAC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MAC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MAC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MAC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MAC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MAC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return MAC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MAC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return MAC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MAC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return MAC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return MAC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                return MAC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return MAC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MAC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MAC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MAC.checkMultiSelects(multiSelects);
            MAC instance = MAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = MAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MAC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MAC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MAC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.UPPER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(MAC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return MAC.select(multiSelects).from(fromClause);
        }
    }

    @Deprecated
    public static class MSC
    extends SQLBuilder {
        MSC() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.IBATIS_SQL);
        }

        static MSC createInstance() {
            return new MSC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return MSC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MSC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MSC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MSC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MSC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MSC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = MSC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MSC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MSC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MSC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MSC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return MSC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MSC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return MSC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return MSC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return MSC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                return MSC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return MSC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MSC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MSC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MSC.checkMultiSelects(multiSelects);
            MSC instance = MSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = MSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MSC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MSC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MSC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(MSC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return MSC.select(multiSelects).from(fromClause);
        }
    }

    @Deprecated
    public static class MSB
    extends SQLBuilder {
        MSB() {
            super(NamingPolicy.NO_CHANGE, SQLPolicy.IBATIS_SQL);
        }

        static MSB createInstance() {
            return new MSB();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return MSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return MSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return MSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MSB.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return MSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return MSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MSB.getTableName(entityClass, NamingPolicy.NO_CHANGE);
            ((SQLBuilder)instance).columnNames = MSB.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = MSB.getTableName(entityClass, NamingPolicy.NO_CHANGE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return MSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = MSB.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return MSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return MSB.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return MSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return MSB.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return MSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return MSB.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return MSB.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.NO_CHANGE);
                return MSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return MSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MSB.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MSB.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MSB.checkMultiSelects(multiSelects);
            MSB instance = MSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = MSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return MSB.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return MSB.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            MSB.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.NO_CHANGE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(MSB.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return MSB.select(multiSelects).from(fromClause);
        }
    }

    public static class NLC
    extends SQLBuilder {
        NLC() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.NAMED_SQL);
        }

        static NLC createInstance() {
            return new NLC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return NLC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NLC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NLC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NLC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NLC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NLC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NLC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNames = NLC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NLC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NLC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NLC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NLC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NLC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return NLC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NLC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return NLC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NLC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return NLC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return NLC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CAMEL_CASE);
                return NLC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return NLC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NLC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NLC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NLC.checkMultiSelects(multiSelects);
            NLC instance = NLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = NLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NLC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NLC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NLC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CAMEL_CASE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(NLC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return NLC.select(multiSelects).from(fromClause);
        }
    }

    public static class NAC
    extends SQLBuilder {
        NAC() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.NAMED_SQL);
        }

        static NAC createInstance() {
            return new NAC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return NAC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NAC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NAC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NAC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NAC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NAC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NAC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = NAC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NAC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NAC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NAC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NAC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NAC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return NAC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NAC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return NAC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NAC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return NAC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return NAC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                return NAC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return NAC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NAC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NAC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NAC.checkMultiSelects(multiSelects);
            NAC instance = NAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = NAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NAC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NAC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NAC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.UPPER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(NAC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return NAC.select(multiSelects).from(fromClause);
        }
    }

    public static class NSC
    extends SQLBuilder {
        NSC() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.NAMED_SQL);
        }

        static NSC createInstance() {
            return new NSC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return NSC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NSC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NSC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NSC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NSC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NSC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = NSC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NSC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NSC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NSC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NSC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return NSC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NSC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return NSC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return NSC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return NSC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                return NSC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return NSC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NSC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NSC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NSC.checkMultiSelects(multiSelects);
            NSC instance = NSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = NSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NSC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NSC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NSC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(NSC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return NSC.select(multiSelects).from(fromClause);
        }
    }

    public static class NSB
    extends SQLBuilder {
        NSB() {
            super(NamingPolicy.NO_CHANGE, SQLPolicy.NAMED_SQL);
        }

        static NSB createInstance() {
            return new NSB();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return NSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return NSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return NSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NSB.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return NSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return NSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NSB.getTableName(entityClass, NamingPolicy.NO_CHANGE);
            ((SQLBuilder)instance).columnNames = NSB.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = NSB.getTableName(entityClass, NamingPolicy.NO_CHANGE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return NSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = NSB.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return NSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return NSB.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return NSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return NSB.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return NSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return NSB.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return NSB.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.NO_CHANGE);
                return NSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return NSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NSB.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NSB.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NSB.checkMultiSelects(multiSelects);
            NSB instance = NSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = NSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return NSB.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return NSB.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            NSB.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.NO_CHANGE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(NSB.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return NSB.select(multiSelects).from(fromClause);
        }
    }

    public static class PLC
    extends SQLBuilder {
        PLC() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PLC createInstance() {
            return new PLC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return PLC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PLC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PLC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PLC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PLC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PLC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PLC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNames = PLC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PLC.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PLC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PLC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PLC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PLC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PLC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return PLC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PLC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return PLC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PLC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return PLC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return PLC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CAMEL_CASE);
                return PLC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return PLC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PLC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PLC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PLC.checkMultiSelects(multiSelects);
            PLC instance = PLC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = PLC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PLC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PLC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PLC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CAMEL_CASE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(PLC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return PLC.select(multiSelects).from(fromClause);
        }
    }

    public static class PAC
    extends SQLBuilder {
        PAC() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PAC createInstance() {
            return new PAC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return PAC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PAC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PAC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PAC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PAC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PAC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PAC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = PAC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PAC.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PAC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PAC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PAC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PAC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PAC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return PAC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PAC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return PAC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PAC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return PAC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return PAC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                return PAC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return PAC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PAC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PAC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PAC.checkMultiSelects(multiSelects);
            PAC instance = PAC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = PAC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PAC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PAC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PAC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.UPPER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(PAC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return PAC.select(multiSelects).from(fromClause);
        }
    }

    public static class PSC
    extends SQLBuilder {
        PSC() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PSC createInstance() {
            return new PSC();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return PSC.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PSC.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PSC.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PSC.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PSC.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSC.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PSC.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = PSC.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PSC.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PSC.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PSC.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSC.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PSC.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PSC.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return PSC.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PSC.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return PSC.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSC.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return PSC.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return PSC.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                return PSC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return PSC.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PSC.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PSC.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PSC.checkMultiSelects(multiSelects);
            PSC instance = PSC.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = PSC.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PSC.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PSC.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PSC.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(PSC.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return PSC.select(multiSelects).from(fromClause);
        }
    }

    public static class PSB
    extends SQLBuilder {
        PSB() {
            super(NamingPolicy.NO_CHANGE, SQLPolicy.PARAMETERIZED_SQL);
        }

        static PSB createInstance() {
            return new PSB();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return PSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return PSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return PSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PSB.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return PSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return PSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PSB.getTableName(entityClass, NamingPolicy.NO_CHANGE);
            ((SQLBuilder)instance).columnNames = PSB.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = PSB.getTableName(entityClass, NamingPolicy.NO_CHANGE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return PSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = PSB.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return PSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return PSB.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return PSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return PSB.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return PSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return PSB.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return PSB.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.NO_CHANGE);
                return PSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return PSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PSB.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PSB.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PSB.checkMultiSelects(multiSelects);
            PSB instance = PSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = PSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return PSB.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return PSB.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            PSB.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.NO_CHANGE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(PSB.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return PSB.select(multiSelects).from(fromClause);
        }
    }

    @Deprecated
    public static class LCSB
    extends SQLBuilder {
        LCSB() {
            super(NamingPolicy.LOWER_CAMEL_CASE, SQLPolicy.SQL);
        }

        static LCSB createInstance() {
            return new LCSB();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return LCSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return LCSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return LCSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = LCSB.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return LCSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return LCSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return LCSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = LCSB.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            ((SQLBuilder)instance).columnNames = LCSB.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = LCSB.getTableName(entityClass, NamingPolicy.LOWER_CAMEL_CASE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return LCSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return LCSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return LCSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = LCSB.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return LCSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return LCSB.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return LCSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return LCSB.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return LCSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return LCSB.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return LCSB.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CAMEL_CASE);
                return LCSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return LCSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return LCSB.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return LCSB.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            LCSB.checkMultiSelects(multiSelects);
            LCSB instance = LCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = LCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return LCSB.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return LCSB.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            LCSB.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CAMEL_CASE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(LCSB.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return LCSB.select(multiSelects).from(fromClause);
        }
    }

    @Deprecated
    public static class ACSB
    extends SQLBuilder {
        ACSB() {
            super(NamingPolicy.UPPER_CASE_WITH_UNDERSCORE, SQLPolicy.SQL);
        }

        static ACSB createInstance() {
            return new ACSB();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return ACSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return ACSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return ACSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = ACSB.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return ACSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return ACSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return ACSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = ACSB.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = ACSB.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = ACSB.getTableName(entityClass, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return ACSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return ACSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return ACSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = ACSB.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return ACSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return ACSB.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return ACSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return ACSB.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return ACSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return ACSB.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return ACSB.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.UPPER_CASE_WITH_UNDERSCORE);
                return ACSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return ACSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return ACSB.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return ACSB.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            ACSB.checkMultiSelects(multiSelects);
            ACSB instance = ACSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = ACSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return ACSB.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return ACSB.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            ACSB.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.UPPER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(ACSB.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return ACSB.select(multiSelects).from(fromClause);
        }
    }

    @Deprecated
    public static class SCSB
    extends SQLBuilder {
        SCSB() {
            super(NamingPolicy.LOWER_CASE_WITH_UNDERSCORE, SQLPolicy.SQL);
        }

        static SCSB createInstance() {
            return new SCSB();
        }

        public static SQLBuilder parse(Condition cond, Class<?> entityClass) {
            N.checkArgNotNull(cond, "cond");
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).isForConditionOnly = true;
            instance.append(cond);
            return instance;
        }

        public static SQLBuilder insert(String expr) {
            return SCSB.insert(N.asArray(expr));
        }

        @SafeVarargs
        public static SQLBuilder insert(String ... columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder insert(Collection<String> columnNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder insert(Map<String, Object> props) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).props = props;
            return instance;
        }

        public static SQLBuilder insert(Object entity) {
            return SCSB.insert(entity, null);
        }

        public static SQLBuilder insert(Object entity, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entity.getClass();
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            SQLBuilder.parseInsertEntity((SQLBuilder)instance, entity, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insert(Class<?> entityClass) {
            return SCSB.insert(entityClass, null);
        }

        public static SQLBuilder insert(Class<?> entityClass, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = SCSB.getInsertPropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder insertInto(Class<?> entityClass) {
            return SCSB.insertInto(entityClass, null);
        }

        public static SQLBuilder insertInto(Class<?> entityClass, Set<String> excludedPropNames) {
            return SCSB.insert(entityClass, excludedPropNames).into(entityClass);
        }

        @Beta
        public static SQLBuilder batchInsert(Collection<?> propsList) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.ADD;
            u.Optional<?> first = N.firstNonNull(propsList);
            if (first.isPresent() && ClassUtil.isEntity(first.get().getClass())) {
                ((SQLBuilder)instance).entityClass = first.get().getClass();
                ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            }
            ((SQLBuilder)instance).propsList = SQLBuilder.toInsertPropsList(propsList);
            return instance;
        }

        public static SQLBuilder update(String tableName) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder update(Class<?> entityClass) {
            return SCSB.update(entityClass, null);
        }

        public static SQLBuilder update(Class<?> entityClass, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.UPDATE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = SCSB.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            ((SQLBuilder)instance).columnNames = SCSB.getUpdatePropNames(entityClass, excludedPropNames);
            return instance;
        }

        public static SQLBuilder deleteFrom(String tableName) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).tableName = tableName;
            return instance;
        }

        public static SQLBuilder deleteFrom(Class<?> entityClass) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.DELETE;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).tableName = SCSB.getTableName(entityClass, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
            return instance;
        }

        public static SQLBuilder select(String selectPart) {
            N.checkArgNotNullOrEmpty(selectPart, "selectPart");
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(selectPart);
            return instance;
        }

        @SafeVarargs
        public static SQLBuilder select(String ... columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = Array.asList(columnNames);
            return instance;
        }

        public static SQLBuilder select(Collection<String> columnNames) {
            N.checkArgNotNullOrEmpty(columnNames, "columnNames");
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnNames = columnNames;
            return instance;
        }

        public static SQLBuilder select(Map<String, String> columnAliases) {
            N.checkArgNotNullOrEmpty(columnAliases, "columnAliases");
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).columnAliases = columnAliases;
            return instance;
        }

        public static SQLBuilder select(Class<?> entityClass) {
            return SCSB.select(entityClass, false);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties) {
            return SCSB.select(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder select(Class<?> entityClass, Set<String> excludedPropNames) {
            return SCSB.select(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder select(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = entityClass;
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).columnNames = SCSB.getSelectPropNames(entityClass, includeSubEntityProperties, excludedPropNames);
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClass) {
            return SCSB.selectFrom(entityClass, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias) {
            return SCSB.selectFrom(entityClass, alias, false);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties) {
            return SCSB.selectFrom(entityClass, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties) {
            return SCSB.selectFrom(entityClass, alias, includeSubEntityProperties, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, Set<String> excludedPropNames) {
            return SCSB.selectFrom(entityClass, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, Set<String> excludedPropNames) {
            return SCSB.selectFrom(entityClass, alias, false, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            return SCSB.selectFrom(entityClass, null, includeSubEntityProperties, excludedPropNames);
        }

        public static SQLBuilder selectFrom(Class<?> entityClass, String alias, boolean includeSubEntityProperties, Set<String> excludedPropNames) {
            if (includeSubEntityProperties) {
                List selectTableNames = SQLBuilder.getSelectTableNames(entityClass, alias, excludedPropNames, NamingPolicy.LOWER_CASE_WITH_UNDERSCORE);
                return SCSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, selectTableNames);
            }
            return SCSB.select(entityClass, includeSubEntityProperties, excludedPropNames).from(entityClass, alias);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return SCSB.select(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder select(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return SCSB.select(multiSelects);
        }

        public static SQLBuilder select(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            SCSB.checkMultiSelects(multiSelects);
            SCSB instance = SCSB.createInstance();
            ((SQLBuilder)instance).op = OperationType.QUERY;
            ((SQLBuilder)instance).entityClass = (Class)multiSelects.get((int)0)._1;
            ((SQLBuilder)instance).propColumnNameMap = SCSB.getProp2ColumnNameMap(((SQLBuilder)instance).entityClass, ((SQLBuilder)instance).namingPolicy);
            ((SQLBuilder)instance).multiSelects = multiSelects;
            return instance;
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Class<?> entityClassB, String tableAliasB, String classAliasB) {
            return SCSB.selectFrom(entityClassA, tableAliasA, classAliasA, null, entityClassB, tableAliasB, classAliasB, null);
        }

        public static SQLBuilder selectFrom(Class<?> entityClassA, String tableAliasA, String classAliasA, Set<String> excludedPropNamesA, Class<?> entityClassB, String tableAliasB, String classAliasB, Set<String> excludedPropNamesB) {
            List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects = N.asList(Tuple.of(entityClassA, tableAliasA, classAliasA, excludedPropNamesA), Tuple.of(entityClassB, tableAliasB, classAliasB, excludedPropNamesB));
            return SCSB.selectFrom(multiSelects);
        }

        public static SQLBuilder selectFrom(List<Tuple.Tuple4<Class<?>, String, String, Set<String>>> multiSelects) {
            SCSB.checkMultiSelects(multiSelects);
            NamingPolicy namingPolicy = NamingPolicy.LOWER_CASE_WITH_UNDERSCORE;
            StringBuilder sb = Objectory.createStringBuilder();
            int idx = 0;
            for (Tuple.Tuple4<Class<?>, String, String, Set<String>> tp : multiSelects) {
                if (idx++ > 0) {
                    sb.append(_COMMA_SPACE);
                }
                sb.append(SCSB.getTableName((Class)tp._1, namingPolicy));
                if (!N.notNullOrEmpty((CharSequence)tp._2)) continue;
                sb.append(' ').append((String)tp._2);
            }
            String fromClause = sb.toString();
            Objectory.recycle(sb);
            return SCSB.select(multiSelects).from(fromClause);
        }
    }

    static enum SQLPolicy {
        SQL,
        PARAMETERIZED_SQL,
        NAMED_SQL,
        IBATIS_SQL;

    }
}

